/// <reference types="node" />
import { Socket } from 'net';
import * as packets from './packet';
declare class RCON {
    host: string;
    port: number;
    maxPacketSize: number;
    encoding: packets.EncodingOptions;
    timeout: number;
    connection: Socket;
    connected: boolean;
    authenticated: boolean;
    /**
     * Source RCON (https://developer.valvesoftware.com/wiki/Source_RCON)
     * @param options Connection options
     */
    constructor(options: RCONOptions);
    /**
     * Authenticates the connection
     * @param password Password string
     */
    authenticate(password: string): Promise<boolean>;
    /**
     * Executes command on the server
     * @param command Command to execute
     */
    execute(command: string): Promise<string | boolean>;
    /**
     * Creates a connection to the socket
     */
    private connect;
    /**
     * Destroys the socket connection
     */
    disconnect(): Promise<void>;
    isConnected(): boolean;
    isAuthenticated(): boolean;
    /**
     * Writes to socket connection
     * @param type Packet Type
     * @param id Packet ID
     * @param body Packet payload
     */
    private write;
}
interface RCONOptions {
    host?: string;
    port?: number;
    maxPacketSize?: number;
    encoding?: packets.EncodingOptions;
    timeout?: number;
}
export default RCON;
