/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "../node_modules/async-mutex/lib/Mutex.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__("../node_modules/tslib/tslib.es6.mjs");
var Semaphore_1 = __webpack_require__("../node_modules/async-mutex/lib/Semaphore.js");
var Mutex = /** @class */ (function () {
    function Mutex(cancelError) {
        this._semaphore = new Semaphore_1.default(1, cancelError);
    }
    Mutex.prototype.acquire = function () {
        return tslib_1.__awaiter(this, arguments, void 0, function (priority) {
            var _a, releaser;
            if (priority === void 0) { priority = 0; }
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this._semaphore.acquire(1, priority)];
                    case 1:
                        _a = _b.sent(), releaser = _a[1];
                        return [2 /*return*/, releaser];
                }
            });
        });
    };
    Mutex.prototype.runExclusive = function (callback, priority) {
        if (priority === void 0) { priority = 0; }
        return this._semaphore.runExclusive(function () { return callback(); }, 1, priority);
    };
    Mutex.prototype.isLocked = function () {
        return this._semaphore.isLocked();
    };
    Mutex.prototype.waitForUnlock = function (priority) {
        if (priority === void 0) { priority = 0; }
        return this._semaphore.waitForUnlock(1, priority);
    };
    Mutex.prototype.release = function () {
        if (this._semaphore.isLocked())
            this._semaphore.release();
    };
    Mutex.prototype.cancel = function () {
        return this._semaphore.cancel();
    };
    return Mutex;
}());
exports["default"] = Mutex;


/***/ }),

/***/ "../node_modules/async-mutex/lib/Semaphore.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__("../node_modules/tslib/tslib.es6.mjs");
var errors_1 = __webpack_require__("../node_modules/async-mutex/lib/errors.js");
var Semaphore = /** @class */ (function () {
    function Semaphore(_value, _cancelError) {
        if (_cancelError === void 0) { _cancelError = errors_1.E_CANCELED; }
        this._value = _value;
        this._cancelError = _cancelError;
        this._queue = [];
        this._weightedWaiters = [];
    }
    Semaphore.prototype.acquire = function (weight, priority) {
        var _this = this;
        if (weight === void 0) { weight = 1; }
        if (priority === void 0) { priority = 0; }
        if (weight <= 0)
            throw new Error("invalid weight ".concat(weight, ": must be positive"));
        return new Promise(function (resolve, reject) {
            var task = { resolve: resolve, reject: reject, weight: weight, priority: priority };
            var i = findIndexFromEnd(_this._queue, function (other) { return priority <= other.priority; });
            if (i === -1 && weight <= _this._value) {
                // Needs immediate dispatch, skip the queue
                _this._dispatchItem(task);
            }
            else {
                _this._queue.splice(i + 1, 0, task);
            }
        });
    };
    Semaphore.prototype.runExclusive = function (callback_1) {
        return tslib_1.__awaiter(this, arguments, void 0, function (callback, weight, priority) {
            var _a, value, release;
            if (weight === void 0) { weight = 1; }
            if (priority === void 0) { priority = 0; }
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.acquire(weight, priority)];
                    case 1:
                        _a = _b.sent(), value = _a[0], release = _a[1];
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, , 4, 5]);
                        return [4 /*yield*/, callback(value)];
                    case 3: return [2 /*return*/, _b.sent()];
                    case 4:
                        release();
                        return [7 /*endfinally*/];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    Semaphore.prototype.waitForUnlock = function (weight, priority) {
        var _this = this;
        if (weight === void 0) { weight = 1; }
        if (priority === void 0) { priority = 0; }
        if (weight <= 0)
            throw new Error("invalid weight ".concat(weight, ": must be positive"));
        if (this._couldLockImmediately(weight, priority)) {
            return Promise.resolve();
        }
        else {
            return new Promise(function (resolve) {
                if (!_this._weightedWaiters[weight - 1])
                    _this._weightedWaiters[weight - 1] = [];
                insertSorted(_this._weightedWaiters[weight - 1], { resolve: resolve, priority: priority });
            });
        }
    };
    Semaphore.prototype.isLocked = function () {
        return this._value <= 0;
    };
    Semaphore.prototype.getValue = function () {
        return this._value;
    };
    Semaphore.prototype.setValue = function (value) {
        this._value = value;
        this._dispatchQueue();
    };
    Semaphore.prototype.release = function (weight) {
        if (weight === void 0) { weight = 1; }
        if (weight <= 0)
            throw new Error("invalid weight ".concat(weight, ": must be positive"));
        this._value += weight;
        this._dispatchQueue();
    };
    Semaphore.prototype.cancel = function () {
        var _this = this;
        this._queue.forEach(function (entry) { return entry.reject(_this._cancelError); });
        this._queue = [];
    };
    Semaphore.prototype._dispatchQueue = function () {
        this._drainUnlockWaiters();
        while (this._queue.length > 0 && this._queue[0].weight <= this._value) {
            this._dispatchItem(this._queue.shift());
            this._drainUnlockWaiters();
        }
    };
    Semaphore.prototype._dispatchItem = function (item) {
        var previousValue = this._value;
        this._value -= item.weight;
        item.resolve([previousValue, this._newReleaser(item.weight)]);
    };
    Semaphore.prototype._newReleaser = function (weight) {
        var _this = this;
        var called = false;
        return function () {
            if (called)
                return;
            called = true;
            _this.release(weight);
        };
    };
    Semaphore.prototype._drainUnlockWaiters = function () {
        if (this._queue.length === 0) {
            for (var weight = this._value; weight > 0; weight--) {
                var waiters = this._weightedWaiters[weight - 1];
                if (!waiters)
                    continue;
                waiters.forEach(function (waiter) { return waiter.resolve(); });
                this._weightedWaiters[weight - 1] = [];
            }
        }
        else {
            var queuedPriority_1 = this._queue[0].priority;
            for (var weight = this._value; weight > 0; weight--) {
                var waiters = this._weightedWaiters[weight - 1];
                if (!waiters)
                    continue;
                var i = waiters.findIndex(function (waiter) { return waiter.priority <= queuedPriority_1; });
                (i === -1 ? waiters : waiters.splice(0, i))
                    .forEach((function (waiter) { return waiter.resolve(); }));
            }
        }
    };
    Semaphore.prototype._couldLockImmediately = function (weight, priority) {
        return (this._queue.length === 0 || this._queue[0].priority < priority) &&
            weight <= this._value;
    };
    return Semaphore;
}());
function insertSorted(a, v) {
    var i = findIndexFromEnd(a, function (other) { return v.priority <= other.priority; });
    a.splice(i + 1, 0, v);
}
function findIndexFromEnd(a, predicate) {
    for (var i = a.length - 1; i >= 0; i--) {
        if (predicate(a[i])) {
            return i;
        }
    }
    return -1;
}
exports["default"] = Semaphore;


/***/ }),

/***/ "../node_modules/async-mutex/lib/errors.js":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.E_CANCELED = exports.E_ALREADY_LOCKED = exports.E_TIMEOUT = void 0;
exports.E_TIMEOUT = new Error('timeout while waiting for mutex to become available');
exports.E_ALREADY_LOCKED = new Error('mutex already locked');
exports.E_CANCELED = new Error('request for lock canceled');


/***/ }),

/***/ "../node_modules/async-mutex/lib/index.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.tryAcquire = exports.withTimeout = exports.Semaphore = exports.Mutex = void 0;
var tslib_1 = __webpack_require__("../node_modules/tslib/tslib.es6.mjs");
var Mutex_1 = __webpack_require__("../node_modules/async-mutex/lib/Mutex.js");
Object.defineProperty(exports, "Mutex", ({ enumerable: true, get: function () { return Mutex_1.default; } }));
var Semaphore_1 = __webpack_require__("../node_modules/async-mutex/lib/Semaphore.js");
Object.defineProperty(exports, "Semaphore", ({ enumerable: true, get: function () { return Semaphore_1.default; } }));
var withTimeout_1 = __webpack_require__("../node_modules/async-mutex/lib/withTimeout.js");
Object.defineProperty(exports, "withTimeout", ({ enumerable: true, get: function () { return withTimeout_1.withTimeout; } }));
var tryAcquire_1 = __webpack_require__("../node_modules/async-mutex/lib/tryAcquire.js");
Object.defineProperty(exports, "tryAcquire", ({ enumerable: true, get: function () { return tryAcquire_1.tryAcquire; } }));
tslib_1.__exportStar(__webpack_require__("../node_modules/async-mutex/lib/errors.js"), exports);


/***/ }),

/***/ "../node_modules/async-mutex/lib/tryAcquire.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.tryAcquire = void 0;
var errors_1 = __webpack_require__("../node_modules/async-mutex/lib/errors.js");
var withTimeout_1 = __webpack_require__("../node_modules/async-mutex/lib/withTimeout.js");
// eslint-disable-next-lisne @typescript-eslint/explicit-module-boundary-types
function tryAcquire(sync, alreadyAcquiredError) {
    if (alreadyAcquiredError === void 0) { alreadyAcquiredError = errors_1.E_ALREADY_LOCKED; }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return (0, withTimeout_1.withTimeout)(sync, 0, alreadyAcquiredError);
}
exports.tryAcquire = tryAcquire;


/***/ }),

/***/ "../node_modules/async-mutex/lib/withTimeout.js":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.withTimeout = void 0;
var tslib_1 = __webpack_require__("../node_modules/tslib/tslib.es6.mjs");
/* eslint-disable @typescript-eslint/no-explicit-any */
var errors_1 = __webpack_require__("../node_modules/async-mutex/lib/errors.js");
function withTimeout(sync, timeout, timeoutError) {
    var _this = this;
    if (timeoutError === void 0) { timeoutError = errors_1.E_TIMEOUT; }
    return {
        acquire: function (weightOrPriority, priority) {
            var weight;
            if (isSemaphore(sync)) {
                weight = weightOrPriority;
            }
            else {
                weight = undefined;
                priority = weightOrPriority;
            }
            if (weight !== undefined && weight <= 0) {
                throw new Error("invalid weight ".concat(weight, ": must be positive"));
            }
            return new Promise(function (resolve, reject) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                var isTimeout, handle, ticket, release, e_1;
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            isTimeout = false;
                            handle = setTimeout(function () {
                                isTimeout = true;
                                reject(timeoutError);
                            }, timeout);
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 4]);
                            return [4 /*yield*/, (isSemaphore(sync)
                                    ? sync.acquire(weight, priority)
                                    : sync.acquire(priority))];
                        case 2:
                            ticket = _a.sent();
                            if (isTimeout) {
                                release = Array.isArray(ticket) ? ticket[1] : ticket;
                                release();
                            }
                            else {
                                clearTimeout(handle);
                                resolve(ticket);
                            }
                            return [3 /*break*/, 4];
                        case 3:
                            e_1 = _a.sent();
                            if (!isTimeout) {
                                clearTimeout(handle);
                                reject(e_1);
                            }
                            return [3 /*break*/, 4];
                        case 4: return [2 /*return*/];
                    }
                });
            }); });
        },
        runExclusive: function (callback, weight, priority) {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var release, ticket;
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            release = function () { return undefined; };
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, , 7, 8]);
                            return [4 /*yield*/, this.acquire(weight, priority)];
                        case 2:
                            ticket = _a.sent();
                            if (!Array.isArray(ticket)) return [3 /*break*/, 4];
                            release = ticket[1];
                            return [4 /*yield*/, callback(ticket[0])];
                        case 3: return [2 /*return*/, _a.sent()];
                        case 4:
                            release = ticket;
                            return [4 /*yield*/, callback()];
                        case 5: return [2 /*return*/, _a.sent()];
                        case 6: return [3 /*break*/, 8];
                        case 7:
                            release();
                            return [7 /*endfinally*/];
                        case 8: return [2 /*return*/];
                    }
                });
            });
        },
        release: function (weight) {
            sync.release(weight);
        },
        cancel: function () {
            return sync.cancel();
        },
        waitForUnlock: function (weightOrPriority, priority) {
            var weight;
            if (isSemaphore(sync)) {
                weight = weightOrPriority;
            }
            else {
                weight = undefined;
                priority = weightOrPriority;
            }
            if (weight !== undefined && weight <= 0) {
                throw new Error("invalid weight ".concat(weight, ": must be positive"));
            }
            return new Promise(function (resolve, reject) {
                var handle = setTimeout(function () { return reject(timeoutError); }, timeout);
                (isSemaphore(sync)
                    ? sync.waitForUnlock(weight, priority)
                    : sync.waitForUnlock(priority)).then(function () {
                    clearTimeout(handle);
                    resolve();
                });
            });
        },
        isLocked: function () { return sync.isLocked(); },
        getValue: function () { return sync.getValue(); },
        setValue: function (value) { return sync.setValue(value); },
    };
}
exports.withTimeout = withTimeout;
function isSemaphore(sync) {
    return sync.getValue !== undefined;
}


/***/ }),

/***/ "../daemon/src/common/compress.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.decompress = exports.compress = void 0;
const child_process_1 = __webpack_require__("child_process");
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const i18next_1 = __webpack_require__("i18next");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const path_1 = __importDefault(__webpack_require__("path"));
const util_1 = __webpack_require__("util");
const const_1 = __webpack_require__("../daemon/src/const.ts");
const i18n_1 = __webpack_require__("../daemon/src/i18n/index.ts");
const log_1 = __importDefault(__webpack_require__("../daemon/src/service/log.ts"));
const seven_zip_service_1 = __webpack_require__("../daemon/src/service/seven_zip_service.ts");
const execPromise = (0, util_1.promisify)(child_process_1.exec);
const COMPRESS_ERROR_MSG = {
    invalidName: (0, i18next_1.t)("TXT_CODE_3aa9f36"),
    exitErr: (0, i18next_1.t)("TXT_CODE_2be83d36"),
    startErr: (0, i18next_1.t)("TXT_CODE_37d839a4"),
    timeoutErr: (0, i18next_1.t)("TXT_CODE_15c07350")
};
function checkFileName(fileName) {
    const disableList = ['"', "'", "?", "|", "&"];
    for (const iterator of disableList) {
        if (fileName.includes(iterator))
            return false;
    }
    return true;
}
async function compress(sourceZip, files, fileCode) {
    if (!checkFileName(sourceZip) || files.some((v) => !checkFileName(v)))
        throw new Error(COMPRESS_ERROR_MSG.invalidName);
    return await useZip(sourceZip, files, fileCode);
}
exports.compress = compress;
async function decompress(zipPath, dest, fileCode) {
    if (!checkFileName(zipPath) || !checkFileName(dest))
        throw new Error(COMPRESS_ERROR_MSG.invalidName);
    const tryUnzip = async () => {
        if (!(0, seven_zip_service_1.isZipFormat)(zipPath)) {
            const fileExt = (0, seven_zip_service_1.getFileExtension)(zipPath);
            throw new Error((0, i18n_1.$t)("TXT_CODE_69c42450", { fileExt: fileExt }));
        }
        if ((0, seven_zip_service_1.isMultiVolume)(zipPath)) {
            throw new Error((0, i18n_1.$t)("TXT_CODE_91d066aa"));
        }
        try {
            return await useUnzip(zipPath, dest, fileCode || "utf-8");
        }
        catch (error) {
            log_1.default.error((0, i18n_1.$t)("TXT_CODE_842929d0", { message: error.message }));
            throw new Error((0, i18n_1.$t)("TXT_CODE_f0512848", {
                message: error === null || error === void 0 ? void 0 : error.message
            }));
        }
    };
    if (!(0, seven_zip_service_1.check7zipStatus)()) {
        try {
            return await use7zip(zipPath, dest);
        }
        catch (error) {
            // if 7zip is not working, try to use unzip
            return await tryUnzip();
        }
    }
    else {
        return await tryUnzip();
    }
}
exports.decompress = decompress;
/**
 * Decompress using 7zip
 */
async function use7zip(sourceZip, destDir) {
    var _a;
    try {
        const sourceDir = path_1.default.dirname(sourceZip);
        const normalizedDest = path_1.default.normalize(destDir);
        const normalizedSource = path_1.default.normalize(sourceDir);
        let command;
        let workingDir;
        await fs_extra_1.default.ensureDir(destDir);
        command = `"${const_1.SEVEN_ZIP_PATH}" x "${sourceZip}" "-o${destDir}" -aoa`;
        workingDir = sourceDir;
        log_1.default.info((0, i18n_1.$t)("TXT_CODE_35d2ee7a", { command }));
        const { stdout, stderr } = await execPromise(command, {
            cwd: workingDir,
            timeout: const_1.ZIP_TIMEOUT_SECONDS * 1000
        });
        const hasErrors = stdout.includes("ERRORS:") ||
            stdout.includes("ERROR:") ||
            stdout.includes("Open Errors:") ||
            stdout.includes("Missing volume") ||
            stdout.includes("Data Error") ||
            stdout.includes("Archives with Errors:");
        if (hasErrors) {
            const errorLines = stdout
                .split("\n")
                .filter((line) => line.includes("ERROR") ||
                line.includes("Missing volume") ||
                line.includes("Data Error") ||
                line.includes("Open Errors") ||
                line.includes("Archives with Errors"));
            let cleanErrorMsg;
            if (stdout.includes("Missing volume")) {
                const volumeMatch = stdout.match(/Missing volume\s*:\s*([^\s\n]+)/);
                if (volumeMatch) {
                    cleanErrorMsg = (0, i18n_1.$t)("TXT_CODE_c0401ba7", { file: volumeMatch[1] });
                }
                else {
                    cleanErrorMsg = (0, i18n_1.$t)("TXT_CODE_908a4ace");
                }
            }
            else if (stdout.includes("Data Error")) {
                cleanErrorMsg = (0, i18n_1.$t)("TXT_CODE_b1ef1d4a");
            }
            else if (stdout.includes("Open Errors")) {
                cleanErrorMsg = (0, i18n_1.$t)("TXT_CODE_5778848e");
            }
            else {
                const firstError = ((_a = errorLines[0]) === null || _a === void 0 ? void 0 : _a.trim()) || (0, i18n_1.$t)("TXT_CODE_11ecd5a9");
                cleanErrorMsg = firstError.length > 100 ? firstError.substring(0, 100) + "..." : firstError;
            }
            log_1.default.error((0, i18n_1.$t)("TXT_CODE_cacd8840", { message: cleanErrorMsg }));
            throw new Error((0, i18n_1.$t)("TXT_CODE_ec7fc405", { message: cleanErrorMsg }));
        }
        if (stderr && stderr.trim()) {
            log_1.default.warn((0, i18n_1.$t)("TXT_CODE_8a9c6364", { warning: stderr }));
        }
        if (stdout.includes("Everything is Ok")) {
            log_1.default.info((0, i18n_1.$t)("TXT_CODE_e96a91cd"));
        }
        else {
            const resultLines = stdout
                .split("\n")
                .filter((line) => line.trim())
                .slice(-3);
            log_1.default.info((0, i18n_1.$t)("TXT_CODE_143db7d9", { result: resultLines.join("; ") }));
        }
        return true;
    }
    catch (error) {
        let simpleErrorMsg;
        if (error.message.includes("Missing volume")) {
            const volumeMatch = error.message.match(/Missing volume\s*:\s*([^\s\n]+)/);
            simpleErrorMsg = volumeMatch
                ? (0, i18n_1.$t)("TXT_CODE_c0401ba7", { file: volumeMatch[1] })
                : (0, i18n_1.$t)("TXT_CODE_908a4ace");
        }
        else if (error.message.includes("timeout")) {
            simpleErrorMsg = (0, i18n_1.$t)("TXT_CODE_1d1ec400");
        }
        else if (error.message.includes("ENOENT")) {
            simpleErrorMsg = (0, i18n_1.$t)("TXT_CODE_a0ede210");
        }
        else if (error.message.includes("Command failed")) {
            simpleErrorMsg = (0, i18n_1.$t)("TXT_CODE_4fb3fad1");
        }
        else {
            simpleErrorMsg = (0, i18n_1.$t)("TXT_CODE_f460677f");
        }
        log_1.default.error((0, i18n_1.$t)("TXT_CODE_1b688710", {
            message: simpleErrorMsg,
            details: error.message.substring(0, 200)
        }));
        throw new Error((0, i18n_1.$t)("TXT_CODE_ec7fc405", { message: simpleErrorMsg }));
    }
}
// ./file-zip -mode 2 --zipPath aaa.zip --DistDirPath 123412124 --code GBK
async function useUnzip(sourceZip, destDir, code = "utf-8") {
    const params = [
        "--mode=2",
        `--zipPath=${path_1.default.basename(sourceZip)}`,
        `--distDirPath=${path_1.default.normalize(destDir)}`,
        `--code=${code}`
    ];
    log_1.default.info(`Function useUnzip(): Command: ${const_1.GOLANG_ZIP_PATH} ${params.join(" ")}`);
    const subProcess = new mcsmanager_common_1.ProcessWrapper(const_1.GOLANG_ZIP_PATH, params, path_1.default.dirname(sourceZip), const_1.ZIP_TIMEOUT_SECONDS, code);
    subProcess.setErrMsg(COMPRESS_ERROR_MSG);
    return subProcess.start();
}
// ./file-zip -mode 1 --file main.go --file file-zip --file 123 --file README.md --zipPath aaabb.zip
async function useZip(distZip, files, code = "utf-8") {
    if (!files || files.length == 0)
        throw new Error((0, i18next_1.t)("TXT_CODE_2038ec2c"));
    const params = ["--mode=1", `--code=${code}`, `--zipPath=${path_1.default.basename(distZip)}`];
    files.forEach((v) => {
        params.push(`--file=${path_1.default.basename(v)}`);
    });
    log_1.default.info(`Function useZip(): Command: ${const_1.GOLANG_ZIP_PATH} ${params.join(" ")}, CWD: ${path_1.default.dirname(distZip)}`);
    const subProcess = new mcsmanager_common_1.ProcessWrapper(const_1.GOLANG_ZIP_PATH, params, path_1.default.dirname(distZip), const_1.ZIP_TIMEOUT_SECONDS, code);
    subProcess.setErrMsg(COMPRESS_ERROR_MSG);
    return subProcess.start();
}


/***/ }),

/***/ "../daemon/src/common/system_storage.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
exports["default"] = new mcsmanager_common_1.StorageSubsystem();


/***/ }),

/***/ "../daemon/src/const.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ZIP_TIMEOUT_SECONDS = exports.WINDOWS_STEAM_CMD_URL = exports.SYSTEM_TYPE = exports.STEAM_CMD_PATH = exports.SEVEN_ZIP_PATH = exports.SEVEN_ZIP_NAME = exports.PTY_PATH = exports.LOCAL_PRESET_LANG_PATH = exports.IGNORE = exports.GOLANG_ZIP_PATH = exports.FRPC_PATH = exports.FILENAME_BLACKLIST = void 0;
const os_1 = __importDefault(__webpack_require__("os"));
const path_1 = __importDefault(__webpack_require__("path"));
function loadSteamCmdPath() {
    let targetPath = path_1.default.normalize(path_1.default.join(process.cwd(), "lib", os_1.default.platform() === "win32" ? "steamcmd.exe" : `steamcmd_${os_1.default.arch()}`));
    return targetPath;
}
const SYS_INFO = `${os_1.default.platform()}_${os_1.default.arch()}${os_1.default.platform() === "win32" ? ".exe" : ""}`;
const ptyName = `pty_${SYS_INFO}`;
const frpcName = `frpc_${SYS_INFO}`;
const PTY_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "lib", ptyName));
exports.PTY_PATH = PTY_PATH;
const FRPC_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "lib", frpcName));
exports.FRPC_PATH = FRPC_PATH;
const FILENAME_BLACKLIST = ["\\", "/", ".", "'", '"', "?", "*", "<", ">"];
exports.FILENAME_BLACKLIST = FILENAME_BLACKLIST;
const LOCAL_PRESET_LANG_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "language"));
exports.LOCAL_PRESET_LANG_PATH = LOCAL_PRESET_LANG_PATH;
const IGNORE = "[IGNORE_LOG]";
exports.IGNORE = IGNORE;
const SYSTEM_TYPE = os_1.default.platform();
exports.SYSTEM_TYPE = SYSTEM_TYPE;
const ZIP_TIMEOUT_SECONDS = 60 * 40;
exports.ZIP_TIMEOUT_SECONDS = ZIP_TIMEOUT_SECONDS;
const GOLANG_ZIP_NAME = `file_zip_${SYSTEM_TYPE}_${os_1.default.arch()}${SYSTEM_TYPE === "win32" ? ".exe" : ""}`;
const GOLANG_ZIP_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "lib", GOLANG_ZIP_NAME));
exports.GOLANG_ZIP_PATH = GOLANG_ZIP_PATH;
const STEAM_CMD_PATH = loadSteamCmdPath();
exports.STEAM_CMD_PATH = STEAM_CMD_PATH;
const WINDOWS_STEAM_CMD_URL = "https://steamcdn-a.akamaihd.net/client/installer/steamcmd.zip";
exports.WINDOWS_STEAM_CMD_URL = WINDOWS_STEAM_CMD_URL;
const SEVEN_ZIP_NAME = `7z_${os_1.default.platform()}_${os_1.default.arch()}${os_1.default.platform() === "win32" ? ".exe" : ""}`;
exports.SEVEN_ZIP_NAME = SEVEN_ZIP_NAME;
const SEVEN_ZIP_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "lib", SEVEN_ZIP_NAME));
exports.SEVEN_ZIP_PATH = SEVEN_ZIP_PATH;


/***/ }),

/***/ "../daemon/src/entity/config.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.globalEnv = exports.globalConfiguration = exports.Config = void 0;
const uuid_1 = __webpack_require__("uuid");
const system_storage_1 = __importDefault(__webpack_require__("../daemon/src/common/system_storage.ts"));
function builderPassword() {
    const a = `${(0, uuid_1.v4)().replace(/\-/gim, "")}`;
    const b = a.slice(0, a.length / 2 - 1);
    const c = `${(0, uuid_1.v4)().replace(/\-/gim, "")}`;
    return b + c;
}
// @Entity
class Config {
    constructor() {
        this.version = 2;
        this.ip = "";
        this.port = 24444;
        this.prefix = "";
        this.key = builderPassword();
        this.maxFileTask = 2;
        this.maxZipFileSize = 200;
        this.language = "en_us";
        this.defaultInstancePath = "";
        this.allocatablePortRange = [10010, 65500];
        this.currentAllocatablePort = 10010;
        this.portAssignInterval = 5;
        // default: Unlimited, if set 40 => (40 packets * 64KB)/s => 2.5MB/s
        this.uploadSpeedRate = 0;
        // default: Unlimited, if set 32 => (32 packets * 64KB)/s => 2MB/s
        this.downloadSpeedRate = 0;
        this.ssl = false;
        this.sslPemPath = "";
        this.sslKeyPath = "";
    }
}
exports.Config = Config;
// daemon configuration class
class GlobalConfiguration {
    constructor() {
        this.config = new Config();
    }
    load() {
        let config = system_storage_1.default.load("Config", Config, GlobalConfiguration.ID);
        if (config == null) {
            config = new Config();
            system_storage_1.default.store("Config", GlobalConfiguration.ID, config);
        }
        this.config = config;
    }
    store() {
        system_storage_1.default.store("Config", GlobalConfiguration.ID, this.config);
    }
}
GlobalConfiguration.ID = "global";
class GlobalEnv {
    constructor() {
        this.fileTaskCount = 0;
    }
}
const globalConfiguration = new GlobalConfiguration();
exports.globalConfiguration = globalConfiguration;
const globalEnv = new GlobalEnv();
exports.globalEnv = globalEnv;


/***/ }),

/***/ "../daemon/src/i18n/index.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// I18n init configuration (Daemon)
// If you want to add the language of your own country, you need to add the code here.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.i18next = exports.$t = void 0;
const i18next_1 = __importDefault(__webpack_require__("i18next"));
exports.i18next = i18next_1.default;
const zh_CN_json_1 = __importDefault(__webpack_require__("../languages/zh_CN.json"));
const en_US_json_1 = __importDefault(__webpack_require__("../languages/en_US.json"));
const zh_TW_json_1 = __importDefault(__webpack_require__("../languages/zh_TW.json"));
const ja_JP_json_1 = __importDefault(__webpack_require__("../languages/ja_JP.json"));
const es_ES_json_1 = __importDefault(__webpack_require__("../languages/es_ES.json"));
const fr_FR_json_1 = __importDefault(__webpack_require__("../languages/fr_FR.json"));
const ru_RU_json_1 = __importDefault(__webpack_require__("../languages/ru_RU.json"));
const ko_KR_json_1 = __importDefault(__webpack_require__("../languages/ko_KR.json"));
const de_DE_json_1 = __importDefault(__webpack_require__("../languages/de_DE.json"));
const pt_BR_json_1 = __importDefault(__webpack_require__("../languages/pt_BR.json"));
const th_TH_json_1 = __importDefault(__webpack_require__("../languages/th_TH.json"));
i18next_1.default.init({
    interpolation: {
        escapeValue: false
    },
    lng: "en_us",
    fallbackLng: "en_us",
    resources: {
        en_us: {
            translation: en_US_json_1.default
        },
        zh_cn: {
            translation: zh_CN_json_1.default
        },
        zh_tw: {
            translation: zh_TW_json_1.default
        },
        ja_jp: {
            translation: ja_JP_json_1.default
        },
        es_es: {
            translation: es_ES_json_1.default
        },
        fr_fr: {
            translation: fr_FR_json_1.default
        },
        ru_ru: {
            translation: ru_RU_json_1.default
        },
        ko_kr: {
            translation: ko_KR_json_1.default
        },
        de_de: {
            translation: de_DE_json_1.default
        },
        pt_br: {
            translation: pt_BR_json_1.default
        },
        th_th: {
            translation: th_TH_json_1.default
        }
    }
});
// alias
const $t = i18next_1.default.t;
exports.$t = $t;


/***/ }),

/***/ "../daemon/src/service/log.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const log4js = __importStar(__webpack_require__("log4js"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const i18n_1 = __webpack_require__("../daemon/src/i18n/index.ts");
const LOG_FILE_PATH = "logs/current.log";
const LOG_SYS_INFO_FILE_PATH = "logs/sysinfo.log";
const time = new Date();
const timeString = `${time.getFullYear()}-${time.getMonth() + 1}-${time.getDate()}` +
    `_${time.getHours()}-${time.getMinutes()}-${time.getSeconds()}`;
if (fs_extra_1.default.existsSync(LOG_FILE_PATH)) {
    fs_extra_1.default.renameSync(LOG_FILE_PATH, `logs/${timeString}.log`);
}
if (fs_extra_1.default.existsSync(LOG_SYS_INFO_FILE_PATH)) {
    fs_extra_1.default.renameSync(LOG_SYS_INFO_FILE_PATH, `logs/sysinfo_${timeString}.log`);
}
log4js.configure({
    appenders: {
        out: {
            type: "stdout",
            layout: {
                type: "pattern",
                pattern: "[%d{MM/dd hh:mm:ss}] [%[%p%]] %m"
            }
        },
        app: {
            type: "file",
            filename: LOG_FILE_PATH,
            layout: {
                type: "pattern",
                pattern: "[%d{MM/dd hh:mm:ss}] [%p] %m"
            }
        },
        sys: {
            type: "file",
            filename: LOG_SYS_INFO_FILE_PATH,
            layout: {
                type: "pattern",
                pattern: "[%d{MM/dd hh:mm:ss}] [%p] %m"
            }
        }
    },
    categories: {
        default: {
            appenders: ["out", "app"],
            level: "info"
        },
        sysinfo: {
            appenders: ["sys"],
            level: "info"
        }
    }
});
const logger = log4js.getLogger("default");
const loggerSysInfo = log4js.getLogger("sysinfo");
function toInt(v) {
    return parseInt(String(v));
}
function systemInfoReport() {
    const MB_SIZE = 1024 * 1024;
    const info = (0, mcsmanager_common_1.systemInfo)();
    const self = process.memoryUsage();
    const sysInfo = `MEM: ${toInt((info.totalmem - info.freemem) / MB_SIZE)}MB/${toInt(info.totalmem / MB_SIZE)}MB` + ` CPU: ${toInt(info.cpuUsage * 100)}%`;
    const selfInfo = `Heap: ${toInt(self.heapUsed / MB_SIZE)}MB/${toInt(self.heapTotal / MB_SIZE)}MB`;
    const selfInfo2 = `RSS: ${toInt(self.rss / MB_SIZE)}MB`;
    const logTip = (0, i18n_1.$t)("TXT_CODE_app.sysinfo");
    loggerSysInfo.info([`[${logTip}]`, sysInfo, selfInfo, selfInfo2].join(" "));
}
setInterval(systemInfoReport, 1000 * 5);
exports["default"] = logger;


/***/ }),

/***/ "../daemon/src/service/seven_zip_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.check7zipStatus = exports.getFileExtension = exports.isMultiVolume = exports.isZipFormat = void 0;
const child_process_1 = __webpack_require__("child_process");
const fs_1 = __webpack_require__("fs");
const promises_1 = __importDefault(__webpack_require__("fs/promises"));
const path_1 = __importDefault(__webpack_require__("path"));
const util_1 = __webpack_require__("util");
const const_1 = __webpack_require__("../daemon/src/const.ts");
const i18n_1 = __webpack_require__("../daemon/src/i18n/index.ts");
const log_1 = __importDefault(__webpack_require__("../daemon/src/service/log.ts"));
const execPromise = (0, util_1.promisify)(child_process_1.exec);
/**
 * Check if the file is in zip format (only supports .zip extension)
 */
function isZipFormat(filePath) {
    const ext = path_1.default.extname(filePath).toLowerCase();
    return ext === ".zip";
}
exports.isZipFormat = isZipFormat;
/**
 * Check if it's a multi-volume archive (supports ZIP, 7z, RAR formats)
 * ZIP multi-volume naming: archive.zip, archive.z01, archive.z02, etc.
 * 7z multi-volume naming: archive.7z.001, archive.7z.002, etc.
 * RAR multi-volume naming: archive.part1.rar, archive.part2.rar or archive.rar, archive.r00, archive.r01, etc.
 */
function isMultiVolume(filePath) {
    const dir = path_1.default.dirname(filePath);
    const fullName = path_1.default.basename(filePath);
    const ext = path_1.default.extname(filePath).toLowerCase();
    if (ext === ".zip") {
        const baseName = path_1.default.basename(filePath, ".zip");
        const firstVolumeFile = path_1.default.join(dir, baseName + ".z01");
        return (0, fs_1.existsSync)(firstVolumeFile);
    }
    if (ext === ".7z") {
        const baseName = path_1.default.basename(filePath, ".7z");
        const firstVolumeFile = path_1.default.join(dir, baseName + ".7z.001");
        return (0, fs_1.existsSync)(firstVolumeFile);
    }
    if (ext === ".rar") {
        const baseName = path_1.default.basename(filePath, ".rar");
        if (fullName.includes(".part1.rar")) {
            const partBaseName = fullName.replace(".part1.rar", "");
            const secondPartFile = path_1.default.join(dir, partBaseName + ".part2.rar");
            return (0, fs_1.existsSync)(secondPartFile);
        }
        const firstVolumeFile = path_1.default.join(dir, baseName + ".r00");
        return (0, fs_1.existsSync)(firstVolumeFile);
    }
    return false;
}
exports.isMultiVolume = isMultiVolume;
/**
 * Get file extension for error messages
 */
function getFileExtension(filePath) {
    return path_1.default.extname(filePath).toLowerCase().substring(1) || "unknown";
}
exports.getFileExtension = getFileExtension;
let isChecked7zip = false;
/**
 * Check if 7zip is working properly
 */
async function check7zipStatus() {
    try {
        if (isChecked7zip)
            return true;
        if (!(0, fs_1.existsSync)(const_1.SEVEN_ZIP_PATH))
            return false;
        try {
            await promises_1.default.chmod(const_1.SEVEN_ZIP_PATH, 0o755);
        }
        catch (chmodError) {
            log_1.default.warn((0, i18n_1.$t)("TXT_CODE_9ade0fb8", { message: chmodError.message }));
        }
        const { stdout } = await execPromise(`"${const_1.SEVEN_ZIP_PATH}" i`, {
            timeout: 5 * 1000
        });
        if (stdout.includes("7-Zip") && stdout.includes("Copyright")) {
            log_1.default.info((0, i18n_1.$t)("TXT_CODE_a7c73a51", { info: stdout.split("\n")[1].trim() }));
            isChecked7zip = true;
            return true;
        }
        return false;
    }
    catch (error) {
        // ignore error
        return false;
    }
}
exports.check7zipStatus = check7zipStatus;


/***/ }),

/***/ "../daemon/src/service/system_file.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const iconv_lite_1 = __importDefault(__webpack_require__("iconv-lite"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const os_1 = __importDefault(__webpack_require__("os"));
const path_1 = __importDefault(__webpack_require__("path"));
const compress_1 = __webpack_require__("../daemon/src/common/compress.ts");
const config_1 = __webpack_require__("../daemon/src/entity/config.ts");
const i18n_1 = __webpack_require__("../daemon/src/i18n/index.ts");
const filepath_1 = __webpack_require__("../daemon/src/tools/filepath.ts");
const ERROR_MSG_01 = (0, i18n_1.$t)("TXT_CODE_system_file.illegalAccess");
const MAX_EDIT_SIZE = 1024 * 1024 * 5;
class FileManager {
    constructor(topPath = "", fileCode) {
        this.topPath = topPath;
        this.fileCode = fileCode;
        this.cwd = ".";
        if (!path_1.default.isAbsolute(topPath)) {
            this.topPath = path_1.default.normalize(path_1.default.join(process.cwd(), topPath));
        }
        else {
            this.topPath = path_1.default.normalize(topPath);
        }
        if (!fileCode) {
            this.fileCode = "utf-8";
            if (i18n_1.i18next.language == "zh_cn")
                this.fileCode = "gbk";
        }
    }
    isRootTopRath() {
        return this.topPath === "/" || this.topPath === "\\";
    }
    toAbsolutePath(fileName = "") {
        const topAbsolutePath = this.topPath;
        if (path_1.default.normalize(fileName).indexOf(topAbsolutePath) === 0)
            return fileName;
        let finalPath = "";
        if (os_1.default.platform() === "win32") {
            const reg = new RegExp("^[A-Za-z]{1}:[\\\\/]{1}");
            if (reg.test(this.cwd)) {
                finalPath = path_1.default.normalize(path_1.default.join(this.cwd, fileName));
            }
            else if (reg.test(fileName)) {
                finalPath = path_1.default.normalize(fileName);
            }
        }
        if (!finalPath) {
            finalPath = path_1.default.normalize(path_1.default.join(this.topPath, this.cwd, fileName));
        }
        if (finalPath.indexOf(topAbsolutePath) !== 0 &&
            topAbsolutePath !== "/" &&
            topAbsolutePath !== "\\")
            throw new Error(ERROR_MSG_01);
        return finalPath;
    }
    checkPath(fileNameOrPath) {
        if (this.isRootTopRath())
            return true;
        const destAbsolutePath = this.toAbsolutePath(fileNameOrPath);
        const topAbsolutePath = this.topPath;
        return destAbsolutePath.indexOf(topAbsolutePath) === 0;
    }
    check(destPath) {
        if (this.isRootTopRath())
            return true;
        return this.checkPath(destPath) && fs_extra_1.default.existsSync(this.toAbsolutePath(destPath));
    }
    cd(dirName) {
        if (!this.check(dirName))
            throw new Error(ERROR_MSG_01);
        this.cwd = (0, filepath_1.normalizedJoin)(this.cwd, dirName);
    }
    async list(page, pageSize = 40, searchFileName) {
        if (pageSize > 100 || pageSize <= 0 || page < 0)
            throw new Error("Beyond the value limit");
        // Use withFileTypes option to get file type directly, reducing stat calls
        const dirents = await fs_extra_1.default.readdir(this.toAbsolutePath(), { withFileTypes: true });
        // Filter search results and create basic file info with type
        let filteredItems = dirents
            .filter((dirent) => !searchFileName || dirent.name.toLowerCase().includes(searchFileName.toLowerCase()))
            .map((dirent) => ({
            name: dirent.name,
            type: dirent.isFile() ? 1 : 0
        }));
        const total = filteredItems.length;
        // Sort: directories first (type 0), then files (type 1), both alphabetically
        filteredItems.sort((a, b) => {
            if (a.type !== b.type)
                return a.type - b.type;
            return a.name.localeCompare(b.name);
        });
        const sliceStart = page * pageSize;
        const sliceEnd = sliceStart + pageSize;
        const targetItems = filteredItems.slice(sliceStart, sliceEnd);
        const statPromises = targetItems.map(async (item) => {
            var _a;
            try {
                const info = await fs_extra_1.default.stat(this.toAbsolutePath(item.name));
                const mode = parseInt(String(parseInt((_a = info.mode) === null || _a === void 0 ? void 0 : _a.toString(8), 10)).slice(-3));
                return {
                    name: item.name,
                    size: info.isFile() ? info.size : 0,
                    time: info.atime.toString(),
                    mode,
                    type: item.type
                };
            }
            catch (error) {
                return {
                    name: item.name,
                    size: 0,
                    time: new Date().toString(),
                    mode: 0,
                    type: item.type
                };
            }
        });
        // Execute all stat operations concurrently
        const resultList = await Promise.all(statPromises);
        return {
            items: resultList,
            page,
            pageSize,
            total,
            absolutePath: this.toAbsolutePath()
        };
    }
    async chmod(fileName, chmodValue, deep) {
        if (!this.check(fileName) || isNaN(parseInt(chmodValue)))
            throw new Error(ERROR_MSG_01);
        const absPath = this.toAbsolutePath(fileName);
        const defaultPath = "/bin/chmod";
        let file = "chmod";
        if (fs_extra_1.default.existsSync(defaultPath))
            file = defaultPath;
        const params = [];
        if (deep)
            params.push("-R");
        params.push(String(chmodValue));
        params.push(absPath);
        return await new mcsmanager_common_1.ProcessWrapper(file, params, ".", 60 * 10).start();
    }
    async readFile(fileName) {
        if (!this.check(fileName))
            throw new Error(ERROR_MSG_01);
        const absPath = this.toAbsolutePath(fileName);
        const buf = await fs_extra_1.default.readFile(absPath);
        const text = iconv_lite_1.default.decode(buf, this.fileCode || "utf-8");
        return text;
    }
    async writeFile(fileName, data) {
        if (!this.check(fileName))
            throw new Error(ERROR_MSG_01);
        const absPath = this.toAbsolutePath(fileName);
        const buf = iconv_lite_1.default.encode(data, this.fileCode || "utf-8");
        return await fs_extra_1.default.writeFile(absPath, buf);
    }
    async newFile(fileName) {
        // if (!FileManager.checkFileName(fileName)) throw new Error(ERROR_MSG_01);
        if (!this.checkPath(fileName))
            throw new Error(ERROR_MSG_01);
        const target = this.toAbsolutePath(fileName);
        fs_extra_1.default.createFile(target);
    }
    async copy(target1, target2) {
        if (!this.checkPath(target2) || !this.check(target1))
            throw new Error(ERROR_MSG_01);
        const targetPath = this.toAbsolutePath(target1);
        target2 = this.toAbsolutePath(target2);
        return await fs_extra_1.default.copy(targetPath, target2);
    }
    mkdir(target) {
        if (!this.checkPath(target))
            throw new Error(ERROR_MSG_01);
        const targetPath = this.toAbsolutePath(target);
        return fs_extra_1.default.mkdirSync(targetPath);
    }
    async delete(target) {
        if (!this.check(target))
            throw new Error(ERROR_MSG_01);
        const targetPath = this.toAbsolutePath(target);
        return new Promise((r, j) => {
            fs_extra_1.default.remove(targetPath, (err) => {
                if (!err)
                    r(true);
                else
                    j(err);
            });
        });
    }
    async move(target, destPath) {
        if (!this.check(target))
            throw new Error(ERROR_MSG_01);
        if (!this.checkPath(destPath))
            throw new Error(ERROR_MSG_01);
        const targetPath = this.toAbsolutePath(target);
        destPath = this.toAbsolutePath(destPath);
        await fs_extra_1.default.move(targetPath, destPath);
    }
    zipFileCheck(path) {
        const fileInfo = fs_extra_1.default.statSync(path);
        const MAX_ZIP_GB = config_1.globalConfiguration.config.maxZipFileSize;
        if (fileInfo.size > 1024 * 1024 * 1024 * MAX_ZIP_GB)
            throw new Error((0, i18n_1.$t)("TXT_CODE_system_file.unzipLimit", { max: MAX_ZIP_GB }));
    }
    async unzip(sourceZip, destDir, code) {
        if (!code)
            code = this.fileCode;
        if (!this.check(sourceZip) || !this.checkPath(destDir))
            throw new Error(ERROR_MSG_01);
        this.zipFileCheck(this.toAbsolutePath(sourceZip));
        return await (0, compress_1.decompress)(this.toAbsolutePath(sourceZip), this.toAbsolutePath(destDir), code);
    }
    async zip(sourceZip, files, code) {
        var _a;
        if (!code)
            code = this.fileCode;
        if (!this.checkPath(sourceZip))
            throw new Error(ERROR_MSG_01);
        const MAX_ZIP_GB = config_1.globalConfiguration.config.maxZipFileSize;
        const MAX_TOTAL_FIELS_SIZE = 1024 * 1024 * 1024 * MAX_ZIP_GB;
        const sourceZipPath = this.toAbsolutePath(sourceZip);
        const filesPath = [];
        let totalSize = 0;
        for (const iterator of files) {
            if (this.check(iterator)) {
                filesPath.push(this.toAbsolutePath(iterator));
                try {
                    totalSize += (_a = fs_extra_1.default.statSync(this.toAbsolutePath(iterator))) === null || _a === void 0 ? void 0 : _a.size;
                }
                catch (error) { }
            }
        }
        if (totalSize > MAX_TOTAL_FIELS_SIZE)
            throw new Error((0, i18n_1.$t)("TXT_CODE_system_file.unzipLimit", { max: MAX_ZIP_GB }));
        return await (0, compress_1.compress)(sourceZipPath, filesPath, code);
    }
    async edit(target, data) {
        if (!this.check(target))
            throw new Error(ERROR_MSG_01);
        if (data || typeof data === "string") {
            return await this.writeFile(target, data);
        }
        else {
            const absPath = this.toAbsolutePath(target);
            const info = fs_extra_1.default.statSync(absPath);
            if (info.size > MAX_EDIT_SIZE) {
                throw new Error((0, i18n_1.$t)("TXT_CODE_system_file.execLimit"));
            }
            return await this.readFile(target);
        }
    }
    rename(target, newName) {
        if (!this.check(target))
            throw new Error(ERROR_MSG_01);
        if (!this.checkPath(newName))
            throw new Error(ERROR_MSG_01);
        const targetPath = this.toAbsolutePath(target);
        const newPath = this.toAbsolutePath(newName);
        fs_extra_1.default.renameSync(targetPath, newPath);
    }
    static checkFileName(fileName) {
        if (!fileName)
            return false;
        const blackKeys = ["/", "\\", "|", "?", "*", ">", "<", ";", '"'];
        for (const ch of blackKeys) {
            if (fileName.includes(ch))
                return false;
        }
        return true;
    }
}
exports["default"] = FileManager;


/***/ }),

/***/ "../daemon/src/tools/filepath.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizedJoin = exports.clearUploadFiles = exports.checkFileName = void 0;
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const os_1 = __importDefault(__webpack_require__("os"));
const path_1 = __importDefault(__webpack_require__("path"));
function checkFileName(fileName) {
    const blackKeys = ["/", "\\", "|", "?", "*", ">", "<", ";", '"'];
    for (const ch of blackKeys) {
        if (fileName.includes(ch))
            return false;
    }
    return true;
}
exports.checkFileName = checkFileName;
function clearUploadFiles(file) {
    if (!file)
        return;
    if (file instanceof Array) {
        file.forEach((v) => {
            fs_extra_1.default.remove(v.filepath, () => { });
        });
    }
    else {
        fs_extra_1.default.remove(file.filepath, () => { });
    }
}
exports.clearUploadFiles = clearUploadFiles;
function normalizedJoin(...paths) {
    if (os_1.default.platform() === "win32") {
        return joinWin32(...paths);
    }
    return path_1.default.normalize(path_1.default.join(...paths));
}
exports.normalizedJoin = normalizedJoin;
function joinWin32(...paths) {
    if (!paths.length)
        return ".";
    if (paths.length == 1)
        return paths[0];
    const parts = path_1.default.win32.parse(paths[1]);
    let p;
    if (parts.root) {
        p = paths[1];
    }
    else {
        p = path_1.default.normalize(path_1.default.join(paths[0], paths[1]));
    }
    if (paths.length <= 2)
        return p;
    return joinWin32(p, ...paths.slice(2));
}


/***/ }),

/***/ "./src/app.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const http_1 = __importDefault(__webpack_require__("http"));
const https_1 = __importDefault(__webpack_require__("https"));
const koa_1 = __importDefault(__webpack_require__("koa"));
const koa_body_1 = __importStar(__webpack_require__("koa-body"));
const koa_session_1 = __importDefault(__webpack_require__("koa-session"));
const koa_static_1 = __importDefault(__webpack_require__("koa-static"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const open_1 = __importDefault(__webpack_require__("open"));
const os_1 = __importDefault(__webpack_require__("os"));
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const path_1 = __importDefault(__webpack_require__("path"));
const uuid_1 = __webpack_require__("uuid");
const redis_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/redis_storage.ts"));
const sys_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/sys_storage.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const index_1 = __webpack_require__("./src/app/index.ts");
const precheck_1 = __webpack_require__("./src/app/middleware/precheck.ts");
const protocol_1 = __webpack_require__("./src/app/middleware/protocol.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const version_adapter_1 = __importDefault(__webpack_require__("./src/app/service/version_adapter.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const version_1 = __webpack_require__("./src/app/version.ts");
function hasParams(name) {
    return process.argv.includes(name);
}
function setupHttp(koaApp, ssl, sslPemPath, sslKeyPath, port, host) {
    let httpServer;
    if (ssl) {
        const options = {
            cert: fs_extra_1.default.readFileSync(path_1.default.join(sslPemPath)),
            key: fs_extra_1.default.readFileSync(path_1.default.join(sslKeyPath))
        };
        httpServer = https_1.default.createServer(options, koaApp.callback());
    }
    else {
        httpServer = http_1.default.createServer(koaApp.callback());
    }
    httpServer.on("error", (err) => {
        log_1.logger.error((0, i18n_1.$t)("TXT_CODE_app.httpSetupError"));
        log_1.logger.error(err);
        process.exit(1);
    });
    httpServer.listen(port, host);
    log_1.logger.info("==================================");
    log_1.logger.info((0, i18n_1.$t)("TXT_CODE_app.panelStarted"));
    log_1.logger.info((0, i18n_1.$t)("TXT_CODE_app.reference"));
    let appHost = (0, i18n_1.$t)("TXT_CODE_app.host", { port });
    if (ssl)
        appHost = appHost.replace("http", "https");
    log_1.logger.info(appHost);
    log_1.logger.info((0, i18n_1.$t)("TXT_CODE_app.portTip", { port }));
    log_1.logger.info((0, i18n_1.$t)("TXT_CODE_app.exitTip", { port }));
    log_1.logger.info("==================================");
    if (os_1.default.platform() == "win32" && hasParams("--open")) {
        (0, open_1.default)(ssl ? `https://localhost:${port}/` : `http://localhost:${port}/`);
    }
}
async function processExit() {
    try {
        log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_cea5dba1"));
        log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_b0aa2db9"));
    }
    catch (err) {
        log_1.logger.error(err);
    }
    finally {
        process.exit(0);
    }
}
["SIGTERM", "SIGINT", "SIGQUIT"].forEach(function (sig) {
    process.on(sig, () => {
        log_1.logger.warn(`${sig} close process signal detected.`);
        processExit();
    });
});
process.stdin.on("data", (v) => {
    const command = v.toString().replace("\n", "").replace("\r", "").trim().toLowerCase();
    if (command === "exit")
        processExit();
});
async function main() {
    var _a;
    // load global configuration file
    (0, setting_1.initSystemConfig)();
    if (setting_1.systemConfig && ((_a = setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.redisUrl) === null || _a === void 0 ? void 0 : _a.length) != 0) {
        await redis_storage_1.default.initialize(setting_1.systemConfig.redisUrl);
        sys_storage_1.default.setStorageType(sys_storage_1.default.TYPE.REDIS);
    }
    (0, version_1.initVersionManager)();
    const VERSION = (0, version_1.getVersion)();
    console.log(`______  _______________________  ___                                         
___   |/  /_  ____/_  ___/__   |/  /_____ _____________ _______ _____________
__  /|_/ /_  /    _____ \\__  /|_/ /_  __ \`/_  __ \\  __ \`/_  __ \`/  _ \\_  ___/
_  /  / / / /___  ____/ /_  /  / / / /_/ /_  / / / /_/ /_  /_/ //  __/  /    
/_/  /_/  \\____/  /____/ /_/  /_/  \\__,_/ /_/ /_/\\__,_/ _\\__, / \\___//_/     
                                                        /____/     

 + Copyright ${new Date().getFullYear()} MCSManager Dev <https://github.com/MCSManager>
 + Version ${VERSION}
`);
    // Detect whether the configuration file is from an older version and update it if so.
    version_adapter_1.default.detectConfig();
    (0, version_1.checkBusinessMode)();
    // Initialize services
    await user_service_1.default.initialize();
    await remote_service_1.default.initialize();
    const app = new koa_1.default({
        proxy: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.reverseProxyMode) || false,
        proxyIpHeader: "X-Real-IP"
    });
    // Listen for Koa errors
    app.on("error", (error) => {
        // Block all Koa framework level events
        // When Koa is attacked by a short connection flood, it is easy for error messages to swipe the screen, which may indirectly affect the operation of some applications
    });
    app.use(precheck_1.preCheckMiddleware);
    app.use((0, koa_body_1.default)({
        multipart: true,
        parsedMethods: [
            koa_body_1.HttpMethodEnum.GET,
            koa_body_1.HttpMethodEnum.PUT,
            koa_body_1.HttpMethodEnum.POST,
            koa_body_1.HttpMethodEnum.DELETE
        ],
        formidable: {
            maxFileSize: 1024 * 1024 * 500,
            maxFiles: 1
        },
        jsonLimit: "10mb",
        onError(err, ctx) {
            log_1.logger.error("koaBody Lib Error:", err);
        }
    }));
    app.keys = [(0, uuid_1.v4)()];
    app.use((0, koa_session_1.default)({
        key: (0, uuid_1.v4)(),
        maxAge: 86400000,
        overwrite: true,
        httpOnly: true,
        signed: true,
        rolling: false,
        renew: false,
        secure: false
    }, app));
    app.use(async (ctx, next) => {
        const ignoreUrls = ["/api/overview", "/api/files/status"];
        for (const iterator of ignoreUrls) {
            if (ctx.URL.pathname.includes(iterator))
                return await next();
        }
        await next();
    });
    if (setting_1.systemConfig && setting_1.systemConfig.prefix != "") {
        const prefix = setting_1.systemConfig.prefix;
        app.use(async (ctx, next) => {
            if (ctx.url.startsWith(prefix)) {
                const orig = ctx.url;
                ctx.url = ctx.url.slice(prefix.length);
                if (!ctx.url.startsWith("/")) {
                    ctx.url = "/" + ctx.url;
                }
                await next();
                ctx.url = orig;
            }
            else {
                ctx.redirect((0, mcsmanager_common_1.removeTrail)(prefix, "/") + ctx.url);
            }
        });
    }
    app.use(protocol_1.middleware);
    app.use((0, koa_static_1.default)(path_1.default.join(process.cwd(), "public"), {
        maxAge: 10 * 24 * 60 * 60
    }));
    (0, index_1.mountRouters)(app);
    process.on("uncaughtException", function (err) {
        log_1.logger.error(`ERROR (uncaughtException):`, err);
    });
    process.on("unhandledRejection", (reason, p) => {
        log_1.logger.error(`ERROR (unhandledRejection):`, reason, p);
    });
    if (setting_1.systemConfig)
        setupHttp(app, setting_1.systemConfig.ssl, setting_1.systemConfig.sslPemPath, setting_1.systemConfig.sslKeyPath, setting_1.systemConfig.httpPort, setting_1.systemConfig.httpIp);
}
main().catch((err) => {
    log_1.logger.error("main() error:", err);
    process.exit(0);
});


/***/ }),

/***/ "./src/app/common/storage/file_storage.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const storage = new mcsmanager_common_1.StorageSubsystem();
class FileStorageSubsystemAdapter {
    async store(category, uuid, object) {
        return storage.store(category, uuid, object);
    }
    async load(category, classz, uuid) {
        return storage.load(category, classz, uuid);
    }
    async list(category) {
        return storage.list(category);
    }
    async delete(category, uuid) {
        return storage.delete(category, uuid);
    }
}
exports["default"] = new FileStorageSubsystemAdapter();


/***/ }),

/***/ "./src/app/common/storage/jsonl_storage.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _JsonlStorageSubsystem_rootDir, _JsonlStorageSubsystem_maxLines;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.JsonlStorageSubsystem = void 0;
const path_1 = __importDefault(__webpack_require__("path"));
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
class JsonlStorageSubsystem {
    constructor(dir, maxLines = 200) {
        _JsonlStorageSubsystem_rootDir.set(this, void 0);
        _JsonlStorageSubsystem_maxLines.set(this, void 0);
        __classPrivateFieldSet(this, _JsonlStorageSubsystem_rootDir, path_1.default.normalize(process.cwd() + "/data/" + dir), "f");
        __classPrivateFieldSet(this, _JsonlStorageSubsystem_maxLines, maxLines, "f");
    }
    resolveFilePath(logicalPath) {
        if (!this.checkPath(logicalPath)) {
            throw new Error(`Invalid path: ${logicalPath}`);
        }
        const fullPath = path_1.default.join(__classPrivateFieldGet(this, _JsonlStorageSubsystem_rootDir, "f"), logicalPath + ".jsonl");
        const normalizePath = path_1.default.normalize(fullPath);
        if (!fs_extra_1.default.existsSync(path_1.default.dirname(normalizePath))) {
            fs_extra_1.default.mkdirsSync(path_1.default.dirname(normalizePath));
        }
        return normalizePath;
    }
    checkPath(name) {
        const blackList = ["..", "\\", "//"];
        return !blackList.some((ch) => name.includes(ch));
    }
    async append(logicalPath, entry, sync = false) {
        if (!Array.isArray(entry))
            entry = [entry];
        const filePath = this.resolveFilePath(logicalPath);
        const lines = entry.map((e) => JSON.stringify(e)).join("\n") + "\n";
        if (sync) {
            fs_extra_1.default.ensureFileSync(filePath);
            fs_extra_1.default.appendFileSync(filePath, lines, "utf-8");
        }
        else {
            await fs_extra_1.default.ensureFile(filePath);
            await fs_extra_1.default.appendFile(filePath, lines, "utf-8");
        }
        await this.trimToMaxLines(logicalPath);
    }
    async readAll(logicalPath) {
        const filePath = this.resolveFilePath(logicalPath);
        if (!(await fs_extra_1.default.pathExists(filePath)))
            return [];
        const lines = await fs_extra_1.default.readFile(filePath, "utf-8");
        return lines
            .split("\n")
            .filter((l) => l.trim())
            .map((l) => {
            try {
                return JSON.parse(l);
            }
            catch (_a) {
                return null;
            }
        })
            .filter(Boolean);
    }
    async query(logicalPath, predicate) {
        const all = await this.readAll(logicalPath);
        return all.filter(predicate);
    }
    async overwrite(logicalPath, entries) {
        const filePath = this.resolveFilePath(logicalPath);
        await fs_extra_1.default.ensureFile(filePath);
        const content = entries.map((e) => JSON.stringify(e)).join("\n") + "\n";
        await fs_extra_1.default.writeFile(filePath, content, "utf-8");
    }
    async update(logicalPath, predicate, updater) {
        const entries = await this.readAll(logicalPath);
        const newEntries = entries.map((e) => (predicate(e) ? updater(e) : e));
        await this.overwrite(logicalPath, newEntries);
    }
    async delete(logicalPath, predicate) {
        const entries = await this.readAll(logicalPath);
        const filtered = entries.filter((e) => !predicate(e));
        await this.overwrite(logicalPath, filtered);
    }
    async clear(logicalPath) {
        const filePath = this.resolveFilePath(logicalPath);
        if (await fs_extra_1.default.pathExists(filePath)) {
            await fs_extra_1.default.remove(filePath);
        }
    }
    async tail(logicalPath, count) {
        const entries = await this.query(logicalPath, () => true);
        return entries.slice(-count);
    }
    async trimToMaxLines(logicalPath) {
        const entries = await this.readAll(logicalPath);
        if (entries.length > __classPrivateFieldGet(this, _JsonlStorageSubsystem_maxLines, "f")) {
            const trimmedEntries = entries.slice(-__classPrivateFieldGet(this, _JsonlStorageSubsystem_maxLines, "f"));
            await this.overwrite(logicalPath, trimmedEntries);
        }
    }
}
exports.JsonlStorageSubsystem = JsonlStorageSubsystem;
_JsonlStorageSubsystem_rootDir = new WeakMap(), _JsonlStorageSubsystem_maxLines = new WeakMap();


/***/ }),

/***/ "./src/app/common/storage/redis_storage.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const redis_1 = __webpack_require__("redis");
const sys_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/sys_storage.ts"));
const log_1 = __webpack_require__("./src/app/service/log.ts");
class RedisStorageSubsystem {
    constructor() {
        this.client = (0, redis_1.createClient)();
    }
    async connect() {
        try {
            await this.client.connect();
        }
        catch (e) {
            log_1.logger.error("Error occurred while trying to dial redis\n" + e);
            log_1.logger.warn("Due to an unrecoverable error, daemon will temporarily store data in files.");
            sys_storage_1.default.setStorageType(0);
        }
    }
    /*
    Redis commands
     */
    async keys(param) {
        return await this.client.keys(param);
    }
    async set(key, value) {
        await this.client.set(key, value);
    }
    async get(key) {
        return await this.client.get(key);
    }
    async del(key) {
        await this.client.del(key);
    }
    async initialize(url) {
        this.client = (0, redis_1.createClient)({ url: url });
        log_1.logger.info("Attempting to connect to redis...");
        await this.connect();
        log_1.logger.info("Connected to redis!");
    }
    // Keep behavior same
    checkFileName(name) {
        const blackList = ["\\", "/", ".."];
        for (const ch of blackList) {
            if (name.includes(ch))
                return false;
        }
        return true;
    }
    /**
     * Stored in local file based on class definition and identifier
     */
    async store(category, uuid, object) {
        if (!this.checkFileName(uuid))
            throw new Error(`UUID ${uuid} does not conform to specification`);
        await this.set(category + ":" + uuid, JSON.stringify(object));
    }
    /**
     * Instantiate an object based on the class definition and identifier
     */
    async load(category, classz, uuid) {
        if (!this.checkFileName(uuid))
            throw new Error(`UUID ${uuid} does not conform to specification`);
        let result = await this.get(category + ":" + uuid);
        if (result == null) {
            return null;
        }
        const dataObject = JSON.parse(result);
        const target = new classz();
        return this.defineAttr(target, dataObject);
    }
    /**
     * Return all identifiers related to this class through the class definition
     */
    async list(category) {
        let result = [];
        let m = Array();
        result = await this.keys(category + "*");
        if (result != null && result.length != 0) {
            for (let i of result)
                m.push(i.replace(category + ":", ""));
        }
        return m;
    }
    /**
     * Delete an identifier instance of the specified type through the class definition
     */
    async delete(category, uuid) {
        if (!this.checkFileName(uuid))
            throw new Error(`UUID ${uuid} does not conform to specification`);
        await this.del(category + ":" + uuid);
    }
    // deep copy of the primitive type with the copy target as the prototype
    // target copy target object copy source
    defineAttr(target, object) {
        for (const v of Object.keys(target)) {
            const objectValue = object[v];
            if (objectValue === undefined)
                continue;
            if (objectValue instanceof Array) {
                target[v] = objectValue;
                continue;
            }
            if (objectValue instanceof Object && typeof objectValue === "object") {
                this.defineAttr(target[v], objectValue);
                continue;
            }
            target[v] = objectValue;
        }
        return target;
    }
}
exports["default"] = new RedisStorageSubsystem();


/***/ }),

/***/ "./src/app/common/storage/sys_storage.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const file_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/file_storage.ts"));
const redis_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/redis_storage.ts"));
class SystemStorage {
    constructor() {
        this.storageSystem = file_storage_1.default;
        this.TYPE = {
            FILE: 0,
            REDIS: 1
        };
    }
    setStorageType(type) {
        switch (type) {
            case this.TYPE.FILE: {
                // Using fs-based storage
                this.storageSystem = file_storage_1.default;
                break;
            }
            case this.TYPE.REDIS: {
                // Using redis-based storage
                this.storageSystem = redis_storage_1.default;
                break;
            }
            default: {
                this.storageSystem = file_storage_1.default;
                break;
            }
        }
    }
    getStorage() {
        return this.storageSystem;
    }
}
exports["default"] = new SystemStorage();


/***/ }),

/***/ "./src/app/common/system_storage.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
exports["default"] = new mcsmanager_common_1.StorageSubsystem();


/***/ }),

/***/ "./src/app/const.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MARKET_CACHE_FILE_PATH = exports.FILENAME_BLACKLIST = void 0;
const path_1 = __importDefault(__webpack_require__("path"));
exports.FILENAME_BLACKLIST = ["\\", "/", ".", "'", '"', "?", "*", "<", ">"];
exports.MARKET_CACHE_FILE_PATH = path_1.default.normalize(path_1.default.join(process.cwd(), "data", "market_cache.json"));


/***/ }),

/***/ "./src/app/entity/entity_interface.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteServiceConfig = void 0;
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
// @Entity
class RemoteServiceConfig {
    constructor() {
        this.ip = "";
        this.port = 24444;
        this.prefix = "";
        this.remarks = "";
        this.apiKey = "";
        this.remoteMappings = [];
        this.connectOpts = {
            multiplex: false,
            reconnectionDelayMax: 1000 * 5,
            timeout: 1000 * 10,
            reconnection: true,
            reconnectionAttempts: 10,
            rejectUnauthorized: false
        };
    }
    /**
     * To keep the remote mapping inside response consistent with other parts,
     * a simple conversion needs to be made.
     *
     * This is intentionally a method instead of a getter member, as the
     * conversion involves list operation.
     *
     * @returns converted remote mappings
     */
    getConvertedRemoteMappings() {
        return this.remoteMappings.map((remote) => ({
            from: {
                addr: `${remote.from.ip}:${remote.from.port}`,
                prefix: remote.from.prefix
            },
            to: {
                addr: `${remote.to.ip}:${remote.to.port}`,
                prefix: remote.to.prefix
            }
        }));
    }
    /**
     * IP concatenated with port.
     */
    get addr() {
        return `${this.ip}:${this.port}`;
    }
    /**
     * The prefix trimmed and removed trailing slash.
     */
    get canonicalPrefix() {
        return (0, mcsmanager_common_1.removeTrail)(this.prefix.trim(), "/");
    }
    /**
     * Full address containing IP, port and prefix.
     */
    get fullAddr() {
        return this.addr + this.canonicalPrefix;
    }
}
exports.RemoteServiceConfig = RemoteServiceConfig;


/***/ }),

/***/ "./src/app/entity/remote_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const socket_io_client_1 = __webpack_require__("socket.io-client");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const setting_1 = __webpack_require__("./src/app/setting.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
class RemoteService {
    constructor(uuid, config) {
        this.uuid = "";
        this.available = false;
        this.instanceStream = new mcsmanager_common_1.InstanceStreamListener();
        this.realUrl = "";
        this.uuid = uuid;
        this.config = config;
    }
    getDaemonInfo() {
        return `Name: ${this.config.remarks} | ID: ${this.uuid} | URL: ${this.realUrl}`;
    }
    connect(connectOpts) {
        if (connectOpts)
            this.config.connectOpts = connectOpts;
        // Start the formal connection to the remote Socket program
        let addr = `ws://${this.config.ip}:${this.config.port}`;
        if (this.config.ip.indexOf("wss://") === 0 || this.config.ip.indexOf("ws://") === 0) {
            addr = `${this.config.ip}:${this.config.port}`;
        }
        if (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.ssl) {
            addr = addr.replace("ws://", "wss://");
        }
        this.realUrl = addr;
        const daemonInfo = this.getDaemonInfo();
        if (this.available) {
            log_1.logger.info(`${(0, i18n_1.$t)("TXT_CODE_daemonInfo.resetConnect")}:${daemonInfo}`);
            this.disconnect();
        }
        // prevent duplicate registration of events
        if (this.socket && this.socket.hasListeners("connect")) {
            log_1.logger.info(`${(0, i18n_1.$t)("TXT_CODE_daemonInfo.replaceConnect")}:${daemonInfo}`);
            return this.refreshReconnect();
        }
        log_1.logger.info(`${(0, i18n_1.$t)("TXT_CODE_daemonInfo.tryConnect")}:${daemonInfo}`);
        this.socket = (0, socket_io_client_1.io)(this.realUrl, {
            ...this.config.connectOpts,
            path: (0, mcsmanager_common_1.removeTrail)(this.config.prefix, "/") + "/socket.io"
        });
        // register built-in events
        this.socket.on("connect", async () => {
            log_1.logger.info((0, i18n_1.$t)("TXT_CODE_daemonInfo.connect", { v: daemonInfo }));
            await this.onConnect();
        });
        this.socket.on("disconnect", async () => {
            log_1.logger.info((0, i18n_1.$t)("TXT_CODE_daemonInfo.disconnect", { v: daemonInfo }));
            await this.onDisconnect();
        });
        this.socket.on("connect_error", async (error) => {
            await this.onDisconnect();
        });
    }
    async setLanguage(language) {
        if (!language)
            language = i18n_1.i18next.language;
        log_1.logger.info(`${(0, i18n_1.$t)("TXT_CODE_daemonInfo.setLanguage")} (${this.config.ip}:${this.config.port}/${this.config.remarks}) language: ${language}`);
        return await new remote_command_1.default(this).request("info/setting", {
            language
        });
    }
    // This function is used to verify the identity. It only needs to be verified once.
    // This function will be executed automatically after the connection event is triggered.
    // Generally, there is no need to execute it manually.
    async auth(key) {
        if (key)
            this.config.apiKey = key;
        const daemonInfo = this.getDaemonInfo();
        try {
            const res = await new remote_command_1.default(this).request("auth", this.config.apiKey, 5000, true);
            if (res === true) {
                this.available = true;
                await this.setLanguage();
                log_1.logger.info((0, i18n_1.$t)("TXT_CODE_daemonInfo.authSuccess", { v: daemonInfo }));
                return true;
            }
            this.available = false;
            log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_daemonInfo.authFailure", { v: daemonInfo }));
            return false;
        }
        catch (error) {
            log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_daemonInfo.authError", { v: daemonInfo }));
            log_1.logger.warn(error);
            return false;
        }
    }
    emit(event, data) {
        var _a;
        return (_a = this.socket) === null || _a === void 0 ? void 0 : _a.emit(event, data);
    }
    async onDisconnect() {
        this.available = false;
    }
    async onConnect() {
        // this.available = true; Note: Connected is not auth;
        return await this.auth(this.config.apiKey);
    }
    disconnect() {
        if (this.socket) {
            const daemonInfo = this.getDaemonInfo();
            log_1.logger.info((0, i18n_1.$t)("TXT_CODE_daemonInfo.closed", { v: daemonInfo }));
            this.socket.removeAllListeners();
            this.socket.disconnect();
            this.socket.close();
            delete this.socket;
        }
        this.socket = undefined;
        this.available = false;
    }
    refreshReconnect() {
        this.disconnect();
        this.connect();
    }
}
exports["default"] = RemoteService;
RemoteService.STATUS_OK = 200;
RemoteService.STATUS_ERR = 500;


/***/ }),

/***/ "./src/app/entity/setting.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
// @Entity
class SystemConfig {
    constructor() {
        // HTTP service port, IP and path prefix
        this.httpPort = 23333;
        this.httpIp = "";
        this.prefix = "";
        // reverse proxy mode
        this.reverseProxyMode = false;
        // data transfer port
        this.dataPort = 23334;
        // Distributed forwarding mode
        this.forwardType = 1;
        // Whether to allow cross-domain requests
        this.crossDomain = false;
        // Whether to use Gzip compression for HTTP return information
        this.gzip = false;
        // Maximum simultaneous compression tasks
        this.maxCompress = 1;
        // Maximum simultaneous download tasks
        this.maxDownload = 10;
        // Decompression implementation form
        this.zipType = 1;
        // TOTP drift tolerance, in steps (30 seconds)
        this.totpDriftToleranceSteps = 0;
        // Login times IP limit
        this.loginCheckIp = true;
        // login Copyright Information
        this.loginInfo = "";
        // Whether to open the file management function for ordinary users
        this.canFileManager = true;
        // Whether to allow template-based instance reset, which may pose a security risk.
        // If you use Docker and need commercial functionality, you can try turning this feature on and testing it.
        this.allowUsePreset = false;
        // Panel display language
        this.language = "en_us";
        // Quick installation address
        this.presetPackAddr = "https://script.mcsmanager.com/market.json";
        // Redis address (Experimental Features)
        this.redisUrl = "";
        // Whether to allow users to edit the start & update command of Docker instances
        this.allowChangeCmd = false;
        // -----
        // After it is enabled, you can connect to the redeem.mcsmanager.com platform
        // to sell instances based on redeem
        // (this feature may not be available in some countries)
        this.businessMode = false;
        this.businessId = "";
        this.panelId = "";
        this.registerCode = "";
        // -----
        // Whether to enable SSL/TLS (HTTPS)
        this.ssl = false;
        // SSL certificate file path (.pem)
        this.sslPemPath = "";
        // SSL private key file path (.key)
        this.sslKeyPath = "";
    }
}
exports["default"] = SystemConfig;


/***/ }),

/***/ "./src/app/entity/user.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ROLE = exports.User = exports.UserPassWordType = void 0;
var UserPassWordType;
(function (UserPassWordType) {
    UserPassWordType[UserPassWordType["md5"] = 0] = "md5";
    UserPassWordType[UserPassWordType["bcrypt"] = 1] = "bcrypt";
})(UserPassWordType = exports.UserPassWordType || (exports.UserPassWordType = {}));
class User {
    constructor() {
        this.uuid = "";
        this.userName = "";
        this.passWord = "";
        this.passWordType = UserPassWordType.bcrypt;
        this.salt = "";
        this.permission = 0;
        this.registerTime = "";
        this.loginTime = "";
        this.instances = [];
        this.apiKey = "";
        this.isInit = false;
        this.secret = "";
        this.open2FA = false;
    }
}
exports.User = User;
var ROLE;
(function (ROLE) {
    ROLE[ROLE["ADMIN"] = 10] = "ADMIN";
    ROLE[ROLE["USER"] = 1] = "USER";
    ROLE[ROLE["GUEST"] = 0] = "GUEST";
    ROLE[ROLE["BAN"] = -1] = "BAN";
})(ROLE = exports.ROLE || (exports.ROLE = {}));


/***/ }),

/***/ "./src/app/i18n/index.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// I18n init configuration (Web Panel)
// If you want to add the language of your own country, you need to add the code here.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.i18next = exports.$t = void 0;
const i18next_1 = __importDefault(__webpack_require__("i18next"));
exports.i18next = i18next_1.default;
const zh_CN_json_1 = __importDefault(__webpack_require__("../languages/zh_CN.json"));
const en_US_json_1 = __importDefault(__webpack_require__("../languages/en_US.json"));
const zh_TW_json_1 = __importDefault(__webpack_require__("../languages/zh_TW.json"));
const ja_JP_json_1 = __importDefault(__webpack_require__("../languages/ja_JP.json"));
const es_ES_json_1 = __importDefault(__webpack_require__("../languages/es_ES.json"));
const fr_FR_json_1 = __importDefault(__webpack_require__("../languages/fr_FR.json"));
const ru_RU_json_1 = __importDefault(__webpack_require__("../languages/ru_RU.json"));
const ko_KR_json_1 = __importDefault(__webpack_require__("../languages/ko_KR.json"));
const de_DE_json_1 = __importDefault(__webpack_require__("../languages/de_DE.json"));
const pt_BR_json_1 = __importDefault(__webpack_require__("../languages/pt_BR.json"));
const th_TH_json_1 = __importDefault(__webpack_require__("../languages/th_TH.json"));
i18next_1.default.init({
    interpolation: {
        escapeValue: false
    },
    lng: "en_us",
    fallbackLng: "en_us",
    resources: {
        en_us: {
            translation: en_US_json_1.default
        },
        zh_cn: {
            translation: zh_CN_json_1.default
        },
        zh_tw: {
            translation: zh_TW_json_1.default
        },
        ja_jp: {
            translation: ja_JP_json_1.default
        },
        es_es: {
            translation: es_ES_json_1.default
        },
        fr_fr: {
            translation: fr_FR_json_1.default
        },
        ru_ru: {
            translation: ru_RU_json_1.default
        },
        ko_kr: {
            translation: ko_KR_json_1.default
        },
        de_de: {
            translation: de_DE_json_1.default
        },
        pt_br: {
            translation: pt_BR_json_1.default
        },
        th_TH: {
            translation: th_TH_json_1.default
        }
    }
});
// alias
const $t = i18next_1.default.t;
exports.$t = $t;


/***/ }),

/***/ "./src/app/index.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.mountRouters = void 0;
const router_1 = __importDefault(__webpack_require__("@koa/router"));
__webpack_require__("./src/app/service/user_service.ts");
__webpack_require__("./src/app/service/visual_data.ts");
__webpack_require__("./src/app/service/remote_service.ts");
__webpack_require__("./src/app/service/user_statistics.ts");
const overview_router_1 = __importDefault(__webpack_require__("./src/app/routers/overview_router.ts"));
const user_overview_router_1 = __importDefault(__webpack_require__("./src/app/routers/user_overview_router.ts"));
const login_router_1 = __importDefault(__webpack_require__("./src/app/routers/login_router.ts"));
const general_user_router_1 = __importDefault(__webpack_require__("./src/app/routers/general_user_router.ts"));
const settings_router_1 = __importDefault(__webpack_require__("./src/app/routers/settings_router.ts"));
const instance_admin_router_1 = __importDefault(__webpack_require__("./src/app/routers/instance_admin_router.ts"));
const instance_operate_router_1 = __importDefault(__webpack_require__("./src/app/routers/instance_operate_router.ts"));
const daemon_router_1 = __importDefault(__webpack_require__("./src/app/routers/daemon_router.ts"));
const filemananger_router_1 = __importDefault(__webpack_require__("./src/app/routers/filemananger_router.ts"));
const manage_user_router_1 = __importDefault(__webpack_require__("./src/app/routers/manage_user_router.ts"));
const schedule_router_1 = __importDefault(__webpack_require__("./src/app/routers/schedule_router.ts"));
const environment_router_1 = __importDefault(__webpack_require__("./src/app/routers/environment_router.ts"));
const instance_exchange_router_1 = __importDefault(__webpack_require__("./src/app/routers/instance_exchange_router.ts"));
function mountRouters(app) {
    const apiRouter = new router_1.default({ prefix: "/api" });
    apiRouter.use(overview_router_1.default.routes()).use(overview_router_1.default.allowedMethods());
    apiRouter.use(instance_operate_router_1.default.routes()).use(instance_operate_router_1.default.allowedMethods());
    apiRouter.use(instance_admin_router_1.default.routes()).use(instance_admin_router_1.default.allowedMethods());
    apiRouter.use(daemon_router_1.default.routes()).use(daemon_router_1.default.allowedMethods());
    apiRouter.use(filemananger_router_1.default.routes()).use(filemananger_router_1.default.allowedMethods());
    apiRouter.use(manage_user_router_1.default.routes()).use(manage_user_router_1.default.allowedMethods());
    apiRouter.use(login_router_1.default.routes()).use(login_router_1.default.allowedMethods());
    apiRouter.use(general_user_router_1.default.routes()).use(general_user_router_1.default.allowedMethods());
    apiRouter.use(user_overview_router_1.default.routes()).use(user_overview_router_1.default.allowedMethods());
    apiRouter.use(schedule_router_1.default.routes()).use(schedule_router_1.default.allowedMethods());
    apiRouter.use(settings_router_1.default.routes()).use(settings_router_1.default.allowedMethods());
    apiRouter.use(environment_router_1.default.routes()).use(environment_router_1.default.allowedMethods());
    apiRouter.use(instance_exchange_router_1.default.routes()).use(instance_exchange_router_1.default.allowedMethods());
    app.use(apiRouter.routes()).use(apiRouter.allowedMethods());
}
exports.mountRouters = mountRouters;


/***/ }),

/***/ "./src/app/middleware/limit.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.speedLimit = void 0;
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const mini_redis_1 = __webpack_require__("./src/app/service/mini_redis.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const SPEED_LIMIT_KEY = "SpeedLimit";
function speedLimit(seconds, errMsg) {
    return async (ctx, next) => {
        const requestPath = ctx.URL.pathname;
        const user = (0, passport_service_1.getUserFromCtx)(ctx);
        if (!user)
            throw new Error((0, i18n_1.$t)("TXT_CODE_permission.forbidden"));
        if (user.permission === user_1.ROLE.ADMIN) {
            return await next();
        }
        const speedCheckKey = `${SPEED_LIMIT_KEY}:${user.uuid}:${requestPath}`;
        const isExist = mini_redis_1.singletonMemoryRedis.get(speedCheckKey);
        if (isExist) {
            ctx.status = 500;
            ctx.body =
                errMsg ||
                    (0, i18n_1.$t)("TXT_CODE_c093bec9", {
                        seconds: mini_redis_1.singletonMemoryRedis.ttl(speedCheckKey)
                    });
            return;
        }
        mini_redis_1.singletonMemoryRedis.set(speedCheckKey, true, seconds);
        return await next();
    };
}
exports.speedLimit = speedLimit;


/***/ }),

/***/ "./src/app/middleware/permission.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.verificationFailed = void 0;
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
/**
 * @description Request speed limit, 8 requests per second
 */
function requestSpeedLimit(ctx) {
    const SESSION_REQ_TIMES = "SESSION_REQ_TIMES";
    const MAX_REQUESTS_PER_SECOND = 8;
    const WINDOW_SIZE = 1000;
    const currentTime = new Date().getTime();
    if (!ctx.session)
        return false;
    let requestTimes = ctx.session[SESSION_REQ_TIMES] || [];
    requestTimes = requestTimes.filter((time) => currentTime - time < WINDOW_SIZE);
    if (requestTimes.length >= MAX_REQUESTS_PER_SECOND) {
        return false;
    }
    requestTimes.push(currentTime);
    ctx.session[SESSION_REQ_TIMES] = requestTimes;
    return true;
}
// Failed callback
function verificationFailed(ctx) {
    ctx.status = 403;
    ctx.body = `[Forbidden] ${(0, i18n_1.$t)("TXT_CODE_permission.forbidden")}`;
}
exports.verificationFailed = verificationFailed;
function tokenError(ctx) {
    ctx.status = 403;
    ctx.body = `[Forbidden] ${(0, i18n_1.$t)("TXT_CODE_permission.forbiddenTokenError")}`;
}
function ajaxError(ctx) {
    ctx.status = 403;
    ctx.body = `[Forbidden] ${(0, i18n_1.$t)("TXT_CODE_permission.xmlhttprequestError")}`;
}
function apiError(ctx) {
    ctx.status = 403;
    ctx.body = `[Forbidden] ${(0, i18n_1.$t)("TXT_CODE_permission.apiError")}`;
}
function tooFast(ctx) {
    ctx.status = 500;
    ctx.body = `[TooFast] ${(0, i18n_1.$t)("TXT_CODE_permission.tooFast")}`;
}
// Basic user permission middleware
exports["default"] = (parameter) => {
    return async (ctx, next) => {
        var _a, _b, _c;
        if ((parameter.speedLimit == null || parameter.speedLimit === true) &&
            Number(parameter.level) < 10) {
            // Request speed check
            if (!requestSpeedLimit(ctx)) {
                return tooFast(ctx);
            }
        }
        // If it is an API request, perform API-level permission judgment
        const key = ((_a = ctx.request) === null || _a === void 0 ? void 0 : _a.header["x-request-api-key"]) || ctx.query.apikey;
        if (key) {
            const apiKey = String(key);
            const user = (0, passport_service_1.getUuidByApiKey)(apiKey);
            if (user && user.permission >= Number(parameter.level)) {
                return await next();
            }
            else {
                return apiError(ctx);
            }
        }
        // If the route requires Token verification, it will be verified, the default is automatic verification
        if (parameter.token !== false) {
            if (!(0, passport_service_1.isAjax)(ctx))
                return ajaxError(ctx);
            const requestToken = ctx.query.token;
            const realToken = (_b = ctx.session) === null || _b === void 0 ? void 0 : _b["token"];
            if (requestToken !== realToken) {
                return tokenError(ctx);
            }
        }
        // If the permission attribute is a number, the permission determination is automatically executed
        if (!isNaN(parseInt(String(parameter.level)))) {
            // The most basic authentication decision
            if (((_c = ctx.session) === null || _c === void 0 ? void 0 : _c["login"]) === true && ctx.session["uuid"] && ctx.session["userName"]) {
                const user = user_service_1.default.getInstance(ctx.session["uuid"]);
                // ban check
                if (user && user.permission < 0) {
                    return (0, passport_service_1.logout)(ctx);
                }
                // Judgment of permissions for ordinary users and administrative users
                if (user && user.permission >= Number(parameter.level)) {
                    return await next();
                }
            }
            // END: to verificationFailed()
        }
        else {
            return await next();
        }
        // record the number of unauthorized access
        mcsmanager_common_1.GlobalVariable.set(passport_service_1.ILLEGAL_ACCESS_KEY, mcsmanager_common_1.GlobalVariable.get(passport_service_1.ILLEGAL_ACCESS_KEY, 0) + 1);
        return verificationFailed(ctx);
    };
};


/***/ }),

/***/ "./src/app/middleware/precheck.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.preCheckMiddleware = exports.isUploadRequest = void 0;
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
function isUploadRequest(ctx) {
    var _a, _b;
    const headers = (_a = ctx.request) === null || _a === void 0 ? void 0 : _a.headers;
    const contentType = (_b = headers === null || headers === void 0 ? void 0 : headers["content-type"]) !== null && _b !== void 0 ? _b : "";
    return contentType.toLowerCase().includes("multipart");
}
exports.isUploadRequest = isUploadRequest;
/**
 * Prevent users from performing unrestricted file uploads using koa-body,
 * occupying machine disk space.
 */
async function preCheckMiddleware(ctx, next) {
    if (isUploadRequest(ctx)) {
        const user = (0, passport_service_1.getUserFromCtx)(ctx);
        const isAdmin = (user === null || user === void 0 ? void 0 : user.permission) === user_1.ROLE.ADMIN;
        if (!isAdmin)
            throw new Error("Access denied: Invalid multipart/form-data request!");
    }
    return await next();
}
exports.preCheckMiddleware = preCheckMiddleware;


/***/ }),

/***/ "./src/app/middleware/protocol.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.middleware = void 0;
const stream_1 = __webpack_require__("stream");
const visual_data_1 = __importDefault(__webpack_require__("./src/app/service/visual_data.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const version_1 = __webpack_require__("./src/app/version.ts");
// Define standard response data format middleware
async function middleware(ctx, next) {
    var _a, _b;
    // Increase the number of interface requests
    if (ctx.url.startsWith("/api/")) {
        visual_data_1.default.addRequestCount();
    }
    // Compatible with version 9.X API parameters
    if ((_a = ctx.query) === null || _a === void 0 ? void 0 : _a.remote_uuid)
        ctx.query.daemonId = ctx.query.remote_uuid;
    if ((_b = ctx.query) === null || _b === void 0 ? void 0 : _b.daemon_id)
        ctx.query.daemonId = ctx.query.daemon_id;
    // Pass the next middleware, any errors and return data will be processed according to the response protocol
    try {
        await next();
    }
    catch (error) {
        ctx.body = error;
    }
    if (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.crossDomain) {
        ctx.response.set("Access-Control-Allow-Origin", "*");
        ctx.response.set("Access-Control-Allow-Methods", "PUT, POST, GET, DELETE, OPTIONS");
        ctx.response.set("Access-Control-Allow-Headers", "Content-Type, Content-Length, Authorization, Accept, X-Requested-With");
    }
    ctx.response.set("X-Powered-By", "MCSManager");
    ctx.response.set("X-Version", (0, version_1.getVersion)());
    // Serialize and display when sending Error class
    if (ctx.body instanceof Error) {
        const error = ctx.body;
        ctx.status = 500;
        ctx.body = JSON.stringify({
            status: ctx.status,
            data: error.message,
            time: new Date().getTime()
        });
        return;
    }
    // release all data streams
    if (ctx.body instanceof stream_1.Stream) {
        return;
    }
    // 404 error code
    if (ctx.status == 404) {
        ctx.status = 404;
        ctx.body = JSON.stringify({
            status: ctx.status,
            data: "[404] Not Found",
            time: new Date().getTime()
        });
        return;
    }
    // When the response text is a string, use normal formatting
    if (typeof ctx.body == "string") {
        const status = ctx.status;
        const data = ctx.body;
        ctx.body = JSON.stringify({
            status,
            data,
            time: new Date().getTime()
        });
        return;
    }
    // When the return result is empty, display processing failed
    if (ctx.body === null || ctx.body === false || ctx.body === undefined) {
        ctx.status = 500;
        ctx.body = JSON.stringify({
            status: 500,
            data: ctx.body || null,
            time: new Date().getTime()
        });
        return;
    }
    // normal data
    if (ctx.status == 200) {
        ctx.body = JSON.stringify({
            status: ctx.status,
            data: ctx.body,
            time: new Date().getTime()
        });
        return;
    }
}
exports.middleware = middleware;


/***/ }),

/***/ "./src/app/middleware/validator.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
// Type check
function check(target, parameter) {
    if (target) {
        for (const key in parameter) {
            const typeVal = parameter[key];
            if (target[key] == null || target[key] === "")
                throw new Error(`Validator failed: "${key}" is required!`);
            if (typeVal === Number) {
                target[key] = Number(target[key]);
                if (isNaN(target[key]))
                    throw new Error(`Validator failed: "${key}" is not a number`);
                continue;
            }
            if (typeVal === String) {
                target[key] = String(target[key]);
                continue;
            }
            if (typeVal === Date) {
                const r = new Date(target[key]).toString();
                if (r == "Invalid Date" || r == null)
                    throw new Error(`Validator failed: "${key}" is not a date`);
                target[key] = new Date(target[key]);
                continue;
            }
            if (typeVal === Array) {
                if (!(target[key] instanceof Array)) {
                    const object = JSON.parse(target[key]);
                    if (!(object instanceof Array))
                        throw new Error(`Validator failed: "${key}" is not an array`);
                    target[key] = object;
                }
                continue;
            }
            if (typeVal === Object) {
                if (!target[key])
                    throw new Error(`Validator failed: "${key}" is not an object`);
                continue;
            }
        }
        return true;
    }
    throw new Error("target is null");
}
// Entry function
function default_1(parameter) {
    return async (ctx, next) => {
        try {
            parameter["params"] && check(ctx.params, parameter["params"]);
            parameter["query"] && check(ctx.query, parameter["query"]);
            parameter["body"] && check(ctx.request.body, parameter["body"]);
            return await next();
        }
        catch (err) {
            ctx.status = 400;
            ctx.body = `${err.message || "Request parameters are incorrect"}`;
        }
    };
}
exports["default"] = default_1;


/***/ }),

/***/ "./src/app/routers/daemon_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const router = new router_1.default({ prefix: "/service" });
// [Top-level Permission]
// Get the list of remote services
// Contains only service information, not a list of instance information
router.get("/remote_services_list", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    const result = new Array();
    for (const iterator of remote_service_1.default.services.entries()) {
        const remoteService = iterator[1];
        result.push({
            uuid: remoteService.uuid,
            ip: remoteService.config.ip,
            port: remoteService.config.port,
            prefix: remoteService.config.prefix,
            available: remoteService.available,
            remarks: remoteService.config.remarks
        });
    }
    ctx.body = result;
});
// [Top-level Permission]
// Query the daemon for the specified instance
router.get("/remote_service_instances", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String, page: Number, page_size: Number } }), async (ctx) => {
    const daemonId = String(ctx.query.daemonId);
    const page = Number(ctx.query.page);
    const pageSize = Number(ctx.query.page_size);
    const instanceName = ctx.query.instance_name;
    const status = ctx.query.status;
    const tag = String(ctx.query.tag);
    const remoteService = remote_service_1.default.getInstance(daemonId);
    let tagList = [];
    try {
        tagList = JSON.parse(tag);
    }
    catch (error) {
        // ignore
    }
    const result = await new remote_command_1.default(remoteService).request("instance/select", {
        page,
        pageSize,
        condition: {
            instanceName,
            status,
            tag: tagList.length > 0 ? tagList : null
        }
    });
    ctx.body = result;
});
// [Top-level Permission]
// Get remote server system information
router.get("/remote_services_system", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    const result = new Array();
    for (const iterator of remote_service_1.default.services.entries()) {
        const remoteService = iterator[1];
        let instancesInfo = null;
        try {
            instancesInfo = await new remote_command_1.default(remoteService).request("info/overview");
        }
        catch (err) {
            continue;
        }
        result.push(instancesInfo);
    }
    ctx.body = result;
});
// [Top-level Permission]
// Get remote server instance information (browse too large)
router.get("/remote_services", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    const result = new Array();
    for (const iterator of remote_service_1.default.services.entries()) {
        const remoteService = iterator[1];
        let instancesInfo = [];
        try {
            instancesInfo = await new remote_command_1.default(remoteService).request("instance/overview");
        }
        catch (err) {
            // ignore request errors
        }
        // send remote command if connection is available
        result.push({
            uuid: remoteService.uuid,
            ip: remoteService.config.ip,
            port: remoteService.config.port,
            prefix: remoteService.config.prefix,
            available: remoteService.available,
            remarks: remoteService.config.remarks,
            instances: instancesInfo
        });
    }
    ctx.body = result;
});
// [Top-level Permission]
// add remote service
router.post("/remote_service", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ body: { apiKey: String, port: Number, ip: String, remarks: String } }), async (ctx) => {
    var _a, _b, _c;
    const parameter = ctx.request.body;
    // do asynchronous registration
    const instance = await remote_service_1.default.registerRemoteService({
        apiKey: parameter.apiKey,
        port: parameter.port,
        ip: parameter.ip,
        prefix: (_a = parameter.prefix) !== null && _a !== void 0 ? _a : "",
        remarks: (_b = parameter.remarks) !== null && _b !== void 0 ? _b : ""
    });
    operation_logger_1.operationLogger.log("daemon_create", {
        operator_ip: ctx.ip,
        operator_name: (_c = ctx.session) === null || _c === void 0 ? void 0 : _c["userName"],
        daemon_id: instance.uuid
    });
    ctx.body = instance.uuid;
});
// [Top-level Permission]
// Modify remote service parameters
router.put("/remote_service", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { uuid: String } }), async (ctx) => {
    var _a, _b, _c;
    const uuid = String(ctx.request.query.uuid);
    const parameter = ctx.request.body || {};
    const daemonSetting = (parameter === null || parameter === void 0 ? void 0 : parameter.setting) || {};
    const daemon = remote_service_1.default.getInstance(uuid);
    if (daemonSetting && (daemon === null || daemon === void 0 ? void 0 : daemon.available)) {
        await new remote_command_1.default(daemon).request("info/setting", {
            ...daemonSetting,
            port: parameter.daemonPort
        });
    }
    if (!remote_service_1.default.services.has(uuid))
        throw new Error("Instance does not exist");
    await remote_service_1.default.edit(uuid, {
        port: parameter.port,
        ip: parameter.ip,
        prefix: (_a = parameter.prefix) !== null && _a !== void 0 ? _a : "",
        apiKey: parameter.apiKey,
        remarks: parameter.remarks,
        remoteMappings: (_b = parameter.remoteMappings) !== null && _b !== void 0 ? _b : [],
    });
    operation_logger_1.operationLogger.log("daemon_config_change", {
        operator_ip: ctx.ip,
        operator_name: (_c = ctx.session) === null || _c === void 0 ? void 0 : _c["userName"],
        daemon_id: uuid
    });
    ctx.body = true;
});
// [Top-level Permission]
// delete remote service
router.delete("/remote_service", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { uuid: String } }), async (ctx) => {
    var _a;
    const uuid = String(ctx.request.query.uuid);
    if (!remote_service_1.default.services.has(uuid))
        throw new Error("Instance does not exist");
    await remote_service_1.default.deleteRemoteService(uuid);
    operation_logger_1.operationLogger.log("daemon_remove", {
        operator_ip: ctx.ip,
        operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
        daemon_id: uuid
    });
    ctx.body = true;
});
// [Top-level Permission]
// connect to remote instance
router.get("/link_remote_service", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { uuid: String } }), async (ctx) => {
    var _a;
    const uuid = String(ctx.request.query.uuid);
    if (!remote_service_1.default.services.has(uuid))
        throw new Error("Instance does not exist");
    try {
        (_a = remote_service_1.default.getInstance(uuid)) === null || _a === void 0 ? void 0 : _a.connect();
        ctx.body = true;
    }
    catch (error) {
        ctx.body = error;
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/environment_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const router = new router_1.default({ prefix: "/environment" });
// [Top-level Permission]
// Get the specified remote service mirror list
router.get("/image", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("environment/images", {});
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// create image
router.post("/image", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const config = ctx.request.body;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("environment/new_image", config);
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// delete the specified image
router.delete("/image", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String, imageId: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const imageId = String(ctx.query.imageId);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("environment/del_image", {
            imageId
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// Get the list of existing containers of the specified remote service
router.get("/containers", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("environment/containers", {});
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// Get the list of existing networks for the specified remote service
router.get("/networkModes", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("environment/networkModes", {});
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// Get the image creation progress of the specified remote service
router.get("/progress", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("environment/progress", {});
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/filemananger_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const limit_1 = __webpack_require__("./src/app/middleware/limit.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const password_1 = __webpack_require__("./src/app/service/password.ts");
const permission_service_1 = __webpack_require__("./src/app/service/permission_service.ts");
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const router = new router_1.default({ prefix: "/files" });
router.use(async (ctx, next) => {
    const instanceUuid = String(ctx.query.uuid);
    const daemonId = String(ctx.query.daemonId);
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    if ((setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.canFileManager) === false && (0, passport_service_1.getUserPermission)(ctx) < 10) {
        ctx.status = 403;
        ctx.body = new Error((0, i18n_1.$t)("TXT_CODE_router.file.off"));
        return;
    }
    if ((0, permission_service_1.isHaveInstanceByUuid)(userUuid, daemonId, instanceUuid)) {
        await next();
    }
    else {
        ctx.status = 403;
        ctx.body = (0, i18n_1.$t)("TXT_CODE_permission.forbiddenInstance");
    }
});
router.get("/status", (0, permission_1.default)({ level: user_1.ROLE.USER, speedLimit: false }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String }
}), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/status", {
            instanceUuid
        });
        if (!(0, permission_service_1.isTopPermissionByUuid)((0, passport_service_1.getUserUuid)(ctx)))
            delete result.disk;
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.get("/list", (0, permission_1.default)({ level: user_1.ROLE.USER, speedLimit: false }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String, target: String, page: Number, page_size: Number }
}), async (ctx) => {
    try {
        const target = String(ctx.query.target);
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const page = Number(ctx.query.page);
        const pageSize = Number(ctx.query.page_size);
        const fileName = String(ctx.query.file_name);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/list", {
            instanceUuid,
            target,
            pageSize,
            page,
            fileName
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.put("/chmod", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, limit_1.speedLimit)(3), (0, validator_1.default)({
    query: { daemonId: String, uuid: String },
    body: { target: String, chmod: Number, deep: Boolean }
}), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const target = String(ctx.request.body.target);
        const chmod = Number(ctx.request.body.chmod);
        const deep = Number(ctx.request.body.deep);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/chmod", {
            target,
            instanceUuid,
            chmod,
            deep
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.post("/touch", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, limit_1.speedLimit)(3), (0, validator_1.default)({ query: { daemonId: String, uuid: String }, body: { target: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const target = String(ctx.request.body.target);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/touch", {
            target,
            instanceUuid
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.post("/mkdir", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, limit_1.speedLimit)(3), (0, validator_1.default)({ query: { daemonId: String, uuid: String }, body: { target: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const target = String(ctx.request.body.target);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/mkdir", {
            target,
            instanceUuid
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.put("/", (0, limit_1.speedLimit)(1), (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String }, body: { target: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const target = String(ctx.request.body.target);
        const text = ctx.request.body.text;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/edit", {
            instanceUuid,
            target,
            text
        }, 100000);
        operation_logger_1.operationLogger.log("instance_file_update", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_id: instanceUuid,
            daemon_id: daemonId,
            file: target
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.post("/copy", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, limit_1.speedLimit)(3), (0, validator_1.default)({ query: { daemonId: String, uuid: String }, body: { targets: Array } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const targets = ctx.request.body.targets;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/copy", {
            instanceUuid,
            targets
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.put("/move", (0, limit_1.speedLimit)(3), (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String }, body: { targets: Array } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const targets = ctx.request.body.targets;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/move", {
            instanceUuid,
            targets
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.delete("/", (0, limit_1.speedLimit)(3), (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String }, body: { targets: Object } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = ctx.query.uuid;
        const targets = ctx.request.body.targets;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("file/delete", {
            instanceUuid,
            targets
        });
        operation_logger_1.operationLogger.log("instance_file_delete", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_id: String(instanceUuid),
            daemon_id: daemonId,
            file: targets
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.post("/compress", (0, limit_1.speedLimit)(3), (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String },
    body: { source: String, targets: Object, type: Number, code: String }
}), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const source = String(ctx.request.body.source);
        const targets = ctx.request.body.targets;
        const type = Number(ctx.request.body.type);
        const code = String(ctx.request.body.code);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const res = await new remote_command_1.default(remoteService).request("file/compress", {
            instanceUuid,
            targets,
            source,
            type,
            code
        }, 0);
        ctx.body = res;
    }
    catch (err) {
        ctx.body = err;
    }
});
router.all("/download", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, limit_1.speedLimit)(3), (0, validator_1.default)({ query: { uuid: String, daemonId: String, file_name: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const fileName = String(ctx.query.file_name);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        if (!remoteService)
            throw new Error((0, i18n_1.$t)("TXT_CODE_dd559000") + ` Daemon ID: ${daemonId}`);
        const addr = remoteService.config.fullAddr;
        const remoteMappings = remoteService.config.getConvertedRemoteMappings();
        const password = (0, password_1.timeUuid)();
        await new remote_command_1.default(remoteService).request("passport/register", {
            name: "download",
            password: password,
            parameter: {
                fileName,
                instanceUuid
            }
        });
        operation_logger_1.operationLogger.log("instance_file_download", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_id: instanceUuid,
            daemon_id: daemonId,
            file: fileName
        });
        ctx.body = {
            password,
            addr,
            remoteMappings
        };
    }
    catch (err) {
        ctx.body = err;
    }
});
router.all("/upload", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { uuid: String, daemonId: String, upload_dir: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const uploadDir = String(ctx.query.upload_dir);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        if (!remoteService)
            throw new Error((0, i18n_1.$t)("TXT_CODE_dd559000") + ` Daemon ID: ${daemonId}`);
        const addr = remoteService.config.fullAddr;
        const remoteMappings = remoteService.config.getConvertedRemoteMappings();
        const password = (0, password_1.timeUuid)();
        await new remote_command_1.default(remoteService).request("passport/register", {
            name: "upload",
            password: password,
            parameter: {
                uploadDir,
                instanceUuid
            }
        });
        operation_logger_1.operationLogger.log("instance_file_upload", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_id: instanceUuid,
            daemon_id: daemonId
        });
        ctx.body = {
            password,
            addr,
            remoteMappings,
        };
    }
    catch (err) {
        ctx.body = err;
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/general_user_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const passport_service_2 = __webpack_require__("./src/app/service/passport_service.ts");
const permission_service_1 = __webpack_require__("./src/app/service/permission_service.ts");
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const uuid_1 = __webpack_require__("uuid");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const instance_service_1 = __webpack_require__("./src/app/service/instance_service.ts");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const router = new router_1.default({ prefix: "/auth" });
// [Low-level Permission]
// add token return
router.get("/token", (0, permission_1.default)({ level: user_1.ROLE.USER, token: false, speedLimit: false }), async (ctx) => {
    // Some and only Ajax requests can get the token
    if ((0, passport_service_2.isAjax)(ctx)) {
        ctx.body = (0, passport_service_2.getToken)(ctx);
    }
    else {
        throw new Error("The request is not an Ajax request.");
    }
});
// [Low-level Permission]
// get user data
router.get("/", (0, permission_1.default)({ level: user_1.ROLE.USER, token: false, speedLimit: false }), async (ctx) => {
    // Default permission to get me
    let uuid = (0, passport_service_1.getUserUuid)(ctx);
    // The front end can choose to require advanced data
    const advanced = ctx.query.advanced;
    // Admin permissions can be obtained from anyone
    if ((0, permission_service_1.isTopPermissionByUuid)(uuid) && ctx.query.uuid)
        uuid = String(ctx.query.uuid);
    // Some and only Ajax requests grant access
    if ((0, passport_service_2.isAjax)(ctx)) {
        const res = await (0, instance_service_1.getInstancesByUuid)(uuid, undefined, (0, mcsmanager_common_1.toBoolean)(advanced) || false);
        res.token = (0, passport_service_2.getToken)(ctx);
        ctx.body = res;
    }
});
// [Low-level Permission]
// Modify personal user information
router.put("/update", (0, permission_1.default)({ level: user_1.ROLE.USER }), async (ctx) => {
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    if (userUuid) {
        const config = ctx.request.body;
        const { passWord, isInit } = config;
        if (!user_service_1.default.validatePassword(passWord))
            throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.passwordCheck"));
        await user_service_1.default.edit(userUuid, { passWord, isInit });
        ctx.body = (0, passport_service_1.logout)(ctx);
    }
});
// [Low-level Permission]
// API generation and shutdown
router.put("/api", (0, permission_1.default)({ level: user_1.ROLE.USER }), async (ctx) => {
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    const enable = ctx.request.body.enable;
    const user = user_service_1.default.getInstance(userUuid);
    let newKey = "";
    try {
        if (user) {
            if (enable) {
                newKey = (0, uuid_1.v4)().replace(/-/gim, "");
                await user_service_1.default.edit(userUuid, {
                    apiKey: newKey
                });
            }
            else {
                await user_service_1.default.edit(userUuid, {
                    apiKey: ""
                });
            }
        }
        ctx.body = newKey;
    }
    catch (error) {
        ctx.body = error;
    }
});
// [Low-level Permission]
// 2FA
router.post("/bind2fa", (0, permission_1.default)({ level: 1 }), async (ctx) => {
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    if (userUuid) {
        const qrcode = await (0, passport_service_1.bind2FA)(ctx);
        ctx.body = qrcode;
    }
});
// [Low-level Permission]
// 2FA
router.post("/confirm2fa", (0, permission_1.default)({ level: 1 }), (0, validator_1.default)({ body: { enable: Boolean } }), async (ctx) => {
    const enable = Boolean(ctx.request.body.enable);
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    await (0, passport_service_1.confirm2FaQRCode)(userUuid, enable);
    ctx.body = true;
});
// [Public Permission]
router.get("/query_username", (0, permission_1.default)({ token: false, level: null }), (0, validator_1.default)({
    query: { username: String }
}), async (ctx) => {
    const userName = String(ctx.request.query.username);
    const user = (0, permission_service_1.getUserByUserName)(userName);
    if (!user) {
        ctx.body = {
            uuid: null,
            userName: null
        };
    }
    else {
        ctx.body = {
            uuid: user === null || user === void 0 ? void 0 : user.uuid,
            userName: user === null || user === void 0 ? void 0 : user.userName
        };
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/instance_admin_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const axios_1 = __importDefault(__webpack_require__("axios"));
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const path_1 = __importDefault(__webpack_require__("path"));
const const_1 = __webpack_require__("./src/app/const.ts");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const frontend_layout_1 = __webpack_require__("./src/app/service/frontend_layout.ts");
const instance_service_1 = __webpack_require__("./src/app/service/instance_service.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const password_1 = __webpack_require__("./src/app/service/password.ts");
const permission_service_1 = __webpack_require__("./src/app/service/permission_service.ts");
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const router = new router_1.default({ prefix: "/instance" });
// [Low-level Permission]
// Get the details of an instance
router.get("/", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        if (!(0, permission_service_1.isHaveInstanceByUuid)((0, passport_service_1.getUserUuid)(ctx), daemonId, instanceUuid))
            throw new Error((0, i18n_1.$t)("TXT_CODE_permission.forbidden"));
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/detail", {
            instanceUuid
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// create instance
router.post("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const config = ctx.request.body;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/new", config);
        ctx.body = result;
        operation_logger_1.operationLogger.log("instance_create", {
            daemon_id: daemonId,
            instance_id: result.instanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: result.nickname
        });
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// upload the file when creating the instance
router.post("/upload", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String, upload_dir: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        // const uploadDir = String(ctx.query.upload_dir);
        const config = ctx.request.body;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        if (!remoteService)
            throw new Error((0, i18n_1.$t)("TXT_CODE_dd559000") + ` Daemon ID: ${daemonId}`);
        const result = await new remote_command_1.default(remoteService).request("instance/new", config);
        const newInstanceUuid = result.instanceUuid;
        if (!newInstanceUuid)
            throw new Error((0, i18n_1.$t)("TXT_CODE_router.instance.createError"));
        operation_logger_1.operationLogger.log("instance_create", {
            daemon_id: daemonId,
            instance_id: newInstanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: result.nickname
        });
        // Send a cross-end file upload task to the daemon
        const addr = remoteService.config.fullAddr;
        const remoteMappings = remoteService.config.getConvertedRemoteMappings();
        const password = (0, password_1.timeUuid)();
        await new remote_command_1.default(remoteService).request("passport/register", {
            name: "upload",
            password: password,
            parameter: {
                uploadDir: ".",
                instanceUuid: newInstanceUuid
            }
        });
        ctx.body = {
            instanceUuid: newInstanceUuid,
            password,
            addr,
            remoteMappings
        };
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// Update instance information (manage users)
router.put("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const config = ctx.request.body;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/update", {
            instanceUuid,
            config
        });
        operation_logger_1.operationLogger.log("instance_config_change", {
            daemon_id: daemonId,
            instance_id: instanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: config.nickname
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// delete instance
router.delete("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { daemonId: String }, body: { uuids: Object, deleteFile: Boolean } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuids = ctx.request.body.uuids;
        const deleteFile = ctx.request.body.deleteFile;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        if (!instanceUuids || !Array.isArray(instanceUuids))
            throw new Error("Type error, invalid uuids or daemonId");
        const instanceIds = instanceUuids.map((uuid) => {
            return { instanceUuid: uuid, daemonId };
        });
        user_service_1.default.deleteUserInstances(null, instanceIds, true);
        const result = await new remote_command_1.default(remoteService).request("instance/delete", {
            instanceUuids,
            deleteFile
        });
        result.instances.forEach((e) => {
            var _a;
            operation_logger_1.operationLogger.log("instance_delete", {
                daemon_id: daemonId,
                instance_id: e.instanceUuid,
                operator_ip: ctx.ip,
                operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
                instance_name: e.nickname
            }, "error");
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// Open instance routing in batches
router.post("/multi_open", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    try {
        const instances = ctx.request.body;
        (0, instance_service_1.multiOperationForwarding)(instances, async (daemonId, instanceUuids) => {
            const remoteService = remote_service_1.default.getInstance(daemonId);
            new remote_command_1.default(remoteService)
                .request("instance/open", {
                instanceUuids
            })
                .then((e) => {
                e.instances.forEach((instance) => {
                    var _a;
                    operation_logger_1.operationLogger.log("instance_start", {
                        daemon_id: daemonId,
                        instance_id: instance.instanceUuid,
                        operator_ip: ctx.ip,
                        operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
                        instance_name: instance.nickname
                    });
                });
            })
                .catch(() => { });
        });
        ctx.body = true;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
//Close instance routing in batches
router.post("/multi_stop", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    try {
        const instances = ctx.request.body;
        (0, instance_service_1.multiOperationForwarding)(instances, async (daemonId, instanceUuids) => {
            const remoteService = remote_service_1.default.getInstance(daemonId);
            new remote_command_1.default(remoteService)
                .request("instance/stop", {
                instanceUuids
            })
                .then((e) => {
                e.instances.forEach((instance) => {
                    var _a;
                    operation_logger_1.operationLogger.log("instance_stop", {
                        daemon_id: daemonId,
                        instance_id: instance.instanceUuid,
                        operator_ip: ctx.ip,
                        operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
                        instance_name: instance.nickname
                    });
                });
            })
                .catch(() => { });
        });
        ctx.body = true;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// batch terminate instance routing
router.post("/multi_kill", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    try {
        const instances = ctx.request.body;
        (0, instance_service_1.multiOperationForwarding)(instances, async (daemonId, instanceUuids) => {
            const remoteService = remote_service_1.default.getInstance(daemonId);
            new remote_command_1.default(remoteService)
                .request("instance/kill", { instanceUuids })
                .then((e) => {
                e.instances.forEach((instance) => {
                    var _a;
                    operation_logger_1.operationLogger.warning("instance_kill", {
                        daemon_id: daemonId,
                        instance_id: instance.instanceUuid,
                        operator_ip: ctx.ip,
                        operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
                        instance_name: instance.nickname
                    });
                });
            })
                .catch((err) => { });
        });
        ctx.body = true;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// restart instance routing in batches
router.post("/multi_restart", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    try {
        const instances = ctx.request.body;
        (0, instance_service_1.multiOperationForwarding)(instances, async (daemonId, instanceUuids) => {
            const remoteService = remote_service_1.default.getInstance(daemonId);
            new remote_command_1.default(remoteService)
                .request("instance/restart", { instanceUuids })
                .then((e) => {
                e.instances.forEach((instance) => {
                    var _a;
                    operation_logger_1.operationLogger.log("instance_restart", {
                        daemon_id: daemonId,
                        instance_id: instance.instanceUuid,
                        operator_ip: ctx.ip,
                        operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
                        instance_name: instance.nickname
                    });
                });
            })
                .catch((err) => { });
        });
        ctx.body = true;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Top-level Permission]
// Get quick install list
router.get("/quick_install_list", (0, permission_1.default)({ level: user_1.ROLE.USER }), async (ctx) => {
    if ((setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.allowUsePreset) === false && !(0, permission_service_1.isTopPermissionByUuid)((0, passport_service_1.getUserUuid)(ctx))) {
        ctx.status = 403;
        ctx.body = new Error((0, i18n_1.$t)("TXT_CODE_b5a47731"));
        return;
    }
    const ADDR = setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.presetPackAddr;
    try {
        if (ADDR === null || ADDR === void 0 ? void 0 : ADDR.startsWith(frontend_layout_1.SAVE_DIR_PATH)) {
            const filesDir = path_1.default.join(process.cwd(), frontend_layout_1.SAVE_DIR_PATH);
            const fileName = ADDR === null || ADDR === void 0 ? void 0 : ADDR.split(frontend_layout_1.SAVE_DIR_PATH)[1];
            const filePath = path_1.default.join(filesDir, fileName !== null && fileName !== void 0 ? fileName : "");
            if (fs_extra_1.default.existsSync(filePath)) {
                ctx.body = JSON.parse(await fs_extra_1.default.readFile(filePath, "utf-8"));
            }
            else {
                throw new Error(`Request failed, status: 404`);
            }
            return;
        }
        // Cache logic implementation
        const CACHE_DURATION = 12 * 60 * 60 * 1000; // 12 hours
        // Check if cache file exists and is valid
        try {
            const stats = await fs_extra_1.default.stat(const_1.MARKET_CACHE_FILE_PATH);
            const now = Date.now();
            const fileAge = now - stats.mtime.getTime();
            // Use cache
            if (fileAge < CACHE_DURATION) {
                const cachedData = await fs_extra_1.default.readFile(const_1.MARKET_CACHE_FILE_PATH, "utf-8");
                ctx.body = JSON.parse(cachedData);
                return;
            }
        }
        catch (error) {
            // Cache file doesn't exist, continue to fetch new data
        }
        const res = await axios_1.default.request({
            method: "GET",
            url: ADDR
        });
        if (res.status !== 200)
            throw new Error(`Request failed, status: ${res.status}`);
        ctx.body = res.data;
        // Save to cache file
        fs_extra_1.default.writeFile(const_1.MARKET_CACHE_FILE_PATH, JSON.stringify(res.data), "utf-8").catch((err) => {
            log_1.logger.warn(`Failed to write quick install cache file at ${const_1.MARKET_CACHE_FILE_PATH}: ${err}`);
        });
    }
    catch (err) {
        ctx.body = [];
    }
});
// [Top-level Permission]
// forward request
router.all("/forward", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { target: String } }), async (ctx) => {
    const ADDR = String(ctx.query.target);
    try {
        const response = await axios_1.default.request({
            method: ctx.request.method,
            url: ADDR,
            data: ctx.request.body
        });
        if (response.status !== 200)
            throw new Error("Response code != 200");
        ctx.body = response.data;
    }
    catch (err) {
        ctx.body = [];
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/instance_exchange_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const exchange_service_1 = __webpack_require__("./src/app/service/exchange_service.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const user_sso_service_1 = __importDefault(__webpack_require__("./src/app/service/user_sso_service.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const sync_1 = __webpack_require__("./src/app/utils/sync.ts");
const router = new router_1.default({ prefix: "/exchange" });
router.post("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({
    body: {
        request_action: String
    }
}), async (ctx) => {
    var _a;
    try {
        const requestAction = (0, mcsmanager_common_1.toText)(ctx.request.body.request_action);
        const params = (_a = ctx.request.body.data) !== null && _a !== void 0 ? _a : {};
        log_1.logger.info("Get exchange request, action: %s, params: %j", requestAction, params);
        if (requestAction === exchange_service_1.RequestAction.PING) {
            ctx.body = await (0, exchange_service_1.getNodeStatus)(params);
            return;
        }
        if ([exchange_service_1.RequestAction.RENEW, exchange_service_1.RequestAction.BUY].includes(requestAction)) {
            ctx.body = await (0, exchange_service_1.buyOrRenewInstance)(requestAction, params);
            return;
        }
        if (requestAction === exchange_service_1.RequestAction.QUERY_INSTANCE) {
            ctx.body = await (0, exchange_service_1.queryInstanceByUserId)(params);
            return;
        }
        if (requestAction === exchange_service_1.RequestAction.SSO_TOKEN) {
            ctx.body = user_sso_service_1.default.generateSSOToken((0, exchange_service_1.parseUserName)(params === null || params === void 0 ? void 0 : params.username));
            return;
        }
    }
    catch (err) {
        log_1.logger.error("Exchange request error: " + err);
        ctx.body = err;
    }
});
router.get("/sso", (0, permission_1.default)({ token: false, level: null }), (0, validator_1.default)({
    query: { username: String, token: String, instanceId: String, daemonId: String, origin: String }
}), async (ctx) => {
    const userName = (0, exchange_service_1.parseUserName)(String(ctx.request.query.username));
    const token = String(ctx.request.query.token);
    const redirect = `${decodeURIComponent(String(ctx.request.query.origin))}/#/instances/terminal?daemonId=${ctx.request.query.daemonId}&instanceId=${ctx.request.query.instanceId}&from=sso`;
    if (user_sso_service_1.default.verifySSOToken(userName, token)) {
        log_1.logger.warn("SSO login: username: %s, token: %s, redirect: %s", userName, token, redirect);
        (0, passport_service_1.loginSuccess)(ctx, userName);
        return ctx.redirect(redirect);
    }
    else {
        throw new Error((0, i18n_1.$t)("TXT_CODE_13411df7"));
    }
});
router.post("/request_buy_instance", (0, permission_1.default)({ token: false, level: null }), (0, validator_1.default)({
    body: {
        productId: Number,
        daemonId: String,
        code: String
    }
}), async (ctx) => {
    var _a, _b, _c, _d, _e;
    const panelId = (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.panelId) || "";
    const registerCode = (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.registerCode) || "";
    const productId = (_a = (0, mcsmanager_common_1.toNumber)(ctx.request.body.productId)) !== null && _a !== void 0 ? _a : 0;
    const daemonId = (_b = (0, mcsmanager_common_1.toText)(ctx.request.body.daemonId)) !== null && _b !== void 0 ? _b : "";
    const code = (_c = (0, mcsmanager_common_1.toText)(ctx.request.body.code)) !== null && _c !== void 0 ? _c : "";
    // Optional
    const instanceId = (_d = (0, mcsmanager_common_1.toText)(ctx.request.body.instanceId)) !== null && _d !== void 0 ? _d : "";
    const username = (_e = (0, mcsmanager_common_1.toText)(ctx.request.body.username)) !== null && _e !== void 0 ? _e : "";
    const response = await (0, sync_1.execWithMutexId)(`buy-${code}`, async () => {
        // First, check if the redeem code is valid
        const productInfo = await (0, exchange_service_1.requestUseRedeem)(panelId, registerCode, productId, daemonId, code, false);
        const hours = productInfo === null || productInfo === void 0 ? void 0 : productInfo.hours;
        if (!hours || !(productInfo === null || productInfo === void 0 ? void 0 : productInfo.payload)) {
            throw new Error((0, i18n_1.$t)("TXT_CODE_45d7b982"));
        }
        const { config } = JSON.parse(productInfo.payload);
        log_1.logger.info(`Router /request_buy_instance Report: Product: ${JSON.stringify(productInfo)}`);
        if (!config || !productId) {
            throw new Error((0, i18n_1.$t)("TXT_CODE_c92156bb"));
        }
        const params = {
            category_id: productId,
            payload: config,
            username: username,
            node_id: daemonId,
            hours: hours,
            instance_id: instanceId,
            code: code
        };
        try {
            return await (0, exchange_service_1.buyOrRenewInstance)(instanceId ? exchange_service_1.RequestAction.RENEW : exchange_service_1.RequestAction.BUY, params, {
                onCreateConfirm: async () => {
                    // Then, delete the redeem code
                    await (0, exchange_service_1.requestUseRedeem)(panelId, registerCode, productId, daemonId, code, true);
                }
            });
        }
        catch (error) {
            log_1.logger.error((0, i18n_1.$t)("TXT_CODE_55b1f20e"), error);
            throw error;
        }
    });
    ctx.body = response;
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/instance_operate_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const axios_1 = __importDefault(__webpack_require__("axios"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const limit_1 = __webpack_require__("./src/app/middleware/limit.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const instance_service_1 = __webpack_require__("./src/app/service/instance_service.ts");
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const password_1 = __webpack_require__("./src/app/service/password.ts");
const permission_service_1 = __webpack_require__("./src/app/service/permission_service.ts");
const remote_command_1 = __importStar(__webpack_require__("./src/app/service/remote_command.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const router = new router_1.default({ prefix: "/protected_instance" });
// Routing permission verification middleware
router.use(async (ctx, next) => {
    const instanceUuid = String(ctx.query.uuid);
    const daemonId = String(ctx.query.daemonId);
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    if ((0, permission_service_1.isHaveInstanceByUuid)(userUuid, daemonId, instanceUuid)) {
        await next();
    }
    else {
        ctx.status = 403;
        ctx.body = (0, i18n_1.$t)("TXT_CODE_permission.forbiddenInstance");
    }
});
// [Low-level Permission]
// Enable instance routing
router.all("/open", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    var _a, _b, _c;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/open", {
            instanceUuids: [instanceUuid]
        });
        operation_logger_1.operationLogger.log("instance_start", {
            daemon_id: daemonId,
            instance_id: instanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: (_c = (_b = result === null || result === void 0 ? void 0 : result.instances) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.nickname
        });
        ctx.body = result;
    }
    catch (err) {
        if (err instanceof remote_command_1.RemoteRequestTimeoutError) {
            ctx.body = {};
            return;
        }
        ctx.body = err;
    }
});
// [Low-level Permission]
// The instance closes the route
router.all("/stop", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    var _a, _b, _c;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/stop", {
            instanceUuids: [instanceUuid]
        });
        operation_logger_1.operationLogger.log("instance_stop", {
            daemon_id: daemonId,
            instance_id: instanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: (_c = (_b = result === null || result === void 0 ? void 0 : result.instances) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.nickname
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Send the command route to the instance
// At this stage, WS cross-panel command transfer has been implemented, and this interface is reserved as an API interface
router.all("/command", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String, command: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const command = String(ctx.query.command);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/command", {
            instanceUuid,
            command
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// restart the instance
router.all("/restart", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    var _a, _b, _c;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/restart", {
            instanceUuids: [instanceUuid]
        });
        operation_logger_1.operationLogger.log("instance_restart", {
            daemon_id: daemonId,
            instance_id: instanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: (_c = (_b = result === null || result === void 0 ? void 0 : result.instances) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.nickname
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// terminate the instance
router.all("/kill", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    var _a, _b, _c;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/kill", {
            instanceUuids: [instanceUuid]
        });
        operation_logger_1.operationLogger.warning("instance_kill", {
            daemon_id: daemonId,
            instance_id: instanceUuid,
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_name: (_c = (_b = result === null || result === void 0 ? void 0 : result.instances) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.nickname
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// start asynchronous task
router.post("/asynchronous", (0, limit_1.speedLimit)(3), (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String, task_name: String },
    body: {}
}), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const taskName = String(ctx.query.task_name).toLowerCase().trim();
        const parameter = ctx.request.body;
        // some asynchronous tasks are only allowed for administrators
        const needTopPermissionTask = ["quick_install"];
        if (needTopPermissionTask.includes(taskName) &&
            !(0, permission_service_1.isTopPermissionByUuid)((_a = ctx.session) === null || _a === void 0 ? void 0 : _a["uuid"])) {
            throw new Error("illegal access");
        }
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/asynchronous", {
            instanceUuid,
            taskName,
            parameter
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// stop an asynchronous task
router.all("/stop_asynchronous", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String }
}), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const parameter = ctx.request.body;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        // No permission check is required because "Parameter.TaskId" is not easily obtained.
        const result = await new remote_command_1.default(remoteService).request("instance/stop_asynchronous", {
            instanceUuid,
            parameter
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// query asynchronous task status
router.all("/query_asynchronous", (0, permission_1.default)({ level: user_1.ROLE.ADMIN, speedLimit: false }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String }
}), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const taskName = String(ctx.query.task_name);
        const parameter = ctx.request.body;
        const taskId = parameter.taskId;
        // Must have administrator to query all asynchronous tasks
        if (!taskId && !(0, permission_service_1.isTopPermissionByUuid)((0, passport_service_1.getUserUuid)(ctx))) {
            throw new Error("Unauthorized access");
        }
        const remoteService = remote_service_1.default.getInstance(daemonId);
        ctx.body = await new remote_command_1.default(remoteService).request("instance/query_asynchronous", {
            instanceUuid,
            taskName,
            parameter
        });
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Request to establish a data stream dedicated channel with the daemon
router.post("/stream_channel", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        if (!remoteService)
            throw new Error((0, i18n_1.$t)("TXT_CODE_dd559000") + ` Daemon ID: ${daemonId}`);
        const addr = remoteService.config.addr;
        const prefix = remoteService.config.prefix;
        const remoteMappings = remoteService.config.getConvertedRemoteMappings();
        const password = (0, password_1.timeUuid)();
        await new remote_command_1.default(remoteService).request("passport/register", {
            name: "stream_channel",
            password: password,
            parameter: {
                instanceUuid
            }
        });
        ctx.body = {
            password,
            addr,
            prefix,
            remoteMappings,
        };
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Get the instance configuration file list based on the file list
router.post("/process_config/list", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const files = ctx.request.body.files;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/process_config/list", {
            instanceUuid,
            files
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Get the content of the specified configuration file
router.get("/process_config/file", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String, fileName: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const fileName = String(ctx.query.fileName);
        const type = String(ctx.query.type);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/process_config/file", {
            instanceUuid,
            fileName,
            config: null,
            type
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Update the content of the specified configuration file
router.put("/process_config/file", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String, fileName: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const fileName = String(ctx.query.fileName);
        const type = String(ctx.query.type);
        const config = ctx.request.body;
        const remoteService = remote_service_1.default.getInstance(daemonId);
        const result = await new remote_command_1.default(remoteService).request("instance/process_config/file", {
            instanceUuid,
            fileName,
            config,
            type
        });
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Update instance low-privilege configuration data (normal user)
router.put("/instance_update", (0, limit_1.speedLimit)(3), (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({
    query: { uuid: String, daemonId: String },
    body: {}
}), async (ctx) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    try {
        // Here is the low-privileged user configuration setting interface,
        // in order to prevent data injection, a layer of filtering must be performed
        const daemonId = (0, mcsmanager_common_1.toText)(ctx.query.daemonId);
        const instanceUuid = (0, mcsmanager_common_1.toText)(ctx.query.uuid);
        const config = ctx.request.body;
        let instanceTags = null;
        if (config.tag instanceof Array && (0, permission_service_1.isTopPermissionByUuid)((0, passport_service_1.getUserUuid)(ctx))) {
            instanceTags = config.tag.map((tag) => {
                const tmp = String(tag).trim();
                if (tmp.length > 20)
                    throw new Error((0, i18n_1.$t)("TXT_CODE_1556989"));
                return tmp;
            });
            if (instanceTags.length > 6) {
                throw new Error((0, i18n_1.$t)("TXT_CODE_dc9fb6ce"));
            }
            instanceTags = instanceTags.sort((a, b) => (a > b ? 1 : -1));
        }
        // Steam Rcon configuration
        const rconIp = (0, mcsmanager_common_1.toText)(config.rconIp);
        const rconPort = (0, mcsmanager_common_1.toNumber)(config.rconPort);
        const rconPassword = (0, mcsmanager_common_1.toText)(config.rconPassword);
        const enableRcon = (0, mcsmanager_common_1.toBoolean)(config.enableRcon);
        // Ping protocol configuration
        const pingConfig = {
            ip: (0, mcsmanager_common_1.toText)((_a = config.pingConfig) === null || _a === void 0 ? void 0 : _a.ip),
            port: (0, mcsmanager_common_1.toNumber)((_b = config.pingConfig) === null || _b === void 0 ? void 0 : _b.port),
            type: (_c = config.pingConfig) === null || _c === void 0 ? void 0 : _c.type
        };
        // event task configuration
        const eventTask = {
            autoStart: (0, mcsmanager_common_1.toBoolean)((_d = config.eventTask) === null || _d === void 0 ? void 0 : _d.autoStart),
            autoRestart: (0, mcsmanager_common_1.toBoolean)((_e = config.eventTask) === null || _e === void 0 ? void 0 : _e.autoRestart),
            autoRestartMaxTimes: (0, mcsmanager_common_1.toNumber)((_f = config.eventTask) === null || _f === void 0 ? void 0 : _f.autoRestartMaxTimes)
        };
        // web terminal settings
        const terminalOption = {
            haveColor: (0, mcsmanager_common_1.toBoolean)((_g = config.terminalOption) === null || _g === void 0 ? void 0 : _g.haveColor),
            pty: (0, mcsmanager_common_1.toBoolean)((_h = config.terminalOption) === null || _h === void 0 ? void 0 : _h.pty),
            ptyWindowCol: (0, mcsmanager_common_1.toNumber)((_j = config.terminalOption) === null || _j === void 0 ? void 0 : _j.ptyWindowCol),
            ptyWindowRow: (0, mcsmanager_common_1.toNumber)((_k = config.terminalOption) === null || _k === void 0 ? void 0 : _k.ptyWindowRow)
        };
        // extra service
        const extraServiceConfig = {
            openFrpTunnelId: (0, mcsmanager_common_1.toText)((_l = config.extraServiceConfig) === null || _l === void 0 ? void 0 : _l.openFrpTunnelId),
            openFrpToken: (0, mcsmanager_common_1.toText)((_m = config.extraServiceConfig) === null || _m === void 0 ? void 0 : _m.openFrpToken)
        };
        const crlf = !(0, mcsmanager_common_1.isEmpty)(config.crlf) ? (0, mcsmanager_common_1.toNumber)(config === null || config === void 0 ? void 0 : config.crlf) : null;
        const oe = !(0, mcsmanager_common_1.isEmpty)(config.oe) ? (0, mcsmanager_common_1.toText)(config === null || config === void 0 ? void 0 : config.oe) : null;
        const ie = !(0, mcsmanager_common_1.isEmpty)(config.ie) ? (0, mcsmanager_common_1.toText)(config === null || config === void 0 ? void 0 : config.ie) : null;
        const fileCode = (0, mcsmanager_common_1.toText)(config.fileCode);
        const stopCommand = config.stopCommand ? (0, mcsmanager_common_1.toText)(config.stopCommand) : null;
        const remoteService = remote_service_1.default.getInstance(daemonId || "");
        const isTopPermission = (0, permission_service_1.isTopPermissionByUuid)((0, passport_service_1.getUserUuid)(ctx));
        let advancedConfig = {};
        advancedConfig = (0, instance_service_1.checkInstanceAdvancedParams)(config, isTopPermission);
        new remote_command_1.default(remoteService).request("instance/update", {
            instanceUuid,
            config: {
                pingConfig: !(0, mcsmanager_common_1.isEmpty)(config.pingConfig) ? pingConfig : null,
                eventTask: !(0, mcsmanager_common_1.isEmpty)(config.eventTask) ? eventTask : null,
                terminalOption: !(0, mcsmanager_common_1.isEmpty)(config.terminalOption) ? terminalOption : null,
                extraServiceConfig: !(0, mcsmanager_common_1.isEmpty)(config.extraServiceConfig) ? extraServiceConfig : null,
                crlf,
                oe,
                ie,
                stopCommand,
                rconIp,
                rconPort,
                rconPassword,
                enableRcon,
                tag: instanceTags,
                fileCode,
                ...advancedConfig
            }
        });
        ctx.body = true;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Get the terminal log of an instance
router.get("/outputlog", (0, permission_1.default)({ level: user_1.ROLE.USER, speedLimit: false }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const remoteService = remote_service_1.default.getInstance(daemonId);
        let result = await new remote_command_1.default(remoteService).request("instance/outputlog", {
            instanceUuid
        });
        if (ctx.query.size) {
            let size, sizeStr = ctx.query.size;
            if (sizeStr instanceof Array) {
                sizeStr = sizeStr[0];
            }
            size = parseInt(sizeStr);
            if (sizeStr.toLowerCase().endsWith("kb")) {
                size *= 1024;
            }
            if (result.length > size) {
                result = result.slice(-size);
            }
        }
        ctx.body = result;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// Reinstall the instance
router.post("/install_instance", (0, limit_1.speedLimit)(3), (0, permission_1.default)({ level: user_1.ROLE.USER, speedLimit: true }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String },
    body: { description: String, title: String }
}), async (ctx) => {
    if ((setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.allowUsePreset) === false && !(0, permission_service_1.isTopPermissionByUuid)((0, passport_service_1.getUserUuid)(ctx))) {
        ctx.status = 403;
        ctx.body = new Error((0, i18n_1.$t)("TXT_CODE_b5a47731"));
        return;
    }
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        // Use "description" and "title" as Package ID
        // Do NOT use other parameters from frontend, it may be a malicious attack
        const description = String(ctx.request.body.description);
        const title = String(ctx.request.body.title);
        const presetUrl = setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.presetPackAddr;
        if (!presetUrl)
            throw new Error("Preset Addr is empty!");
        const { data: presetConfig } = await (0, axios_1.default)({
            url: presetUrl,
            method: "GET"
        });
        const packages = presetConfig.packages;
        if (!(packages instanceof Array))
            throw new Error("Preset Config is not array!");
        // Find the target preset config
        const targetPresetConfig = packages.find((v) => v.title === title && v.description === description);
        if (!targetPresetConfig)
            throw new Error("Preset Config is not found!");
        const remoteService = remote_service_1.default.getInstance(daemonId);
        new remote_command_1.default(remoteService).request("instance/asynchronous", {
            taskName: "install_instance",
            instanceUuid,
            parameter: targetPresetConfig
        });
        ctx.body = true;
    }
    catch (err) {
        ctx.body = err;
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/login_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const setting_1 = __webpack_require__("./src/app/setting.ts");
const user_service_1 = __importStar(__webpack_require__("./src/app/service/user_service.ts"));
const log_1 = __webpack_require__("./src/app/service/log.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const axios_1 = __importDefault(__webpack_require__("axios"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const router = new router_1.default({ prefix: "/auth" });
// [Public Permission]
// login route
router.post("/login", (0, permission_1.default)({ token: false, level: null }), (0, validator_1.default)({ body: { username: String, password: String } }), async (ctx) => {
    const userName = String(ctx.request.body.username);
    const passWord = String(ctx.request.body.password);
    const code = String(ctx.request.body.code);
    if (!(0, passport_service_1.checkBanIp)(ctx))
        throw new Error((0, i18n_1.$t)("TXT_CODE_router.login.ban"));
    if ((0, passport_service_1.check)(ctx))
        return (ctx.body = "Logined");
    try {
        ctx.body = (0, passport_service_1.login)(ctx, userName, passWord, code);
        operation_logger_1.operationLogger.info("user_login", {
            operator_ip: ctx.ip,
            operator_name: userName,
            login_result: true
        });
    }
    catch (error) {
        if (error instanceof user_service_1.TwoFactorError && !code) {
            ctx.body = "NEED_2FA";
            return;
        }
        ctx.body = error;
        operation_logger_1.operationLogger.warning("user_login", {
            operator_ip: ctx.ip,
            operator_name: userName,
            login_result: false
        });
    }
});
// [Public Permission]
// exit route
router.get("/logout", (0, permission_1.default)({ token: false, level: null, speedLimit: false }), async (ctx) => {
    (0, passport_service_1.logout)(ctx);
    ctx.body = true;
});
// [Public Permission]
// Display the text of the login interface
router.all("/login_info", (0, permission_1.default)({ token: false, level: null, speedLimit: false }), async (ctx) => {
    ctx.body = {
        loginInfo: setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.loginInfo
    };
});
// [Public Permission]
// Get the state information that the panel can expose
router.all("/status", (0, permission_1.default)({ token: false, level: null, speedLimit: false }), async (ctx) => {
    let isInstall = true;
    if (user_service_1.default.objects.size === 0) {
        isInstall = false;
    }
    ctx.body = {
        versionChange: mcsmanager_common_1.GlobalVariable.get("versionChange", null),
        isInstall,
        language: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.language) || null,
        settings: {
            canFileManager: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.canFileManager) || false,
            allowUsePreset: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.allowUsePreset) || false,
            businessMode: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.businessMode) || false,
            businessId: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.businessId) || null,
            allowChangeCmd: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.allowChangeCmd) || false,
            panelId: (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.panelId) || null
        }
    };
});
// [Public Permission]
// Install the panel, only available when the number of user entities is 0
router.all("/install", (0, permission_1.default)({ token: false, level: null }), (0, validator_1.default)({ body: { username: String, password: String } }), async (ctx) => {
    const userName = String(ctx.request.body.username);
    const passWord = String(ctx.request.body.password);
    if (user_service_1.default.objects.size === 0) {
        if (!user_service_1.default.validatePassword(passWord))
            throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.passwordCheck"));
        log_1.logger.info((0, i18n_1.$t)("TXT_CODE_router.login.init", { userName }));
        await user_service_1.default.create({
            userName,
            passWord,
            permission: 10
        });
        operation_logger_1.operationLogger.log("user_create", {
            operator_ip: ctx.ip,
            operator_name: userName,
            target_user_name: userName
        });
        (0, passport_service_1.login)(ctx, userName, passWord);
        return (ctx.body = true);
    }
    throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.installed"));
});
router.all("/proxy", (0, validator_1.default)({ query: { target: String } }), (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    try {
        const response = await axios_1.default.request({
            method: ctx.query.method || ctx.method,
            url: String(ctx.query.target)
        });
        if (response.status !== 200)
            throw new Error("Response code != 200");
        ctx.body = response.data;
    }
    catch (err) {
        ctx.body = err;
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/manage_user_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const router = new router_1.default({ prefix: "/auth" });
// Add user
router.post("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ body: { username: String, password: String, permission: Number } }), async (ctx) => {
    var _a;
    const userName = String(ctx.request.body.username);
    const passWord = String(ctx.request.body.password);
    const permission = Number(ctx.request.body.permission);
    if (!user_service_1.default.validatePassword(passWord))
        throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.invalidPassword"));
    if (user_service_1.default.existUserName(userName))
        throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.existsUserName"));
    operation_logger_1.operationLogger.log("user_create", {
        operator_ip: ctx.ip,
        operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
        target_user_name: userName
    });
    ctx.body = await (0, passport_service_1.register)(ctx, userName, passWord, permission);
});
// Delete user
router.del("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    var _a;
    const uuids = ctx.request.body;
    try {
        for (const iterator of uuids) {
            const user = user_service_1.default.getUserByUuid(iterator);
            operation_logger_1.operationLogger.log("user_delete", {
                operator_ip: ctx.ip,
                operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
                target_user_name: (user === null || user === void 0 ? void 0 : user.userName) || "Unknown"
            }, "warning");
            await user_service_1.default.deleteInstance(iterator);
        }
        ctx.body = true;
    }
    catch (error) {
        ctx.throw(500, (0, i18n_1.$t)("TXT_CODE_router.user.deleteFailure"));
    }
});
// User search function
router.get("/search", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), (0, validator_1.default)({ query: { page: Number, page_size: Number } }), async (ctx) => {
    const userName = String(ctx.query.userName);
    const role = String(ctx.query.role);
    const page = Number(ctx.query.page);
    const pageSize = Number(ctx.query.page_size);
    const condition = {};
    if (userName)
        condition["userName"] = `%${userName}%`;
    if (role)
        condition["permission"] = Number(role);
    let resultPage = user_service_1.default.getQueryWrapper().selectPage(condition, page, pageSize);
    // make a copy, delete redundant
    resultPage = JSON.parse(JSON.stringify(resultPage));
    resultPage.data.forEach((v) => {
        v.passWord = "";
        v.salt = "";
    });
    ctx.body = resultPage;
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/overview_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const os_1 = __importDefault(__webpack_require__("os"));
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const visual_data_1 = __importDefault(__webpack_require__("./src/app/service/visual_data.ts"));
const version_1 = __webpack_require__("./src/app/version.ts");
const router = new router_1.default({ prefix: "/overview" });
// [Top-level Permission]
// Control panel home page information overview routing
router.get("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN, token: false }), async (ctx) => {
    // Get the information of the remote service concurrently
    const requestTasks = Array.from(remote_service_1.default.services.entries()).map(async ([_, remoteService]) => {
        let remoteInfo = {};
        try {
            remoteInfo = await new remote_command_1.default(remoteService).request("info/overview");
        }
        catch (err) {
            // ignore request errors and continue looping
        }
        // assign some identifier value
        remoteInfo.uuid = remoteService.uuid;
        remoteInfo.ip = remoteService.config.ip;
        remoteInfo.port = remoteService.config.port;
        remoteInfo.prefix = remoteService.config.prefix;
        remoteInfo.available = remoteService.available;
        remoteInfo.remarks = remoteService.config.remarks;
        remoteInfo.remoteMappings = remoteService.config.remoteMappings;
        return remoteInfo;
    });
    const remoteInfoList = await Promise.all(requestTasks);
    const selfInfo = (0, mcsmanager_common_1.systemInfo)();
    // Get the information of the system where the panel is located
    const overviewData = {
        version: (0, version_1.getVersion)(),
        specifiedDaemonVersion: (0, version_1.specifiedDaemonVersion)(),
        process: {
            cpu: selfInfo.processCpu,
            memory: process.memoryUsage().rss,
            cwd: selfInfo.cwd
        },
        record: {
            logined: mcsmanager_common_1.GlobalVariable.get(passport_service_1.LOGIN_COUNT, 0),
            illegalAccess: mcsmanager_common_1.GlobalVariable.get(passport_service_1.ILLEGAL_ACCESS_KEY, 0),
            banips: mcsmanager_common_1.GlobalVariable.get(passport_service_1.BAN_IP_COUNT, 0),
            loginFailed: mcsmanager_common_1.GlobalVariable.get(passport_service_1.LOGIN_FAILED_COUNT_KEY, 0)
        },
        system: {
            user: os_1.default.userInfo(),
            time: new Date().getTime(),
            totalmem: selfInfo.totalmem,
            freemem: selfInfo.freemem,
            type: selfInfo.type,
            version: os_1.default.version(),
            node: process.version,
            hostname: selfInfo.hostname,
            loadavg: selfInfo.loadavg,
            platform: selfInfo.platform,
            release: selfInfo.release,
            uptime: os_1.default.uptime(),
            cpu: selfInfo.cpuUsage
        },
        chart: {
            system: visual_data_1.default.getSystemChartArray(),
            request: visual_data_1.default.getStatusChartArray()
        },
        remoteCount: remote_service_1.default.count(),
        remote: remoteInfoList
    };
    ctx.body = overviewData;
});
// [Top-level Permission]
// Get user operation logs
router.get("/operation_logs", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    var _a;
    const limit = +(((_a = ctx === null || ctx === void 0 ? void 0 : ctx.query) === null || _a === void 0 ? void 0 : _a.limit) || 20);
    if (isNaN(limit))
        return ctx.throw(400, "Invalid limit value. It must be a number.");
    if (limit <= 0 || limit > 200)
        return ctx.throw(400, "Invalid limit value. It must be between 1 and 200.");
    ctx.body = await operation_logger_1.operationLogger.get(limit);
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/schedule_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const validator_1 = __importDefault(__webpack_require__("./src/app/middleware/validator.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const passport_service_1 = __webpack_require__("./src/app/service/passport_service.ts");
const permission_service_1 = __webpack_require__("./src/app/service/permission_service.ts");
const const_1 = __webpack_require__("./src/app/const.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const router = new router_1.default({ prefix: "/protected_schedule" });
// Routing permission verification middleware
router.use(async (ctx, next) => {
    const instanceUuid = String(ctx.query.uuid);
    const daemonId = String(ctx.query.daemonId);
    const userUuid = (0, passport_service_1.getUserUuid)(ctx);
    if ((0, permission_service_1.isHaveInstanceByUuid)(userUuid, daemonId, instanceUuid)) {
        await next();
    }
    else {
        ctx.status = 403;
        ctx.body = (0, i18n_1.$t)("TXT_CODE_permission.forbiddenInstance");
    }
});
// [Low-level Permission]
// Get the list of scheduled tasks
router.get("/", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const list = await new remote_command_1.default(remote_service_1.default.getInstance(daemonId)).request("schedule/list", {
            instanceUuid
        });
        ctx.body = list;
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// create a scheduled task
router.post("/", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({
    query: { daemonId: String, uuid: String },
    body: { name: String, count: Number, time: String, action: String, type: Number }
}), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const task = ctx.request.body;
        // Scheduled task name needs file name format check
        const name = String(task.name);
        const_1.FILENAME_BLACKLIST.forEach((ch) => {
            if (name.includes(ch))
                throw new Error((0, i18n_1.$t)("TXT_CODE_router.schedule.invalidName"));
        });
        operation_logger_1.operationLogger.log("instance_task_create", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_id: instanceUuid,
            daemon_id: daemonId,
            task_name: name
        });
        ctx.body = await new remote_command_1.default(remote_service_1.default.getInstance(daemonId)).request("schedule/register", {
            instanceUuid,
            name,
            count: Number(task.count),
            time: String(task.time),
            action: String(task.action),
            payload: String(task.payload),
            type: Number(task.type)
        });
    }
    catch (err) {
        ctx.body = err;
    }
});
// [Low-level Permission]
// delete scheduled task
router.delete("/", (0, permission_1.default)({ level: user_1.ROLE.USER }), (0, validator_1.default)({ query: { daemonId: String, uuid: String } }), async (ctx) => {
    var _a;
    try {
        const daemonId = String(ctx.query.daemonId);
        const instanceUuid = String(ctx.query.uuid);
        const name = String(ctx.query.task_name);
        operation_logger_1.operationLogger.log("instance_task_delete", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"],
            instance_id: instanceUuid,
            daemon_id: daemonId,
            task_name: name
        });
        ctx.body = await new remote_command_1.default(remote_service_1.default.getInstance(daemonId)).request("schedule/delete", {
            instanceUuid,
            name
        });
    }
    catch (err) {
        ctx.body = err;
    }
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/settings_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const fs = __importStar(__webpack_require__("fs-extra"));
const path_1 = __importDefault(__webpack_require__("path"));
const uuid_1 = __webpack_require__("uuid");
const system_file_1 = __importDefault(__webpack_require__("../daemon/src/service/system_file.ts"));
const const_1 = __webpack_require__("./src/app/const.ts");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const limit_1 = __webpack_require__("./src/app/middleware/limit.ts");
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const frontend_layout_1 = __webpack_require__("./src/app/service/frontend_layout.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const operation_logger_1 = __webpack_require__("./src/app/service/operation_logger.ts");
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const version_1 = __webpack_require__("./src/app/version.ts");
const router = new router_1.default({ prefix: "/overview" });
// [Top-level Permission]
// Get panel configuration items
router.get("/setting", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    ctx.body = setting_1.systemConfig;
});
// [Top-level Permission]
// Update panel configuration items
router.put("/setting", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    var _a;
    const config = ctx.request.body;
    if (config && setting_1.systemConfig) {
        if (config.httpIp != null)
            setting_1.systemConfig.httpIp = config.httpIp;
        if (config.httpPort != null)
            setting_1.systemConfig.httpPort = config.httpPort;
        if (config.prefix != null)
            setting_1.systemConfig.prefix = config.prefix;
        if (config.reverseProxyMode != null) {
            setting_1.systemConfig.reverseProxyMode = Boolean(config.reverseProxyMode);
            ctx.app.proxy = setting_1.systemConfig.reverseProxyMode;
        }
        if (config.crossDomain != null)
            setting_1.systemConfig.crossDomain = config.crossDomain;
        if (config.gzip != null)
            setting_1.systemConfig.gzip = config.gzip;
        if (config.maxCompress != null)
            setting_1.systemConfig.maxCompress = config.maxCompress;
        if (config.maxDownload != null)
            setting_1.systemConfig.maxDownload = config.maxDownload;
        if (config.zipType != null)
            setting_1.systemConfig.zipType = config.zipType;
        if (config.totpDriftToleranceSteps != null)
            setting_1.systemConfig.totpDriftToleranceSteps = config.totpDriftToleranceSteps;
        if (config.loginCheckIp != null)
            setting_1.systemConfig.loginCheckIp = config.loginCheckIp;
        if (config.forwardType != null)
            setting_1.systemConfig.forwardType = Number(config.forwardType);
        if (config.dataPort != null)
            setting_1.systemConfig.dataPort = Number(config.dataPort);
        if (config.loginInfo != null)
            setting_1.systemConfig.loginInfo = String(config.loginInfo);
        if (config.canFileManager != null)
            setting_1.systemConfig.canFileManager = Boolean(config.canFileManager);
        if (config.allowUsePreset != null)
            setting_1.systemConfig.allowUsePreset = Boolean(config.allowUsePreset);
        if (config.businessMode != null)
            setting_1.systemConfig.businessMode = Boolean(config.businessMode);
        if (config.businessId != null)
            setting_1.systemConfig.businessId = String(config.businessId);
        if (config.allowChangeCmd != null)
            setting_1.systemConfig.allowChangeCmd = Boolean(config.allowChangeCmd);
        if (config.registerCode != null)
            setting_1.systemConfig.registerCode = String(config.registerCode);
        if (config.panelId != null)
            setting_1.systemConfig.panelId = String(config.panelId);
        if (config.presetPackAddr != null) {
            // clear cache
            fs.remove(const_1.MARKET_CACHE_FILE_PATH).catch((err) => {
                log_1.logger.warn(`Failed to clear preset pack cache file at ${const_1.MARKET_CACHE_FILE_PATH}: ${err}`);
            });
            setting_1.systemConfig.presetPackAddr = String(config.presetPackAddr);
        }
        if (config.language != null) {
            log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_e29a9317"), config.language);
            setting_1.systemConfig.language = String(config.language);
            await i18n_1.i18next.changeLanguage(setting_1.systemConfig.language.toLowerCase());
            remote_service_1.default.changeDaemonLanguage(setting_1.systemConfig.language);
        }
        operation_logger_1.operationLogger.log("system_config_change", {
            operator_ip: ctx.ip,
            operator_name: (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"]
        });
        (0, setting_1.saveSystemConfig)(setting_1.systemConfig);
        (0, version_1.checkBusinessMode)();
        ctx.body = "OK";
        return;
    }
    ctx.body = new Error((0, i18n_1.$t)("TXT_CODE_e4d6cc20"));
});
// [Public Permission]
// Update config when install
router.put("/install", async (ctx) => {
    const config = ctx.request.body;
    if (user_service_1.default.objects.size === 0 && setting_1.systemConfig) {
        if (config.language != null) {
            log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_e29a9317"), config.language);
            setting_1.systemConfig.language = String(config.language);
            i18n_1.i18next.changeLanguage(setting_1.systemConfig.language.toLowerCase());
            remote_service_1.default.changeDaemonLanguage(setting_1.systemConfig.language);
        }
        (0, setting_1.saveSystemConfig)(setting_1.systemConfig);
        ctx.body = "OK";
        return;
    }
    ctx.body = new Error((0, i18n_1.$t)("TXT_CODE_d37f0418"));
});
// [Public router]
router.get("/layout", async (ctx) => {
    ctx.body = (0, frontend_layout_1.getFrontendLayoutConfig)();
});
// [Top-level Permission]
// Set frontend layout
router.post("/layout", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    const config = ctx.request.body;
    (0, frontend_layout_1.setFrontendLayoutConfig)(config);
    ctx.body = true;
});
// [Top-level Permission]
// Reset frontend layout
router.delete("/layout", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    (0, frontend_layout_1.resetFrontendLayoutConfig)();
    ctx.body = true;
});
// [Top-level Permission]
// Upload file to asserts directory, only administrator can upload
router.post("/upload_assets", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    var _a;
    let files = (_a = ctx.request.files) === null || _a === void 0 ? void 0 : _a.file;
    let tmpFile;
    if (Array.isArray(files)) {
        tmpFile = files[0];
    }
    else {
        tmpFile = files;
    }
    try {
        if (!tmpFile)
            throw new Error((0, i18n_1.$t)("TXT_CODE_e4d6cc20"));
        if (!tmpFile.filepath || !fs.existsSync(tmpFile.filepath))
            throw new Error((0, i18n_1.$t)("TXT_CODE_1a499109"));
        const newFileName = (0, uuid_1.v4)() + path_1.default.extname(tmpFile.originalFilename || "");
        if (!system_file_1.default.checkFileName(newFileName))
            throw new Error("Access denied: Malformed file name");
        const saveDirPath = path_1.default.join(process.cwd(), frontend_layout_1.SAVE_DIR_PATH);
        if (!fs.existsSync(saveDirPath))
            fs.mkdirsSync(saveDirPath);
        await fs.move(tmpFile.filepath, path_1.default.join(saveDirPath, newFileName));
        ctx.body = newFileName;
    }
    finally {
        if (Array.isArray(files)) {
            files.forEach((v) => {
                if (v === null || v === void 0 ? void 0 : v.filepath)
                    fs.remove(v.filepath, () => { });
            });
        }
        else {
            if (tmpFile === null || tmpFile === void 0 ? void 0 : tmpFile.filepath)
                fs.remove(tmpFile.filepath, () => { });
        }
    }
});
router.post("/refresh_business_mode", (0, limit_1.speedLimit)(5), (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    await (0, version_1.checkBusinessMode)();
    ctx.body = "OK";
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/routers/user_overview_router.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const router_1 = __importDefault(__webpack_require__("@koa/router"));
const permission_1 = __importDefault(__webpack_require__("./src/app/middleware/permission.ts"));
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const router = new router_1.default({ prefix: "/auth" });
// [Top-level Permission]
router.put("/", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    const { uuid, config } = ctx.request.body;
    const { passWord } = config;
    if (passWord && !user_service_1.default.validatePassword(passWord))
        throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.passwordCheck"));
    try {
        // If the administrator resets the user's password, 2FA is automatically turned off.
        if (passWord) {
            config.secret = "";
            config.open2FA = false;
        }
        await user_service_1.default.edit(uuid, config);
        ctx.body = true;
    }
    catch (error) {
        ctx.throw(500, error.message);
    }
});
// [Top-level Permission]
router.get("/overview", (0, permission_1.default)({ level: user_1.ROLE.ADMIN }), async (ctx) => {
    const users = [];
    user_service_1.default.objects.forEach((user) => {
        users.push({
            uuid: user.uuid,
            userName: user.userName,
            permission: user.permission,
            instances: user.instances,
            loginTime: user.loginTime,
            registerTime: user.loginTime
        });
    });
    ctx.body = users;
});
exports["default"] = router;


/***/ }),

/***/ "./src/app/service/base/urs.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UniversalRemoteSubsystem = void 0;
const uuid_1 = __webpack_require__("uuid");
class UniversalRemoteSubsystem {
    constructor() {
        this.services = new Map();
    }
    setInstance(uuid, object) {
        if (this.services.get(uuid))
            throw new Error("Instance already exists");
        this.services.set(uuid, object);
    }
    getInstance(uuid) {
        return this.services.get(uuid);
    }
    deleteInstance(uuid) {
        return this.services.delete(uuid);
    }
    randdomUuid() {
        return (0, uuid_1.v4)().replace(/-/gim, "");
    }
}
exports.UniversalRemoteSubsystem = UniversalRemoteSubsystem;


/***/ }),

/***/ "./src/app/service/exchange_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNodeStatus = exports.queryInstanceByUserId = exports.buyOrRenewInstance = exports.parseUserName = exports.requestUseRedeem = exports.RequestAction = exports.REDEEM_PLATFORM_ADDR = void 0;
const axios_1 = __importDefault(__webpack_require__("axios"));
const i18next_1 = __webpack_require__("i18next");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const nanoid_1 = __webpack_require__("nanoid");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const instance_service_1 = __webpack_require__("./src/app/service/instance_service.ts");
// A commercial platform for selling instances released by the MCSManager Dev Team.
// Currently, it only supports some countries and regions.
// If you do not turn on "Commercial Mode", MCSManager will not send any data.
// export const REDEEM_PLATFORM_ADDR = "https://redeem.mcsmanager.com";
exports.REDEEM_PLATFORM_ADDR = "http://localhost:3000";
var RequestAction;
(function (RequestAction) {
    RequestAction["BUY"] = "buy";
    RequestAction["RENEW"] = "renew";
    RequestAction["QUERY_INSTANCE"] = "query_instance";
    RequestAction["PING"] = "ping";
    RequestAction["SSO_TOKEN"] = "sso_token";
})(RequestAction = exports.RequestAction || (exports.RequestAction = {}));
// ------- Define End ------
const getNanoId = (0, nanoid_1.customAlphabet)("1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", 6);
async function requestUseRedeem(panelId, registerCode, productId, daemonId, code, isDelete) {
    const { data: responseData } = await axios_1.default.post(`${exports.REDEEM_PLATFORM_ADDR}/api/iframe_instances/use_redeem`, {
        panelId,
        registerCode,
        productId,
        daemonId,
        code,
        isDelete
    }, {
        headers: {
            "X-Panel-Id": panelId,
            "X-Register-Code": registerCode
        }
    });
    if (responseData.code !== 200) {
        throw new Error(responseData.message);
    }
    return responseData.data;
}
exports.requestUseRedeem = requestUseRedeem;
function formatInstanceData(instance) {
    var _a, _b, _c, _d, _e, _f;
    let ports = (_b = (_a = instance.docker) === null || _a === void 0 ? void 0 : _a.ports) !== null && _b !== void 0 ? _b : [];
    let portRules = [];
    if ((ports === null || ports === void 0 ? void 0 : ports.length) > 0) {
        ports.forEach((line) => {
            // line = "23333:24444/tcp"
            const [ports, protocol] = line.split("/");
            if (!ports || !protocol)
                return;
            const [host, container] = ports.split(":");
            if (isNaN(Number(container)) || isNaN(Number(host)))
                return;
            portRules.push({
                protocol,
                container: Number(container),
                host: Number(host)
            });
        });
    }
    const lines = [];
    if (((_c = instance.info) === null || _c === void 0 ? void 0 : _c.maxPlayers) && Number((_d = instance.info) === null || _d === void 0 ? void 0 : _d.maxPlayers) != -1) {
        lines.push({
            title: (0, i18next_1.t)("TXT_CODE_7e9727bd"),
            value: `${(_e = instance.info) === null || _e === void 0 ? void 0 : _e.currentPlayers}/${(_f = instance.info) === null || _f === void 0 ? void 0 : _f.maxPlayers}`
        });
    }
    return {
        instance_id: instance.instanceUuid,
        name: instance.nickname || "",
        status: instance.status || 0,
        ports: portRules,
        expire: instance.endTime || 0,
        lines
    };
}
function parseUserName(t) {
    var _a;
    if (!t || typeof t !== "string")
        return "";
    return (_a = (0, mcsmanager_common_1.toText)(t)) !== null && _a !== void 0 ? _a : "";
}
exports.parseUserName = parseUserName;
async function buyOrRenewInstance(request_action, params, handler = {}) {
    var _a, _b, _c, _d, _e, _f;
    const node_id = (_a = (0, mcsmanager_common_1.toText)(params.node_id)) !== null && _a !== void 0 ? _a : "";
    const instance_id = (_b = (0, mcsmanager_common_1.toText)(params.instance_id)) !== null && _b !== void 0 ? _b : "";
    const username = parseUserName(params.username);
    const hours = (_c = (0, mcsmanager_common_1.toNumber)(params.hours)) !== null && _c !== void 0 ? _c : 0;
    const payload = (_d = params.payload) !== null && _d !== void 0 ? _d : {};
    const remoteService = remote_service_1.default.getInstance(node_id || "");
    if (!(remoteService === null || remoteService === void 0 ? void 0 : remoteService.available)) {
        throw new Error((0, i18next_1.t)("TXT_CODE_bed32084"));
    }
    const remoteRequest = new remote_command_1.default(remoteService);
    if (request_action === RequestAction.BUY) {
        payload.category = params.category_id || 0;
        payload.endTime =
            (payload.endTime ? Number(payload.endTime) : Date.now()) + hours * 3600 * 1000;
        if (username.length < 4) {
            throw new Error((0, i18n_1.$t)("TXT_CODE_router.user.invalidUserName"));
        }
        payload.nickname = "App-" + username + "-" + getNanoId(6);
        const { instanceUuid: newInstanceId, config: newInstanceConfig } = await remoteRequest.request("instance/new", payload);
        if (!newInstanceId)
            throw new Error((0, i18next_1.t)("TXT_CODE_728fdabf"));
        let user = user_service_1.default.getUserByUserName(username);
        let newPassword = "";
        await ((_e = handler.onCreateConfirm) === null || _e === void 0 ? void 0 : _e.call(handler, newInstanceId));
        if (user) {
            await user_service_1.default.edit(user.uuid, {
                instances: [
                    ...user.instances,
                    {
                        instanceUuid: newInstanceId,
                        daemonId: node_id
                    }
                ]
            });
        }
        else {
            newPassword = getNanoId(12);
            user = await user_service_1.default.create({
                userName: username,
                passWord: newPassword,
                permission: 1,
                instances: [
                    {
                        instanceUuid: newInstanceId,
                        daemonId: node_id
                    }
                ]
            });
        }
        return {
            instance_id: newInstanceId,
            instance_config: newInstanceConfig,
            username: user.userName,
            password: newPassword,
            uuid: user.uuid,
            expire: (0, mcsmanager_common_1.toNumber)(newInstanceConfig.endTime) || 0,
            instance_info: formatInstanceData(newInstanceConfig)
        };
    }
    if (request_action === RequestAction.RENEW) {
        const instanceInfo = await remoteRequest.request("instance/detail", {
            instanceUuid: instance_id
        });
        const config = instanceInfo.config || {};
        if (!config.category || isNaN(Number(config.category))) {
            throw new Error((0, i18next_1.t)("TXT_CODE_ed81f72d"));
        }
        if (config.category !== Number(params.category_id)) {
            throw new Error((0, i18next_1.t)("TXT_CODE_c5b38d90"));
        }
        if (!config)
            throw new Error((0, i18next_1.t)("TXT_CODE_348c9098"));
        const curExpireTime = Number(config.endTime);
        if (!curExpireTime || isNaN(curExpireTime) || curExpireTime < Date.now()) {
            config.endTime = Date.now() + hours * 3600 * 1000;
        }
        else {
            config.endTime = curExpireTime + hours * 3600 * 1000;
        }
        await ((_f = handler.onCreateConfirm) === null || _f === void 0 ? void 0 : _f.call(handler, instance_id));
        await remoteRequest.request("instance/update", {
            instanceUuid: instance_id,
            config: config
        });
        return {
            instance_id,
            instance_config: config,
            expire: (0, mcsmanager_common_1.toNumber)(config.endTime) || 0,
            username: "",
            password: "",
            uuid: ""
        };
    }
    throw new Error((0, i18next_1.t)("TXT_CODE_4aaec75c"));
}
exports.buyOrRenewInstance = buyOrRenewInstance;
async function queryInstanceByUserId(params) {
    var _a;
    const name = parseUserName(params.username) || "";
    const targetDaemonId = (_a = (0, mcsmanager_common_1.toText)(params.node_id)) !== null && _a !== void 0 ? _a : undefined;
    const user = user_service_1.default.getUserByUserName(name);
    if (!user)
        throw new Error((0, i18next_1.t)("TXT_CODE_903b6c50"));
    const { instances = [] } = await (0, instance_service_1.getInstancesByUuid)(user.uuid, targetDaemonId, true);
    const newInstancesInfo = instances.map((v) => {
        return formatInstanceData(v);
    });
    return newInstancesInfo;
}
exports.queryInstanceByUserId = queryInstanceByUserId;
async function getNodeStatus(params) {
    var _a, _b, _c, _d, _e;
    const nodeId = (_a = (0, mcsmanager_common_1.toText)(params.node_id)) !== null && _a !== void 0 ? _a : "";
    const remoteService = remote_service_1.default.getInstance(nodeId);
    if (!(remoteService === null || remoteService === void 0 ? void 0 : remoteService.available)) {
        throw new Error((0, i18next_1.t)("TXT_CODE_bed32084"));
    }
    const remoteRequest = new remote_command_1.default(remoteService);
    const remoteInfo = await remoteRequest.request("info/overview");
    remoteInfo.uuid = remoteService.uuid;
    remoteInfo.available = remoteService.available;
    remoteInfo.ip = (_b = remoteService.config) === null || _b === void 0 ? void 0 : _b.ip;
    remoteInfo.port = (_c = remoteService.config) === null || _c === void 0 ? void 0 : _c.port;
    remoteInfo.prefix = (_d = remoteService.config) === null || _d === void 0 ? void 0 : _d.prefix;
    remoteInfo.remarks = (_e = remoteService.config) === null || _e === void 0 ? void 0 : _e.remarks;
    return {
        name: String(remoteInfo.remarks),
        id: String(remoteInfo.uuid),
        ip: String(remoteInfo.ip),
        port: Number(remoteInfo.port),
        available: Boolean(remoteInfo.available),
        running: Number(remoteInfo.instance.running),
        instances: Number(remoteInfo.instance.total)
    };
}
exports.getNodeStatus = getNodeStatus;


/***/ }),

/***/ "./src/app/service/frontend_layout.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LayoutCardHeight = exports.resetFrontendLayoutConfig = exports.setFrontendLayoutConfig = exports.getFrontendLayoutConfig = exports.SAVE_DIR_PATH = void 0;
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const path_1 = __importDefault(__webpack_require__("path"));
const uuid_1 = __webpack_require__("uuid");
const system_storage_1 = __importDefault(__webpack_require__("./src/app/common/system_storage.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const LAYOUT_CONFIG_NAME = "layout.json";
exports.SAVE_DIR_PATH = "public/upload_files/";
function getRandomId() {
    return (0, uuid_1.v4)();
}
function getFrontendLayoutConfig() {
    let layoutConfig = "";
    if (system_storage_1.default.fileExists(LAYOUT_CONFIG_NAME)) {
        layoutConfig = system_storage_1.default.readFile(LAYOUT_CONFIG_NAME);
    }
    if (layoutConfig) {
        if (mcsmanager_common_1.GlobalVariable.get("versionChange")) {
            const latestLayoutConfig = getDefaultFrontendLayoutConfig();
            const currentLayoutConfig = JSON.parse(layoutConfig);
            for (const page of latestLayoutConfig) {
                if (!currentLayoutConfig.find((item) => item.page === page.page)) {
                    currentLayoutConfig.push(page);
                }
            }
            mcsmanager_common_1.GlobalVariable.set("versionChange", null);
            setFrontendLayoutConfig(currentLayoutConfig);
            return JSON.stringify(currentLayoutConfig);
        }
        return layoutConfig;
    }
    else {
        return JSON.stringify(getDefaultFrontendLayoutConfig());
    }
}
exports.getFrontendLayoutConfig = getFrontendLayoutConfig;
function setFrontendLayoutConfig(config) {
    system_storage_1.default.writeFile(LAYOUT_CONFIG_NAME, JSON.stringify(config, null, 2));
}
exports.setFrontendLayoutConfig = setFrontendLayoutConfig;
function resetFrontendLayoutConfig() {
    system_storage_1.default.deleteFile(LAYOUT_CONFIG_NAME);
    const filesDir = path_1.default.join(process.cwd(), exports.SAVE_DIR_PATH);
    if (fs_extra_1.default.existsSync(filesDir)) {
        for (const fileName of fs_extra_1.default.readdirSync(filesDir)) {
            fs_extra_1.default.remove(path_1.default.join(filesDir, fileName), () => { });
        }
    }
}
exports.resetFrontendLayoutConfig = resetFrontendLayoutConfig;
var LayoutCardHeight;
(function (LayoutCardHeight) {
    LayoutCardHeight["MINI"] = "100px";
    LayoutCardHeight["SMALL"] = "200px";
    LayoutCardHeight["MEDIUM"] = "400px";
    LayoutCardHeight["BIG"] = "600px";
    LayoutCardHeight["LARGE"] = "800px";
    LayoutCardHeight["AUTO"] = "unset";
})(LayoutCardHeight = exports.LayoutCardHeight || (exports.LayoutCardHeight = {}));
function getDefaultFrontendLayoutConfig() {
    return [
        {
            page: "__settings__",
            items: [],
            theme: {
                logoImage: "",
                backgroundImage: ""
            }
        },
        {
            page: "/overview",
            items: [
                {
                    id: getRandomId(),
                    type: "StatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_e627e546"),
                    meta: {
                        type: "node"
                    },
                    width: 3,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    type: "StatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_88e9361a"),
                    meta: {
                        type: "instance"
                    },
                    width: 3,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    type: "StatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_db64faf6"),
                    meta: {
                        type: "users"
                    },
                    width: 3,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    type: "StatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_66056676"),
                    meta: {
                        type: "system"
                    },
                    width: 3,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "DataOverview",
                    title: (0, i18n_1.$t)("TXT_CODE_721157a3"),
                    width: 12,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.MEDIUM
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "RequestChart",
                    title: (0, i18n_1.$t)("TXT_CODE_a4037a98"),
                    width: 6,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceChart",
                    title: (0, i18n_1.$t)("TXT_CODE_d6d9c42c"),
                    width: 6,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "OperationLogCard",
                    title: (0, i18n_1.$t)("TXT_CODE_f6a33629"),
                    width: 4,
                    description: (0, i18n_1.$t)("TXT_CODE_9e8c176e"),
                    height: LayoutCardHeight.MEDIUM
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "NodeOverview",
                    title: (0, i18n_1.$t)("TXT_CODE_bfb50126"),
                    width: 8,
                    description: (0, i18n_1.$t)("TXT_CODE_55ade942"),
                    height: LayoutCardHeight.MEDIUM
                }
            ]
        },
        {
            page: "/market",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "Market",
                    title: (0, i18n_1.$t)("TXT_CODE_88249aee"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/market/editor",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "MarketEditor",
                    title: (0, i18n_1.$t)("TXT_CODE_54275b9c"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/instances",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceList",
                    title: (0, i18n_1.$t)("TXT_CODE_e21473bc"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/instances/terminal",
            items: [
                {
                    id: getRandomId(),
                    meta: {
                        viewType: "inner"
                    },
                    type: "Terminal",
                    title: (0, i18n_1.$t)("TXT_CODE_4ccdd3a0"),
                    width: 12,
                    height: LayoutCardHeight.BIG,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceBaseInfo",
                    title: (0, i18n_1.$t)("TXT_CODE_eadb4f60"),
                    width: 4,
                    height: LayoutCardHeight.SMALL
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceManagerBtns",
                    title: (0, i18n_1.$t)("TXT_CODE_efd37c48"),
                    width: 8,
                    height: LayoutCardHeight.SMALL,
                    disableDelete: true
                }
            ]
        },
        {
            page: "/instances/terminal/files",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceFileManager",
                    title: (0, i18n_1.$t)("TXT_CODE_ae533703"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/instances/terminal/serverConfig",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceServerConfigOverview",
                    title: (0, i18n_1.$t)("TXT_CODE_d07742fe"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/instances/terminal/serverConfig/fileEdit",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "InstanceServerConfigFile",
                    title: (0, i18n_1.$t)("TXT_CODE_1c45f7fe"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/instances/schedule",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "Schedule",
                    title: (0, i18n_1.$t)("TXT_CODE_b7d026f8"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/users",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "UserList",
                    title: (0, i18n_1.$t)("TXT_CODE_97d17cce"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/users/resources",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "UserAccessSettings",
                    title: (0, i18n_1.$t)("TXT_CODE_eb579d63"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/settings",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "Settings",
                    title: (0, i18n_1.$t)("TXT_CODE_3fe97dcc"),
                    width: 9,
                    height: LayoutCardHeight.LARGE,
                    disableDelete: true
                }
            ]
        },
        {
            page: "/node",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "NodeList",
                    title: (0, i18n_1.$t)("TXT_CODE_20509fa0"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/node/image",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "ImageManager",
                    title: (0, i18n_1.$t)("TXT_CODE_e6c30866"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/node/image/new",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "NewImage",
                    title: (0, i18n_1.$t)("TXT_CODE_3d09f0ac"),
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/quickstart",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "QuickStartFlow",
                    title: (0, i18n_1.$t)("TXT_CODE_9b99b72e"),
                    width: 8,
                    height: LayoutCardHeight.AUTO
                }
            ]
        },
        {
            page: "/quickstart/minecraft",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "McPreset",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.AUTO
                },
                {
                    id: getRandomId(),
                    meta: {},
                    type: "EmptyCard",
                    title: "",
                    width: 12,
                    height: LayoutCardHeight.MINI
                }
            ]
        },
        {
            page: "/customer",
            items: [
                {
                    id: getRandomId(),
                    type: "UserStatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_7411336e"),
                    meta: {
                        type: "instance_all"
                    },
                    width: 3,
                    height: LayoutCardHeight.SMALL,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    type: "UserStatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_f912fadc"),
                    meta: {
                        type: "instance_running"
                    },
                    width: 3,
                    height: LayoutCardHeight.SMALL,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    type: "UserStatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_15f2e564"),
                    meta: {
                        type: "instance_stop"
                    },
                    width: 3,
                    height: LayoutCardHeight.SMALL,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    type: "UserStatusBlock",
                    title: (0, i18n_1.$t)("TXT_CODE_342a04a9"),
                    meta: {
                        type: "instance_error"
                    },
                    width: 3,
                    height: LayoutCardHeight.SMALL,
                    disableDelete: true
                },
                {
                    id: getRandomId(),
                    type: "UserInstanceList",
                    title: (0, i18n_1.$t)("TXT_CODE_d655beec"),
                    meta: {
                        type: "instance_error"
                    },
                    width: 12,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                }
            ]
        },
        {
            page: "/login",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "LoginCard",
                    title: (0, i18n_1.$t)("TXT_CODE_ccb60658"),
                    width: 4,
                    height: LayoutCardHeight.AUTO,
                    disableDelete: true
                }
            ]
        },
        {
            page: "/shop",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "ShelvesCard",
                    title: (0, i18n_1.$t)("TXT_CODE_381f8f22"),
                    width: 12,
                    height: LayoutCardHeight.LARGE,
                    disableDelete: true
                }
            ]
        },
        {
            page: "/404",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "Page404",
                    title: (0, i18n_1.$t)("TXT_CODE_6aa286df"),
                    width: 6,
                    height: LayoutCardHeight.MINI,
                    disableDelete: true
                }
            ]
        },
        {
            page: "/_open_page",
            items: [
                {
                    id: getRandomId(),
                    meta: {},
                    type: "DefaultCard",
                    title: (0, i18n_1.$t)("TXT_CODE_463375d2"),
                    width: 6,
                    height: LayoutCardHeight.SMALL
                }
            ]
        }
    ];
}


/***/ }),

/***/ "./src/app/service/instance_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.checkInstanceAdvancedParams = exports.getInstancesByUuid = exports.multiOperationForwarding = exports.INSTANCE_STATUS_TEXT = exports.INSTANCE_STATUS = void 0;
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
const i18next_1 = __webpack_require__("i18next");
const setting_1 = __webpack_require__("./src/app/setting.ts");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
var INSTANCE_STATUS;
(function (INSTANCE_STATUS) {
    INSTANCE_STATUS[INSTANCE_STATUS["BUSY"] = -1] = "BUSY";
    INSTANCE_STATUS[INSTANCE_STATUS["STOP"] = 0] = "STOP";
    INSTANCE_STATUS[INSTANCE_STATUS["STOPPING"] = 1] = "STOPPING";
    INSTANCE_STATUS[INSTANCE_STATUS["STARTING"] = 2] = "STARTING";
    INSTANCE_STATUS[INSTANCE_STATUS["RUNNING"] = 3] = "RUNNING";
})(INSTANCE_STATUS = exports.INSTANCE_STATUS || (exports.INSTANCE_STATUS = {}));
exports.INSTANCE_STATUS_TEXT = {
    [INSTANCE_STATUS.BUSY]: (0, i18next_1.t)("TXT_CODE_342a04a9"),
    [INSTANCE_STATUS.STOP]: (0, i18next_1.t)("TXT_CODE_15f2e564"),
    [INSTANCE_STATUS.STOPPING]: (0, i18next_1.t)("TXT_CODE_a409b8a9"),
    [INSTANCE_STATUS.STARTING]: (0, i18next_1.t)("TXT_CODE_175b570d"),
    [INSTANCE_STATUS.RUNNING]: (0, i18next_1.t)("TXT_CODE_bdb620b9")
};
// Multi-forward operation method
function multiOperationForwarding(instances, callback) {
    var _a;
    // classification table
    const map = new Map();
    // Classify remote hosts and instance IDs based on information
    for (const instanceInfo of instances) {
        const daemonId = instanceInfo.daemonId;
        const instanceUuid = instanceInfo.instanceUuid;
        if (map.has(daemonId)) {
            (_a = map.get(daemonId)) === null || _a === void 0 ? void 0 : _a.push(instanceUuid);
        }
        else {
            map.set(daemonId, [instanceUuid]);
        }
    }
    // Pack and forward the classified data separately
    for (const iterator of map) {
        const daemonId = iterator[0];
        const instanceUuids = iterator[1];
        callback(daemonId, instanceUuids);
    }
}
exports.multiOperationForwarding = multiOperationForwarding;
async function getInstancesByUuid(uuid, targetDaemonId, advanced = false) {
    const user = user_service_1.default.getInstance(uuid);
    if (!user)
        throw new Error("The UID does not exist");
    // Advanced functions are optional, analyze each instance data
    let resInstances = [];
    if (advanced) {
        const instances = user.instances;
        for (const iterator of instances) {
            if (targetDaemonId && targetDaemonId !== iterator.daemonId)
                continue;
            const remoteService = remote_service_1.default.getInstance(iterator.daemonId);
            if (!remoteService) {
                // If the remote service doesn't exist at all, load a deleted prompt
                resInstances.push({
                    hostIp: "-- Unknown --",
                    instanceUuid: iterator.instanceUuid,
                    daemonId: iterator.daemonId,
                    status: -1,
                    nickname: "-- Unknown --",
                    remarks: "",
                    ie: "",
                    oe: "",
                    endTime: 0,
                    lastDatetime: 0,
                    stopCommand: "",
                    processType: "",
                    docker: {},
                    info: {}
                });
                continue;
            }
            // Note: UUID can be integrated here to save the returned traffic, and this optimization will not be done for the time being
            let instancesInfo = await new remote_command_1.default(remoteService).request("instance/section", {
                instanceUuids: [iterator.instanceUuid]
            });
            if (!instancesInfo || instancesInfo.length === 0)
                continue;
            instancesInfo = instancesInfo[0];
            resInstances.push({
                hostIp: `${remoteService.config.ip}:${remoteService.config.port}`,
                remarks: remoteService.config.remarks,
                instanceUuid: instancesInfo.instanceUuid,
                daemonId: remoteService.uuid,
                status: instancesInfo.status,
                nickname: instancesInfo.config.nickname,
                ie: instancesInfo.config.ie,
                oe: instancesInfo.config.oe,
                endTime: instancesInfo.config.endTime,
                lastDatetime: instancesInfo.config.lastDatetime,
                stopCommand: instancesInfo.config.stopCommand,
                processType: instancesInfo.config.processType,
                docker: instancesInfo.config.docker || {},
                info: instancesInfo.info || {}
            });
        }
    }
    else {
        resInstances = user.instances;
    }
    // respond to user data
    return {
        uuid: user.uuid,
        userName: user.userName,
        loginTime: user.loginTime,
        registerTime: user.registerTime,
        instances: resInstances,
        permission: user.permission,
        apiKey: user.apiKey,
        isInit: user.isInit,
        open2FA: user.open2FA,
        secret: user.secret,
        token: ""
    };
}
exports.getInstancesByUuid = getInstancesByUuid;
function checkInstanceAdvancedParams(config, isTopPermission = false) {
    var _a;
    const canChangeCmd = setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.allowChangeCmd;
    if (!isTopPermission) {
        if (!canChangeCmd)
            return {};
        if (config.processType !== "docker")
            return {};
    }
    const startCommand = (0, mcsmanager_common_1.toText)(config.startCommand);
    const updateCommand = (0, mcsmanager_common_1.toText)(config.updateCommand);
    const dockerEnv = Array.isArray((_a = config.docker) === null || _a === void 0 ? void 0 : _a.env) ? config.docker.env : null;
    return {
        startCommand,
        updateCommand,
        docker: {
            env: dockerEnv
        }
    };
}
exports.checkInstanceAdvancedParams = checkInstanceAdvancedParams;


/***/ }),

/***/ "./src/app/service/log.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fullLocalTime = exports.fullTime = exports.fileLogger = exports.logger = void 0;
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const log4js_1 = __importDefault(__webpack_require__("log4js"));
const LOG_FILE_PATH = "logs/current.log";
// save the log file separately on each startup
if (fs_extra_1.default.existsSync(LOG_FILE_PATH)) {
    const time = new Date();
    const timeString = `${time.getFullYear()}-${time.getMonth() + 1}-${time.getDate()}_${time.getHours()}-${time.getMinutes()}-${time.getSeconds()}`;
    fs_extra_1.default.renameSync(LOG_FILE_PATH, `logs/${timeString}.log`);
}
log4js_1.default.configure({
    appenders: {
        out: {
            type: "stdout",
            layout: {
                type: "pattern",
                pattern: "[%d{MM/dd hh:mm:ss}] [%[%p%]] %m"
            }
        },
        file: {
            type: "file",
            filename: LOG_FILE_PATH,
            layout: {
                type: "pattern",
                pattern: "%d %p %m"
            }
        }
    },
    categories: {
        default: {
            appenders: ["out", "file"],
            level: "info"
        },
        file: {
            appenders: ["file"],
            level: "info"
        }
    }
});
const logger = log4js_1.default.getLogger("default");
exports.logger = logger;
const fileLogger = log4js_1.default.getLogger("file");
exports.fileLogger = fileLogger;
function fullTime() {
    const date = new Date();
    return `${date.getFullYear()}/${date.getMonth()}/${date.getDate()}`;
}
exports.fullTime = fullTime;
function fullLocalTime() {
    return new Date().toLocaleTimeString();
}
exports.fullLocalTime = fullLocalTime;


/***/ }),

/***/ "./src/app/service/mini_redis.ts":
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.singletonMemoryRedis = void 0;
class SingletonMemoryRedis {
    constructor() {
        this.envMap = new Map();
        setInterval(() => {
            const now = Date.now();
            for (const [key, data] of this.envMap) {
                if (now >= data.ttl) {
                    this.envMap.delete(key);
                }
            }
        }, 500);
    }
    get(key) {
        return this.envMap.get(key);
    }
    set(key, value, ttl = 0) {
        this.envMap.set(key, {
            value,
            ttl: Date.now() + ttl * 1000
        });
    }
    ttl(key) {
        const data = this.envMap.get(key);
        if (!data)
            return 0;
        const ttl = data.ttl - Date.now();
        return parseInt(String(ttl / 1000));
    }
}
// singleton
exports.singletonMemoryRedis = new SingletonMemoryRedis();


/***/ }),

/***/ "./src/app/service/operation_logger.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _OperationLogger_storage, _OperationLogger_buffer, _OperationLogger_bufferSize, _OperationLogger_flushTimer;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.operationLogger = void 0;
const jsonl_storage_1 = __webpack_require__("./src/app/common/storage/jsonl_storage.ts");
const uuid_1 = __webpack_require__("uuid");
class OperationLogger {
    constructor(bufferSize = 20) {
        _OperationLogger_storage.set(this, void 0);
        _OperationLogger_buffer.set(this, void 0);
        _OperationLogger_bufferSize.set(this, void 0);
        _OperationLogger_flushTimer.set(this, null);
        __classPrivateFieldSet(this, _OperationLogger_storage, new jsonl_storage_1.JsonlStorageSubsystem("/operation_logs"), "f");
        __classPrivateFieldSet(this, _OperationLogger_buffer, new Map(), "f");
        __classPrivateFieldSet(this, _OperationLogger_bufferSize, bufferSize, "f");
        this.startFlushTimer();
    }
    async flushAsync(buffer = __classPrivateFieldGet(this, _OperationLogger_buffer, "f")) {
        if (buffer.size === 0)
            return true;
        const entries = Array.from(buffer.values());
        await __classPrivateFieldGet(this, _OperationLogger_storage, "f").append("global", entries);
        return true;
    }
    flushSync(buffer = __classPrivateFieldGet(this, _OperationLogger_buffer, "f")) {
        if (buffer.size === 0)
            return true;
        const entries = Array.from(buffer.values());
        __classPrivateFieldGet(this, _OperationLogger_storage, "f").append("global", entries, true);
        return true;
    }
    checkBufferQueue() {
        if (__classPrivateFieldGet(this, _OperationLogger_buffer, "f").size < __classPrivateFieldGet(this, _OperationLogger_bufferSize, "f"))
            return;
        const currentBuffer = __classPrivateFieldGet(this, _OperationLogger_buffer, "f");
        __classPrivateFieldSet(this, _OperationLogger_buffer, new Map(), "f");
        this.flushAsync(currentBuffer);
    }
    log(type, payload, level = "info") {
        const operation_id = (0, uuid_1.v4)();
        const operation_time = Date.now().toString();
        const item = {
            type,
            operation_id,
            operation_time,
            operation_level: level,
            ...payload
        };
        __classPrivateFieldGet(this, _OperationLogger_buffer, "f").set(operation_id, item);
        this.checkBufferQueue();
        return operation_id;
    }
    async get(limit = 20) {
        if (limit <= __classPrivateFieldGet(this, _OperationLogger_buffer, "f").size)
            return Array.from(__classPrivateFieldGet(this, _OperationLogger_buffer, "f").values()).slice(-limit);
        const currentBuffer = __classPrivateFieldGet(this, _OperationLogger_buffer, "f");
        __classPrivateFieldSet(this, _OperationLogger_buffer, new Map(), "f");
        await this.flushAsync(currentBuffer);
        return __classPrivateFieldGet(this, _OperationLogger_storage, "f").tail("global", limit);
    }
    info(type, payload) {
        return this.log(type, payload, "info");
    }
    warning(type, payload) {
        return this.log(type, payload, "warning");
    }
    error(type, payload) {
        return this.log(type, payload, "error");
    }
    startFlushTimer() {
        __classPrivateFieldSet(this, _OperationLogger_flushTimer, setInterval(() => {
            if (__classPrivateFieldGet(this, _OperationLogger_buffer, "f").size > 0) {
                const currentBuffer = __classPrivateFieldGet(this, _OperationLogger_buffer, "f");
                __classPrivateFieldSet(this, _OperationLogger_buffer, new Map(), "f");
                this.flushAsync(currentBuffer);
            }
        }, 5000), "f");
    }
    stopFlushTimer() {
        if (__classPrivateFieldGet(this, _OperationLogger_flushTimer, "f")) {
            clearInterval(__classPrivateFieldGet(this, _OperationLogger_flushTimer, "f"));
            __classPrivateFieldSet(this, _OperationLogger_flushTimer, null, "f");
        }
    }
}
_OperationLogger_storage = new WeakMap(), _OperationLogger_buffer = new WeakMap(), _OperationLogger_bufferSize = new WeakMap(), _OperationLogger_flushTimer = new WeakMap();
exports.operationLogger = new OperationLogger();
process.on("SIGINT", () => {
    exports.operationLogger.stopFlushTimer();
    exports.operationLogger.flushSync();
});
process.on("exit", () => {
    exports.operationLogger.stopFlushTimer();
    exports.operationLogger.flushSync();
});


/***/ }),

/***/ "./src/app/service/passport_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getApiKey = exports.isApiRequest = exports.getUuidByApiKey = exports.checkBanIp = exports.isAjax = exports.getToken = exports.getUserUuid = exports.getUserFromCtx = exports.getUserNameBySession = exports.getUserPermission = exports.register = exports.logout = exports.check = exports.confirm2FaQRCode = exports.bind2FA = exports.getLoginIp = exports.loginSuccess = exports.login = exports.LOGIN_FAILED_COUNT_KEY = exports.LOGIN_COUNT = exports.ILLEGAL_ACCESS_KEY = exports.LOGIN_FAILED_KEY = exports.BAN_IP_COUNT = void 0;
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const otplib_1 = __webpack_require__("otplib");
const qrcode_1 = __importDefault(__webpack_require__("qrcode"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const setting_1 = __webpack_require__("./src/app/setting.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const password_1 = __webpack_require__("./src/app/service/password.ts");
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
exports.BAN_IP_COUNT = "banip";
exports.LOGIN_FAILED_KEY = "loginFailed";
exports.ILLEGAL_ACCESS_KEY = "illegalAccess";
exports.LOGIN_COUNT = "loginCount";
exports.LOGIN_FAILED_COUNT_KEY = "loginFailedCount";
function login(ctx, userName, passWord, twoFACode) {
    // record the number of login requests
    mcsmanager_common_1.GlobalVariable.set(exports.LOGIN_COUNT, mcsmanager_common_1.GlobalVariable.get(exports.LOGIN_COUNT, 0) + 1);
    const ip = getLoginIp(ctx);
    // check user information
    try {
        const totpDriftToleranceSteps = (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.totpDriftToleranceSteps) || 0;
        user_service_1.default.checkUser({ userName, passWord }, twoFACode, totpDriftToleranceSteps);
        // The number of errors to reset this IP after successful login
        const ipMap = mcsmanager_common_1.GlobalVariable.get(exports.LOGIN_FAILED_KEY);
        if (ipMap)
            delete ipMap[ip || ""];
        // Session Session state changes to logged in
        return loginSuccess(ctx, userName);
    }
    catch (err) {
        // record the number of login failures
        mcsmanager_common_1.GlobalVariable.set(exports.LOGIN_FAILED_COUNT_KEY, mcsmanager_common_1.GlobalVariable.get(exports.LOGIN_FAILED_COUNT_KEY, 0) + 1);
        if (ctx.session) {
            ctx.session["login"] = null;
            ctx.session["token"] = null;
            ctx.session.save();
        }
        log_1.logger.info(`[LOGIN] IP: ${ip}, Try login ${userName} failed!`);
        throw err;
    }
}
exports.login = login;
function loginSuccess(ctx, userName) {
    const ip = getLoginIp(ctx);
    const user = user_service_1.default.getUserByUserName(userName);
    if (!user)
        throw new Error((0, i18n_1.$t)("TXT_CODE_router.login.nameOrPassError"));
    if (!ctx.session)
        throw new Error("Session is Null!");
    user.loginTime = new Date().toLocaleString();
    ctx.session["login"] = true;
    ctx.session["userName"] = userName;
    ctx.session["uuid"] = user.uuid;
    ctx.session["token"] = (0, password_1.timeUuid)();
    ctx.session.save();
    log_1.logger.info((0, i18n_1.$t)("TXT_CODE_42036f92"));
    log_1.logger.info(`[LOGIN] IP: ${ip} Login ${userName} successful!`);
    log_1.logger.info(`[LOGIN] Token: ${ctx.session["token"]}`);
    log_1.logger.info((0, i18n_1.$t)("TXT_CODE_42036f92"));
    return String(ctx.session["token"]);
}
exports.loginSuccess = loginSuccess;
function getLoginIp(ctx) {
    var _a;
    return (_a = ctx.ip) !== null && _a !== void 0 ? _a : "";
}
exports.getLoginIp = getLoginIp;
async function bind2FA(ctx) {
    if (!ctx.session)
        throw new Error("Session is Null!");
    const userName = ctx.session["userName"];
    const user = user_service_1.default.getUserByUserName(userName);
    if (!user)
        throw new Error("User is Null!");
    try {
        const secret = otplib_1.authenticator.generateSecret();
        const qrCode = await qrcode_1.default.toDataURL(otplib_1.authenticator.keyuri(userName, "MCSManager Panel", secret));
        user_service_1.default.edit(user.uuid, { secret, open2FA: false });
        return qrCode;
    }
    catch (err) {
        user.secret = "";
    }
}
exports.bind2FA = bind2FA;
async function confirm2FaQRCode(userUuid, isEnable) {
    await user_service_1.default.edit(userUuid, {
        open2FA: isEnable
    });
}
exports.confirm2FaQRCode = confirm2FaQRCode;
function check(ctx) {
    if (!ctx.session)
        return false;
    if (ctx.session["login"] && ctx.session["userName"] && ctx.session["token"])
        return true;
    return false;
}
exports.check = check;
function logout(ctx) {
    if (!ctx.session)
        return false;
    ctx.session["login"] = null;
    ctx.session["userName"] = null;
    ctx.session["uuid"] = null;
    ctx.session["token"] = null;
    ctx.session.maxAge = 0;
    ctx.session.save();
    return true;
}
exports.logout = logout;
async function register(ctx, userName, passWord, permission) {
    let f = true;
    // Check for duplicate usernames.
    user_service_1.default.objects.forEach((user) => {
        if (user && user.userName == userName)
            f = false;
    });
    if (f) {
        // Next. UUID and other data will be automatically generated.
        const { uuid } = await user_service_1.default.create({
            userName,
            passWord,
            permission
        });
        return {
            uuid,
            userName,
            permission
        };
    }
    return false;
}
exports.register = register;
function getUserPermission(ctx) {
    var _a, _b;
    let user = undefined;
    if (isApiRequest(ctx)) {
        user = getUuidByApiKey(getApiKey(ctx));
    }
    else {
        user = user_service_1.default.getInstance(((_a = ctx.session) === null || _a === void 0 ? void 0 : _a["uuid"]) || "");
    }
    if (!user)
        return 0;
    return (_b = user.permission) !== null && _b !== void 0 ? _b : 0;
}
exports.getUserPermission = getUserPermission;
function getUserNameBySession(ctx) {
    var _a;
    if (isApiRequest(ctx)) {
        const user = getUuidByApiKey(getApiKey(ctx));
        return user ? user.userName : "";
    }
    return (_a = ctx.session) === null || _a === void 0 ? void 0 : _a["userName"];
}
exports.getUserNameBySession = getUserNameBySession;
function getUserFromCtx(ctx) {
    var _a;
    try {
        if (isApiRequest(ctx)) {
            const user = getUuidByApiKey(getApiKey(ctx));
            return user || undefined;
        }
        return user_service_1.default.getInstance(((_a = ctx.session) === null || _a === void 0 ? void 0 : _a["uuid"]) || "") || undefined;
    }
    catch (error) {
        return undefined;
    }
}
exports.getUserFromCtx = getUserFromCtx;
function getUserUuid(ctx) {
    var _a;
    if (isApiRequest(ctx)) {
        const user = getUuidByApiKey(getApiKey(ctx));
        if (user && user.uuid) {
            return user.uuid;
        }
        else {
            return "";
        }
    }
    return ((_a = ctx.session) === null || _a === void 0 ? void 0 : _a["uuid"]) || "";
}
exports.getUserUuid = getUserUuid;
function getToken(ctx) {
    var _a;
    return ((_a = ctx.session) === null || _a === void 0 ? void 0 : _a["token"]) || "";
}
exports.getToken = getToken;
function isAjax(ctx) {
    return (ctx.header["x-requested-with"] &&
        ctx.header["x-requested-with"].toString().toLocaleLowerCase() === "xmlhttprequest");
}
exports.isAjax = isAjax;
function checkBanIp(ctx) {
    if (!mcsmanager_common_1.GlobalVariable.map.has(exports.LOGIN_FAILED_KEY))
        mcsmanager_common_1.GlobalVariable.set(exports.LOGIN_FAILED_KEY, {});
    // This IpMap also needs to be used when logging in
    const ipMap = mcsmanager_common_1.GlobalVariable.get(exports.LOGIN_FAILED_KEY);
    const ip = getLoginIp(ctx);
    if (ipMap[ip] > 10 && (setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.loginCheckIp) === true) {
        if (ipMap[ip] != 999) {
            // record the number of bans
            mcsmanager_common_1.GlobalVariable.set(exports.BAN_IP_COUNT, mcsmanager_common_1.GlobalVariable.get(exports.BAN_IP_COUNT, 0) + 1);
            setTimeout(() => {
                delete ipMap[ip];
                // delete the number of bans
                mcsmanager_common_1.GlobalVariable.set(exports.BAN_IP_COUNT, mcsmanager_common_1.GlobalVariable.get(exports.BAN_IP_COUNT, 1) - 1);
            }, 1000 * 60 * 10);
        }
        ipMap[ip] = 999;
        return false;
    }
    if (!isNaN(Number(ipMap[ip])))
        ipMap[ip] = Number(ipMap[ip]) + 1;
    else
        ipMap[ip] = 1;
    return true;
}
exports.checkBanIp = checkBanIp;
function getUuidByApiKey(apiKey) {
    const pageData = user_service_1.default.getQueryWrapper().selectPage({
        apiKey
    }, 1, 1);
    if (pageData.total === 1) {
        return pageData.data[0];
    }
    return null;
}
exports.getUuidByApiKey = getUuidByApiKey;
function isApiRequest(ctx) {
    var _a;
    return ctx.query.apikey || ((_a = ctx.request) === null || _a === void 0 ? void 0 : _a.header["x-request-api-key"]) ? true : false;
}
exports.isApiRequest = isApiRequest;
function getApiKey(ctx) {
    var _a;
    return String(ctx.query.apikey || ((_a = ctx.request) === null || _a === void 0 ? void 0 : _a.header["x-request-api-key"]) || "");
}
exports.getApiKey = getApiKey;


/***/ }),

/***/ "./src/app/service/password.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.timeUuid = void 0;
const uuid_1 = __webpack_require__("uuid");
function timeUuid() {
    let uuid = (0, uuid_1.v4)().replace(/-/gim, "");
    const t = new Date().getTime() + "";
    uuid = uuid + t;
    return uuid;
}
exports.timeUuid = timeUuid;


/***/ }),

/***/ "./src/app/service/permission_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getUserByUserName = exports.isHaveInstanceByUuid = exports.isTopPermissionByUuid = exports.isTopPermission = exports.isHaveInstance = void 0;
const user_service_1 = __importDefault(__webpack_require__("./src/app/service/user_service.ts"));
function isHaveInstance(user, daemonId, instanceUuid) {
    if (isTopPermission(user))
        return true;
    if (user && user.instances) {
        for (const v of user.instances) {
            if (daemonId === v.daemonId && instanceUuid === v.instanceUuid)
                return true;
        }
    }
    return false;
}
exports.isHaveInstance = isHaveInstance;
function isTopPermission(user) {
    if (!user)
        return false;
    return user.permission >= 10;
}
exports.isTopPermission = isTopPermission;
function isTopPermissionByUuid(uuid) {
    const user = user_service_1.default.getInstance(uuid);
    if (!user)
        return false;
    return isTopPermission(user);
}
exports.isTopPermissionByUuid = isTopPermissionByUuid;
function isHaveInstanceByUuid(uuid, daemonId, instanceUuid) {
    const user = user_service_1.default.getInstance(uuid);
    if (!user)
        return false;
    return isHaveInstance(user, daemonId, instanceUuid);
}
exports.isHaveInstanceByUuid = isHaveInstanceByUuid;
function getUserByUserName(userName) {
    return user_service_1.default.getUserByUserName(userName);
}
exports.getUserByUserName = getUserByUserName;


/***/ }),

/***/ "./src/app/service/remote_command.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteRequestTimeoutError = void 0;
const uuid_1 = __webpack_require__("uuid");
const remote_service_1 = __importDefault(__webpack_require__("./src/app/entity/remote_service.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
class RemoteError extends Error {
    constructor(msg) {
        super(msg);
    }
}
class RemoteRequestTimeoutError extends RemoteError {
    constructor(msg) {
        super(msg);
    }
}
exports.RemoteRequestTimeoutError = RemoteRequestTimeoutError;
// Use RemoteRequest to send Socket.io events and data to remote services,
// and support synchronous response data (such as HTTP).
class RemoteRequest {
    constructor(rService) {
        this.rService = rService;
        if (!this.rService || !this.rService.socket)
            throw new Error((0, i18n_1.$t)("TXT_CODE_ca8072bd"));
    }
    // request to remote daemon
    async request(event, data, timeout = 6000, force = false) {
        if (!this.rService || !this.rService.socket)
            throw new Error((0, i18n_1.$t)("TXT_CODE_3d94ea16"));
        if (!this.rService.available && !force)
            throw new Error((0, i18n_1.$t)("TXT_CODE_b7d38e78") + ` IP: ${this.rService.config.ip}`);
        if (!this.rService.socket.connected && !force)
            throw new Error((0, i18n_1.$t)("TXT_CODE_7c650d80") + ` IP: ${this.rService.config.ip}`);
        return new Promise((resolve, reject) => {
            var _a, _b, _c;
            let countdownTask;
            const uuid = [(0, uuid_1.v4)(), new Date().getTime()].join("");
            const protocolData = { uuid, data };
            const fn = (msg) => {
                var _a, _b;
                if (msg.uuid === uuid) {
                    if (countdownTask)
                        clearTimeout(countdownTask);
                    (_b = (_a = this.rService) === null || _a === void 0 ? void 0 : _a.socket) === null || _b === void 0 ? void 0 : _b.removeListener(event, fn);
                    if (msg.status == remote_service_1.default.STATUS_OK)
                        resolve(msg.data);
                    else if (msg.data.err) {
                        reject(new RemoteError(msg.data.err));
                    }
                    else {
                        reject(new RemoteError(msg.data));
                    }
                }
            };
            if (timeout) {
                countdownTask = setTimeout(() => {
                    var _a, _b, _c;
                    (_b = (_a = this.rService) === null || _a === void 0 ? void 0 : _a.socket) === null || _b === void 0 ? void 0 : _b.removeListener(event, fn);
                    reject(new RemoteRequestTimeoutError([(0, i18n_1.$t)("TXT_CODE_bd99b64e"), (_c = this.rService) === null || _c === void 0 ? void 0 : _c.config.ip].join(" ")));
                }, timeout);
            }
            (_b = (_a = this.rService) === null || _a === void 0 ? void 0 : _a.socket) === null || _b === void 0 ? void 0 : _b.on(event, fn);
            // send command
            (_c = this.rService) === null || _c === void 0 ? void 0 : _c.emit(event, protocolData);
        });
    }
}
exports["default"] = RemoteRequest;


/***/ }),

/***/ "./src/app/service/remote_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const fs_extra_1 = __importDefault(__webpack_require__("fs-extra"));
const path_1 = __importDefault(__webpack_require__("path"));
const sys_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/sys_storage.ts"));
const entity_interface_1 = __webpack_require__("./src/app/entity/entity_interface.ts");
const remote_service_1 = __importDefault(__webpack_require__("./src/app/entity/remote_service.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const urs_1 = __webpack_require__("./src/app/service/base/urs.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
// The RemoteServiceSubsystem will be one of the most important systems
// main function is to store remote services everywhere
// Scan local services, unified management, remote calls and proxies, etc.
class RemoteServiceSubsystem extends urs_1.UniversalRemoteSubsystem {
    async initialize() {
        // If it is the first startup, it will automatically try to connect to "LocalHost",
        // otherwise it will automatically read from the configuration file and connect to all remote services.
        for (const uuid of await sys_storage_1.default.getStorage().list("RemoteServiceConfig")) {
            const config = (await sys_storage_1.default.getStorage().load("RemoteServiceConfig", entity_interface_1.RemoteServiceConfig, uuid));
            const newService = new remote_service_1.default(uuid, config);
            this.setInstance(uuid, newService);
            newService.connect();
        }
        // If there is no daemon process, check whether there is a daemon process locally
        if (this.services.size === 0) {
            await this.initConnectLocalhost("");
        }
        log_1.logger.info((0, i18n_1.$t)("TXT_CODE_systemRemoteService.nodeCount", { n: this.services.size }));
        // Register for periodic connection status checks
        setInterval(() => this.connectionStatusCheckTask(), 1000 * 60);
    }
    // Register a NEW remote service to system and connect it.
    // Like: this.registerRemoteService({
    // ip: "127.0.0.1",
    // apiKey: "test_key",
    // port: 24444
    // });
    async registerRemoteService(config) {
        const instance = await this.newInstance(config);
        if (!instance)
            throw new Error((0, i18n_1.$t)("TXT_CODE_3bfb9e04"));
        await sys_storage_1.default.getStorage().store("RemoteServiceConfig", instance.uuid, instance.config);
        instance.connect();
        return instance;
    }
    // Delete the specified remote service based on UUID
    async deleteRemoteService(uuid) {
        var _a;
        if (this.getInstance(uuid)) {
            (_a = this.getInstance(uuid)) === null || _a === void 0 ? void 0 : _a.disconnect();
            this.deleteInstance(uuid);
            await sys_storage_1.default.getStorage().delete("RemoteServiceConfig", uuid);
        }
    }
    // According to the IRemoteService, New a RemoteService object
    // Used to initialize objects.
    async newInstance(config) {
        const instance = new remote_service_1.default(config.uuid || this.randdomUuid(), new entity_interface_1.RemoteServiceConfig());
        this.setInstance(instance.uuid, instance);
        await this.edit(instance.uuid, config);
        return instance;
    }
    // Edit the configuration file of the instance
    async edit(uuid, config) {
        const instance = this.getInstance(uuid);
        if (!instance)
            return;
        if (config.remarks)
            instance.config.remarks = config.remarks;
        if (config.ip)
            instance.config.ip = config.ip;
        if (config.port)
            instance.config.port = config.port;
        if (config.prefix != null)
            instance.config.prefix = config.prefix;
        if (config.apiKey)
            instance.config.apiKey = config.apiKey;
        if (config.remoteMappings != null)
            instance.config.remoteMappings = config.remoteMappings;
        await sys_storage_1.default.getStorage().store("RemoteServiceConfig", instance.uuid, instance.config);
    }
    // Scannce localhost service
    // First use, need to scan the local host
    // Note: Every time you execute "initConnectLocalhost",
    // it will be managed by the subsystem (regardless of whether the target exists).
    async initConnectLocalhost(key) {
        const ip = "localhost";
        const localKeyFilePath = path_1.default.normalize(path_1.default.join(process.cwd(), "../daemon/data/Config/global.json"));
        log_1.logger.info((0, i18n_1.$t)("TXT_CODE_systemRemoteService.loadDaemonTitle", { localKeyFilePath }));
        if (fs_extra_1.default.existsSync(localKeyFilePath)) {
            log_1.logger.info((0, i18n_1.$t)("TXT_CODE_systemRemoteService.autoCheckDaemon"));
            const localDaemonConfig = JSON.parse(fs_extra_1.default.readFileSync(localKeyFilePath, { encoding: "utf-8" }));
            const localKey = localDaemonConfig.key;
            const localPort = localDaemonConfig.port;
            return await this.registerRemoteService({ apiKey: localKey, port: localPort, ip });
        }
        else if (key) {
            const port = 24444;
            return await this.registerRemoteService({ apiKey: key, port, ip });
        }
        log_1.logger.warn((0, i18n_1.$t)("TXT_CODE_systemRemoteService.error"));
        // After 5 seconds, determine whether the daemon has been connected until a daemon is connected
        setTimeout(() => {
            if (this.services.size === 0)
                return this.initConnectLocalhost();
        }, 5 * 1000);
    }
    count() {
        let total = 0;
        let available = 0;
        this.services.forEach((v) => {
            total++;
            if (v.available)
                available++;
        });
        return { available, total };
    }
    // Periodic connection status check
    connectionStatusCheckTask() {
        var _a;
        (_a = this.services) === null || _a === void 0 ? void 0 : _a.forEach((v) => {
            if (v && v.available === false) {
                log_1.logger.warn(`Daemon exception detected: ${v.config.remarks} ${v.config.ip}:${v.config.port}, reconnecting...`);
                return v.connect();
            }
        });
    }
    changeDaemonLanguage(language) {
        for (const iterator of this.services.entries()) {
            iterator[1].setLanguage(language);
        }
    }
}
exports["default"] = new RemoteServiceSubsystem();


/***/ }),

/***/ "./src/app/service/user_service.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TwoFactorError = void 0;
const bcryptjs_1 = __importDefault(__webpack_require__("bcryptjs"));
const i18next_1 = __webpack_require__("i18next");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const md5_1 = __importDefault(__webpack_require__("md5"));
const otplib_1 = __webpack_require__("otplib");
const uuid_1 = __webpack_require__("uuid");
const sys_storage_1 = __importDefault(__webpack_require__("./src/app/common/storage/sys_storage.ts"));
const user_1 = __webpack_require__("./src/app/entity/user.ts");
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
class TwoFactorError extends Error {
}
exports.TwoFactorError = TwoFactorError;
class UserSubsystem {
    constructor() {
        this.objects = new Map();
    }
    async initialize() {
        for (const uuid of await sys_storage_1.default.getStorage().list("User")) {
            const user = (await sys_storage_1.default.getStorage().load("User", user_1.User, uuid));
            this.objects.set(uuid, user);
        }
        log_1.logger.info((0, i18n_1.$t)("TXT_CODE_systemUser.userCount", { n: this.objects.size }));
    }
    async create(config) {
        const newUuid = (0, uuid_1.v4)().replace(/-/gim, "");
        // Initialize necessary user data
        const instance = new user_1.User();
        instance.uuid = newUuid;
        instance.registerTime = new Date().toLocaleString();
        // add to the user system
        this.setInstance(newUuid, instance);
        await this.edit(instance.uuid, config);
        // Persistently save user information
        await sys_storage_1.default.getStorage().store("User", instance.uuid, instance);
        return instance;
    }
    // Update user detail
    async edit(uuid, config) {
        const instance = this.getInstance(uuid);
        if (!instance)
            return;
        if (config.userName)
            instance.userName = config.userName;
        if (config.isInit != null)
            instance.isInit = Boolean(config.isInit);
        if (config.permission)
            instance.permission = config.permission;
        if (config.registerTime)
            instance.registerTime = config.registerTime;
        if (config.loginTime)
            instance.loginTime = config.loginTime;
        if (config.apiKey != null)
            instance.apiKey = config.apiKey;
        if (config.secret != null)
            instance.secret = String(config.secret);
        if (config.open2FA != null)
            instance.open2FA = Boolean(config.open2FA);
        if (config.instances)
            this.setUserInstances(uuid, config.instances);
        if (config.passWord) {
            instance.passWordType = user_1.UserPassWordType.bcrypt;
            instance.passWord = bcryptjs_1.default.hashSync(config.passWord, 10);
        }
        await sys_storage_1.default.getStorage().store("User", uuid, instance);
    }
    validatePassword(password = "") {
        if (password.length < 9 || password.length > 36)
            return false;
        const reg = /(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])/;
        return reg.test(password);
    }
    check2FA(code, user, totpDriftToleranceSteps = 0) {
        if (!user.secret)
            throw new Error("Please contact the administrator to reset the account password");
        otplib_1.authenticator.options = { window: totpDriftToleranceSteps };
        const delta = otplib_1.authenticator.checkDelta(code, user === null || user === void 0 ? void 0 : user.secret);
        return delta != null;
    }
    checkUser(info, code2FA, totpDriftToleranceSteps = 0) {
        const inputPassword = info.passWord || "";
        for (const [uuid, user] of this.objects) {
            if (user.userName === info.userName) {
                if (user.open2FA &&
                    user.secret &&
                    !this.check2FA(code2FA || "", user, totpDriftToleranceSteps))
                    throw new TwoFactorError((0, i18next_1.t)("TXT_CODE_3d68e43b"));
                if (user.passWordType === user_1.UserPassWordType.bcrypt) {
                    if (!bcryptjs_1.default.compareSync(inputPassword, user.passWord))
                        throw new Error((0, i18n_1.$t)("TXT_CODE_fefbb457"));
                }
                else {
                    if (!((0, md5_1.default)(inputPassword) === user.passWord))
                        throw new Error((0, i18n_1.$t)("TXT_CODE_fefbb457"));
                }
            }
        }
    }
    existUserName(userName) {
        let flag = false;
        this.objects.forEach((user) => {
            if (user.userName === userName)
                return (flag = true);
        });
        return flag;
    }
    setUserInstances(uuid, instanceIds) {
        const user = this.getInstance(uuid);
        if (!user)
            return;
        instanceIds.forEach((value) => {
            if (!value.daemonId || !value.instanceUuid)
                throw new Error("Type error, The instances of user must be IUserHaveInstance array.");
        });
        user.instances = [];
        instanceIds.forEach((value) => {
            user.instances.push({
                instanceUuid: String(value.instanceUuid),
                daemonId: String(value.daemonId)
            });
        });
    }
    deleteUserInstances(uuid, instanceIds, allUsers = false) {
        if (uuid && allUsers) {
            throw new Error("Type error, The uuid and allUsers cannot be true at the same time.");
        }
        const users = allUsers ? Array.from(this.objects.values()) : [this.getInstance(uuid)];
        if (!users || users.length === 0)
            return;
        instanceIds.forEach((value) => {
            if (!value.daemonId || !value.instanceUuid)
                throw new Error("Type error, The instances of user must be IUserHaveInstance array.");
        });
        users.forEach((user) => {
            if (!user)
                return;
            user.instances = user.instances.filter((value) => {
                for (const instance of instanceIds) {
                    if (instance.daemonId === value.daemonId && instance.instanceUuid === value.instanceUuid)
                        return false;
                }
                return true;
            });
        });
    }
    getUserByUserName(userName) {
        for (const map of this.objects) {
            const user = map[1];
            if (user.userName === userName)
                return user;
        }
        return null;
    }
    getUserByUuid(uuid) {
        return this.objects.get(uuid) || null;
    }
    getInstance(uuid) {
        return this.objects.get(uuid);
    }
    setInstance(uuid, object) {
        this.objects.set(uuid, object);
    }
    hasInstance(uuid) {
        return this.objects.has(uuid);
    }
    async deleteInstance(uuid) {
        if (this.hasInstance(uuid)) {
            this.objects.delete(uuid);
            await sys_storage_1.default.getStorage().delete("User", uuid);
        }
    }
    getQueryWrapper() {
        return new mcsmanager_common_1.QueryWrapper(new mcsmanager_common_1.LocalFileSource(this.objects));
    }
}
exports["default"] = new UserSubsystem();


/***/ }),

/***/ "./src/app/service/user_sso_service.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const uuid_1 = __webpack_require__("uuid");
class UserSSOService {
    constructor() { }
    static generateSSOToken(username) {
        var _a, _b, _c;
        if (!username || typeof username !== "string")
            throw new Error("username is required!");
        const token = (0, uuid_1.v4)();
        UserSSOService.tokens.set(token, username);
        if (UserSSOService.tokens.size > 1000) {
            UserSSOService.tokens.delete(((_c = (_b = (_a = UserSSOService.tokens) === null || _a === void 0 ? void 0 : _a.keys()) === null || _b === void 0 ? void 0 : _b.next()) === null || _c === void 0 ? void 0 : _c.value) || "");
        }
        return token;
    }
    static verifySSOToken(username, token) {
        const name = UserSSOService.tokens.get(token);
        if (name === username) {
            UserSSOService.tokens.delete(token);
            return true;
        }
        else {
            return false;
        }
    }
}
exports["default"] = UserSSOService;
UserSSOService.tokens = new Map();


/***/ }),

/***/ "./src/app/service/user_statistics.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const axios_1 = __importDefault(__webpack_require__("axios"));
const version_1 = __webpack_require__("./src/app/version.ts");
// This function module is used for MCSManager user statistics,
// the purpose is to know the number of existing daily activities and installations.
// User statistics will not send any private data, user data, system information, etc.
const st = new Date().getTime();
const version = (0, version_1.getVersion)();
async function statistics() {
    return await axios_1.default.get("http://statistics.mcsmanager.com/", {
        params: {
            st,
            version
        },
        timeout: 1000 * 30
    });
}
// Only one request within 24 hours counts as valid statistics, and repeated requests are ignored
// This is set to request once every 24 hours
setInterval(async () => {
    try {
        return await statistics();
    }
    catch (error) {
        // ignore
    }
}, 1000 * 60 * 60 * 24);
// Count once when the panel starts
statistics()
    .then(() => { })
    .catch(() => { });


/***/ }),

/***/ "./src/app/service/version_adapter.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const i18next_1 = __webpack_require__("i18next");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const system_storage_1 = __importDefault(__webpack_require__("./src/app/common/system_storage.ts"));
const setting_1 = __webpack_require__("./src/app/setting.ts");
const version_1 = __webpack_require__("./src/app/version.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
function readCategoryConfig(configCategory, callback) {
    const configPaths = system_storage_1.default.readDir(configCategory);
    for (const configPath of configPaths) {
        try {
            const config = JSON.parse(system_storage_1.default.readFile(configPath));
            if (callback(config)) {
                log_1.logger.info((0, i18next_1.t)("TXT_CODE_6b2a9cab"), configPath);
                system_storage_1.default.writeFile(configPath, JSON.stringify(config, null, 4));
            }
        }
        catch (error) {
            log_1.logger.error((0, i18next_1.t)("TXT_CODE_fb75aba9"), error);
        }
    }
}
function refactorUserConfig(config) {
    let changed = false;
    const { instances } = config;
    if (instances instanceof Array && instances.length > 0) {
        for (const iterator of instances) {
            if (typeof iterator.serviceUuid === "string") {
                iterator.daemonId = iterator.serviceUuid;
                delete iterator.serviceUuid;
                changed = true;
            }
        }
    }
    return changed;
}
/**
 * Starting from version 10.8.0, the configuration file path for preset templates has changed,
 * so we will perform an automatic upgrade to ensure users' paths are updated automatically!
 */
function upgradePresetPackAddr() {
    const config = setting_1.systemConfig;
    const lastLaunchedVersion = mcsmanager_common_1.GlobalVariable.get("lastLaunchedVersion");
    // If the version is less than 10.8.0 and the version has changed,
    // then we need to upgrade the preset pack addr
    if (config && lastLaunchedVersion < 108 && (0, version_1.hasVersionChanged)()) {
        log_1.logger.warn(`Upgrading Market source addr from ${config.presetPackAddr} to https://script.mcsmanager.com/market.json`);
        config.presetPackAddr = "https://script.mcsmanager.com/market.json";
        system_storage_1.default.store("SystemConfig", "config", config);
    }
}
function detectConfig() {
    upgradePresetPackAddr();
    readCategoryConfig("User", refactorUserConfig);
}
exports["default"] = { detectConfig };


/***/ }),

/***/ "./src/app/service/visual_data.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const log_1 = __webpack_require__("./src/app/service/log.ts");
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const remote_service_1 = __importDefault(__webpack_require__("./src/app/service/remote_service.ts"));
const remote_command_1 = __importDefault(__webpack_require__("./src/app/service/remote_command.ts"));
// Visual data subsystem: responsible for collecting system data and event data, and providing some methods to display them
class LineQueue {
    constructor(maxSize, defaultValue) {
        this.maxSize = maxSize;
        this.arr = new Array();
        for (let index = 0; index < maxSize; index++) {
            this.arr.push(defaultValue);
        }
    }
    push(data) {
        if (this.arr.length < this.maxSize) {
            this.arr.push(data);
        }
        else {
            this.arr.shift();
            this.arr.push(data);
        }
    }
    getArray() {
        return this.arr;
    }
}
class VisualDataSubsystem {
    constructor() {
        this.countMap = new Map();
        // system information table
        this.systemChart = new LineQueue(60, { cpu: 0, mem: 0 });
        // panel state table
        this.statusChart = new LineQueue(60, {
            value: 0,
            totalInstance: 0,
            runningInstance: 0
        });
        // request count counter
        this.requestCount = 0;
        // system information table
        setInterval(() => {
            const info = (0, mcsmanager_common_1.systemInfo)();
            if (info) {
                this.systemChart.push({
                    cpu: Number((info.cpuUsage * 100).toFixed(1)),
                    mem: Number((info.memUsage * 100).toFixed(1))
                });
            }
            else {
                this.systemChart.push({
                    cpu: 0,
                    mem: 0
                });
            }
        }, 1000 * 10);
        // state table
        setInterval(async () => {
            // Calculate the total number of instances and the number of running instances
            const remoteInfoList = new Array();
            for (const iterator of remote_service_1.default.services.entries()) {
                try {
                    remoteInfoList.push(await new remote_command_1.default(iterator[1]).request("info/overview"));
                }
                catch (err) { }
            }
            let totalInstance = 0;
            let runningInstance = 0;
            for (const iterator of remoteInfoList) {
                if (iterator.instance) {
                    totalInstance += iterator.instance.total;
                    runningInstance += iterator.instance.running;
                }
            }
            this.statusChart.push({
                value: this.requestCount,
                totalInstance,
                runningInstance
            });
            this.requestCount = 0;
        }, 1000 * 10);
    }
    addRequestCount() {
        this.requestCount++;
    }
    getSystemChartArray() {
        return this.systemChart.getArray();
    }
    getStatusChartArray() {
        return this.statusChart.getArray();
    }
    // Trigger counting event
    emitCountEvent(eventName) {
        const v = this.countMap.get(eventName);
        if (v) {
            this.countMap.set(eventName, v + 1);
        }
        else {
            this.countMap.set(eventName, 1);
        }
    }
    // Trigger counting event
    eventCount(eventName) {
        return this.countMap.get(eventName);
    }
    // Trigger log event
    emitLogEvent(eventName, source) {
        const time = new Date().toLocaleString();
        log_1.logger.info(`The object [${source}] triggered the [${eventName}] event at ${time}`);
    }
}
exports["default"] = new VisualDataSubsystem();


/***/ }),

/***/ "./src/app/setting.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


// global configuration initialization
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.systemConfig = exports.saveSystemConfig = exports.initSystemConfig = void 0;
const setting_1 = __importDefault(__webpack_require__("./src/app/entity/setting.ts"));
const system_storage_1 = __importDefault(__webpack_require__("./src/app/common/system_storage.ts"));
const i18n_1 = __webpack_require__("./src/app/i18n/index.ts");
const uuid_1 = __webpack_require__("uuid");
let systemConfig = null;
exports.systemConfig = systemConfig;
// System persistence configuration table
function initSystemConfig() {
    exports.systemConfig = systemConfig = system_storage_1.default.load("SystemConfig", setting_1.default, "config");
    if (!systemConfig) {
        exports.systemConfig = systemConfig = new setting_1.default();
        system_storage_1.default.store("SystemConfig", "config", systemConfig);
    }
    if (systemConfig.language)
        i18n_1.i18next.changeLanguage(systemConfig.language);
    if (!systemConfig.panelId) {
        systemConfig.panelId = (0, uuid_1.v4)();
        saveSystemConfig(systemConfig);
    }
}
exports.initSystemConfig = initSystemConfig;
function saveSystemConfig(_systemConfig) {
    system_storage_1.default.store("SystemConfig", "config", _systemConfig);
}
exports.saveSystemConfig = saveSystemConfig;


/***/ }),

/***/ "./src/app/utils/sync.ts":
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.execWithMutexId = exports.execWithMutex = exports.mutexIdMap = exports.mutexMap = void 0;
const async_mutex_1 = __webpack_require__("../node_modules/async-mutex/lib/index.js");
exports.mutexMap = new WeakMap();
exports.mutexIdMap = new Map();
async function execWithMutex(fn) {
    let mutex = exports.mutexMap.get(fn);
    if (!mutex) {
        mutex = new async_mutex_1.Mutex();
        exports.mutexMap.set(fn, mutex);
    }
    const releaseLock = await mutex.acquire();
    try {
        return await fn();
    }
    finally {
        releaseLock();
        exports.mutexMap.delete(fn);
    }
}
exports.execWithMutex = execWithMutex;
async function execWithMutexId(id, fn) {
    let mutex = exports.mutexIdMap.get(id);
    if (!mutex) {
        mutex = new async_mutex_1.Mutex();
        exports.mutexIdMap.set(id, mutex);
    }
    const releaseLock = await mutex.acquire();
    try {
        return await fn();
    }
    finally {
        releaseLock();
        exports.mutexIdMap.delete(id);
    }
}
exports.execWithMutexId = execWithMutexId;


/***/ }),

/***/ "./src/app/version.ts":
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.checkBusinessMode = exports.specifiedDaemonVersion = exports.hasVersionChanged = exports.getVersion = exports.initVersionManager = exports.REDEEM_PLATFORM_ADDR = void 0;
const axios_1 = __importDefault(__webpack_require__("axios"));
const fs = __importStar(__webpack_require__("fs-extra"));
const mcsmanager_common_1 = __webpack_require__("mcsmanager-common");
const system_storage_1 = __importDefault(__webpack_require__("./src/app/common/system_storage.ts"));
const frontend_layout_1 = __webpack_require__("./src/app/service/frontend_layout.ts");
const log_1 = __webpack_require__("./src/app/service/log.ts");
const setting_1 = __webpack_require__("./src/app/setting.ts");
// A business platform for selling instances released by the MCSManager Dev Team.
// Currently, it only supports some countries and regions.
// If you do not turn on "Business Mode", MCSManager will not send any data.
exports.REDEEM_PLATFORM_ADDR = "http://localhost:3000";
const PACKAGE_JSON = "package.json";
const VERSION_LOG_TEXT_NAME = "current-version.txt";
let currentVersion = "";
function initVersionManager() {
    try {
        mcsmanager_common_1.GlobalVariable.set("lastLaunchedVersion", 100);
        mcsmanager_common_1.GlobalVariable.set("version", "Unknown");
        if (fs.existsSync(PACKAGE_JSON)) {
            const data = JSON.parse(fs.readFileSync(PACKAGE_JSON, { encoding: "utf-8" }));
            if (data.version) {
                mcsmanager_common_1.GlobalVariable.set("version", data.version);
                currentVersion = String(data.version);
            }
        }
    }
    catch (error) {
        log_1.logger.error("Version Check failure:", error);
    }
    if (currentVersion && system_storage_1.default.fileExists(VERSION_LOG_TEXT_NAME)) {
        const LastLaunchedVersion = system_storage_1.default.readFile(VERSION_LOG_TEXT_NAME);
        const lastVersionNumber = Number(LastLaunchedVersion.split(".").slice(0, 2).join(""));
        if (LastLaunchedVersion && LastLaunchedVersion != currentVersion && !isNaN(lastVersionNumber)) {
            log_1.logger.warn(`Version changed from ${LastLaunchedVersion} to ${currentVersion}`);
            mcsmanager_common_1.GlobalVariable.set("lastLaunchedVersion", lastVersionNumber);
            mcsmanager_common_1.GlobalVariable.set("versionChange", currentVersion);
            // reload layout
            (0, frontend_layout_1.getFrontendLayoutConfig)();
        }
    }
    system_storage_1.default.writeFile(VERSION_LOG_TEXT_NAME, currentVersion);
}
exports.initVersionManager = initVersionManager;
function getVersion() {
    return mcsmanager_common_1.GlobalVariable.get("version", "Unknown");
}
exports.getVersion = getVersion;
function hasVersionChanged() {
    return mcsmanager_common_1.GlobalVariable.get("versionChange") || false;
}
exports.hasVersionChanged = hasVersionChanged;
function specifiedDaemonVersion() {
    var _a;
    try {
        const data = JSON.parse(fs.readFileSync(PACKAGE_JSON, { encoding: "utf-8" }));
        return (_a = data.daemonVersion) !== null && _a !== void 0 ? _a : "1.0.0";
    }
    catch (error) {
        return "1.0.0";
    }
}
exports.specifiedDaemonVersion = specifiedDaemonVersion;
async function checkBusinessMode() {
    if (!setting_1.systemConfig)
        return;
    try {
        setting_1.systemConfig.businessMode = false;
        const { data: response } = await axios_1.default.post(`${exports.REDEEM_PLATFORM_ADDR}/api/user/check`, {
            panelId: setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.panelId,
            registerCode: setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.registerCode,
            businessMode: setting_1.systemConfig === null || setting_1.systemConfig === void 0 ? void 0 : setting_1.systemConfig.businessMode
        });
        if (response.data && response.code === 200) {
            log_1.logger.info(`Business mode is active: ${JSON.stringify(response.data)} !!!`);
            setting_1.systemConfig.businessMode = true;
        }
        else {
            setting_1.systemConfig.businessMode = false;
        }
        (0, setting_1.saveSystemConfig)(setting_1.systemConfig);
    }
    catch (error) {
        // ignore
    }
}
exports.checkBusinessMode = checkBusinessMode;
setInterval(checkBusinessMode, 1000 * 60 * 60);


/***/ }),

/***/ "@koa/router":
/***/ ((module) => {

module.exports = require("@koa/router");

/***/ }),

/***/ "axios":
/***/ ((module) => {

module.exports = require("axios");

/***/ }),

/***/ "bcryptjs":
/***/ ((module) => {

module.exports = require("bcryptjs");

/***/ }),

/***/ "fs-extra":
/***/ ((module) => {

module.exports = require("fs-extra");

/***/ }),

/***/ "i18next":
/***/ ((module) => {

module.exports = require("i18next");

/***/ }),

/***/ "iconv-lite":
/***/ ((module) => {

module.exports = require("iconv-lite");

/***/ }),

/***/ "koa":
/***/ ((module) => {

module.exports = require("koa");

/***/ }),

/***/ "koa-body":
/***/ ((module) => {

module.exports = require("koa-body");

/***/ }),

/***/ "koa-session":
/***/ ((module) => {

module.exports = require("koa-session");

/***/ }),

/***/ "koa-static":
/***/ ((module) => {

module.exports = require("koa-static");

/***/ }),

/***/ "log4js":
/***/ ((module) => {

module.exports = require("log4js");

/***/ }),

/***/ "mcsmanager-common":
/***/ ((module) => {

module.exports = require("mcsmanager-common");

/***/ }),

/***/ "md5":
/***/ ((module) => {

module.exports = require("md5");

/***/ }),

/***/ "nanoid":
/***/ ((module) => {

module.exports = require("nanoid");

/***/ }),

/***/ "open":
/***/ ((module) => {

module.exports = require("open");

/***/ }),

/***/ "otplib":
/***/ ((module) => {

module.exports = require("otplib");

/***/ }),

/***/ "qrcode":
/***/ ((module) => {

module.exports = require("qrcode");

/***/ }),

/***/ "redis":
/***/ ((module) => {

module.exports = require("redis");

/***/ }),

/***/ "socket.io-client":
/***/ ((module) => {

module.exports = require("socket.io-client");

/***/ }),

/***/ "uuid":
/***/ ((module) => {

module.exports = require("uuid");

/***/ }),

/***/ "child_process":
/***/ ((module) => {

module.exports = require("child_process");

/***/ }),

/***/ "fs":
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ "fs/promises":
/***/ ((module) => {

module.exports = require("fs/promises");

/***/ }),

/***/ "http":
/***/ ((module) => {

module.exports = require("http");

/***/ }),

/***/ "https":
/***/ ((module) => {

module.exports = require("https");

/***/ }),

/***/ "os":
/***/ ((module) => {

module.exports = require("os");

/***/ }),

/***/ "path":
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ "stream":
/***/ ((module) => {

module.exports = require("stream");

/***/ }),

/***/ "util":
/***/ ((module) => {

module.exports = require("util");

/***/ }),

/***/ "../node_modules/tslib/tslib.es6.mjs":
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: () => (/* binding */ __addDisposableResource),
/* harmony export */   __assign: () => (/* binding */ __assign),
/* harmony export */   __asyncDelegator: () => (/* binding */ __asyncDelegator),
/* harmony export */   __asyncGenerator: () => (/* binding */ __asyncGenerator),
/* harmony export */   __asyncValues: () => (/* binding */ __asyncValues),
/* harmony export */   __await: () => (/* binding */ __await),
/* harmony export */   __awaiter: () => (/* binding */ __awaiter),
/* harmony export */   __classPrivateFieldGet: () => (/* binding */ __classPrivateFieldGet),
/* harmony export */   __classPrivateFieldIn: () => (/* binding */ __classPrivateFieldIn),
/* harmony export */   __classPrivateFieldSet: () => (/* binding */ __classPrivateFieldSet),
/* harmony export */   __createBinding: () => (/* binding */ __createBinding),
/* harmony export */   __decorate: () => (/* binding */ __decorate),
/* harmony export */   __disposeResources: () => (/* binding */ __disposeResources),
/* harmony export */   __esDecorate: () => (/* binding */ __esDecorate),
/* harmony export */   __exportStar: () => (/* binding */ __exportStar),
/* harmony export */   __extends: () => (/* binding */ __extends),
/* harmony export */   __generator: () => (/* binding */ __generator),
/* harmony export */   __importDefault: () => (/* binding */ __importDefault),
/* harmony export */   __importStar: () => (/* binding */ __importStar),
/* harmony export */   __makeTemplateObject: () => (/* binding */ __makeTemplateObject),
/* harmony export */   __metadata: () => (/* binding */ __metadata),
/* harmony export */   __param: () => (/* binding */ __param),
/* harmony export */   __propKey: () => (/* binding */ __propKey),
/* harmony export */   __read: () => (/* binding */ __read),
/* harmony export */   __rest: () => (/* binding */ __rest),
/* harmony export */   __rewriteRelativeImportExtension: () => (/* binding */ __rewriteRelativeImportExtension),
/* harmony export */   __runInitializers: () => (/* binding */ __runInitializers),
/* harmony export */   __setFunctionName: () => (/* binding */ __setFunctionName),
/* harmony export */   __spread: () => (/* binding */ __spread),
/* harmony export */   __spreadArray: () => (/* binding */ __spreadArray),
/* harmony export */   __spreadArrays: () => (/* binding */ __spreadArrays),
/* harmony export */   __values: () => (/* binding */ __values),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  }
  return __assign.apply(this, arguments);
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};

function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};

function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

var ownKeys = function(o) {
  ownKeys = Object.getOwnPropertyNames || function (o) {
    var ar = [];
    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
    return ar;
  };
  return ownKeys(o);
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
});


/***/ }),

/***/ "../languages/de_DE.json":
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"TXT_CODE_00000001":"Willkommen im MCSManager-Verwaltungspanel","TXT_CODE_10088738":"Bestätigen Sie den Löschvorgang","TXT_CODE_10150756":"Ereignisgesteuerte Aufgaben","TXT_CODE_10194e6a":"Netzwerk-Alias","TXT_CODE_10430e01":"Außenpostensamen","TXT_CODE_1049cbd1":"Ob der Server Meldungen auf Debugging-Ebene im Zusammenhang mit Systemvorgängen ausgeben soll","TXT_CODE_10693964":"irgendein Programm","TXT_CODE_107695d":"Alle Spiele","TXT_CODE_108ce2e4":"Breite:","TXT_CODE_10a6d36f":"Eine Konsole, die zum Anzeigen und Interagieren mit einer Instanz verwendet wird.","TXT_CODE_10cc2794":"Beschreibung der Netzwerkarchitektur","TXT_CODE_10eeb359":"Die Anzahl der umgebenden Mobs (auch Fledermäuse genannt), die auf der Welt erscheinen können","TXT_CODE_10efed7c":"Auf „false“ setzen, um Korallen am Leben zu halten, wenn sie an Land platziert werden","TXT_CODE_1135828":"Weizenwachstumsrate","TXT_CODE_1155db3a":"Ob Server-Listener die Verwendung des GameSpy4-Protokolls zulassen sollen","TXT_CODE_115e891f":"Schneeballgenerierung deaktivieren","TXT_CODE_115e8a25":"variabler Wert","TXT_CODE_11673d8c":"Erfolgreiche Abmeldung","TXT_CODE_116db655":"Spielt einen Rülpser ab, nachdem ein Spieler den Hungerbalken durch Essen vollständig gefüllt hat","TXT_CODE_1181762b":"Feste Blockverweilzeit","TXT_CODE_11cba563":"Wird ein Huhn angegriffen, schlägt es zurück","TXT_CODE_11cfe3a1":"Befehl zum Schließen der Instanz","TXT_CODE_11d2ab6b":"RGB-Wert, der für die Farbe der Broadcast-Nachricht verwendet wird","TXT_CODE_11d5caea":"Benutzerkonto erstellen","TXT_CODE_11dd341b":"Auf „false“ setzen, um die Fähigkeit der Spieler zu deaktivieren, die Nacht durch Schlafen zu überspringen","TXT_CODE_11ecd5a9":"Unbekannter Fehler","TXT_CODE_11f8cc36":"Missbrauchslimit für Tabulatortasten","TXT_CODE_12040bf0":"Die Portnummer muss im Bereich von 0-65535 liegen","TXT_CODE_123bcd09":"Benutzerdefinierter Build mit DockerFile","TXT_CODE_12413b31":"Die Anzahl der Monster, die in jeder Welt gespawnt werden können","TXT_CODE_125812c9":"Der Farbverlauf von <text>, wenn der Füllmodus „mittel“ ist.","TXT_CODE_129475a7":"Gründe, Hardcore-Spieler rauszuschmeißen","TXT_CODE_1295831e":"Wenn die Farbwiedergabefunktion mit der Farbfunktion der Software in Konflikt steht, können Sie diese Funktion deaktivieren.","TXT_CODE_12e3afa9":"Eine sehr wichtige Einstellungsdatei für den Minecraft-Server. In dieser Datei werden fast die meisten gängigen Konfigurationen (Anschlüsse, Anzahl der Personen, Sichtweite usw.) bearbeitet.","TXT_CODE_1301e748":"Der Fehler beim unbesiegbaren Endkristall wurde behoben","TXT_CODE_13411df7":"Die SSO-Anmeldung ist fehlgeschlagen. Bitte kehren Sie zur ursprünglichen Seite zurück und versuchen Sie erneut, sich anzumelden!","TXT_CODE_1348332a":"Kontrollieren Sie, ob sich das Drachenei teleportiert, wenn es berührt wird","TXT_CODE_13663120":"Beispiel: Ohne das Ausfüllen der Parameter kann „Konsolenkarte“ nur auf der Seite „Instanzdetails“ verwendet werden.","TXT_CODE_1396f33c":"Ob ein Kaktus bei einem festen Block daneben bricht","TXT_CODE_139ef152":"Set-Version. \\nÄndere das nicht","TXT_CODE_13aa13dd":"Track-Plug-in-Anzeigetafel","TXT_CODE_13ae6a93":"Kopieren","TXT_CODE_13dfc5cb":"Verlaufslänge","TXT_CODE_13eac7e1":"Paket-Download-URL (Optional)","TXT_CODE_143db7d9":"7zip-Entpackung abgeschlossen: {{result}}","TXT_CODE_143e55cb":"ID der Artikelbeschreibungszeilennummer","TXT_CODE_143f213e":"Wachstumsrate der Reben","TXT_CODE_144caddf":"Beheben Sie, dass Spawner Wassertiere nicht korrekt spawnen; \\nMC-238526","TXT_CODE_14688b70":"Gibt Ihnen die Möglichkeit zu steuern, wie lange ein Spieler unverwundbar bleibt, wenn er zum ersten Mal erscheint.","TXT_CODE_1471ac98":"Auf „true“ setzen, damit Füchse die Mob-Griefing-Gamerule umgehen","TXT_CODE_147a2f87":"Die tatsächlich erforderliche Zeit hängt von der Netzwerkgeschwindigkeit und der Prozessorgeschwindigkeit ab. Bitte haben Sie etwas Geduld.","TXT_CODE_148d6467":"Stoppen Sie eine Instanz","TXT_CODE_15022f3e":"Verwenden Sie den Anzeigenamen in der Exit-Nachricht","TXT_CODE_1514d08f":"Der Befehl wurde erfolgreich an jeden Remote-Host gesendet. Bitte warten Sie eine Weile, um die Ergebnisse zu überprüfen.","TXT_CODE_153f705d":"Karte löschen","TXT_CODE_1544562":"Nutzlast","TXT_CODE_1548649e":"Bearbeiten Sie geplante Aufgaben","TXT_CODE_154cd636":"Die Abklingzeit der Delphinspucke","TXT_CODE_1556989":"Der Etiketteninhalt ist zu lang. \\nBitte reduzieren Sie die Anzahl der Zeichen.","TXT_CODE_1561198c":"Nach dem Hochladen der Datei erstellt und dekomprimiert die Instanz die Datei automatisch. Es kann einige Zeit dauern, bis die Dekomprimierungsaufgabe abgeschlossen ist.","TXT_CODE_1562f6cf":"Alle Installationsvorgänge wurden abgeschlossen. \\nBitte versuchen Sie, die Instanz zu starten ...","TXT_CODE_157e06a9":"Maximale Anzahl der in der TAB-Liste angezeigten Spieler","TXT_CODE_1594de63":"Die zu verwendende Standardsprache, wenn wir nicht über die vom Kunden angeforderte Sprache verfügen.","TXT_CODE_159f0203":"Monsterverfolgungsreichweite","TXT_CODE_15a381d5":"Neuen Knoten hinzufügen","TXT_CODE_15c07350":"Die Dekomprimierungs-/Komprimierungsaufgabe ist abgelaufen und wurde automatisch beendet!","TXT_CODE_15c6d4eb":"Zurücksetzen erfolgreich","TXT_CODE_15c747a6":"Verzögerung der Ticks zwischen Physik/Fließen (je niedriger, desto schneller)","TXT_CODE_15e80e9d":"Die Stufenhöhe, mit der ein Minenwagen den nächsten Block erreichen kann, ohne zu springen","TXT_CODE_15f2e564":"Nicht ausgeführt","TXT_CODE_15f5fb07":"Zugewiesener Startport","TXT_CODE_163e2d0a":"Instanzspezifikationen anzeigen, wenn der Händlermodus aktiviert ist","TXT_CODE_1644b775":"Neu","TXT_CODE_1648c9ea":"Händlerinformationen anzeigen, wenn der Händlermodus aktiviert ist","TXT_CODE_16853efe":"Berechtigungen ändern","TXT_CODE_16b4f026":"Ob die Befehlsblockkonsole stummgeschaltet werden soll","TXT_CODE_16d71239":"Übersicht","TXT_CODE_16da1c76":"Trichtertransferwaage","TXT_CODE_16e2615":"Die Todesmeldung, die erscheint, wenn der Spieler getötet wird, weil er auf einer Steinsäge stand","TXT_CODE_16e58cc1":"Ob der Enderdrache entfernt werden soll","TXT_CODE_16f55a9b":"Die Dateidekomprimierungsaufgabe wird gestartet. Wenn zu viele Dateien vorhanden sind, dauert es einige Zeit.","TXT_CODE_1704ea49":"Installieren","TXT_CODE_172c745e":"Ermöglicht die Fähigkeit, Verzauberungen zu erhöhen, die ihr maximales Level überschritten haben. \\nZum Beispiel Effizienz V + Effizienz V = Effizienz VI.","TXT_CODE_1732276b":"Die Entfernung, aus der ein Schneegolem angreift","TXT_CODE_17544b7b":"Da der Serverdateiname im komprimierten Paket nicht erkannt werden kann, geben Sie den Startbefehl bitte selbst ein.","TXT_CODE_175b570d":"Beginnend","TXT_CODE_176b2151":"Stellen Sie dies auf True ein, um die Werbung für den dedizierten Server für lokale LAN -Clients zu ermöglichen, damit er automatisch im Multiplayer -Bildschirm angezeigt wird.","TXT_CODE_1770c716":"Die Menge an Obsidian, die erforderlich ist, um einen Amboss zu beschädigen","TXT_CODE_179d7be4":"Aktivieren Sie das Rcon-Protokoll","TXT_CODE_179e8e0":"Spieler-Tracking-Reichweite","TXT_CODE_179eb7ce":"Die maximale Anzahl an Blöcken, die ein Spieler gleichzeitig generiert","TXT_CODE_17b3748b":"Überprüfen Sie die Kaufhistorie","TXT_CODE_17be5f70":"Bildname darf nicht leer sein!","TXT_CODE_17cbacf6":"Blockiere den Spieler, wenn diese Anzahl an Spielsteinen innerhalb einer Sekunde platziert wird","TXT_CODE_17f1f440":"MySQL-Datenbankadresse","TXT_CODE_180884da":"Aktivieren Sie den Händlermodus","TXT_CODE_181c72ba":"Keine geeignete Vorlage gefunden? \\nPassen Sie eine Vorlagenkonfiguration an.","TXT_CODE_181f2f08":"Informationen zum Remote-Knoten können nicht abgerufen werden","TXT_CODE_187bb567":"Alle Fälle wurden geschlossen und das Programm verlassen ...","TXT_CODE_188c7493":"Ob die Fortschrittsspeicherung deaktiviert werden soll","TXT_CODE_18b3d541":"Ob Betten explodieren, wenn ein Dorfbewohner darin schläft.","TXT_CODE_18b94497":"Umweltbedürfnisse","TXT_CODE_18cdc17f":"Titel ändern","TXT_CODE_18d2f8ae":"Sind Sie sicher, dass Sie diese Instanz und dieses Archiv löschen möchten? \\nDurch diesen Vorgang werden alle Dateien im Instanzverzeichnis gelöscht. Gehen Sie daher vorsichtig vor","TXT_CODE_18de069c":"Ermöglicht die Plünderungsverzauberung auf Scheren","TXT_CODE_18df7f10":"Bitte wählen Sie die Kategorie Ihres Serverprogramms aus","TXT_CODE_18e7e5df":"Umgebungsvariablen (Optional)","TXT_CODE_190ecd56":"Durchschnittliche Systemlast","TXT_CODE_19140a89":"Auf „true“ setzen, um nach oben gerichtete Blasenaufzüge statt nach unten gerichtete Blasenaufzüge zu erzeugen, wenn Magmablöcke unter Wasserquellenblöcken platziert/erzeugt werden.","TXT_CODE_192078c6":"Wenn ein Spieler den TilePaint-Schwellenwert überschreitet, wird festgelegt, ob er rausgeschmissen werden soll","TXT_CODE_192b48f0":"Der Server wird neu gestartet","TXT_CODE_193297ed":"Kartoffelwachstumsrate","TXT_CODE_1934114b":"Einstellungseditor für Anwendungsinstanzen, Eingabefunktionskarten für Konsoleneinstellungen und andere Funktionen","TXT_CODE_193605ab":"Auf „true“ setzen, damit Enderman Spieler ignorieren, die den Drachenkopf tragen","TXT_CODE_193f5347":"Wither erzeugt einen Soundeffektradius","TXT_CODE_195215f7":"Der Projektilversatz eines Wurftranks","TXT_CODE_196253a2":"Sollten wir Mojang zur Authentifizierung von Spielern verwenden? \\nStandardmäßig ist diese Option aktiviert.","TXT_CODE_196d6257":"Die Gleichung, die zur Berechnung eines Shulkers verwendet werden soll, der aus einer Kugel spawnt (nahe ist die Anzahl der Shulker-Entitäten in der Nähe). Lassen Sie dieses Feld leer, um immer zu spawnen, wenn ein Shulker in der Nähe ist","TXT_CODE_1981470a":"Wenn Sie instanzbezogene Dateien gleichzeitig löschen, wird das gesamte Verzeichnis, in dem sich die Instanz befindet, direkt gelöscht.","TXT_CODE_1987587b":"Erforderlich, 3 bis 12 Zeichen, jede unterstützte Sprache","TXT_CODE_19cada2a":"Das Intervall in Sekunden für das Pingen des Remote-Servers.","TXT_CODE_19f697f3":"Ich weiß, dass ich gehackt werden könnte! \\nIgnorieren Sie die Risiken!","TXT_CODE_1a0ab98b":"Legen Sie das Passwort für den RCON-Fernzugriff fest (siehe enable-rcon).","TXT_CODE_1a124d6":"Wenn Sie dies auf „false“ setzen, wird verhindert, dass Pfeile auf unbestimmte Zeit am Leben bleiben (z. B. wenn der Block, in dem der Pfeil steckt, entfernt wird, wie z. B. ein Kolbenkopf, der sich nach oben/unten bewegt).","TXT_CODE_1a37f514":"Lassen Sie das Containerprogramm durch Zuordnung den tatsächlichen Verbindungsport des Hosts verwenden","TXT_CODE_1a499109":"Die Datei existiert nicht","TXT_CODE_1a6bacc6":"Ob in der Konsole die Aufzeichnung der vom Player-Client an BungeeCord initiierten Ping-Anfragen aufgezeichnet werden soll","TXT_CODE_1a6d30de":"Blockieren Sie die Verbindung von Softcore-Spielern","TXT_CODE_1a730d48":"Der Inhalt der Konfigurationsdatei ist leer. Bitte überprüfen Sie, ob die Datei korrekt ist, oder klicken Sie oben auf die Schaltfläche „Quelldatei bearbeiten“, um mit der Bearbeitung fortzufahren.","TXT_CODE_1a77954":"Die maximale Anzahl an Ticks, die bei der Heiliung von Zombie-Dorfbewohnern zufällig ausgewählt werden.","TXT_CODE_1a8cf808":"Samen des Unterwassertempels","TXT_CODE_1ac19459":"Rate des Verschwindens von Pfeilen im Kreativmodus","TXT_CODE_1adaa4f4":"Wecken Sie das Tier bei jedem Ticken auf","TXT_CODE_1af148fe":"Es existiert eine Datei mit demselben Namen","TXT_CODE_1b1b2934":"Der RCON-Befehl konnte aufgrund eines falschen Passworts nicht gesendet werden. Bitte überprüfen Sie das im Steam Rcon-Protokoll festgelegte Zugangspasswort!","TXT_CODE_1b450b79":"Bitte geben Sie den Verzeichnisnamen ein","TXT_CODE_1b518dd0":"Blockfallmultiplikator für hellgrünes Bett","TXT_CODE_1b688710":"7zip-Entpackung fehlgeschlagen: {{message}} (Details: {{details}})","TXT_CODE_1b763e24":"Zeigt die IP des Spielers an, der über die Log-Berechtigung verfügt, wenn der Spieler beitritt","TXT_CODE_1b78c12e":"Ausgabe des Platzhalters <Minuten> in der Option command.uptime.format","TXT_CODE_1b7a8832":"Auftrag abgesagt!","TXT_CODE_1b7f826e":"Der Projektilversatz einer Armbrust","TXT_CODE_1b82883f":"Welche Farbe soll angezeigt werden, wenn die RAM-Auslastung „mittel“ ist?","TXT_CODE_1b858414":"Auf „true“ setzen, um den Enderdrachen reiten zu können","TXT_CODE_1baf656e":"Wählen Sie ein vorhandenes Verzeichnis auf dem Server aus","TXT_CODE_1bc41425":"Ob Spieler im Kreativmodus beim Spawnen von Mobs ignoriert werden sollen oder nicht.","TXT_CODE_1c18acc0":"Darstellungseinstellungen","TXT_CODE_1c2efd38":"Es konnte keine Netzwerkverbindung mit dem Remote-Knoten hergestellt werden. Bitte überprüfen Sie, ob der Remote-Knoten normal funktioniert. \\nIst das Netzwerk richtig konfiguriert?","TXT_CODE_1c36c8f2":"Instanz abwürgen","TXT_CODE_1c38439b":"Auf „true“ setzen, damit Silberfische die Mob-Griefing-Gamerule umgehen","TXT_CODE_1c45f7fe":"Bearbeiten Sie die Serverkonfigurationsdatei","TXT_CODE_1c6e2cd":"Anzahl der Pilze, die man einer Kuh füttern muss, damit sie sich in einen Moospilz verwandelt. \\nDer Wert 0 deaktiviert die Funktion","TXT_CODE_1c7a8f47":"Der Server ist voll!","TXT_CODE_1c84154f":"Prozentuale Chance (0.0 – 1.0), dass ein Wolf als Tollwütiger spawnt","TXT_CODE_1cafa176":"Ermöglicht die gleichzeitige Anwendung von Verzauberungen, die normalerweise nicht kompatibel sind. \\nZum Beispiel Schutz und Brandschutz oder Glück und Behutsamkeit.","TXT_CODE_1cd8f9d2":"Konfigurationsdatei des Tshock-Servers","TXT_CODE_1ce1d1d1":"Laufzeitplattform","TXT_CODE_1ceefd70":"Die Spieler mischen","TXT_CODE_1cf6fc4b":"Die offene Portkonfiguration dieses Containers ist falsch!","TXT_CODE_1d1ec400":"Entpacken zeitüberschritten","TXT_CODE_1d39feca":"Die eigenständige Geyser-Version der Serversoftware-Konfigurationsdatei verfügt über grundlegende Serverparametereinstellungen (wie Port, maximale Anzahl von Spielern usw.) und kann auch detaillierte Serverparameter (Blockcache, Anzahl von Threads usw.) festlegen.","TXT_CODE_1d67c9c6":"Begrenzen Sie die Anzahl der Anmeldungen mit derselben IP","TXT_CODE_1d7a8617":"Der Schutzradius des Spawnpunkts wird bestimmt, indem 2x 1 auf diesen Wert angewendet wird. Wenn Sie ihn auf 0 setzen, wird nur der Block unterhalb des Spawnpunkts geschützt.","TXT_CODE_1d8746ed":"Wird für die Reparaturverzauberung auf „true“ gesetzt, um immer zuerst die am stärksten beschädigte Ausrüstung zu reparieren","TXT_CODE_1d8f3c33":"Netzwerkfehler","TXT_CODE_1d9d0746":"Benutzer-ID","TXT_CODE_1dc0000f":"Die Aktionsleistenmeldung, die angezeigt wird, wenn ein Spieler versucht zu schlafen, die Spielerregel „playersSleepingPercentage“ jedoch auf einen Wert größer als 100 eingestellt ist. Auf „Standard“ setzen, damit die Clients ihre eigenen übersetzbaren Komponenten verwenden können. \\nLegen Sie eine leere Zeichenfolge fest, um es zu deaktivieren.","TXT_CODE_1dc16497":"Maximale Block-Senderate des Spielers","TXT_CODE_1deaa2dd":"Benutzer","TXT_CODE_1df9fbd5":"Importieren","TXT_CODE_1e03347e":"Externer Zugriffsport: {{- Host}}-> Interner Containerport: {{- Container}} / Protocol: {{- Protocol}}","TXT_CODE_1e08ca6b":"Festungssamen","TXT_CODE_1e0b63b6":"Leere Datei","TXT_CODE_1e1dfbbe":"Unterschiedliche Typen führen zu unterschiedlichen Funktionen. Wenn kein Typ erforderlich ist, können Sie einen abstrakteren allgemeinen Typ auswählen, z. B. Java Universal Edition Server","TXT_CODE_1e58bb5e":"Minecraft-Endbenutzervereinbarung (EULA)","TXT_CODE_1e9c479e":"NEIN","TXT_CODE_1ed0031c":"Aktivierungsbereich der Wasserentität","TXT_CODE_1eea2726":"Macht die Arme beim Platzieren sichtbar","TXT_CODE_1efc7c5f":"Gemeinsame Konfigurationsdatei eines Neoforge -Servers","TXT_CODE_1f2062c7":"Erforderlich, 9 bis 36 Zeichen, muss Groß- und Kleinbuchstaben sowie Zahlen enthalten","TXT_CODE_1f224bef":"Ob das Speichern von Statistiken deaktiviert werden soll","TXT_CODE_1f246be3":"Mindesthöhe:","TXT_CODE_1f2d95eb":"Auf „false“ setzen, um <mob>.ridable-in-water-Optionen anstelle des DISMOUNTS_UNDERWATER-Tags zu verwenden","TXT_CODE_1f3aac40":"Deaktiviert optimierte DFU -Client -Seite - bereits auf Servern deaktiviert","TXT_CODE_1f600912":"Sollte Schaden in Lava ignoriert werden, wenn damage-if-sprinting aktiviert ist","TXT_CODE_1f61e5a3":"Originaldatei bearbeiten","TXT_CODE_1f62022c":"Ermöglicht Ihnen, die Farbe des Shulkers zu ändern, indem Sie mit der rechten Maustaste darauf klicken und einen Farbstoff verwenden","TXT_CODE_1f991d":"Die Höhe des Schadens, der verursacht wird, wenn damage-if-sprinting aktiviert ist","TXT_CODE_1fbf74d9":"Legt fest, ob der Spieler bei jedem Betreten des Servers zum Standardserver teleportiert werden soll","TXT_CODE_1fc10e3b":"Erzwingen Sie Whitelisting auf dem Server","TXT_CODE_1fe2257b":"Führen Sie die Überprüfung des Benutzernamens durch","TXT_CODE_1fec78cc":"Stellen Sie dies auf True ein, um das Kollisionsgrenzfeld der gesamten Entität auf Leitern zu überprüfen, anstatt nur den Block, in dem sie sich befinden. Verursacht bemerkenswerte Unterschiede in der Mechanik, sodass Standard das Vanilleverhalten ist. \\nStandard: Falsch.","TXT_CODE_20053f37":"Blockfallmultiplikator für hellgraues Bett","TXT_CODE_201bc643":"kein Schutz","TXT_CODE_2029027e":"Die Konfiguration des offenen Ports dieses Containers ist falsch und es gibt keine Werte auf der linken und rechten Seite des Trennzeichens!","TXT_CODE_2033383b":"Verzögerung zwischen Wellen. \\nJe niedriger der Wert, desto mehr Kreaturen gibt es","TXT_CODE_2038ec2c":"Bitte wählen Sie mindestens ein Profil aus!","TXT_CODE_20509fa0":"Liste der Knoten","TXT_CODE_2054155a":"Die maximale Höhe, in der Spieler Blöcke auf dem Server platzieren","TXT_CODE_206f0c11":"Wenn man Spielern erlaubt, sich zu registrieren, stimmt das nicht unbedingt mit ihrem Charakternamen überein","TXT_CODE_2076e91e":"zeigen","TXT_CODE_2082f659":"Hinweis: Ist dieser leer, werden die Dateien in der Dateiverwaltung nicht an den Container gebunden!","TXT_CODE_2093cc1a":"Kaufhistorie","TXT_CODE_20bf7fdd":"Die Gleichung für die maximale Gesundheit, die zur Berechnung der maximalen Gesundheit verwendet wird","TXT_CODE_20ce2aae":"Build fehlgeschlagen","TXT_CODE_20cec54":"Wagenrücklauf-Zeilenvorschubsymbol","TXT_CODE_20d107f1":"o true, damit die Einstellung „max-joins-per-tick“ in paper.yml pro Sekunde statt pro Tick verwendet wird","TXT_CODE_20e4ab72":"Auf „false“ setzen, um zu verhindern, dass Piglins trauern","TXT_CODE_21077dc4":"Legen Sie fest, wie viel Schaden ein Schneeball verursacht (-1 macht den Schaden für Flammen zu 3).","TXT_CODE_21b8b71a":"Normale Berechtigungen eignen sich für Geschäftsanwender und die höchsten Berechtigungen eignen sich für Manager.","TXT_CODE_2203d4ff":"Alle Paketverarbeitungsmethoden","TXT_CODE_221bf389":"Ob falsche Kühlanweisungen gesendet werden sollen.","TXT_CODE_2222777e":"Ist in der URL-Adresse oder den Initialisierungseinstellungen nicht vorhanden.","TXT_CODE_22510c5c":"Anmeldekonto","TXT_CODE_2266908":"Hinterlässt eine Spur, auf der ein Schneemann läuft, wenn er geritten wird","TXT_CODE_226b6c9e":"Ermöglichen Sie nie endende Einbruchsereignisse","TXT_CODE_22b2a206":"Trennzeiten","TXT_CODE_22b5f37d":"Die Menge an Quellen, die erforderlich ist, um unendliche Lava zu haben","TXT_CODE_22c68314":"Auf „true“ setzen, wenn dieser Mob immer Erfahrung verlieren soll","TXT_CODE_22cf9c9d":"Geben Sie hier den Lese-Timeout für die Verbindung an. \\nDer Standardwert beträgt 30 Sekunden.","TXT_CODE_2313aab2":"Ob Antworten auf GameSpy 4-Abfrageantworten aktiviert werden sollen.","TXT_CODE_23178d7d":"Begrenzen Sie die Anzahl der pro Block gespeicherten Entitäten","TXT_CODE_233624ad":"Webseitenzugriffsport, bitte geben Sie reine Zahlen ein, der Standardport ist 23333.","TXT_CODE_233dd4f8":"Wie lange soll die Gesundheitsregeneration verzögert werden?","TXT_CODE_235cd293":"Gibt an, welche Zeichenfolge als Startteil des Befehls verwendet werden soll. \\nWenn die Länge größer als 1 ist, funktioniert es möglicherweise nicht richtig.","TXT_CODE_236f70aa":"Benutzereinstellungen","TXT_CODE_2374966e":"Chatformat im Spiel ändern: {0} = Gruppenname, {1} = Gruppenpräfix, {2} = Spielername, {3} = Gruppensuffix, {4} = Chatnachricht.","TXT_CODE_2375f010":"Neu installieren","TXT_CODE_238c4c01":"Auf „true“ gesetzt, damit Schneegolems die Mob-Griefing-Gamerregel umgehen","TXT_CODE_2393baa2":"runder Stein","TXT_CODE_23a3bd72":"abnormal","TXT_CODE_23b02a65":"Konfiguration des Instanzstatus-Abfrageprotokolls","TXT_CODE_240252a":"Leiten Sie die Spieleranzahl und die maximale Spieleranzahl des Remote-Servers an Bedrock Edition-Spieler weiter.","TXT_CODE_2415440f":"Wenn nicht kompatible Verzauberungen zusammen angewendet werden, wird die Verzauberung nicht im Basisgegenstand verwendet, sondern durch die Verzauberung im sekundären Gegenstand ersetzt.","TXT_CODE_2418225f":"Zu statistischen Zwecken bitte nicht ändern oder löschen","TXT_CODE_2428b9c0":"Der Farbverlauf von <text>, wenn der Füllmodus „niedrig“ ist.","TXT_CODE_2432f4cc":"Bitte stellen Sie sicher, dass der Aktivierungscode gültig ist und mit den Instanzplanspezifikationen übereinstimmt.","TXT_CODE_243a463":"Serverzugriffsport","TXT_CODE_2452016e":"Bitte kopieren Sie den folgenden Inhalt manuell","TXT_CODE_2471b9c":"Suche nach Benutzername","TXT_CODE_247f6613":"Auf „false“ setzen, damit Geistliche keine Netherwarzen auf andere Dorfbewohner werfen","TXT_CODE_24843187":"Präfix für Superadministrator-Gruppenchat","TXT_CODE_24873a8a":"Loginseite","TXT_CODE_2493e6fc":"Berechtigungskontrolle verwenden","TXT_CODE_2498e4ed":"Bessere Überwachung des Serverstatus","TXT_CODE_249df6f2":"Die maximal zulässige Anzahl an Bienen in einem Bienenstock/Bienennest","TXT_CODE_24c2172c":"Macht diesen Mob immun gegen EAR (Entity Activation Range – Siehe spigot.yml)","TXT_CODE_24c4768a":"Sie können die Datenquelle für App Marketplace herunterladen, ändern und auf jeden Server hochladen, um Ihren eigenen Modpack zum Marktplatz hinzuzufügen.","TXT_CODE_24e5bff2":"Zustand","TXT_CODE_25023ad0":"Ermöglicht dem Spieler, den Fluch der bindenden Rüstung zu entfernen, wenn auf ihn ein Schwächeeffekt angewendet wird","TXT_CODE_2541ce4d":"Wie lange sollte die Verzögerung eines großen Dripleafs dauern, bis es vollständig zusammenfällt?","TXT_CODE_255606fb":"Wie lange Backups in Minuten aufbewahrt werden sollen","TXT_CODE_25699fea":"Konfigurationsdatei des MCDReforged-Serversteuerungstools","TXT_CODE_256e5825":"Docker muss im Voraus installiert werden. \\nVerwenden Sie dann jedes Bild, das Sie auf DockerHub gefunden haben, um die Instanz zu erstellen, zu installieren und zu starten.","TXT_CODE_25924d5a":"Maximale Anzahl von Ticks, die von der Entität verarbeitet werden","TXT_CODE_25af3af3":"RCON-Zugangspasswort","TXT_CODE_25cb04bb":"In der Zwischenablage gespeichert","TXT_CODE_260d96a0":"Wenn der Wert auf „true“ gesetzt ist, werden dem Spieler gegebene Gegenstände direkt in sein Inventar eingefügt. \\nAndernfalls werden dem Spieler gegebene Gegenstände als fallengelassene Gegenstände generiert. \\nExperimentelle Funktion, funktioniert möglicherweise nicht richtig oder führt zum Verlust von Gegenständen","TXT_CODE_26407d1f":"Fehler melden","TXT_CODE_2645196f":"Maximale Paketverarbeitungsrate","TXT_CODE_26495d02":"Sie können den Startbefehl eingeben, z. B. java -jar demo.jar. Wenn Sie den Startbefehl nicht eingeben, hat der im Bild definierte Befehl Vorrang.","TXT_CODE_266b7246":"Schnelle Bereitstellung von Minecraft","TXT_CODE_2695488c":"Bitte geben sie einen Benutzernamen ein","TXT_CODE_26d7316f":"Die Dekomprimierungsaufgabe ist fehlgeschlagen!","TXT_CODE_2728d0d4":"Kommandoassistent","TXT_CODE_273d24e0":"Automatischer Start","TXT_CODE_2759226f":"Wachstumsrate von Zuckerrohr","TXT_CODE_27594db8":"Markt","TXT_CODE_2764f197":"Bitte füllen Sie das Formular vollständig aus","TXT_CODE_276756b2":"Sind Sie sicher, dass Sie diese Aktion ausführen möchten?","TXT_CODE_2793b84":"Deaktivieren Sie die Teleport-Erstickungsprüfung","TXT_CODE_2799a1dd":"Erstellen Sie schnell Anwendungsinstanzen","TXT_CODE_27b7102a":"Keine Berechtigung zum Ausführen der Eingabeaufforderung","TXT_CODE_27ecd5c9":"Verzögerung erzeugen – Ticks","TXT_CODE_27ee6bf8":"Der Gradient von <text>, wenn die RAM-Auslastung „gut“ ist.","TXT_CODE_27efac3b":"Erfolgreich bearbeitet","TXT_CODE_27efff22":"Wachstumsrate der Höhlenrebe","TXT_CODE_27f641c1":"Dschungelsamen","TXT_CODE_27fd08b9":"Multiplikator für den Hungerwertabbau für andere Aktivitäten","TXT_CODE_28013340":"Auf „false“ setzen, um zu verhindern, dass Flüssigkeiten ticken.","TXT_CODE_28116f29":"Bedrock Edition Minecraft-Server","TXT_CODE_28124988":"Stammverzeichnis des Programms","TXT_CODE_2818a7bc":"voll stornieren","TXT_CODE_28190dbc":"Erfolgreich löschen","TXT_CODE_281c9d37":"Ob Fehlerinhalte in der Protokolldatei aufgezeichnet werden sollen","TXT_CODE_282b0721":"Steam Rcon-Protokolleinstellungen","TXT_CODE_28357e8b":"Floodgate verwendet Verschlüsselung, um die Nutzung durch autorisierte Quellen sicherzustellen. \\nDies sollte auf den von Floodgate generierten öffentlichen Schlüssel verweisen (BungeeCord, Spigot oder Velocity).","TXT_CODE_2841f4a":"Bitte wählen Sie das Format der komprimierten Datei aus","TXT_CODE_2864bfbc":"Gehen Sie zur Instanzdateiverwaltung","TXT_CODE_2880eed4":"RCON Passwort","TXT_CODE_288830f4":"Die Anzahl der Sekunden, die der Spieler warten muss, bevor er wieder erscheint. \\nGültiger Bereich: 0 (Standard) bis 15 Sekunden. \\nBenutzung auf eigene Gefahr","TXT_CODE_28bf8a1b":"Ob Timings aktiviert werden sollen","TXT_CODE_28bfb02":"Wenn dieser Agent einen Client mit einem anderen ISP/AS als Mojangs Authentifizierungsserver sendet, wird der Spieler gekickt.","TXT_CODE_28ce635a":"Noch keine Musik","TXT_CODE_28e53fed":"Remote-Knoten verwalten","TXT_CODE_2908dac":"Name der benutzerdefinierten Berechtigungsdatei","TXT_CODE_2930907c":"Maximale Anzahl automatisch gespeicherter Blöcke pro Tick","TXT_CODE_2931127f":"Mit der globalen Konfigurationsdatei der PaperSpigot-Serversoftware können erweiterte Parameter und spezifischere Spieleinstellungen weiter konfiguriert werden, was einen entscheidenden Einfluss auf die Gesamtleistung hat.","TXT_CODE_2958a0f8":"Herzlichen Glückwunsch, die Instanz wurde erfolgreich erstellt","TXT_CODE_29b7eca5":"Zielgruppenentitäten ignorieren","TXT_CODE_2a07bba3":"Start – jeder Spieler","TXT_CODE_2a1fc6cc":"Legen Sie die Portnummer für den RCON-Fernzugriff fest","TXT_CODE_2a22c2ff":"Keine Zugriffsberechtigung für Zwischenablage, Browser-Einstellungen prüfen","TXT_CODE_2a2dfc09":"Spieler im Kreativmodus sind immun gegen Phantomangriffe","TXT_CODE_2a34c50a":"Sprache","TXT_CODE_2a370f1c":"Auf „true“ setzen, um beim Schleichen das Brechen einzelner Platten in einem Doppelplattenblock zu ermöglichen","TXT_CODE_2a379a13":"Optional können Sie entsprechend Ihrem Startprogramm die erforderlichen Angaben eintragen, z. B.: -server -XXX -ZZZ usw.","TXT_CODE_2a3b0c17":"endgültige Bestätigung","TXT_CODE_2a4f13d4":"Zeigt den Radius des benutzerdefinierten Kopfes in Blöcken um den Player an.","TXT_CODE_2a82b720":"Prozentuale Chance (0,0 – 1,0), dass eine Entität linkshändig spawnt","TXT_CODE_2a84466d":"Maximale Anzahl automatischer Speicherungen des Spielers pro Tick","TXT_CODE_2a8dc13f":"Wird verwendet, um den Status aller mit dem Panel verbundenen Remote-Knoten anzuzeigen","TXT_CODE_2ab036a4":"Bitte geben Sie den Gameserver-Port ein","TXT_CODE_2ab3e9fd":"Stellen Sie eine beliebige Konsolenanwendung bereit","TXT_CODE_2abeb185":"Durch die Sprachänderung werden hier gleichzeitig die Sprachen aller Knoten und aller Benutzer geändert.","TXT_CODE_2ad9f3a0":"Wie groß muss ein Minecraft-Datenpaket sein, bevor wir es komprimieren? \\nWenn Sie den Wert auf Null setzen, werden alle Pakete komprimiert. Wenn Sie ihn auf -1 setzen, wird die Komprimierung vollständig deaktiviert.","TXT_CODE_2af87548":"Alle Versionen","TXT_CODE_2b221e02":"Nach der Aktivierung wird die Instanz in einer „Sandbox“-Umgebung ausgeführt und die meisten Vorgänge haben keine Auswirkungen auf die Hostsicherheit.","TXT_CODE_2b524bbf":"Für jeden Spielmodus auf „true“ setzen, um eine eigene Berechtigung zu erfordern","TXT_CODE_2b5fd76e":"Der Befehl „Öffnen“ wurde ausgegeben","TXT_CODE_2b9e9b5":"Beschränken Sie die Ausführung von Containern auf bestimmten CPU-Kernen","TXT_CODE_2ba4bf6f":"Das SQL-Protokoll greift auf das Textprotokoll zurück, nachdem das Einfügen von Datensätzen mehrmals fehlgeschlagen ist.","TXT_CODE_2bcc4e34":"Wird nach dem Hochladen automatisch gespeichert","TXT_CODE_2be83d36":"Ausnahme beim Dekomprimierungs- und Komprimierungsprogramm. Stellen Sie sicher, dass die Datei, die Sie verarbeiten möchten, vorhanden und legal ist. Bitte versuchen Sie es später erneut.","TXT_CODE_2bfc02ef":"Name des Weiterleitungsserverprotokolls (z. B. BungeeCord [X.X], Paper 1.X).","TXT_CODE_2c1337d":"Liste der Tags für diese Instanz","TXT_CODE_2c194599":"Ob beim Speichern eine Ankündigung ausgegeben werden soll","TXT_CODE_2c19f3b2":"Der Betrag, in dem sich dieser Effekt auf Entitäten auswirkt","TXT_CODE_2c41a36d":"Die vom Internet unterstützte maximale MTU beträgt 1492, dies kann jedoch zu Problemen mit der Paketfragmentierung führen.","TXT_CODE_2c4d586f":"Dungeons und unterirdische Festungen werden weiterhin generiert, nachdem bei der Erstellung der Welt generierte Strukturen (z. B. Dörfer) deaktiviert wurden.","TXT_CODE_2c69ab15":"Abmelden","TXT_CODE_2c7bcdfa":"1. Diese Seite ist für jedermann zugänglich und Sie können Karten mit beliebigen Berechtigungen platzieren.","TXT_CODE_2c9083a1":"Instanz auswählen","TXT_CODE_2ca42b39":"Zeigt den angegebenen Text an und unterstützt die Markdown-Syntax","TXT_CODE_2ce63943":"Frühes Fenster beginnt maximiert","TXT_CODE_2ce953da":"Unbekanntes Profil","TXT_CODE_2cf59872":"Seite öffnen","TXT_CODE_2cfbaa90":"Radius-Dorfbewohner suchen nach vorhandenen Eisengolems, bevor sie weitere hervorbringen. \\nDer Wert 0 deaktiviert Funktionen","TXT_CODE_2d542e4c":"Aufgabennname","TXT_CODE_2d8a400":"Sekundäre Kategorie (Versionstyp)","TXT_CODE_2db37427":"PlaceRecipePacket-Paketverarbeitungsintervall","TXT_CODE_2dbd3cd3":"Betreten Sie die Händlerkonsole","TXT_CODE_2dc23f7a":"Wählen Sie die Dekomprimierungskodierung aus","TXT_CODE_2de4c590":"Ausgabe des Platzhalters <day> in der Option command.uptime.format","TXT_CODE_2de92a5d":"Bitte wählen Sie vor der Installation einen Knoten aus!","TXT_CODE_2debc7ae":"Extremmodus (automatisch blockiert nach dem Tod)","TXT_CODE_2e0e1dfa":"Sentry DSN für verbesserte Fehlerprotokollierung, zum Deaktivieren leer lassen","TXT_CODE_2e4469f6":"Verfügbare Anschlussports:","TXT_CODE_2e5d3d0f":"Eigentümer","TXT_CODE_2e660675":"Eine Liste von Entitäten, die bei der Aktivierung ignoriert werden sollen","TXT_CODE_2ea7af21":"Was ist Docker? \\nWarum wird es benötigt?","TXT_CODE_2ee6fd18":"Beim Zugriff auf Panel von","TXT_CODE_2efcbf1e":"Ausgabe-Kodierung","TXT_CODE_2f07d608":"Das Intervall nach dem letzten Verbindungsversuch des Clients, bevor eine weitere Verbindung zugelassen wird","TXT_CODE_2f09a53c":"Behebt MC-163962, wo die Nachfrage der Dorfbewohner auf unbestimmte Zeit zurückgeht. \\nPaper fügt einen Patch hinzu, um dieses Problem zu beheben, indem verhindert wird, dass die Nachfrage unter Null sinkt. \\nMit dieser Option kann der Mindestbedarf konfiguriert werden.","TXT_CODE_2f291d8b":"Instanztyp","TXT_CODE_2f59807a":"Serveradresse","TXT_CODE_2f87036a":"Maßstab des Mobs","TXT_CODE_2f900008":"Nethersamen","TXT_CODE_2fa46b8c":"Die Bilddatei wird heruntergeladen. Bitte warten Sie geduldig. \\nBildname:","TXT_CODE_2fb14927":"Dieser Fehler bedeutet normalerweise, dass die Webseite keine direkte Verbindung zum Backend-Prozess herstellen kann. \\nWenn Sie Portweiterleitung, Mapping, Reverse-Proxy haben, überprüfen Sie bitte die Konfiguration!","TXT_CODE_2fb7e284":"Ob BungeeCord den Online-Modus aktiviert","TXT_CODE_2fe0cc84":"Bitte wählen Sie einen Wochentag aus","TXT_CODE_2fe6e00e":"Wenn der Spieler in einem Portal feststeckt und keine Möglichkeit hat, herauszukommen, wird durch das Gehen zu einem anderen Block die Abklingzeit des Portals zurückgesetzt, sodass er sich durch das Portal zurückteleportieren kann","TXT_CODE_30051f9b":"Instanz-ID:","TXT_CODE_300c2ff4":"Remote-Knotenschlüssel","TXT_CODE_30258325":"Containerverzeichnis","TXT_CODE_3036d123":"Ob die Spielerposition des Clients an die Position des Serverspielers angepasst werden soll, wenn der Bewegungswert den Schwellenwert überschreitet","TXT_CODE_30aa5133":"IP-Adresse des Java-Servers","TXT_CODE_30fcc19a":"Benutzer <<operator_name>> hat die Konfiguration der Instanz <<instance_name>> geändert","TXT_CODE_30fe1717":"Optional, zum Beispiel 0,1,2,3","TXT_CODE_31145b04":"Wiederholung {Retries}/{maxretries}}","TXT_CODE_311b2d6b":"Schwächt Mobs, die von Spawnern gespawnt werden","TXT_CODE_312cd9f0":"PlaceRecipePacket-Paketverarbeitungsmethode","TXT_CODE_313db7d2":"Fossile Samen","TXT_CODE_314aa817":"Leiten Sie den Hostnamen weiter, der vom Bedrock Edition-Client verwendet wird, um eine Verbindung zum Java-Server herzustellen","TXT_CODE_317e0cc1":"Andere Tracking-Bereiche","TXT_CODE_3183c301":"Blitzeinschlagswahrscheinlichkeit","TXT_CODE_31a1d824":"Erweiterte Einstellungen","TXT_CODE_31a48870":"Benutzer <<operator_name>> hat versucht, sich anzumelden, Ergebnis: <<login_result>>","TXT_CODE_31c10b14":"Auf „true“ setzen, damit der Feuerwiderstandstrank-Effekt Partikel anzeigt","TXT_CODE_31c5a4d0":"Web-Shell","TXT_CODE_31edf78":"Auf „false“ setzen, um zu verhindern, dass zombifizierte Piglins XP verlieren, wenn sie von einem Spieler verärgert (aber nicht getötet) werden","TXT_CODE_320f4304":"Serverdateiverzeichnis","TXT_CODE_3243b4f8":"Truhe des Piglin-Wächters","TXT_CODE_3247f016":"Die Menge an Quellen, die erforderlich ist, um unendlich viel Wasser zu haben","TXT_CODE_328191e":"Es eignet sich für Situationen, in denen der Host über mehrere Netzwerkkarten und mehrere IP-Adressen verfügt. Wenn Sie nur eine öffentliche IP haben, legen Sie dieses Element bitte nicht fest.","TXT_CODE_329fb904":"In neuen Ordner entpacken","TXT_CODE_32bf92a1":"Wie viele NPCs kann die Statue innerhalb von 600 Pixeln spawnen, bevor sie nicht mehr spawnt? \\nStandardwert 6","TXT_CODE_32cd41d5":"Datei wird heruntergeladen...","TXT_CODE_32d87bf1":"Die meisten Steam-Spieleserver erfordern das RCON-Protokoll zur Unterstützung der Befehlsausführung und unterstützen auch den Minecraft-Spieleserver. Wenn Sie feststellen, dass die integrierte Konsole beim Ausführen des Steam-Spieleservers keine Befehle ausführen kann, können Sie versuchen, das RCON-Protokoll auf Unterstützung einzustellen es. Der Befehl wird ausgeführt.","TXT_CODE_32eb350b":"Wenn diese Einstellung wahr ist, läuft der Server nach einer Verzögerungsspitze schneller","TXT_CODE_3354b56e":"Ob die vom Spieler in der Konsole eingegebenen Befehle aufgezeichnet werden sollen (nur BungeeCord-Befehle werden aufgezeichnet)","TXT_CODE_335ba209":"Datei aussuchen","TXT_CODE_3362d4b7":"Bild erstellen","TXT_CODE_3371000d":"Das Panel wurde installiert und kann nicht erneut installiert werden.","TXT_CODE_3378e8a5":"Was soll die maximale Spieleranzahl anzeigen? \\n(Velocity unterstützt nicht die maximale Anzahl von Online-Spielern.)","TXT_CODE_337da349":"Startzeit – Tage","TXT_CODE_33a09033":"Anzahl Personen online:","TXT_CODE_33c223c":"Ignorieren Sie die Prüfung, ob der Spieler das Projektil aktualisieren „kann“.","TXT_CODE_33ce1c5c":"Übergeben Sie Umgebungsvariablen an den Container","TXT_CODE_33d91ef6":"Ob Bücher beschreibbar sein sollten oder nicht.","TXT_CODE_34071701":"Erleben Sie den Radius der Kugelverschmelzung","TXT_CODE_3407250a":"Hängen Sie das Host-Instanzverzeichnis für die Datenpersistenz in den Container ein","TXT_CODE_34100777":"Auf „false“ setzen, um zu verhindern, dass der Dorfbewohner den Handelsgegenstand anzeigt","TXT_CODE_34148d2b":"Auf „true“ setzen, damit die Partikeleffekte weniger störend auf dem Bildschirm wirken","TXT_CODE_341bc7f3":"Skalierungsattribut","TXT_CODE_341dfd11":"Frühe Fensterhöhe","TXT_CODE_342a04a9":"Wird gewartet","TXT_CODE_342d5959":"Der Schaden der Delfinspucke","TXT_CODE_34611898":"Start-up","TXT_CODE_347ff81c":"Erlauben Sie Spielern, Hinweise auf umherziehende Händler zu nutzen","TXT_CODE_3489786b":"Verwenden Sie Berechtigungsknoten, um die Anzahl der Zeilen zu bestimmen. \\nWenn diese Einstellung aktiviert ist, verfügen alle Spieler standardmäßig über sechs Reihen, sofern in den Berechtigungen nichts anderes angegeben ist.","TXT_CODE_348c9098":"Die angegebenen Instanzdetails konnten nicht abgerufen werden. Bitte versuchen Sie es erneut!","TXT_CODE_34999278":"Das Intervall in Ticks, um zu überprüfen, ob der Dorfbewohner lobotomiert ist","TXT_CODE_349edc57":"Bitte wählen Sie eine Uhrzeit aus","TXT_CODE_3502273d":"Neue geplante Aufgabe hinzufügen","TXT_CODE_351aaf7":"Loslegen","TXT_CODE_354409b6":"Warnung vor Serverüberlastung","TXT_CODE_3549ea82":"Maximale Anzahl an Intervall-Ticks, die geschossen werden","TXT_CODE_3554dac0":"Auslösezeit","TXT_CODE_3579ab7d":"Ermöglicht das Anwenden von Verzauberungen auf Werkzeuge oder Rüstungen, die normalerweise nicht anwendbar sind. \\nZum Beispiel die Schärfe einer Spitzhacke.","TXT_CODE_35d2ee7a":"Entpacke mit 7zip in Zielverzeichnis: {{command}}","TXT_CODE_35d52619":"Chance für blühende Azaleen, auf natürliche Weise zu Bäumen zu wachsen","TXT_CODE_361a79c6":"Der Bild-Download wurde gestoppt!","TXT_CODE_36417656":"Gehen Sie zur Instanzkonsole","TXT_CODE_365aabd4":"Newline-Symbol","TXT_CODE_36622cee":"Auf „true“ setzen, um Fahrern auf einem Motorrad Nachtsicht zu ermöglichen","TXT_CODE_366bad15":"Bitte geben Sie den Namen der komprimierten Datei ein","TXT_CODE_369a4a22":"Slots reservieren. \\nAnzahl der reservierten Slots, denen reservierte Spieler beitreten können, wenn sie die maximale Anzahl an Server-Slots überschreiten","TXT_CODE_36b878dc":"Paketverarbeitungsintervall","TXT_CODE_36cae384":"Sie verwenden eine private IP -Adresse","TXT_CODE_3725b37b":"Strg C wurde gesendet!","TXT_CODE_372e7b9c":"„Bild“ klicken für Vorlagen dieser Kategorie, „Installieren“ für Bearbeitung, „Stapelbearbeitung“ zum Löschen","TXT_CODE_372e97f4":"Wenn sich die Welt im harten Modus befindet, darf sich Korruption ausbreiten","TXT_CODE_3752d436":"Ausgabe des Platzhalters <Stunde> in der Option command.uptime.format","TXT_CODE_37658aab":"Der Modifikatorwert von Schneeballprojektilen","TXT_CODE_377a62dc":"Auf „True“ setzen, um Feuer zu legen, wenn der Endkristall explodiert","TXT_CODE_377e142":"Die Dateikomprimierungsaufgabe wird gestartet. Wenn zu viele Dateien vorhanden sind, dauert es einige Zeit.","TXT_CODE_377e5535":"Bitte geben Sie einen Ordnernamen ein","TXT_CODE_3790ec90":"Ob Namespace-Anweisungen gesendet werden sollen","TXT_CODE_37924654":"Bitte geben Sie das neue Passwort erneut ein","TXT_CODE_37931fa9":"Attribut der Rüstungshärte","TXT_CODE_379fa48a":"Ausgewählt","TXT_CODE_37a4c14a":"Keine verfügbare Konfigurationsdatei gefunden","TXT_CODE_37d67b69":"Maximale TNT-Menge pro Tick","TXT_CODE_37d839a4":"Dekomprimierungs-/Komprimierungsprogramm konnte nicht gestartet werden! \\nBitte stellen Sie sicher, dass die Dateien im Verzeichnis daemon/lib vorhanden sind und über die richtigen Berechtigungen verfügen! \\nWenn es immer noch nicht funktioniert, installieren Sie das Panel neu","TXT_CODE_37f5901":"Wachstumsrate der Rote Bete","TXT_CODE_38091a03":"Zombies sind den Dorfbewohnern gegenüber feindlich eingestellt","TXT_CODE_3816e0d9":"Auf „false“ setzen, um zu verhindern, dass der Enderman trauert.","TXT_CODE_381f8f22":"Produktliste","TXT_CODE_382ec256":"Die Mindestanzahl an Zecken, aus denen beim Aushärten zufällig ausgewählt werden kann","TXT_CODE_384d278f":"Benutzer <<operator_name>> löscht den Daemon -Prozess <<daemon_id>>","TXT_CODE_3855e22f":"Wenn dem Ban-Befehl keine Parameter übergeben werden, wird die IP-Blockierung aufgehoben","TXT_CODE_38591f72":"bestimmten Zeitpunkt","TXT_CODE_386f2d66":"Der Befehl wurde gesendet, aber es erfolgt keine Antwort. Bitte überprüfen Sie das Spiel.","TXT_CODE_3897eb89":"Maximale Anzahl gleichzeitig geladener Blöcke durch einen Spieler","TXT_CODE_38a430d8":"Wählen Sie den Netzwerkmodus für den Containerzugriff aus, z. B. Bridge Bridge","TXT_CODE_38fb23a8":"Download gestartet...","TXT_CODE_393c816c":"Seite existiert nicht","TXT_CODE_3969cb6b":"Sendeentfernung automatisch einstellen","TXT_CODE_397667ff":"Notieren Sie Todesereignisse von Dorfbewohnern im Protokoll","TXT_CODE_39994770":"Spieler","TXT_CODE_39a3ba38":"Dorfsamen","TXT_CODE_39abde23":"Kelp-Wachstumsrate","TXT_CODE_39ac8ed3":"einfach","TXT_CODE_39bb14c1":"Meldung, die angezeigt wird, wenn ein Spieler gekickt wird, weil er einen nicht bestätigten Benutzernamen hat (Benutzer befindet sich im Offline-Modus). \\nBei der Einstellung „Standard“ wird die Standardmeldung „Benutzername konnte nicht überprüft werden!“ angezeigt.","TXT_CODE_39c5229e":"Knoteninformationen bearbeiten","TXT_CODE_39e7fa63":"Lassen Sie Schleifmaschinen die Stapelgrenze überschreiten","TXT_CODE_3a056dc8":"Benutzernamen sind in jeder Sprache verfügbar. Bitte bewahren Sie Ihr Passwort sicher auf.","TXT_CODE_3a24c7a3":"Der effektive Radius des Kanals für jeweils sieben Blöcke im Rahmen","TXT_CODE_3a302f23":"Benutzerhandbuch","TXT_CODE_3a3f9a57":"Eine sehr wichtige Konfigurationsdatei für den Minecraft Bedrock-Server. In dieser Datei werden fast die meisten gängigen Konfigurationen (Ports, Anzahl der Personen, Sichtweite usw.) bearbeitet.","TXT_CODE_3a406403":"Statusabfrage","TXT_CODE_3a51d817":"Der Grad der Dunkelheit am Himmel (5 ist dunkel genug für Gewitter, aber nicht für normalen Regen)","TXT_CODE_3a5b3d2d":"Passwort für die MySQL-Datenbank","TXT_CODE_3a5c9779":"Wenn Sie dies auf „true“ setzen, kann der Lapislazuli im Zaubertischplatz bleiben, sodass Sie Ihren Lapislazuli im Tisch lassen können","TXT_CODE_3a818e91":"Zurück zur Bilderliste","TXT_CODE_3a8fdbf1":"Verhindert, dass das Ackerland mit Füßen getreten wird, wenn direkt darunter ein Zaun oder eine Kopfsteinmauer angebracht wird","TXT_CODE_3aa9f36":"Der komprimierte oder dekomprimierte Dateiname enthält falsche Zeichen, bitte benennen Sie die Datei um!","TXT_CODE_3ae0276b":"Bitte geben Sie das RCON-Protokollzugriffspasswort des Spielservers ein, das normalerweise in der Konfigurationsdatei zu finden ist.","TXT_CODE_3aec94fb":"ZIP-Entpackung fehlgeschlagen. Mögliche Gründe:\\n1. Datei beschädigt oder passwortgeschützt\\n2. Bei Mehrteiligen Archiven (zip+z01+z02 usw.) muss 7zip aktiviert sein\\n3. Falsches Dateiformat\\nBitte Datei prüfen oder Administrator um 7zip-Aktivierung bitten.","TXT_CODE_3b1bb444":"Minute","TXT_CODE_3b1cc020":"Stornieren","TXT_CODE_3b24a247":"Klicken Sie auf die Schaltfläche „Speichern“ in der oberen rechten Ecke, um den Layoutentwurf zu speichern.","TXT_CODE_3b346a65":"Sollte Zonenschutz für Boxen gelten?","TXT_CODE_3b4260f8":"Wie viele NPCs kann eine Statue spawnen, bevor sie nicht mehr spawnt? \\nStandardwert 10.","TXT_CODE_3b4b656d":"Über MCSManager","TXT_CODE_3ba5ad":"Benutzerauthentifizierung","TXT_CODE_3bb646e4":"Bitte auswählen","TXT_CODE_3bdd7af8":"Ausgabe-Kodierung auswählen","TXT_CODE_3be23278":"Ob die Explosion einen Brand verursachen kann oder nicht","TXT_CODE_3beb6e5c":"Legen Sie fest, wie lange der Tageslichtzyklus aktiviert ist","TXT_CODE_3bfb9e04":"Die Zielinstanz existiert nicht!","TXT_CODE_3c37583b":"Das Verzeichnis unter der Dateiverwaltungsfunktion wird in dieses Verzeichnis im Container eingebunden","TXT_CODE_3c8fd4c2":"Spitzname","TXT_CODE_3c93920b":"Normale Benutzer dürfen die Neuinstallationsfunktion verwenden","TXT_CODE_3ccb26e":"Community Edition","TXT_CODE_3d046b93":"Steuert, ob dem Spieler Koordinaten angezeigt werden.","TXT_CODE_3d07fa74":"Verhindert, dass der Enderman gegen Projektile immun ist","TXT_CODE_3d0885c0":"Plattform","TXT_CODE_3d09f0ac":"Bild erstellen","TXT_CODE_3d14442a":"Verwenden Sie DockerFile, um ein beliebiges Umgebungsbild anzupassen. Dies wird technischem Personal empfohlen","TXT_CODE_3d45d8d":"Vorlage hinzufügen","TXT_CODE_3d4e1594":"PlaceRecipePacket maximale Paketverarbeitungsrate","TXT_CODE_3d56da34":"Vorlagenautor/-anbieter","TXT_CODE_3d602459":"Instanzstatus","TXT_CODE_3d68e43b":"Fehler beim zweistufigen Bestätigungscode","TXT_CODE_3d7fbe30":"Steam-Gameserver","TXT_CODE_3d94ea16":"Der Knoten-Socket ist abnormal, bitte versuchen Sie, die Verbindung in der Knotenverwaltung wiederherzustellen!","TXT_CODE_3da5e4e":"Legt fest, ob Leuchtfeuereffekte aktiviert werden sollen, wenn es durch getöntes Glas abgedeckt ist","TXT_CODE_3dbf8890":"Maximale Höhe, die dieser Mob erreichen kann, während er geritten wird","TXT_CODE_3dd66d98":"Neuer Tab","TXT_CODE_3dee9250":"Auf „true“ setzen, damit Schildkröteneier die Mob-Griefing-Gamerregel umgehen","TXT_CODE_3df4beaf":"Ob die Paketversand- und -empfangsoptimierung für die Linux-Plattform verwendet werden soll [nur Linux]","TXT_CODE_3e252bc9":"Die Größe des Eingriffs","TXT_CODE_3e4e61b3":"Auf „true“ setzen, damit Phantome im Sturzflug Flammen schießen","TXT_CODE_3e68ca00":"Zusätzlicher Mount-Pfad","TXT_CODE_3e724e40":"Anpassungen der Baby-Zombie-Bewegung","TXT_CODE_3e83082b":"Erlauben Sie die Verwendung von Beschilderungen innerhalb von Wiedergeburtsschutzgebieten","TXT_CODE_3e93e31e":"Wird bei der gemeinsamen Nutzung eines Verbindungsports verwendet. Normalerweise ist hier keine Konfiguration erforderlich","TXT_CODE_3e959ce7":"Komprimierungs-/Dekomprimierungsaufgaben werden ausgeführt...","TXT_CODE_3e98e22f":"Die Anzahl der fehlgeschlagenen Anmeldeversuche eines Spielers. Wenn die Anzahl überschritten wird, wird der Spieler direkt gekickt.","TXT_CODE_3eb58633":"Kann für die automatische Neustartfunktion nach einem Absturz verwendet werden.","TXT_CODE_3ecee271":"Diese auswählbaren Tags werden aus der aktuellen Seiteninstanzliste berechnet und umfassen nicht alle vorhandenen Tags. Hier werden maximal 30 angezeigt.","TXT_CODE_3ed96265":"iframe","TXT_CODE_3ee20639":"Einlösung erfolgreich, bitte beachten Sie Folgendes","TXT_CODE_3ef08433":"Auf „true“ setzen, um nicht verwendete/versteckte Minecraft-Befehle zu registrieren. \\nDie folgenden Befehle werden verfügbar (zusammen mit ihrem Gegenstück zur Berechtigung „minecraft.command.<command_name>“): debugconfig, serverpack, spawn_armor_trims, warden_spawn_tracker, debugmobspawning, debugpath und RAID. \\nDiese Liste ist möglicherweise unvollständig, je nachdem, ob sie entfernt oder neue in neueren Minecraft-Versionen hinzugefügt werden.","TXT_CODE_3efe364e":"Netz","TXT_CODE_3f227bcf":"Aktivieren Sie den Händlermodus, um eine Verbindung zur MCSManager-Konsole herzustellen, um Pakete anzupassen und Codes zu verkaufen","TXT_CODE_3f3e734b":"Gesperrte Elemente zulassen Ermöglicht Gruppen in der Liste, gesperrte Elemente zu erzeugen, selbst wenn PreventBannedItemSpawn auf „true“ gesetzt ist","TXT_CODE_3f470950":"Die maximale Gesundheit, die ein Spieler vor Ausrüstungs-Buffs haben kann","TXT_CODE_3f477ec":"Die Länge darf nur 3 bis 20 Zeichen betragen","TXT_CODE_3f59b48":"Der Prozentsatz des Schadens, den ein kritischer Angriff zum Grundschaden hinzufügt","TXT_CODE_3f5a2028":"Ob benutzerdefinierte Monster-Spawner Dimensionstypen verwenden","TXT_CODE_3f65b1f2":"Auf „false“ setzen, damit die Milch nur negative Statuseffekte beseitigt","TXT_CODE_3f678132":"Monster-Startreichweite","TXT_CODE_3f739f9c":"Deaktivieren Sie den Hard-Modus","TXT_CODE_3f810f66":"Standardmäßig deaktiviert (0), Anzahl der Ticks, die eine Entität überlebt, bevor sie verschwindet. \\nDurch die Interaktion mit einem Spieler wird der Timer zurückgesetzt","TXT_CODE_3f828072":"maximale Anzahl von Wiederholungen erreichen","TXT_CODE_3f99f17f":"Remote-Knoten-Version","TXT_CODE_3fce7ccb":"Zeigen Sie den Instanzstatus an, sofern der Benutzer die Berechtigung zum Betreten der Instanz hat","TXT_CODE_3fd222b0":"Bitte drücken Sie schnell erneut C, um wirksam zu werden ...","TXT_CODE_3fe97dcc":"Systemeinstellungen","TXT_CODE_400a4210":"Eingabekodierung: ","TXT_CODE_402018ce":"Kategorie","TXT_CODE_40241d8e":"Minecraft-Spielerabfrage","TXT_CODE_405cd346":"API-Schnittstelle für domänenübergreifende Anfragen","TXT_CODE_405d1f28":"OP-Berechtigungsstufe (1–4)","TXT_CODE_40a87804":"Laden Sie eine HTML-Datei hoch","TXT_CODE_40c2c2ee":"Das Intervall zwischen Sicherungen in Minuten. \\nBackups werden im Ordner tshock/backups gespeichert","TXT_CODE_40c4894a":"Aktivieren Sie die TCP-Schnellstartunterstützung auf dem Agenten. \\nErfordert, dass der Agent unter Linux ausgeführt wird.","TXT_CODE_40ca4f2":"erneuern","TXT_CODE_40ee4eaf":"Parallelität erzeugen","TXT_CODE_4126fc53":"Wenn die Bossleiste des Befehls /compass angezeigt werden soll, wenn Sie einen Kompass halten","TXT_CODE_413b9c01":"Node.js Version","TXT_CODE_41406a5f":"Datenkarte","TXT_CODE_4140aa4b":"Unterdrücken Sie Fehler, bei denen setBlock in einem entfernten Block erkannt wurde","TXT_CODE_41813325":"Ob asynchrones Mob-Spawnen aktiviert werden soll oder nicht.","TXT_CODE_41ae3d88":"Setzen Sie es auf „true“, damit Sie Portale aus weinendem Obsidian erstellen können","TXT_CODE_41d79430":"Geeignet für die Serverbetriebsumgebung MC Bedrock Edition oder andere Linux-Programme","TXT_CODE_41dd4d19":"Offizielle Website","TXT_CODE_41f86ac":"Benutzer <<operator_name>> löschte die Aufgabe <<task_name>> des <<instance_name>> Instanz","TXT_CODE_42036f92":"------Benutzeranmeldeereignis ------","TXT_CODE_42a7759b":"Das Suffix, das in der Spielerliste nach dem Namen einer Person angezeigt wird, wenn diese AFK ist","TXT_CODE_42bcfe0c":"Die Initialisierung der Konsole ist fehlgeschlagen. Bitte aktualisieren Sie die Webseite und versuchen Sie es erneut!","TXT_CODE_42e25bc2":"Wenn Sie dies auf „false“ setzen, ist eine RNG-Manipulation möglich. \\nPaper behebt die RNG-Manipulation durch Verwendung einer gemeinsam genutzten (und gesperrten) Zufallsquelle. \\nDies geht mit einem Leistungsgewinn einher, aber technisch versierte Spieler ziehen es möglicherweise vor, dies auszuschalten, um RNG manipulieren zu können.","TXT_CODE_4306a0d0":"Online-(echte) Verifizierung","TXT_CODE_43248597":"Paste","TXT_CODE_432cbc38":"Ausgewählt:","TXT_CODE_432cfb62":"Noch kein Profil","TXT_CODE_43422ed3":"Java-Pfad","TXT_CODE_434786c9":"Nach dem Hochladen eines Hintergrundbilds wird das Panel auf ein dunkles Thema eingestellt und unscharf und durchscheinend, und Sie können jederzeit zurückwechseln.","TXT_CODE_435f4975":"Verwenden Sie Bilder von Docker Hub","TXT_CODE_438aa1":"Image-Name","TXT_CODE_43984628":"Wachstumsrate der Netherwarze","TXT_CODE_43df9305":"Unbekannter Betrieb","TXT_CODE_43eedf83":"Bei welcher Lichtstärke werden die Phantome brennen?","TXT_CODE_43fcaf94":"Erfolgreich","TXT_CODE_442c0649":"Das maximale Wachstumsalter, in dem die Pflanze wachsen kann","TXT_CODE_443ac54f":"Aktivieren oder deaktivieren Sie Anti-Cheat-Reichweitenprüfungen basierend auf der Entfernung zwischen dem Spieler und seinem Kachelstandort","TXT_CODE_44454300":"Maximales Erlebnis vereint","TXT_CODE_444db70f":"Laden Sie Einzelserversoftware hoch","TXT_CODE_447a9fc4":"Protokollpfad","TXT_CODE_448d08eb":"Auf „true“ setzen, um Teleportbeschränkungen für Endportale aufzuerlegen. \\nDadurch wird das EntityTeleportHinderedEvent-Ereignis gesendet, das die Möglichkeit bietet, Teleports erneut zu versuchen, wenn sie aufgrund von Passagieren/Fahrzeugen fehlschlagen","TXT_CODE_448df2bd":"Für den Beitritt zum Server ist ein Passwort erforderlich","TXT_CODE_449d1581":"Eingabe- und Ausgabekodierung","TXT_CODE_449efd26":"Deaktivieren Sie den Player, wenn diese Anzahl an HealOtherPlayer-Paketen innerhalb einer Sekunde gesendet wird","TXT_CODE_44a472a5":"Deaktivierte Anweisungen","TXT_CODE_44ae0e7":"Komm mit einem schönen Namen!","TXT_CODE_44c67809":"Überspringen Sie bestimmte GL -Versionen, kann bei Buggy -Grafikkartentreibern helfen","TXT_CODE_44f46508":"Blockfallmultiplikator für Grünbeet","TXT_CODE_450481c5":"Diese Karte kann beim Hinzufügen nicht in der Vorschau angezeigt werden. Bitte füllen Sie nach dem Hinzufügen die entsprechende Parameterkarte aus, damit sie normal funktioniert.","TXT_CODE_451f9968":"Einsperren von Zombie-Piglins über Netherportale","TXT_CODE_45364559":"Bitte geben Sie den URL-Link ein","TXT_CODE_458c34db":"Beispiellink","TXT_CODE_458df26d":"Ob das Speichern des Spielerprofils deaktiviert werden soll","TXT_CODE_45d7b982":"Es wurden keine Plan -Details anfordern. \\nBitte versuchen Sie es später noch einmal!","TXT_CODE_45e8f121":"Zusätzliche Tags (Optional)","TXT_CODE_4600deb7":"jedes Konsolenprogramm","TXT_CODE_46039f9b":"Laufzeitplattform auswählen","TXT_CODE_461d1a01":"Suche nach Knotennamen","TXT_CODE_462ba96":"UUID dieses Servers, ändern Sie sie nicht","TXT_CODE_463375d2":"Über diese Seite","TXT_CODE_46410888":"Ob Phantome Spieler mit einer Fackel in der Hand meiden","TXT_CODE_46ba576a":"Auf „false“ setzen, um zu verhindern, dass sich Rüstungsständer bewegen","TXT_CODE_46bb965":"Einen Steam-Spieleserver erstellen","TXT_CODE_46c4169b":"Ausschneiden","TXT_CODE_46c48969":"Anscheinend versuchen Sie, HTTPS zu verwenden, aber wir können über das WSS-Protokoll keine Verbindung zum Daemon herstellen. \\nBitte versuchen Sie, über das WSS://-Protokoll eine Verbindung zum Daemon herzustellen.","TXT_CODE_46c4e9ac":"schreiben","TXT_CODE_46cb40d5":"Werden Sie Sponsor","TXT_CODE_46f575ae":"Zuletzt gestartet: ","TXT_CODE_47071ef6":"Geschwindigkeit des Pfeilverschwindens","TXT_CODE_47129a5b":"Wenn nicht ausgefüllt, wird automatisch die lokale Adresse von localhost verwendet.","TXT_CODE_47203b64":"Alle Systeme","TXT_CODE_4745436a":"Dorfbewohner werden von Smaragdblöcken in Versuchung geführt und folgen den Spielern, die sie halten","TXT_CODE_47491a7e":"Welche Farbe soll angezeigt werden, wenn der Füllmodus „mittel“ ist?","TXT_CODE_475c5890":"Zum Beispiel: Mein erster Server","TXT_CODE_47667d86":"Lassen Sie deadmau5-Ohren von Drittanbietern sichtbar sein.","TXT_CODE_4770de17":"Händlerinformationen","TXT_CODE_477ece61":"Installation abgeschlossen","TXT_CODE_478717e2":"Dies ist die Nachricht, die gesendet wird, wenn ein Benutzer AFK wechselt (es muss ein Player-Idle-Timeout größer als 0 eingestellt sein).","TXT_CODE_479389a":"Erlauben Sie den Spielern, Farbcodes auf Schildern zu verwenden","TXT_CODE_47b5a2f7":"Logo-Bild","TXT_CODE_47c35915":"Layout gespeichert","TXT_CODE_47c62dac":"Verwenden Sie Bilder","TXT_CODE_47d09eea":"Tab abgeschlossen","TXT_CODE_47d56d0d":"Instanz -Update fehlgeschlagen! \\nGrund:","TXT_CODE_47dcfa5":"Neu starten","TXT_CODE_47dd244a":"Wachstumsgeschwindigkeit der Fackelblume","TXT_CODE_47e182a5":"Bau abgeschlossen","TXT_CODE_47e21c80":"Bitte vervollständigen Sie die Grundparameter, bevor Sie die Datei hochladen.","TXT_CODE_48044fc2":"Wenn die Quelle des Komprimierungspakets Festlandchina ist, wird im Allgemeinen GBK ausgewählt.","TXT_CODE_4822a21":"Es wurde eine Abschaltverfügung erlassen","TXT_CODE_48261ab7":"Händler-Infokarte","TXT_CODE_483d379":"Die Zeitdauer von Server- und Clientstandorten ist möglicherweise nicht synchron (deaktiviert, wenn die Option „server-authoritative-movement“ auf „false“ gesetzt ist).","TXT_CODE_485e2d41":"Verbleibende Zeiten","TXT_CODE_4880ef77":"Weltkonfigurationsdatei der PaperSpigot-Serversoftware, die auf Weltbasis weiter konfiguriert werden kann","TXT_CODE_48c286cc":"Benutzer <<operator_name>> gestoppt die Instanz <<instance_name>>","TXT_CODE_48c291c1":"Remote-Zuordnungen nicht verfügbar. Möglicherweise veraltetes Panel-Backend.","TXT_CODE_4908e15b":"Ob der Client gezwungen werden soll, alle Ressourcenpakete zu laden.","TXT_CODE_495027e1":"Erstellen eines Ubuntu 22.04-Umgebungsimages","TXT_CODE_497568db":"Konfigurieren Sie die direkte Verbindung des Nodes bei Zugriff von verschiedenen Endpunkten. Nützlich bei Reverse Proxy.","TXT_CODE_498cd5c5":"Klicken Sie auf die Schaltfläche „Schließen“, um den Upload abzubrechen","TXT_CODE_49981cb9":"Bitte wählen Sie aus, wie Sie Ihre Anwendungsinstanz bereitstellen möchten.","TXT_CODE_49ab8e74":"Rüstungsattribut","TXT_CODE_49c040e1":"Legt fest, ob beim Ausführen eines Emotes Nebenhand- und Haupthand-Gegenstände ausgetauscht werden sollen.","TXT_CODE_49c48e0a":"Die Aktionsleistenmeldung, die angezeigt wird, wenn ein Spieler schläft. \\nAuf „Standard“ setzen, damit die Clients ihre eigenen übersetzbaren Komponenten verwenden können. \\nLegen Sie eine leere Zeichenfolge fest, um es zu deaktivieren. \\nVerfügbare Platzhalter: <count> – die aktuelle Anzahl der Spieler, die schlafen, <total> – die Gesamtanzahl der Spieler, die schlafen müssen","TXT_CODE_4a37ec9c":"Die Anzahl der mit dieser Konsole verbundenen Webseiten, die sich auf die Breite und Höhe Ihrer Konsole auswirken kann","TXT_CODE_4a56836d":"Bilderliste einrichten","TXT_CODE_4a570d32":"Bitte stellen Sie sicher, dass dieses Image vorhanden ist und Tags und andere Informationen enthalten muss. Dieses Image wird automatisch abgerufen, bevor die Instanz ausgeführt wird.","TXT_CODE_4a6bf8c6":"Verbindungsport des Remote-Knotens","TXT_CODE_4a70853b":"Wenn die kumulierten Kosten anfallen sollen, wenn ein Artikel in einem Amboss verwendet wird","TXT_CODE_4a95255b":"Tierverfolgungsreichweite","TXT_CODE_4a9822f":"Ob Schneebälle, wenn sie geworfen werden, Lagerfeuer löschen sollen","TXT_CODE_4aaec75c":"Falscher Anfragetyp, bitte versuchen Sie es erneut!","TXT_CODE_4ab6a0b5":"Browserzeit","TXT_CODE_4aba9745":"Ob der Spieler gekickt werden soll, wenn der Spieler den TileKill-Schwellenwert überschreitet","TXT_CODE_4ad9f75d":"Eintrittswahrscheinlichkeit","TXT_CODE_4b1d5199":"Unterstützt jede Sprache zum Ausfüllen relevanter Bemerkungsinformationen","TXT_CODE_4b20289c":"Ob das synchrone Blockschreiben aktiviert werden soll","TXT_CODE_4b39143b":"Der Name des Spawners","TXT_CODE_4b610194":"Aktivieren Sie die clientseitige Blockgenerierung","TXT_CODE_4b6e951":"Eingang","TXT_CODE_4b7eba50":"Online-Knoten/Gesamtknoten","TXT_CODE_4b971ef4":"Lässt den Enderman verschwinden, selbst wenn er einen Block hält","TXT_CODE_4bbd3fde":"Baufortschritt","TXT_CODE_4bedec2a":"alle Knoten","TXT_CODE_4bf8a52f":"Referenzpreis","TXT_CODE_4bf93cf1":"Sollten Agenten gezwungen werden, neue Sicherheitsstandards für öffentliche Schlüssel zu implementieren? \\nStandardmäßig ist diese Option aktiviert.","TXT_CODE_4c0fda9":"Bitte starten Sie die Instanz einmal, um eine Konfigurationsdatei zu generieren. \\nWenn es noch leer erscheint, wird dieser Spielservertyp möglicherweise nicht unterstützt.","TXT_CODE_4c38bb42":"Der Hunger nach Springen und Laufen ist erschöpft.","TXT_CODE_4c55b6c7":"Versuchen Sie, bei jedem Tick ein Tier zu spawnen. Ein Wert von 400 bedeutet, dass der Server alle 400 Ticks versucht, ein Tier zu spawnen. Ein Wert kleiner als 0 wird auf den Standardwert von Minecraft zurückgesetzt.","TXT_CODE_4c566219":"Ermöglicht Spielern die Verwendung von MiniMessage-Tags in einem Amboss.","TXT_CODE_4c714a4f":"Der Server ist veraltet! \\nDie aktuelle Version ist {0}","TXT_CODE_4c72565d":"Benutzername nicht gefunden, neues Konto erstellen?","TXT_CODE_4c82f760":"Unterdrücken Sie Warnungen vor Versuchen, ein nicht erkanntes Rezept zu laden","TXT_CODE_4c841d3":"Pilzwachstumsrate","TXT_CODE_4c9dd2b4":"Blockfallmultiplikator für Heublock","TXT_CODE_4ca9e35f":"Skelett","TXT_CODE_4ccdd3a0":"Konsole","TXT_CODE_4cef8979":"Server-Port (diese Option funktioniert möglicherweise nicht, wenn der Server über erweiterte Einstellungen verfügt)","TXT_CODE_4d00c085":"Aktivieren Sie die Nachrichtenkanalunterstützung des BungeeCord-Plug-ins auf Velocity.","TXT_CODE_4d124f78":"Ob die UDP-Abfrage aktiviert werden soll","TXT_CODE_4d36128b":"Auf Updates prüfen","TXT_CODE_4d3b4548":"Prozentuale Chance (0,0 – 1,0), dass ein Endermit erscheint, nachdem er mit einer Enderperle teleportiert wurde","TXT_CODE_4d50f316":"3. Nachdem das Design fertiggestellt ist, können Sie im angemeldeten Status direkt darauf zugreifen.","TXT_CODE_4d5432bd":"Prozentuale Chance (0,0 – 1,0), dass ein Zombie-Pferd anstelle eines Skelettpferdes spawnt (natürliches Spawnen bei Gewittern)","TXT_CODE_4d571cda":"Versteckte Elementmetadaten","TXT_CODE_4d6b06f0":"Vereinfachtes Chinesisch (GBK)","TXT_CODE_4d81a657":"Vorschau","TXT_CODE_4d8e959e":"Ermöglicht Ihnen, eine Liste von Konsolenbefehlen festzulegen, die beim Starten des Servers ausgeführt werden. \\nNützlich für Serverbesitzer, die keinen Zugriff auf ihre Konsole haben.","TXT_CODE_4d934e3a":"Ressourcenzuweisung","TXT_CODE_4d993ca4":"Bilderrahmen","TXT_CODE_4dab643d":"Schwierigkeit","TXT_CODE_4df7e9bd":"Hostname","TXT_CODE_4e2c7f64":"Stunde","TXT_CODE_4e4b52a0":"Dieser Installationsvorgang kann einige Minuten dauern. Bitte stellen Sie sicher, dass das Netzwerk geöffnet ist. Möchten Sie fortfahren?","TXT_CODE_4e4d9680":"Vollständiger Bildname","TXT_CODE_4e627613":"Es liegt ein Kartenausführungsfehler vor. Bitte aktualisieren Sie die Webseite und versuchen Sie es erneut","TXT_CODE_4e810102":"Bitte geben Sie den Startbefehl ein","TXT_CODE_4ea93630":"Bitte geben Sie Inhalte ein","TXT_CODE_4ec4f7bb":"Bitte wählen Sie einen verfügbaren Knoten!","TXT_CODE_4eccdde8":"Konfiguration erfolgreich erstellt!","TXT_CODE_4ed501a1":"Leiten Sie die MOTD des Remote-Servers an Bedrock Edition-Spieler weiter.","TXT_CODE_4ef3f800":"Für Händler: Wenden Sie sich an https://redeem.mcsmanager.com oder lesen Sie die Hinweise auf der Website, um Hilfe zu erhalten","TXT_CODE_4ef6b040":"gestoppt","TXT_CODE_4efba567":"zusätzliche Parameter","TXT_CODE_4f0b822b":"Wie lange in Millisekunden BungeeCord versucht, den Server anzupingen, um die Anzahl der Spieler zu ermitteln, bevor die Verbindung abgebrochen wird","TXT_CODE_4f21b52":"Nachricht, die anzeigt, wenn jemand versucht, einen Mob zu besteigen, wozu er nicht berechtigt ist.","TXT_CODE_4f225afd":"Nur für den Verifizierungstyp Online-Modus. \\nSpeichert eine Liste der Bedrock Edition-Spieler, deren Java-Konten nach dem Anmelden gespeichert werden sollen.","TXT_CODE_4f2f381b":"Macht den Namen sichtbar, wenn ein Namensschild an einem Rüstungsständer verwendet wird","TXT_CODE_4f34fc28":"Instanzeinstellungen anwenden","TXT_CODE_4f387c5a":"Nachdem Sie den Update-Befehl konfiguriert haben, finden Sie den Update-Vorgang auf der Schaltfläche „Instanz wechseln“. Nach dem Klicken wird der hier geschriebene Befehl auf dem Host (oder in Docker) ausgeführt.","TXT_CODE_4f57868":"MC Geyser","TXT_CODE_4f64db47":"Macht diesen Mob WASD-kontrollierbar","TXT_CODE_4f6a2959":"Bitte warten Sie, bis der aktuelle Datei-Upload abgeschlossen ist","TXT_CODE_4f6c39d3":"Bitte geben Sie ein neues Passwort ein","TXT_CODE_4f917a65":"Ressourcengrenzen:","TXT_CODE_4fb30d0a":"Der Projektilversatz eines Eies","TXT_CODE_4fb3fad1":"Fehler beim Entpacken","TXT_CODE_4fb66c81":"Wenn in 1 Sekunde mehr als diese Anzahl an Spielsteinen zerstört wird, blockiere den Spieler und setze seine Aktionen fort","TXT_CODE_4fd13f18":"Diese Einstellung gilt für die BungeeCord-Gruppenserversoftware. Da diese Konfigurationsdatei jedoch etwas komplex ist, können die meisten Einstellungen nur einfach geändert werden. Es wird empfohlen, diese Datei mit der Online-Dateiverwaltungsfunktion zu bearbeiten.","TXT_CODE_4fdbb351":"Integrierte Java 16-Ausführungszeitumgebung, geeignet für Minecraft-Server der Version 1.17","TXT_CODE_4fe284cd":"Squir?","TXT_CODE_4fe5dce5":"Gehen Sie zur Knotenseite","TXT_CODE_4ff6a125":"Es wurde eine Erinnerung hinzugefügt, wenn der Server voll ist","TXT_CODE_4ffdc91d":"Empfangen {{Signal}} Signal aus dem System und versucht, alle Instanzen zu schalten ...","TXT_CODE_50075e02":"Es kann zu Verzögerungen kommen und das Löschen der Datei dauert einige Zeit","TXT_CODE_5020d183":"Ermöglicht das Ändern des Modifikators für die Spawn-Chance von Piglins aus einem Portalblock basierend auf der Weltschwierigkeit.","TXT_CODE_5024d817":"Das Verzeichnis /workspace muss erstellt werden und wird automatisch im Dateistammverzeichnis der Instanz bereitgestellt.","TXT_CODE_504b84d9":"Aktivieren Sie die Protokollierung von Spielerverbindungen.","TXT_CODE_50511e8f":"Standardmäßige Spielerberechtigungsstufe (Gast: Besucher | Mitglied: Mitglied | Administrator: Operator).","TXT_CODE_50697989":"Verwenden Sie die Remote-Host-Adresse und die Fuzzy-Abfrage, um Anwendungsbeispiele für diesen Benutzer hinzuzufügen","TXT_CODE_509d7d9a":"Die Spigot-Konfigurationsdatei kann das Verhalten des Servers und bestimmte Parameter weiter steuern. Diese Konfigurationsdatei enthält einige erweiterte Einschränkungen.","TXT_CODE_50a2b2d9":"Gleichzeitig wirkt sich diese Option auch den Benutzer im Docker -Container der Instanz aus. \\nWenn Sie nicht wissen, was dies bedeutet, ändern Sie es bitte nicht.","TXT_CODE_50aa56a1":"Ermöglicht die Verwendung der Direktive /timings. \\nWird verwendet, um die Zeit zu messen, die das Plug-in für Ereignisse verbringt","TXT_CODE_50d471b2":"zurücksetzen","TXT_CODE_50daec4":"Netzwerk","TXT_CODE_510bd294":"Unterstützt nur das ZIP-Format. Nach dem Hochladen wird das komprimierte Paket automatisch in das „Dateiverzeichnis“ dekomprimiert.","TXT_CODE_5112fcb2":"MC-Forge","TXT_CODE_511aea70":"Berechtigungen","TXT_CODE_51289627":"Ist die Installation abgeschlossen?","TXT_CODE_5143c584":"Schutzmechanismus, um die Erstellung benutzerdefinierter Nachrichten mit Todesmeldungen zu verhindern","TXT_CODE_514e064a":"Panel-Bindungs-IP","TXT_CODE_518528d0":"Überspringen","TXT_CODE_51a1fffb":"Filter","TXT_CODE_51bb7e9f":"Unbekannter Befehl. \\nGeben Sie „/help“ ein, um Hilfe zu erhalten.","TXT_CODE_51df891f":"Spur ruiniert Samen","TXT_CODE_51ff8e5b":"Auf „true“ setzen, um zu verhindern, dass der Befehl „/give“ Gegenstände auf den Boden fallen lässt, wenn das Inventar eines Spielers voll ist","TXT_CODE_5206cf41":"Basiseinstellung","TXT_CODE_5207688f":"Berechtigungsprofil für das MCDReforged-Serversteuerungstool","TXT_CODE_5245bd11":"Bitte füllen Sie den Formularinhalt aus","TXT_CODE_524e3036":"Konsole","TXT_CODE_525e6e18":"Eula wurde erfolgreich angenommen. \\nStartinstanz ...","TXT_CODE_5275cb62":"Die Anzahl der Ticks beginnt, wenn der Spieler unter Schlaflosigkeit leidet","TXT_CODE_528753e7":"Da Minecraft oder andere Programme bestimmte Betriebsumgebungen wie Java/Python/.NET usw. erfordern, ist es sehr kompliziert, verschiedene Versionen auf demselben Computer zu installieren und zu verwalten. Durch die Verwendung verschiedener Umgebungsimages können verschiedene Versionen und verschiedene Typen problemlos verwaltet werden Serviceumgebungen.","TXT_CODE_52b31aef":"Protokollieren Sie anhand ihrer IP, wo sich Spieler abmelden. \\nEs wird nach dem Neustart des Servers gelöscht.","TXT_CODE_52ba5942":"Volle Karte","TXT_CODE_52bc24ec":"Bestätigen Sie den Upload","TXT_CODE_52c8a730":"aktivieren","TXT_CODE_52eff9c3":"OP-Berechtigungsstufe (1–4)","TXT_CODE_52f96ff0":"Der Farbverlauf von <text>, wenn der Füllmodus „gut“ ist.","TXT_CODE_53046822":"CPU-Auslastung begrenzen (Prozent)","TXT_CODE_530f5951":"Sicht","TXT_CODE_5338b335":"Wachstumsrate der Wassermelone","TXT_CODE_53408064":"Antrag erstellen","TXT_CODE_53499d7":"Leere Vorlage erstellen","TXT_CODE_534db0b2":"Host-Verbindungsport","TXT_CODE_5366af54":"Batch-Job beenden","TXT_CODE_53745cc0":"Die Gesamtzahl der Instanzen, die Ihnen von Managern zugewiesen wurden","TXT_CODE_53761955":"Meldung, die angezeigt wird, wenn der Demobildschirm für einen Benutzer mit dem Befehl /demo aktiviert wird.","TXT_CODE_537cd5ad":"Zurück zur Profilliste","TXT_CODE_53aec8c6":"Kreuzen Sie zwischen jeder großen Block-Garbage-Collection an","TXT_CODE_53d04392":"Ob Schneebälle, wenn sie geworfen werden, Brände löschen sollen","TXT_CODE_53dd82fc":"Stop-Befehl","TXT_CODE_53e8e5af":"Die Todesmeldung, die erscheint, wenn der Spieler getötet wird, weil er mit einer Schere gerannt ist","TXT_CODE_5415f009":"Kein Inhalt, bitte wählen Sie den Knoten im Dropdown-Feld in der oberen rechten Ecke aus oder klicken Sie auf Anwendung erstellen","TXT_CODE_54275b9c":"Vorlagen-Editor","TXT_CODE_54312194":"Adresse und Port","TXT_CODE_543356c1":"Liste der Blöcke, die durch Rechtsklick mit der Schaufel in einen Grasweg verwandelt werden können","TXT_CODE_5445f34b":"und {num} weitere","TXT_CODE_54469e02":"Noch keine Betriebsprotokolle verfügbar","TXT_CODE_5476e012":"Betriebszustand","TXT_CODE_5484094a":"Ändern Sie das Arbeitsverzeichnis des Containers","TXT_CODE_55015f30":"Zusätzliche Mount-Verzeichnisse (Optional)","TXT_CODE_551b0348":"Passwort","TXT_CODE_553c6ed2":"Auf „true“ setzen, damit Netherwart mit Knochenmehl behandelt werden kann","TXT_CODE_5544ec22":"Überprüfen Sie den Baufortschritt","TXT_CODE_555b3625":"Forest Mansion-Samen","TXT_CODE_555e2c1b":"Geben Sie den Befehl ein und drücken Sie die Eingabetaste, um ihn zu senden. Verwenden Sie die Auf- und Ab-Tasten, um historische Befehle auszuwählen.","TXT_CODE_5564bc4c":"Benutzer <<operator_name>> hat die Benutzerkonfiguration geändert","TXT_CODE_559f4b1d":"Unterdrücken Sie Warnungen zu Plugins, die die Legacy-Material-API initialisieren","TXT_CODE_55a62de":"Ermöglicht die Platzierung von Wasser am Ende.","TXT_CODE_55ade942":"Wird von Administratoren zum Anzeigen von Serverdaten verwendet","TXT_CODE_55b1f20e":"Der Benutzer konnte die Instanz nicht aktivieren:","TXT_CODE_55c91a9b":"Auf „true“ setzen, um Schaden beim Schleichen zu ermöglichen","TXT_CODE_55e91545":"Früher Fensteranbieter","TXT_CODE_55edf44d":"Die Imaging-Aufgabe wurde gestartet","TXT_CODE_56197d09":"Verhindert, dass Tintenfische auf dem Wasser schwimmen","TXT_CODE_5635dd6b":"Auf „True“ gesetzt, um Schaden beim Gehen mit Stiefeln zu ermöglichen, die mit „Frostläufer“ verzaubert sind","TXT_CODE_56516e92":"Versteckte Einstellungen","TXT_CODE_56b9e6af":"Standardmäßig zuteilt McSmanager 5 Ports für jede Instanz nacheinander und unterstützt die Verwendung von {MCSM_PORT1} an {MCSM_PORT5} als nacheinander hinzugefügte Portnummern.","TXT_CODE_56c42793":"Das Präfix, das in der Spielerliste vor dem Namen einer Person angezeigt wird, wenn diese AFK ist","TXT_CODE_56c686f8":"Fehlgeschlagen","TXT_CODE_56ff18c1":"Anzeige der Serverinformationen. Wenn Sie Plug-in-Programme wie ColorMotd verwenden, können Sie diese Option leer lassen.","TXT_CODE_57245e94":"Einschalten","TXT_CODE_57358a8b":"Auf „true“ gesetzt, damit Boote Spieler an Land auswerfen","TXT_CODE_57417f60":"Ob Spieler rausgeschmissen werden, wenn sie den MaxDamage-Schwellenwert überschreiten","TXT_CODE_574ed474":"Online -Funktionen","TXT_CODE_57674047":"Befehl bei Klick auf „Aktualisieren“","TXT_CODE_5778848e":"Archiv kann nicht geöffnet werden","TXT_CODE_57a3aae":"Meldung, die angezeigt wird, wenn der Befehl /uptime ausgeführt wird.","TXT_CODE_57c09778":"Auf „true“ setzen, damit Creeper die Mob-Griefing-Gamerregel umgehen","TXT_CODE_57c1b0a3":"Optionaler Parameter -Xms, z. B. 1024M","TXT_CODE_57cd2d04":"Möglicherweise ist das Netzwerk nicht verfügbar oder der Server wird gerade gewartet. Bitte warten Sie eine Weile, bevor Sie es erneut versuchen, oder versuchen Sie es mit anderen Installationskits.","TXT_CODE_57d1929e":"MCSManager verwendet das Minecraft-Ping-Protokoll, um die Anzahl der Personen, die auf dem Server online sind, die Version, die Latenz und andere Informationen zu ermitteln.","TXT_CODE_57d76ece":"Ersatzblockliste","TXT_CODE_57e86edb":"Zu den von Ihnen zugewiesenen Instanzen gehören einige Instanzen, für die „Containerschutz“ nicht aktiviert ist. Der zugewiesene Benutzer kann über diese Instanzen Malware hochladen, um in Ihren Host einzudringen. Der Benutzer ist jemand, dem Sie vertrauen.\\n\\n\\nDie Namen der Instanzen mit Sicherheitsrisiken lauten wie folgt:","TXT_CODE_584af0ab":"Deaktiviere die Wirkung des Unsichtbarkeitstranks","TXT_CODE_584d786d":"Löschen Sie die Instanz und die zugehörigen Dateien","TXT_CODE_58508fb7":"Name der Serversoftwaredatei","TXT_CODE_58939ea7":"Ob Tiere erzeugt werden sollen","TXT_CODE_589e091c":"Fügen Sie ein neues hinzu","TXT_CODE_58a55f17":"Die Datei {name} existiert bereits in diesem Ordner","TXT_CODE_58aa8491":"Shulker müssen ihren Deckel geöffnet haben, um aus der Kugel zu spawnen","TXT_CODE_58e4a9bd":"Benutzer <<operator_name>> Die Datei {<<file>> in die <<instance_name>> Instanz hochgeladen","TXT_CODE_592eff33":"Im Panel speichern","TXT_CODE_5936d79":"Auf „true“ setzen, damit Projektile die Mob-Griefing-Gamerregel umgehen","TXT_CODE_593ee330":"Speicherauslastung","TXT_CODE_595efd06":"Neu erstellen","TXT_CODE_5962e188":"Neueste Version","TXT_CODE_5974bf24":"verwalten","TXT_CODE_597c11cc":"Bei welchem ​​Schwierigkeitsgrad bricht die Schale?","TXT_CODE_598f2d02":"Der Gradient von <text>, wenn die RAM-Auslastung „niedrig“ ist.","TXT_CODE_59917c84":"Ermöglicht die Sichtbarkeit von Tarnkappen von Drittanbietern.","TXT_CODE_59976e2c":"Auf „true“ setzen, um Teleport-Einschränkungen für Gateways aufzuerlegen. \\nDadurch wird das EntityTeleportHinderedEvent-Ereignis gesendet, das die Möglichkeit bietet, Teleports erneut zu versuchen, wenn sie aufgrund von Passagieren/Fahrzeugen fehlschlagen","TXT_CODE_59a76359":"Verwenden Sie den Cache, um Kartenfarben zu speichern","TXT_CODE_59ab3364":"Herunterladen Rate","TXT_CODE_59ac0239":"Neues Bild hinzufügen","TXT_CODE_59b1cb55":"Ermöglicht kopflose Kolben","TXT_CODE_59c0c994":"Hochladen auf andere Fälle","TXT_CODE_59c39e03":"Das MCSManager Redemption Center unterstützt Sie bei Ihrem Geschäftsplan","TXT_CODE_59cb16ff":"Bitte geben Sie den Dateinamen ein","TXT_CODE_59cdbec3":"Beschreibung","TXT_CODE_59f7c3a2":"Prozentuale Chance (0,0 – 1,0), dass ein Zombie oder Skelett mit einem Kürbislaternen/geschnitzten Kürbis auf dem Kopf erscheint","TXT_CODE_5a196078":"Scrollen Sie durch den Fotorahmen","TXT_CODE_5a280280":"Laden Sie „permissions.yml“ vor dem Plugin","TXT_CODE_5a408a5e":"Geschäft","TXT_CODE_5a56ccca":"Ermöglicht passwortbasierte Authentifizierungsmethoden über Geyser. \\nNur im Online-Modus sinnvoll.","TXT_CODE_5a6463fb":"Rüstungsständer graviert","TXT_CODE_5a74975b":"Erstellen Sie eine Instanz","TXT_CODE_5a936b7f":"Entpacken","TXT_CODE_5aa330f0":"Auf „false“ setzen, damit der Feuerwiderstandseffekt sein Symbol nicht anzeigt","TXT_CODE_5ab1eb7d":"Stil ändern","TXT_CODE_5ab2062d":"letzter Start","TXT_CODE_5af5838a":"Sendet die Fortschrittsnachrichten im Chat nur an den betroffenen Spieler","TXT_CODE_5b0e93b5":"Die Installation kann nicht gestartet werden, da andere asynchrone Aufgaben in Arbeit sind. \\nBitte beenden Sie zuerst andere Aufgaben auf der Terminalseite!","TXT_CODE_5b190bc4":"Wie oft (in Minuten) fordert REST die Dekrementierung des Buckets um 1 an? \\nDer Mindestwert beträgt 1 Minute","TXT_CODE_5b2daea0":"Wenn beim Eingeben eines Befehls und Drücken der Eingabetaste nichts passiert, können Sie versuchen, diese Option anzupassen.","TXT_CODE_5b323a2":"Die maximale Anzahl an Spielern, die die gesamte BungeeCord-Instanz akzeptieren kann. Der Standardwert ist -1, was bedeutet, dass es keine Begrenzung für die Anzahl der Spieler gibt.","TXT_CODE_5b5d6f04":"Speichern des Layouts abbrechen","TXT_CODE_5b60ad00":"Verwenden Sie das MCSManager-Konto des Servers, um auf das Panel zuzugreifen","TXT_CODE_5b6f3691":"Serverkonfigurationsdatei eines Neoforge -Servers","TXT_CODE_5b719d7b":"Auf „true“ setzen, um den Schlaf zu ermöglichen, auch wenn sich Mobs in der Nähe befinden","TXT_CODE_5b990e2e":"Erfolgreich umbenannt","TXT_CODE_5bb8f14":"Erzeuge angreifende Kreaturen (Monster)","TXT_CODE_5bba3e38":"Umkreis, in dem Dorfbewohner nach POIs suchen.","TXT_CODE_5bc16b9a":"Superadministrator-Gruppenchat-Suffix","TXT_CODE_5bdaf23d":"Knotenkonsole","TXT_CODE_5be6c38e":"Standardtyp","TXT_CODE_5bf41818":"Überschreiben","TXT_CODE_5c3ba572":"Ob Raubtiere außer Gefecht gesetzt werden sollen","TXT_CODE_5c43374f":"Präferenz für virtuelle Speicherverwendung","TXT_CODE_5c54f599":"irgendjemand","TXT_CODE_5cb656b9":"Batch-Job","TXT_CODE_5cd3b4bd":"Artikel","TXT_CODE_5ce5085c":"Eingabe-Kodierung","TXT_CODE_5d033431":"Liste versteckter Anti-Perspektiv-Sperren","TXT_CODE_5d41afbf":"Auf „true“ setzen, um eine 100-prozentige Chance zu haben, einen Mob zu zähmen","TXT_CODE_5d488270":"Es stellt sicher, dass Allays die NBT der von ihnen abgeholten Gegenstände respektieren. \\nWenn Sie der Liste gespeicherte Verzauberungen hinzufügen, um sie zu respektieren, und wenn Sie einem Allay ein Schwert mit einer Verzauberung geben, nimmt er nur Schwerter mit denselben Verzauberungen auf.","TXT_CODE_5d563196":"Der Hunger nach Springen und Gehen ist erschöpft.","TXT_CODE_5d589988":"Ermöglicht das Öffnen von Truhen, selbst wenn ein fester Block darauf steht","TXT_CODE_5db4e96b":"Erweiterte Höhe (die höchste Höhe auf derselben Seite ist die endgültige Höhe)","TXT_CODE_5ddb00f2":"Benutzer <<operator_name>> Erstellen Sie die Aufgabe <<task_name>> für die Instanz <<instance_name>>","TXT_CODE_5ddf3123":"Auf „true“ setzen, um Beobachteruhren zu deaktivieren","TXT_CODE_5deeefb5":"Die Instanz wird erstellt. Möchten Sie fortfahren?","TXT_CODE_5def0cbe":"Sicherheit","TXT_CODE_5e10537a":"Instanzvorlage ändern","TXT_CODE_5e4a370d":"Dunkelmodus","TXT_CODE_5e4c9793":"Anzahl der Ticks zur Tonverzögerung; \\nDie Option „Burp-when-full“ muss aktiviert sein","TXT_CODE_5e56a7a5":"Die Geschwindigkeit, mit der sich ein Kessel unter einem nach unten gerichteten spitzen Tropfstein, über dem sich ein Block Wasser befindet, mit Wasser füllt (hängt von der Zufallsgeschwindigkeit ab)","TXT_CODE_5e6e46bb":"Maximaler Schaden, den ein Spieler/NPC verursachen kann","TXT_CODE_5e9022f8":"Weiter","TXT_CODE_5ead1240":"Bearbeitung starten","TXT_CODE_5eb49cd":"Auf „true“ setzen, damit die Überlieferungen von TE auch nach dem Zerstören bestehen bleiben (z. B. benutzerdefinierte Spielerköpfe mit Überlieferungen behalten ihre Überlieferungen).","TXT_CODE_5ebec0db":"Erweiterungsseitenkarte","TXT_CODE_5ec10cc8":"Diese Karte kann im Designmodus nicht in der Vorschau angezeigt werden.","TXT_CODE_5ef2cf20":"Die Identität wird durch den vom Remote-Knoten generierten Schlüssel authentifiziert, um die Sicherheit der Integrationsarbeit mehrerer Maschinen zu gewährleisten.","TXT_CODE_5f0eafe5":"Ender-Drachentod-Soundeffektradius","TXT_CODE_5f1ae9ca":"Auf „true“ setzen, damit Clients mithilfe benutzerdefinierter Nutzlastpakete die Bienenzahl von Bienenstöcken anfordern können.","TXT_CODE_5f23008":"Der Grund wird angegeben, wenn ein Spieler, der versucht, beizutreten, gekickt wird, wenn der Server voll ist und keine reservierten Slots verfügbar sind","TXT_CODE_5f282a51":"Ab welchem ​​Schwierigkeitsgrad wird der böse Geist die Tür aufbrechen?","TXT_CODE_5f2d2e30":"Knoten-ID:","TXT_CODE_5f42b528":"Serverauthentifizierungstyp. \\nKann offline, online oder Floodgate sein.","TXT_CODE_5fed0011":"Aktivieren Sie LEGACY-Ping-Passthrough. \\nEs besteht keine Notwendigkeit, diese Option zu aktivieren, es sei denn, Ihr MOTD oder Ihre Spielerzahl werden nicht korrekt angezeigt.","TXT_CODE_6032f5a3":"9 bis 36 Zeichen, muss Groß- und Kleinbuchstaben sowie Zahlen enthalten","TXT_CODE_603cbc35":"Gilt der Zonenschutz für Diamant-Edelsteinschlösser?","TXT_CODE_604d3041":"Wie viel Komprimierung durchgeführt werden soll (von 0-9). \\nDer Standardwert ist -1, wobei die Standardstufe 6 verwendet wird.","TXT_CODE_604d8d63":"Containergrenzen","TXT_CODE_606da66a":"Tieraktivierungsbereich","TXT_CODE_6071bd0b":"Informationen, die vom Spielclient nach dem Herunterfahren des Servers angefordert werden","TXT_CODE_60752a40":"Sprache auswählen","TXT_CODE_60a11735":"Legen Sie Kletterregeln fest, um Menschenansammlungen zu umgehen","TXT_CODE_60dd05d5":"Überschreiben Sie das Standard-Image-Arbeitsverzeichnis durch das Datenspeicherverzeichnis","TXT_CODE_60e3c342":"Servername. \\nWenn UseServerName wahr ist, wird der Weltname während der Sitzung ersetzt","TXT_CODE_615be555":"Verschwindende Geschwindigkeit des Dreizacks","TXT_CODE_61700077":"Auf „true“ setzen, damit dieser Mob anfängt, Schaden durch Wasser zu erleiden","TXT_CODE_617701dc":"Ob Spieler gekickt werden sollen, wenn sie den TilePlace-Schwellenwert überschreiten","TXT_CODE_617ce69c":"warnen","TXT_CODE_61811ac":"Aufgabennutzlast","TXT_CODE_61834192":"Update-Befehl (Optional)","TXT_CODE_619d74d3":"Wie Java -jar server.jar, cmd.exe usw.","TXT_CODE_619faab6":"Wenn sich der Status der Instanz ohne Bedienfeldbedienung in den Status „Nicht ausgeführt“ ändert, wird der Startvorgang der Instanz sofort eingeleitet.","TXT_CODE_61a8296e":"Aktivieren Sie Docker-Container","TXT_CODE_61b6facb":"Benutzer <<operator_name>> löscht die <<instance_name>> Instanz","TXT_CODE_61ca492b":"Zum Beispiel:","TXT_CODE_61dd421d":"Legen Sie die maximale Anzahl an Millisekunden fest, die pro Tick verbracht werden","TXT_CODE_61eae8a6":"Zwei-Faktor-Authentifizierung (2FA)","TXT_CODE_62051fcc":"Upload fehlgeschlagen","TXT_CODE_6215388a":"neues Verzeichnis","TXT_CODE_6239c6b6":"Noch keine Webseite","TXT_CODE_6253ecce":"Block-Fall-Multiplikator für hellblaues Bett","TXT_CODE_6259357c":"Das Programm muss länger als 6 Sekunden laufen, bevor ein Stopp erzwungen werden kann!","TXT_CODE_6265ae47":"App Marketplace Datenquelle","TXT_CODE_628f6851":"Auszeit","TXT_CODE_62c62825":"Ob Anweisungen im Protokoll aufgezeichnet werden sollen","TXT_CODE_62c88f3a":"Wachstumsrate der Weinrebe","TXT_CODE_62dbf117":"Versuchen Sie, wie oben beschrieben bei jedem Tick ein Monster hervorzubringen","TXT_CODE_633415e2":"Bitte füllen Sie das Formular korrekt aus","TXT_CODE_6345aa71":"HTML-Datei:","TXT_CODE_6353e235":"Der SHA-1-Wert des Ressourcenpakets muss hexadezimal in Kleinbuchstaben angegeben werden und ist keine erforderliche Option","TXT_CODE_635d051":"Noch keine Bilder","TXT_CODE_638bca20":"Der Löschbefehl wurde erteilt","TXT_CODE_63a4602e":"Auto-Save-Rate des Spielers","TXT_CODE_63ccbf90":"Berechtigungsstufe","TXT_CODE_6420023d":"Anzahl Auto-Neustarts: ","TXT_CODE_64282335":"Deaktivieren Sie die Aufzeichnung von Anlagenaktualisierungen","TXT_CODE_645bc545":"Erstellen Sie eine neue Instanz","TXT_CODE_645da993":"Docker-Konfiguration","TXT_CODE_647ea2ec":"Sind Sie sicher, dass Sie alle ausgewählten Instanzen löschen möchten?","TXT_CODE_64bf4386":"Wenn der Remote-Knoten beim Start automatisch gestartet wird, kann er zum automatischen Starten der Instanz beim Start verwendet werden.","TXT_CODE_6514e191":"Dieses Profil ist bei Servern der Kategorie Spigot oder anderen abgeleiteten Kategorien üblich.","TXT_CODE_6526494a":"Auf „true“ setzen, um das Trampeln zu stoppen, wenn Entitäten um eine Distanz fallen, die ihrer Federfallstufe entspricht, zuzüglich des zusätzlichen Blocks, der zum Trampeln überhaupt erforderlich ist. \\nBei Feather Falling 1 müssen Sie über 3 Blöcke fallen, um zu trampeln. \\nFF 2 erfordert 4 usw.","TXT_CODE_6546b287":"Verwendet in der AFK-Übertragung eine Klartextversion des Anzeigenamens des Spielers anstelle seines Benutzernamens.","TXT_CODE_6557efaf":"Zweite Zeile MOTD","TXT_CODE_656a85d8":"Steam Rcon-Protokoll","TXT_CODE_65a057ec":"Java-Server-Verbindungsport","TXT_CODE_65a780a2":"Das Ausmaß des Schadens, den Hunger anrichten wird","TXT_CODE_65b21404":"Herunterladen","TXT_CODE_65e33205":"Auf „true“ setzen, wenn dieser Mob Kaninchen meiden soll, ähnlich wie Schlingpflanzen Katzen meiden","TXT_CODE_65fcbd09":"Entfernen","TXT_CODE_66056676":"Informationen zu Systemressourcen","TXT_CODE_660e2341":"Musikspieler","TXT_CODE_661c66fa":"Downstream-Server-Einstellungen, nur hier festgelegte Downstream-Server können verbunden werden.","TXT_CODE_6623dde0":"Unterdrücken Sie Protokolle im Zusammenhang mit dem Bibliothekslader","TXT_CODE_662ad338":"Byte-Stream-Kodierung","TXT_CODE_662ae77":"Auf „true“ setzen, damit Enderman die Mob-Griefing-Gamerregel umgeht","TXT_CODE_6655c905":"Die HTTP-Antwort fügt access-control-allow-origin: * hinzu, was möglicherweise die Sicherheit verringert, aber die Skalierbarkeit der Entwicklung verbessert.","TXT_CODE_66820e23":"Wie viele NPCs kann die Statue in 200 Pixeln spawnen, bevor sie nicht mehr spawnt? \\nStandardwert 3","TXT_CODE_6683b887":"Aktivieren oder deaktivieren Sie die REST-API","TXT_CODE_66968dc0":"Wie viele Blöcke können Riesen hinaufgehen, ohne springen zu müssen?","TXT_CODE_669eb0ff":"Ausgabe, wenn /ping <Benutzer> ausgeführt wird.","TXT_CODE_66ac4611":"Auf „false“ setzen, um die Bildung von Schnee auf blauem Eis zu verhindern","TXT_CODE_66b01c4e":"Multiplikator für das gesamte Buchvolumen","TXT_CODE_66b7b26e":"Attribut der Bewegungsgeschwindigkeit","TXT_CODE_66ce073e":"Offline","TXT_CODE_66e32091":"Die Knotensprache wurde geändert:","TXT_CODE_66f38b2e":"Normale Benutzer können nur einen Teil der Einstellungen ändern","TXT_CODE_673eac8e":"Hellmodus","TXT_CODE_67509ff2":"Steuert, ob Bienen nachts arbeiten können","TXT_CODE_6750d9d3":"Die Verwendung von Profilen, die von anderen geteilt werden, kann zur Kompromittierung des Panels führen.","TXT_CODE_678164d7":"Sie finden die Knoten -ID im Abschnitt \\"Knotenliste\\" der Händlerkonsole","TXT_CODE_67b4d0ba":"Kicken Sie Spieler, wenn sie inaktiv werden (siehe server.properties für die Timeout-Zeit bei Spieler-Leerlauf)","TXT_CODE_67b57086":"Spawnt nur bei Spielern über dem Meeresspiegel","TXT_CODE_67b5f678":"MC Bedrock","TXT_CODE_67c765be":"Geben Sie den Prozess an, der auf bestimmten Kernen ausgeführt werden soll, um die Hardwareressourcen Ihres Systems besser zu nutzen. Beispielsweise bedeutet 0,1, dass er auf dem 1. und 2. Kern ausgeführt wird, getrennt durch Kommas.","TXT_CODE_67d1ea21":"Einige optionale Tags","TXT_CODE_67d68dd1":"Typ","TXT_CODE_68128434":"Einen Minecraft-Spieleserver erstellen","TXT_CODE_6819de18":"Sind Sie sicher, dass Sie APIKey deaktivieren möchten?","TXT_CODE_681aaeb9":"Hostverzeichnis","TXT_CODE_683e3033":"Hardware-Anforderungen","TXT_CODE_684eb7e3":"Maximale Seitenanzahl in einem Buch","TXT_CODE_686c9ca9":"Verbindung zur Konsole wird hergestellt...","TXT_CODE_68821d80":"Bei dieser Konfigurationsdatei handelt es sich um eine allgemeine Konfigurationsdatei für Tshock-Server.","TXT_CODE_68831be6":"Typ:","TXT_CODE_68928779":"Unterdrücken Sie Warnungen zu unbekannten Attributen in Konsole und Protokollen","TXT_CODE_68a15ebb":"Ob die JMX-Überwachung aktiviert werden soll","TXT_CODE_68a504b3":"Bitte geben Sie einen Instanznamen ein","TXT_CODE_68a6aec5":"Wenn ein Spieler einen Erfolg erzielt, wird dieser in der Server-Chat-Leiste angezeigt (ob er X installieren darf)","TXT_CODE_6904cb3":"Docker-Image","TXT_CODE_6915f2a":"Abhängigkeitsdateien fehlen und können nicht gestartet werden. Bitte installieren Sie das Programm neu:","TXT_CODE_692957":"Server-IP, bitte leer lassen, wenn nicht gebunden","TXT_CODE_6929b0b2":"Es kann keine Verbindung zum Remote-Knoten hergestellt werden","TXT_CODE_693f31d6":"Pfadpräfix","TXT_CODE_694952a":"Erstellen Sie ein OpenJDK 16-Umgebungsimage","TXT_CODE_699b4b66":"Nicht ausfüllen; \\nDas Panel generiert es automatisch bei Bedarf.","TXT_CODE_69ad6852":"Ob Betrug mit ähnlichen Anweisungen erlaubt ist","TXT_CODE_69c42450":"7zip-Unterstützung fehlt, {{fileExt}}-Dateien können nicht entpackt werden.","TXT_CODE_69dbb08":"Ermöglicht Spielern die Verwendung von Farbcodes in Ambossen","TXT_CODE_69ecec1":"Download-Quelle für Bibliotheken","TXT_CODE_6a06a9ef":"Zum Arbeitsverzeichnis wechseln erzwingen","TXT_CODE_6a10302d":"Einmal gelöscht, kann es nicht wiederhergestellt werden!","TXT_CODE_6a365d01":"Operation fehlgeschlagen","TXT_CODE_6a515e35":"Die Webseite fügt dem Ausgabeinhalt automatisch eine Farbwiedergabe hinzu, und die gerenderten Farben sind möglicherweise nicht vollständig korrekt.","TXT_CODE_6a826e8b":"Wie lange können Sie unter Wasser atmen, bevor Sie ertrinken?","TXT_CODE_6aa286df":"Seite nicht gefunden","TXT_CODE_6ac327b4":"Auf „true“ setzen, um die Massenverarbeitung von Nahrungsmitteln/Pflanzengegenständen durch einen heimlichen Rechtsklick mit dem Gegenstand in der Hand zu ermöglichen","TXT_CODE_6ac61ca1":"Umkreis, in dem die Dorfbewohner nach dem nächstgelegenen Bett suchen.","TXT_CODE_6adffa20":"Fehlgeschlagene Dateischnitte hochladen,","TXT_CODE_6b175558":"Nach Abschluss der Konfiguration wird der Serverstatus jede Minute aktualisiert, wenn die Instanz ausgeführt wird.","TXT_CODE_6b1984c0":"Prozentuale Chance (0,0 – 1,0), dass Creeper beim Spawnen aufgeladen (angetrieben) werden","TXT_CODE_6b2a9cab":"Die alte Versionskonfiguration wurde auf die neue Versionskonfiguration aktualisiert:","TXT_CODE_6b313c":"Auf „true“ setzen, um in der Welt zu spawnen, zu der diese Option gehört","TXT_CODE_6b4a27dd":"Das Web-Frontend kann keine WebSocket-Verbindung mit dem Knoten herstellen, bitte überprüfen Sie die Netzwerk-Proxy-Konfiguration oder Firewall-Konfiguration!","TXT_CODE_6b5509c7":"Vorlagenname eingeben","TXT_CODE_6b583898":"Anti-Pivot-Motormodus","TXT_CODE_6b69f1d":"Geben Sie hier ein benutzerdefiniertes Zeitlimit für das Verbindungszeitlimit an. \\nDer Standardwert beträgt fünf Sekunden.","TXT_CODE_6b6f1d3":"Es steht Ihnen frei, alles zu gestalten, was Sie möchten. \\nZu viele Elemente auf derselben Seite können zu Leistungseinbußen führen. Bitte verteilen Sie sie daher angemessen.","TXT_CODE_6be8dbe7":"Skriptpfad neu starten","TXT_CODE_6bf4665b":"Übertragen Sie die Geolokalisierung des Spielers basierend auf der IP des Spielers beim Beitritt","TXT_CODE_6c0478ab":"Befehl bei Klick auf „Stop“","TXT_CODE_6c08319b":"MC Spigot","TXT_CODE_6c232c9c":"Wird zum Mounten zusätzlicher Ordner auf dem Host im Container verwendet und unterstützt zwei variable Zeichenfolgen:","TXT_CODE_6c274bdc":"Für diesen Benutzer ist APIKEY nicht aktiviert.","TXT_CODE_6c5985ca":"Gehe zu","TXT_CODE_6c7970df":"vergrabene Schatzsamen","TXT_CODE_6c87dd18":"Docker-Container (Docker)","TXT_CODE_6c945cf8":"Spielen Sie den Spawn-Sound des Withers global ab, wenn er gespawnt wird","TXT_CODE_6c94f562":"Macht diesen Mob montierbar","TXT_CODE_6ca6667f":"Speicherauslastung (10 Min.)","TXT_CODE_6cb9bb04":"Mond","TXT_CODE_6cbb84a9":"Nicht verfügbar","TXT_CODE_6cd13a66":"Ob Spieler-Pings an den Server weitergeleitet werden sollen. \\nWenn Sie diese Option aktivieren, können Spieler der Bedrock Edition einen genaueren Ping erhalten, können aber auch dazu führen, dass es bei Spielern schneller zu Zeitüberschreitungen kommt.","TXT_CODE_6cfeb776":"Auf „false“ setzen, damit dieser Mob keinen Wasserschaden mehr erleidet","TXT_CODE_6d244c20":"Tier","TXT_CODE_6d32ea04":"Sollten AFK-Spieler als schlafend gelten? \\n(ermöglicht aktiven Spielern, die Nacht durch Schlafen zu überspringen, auch wenn AFK-Spieler nicht im Bett sind)","TXT_CODE_6d6c7e9a":"Blockiere den Spieler, wenn diese Anzahl an Projektilen innerhalb einer Sekunde erzeugt wird","TXT_CODE_6d6ceab5":"Spinnen sind immun gegen Giftwirkungen","TXT_CODE_6d772765":"Download-Adresse konnte nicht abgerufen werden","TXT_CODE_6d8bc58d":"Das Speichern ist fehlgeschlagen. Ein einzelnes Etikett unterstützt nur bis zu 9 Zeichen!","TXT_CODE_6d912e27":"Blockiere den Spieler, wenn diese Anzahl an Spielsteinen innerhalb von 1 Sekunde gezogen wird","TXT_CODE_6d9b9f22":"Da die Benutzeroberfläche in hohem Maße anpassbar ist, wird nach dem Speichern des Layouts die Sprache der gesamten Benutzeroberfläche gesperrt, und das Umschalten der Sprache funktioniert nur dann gut, wenn das Layout zurückgesetzt wird. \\nWenn Sie die Sprache nicht wechseln müssen, können Sie diesen Vorschlag ignorieren.","TXT_CODE_6da85509":"Sind Sie sicher, dass Sie der Instanz einen Befehl zum Herunterfahren erteilen möchten?","TXT_CODE_6dcaa94d":"Die Namenslänge sollte zwischen 1 und 30 Zeichen liegen","TXT_CODE_6e23c48":"Universalkarte","TXT_CODE_6e3da823":"Optionale, zusätzliche Parameter nach dem Java-Programm, wie z. B. -nogui usw. Mehrere Parameter werden durch Leerzeichen getrennt.","TXT_CODE_6e69b5a5":"Dekomprimierung, Bearbeitung und andere Kodierung von Dateiverwaltungsfunktionen","TXT_CODE_6e718abe":"Es können keine Identitätsdaten abgerufen werden. Möglicherweise wurden Sie blockiert oder es liegt ein Netzwerkproblem vor. Bitte versuchen Sie, die Seite zu aktualisieren.","TXT_CODE_6e96b2a9":"Codierung der Konsolenausgabe","TXT_CODE_6ed13fd":"Wie viel Schaden muss den Flügeldecken zugefügt werden, wenn der Dreizack-Springflut-Boost aktiviert wird?","TXT_CODE_6eead111":"mohist.yml Serverkonfigurationsdatei","TXT_CODE_6ef5195f":"Kann zum Anzeigen von Bildern verwendet werden","TXT_CODE_6f038f25":"Wir arbeiten mit Hochdruck an den Archiven!","TXT_CODE_6f0a5984":"Bereichsattribut folgen","TXT_CODE_6f1129fb":"Automatische Zuweisung","TXT_CODE_6f12aba3":"Sind Sie sicher, dass Sie diesen Hyperlink löschen möchten?","TXT_CODE_6f161560":"Datei-Kodierung","TXT_CODE_6f23ce93":"{{count}} Instanz verbleiben, um geschlossen zu werden, und wartet ...","TXT_CODE_6f27624c":"Daemon zugreifen von","TXT_CODE_6f2c1806":"Entfernen","TXT_CODE_6f43f95f":"Benutzer <<operator_name>> Die Datei {<<file>> der <<instance_name>> Instanz heruntergeladen","TXT_CODE_6f659da2":"Zustandsdiagramm zur Analyse der letzten Periode des Panels","TXT_CODE_6f7c50c2":"Deaktivieren Sie die Katzenerkennung für Kisten","TXT_CODE_6f862823":"Der McSmanager fährt aus, bitte warte ...","TXT_CODE_6f91f3ba":"Platz einnehmen","TXT_CODE_6f98ccd7":"Erstmalige Verwendung","TXT_CODE_6f9d4bb7":"Blöcke, die zum Bau einer Leitung verwendet werden können","TXT_CODE_6fac9e82":"Wachstumsrate des Schösslings","TXT_CODE_6fe24924":"Maximaler Speicher (MB)","TXT_CODE_6ff0668f":"Sind Sie sicher, dass Sie diese Projektaufgabe löschen möchten?","TXT_CODE_7010d780":"Die Reihenfolge, welche Server ausprobiert werden sollen, wenn sich ein Spieler anmeldet oder von einem Server geworfen wird.","TXT_CODE_703cdd68":"Sollten wir das Fenster steuern. \\nDeaktivieren Sie diese deaktivieren neue GL -Funktionen und können für Mods, die auf sie angewiesen sind, schlecht sein.","TXT_CODE_704a8b5d":"Startbereich der Dorfbewohner","TXT_CODE_70750fa":"Fahrzeugkollisionen zulassen","TXT_CODE_7078fd28":"Installationsfehler","TXT_CODE_709c2db4":"Template beisteuern?","TXT_CODE_70a2613b":"Durch bestimmte Instanztypen (Minecraft/Java) und Dateiscans wurden keine qualifizierten Konfigurationsdateien erkannt. Bitte initialisieren Sie die Prozesskonfiguration oder ändern Sie den Instanztyp, um Anpassungen vorzunehmen.","TXT_CODE_70c3b6e":"Aussage 1.13 Client-Proxy-Befehle.","TXT_CODE_70ce6fbb":"Die Instanz wurde gestoppt.","TXT_CODE_70e0cf4d":"Zurück zur Startseite","TXT_CODE_70fe20dd":"Sollten Elytras die unzerstörbare Verzauberung ignorieren?","TXT_CODE_70ff09a8":"Der Schwellenwert für die Aktualisierung des Scoreboards, wie viele Scoreboard-Pakete pro Sekunde.","TXT_CODE_710a2e6c":"Whitelist von Werkzeugen, die Spawner mit Silk Touch abbauen können","TXT_CODE_71155575":"Sind Sie sicher, dass Sie es löschen möchten?","TXT_CODE_711d4763":"Die vom Server an den Client gesendete Datenmenge bestimmt das Sichtfeld, das der Spieler einstellen kann","TXT_CODE_7141866a":"Kicken Sie Clients, die keine UUIDs an den Server senden","TXT_CODE_7153951e":"Der Schnellinstallationsdienst basiert auf Online-Plattformen von Drittanbietern.","TXT_CODE_7166a969":"Ob die Ping-Penetration aktiviert werden soll","TXT_CODE_718c9310":"deaktivieren","TXT_CODE_71a51d19":"Instanzkonsole","TXT_CODE_71c948a9":"Bitte geben Sie das Arbeitsverzeichnis ein","TXT_CODE_71f715e2":"Macht diesen Mob WASD-kontrollierbar. \\nHändlerlamas müssen gezähmt werden, damit sie WASD-kontrollierbar sind. \\nEin Sattel (Teppich) ist keine Voraussetzung, da es technisch gesehen immer einen Teppich gibt.","TXT_CODE_721157a3":"Datenübersicht","TXT_CODE_7214ead7":"Konfigurationsversion","TXT_CODE_724ce74d":"Welche Anwendungsinstanz möchten Sie bereitstellen?","TXT_CODE_7284c68e":"Standardspielmodus, wenn Spieler zum Beitritt gezwungen werden","TXT_CODE_728fdabf":"Die Instanz konnte nicht erstellt werden. Bitte versuchen Sie es später noch einmal","TXT_CODE_72952e19":"Löschobjekte auswählen","TXT_CODE_72c8d0bf":"Ermöglicht die unbegrenzte Energieversorgung des Ofens durch darunter platzierte Lava","TXT_CODE_72cce10b":"Instanzdateiverwaltung","TXT_CODE_72cfab69":"Knoten-ID","TXT_CODE_72d36de":"Ob die BungeeCord-Unterstützung aktiviert werden soll","TXT_CODE_72f69b34":"Verwenden Sie die Farben der Vanilla World Scoreboard-Namen","TXT_CODE_73102f2b":"Systembetriebsprotokolle werden hier angezeigt","TXT_CODE_7333c7f7":"Klar","TXT_CODE_7356e569":"Keine Vorlagen verfügbar","TXT_CODE_738bc836":"Maximale Weltgröße","TXT_CODE_73c7b4b":"Angriffsschadensattribut","TXT_CODE_7411336e":"Gesamtzahl der Instanzen","TXT_CODE_741fdde4":"Ob der Server bei einem Absturz automatisch neu gestartet werden soll","TXT_CODE_743c6bf3":"Auf „true“ gesetzt, damit Geistliche Netherwarzen farmen können","TXT_CODE_743ed87f":"Komprimierungsstufe","TXT_CODE_74443c8f":"Instanz läuft nicht","TXT_CODE_745d8a03":"Hyperlink-Block","TXT_CODE_745fc959":"Diese Funktion schützt Ihr Panel vor dem Brute-Force-Knacken von Passwörtern durch einen einzelnen Host mit nur 10 Passwortfehlern pro IP.","TXT_CODE_74788d9e":"Ermöglicht die Platzierung eines Endkristalls auf jedem Block, nicht nur auf Obsidian und Grundgestein","TXT_CODE_74c3d3e5":"Dokumentation","TXT_CODE_74c46351":"Statistiken erzwingen","TXT_CODE_74fa2f73":"Möchten Sie das Layout wirklich zurücksetzen?","TXT_CODE_74fd665e":"Auf Unterverzeichnis anwenden","TXT_CODE_750ab5c6":"Begrenzen Sie die Gesamtauslastung aller CPUs, es wird eine leichte Abweichung geben","TXT_CODE_751f9bc1":"Die wichtige Konfigurationsdatei des Velocity-Gruppenservers kann für die verteilte Verwaltung, Knotensteuerung usw. verwendet werden. Diese Konfigurationsdatei ist jedoch komplizierter und dient nur einfachen Einstellungen und Vorgängen.","TXT_CODE_7542201a":"Löschen Sie auch instanzbezogene Dateien","TXT_CODE_7546cc5":"Sollten Entitäten normal ticken, wenn Spieler in der Nähe AFK sind? \\nBei „Falsch“ ist mindestens ein Nicht-AFK-Spieler erforderlich, um zu kreuzen","TXT_CODE_75696661":"Wenn Sie die moderne oder BungeeGuard-IP-Weiterleitung verwenden, konfigurieren Sie hier das Profil, das den eindeutigen Schlüssel enthält.","TXT_CODE_759fb403":"Zustand","TXT_CODE_75bf9192":"Code verwenden","TXT_CODE_75c04302":"Startreichweite fliegender Monster","TXT_CODE_75da3f2d":"Aktuelle Vorlage leeren","TXT_CODE_75e5af9b":"Diese Konfigurationsdatei unterstützt derzeit keine direkte Konfiguration. Bitte gehen Sie zur Dateiverwaltung, um sie zu bearbeiten.","TXT_CODE_75ef0619":"Starten Sie den Knoten zur Wirkung neu, erfordert eine gleichzeitige Änderung der Verbindungskonfiguration","TXT_CODE_7638590c":"Die Anzahl der ausgeführten Instanzen","TXT_CODE_765d34e6":"Benutzerkarte","TXT_CODE_7669fd3f":"Entpacken Sie das Archiv","TXT_CODE_76750199":"jede Woche","TXT_CODE_7680e37f":"Aktivieren Sie die Protokollierung von Anweisungen.","TXT_CODE_768c6fa9":"Wachstumsrate der Kannenpflanze","TXT_CODE_76a82338":"Wenn es aus Taiwan und Hongkong kommt, können Sie BIG5 wählen, und wenn es aus anderen Regionen kommt, können Sie UTF-8 wählen.","TXT_CODE_76b2a495":"andere","TXT_CODE_76c66252":"Inkrement für Missbrauch der Tabulatortaste","TXT_CODE_76d20724":"Alle Instanzen des Benutzers","TXT_CODE_76d59e8":"Auf „true“ setzen, damit abwärts gerichtete Blasensäulen anstelle von aufwärts gerichteten Blasensäulen erzeugt werden, wenn Seelensand unter Wasserquellenblöcken platziert/erzeugt wird.","TXT_CODE_77000411":"Bildname","TXT_CODE_7702d818":"Schleichen Sie sich an einen Läufer mit einem Sattel auf dem Rücken und klicken Sie mit der rechten Maustaste darauf, um ihn zu entfernen, wenn diese Option aktiviert ist","TXT_CODE_77083c51":"Zusätzliche Host-Verzeichnisse in Container mounten. Variablen {mcsm_workspace} (Arbeitsverzeichnis) und {mcsm_instance_id} (Instanz-ID) unterstützt.","TXT_CODE_772bb48a":"z.B. Java 18+","TXT_CODE_772c4961":"Schadensmenge pro Sekunde, die Kristalle Phantomen zufügen. \\nDer Wert 1,0 entspricht einem halben Herzen","TXT_CODE_773f36a0":"Hochladen erfolgreich","TXT_CODE_77816ef3":"Wenn dies der Fall ist, lassen alle gültigen Enderdrachen-Todesfälle die volle Menge an Erfahrungskugeln fallen, als wäre es der erste Drachentod","TXT_CODE_779553fb":"Webdienst-Token","TXT_CODE_77cc12da":"Starten Sie die Instanz neu","TXT_CODE_77d038f7":"Die von der Panel-Seite verwendete Speichermenge","TXT_CODE_77d93d7d":"Offizielles Referenzdokument: https://docs.docker.com/engine/reference/builder/","TXT_CODE_78019c60":"Profil bearbeiten","TXT_CODE_7818efd1":"Auf „false“ setzen, damit tollwütige Wölfe nicht durch Milch geheilt werden","TXT_CODE_78223e62":"Wenn GeoIP aktiviert ist, werden Spieler, bei denen festgestellt wurde, dass sie Proxys verwenden, rausgeschmissen","TXT_CODE_785a0fcf":"Benutzerdatei -Download -Rate","TXT_CODE_7863f28d":"Aktualisierung erfolgreich","TXT_CODE_786c22bd":"Versäumte, laufende Behälter zu übernehmen","TXT_CODE_786e2280":"Ob Betten explodieren. \\nWenn Sie dies auf „false“ setzen, verschwindet das Bett einfach","TXT_CODE_78930f0f":"URL bearbeiten","TXT_CODE_7898c2b4":"Ermöglicht Endermen, in Räume mit einer Höhe von 2 Blocks zu passen, wenn diese Option aktiviert ist. \\nDa die Hitbox des Clients gleich bleibt, können Sie ihn immer noch in den Kopf treffen","TXT_CODE_78aa511":"Trennzeit","TXT_CODE_78e88c3f":"Etikettengruppierung","TXT_CODE_7907c99":"In das aktuelle Verzeichnis entpacken","TXT_CODE_791a4c9b":"Legen Sie die Standardberechtigungsstufe einer Funktion fest","TXT_CODE_791c73e9":"neue Datei","TXT_CODE_798f592e":"lesen","TXT_CODE_7991f7b3":"Der Projektilversatz eines Schneeballs","TXT_CODE_79b77e31":"Auf „true“ setzen, um dem Spieler Fallschaden zuzufügen, während er sich in einem Minenwagen befindet","TXT_CODE_79ccdee0":"Der Radius der Blöcke, in denen ein Schwamm Wasser aufnimmt","TXT_CODE_79d2800b":"Latenz erzeugen – pro Spieler","TXT_CODE_79f9a172":"Benutzer bearbeiten","TXT_CODE_7a2b969f":"Die Verzauberungen, die nicht von Schleifsteinen entfernt werden","TXT_CODE_7a318185":"Ändern, um den Explosionswiderstand von Blöcken zu ändern.","TXT_CODE_7a464bb4":"Die Geschwindigkeit der Delfinspucke","TXT_CODE_7a830c68":"Autosave, ein Wert von 6000 bedeutet, dass der Server alle 5 Minuten versucht, die Welt automatisch zu retten. \\nHinweis: Zu klein kann zu Serververzögerungen führen","TXT_CODE_7ac6f85c":"Die Anzeigekonsole wird im Designmodus nicht unterstützt.","TXT_CODE_7ac8b1d3":"Bitte geben Sie den zweistufigen Bestätigungscode ein","TXT_CODE_7af6d85a":"MC-Fabric","TXT_CODE_7b0b38e6":"Sollten Spender Rüstung auf Rüstungsplätze auftragen, wenn sie mit dem Fluch der Bindung verzaubert sind?","TXT_CODE_7b1adf35":"Interface-Designmuster","TXT_CODE_7b2c5414":"wählen","TXT_CODE_7b477c3":"Mindestgröße zur zufälligen Auswahl beim natürlichen Laichen","TXT_CODE_7b67813a":"Abwürgen","TXT_CODE_7b759c13":"Verhindern Sie, dass voreingestellte Kacheln innerhalb des Schutzradius generiert werden","TXT_CODE_7b763c56":"Der MOTD des Servers. \\nEs spielt keine Rolle, ob „passthrough-motd“ auf „true“ gesetzt ist","TXT_CODE_7b8f01b5":"Anzahl der Arbeitsausführungsthreads","TXT_CODE_7b92d98d":"Anforderungen an die Java-Version","TXT_CODE_7bcf35c1":"Die Höhe des Schadens, den es den Spielern zufügt","TXT_CODE_7bdd0634":"Auf „true“ setzen, um Enderman nur dann gegen Endermiten aggressiv zu machen, wenn sie von einem Spieler erzeugt wurden, der eine Enderperle geworfen hat. \\nDiese Option bewirkt nichts, wenn „aggressiv gegenüber Endermiten“ auf „false“ gesetzt ist","TXT_CODE_7c0b7608":"Knotenstatus","TXT_CODE_7c25c81a":"Deaktiviert Dateibeobachter. \\nWird verwendet, um die Konfiguration automatisch zu aktualisieren, wenn die Datei geändert wurde.","TXT_CODE_7c650d80":"Die Knotenverbindung ist fehlgeschlagen. Bitte wenden Sie sich an den Administrator, um den Status des Remote-Knotens zu überprüfen!","TXT_CODE_7c76dbf":"Gesperrt","TXT_CODE_7cad42a5":"Suche nach Dateinamen","TXT_CODE_7cc196b9":"Schwellenwert für die Netzwerkkomprimierung","TXT_CODE_7ce3c6e":"Buchseiten-ID","TXT_CODE_7ceebc05":"Geben Sie Textinhalte ein, unterstützen Sie die Markdown-Syntax und können Sie Zeilen umbrechen.\\n\\nBenutzen Sie nicht leichtfertig die Texte anderer, da sonst möglicherweise bösartiger Code eingeschleust wird, der Sie angreift.","TXT_CODE_7cf078e8":"Bildname und Versionsidentifikation nach der Erstellung","TXT_CODE_7cf70670":"Wecke das Monster bei jedem Tick auf","TXT_CODE_7d197c39":"Anzahl der E/A-Ausführungsthreads","TXT_CODE_7d1a9487":"Integrierte Java 17-Ausführungsumgebung, geeignet für Server mit Minecraft 1.18 oder höher","TXT_CODE_7d25f076":"Umherziehende Händler werden von Smaragdblöcken in Versuchung geführt und folgen den Spielern, die sie halten","TXT_CODE_7d28d924":"Steuert, wie viele Endkristalle denselben Hitbox-Platz belegen können. \\nBei einer bestimmten Anzahl lösen alle zusätzlichen Kristalle eine Explosion aus.","TXT_CODE_7d3d97ec":"Welche Farbe sollte angezeigt werden, wenn der Füllmodus „gut“ ist?","TXT_CODE_7d81030f":"Kontrollieren Sie, ob riesige Zombies auch über eine feindliche KI verfügen","TXT_CODE_7d839745":"z.B. Apfel, Banane, Kirsche","TXT_CODE_7d874fad":"Die voreingestellte maximale Anzahl an Kreaturen, die pro Welle gespawnt werden. \\nHöher bedeutet, dass es mehr Kreaturen in dieser Welle gibt","TXT_CODE_7da6e84":"Nachdem Sie alle erforderlichen Felder ausgefüllt haben, können Sie es erstellen. Für weitere Einstellungen erstellen Sie diese bitte und bearbeiten Sie sie in den Einstellungen der Anwendungsinstanz!","TXT_CODE_7db580c1":"Blockfallmultiplikator für weißes Bett","TXT_CODE_7dd469fa":"Dies ist die Nachricht, die gesendet wird, wenn ein Benutzer nicht mehr AFK ist (Player-Idle-Timeout muss auf größer als 0 eingestellt sein).","TXT_CODE_7e0b9953":"Was tun mit den Blöcken, die von der Explosion betroffen sind?","TXT_CODE_7e267ba":"Knoten auswählen","TXT_CODE_7e426b47":"Wenn die Abfrage aktiviert ist, welchen Verbindungsport soll das abfragende Protokoll abhören?","TXT_CODE_7e6a82d8":"Konfigurationsdatei eines Forge -Servers","TXT_CODE_7e9727bd":"Anzahl der Spieler","TXT_CODE_7eb0f9fd":"Auf „true“ setzen, um Spieler aus der Entitätsauswahl auszublenden, wenn sie ausgeblendet sind","TXT_CODE_7ec7ccb8":"Wenn auf die Schaltfläche „Instanz stoppen“ geklickt wird, wird dieser Befehl sofort ausgeführt. ^C repräsentiert das Strg-C-Signal.","TXT_CODE_7ec87e8a":"Hochladen abbrechen","TXT_CODE_7ec9c59c":"Name: ","TXT_CODE_7f0017d2":"Anschluss für Panel-Anschluss","TXT_CODE_7f0c746d":"Erfolgreiche Operation","TXT_CODE_7f0daff7":"Beheben Sie das Problem, dass die Position der Entität nicht synchron ist","TXT_CODE_7f1aef9f":"MC Bedrock Edition-Server","TXT_CODE_7f31b67d":"Anzahl der Trichter","TXT_CODE_7f52e10d":"Angriffsschaden (in halben Herzen)","TXT_CODE_7f5ee413":"Der Explosionsradius des Widerrist-Projektilangriffs","TXT_CODE_7f8f267f":"Geschwindigkeitsagentenschlüssel","TXT_CODE_7f9b6758":"Geben Sie optional den absoluten Java-Pfad ein. Wenn Sie das Feld leer lassen, werden die Umgebungsvariablen standardmäßig ausgewählt.","TXT_CODE_7fa8720d":"Startbefehl (Keine Zeilenumbrüche)","TXT_CODE_7fc92d9":"Der Bedrock Edition-Client friert möglicherweise ein, wenn die Eingabeaufforderung zum ersten Mal geöffnet wird. \\nDurch Deaktivieren dieser Funktion wird das Senden von Befehlsvorschlägen verhindert und ein Einfrieren des Bedrock Edition-Clients behoben.","TXT_CODE_7fca723a":"Laden. \\nWenn es lange Zeit keine Antwort gibt, überprüfen Sie bitte das Netzwerk.","TXT_CODE_8028e95b":"Geben Sie Ihren Panel-Benutzernamen ein. Falls noch kein Konto vorhanden ist, wird ein neues Konto erstellt","TXT_CODE_8036ea5e":"Keine Zuordnung festgelegt.","TXT_CODE_806441b5":"Schleichen Sie sich an ein Schwein mit einem Sattel auf dem Rücken und klicken Sie mit der rechten Maustaste darauf, um es zu entfernen, wenn diese Option aktiviert ist","TXT_CODE_80747f11":"Ausgabe des Platzhalters <Minute> in der Option command.uptime.format","TXT_CODE_8074a178":"Neues Ablaufdatum:","TXT_CODE_80766ddc":"Vereinfachtes Skript","TXT_CODE_80790069":"Optional, zum Beispiel 1024","TXT_CODE_808e5ad9":"Es können nur Zip-Archive hochgeladen werden","TXT_CODE_80a560a1":"Accountnummer","TXT_CODE_80c5409f":"Titelbild","TXT_CODE_80c85070":"Umgebungsanforderungen","TXT_CODE_80f0904e":"Professionelle Ausgabe","TXT_CODE_81297804":"Wie Anweisungen, Dateinamen oder andere Parameter usw.","TXT_CODE_812a629e":"Der Browser kann keine Verbindung zur Adresse herstellen:","TXT_CODE_8145d25a":"Bitte wählen Sie eine Instanz aus","TXT_CODE_8145d82":"Kartenlayout speichern","TXT_CODE_814a3c64":"Die maximale Anzahl an fliegenden Monstern, die pro Tick erwacht sind","TXT_CODE_81634069":"Ausführung","TXT_CODE_816ae222":"Ausgabe des Platzhalters <days> in der Option command.uptime.format","TXT_CODE_8175818c":"Blockfallmultiplikator für gelbes Bett","TXT_CODE_818928ba":"Unterstützen Sie jede Sprache und sorgen Sie so weit wie möglich für Einzigartigkeit","TXT_CODE_81979d0f":"Datenspeicherverzeichnis","TXT_CODE_81ad9e80":"Eine flexiblere Möglichkeit, Instanzen zu erstellen, ohne über den App -Marktplatz zu installieren.","TXT_CODE_81b9b599":"Kopieren fehlgeschlagen:","TXT_CODE_81c2f4ae":"Auf „false“ setzen, um zu verhindern, dass sich Rüstungsständer im Wasser bewegen","TXT_CODE_81cabec":"Legt fest, ob der Server beim Start alle Konfigurationswerte im Serverprotokoll speichern soll","TXT_CODE_81d7e7c5":"Open Source, dezentrales, sofort einsatzbereites Admin-Panel, das Minecraft-Spieleserver und alle Konsolenprogramme unterstützt","TXT_CODE_8201d2c6":"Anzahl der Ausführungen/Gesamtzahl aller Instanzen","TXT_CODE_820ebc92":"Verzeichnis in Container einbinden","TXT_CODE_823bfe63":"online","TXT_CODE_8259b3db":"Das nahegelegene Schilfgebiet, um nach Shulkern zu suchen","TXT_CODE_828ea87f":"Hängen Sie zusätzliche Pfade in den Container ein","TXT_CODE_8298bfde":"Die maximale Anzahl von REST-Anfragen im Bucket, bevor die Anfrage abgelehnt wird. \\nDer Mindestwert ist 5","TXT_CODE_82b18ea4":"Welche Farbe sollte angezeigt werden, wenn die RAM-Auslastung „gut“ ist?","TXT_CODE_82c331f":"Ob die Anzahl der Personen online ausgeblendet werden soll","TXT_CODE_82d650be":"Installationsschnittstelle","TXT_CODE_82e624d1":"Mc-Mohist","TXT_CODE_82fbc5ad":"Aktion","TXT_CODE_8343c177":"Die maximale Anzahl erwachter Dorfbewohner pro Tick","TXT_CODE_8366db5a":"End City-Samen","TXT_CODE_836addb9":"(offline)","TXT_CODE_837501b0":"Grundgeschwindigkeit des Minenwagens bei Kontrolle","TXT_CODE_83856178":"Die Anzahl der Tiere, die in jeder Welt gespawnt werden können","TXT_CODE_83914d85":"Ob Remotezugriff auf die Serverkonsole (RCON) zugelassen werden soll","TXT_CODE_83c9cb05":"Block-Entladezeit verzögern","TXT_CODE_83d5cbbe":"Auf „false“ setzen, um zu verhindern, dass Zombie-Dorfbewohner geheilt werden","TXT_CODE_83d8e4a1":"Update-Befehl eingeben","TXT_CODE_83e553fc":"Profilliste konnte nicht abgerufen werden","TXT_CODE_84099e5":"Stellen Sie sicher, dass die Adresse des Remote-Knotens eine öffentliche IP ist und der Knotenverbindungsport normal geöffnet ist.","TXT_CODE_842929d0":"ZIP-Entpackung fehlgeschlagen: {{message}}","TXT_CODE_845b8bd8":"Block-Fall-Multiplikator für lila Bett","TXT_CODE_846683e4":"Hält den Delphin von der Schatzsuche ab","TXT_CODE_849c3911":"Die Chance, dass ein Schildkrötenei zerbricht","TXT_CODE_84bf49c9":"Festplatte I/O:","TXT_CODE_84cf0951":"Händlerinformationen können nicht abgerufen werden","TXT_CODE_84d56d69":"Senden Sie vollständige Positionsinformationen für Objekte mit harter Kollision","TXT_CODE_84f760fa":"Im Allgemeinen handelt es sich um eine .jar-Datei, z. B. paper.jar usw.","TXT_CODE_84fbe277":"Überblick","TXT_CODE_8504218":"Fügt der Zucht von Tieren pro Tiertyp eine Abklingzeit hinzu","TXT_CODE_855c4a1c":"Anzahl Spieler: ","TXT_CODE_85617390":"Mittwoch","TXT_CODE_856bd2f3":"Anzahl der vorübergehend blockierten IPs","TXT_CODE_8575f7c":"Berechtigungen:","TXT_CODE_85770d4a":"Suffix-Parameter","TXT_CODE_858d8728":"Inkubationszeit verlängern","TXT_CODE_859b2d24":"Schlagen Sie Spielernamen vor, wenn die Tab-Vervollständigung leer ist","TXT_CODE_85a33a84":"neu binden","TXT_CODE_85b01e01":"PvP-Modus einstellen. \\nGültige Typen sind: „normal“, „immer“ und „deaktiviert“.","TXT_CODE_85d134f2":"Ob Mobs in eingeschränkte Spawner springen","TXT_CODE_85d8d0a3":"Ob Debugmeldungen über die Konsole gesendet werden sollen.","TXT_CODE_86076132":"Wie blind ein Mob ist, wenn er vom Blindheitstrank-Effekt betroffen ist","TXT_CODE_860e2ce":"Legen Sie fest, ob Eisengolems schwimmen können oder nicht","TXT_CODE_8631c629":"Steuert, ob Rüstungen den Schaden begrenzen sollen, den sie reduzieren können.","TXT_CODE_8638bb65":"Maximale Geschwindigkeit eines kontrollierten Minenwagens","TXT_CODE_8677ef57":"Auf „false“ setzen, um den Donner auch dann fortzusetzen, wenn ein Spieler schläft","TXT_CODE_868df02c":"Über DockerFile-Dateien","TXT_CODE_86ab6e1e":"Deaktivieren Sie Mushroom-Block-Updates","TXT_CODE_86caaf6c":"Erweiterte Optionen","TXT_CODE_86e0cccc":"Adresse muss ausgefüllt werden","TXT_CODE_86ff658a":"Die Konfiguration von SSL, Reverse-Proxy usw. erfordert zusätzliche Unterstützung für das Websocket-Protokoll.","TXT_CODE_870b392e":"Maximale Anzahl an Phantomen, die pro Versuch erscheinen (Verwenden Sie -1, um dies anhand des Weltschwierigkeitsgrads zu ermitteln)","TXT_CODE_8717ed9d":"Umgebungsanforderungen eingeben","TXT_CODE_871cb8bc":"Gehen Sie zum App -Markt, um Anwendungen zu installieren","TXT_CODE_871fb0d6":"Anzahl fehlgeschlagener Anmeldungen: Anzahl erfolgreicher Anmeldungen","TXT_CODE_871feca":"Aktivieren Sie die Brigadier-Syntaxhervorhebung","TXT_CODE_875e804b":"Auf welchem ​​Schwierigkeitsgrad brechen Zombie-Dorfbewohner Türen ein?","TXT_CODE_877eea45":"Optional wird der Standardwert automatisch erstellt und verwaltet. Bitte geben Sie bei Bedarf den vollständigen absoluten Pfad an.","TXT_CODE_877ef60c":"Prozentuale Chance (0,0 – 1,0), dass ein Verteidiger namens „Johnny“ anstelle eines Verteidigers erscheint","TXT_CODE_87c20d47":"Attribut „Maximale Sprungkraft“.","TXT_CODE_87c5dcb4":"Die Aktionsleistenmeldung, die angezeigt wird, wenn die Nacht übersprungen wurde. \\nAuf „Standard“ setzen, damit der Client seine eigenen übersetzbaren Komponenten verwenden kann. \\nLegen Sie eine leere Zeichenfolge fest, um es zu deaktivieren.","TXT_CODE_87e18bb5":"Ob Boss-Spawns oder Invasionsstarts übertragen werden sollen","TXT_CODE_87e448ae":"Server-IP, bitte leer lassen, wenn nicht gebunden","TXT_CODE_87f0a517":"Deaktivieren Sie die Box-Cat-Erkennung","TXT_CODE_880fedf7":"Filter zurücksetzen","TXT_CODE_881213df":"Was sollte MOTD sein? \\nDiese Informationen werden angezeigt, wenn ein Spieler Ihren Server zur Serverliste hinzufügt. \\nEs wird nur das MiniMessage-Format akzeptiert.","TXT_CODE_88122886":"Kompression","TXT_CODE_88249aee":"Server-Vorlagenmarkt","TXT_CODE_88405298":"Ob Schneebälle, wenn sie geworfen werden, Kerzen löschen sollen","TXT_CODE_88419e99":"maximale Blockhöhe","TXT_CODE_88427611":"Wird verwendet, um die Generierung einer superflachen Welt anzupassen. Wenn Sie keine superflache Welt generieren möchten, lassen Sie das Feld bitte leer.","TXT_CODE_88c990a4":"Integrierte Paketgröße","TXT_CODE_88e9361a":"Betriebsstatus der Instanz","TXT_CODE_88f7082":"Auf „true“ setzen, damit Beschwörer die Mob-Griefing-Gamerule umgehen","TXT_CODE_890aa44c":"RCON-Verbindungsport","TXT_CODE_893567ac":"Zweite Bestätigung","TXT_CODE_894b8e52":"Maximale Auto-Neustarts erreicht","TXT_CODE_8956123b":"Sollten wir IP-Adressen und andere Daten an Backend-Server weiterleiten?","TXT_CODE_8965b2cf":"Der Servername, der an den JAVA-Client gesendet wird. \\nDies ist sowohl im Pausenmenü als auch im Einstellungsmenü sichtbar.","TXT_CODE_8981d724":"Unbenannte Titelspalte","TXT_CODE_8a30e150":"Alle Sprachen","TXT_CODE_8a5274c1":"Gibt an, wie lange in Millisekunden BungeeCord zwischengespeicherte Ergebnisse von Server-Pings verwenden soll, anstatt sie manuell für die Spieleranzahl zu pingen. Geben Sie zum Deaktivieren -1 ein","TXT_CODE_8a71a4d7":"Auf „true“ setzen, damit Feuerbälle die Mob-Griefing-Gamerregel umgehen","TXT_CODE_8a7c57b9":"Ermöglicht Ihnen, die Türen einzustellen, deren Betätigung Redstone erfordert (Eiche, Fichte usw.)","TXT_CODE_8a924345":"Ob ServerName anstelle des Weltnamens verwendet werden soll","TXT_CODE_8a9c6364":"7zip-Entpackwarnung: {{warning}}","TXT_CODE_8a9fd2b4":"Phantomflügel greifen nur Schlaflose an","TXT_CODE_8aa7f7a0":"Können Skelettpferde im Wasser schwimmen? \\nFalse lässt sie auf den Boden sinken (Vanilla-Standardeinstellung)","TXT_CODE_8ab0cc1a":"Verhindern Sie, dass Hardcore-Spieler sterben","TXT_CODE_8ae0dc90":"Hintergrundbild der Benutzeroberfläche","TXT_CODE_8b0f8aab":"Neue Karte hinzufügen","TXT_CODE_8b14426e":"Die Datei existiert bereits. Überspringen Sie das Hochladen","TXT_CODE_8b62abb2":"Liste der Remote-Host-Images","TXT_CODE_8b8c52f":"Sie sind nicht auf der Whitelist!","TXT_CODE_8b8e08a6":"Erstellungszeitpunkt: ","TXT_CODE_8b937b23":"Knoten löschen","TXT_CODE_8bb8e2a1":"Händlermodus","TXT_CODE_8bd1f5d2":"Existiert bereits im Verzeichnis. Möchten Sie die Originaldatei überschreiben?","TXT_CODE_8be0e39b":"Anzahl der Ticks zwischen den Ertrinkungsschäden","TXT_CODE_8bf86cbc":"Auf „false“ setzen, um zu verhindern, dass die Anzeigenamen von TE nach einer Unterbrechung bestehen bleiben (z. B. benannte benutzerdefinierte Spielerköpfe behalten ihren Namen nicht mehr).","TXT_CODE_8c0db3f4":"Bitte füllen Sie die Inbetriebnahmeanleitung selbst aus","TXT_CODE_8c17acf8":"Port-Mapping","TXT_CODE_8c18a6ac":"Der Projektilversatz eines Bogens","TXT_CODE_8c2ad2cb":"Ermöglicht Spielern, temporäre Spielsteine ​​zu zerstören, die nicht gebaut werden können (Gras, Blumentöpfe usw.)","TXT_CODE_8c3164c9":"Persönliche Angaben","TXT_CODE_8c7318b3":"Starten Sie eine Instanz","TXT_CODE_8cb5a1e6":"Die Anzahl der Reihen, die ein Fass haben sollte. \\nMin: 1, Max: 6","TXT_CODE_8cba8d40":"Legen Sie fest, ob Eisengolems in der Luft spawnen können, wie in 1.12 und niedriger","TXT_CODE_8cc8e9e2":"Der Grundwert, der für den Angriffsschaden des Schleims festgelegt werden soll","TXT_CODE_8ccb5428":"Dateiliste erfolgreich aktualisiert","TXT_CODE_8cfa8c1e":"Ob der Trichter Brocken laden kann","TXT_CODE_8d4882b0":"Optional, es wird nicht empfohlen, dieses Element ohne besondere Anforderungen auszufüllen","TXT_CODE_8d4c8f7e":"Versäumte, laufende Behälter zu übernehmen","TXT_CODE_8d4e6058":"Überprüfen Sie die Bibliotheken","TXT_CODE_8d5d8e26":"Sumpfsamen","TXT_CODE_8d6c8ae7":"Vorlagenbeschreibung eingeben","TXT_CODE_8d6e5b1f":"Überprüfen Sie den Fortschritt der Abmessungen genau","TXT_CODE_8d83752":"Nur offizielle Spiel-Download-URLs und ZIP-Dateien unterstützt","TXT_CODE_8d8b1d6a":"Erstellen Sie eine Minecraft-Instanz","TXT_CODE_8d8fbbf4":"Zuordnung hinzufügen","TXT_CODE_8d9f5a4e":"Solange der Remote-Knoten (Remote-Knoten) läuft, wird automatisch ein Instanz-Startvorgang initiiert.","TXT_CODE_8da44b20":"Blockfallmultiplikator für schwarzes Bett","TXT_CODE_8dbcf565":"Paketgröße (Optional)","TXT_CODE_8dd7bc1a":"Maximale Chunk-Laderate des Spielers","TXT_CODE_8deb2054":"Wenn man dem Eisengolem eine Mohnblume gibt, beruhigt er sich, wenn er wütend ist","TXT_CODE_8dfc41ef":"Gastgeber","TXT_CODE_8dfd8b17":"unbegrenzt","TXT_CODE_8e16ee21":"Vorlagendatei hochladen","TXT_CODE_8e223f23":"Keine Daten zum Download verfügbar","TXT_CODE_8e2be926":"Bitte geben Sie die IP-Adresse des Spielservers ein. Wenn Sie das Feld leer lassen, wird standardmäßig der lokale Daemon-Host (localhost) verwendet.","TXT_CODE_8e5f865e":"Der Typ der Datenbank, die zum Speichern von Daten verwendet wird (SQLite oder MySQL)","TXT_CODE_8e632796":"Serverzugriffsadresse","TXT_CODE_8eb1ae3e":"Auf „true“ setzen, um Teleportbeschränkungen für Netherportale aufzuerlegen. \\nDadurch wird das EntityTeleportHinderedEvent-Ereignis gesendet, das die Möglichkeit bietet, Teleports erneut zu versuchen, wenn sie aufgrund von Passagieren/Fahrzeugen fehlschlagen","TXT_CODE_8f20c21c":"Möchten Sie das Speichern des Layouts wirklich abbrechen?","TXT_CODE_8f3582d7":"Set-Version","TXT_CODE_8f3e5807":"Mc-Nukkit","TXT_CODE_8f47d95":"Per Tastenkombination gespeichert!","TXT_CODE_8f809a5":"Wecken Sie die hartnäckigen Zecken der Tiere auf","TXT_CODE_8f8103b7":"Container","TXT_CODE_8f9533b5":"Aktivieren Sie die Anti-Pivot-Funktion","TXT_CODE_8fac22fc":"Welche Farbe soll angezeigt werden, wenn der Füllmodus „niedrig“ ist?","TXT_CODE_8fac56fb":"Geschwindigkeit des Verschwindens von Gegenständen","TXT_CODE_8facd134":"Hier klicken","TXT_CODE_8fd7a9a1":"Stellen Sie sicher, dass Docker erfolgreich auf diesem Computer installiert ist!","TXT_CODE_8fd8bfd3":"Menüpunkt wählen","TXT_CODE_8fe9c7f7":"Ob die Whitelist aktiviert werden soll (alte Version)","TXT_CODE_903a9ec9":"Musik-Player-Karte","TXT_CODE_903b6c50":"Der Benutzer existiert nicht. Bitte versuchen Sie es erneut","TXT_CODE_903dfe61":"simulierte Distanz","TXT_CODE_90508729":"Durch diesen Vorgang wird das gesamte Verzeichnis, in dem sich die Instanz befindet, direkt gelöscht und die Dateien können nicht wiederhergestellt werden. Möchten Sie fortfahren?","TXT_CODE_9066472a":"Wenn Sie dies auf „false“ setzen, können die Level auf „32767“ steigen, indem sie als Shorts statt als Bytes gespeichert werden.","TXT_CODE_906c5d6a":"Löschung abgeschlossen!","TXT_CODE_90865a4":"Deaktiviert den Methodenprofiler.","TXT_CODE_90896d08":"Standardgruppenname für nicht registrierte Spieler","TXT_CODE_908a4ace":"Fehlende Volumendatei","TXT_CODE_90912e04":"Deaktivieren Sie Grabsteine, die fallen gelassen werden, wenn der Spieler stirbt","TXT_CODE_9095d186":"Maximaler Erfahrungswert, der beim Tod verloren geht","TXT_CODE_90a9d317":"Container-Umgebungsvariablen","TXT_CODE_90b2ae00":"MCSManager legt Wert darauf, die Benutzererfahrung im hellen Modus sicherzustellen. Der dunkle Modus kann bei einigen Schnittstellen zu einer schlechteren Benutzererfahrung führen.","TXT_CODE_90b596a8":"Das Format der Bossbar, wenn der Server den Befehl /rambar ausführt","TXT_CODE_90e959d2":"Ermöglicht die Kompatibilität mit dem PROXY-Protokoll von HAProxy. \\nWenn Sie nicht wissen, wozu dies dient, aktivieren Sie es nicht.","TXT_CODE_90edf4ad":"Maximale Anzahl von Verbindungen pro Tick","TXT_CODE_90f00679":"SQLite-Datenbankpfad","TXT_CODE_90f684dc":"[Allgemein] eula.txt","TXT_CODE_912ec943":"Der Client ist veraltet! \\nBitte verwenden Sie {0}","TXT_CODE_91381d5c":"Wenn diese Option aktiviert ist (Standard ist „false“) und sich der Agent im Online-Modus befindet, wirft Velocity alle vorhandenen Online-Spieler raus, wenn wiederholt versucht wird, eine Verbindung herzustellen.","TXT_CODE_91507ef3":"Ob die Unterstützung für Forge aktiviert werden soll","TXT_CODE_9156fbc":"Anzahl der Ausführungen. Wenn Sie das Feld leer lassen, bedeutet dies unbegrenzte Anzahl","TXT_CODE_91734638":"Ob die serverseitige autorisierende Bewegung aktiviert werden soll","TXT_CODE_91a8d35c":"Prozentuale Chance (0,0–1,0), dass das Killerkaninchen auf natürliche Weise spawnt","TXT_CODE_91b3fa98":"Das Panel kann nicht wissen, ob dieses Profil kompatibel ist. Bitte geben Sie die entsprechende Profilschnittstelle entsprechend dem Typ ein.","TXT_CODE_91bb6101":"Panel/Linux (UTF8)","TXT_CODE_91d066aa":"7zip nicht geladen, Mehrteilige Archive werden nicht unterstützt. Diese (zip, 7z, rar etc.) benötigen 7zip. Bitte Administrator um Installation der 7zip-Bibliothek.","TXT_CODE_91d70059":"Instanzverzeichnis:","TXT_CODE_91d857f5":"Optional, 0 bis unendlich","TXT_CODE_91ebfa75":"Fluggeschwindigkeitsattribut","TXT_CODE_921206fc":"Vorlage bearbeiten","TXT_CODE_9213f8e3":"Konfigurationsdatei für Pufferfish. \\nEs ermöglicht die weitere Konfiguration eines Papierservers.","TXT_CODE_925af648":"Wachstumsrate leuchtender Beeren","TXT_CODE_9268932c":"Bereich beim Speichern aktualisieren","TXT_CODE_9277af78":"Wiederholen","TXT_CODE_9278b7b0":"Normalerweise ist die Standardeinstellung ausreichend. Wenn Sie kommerzielle Aktivitäten ausüben, sollten Sie die Startmethode für virtualisierte Container verwenden, da sonst der Host angegriffen werden kann.","TXT_CODE_928653c6":"Ob Entitäten innerhalb des folgenden Bereichs vom Zielselektor ausgewählt werden","TXT_CODE_929a9ee4":"Benutzername der MySQL-Datenbank","TXT_CODE_92bedafa":"Komprimierung des Netzwerkverkehrs zum Bedrock Edition-Client. \\nJe höher die Zahl, desto größer ist die CPU-Auslastung, aber desto weniger Bandbreite wird beansprucht. \\nUnterhalb von -1 oder 9 hat dies keine Auswirkung. \\nZum Deaktivieren auf -1 setzen.","TXT_CODE_92c21a08":"Ob eine Verbindung zu einem Java-Server hergestellt werden soll, ohne eine TCP-Verbindung herzustellen.","TXT_CODE_92ebdc7f":"Die vom Panel komprimierten ZIP-Dateien werden alle in der UTF-8-Kodierung gepackt. Wenn Sie eine Dekomprimierung benötigen, wählen Sie bitte die UTF-8-Kodierung zum Dekomprimieren aus!","TXT_CODE_930d2524":"Direkte Verbindung zur Webseite","TXT_CODE_93191a82":"Sendet die Todesnachrichten im Chat nur an den betroffenen Spieler","TXT_CODE_931e4c8":"Die Geschwindigkeit, mit der sich ein Kessel mit Regen füllt (hängt vom zufälligen Tick ab)","TXT_CODE_9337bed1":"Es scheint, dass es hier keine Remote-Knoten gibt. Möglicherweise liegt während des Installationsvorgangs ein Problem vor, das durch einen Neustart Ihres Panels behoben werden kann.","TXT_CODE_9341498a":"Aktualisierungsradius","TXT_CODE_93610b08":"Macht dieses Mob-Reittier im Wasser montierbar (es schleudert dich nicht heraus)","TXT_CODE_9364ec40":"Die maximale Anzahl an Tieren, die pro Zecke geweckt werden","TXT_CODE_937b42e6":"Multiplikator für die Erschöpfung der Hungerstange im Sprint","TXT_CODE_9393b484":"Instanz zuordnen","TXT_CODE_9394aadf":"Ob Spieler gekickt werden sollen, wenn sie den TileLiquid-Schwellenwert überschreiten","TXT_CODE_93a70cda":"Erforderliche Parameter der Karte","TXT_CODE_93afb039":"Behebt MC-3304, indem verhindert wird, dass Plünderungen auf durch ein Projektil verursachte Todesfälle angewendet werden, es sei denn, ein Plugin hat den Plünderungsmodifikator geändert.","TXT_CODE_93c3cb78":"Für diese Adresse müssen Sie möglicherweise Node-Direktverbindungszuordnungen konfigurieren.","TXT_CODE_93d4b66a":"Die Dateioperationsaufgabe wird gestartet. Wenn zu viele Dateien vorhanden sind, dauert es einige Zeit.","TXT_CODE_93f9b02a":"IP-Adresse des Remote-Knotens","TXT_CODE_94002354":"Verhindern Sie, dass Spieler sich mit ihrer Client-UUID anmelden","TXT_CODE_941d83b8":"Pfadpräfix","TXT_CODE_9466852b":"Diese Karte kann zur Spaltensegmentierung verwendet werden, ähnlich wie bei Titeln beim Schreiben von Artikeln, und kann für das Layout verwendet werden.","TXT_CODE_946d4401":"Legt fest, ob der Spieler getreten werden soll, wenn der Spieler die Projektilschwelle überschreitet","TXT_CODE_94b6cd6e":"Legen Sie hier Ihren obligatorischen Host fest.","TXT_CODE_94bb113a":"Größe","TXT_CODE_94bcd51b":"Häufigkeit der Aktualisierung hängender Blöcke","TXT_CODE_94c193de":"Dateiname","TXT_CODE_94d4c80c":"Ob Spieler der Bedrock Edition daran gehindert werden sollen, Gerüste zu bauen.","TXT_CODE_94d885d1":"Legen Sie dies auf True ein, um das Anzeigen von Debug -Informationen zu Attributen eines Elements zu aktivieren, wenn erweiterte Tooltips eingeschaltet sind.","TXT_CODE_94f1ba3":"Nach Auswahl dieser Vorlage werden alle Daten dieser Instanz gelöscht. Bitte komprimieren und laden Sie zuerst die Dateisicherung herunter. Möchten Sie fortfahren?","TXT_CODE_94f55150":"Visueller Vorlagen-Editor","TXT_CODE_950c0d7a":"Wachstumsgeschwindigkeit der verdrehten Rebe","TXT_CODE_952c2697":"Erhöhen oder verringern Sie den Prozentsatz, um die Erkennungsreichweite des Mobs zu verkleinern oder zu vergrößern, wenn ein Spieler den entsprechenden Kopf des Mobs trägt","TXT_CODE_95340802":"Ob Hardcore-Spieler rausgeschmissen werden sollen","TXT_CODE_9535104c":"Auf „false“ setzen, um zu verhindern, dass der Creeper trauert.","TXT_CODE_95495db":"Aktenarbeit","TXT_CODE_95583336":"Java Edition Minecraft Server","TXT_CODE_958fd70c":"Profil Beschreibung","TXT_CODE_95b08ec3":"Lässt den Creeper explodieren, wenn er getötet wird","TXT_CODE_95b9833f":"Zur Konsole zurückkehren","TXT_CODE_95bdc950":"Ein Uniform Resource Identifier (URI) verweist auf ein Ressourcenbündel. \\nSpieler können wählen, ob sie es verwenden möchten","TXT_CODE_95c5e900":"Der vollständige Name des Bildes, zum Beispiel: openjdk:17","TXT_CODE_95c65dc1":"Auf „true“ setzen, damit Schafe die Mob-Griefing-Gamerule umgehen","TXT_CODE_95d43994":"Die minimale Stufe der Verzauberung „Seidenberührung“, die erforderlich ist, um verminte Spawner aufzusammeln","TXT_CODE_95df80df":"Ihnen steht eine professionellere Benutzeroberfläche zur Verfügung.","TXT_CODE_95dfd5bd":"Maximale MP, die ein Spieler vor Ausrüstungs-Buffs haben kann","TXT_CODE_96281410":"Pfad nicht gefunden","TXT_CODE_962d9320":"Für das Arbeitsverzeichnis, in dem die Instanz ausgeführt wird, können Sie den absoluten und den relativen Pfad eingeben","TXT_CODE_962f4288":"Größe des Benutzercaches","TXT_CODE_9651d0b3":"Der Schaden wird mit der Geschwindigkeit multipliziert, wenn der Flug schneller als die eingestellte Geschwindigkeit ist. \\nDer Wert 0 deaktiviert diesen Multiplikator","TXT_CODE_96520bce":"Die maximale Anzahl an benutzerdefinierten Köpfen, die pro Spieler angezeigt werden.","TXT_CODE_965360cd":"Schutzradius generieren","TXT_CODE_9654b91c":"Sind Sie sicher, dass Sie den aktuellen Benutzer abmelden möchten?","TXT_CODE_96c02044":"Prozentuale Chance (0,0–1,0), dass dieser Mob aggressiv gegenüber Spielern spawnt","TXT_CODE_96e6bf5d":"Endgültiger Soundeffektradius des Portals","TXT_CODE_9740f199":"Das aktuelle Layout geht verloren. Möchten Sie fortfahren?","TXT_CODE_97433ac4":"Mehr Informationen","TXT_CODE_97535446":"Ändern Sie den im Overhead-Chat verwendeten Spielernamen. \\nBeginnt mit dem Spielernamen in eckigen Klammern im gleichen Format wie Terraria. \\nDasselbe Format wie ChatFormat, jedoch ohne die Nachricht.","TXT_CODE_97655c5d":"Wird verwendet, um Containern den Zugriff aufeinander in einem benutzerdefinierten Netzwerk zu ermöglichen, getrennt durch Leerzeichen.","TXT_CODE_9775ccb":"Möchten Sie wirklich in den Dunkelmodus wechseln?","TXT_CODE_977cb449":"Warten auf die Veranstaltung „Download abgeschlossen“ ...","TXT_CODE_978491ec":"Verbindungszeitüberschreitung","TXT_CODE_978da1c1":"Bauarbeiten im Gange","TXT_CODE_979b9aaf":"Deaktivieren Sie Skins, die von Spielern außerhalb des Minecraft-Stores oder aus In-Game-Ressourcen angepasst wurden","TXT_CODE_97b80a79":"Ob Minenwagen überall platziert werden können, nicht nur auf Schienen","TXT_CODE_97be50a8":"Du bist fertig!","TXT_CODE_97ceb743":"Bitte wählen Sie die Dekomprimierungskodierung aus","TXT_CODE_97d17cce":"Benutzerliste","TXT_CODE_97e5eccb":"Wird verwendet, um Details einer angegebenen Instanz anzuzeigen","TXT_CODE_97f5701e":"Ob der Spieler fliegen darf (in jedem Spielmodus)","TXT_CODE_97f5d91f":"Wie schnell darf sich der Client nach der letzten Verbindung verbinden? \\nStandardmäßig beträgt dieser drei Sekunden. \\nDeaktivieren Sie diese Funktion, indem Sie sie auf 0 setzen.","TXT_CODE_97f779b3":"MC Java Edition-Server","TXT_CODE_97ff044f":"Befehlsblöcke aktivieren","TXT_CODE_981c59e6":"Papageien werden von Spielerbewegungen nicht beeinflusst","TXT_CODE_9867da6b":"Ob der Server eine Warnung anzeigt, wenn ein Plugin ein veraltetes Ereignis registriert","TXT_CODE_98742e5f":"Die Farbe der Bossleiste","TXT_CODE_9878c2bc":"Standardmäßig versucht Velocity, den unerwarteten Verlust der Verbindung eines Benutzers zum Server ordnungsgemäß zu bewältigen, anstatt die Verbindung zu trennen.","TXT_CODE_9885543f":"Die Konsole konnte nicht initialisiert werden. Möglicherweise existiert der Remote-Knoten oder die Instanz nicht mehr. Bitte aktualisieren Sie die Webseite und versuchen Sie es erneut.","TXT_CODE_98b4ac74":"Mc-Neoforge","TXT_CODE_98dbd049":"Maximal 3 Zeilen empfohlen","TXT_CODE_98e50717":"Konfigurationsdatei für Purpur. \\nEs ermöglicht die weitere Konfiguration erweiterter Parameter und spezifischerer Spieleinstellungen. \\nEs wirkt sich stark auf die Gesamtleistung aus und erweitert die Einschränkungen der Paper-Konfigurationsdatei.","TXT_CODE_98e7c829":"Lassen Sie das Feld leer, um den standardmäßigen Docker-Image-Befehl zu verwenden","TXT_CODE_9900f79e":"Bilder","TXT_CODE_9901af98":"Tags (Optional)","TXT_CODE_9911ac11":"Das Speichern ist fehlgeschlagen. Bitte überprüfen Sie die Einstellungen","TXT_CODE_99167cda":"Ob Minenwagen gesteuert werden können, wenn sie nicht auf Schienen sind","TXT_CODE_992bf9bc":"MC Bukkit","TXT_CODE_998d1dec":"Blockfallmultiplikator für orangefarbenes Bett","TXT_CODE_99a42341":"z.B. https://example.com/bild.png","TXT_CODE_99ca8563":"Datei überschreiben","TXT_CODE_99e98174":"Zähle alle Kreaturen zum Laichen","TXT_CODE_99f8edf0":"Auf „true“ setzen, um can_summon bei der Platzierung auf „true“ zu setzen","TXT_CODE_99fab05d":"Ob Respawn-Anker explodieren. \\nWenn Sie dies auf „false“ setzen, verschwinden die Respawn-Anker einfach","TXT_CODE_9a6e35e4":"Spielerinteraktion deaktivieren","TXT_CODE_9aa1872c":"Liste der Gegenstände, die gegen Blitze immun sind","TXT_CODE_9aa83c05":"Standardmäßig erbt es und verwendet den Systembenutzer von StartPad","TXT_CODE_9ab6fd":"Benutzer <<operator_name>> Erstellt die <<instance_name>> Instanz","TXT_CODE_9ac035d0":"Datenschutzeinstellungen für Servernamen","TXT_CODE_9ac051fb":"Markiert Gegenstände in nicht verfügbaren Plätzen im Spielerinventar der Bedrock Edition.","TXT_CODE_9ade0fb8":"7zip-Dateiberechtigungen fehlgeschlagen: {{message}}","TXT_CODE_9afe56de":"Hochladenrate","TXT_CODE_9b36d5a2":"[Allgemein] server.properties","TXT_CODE_9b3ce825":"Beschreibung des Reverse-Proxys","TXT_CODE_9b45858c":"Installieren Sie die Anwendungen schnell mit voreingestellten Vorlagen","TXT_CODE_9b4985d3":"Instanz erfolgreich aktualisiert!","TXT_CODE_9b5dcfdd":"Anzahl von Beispielen","TXT_CODE_9b8f02fd":"Komprimierungsalgorithmus","TXT_CODE_9b99b72e":"Stellen Sie Anwendungsinstanzen schnell bereit","TXT_CODE_9b9b745c":"Erstellen Sie ein OpenJDK 17-Umgebungsimage","TXT_CODE_9bb2f08b":"Nutzerinformation","TXT_CODE_9bc7f49e":"Die Anzahl der Instanzen, die nicht betriebsbereit sind","TXT_CODE_9c188ec8":"Besuchen Sie https://docs.mcsmanager.com, um mehr zu erfahren.","TXT_CODE_9c2250b7":"Auf „true“ setzen, um durch NetworkItemSerializeEvent geänderte Elemente zu reparieren, die bestehen bleiben, obwohl sie clientseitig sind, weil der Kreativ-Client Kreativ-Inventaraktionen verwendet","TXT_CODE_9c247f6":"Mounten des Container-Arbeitsverzeichnisses","TXT_CODE_9c39c7ae":"Ob Chatnachrichten über dem Kopf des Spielers angezeigt werden sollen","TXT_CODE_9c3ca8f":"Sicherheitseinstellungen","TXT_CODE_9c7f8eb8":"Wie effektiv das Ausbessern bei der Reparatur von Gegenständen ist. Höhere Werte bedeuten, dass weniger XP für die Reparatur von Gegenständen verwendet wird. \\n(1,0 = 100 %)","TXT_CODE_9c95b60f":"Fehlermeldung:","TXT_CODE_9c9c19f0":"Halten Sie den Spawnpunkt geladen","TXT_CODE_9cae6f92":"Zeitüberschreitung beim Bild-Download! \\nWir können nur bis zu 15 Minuten warten, bitte überprüfen Sie Ihr Netzwerk!","TXT_CODE_9cefd73":"Automatisch speichern","TXT_CODE_9d1d244f":"Programmstart fehlgeschlagen, Eingabe- und Ausgabestreams sind nicht lesbar: {{pipeName}}","TXT_CODE_9d2fca76":"Kein Auto-Neustart bei Erreichen der Neustartanzahl. (-1 für unbegrenzt)","TXT_CODE_9d498b20":"Einrichtung erfolgreich, speichern, um die Änderungen zu übernehmen","TXT_CODE_9d820cb4":"Informationsdetails","TXT_CODE_9d8e6107":"Spielern erlauben, Hinweise auf Dorfbewohner zu verwenden (Händler nicht inbegriffen)","TXT_CODE_9d902725":"Auf welchem ​​Schwierigkeitsgrad wird das zombifizierte Schweinchen die Tür aufbrechen?","TXT_CODE_9d982f06":"Ob IP-Tracking aktiviert werden soll","TXT_CODE_9dc4ee75":"Für Pulverschnee auf „true“ setzen, um die Mob-Griefing-Gamerule zu umgehen","TXT_CODE_9df0f923":"Meeressamen","TXT_CODE_9df68e04":"Verhindern Sie das Laden von Plug-Ins mit inkompatiblen APIs","TXT_CODE_9df98e2":"Konfiguration aufbauen ...","TXT_CODE_9e090ff6":"Wie viel Erfahrungspunkte man beim Tod verliert. \\nVerfügbare NMS-Variablen sind expLevel, expTotal und exp","TXT_CODE_9e1657b":"Block-Fall-Multiplikator für rosa Bett","TXT_CODE_9e33445e":"Wenn Sie mit der rechten Maustaste auf ein Skelett klicken, während Sie eine Widerristrose halten, wird das Skelett in ein Widerristskelett umgewandelt. \\nDer Wert gibt an, wie viele verwelkte Rosen Sie benötigen würden, um das Skelett umzuwandeln, und 0 bedeutet, dass die Funktion deaktiviert ist.","TXT_CODE_9e3f25e0":"Minecraft Java Edition-Spieleserver","TXT_CODE_9e5eb2a":"Suchen Sie nach vorhandenen Hühnern, auf denen Sie laichen können","TXT_CODE_9e8c176e":"Wird verwendet, um die Benutzeroperationsprotokolle anzuzeigen","TXT_CODE_9e9c0179":"Wie lange die Verzögerung eines großen Dripleafs sein sollte, bis es in die nächste Animation übergeht","TXT_CODE_9e9d3767":"Wenn Sie im Mietgeschäft tätig sind, stellen Sie sicher, dass die Anwendungsinstanz in einem virtuellen Linux-Docker-Container ausgeführt wird, da sonst Sicherheitsrisiken bestehen.","TXT_CODE_9eacb622":"Methode zum Starten der Reise","TXT_CODE_9eb5dd12":"Blockfallmultiplikator für magentafarbenes Bett","TXT_CODE_9ef27367":"Komplett löschen","TXT_CODE_9f174887":"Lesen Sie die Festplatte","TXT_CODE_9f28d67b":"Der Generierungstyp der Karte (Standard: flach, superflach: verstärkt, große Biome: große Biome)","TXT_CODE_9f4eaa41":"Spieltyp auswählen","TXT_CODE_9fb9e6a8":"Auf „false“ setzen, um zu verhindern, dass Babys fahrbar werden","TXT_CODE_9fd05002":"Legen Sie fest, ob eine Biene nach dem Stechen sterben soll","TXT_CODE_9fe98f3":"Abhörport","TXT_CODE_9fed23ab":"Bitte geben Sie den Bildnamen ein","TXT_CODE_A0000001":"Geeignet für Startbefehle aller Konsolenprogramme, Skriptdateien werden nicht unterstützt;<br />Zum Beispiel: „C://Program Files/Java/bin/java.exe“ -Dfile.encoding= utf-8 -Djline.terminal =jline.UnsupportedTerminal -jar my server.jar -nogui <br/>Wenn Sie einen Docker-Container verwenden, müssen Sie den Startbefehl nicht ausfüllen und beginnen mit der Verwendung des durch das Image definierten Befehls.","TXT_CODE_ETA":"ETA","TXT_CODE_Instance_router.accessFileErr":"Die Datei existiert nicht oder der Pfad ist falsch.","TXT_CODE_Instance_router.cancelIO":"Sitzung {{id}} hat den Abbruch des E/A-Streams der Weiterleitungsinstanz {{targetInstanceUuid}} angefordert","TXT_CODE_Instance_router.openInstanceErr":"Fehler beim Starten der Instanz {{instanceUuid}}:","TXT_CODE_Instance_router.performTasks":"Für die Sitzung {{id}} ist die Instanz {{uuid}} erforderlich, um die asynchrone asynchrone Aufgabe {{taskName}} auszuführen","TXT_CODE_Instance_router.performTasksErr":"Instanz {{uuid}} {{taskName}} Ausnahme bei asynchroner Aufgabenausführung: {{err}}","TXT_CODE_Instance_router.requestIO":"Sitzung {{id}} Anforderungsweiterleitungsinstanz {{targetInstanceUuid}} E/A-Stream","TXT_CODE_Instance_router.taskEmpty":"Es werden keine asynchronen Aufgaben ausgeführt","TXT_CODE_Instance_router.terminalLogNotExist":"Konsolenprotokolldatei ist nicht vorhanden","TXT_CODE_Speed":"Geschwindigkeit","TXT_CODE_a00e84d7":"Gelöscht","TXT_CODE_a02a0849":"Dieser Wert definiert, wie oft in Ticks die Pathfinder und Verhaltensweisen der am weitesten entfernten Entität angekreuzt werden.","TXT_CODE_a0451c97":"Stornieren","TXT_CODE_a08f261e":"Ob das Portal-Spawnen von Zombie-Piglins aktiviert werden soll","TXT_CODE_a092b6f0":"Liste der Gegenstände, die gegen Kakteen immun sind","TXT_CODE_a0a00fc0":"Erlauben Sie Minecarts, Schildkröteneier zu beschädigen/zerbrechen","TXT_CODE_a0a77be5":"Ausführung nicht möglich. Bitte wählen Sie mindestens eine Instanz aus","TXT_CODE_a0a99beb":"Gibt Papageien die Möglichkeit, sich mit jeder Art von Samen zu vermehren (Babypapageien gibt es nicht D:, daher kommen „erwachsene“ Papageien heraus)","TXT_CODE_a0d214ac":"Zum Beispiel 1024, 2048 usw., fügen Sie bitte keine Einheiten hinzu.","TXT_CODE_a0e19f38":"Instanz löschen","TXT_CODE_a0e70887":"Entsprechende Knotenversion","TXT_CODE_a0eb8b37":"Eis- und Schneeeffekte deaktivieren","TXT_CODE_a0ede210":"7zip-Programm nicht gefunden","TXT_CODE_a106108c":"Musikdateien hochladen","TXT_CODE_a112cff4":"Prioritätensetzung","TXT_CODE_a132c796":"Lassen Sie zu, dass Exp-Kugeln Schildkröteneier beschädigen/zerbrechen","TXT_CODE_a1587e9d":"Ob der Server die IP-Adresse des Spielers protokolliert.","TXT_CODE_a1833a27":"Der Basiswert, der für den Angriffsschaden des Magmawürfels festgelegt werden soll","TXT_CODE_a1a59b08":"Panel-Sprache","TXT_CODE_a1cc8b68":"Können Zombiepferde im Wasser schwimmen? \\nFalse lässt sie auf den Boden sinken (Vanilla-Standardeinstellung)","TXT_CODE_a1d885c1":"Neu","TXT_CODE_a1e4c720":"Ermöglicht die Möglichkeit, Verzauberungen über ihren Maximalwert hinaus durch den Befehl zu erhöhen","TXT_CODE_a22e749a":"Deaktiviere kritische Spielertreffer","TXT_CODE_a2544278":"Instanzbezeichnung","TXT_CODE_a2a0e054":"Zum Beispiel: server.exe, app.exe oder verwenden Sie einen absoluten Pfad usw.","TXT_CODE_a2c8c88a":"Entfernung bis zum Stoppen des Ladens von Chunks (zulässige Werte: 4, 12)","TXT_CODE_a379038f":"Server Port","TXT_CODE_a3991784":"Ändere die Genauigkeit, mit der Skelette schießen. \\nDas Ergebnis der Formel ist die Divergenz (Spread). \\nJe höher der Wert, desto ungenauer ist der Schuss.","TXT_CODE_a3abb092":"MC-Velocity","TXT_CODE_a3de630":"Geben Sie den für den Kauf verwendeten Einlösungscode ein","TXT_CODE_a3efb1cc":"Komprimiertes Paket importieren","TXT_CODE_a3f13157":"Containerschutz","TXT_CODE_a3f8313f":"Bereich, in dem ein Schwamm Wasser aufnimmt","TXT_CODE_a4037a98":"Anzahl der Schnittstellenanfragen","TXT_CODE_a409b8a9":"Anhalten","TXT_CODE_a41a4820":"POI-Überprüfungszeit in der Nähe von Dorfbewohnern","TXT_CODE_a42984e":"Variablennamen","TXT_CODE_a463be37":"Das Format der Bossbar, wenn der Server den Befehl /compass ausführt","TXT_CODE_a4748cb0":"Bitte geben Sie den RCON-Protokollport des Spieleservers ein, der normalerweise in der Konfigurationsdatei zu finden ist.","TXT_CODE_a4757fec":"Berechtigungen der Administrator-Benutzergruppe","TXT_CODE_a48bdb09":"Anzahl der Blöcke, die der Wirkungsbereich für dieses Level erreicht","TXT_CODE_a492ae63":"Beginnen Sie mit dem Binden","TXT_CODE_a4efbd21":"Ermöglichen Sie die Deaktivierung von Spawnern durch Redstone","TXT_CODE_a519b5ff":"Spielerkollision aktivieren","TXT_CODE_a53573af":"Liste aktualisieren","TXT_CODE_a5830778":"Bitte geben Sie einen neuen Namen ein","TXT_CODE_a583cae4":"Ermöglichen Sie den normalen Benutzern, den Startbefehl zu bearbeiten","TXT_CODE_a584cb71":"Instanzbild angeben","TXT_CODE_a59981f4":"Leer lassen bis unendlich","TXT_CODE_a5bdf2d8":"Blockfallmultiplikator für Cyan-Bett","TXT_CODE_a5f01916":"Ermöglichen Sie allgemeinen Benutzern die Verwendung der Instanzvorlagenfunktion","TXT_CODE_a5f7d835":"Zombie","TXT_CODE_a621f370":"Sonntag","TXT_CODE_a62886b9":"Dateilesefehler","TXT_CODE_a6424dcc":"Das Arbeitsverzeichnis oder der Startbefehl darf nicht leer sein","TXT_CODE_a6453188":"Bitte wählen Sie den Dekomprimierungsmodus","TXT_CODE_a64da7c4":"Automatischer Neustart","TXT_CODE_a64f3007":"Entpacken","TXT_CODE_a65c65c2":"Daher müssen Sie die Verwendung anderer IP-Adressen als „localhost“ im lokalen Netzwerksegment vermeiden und für die Verbindung eine externe IP-Adresse oder Domäne verwenden.","TXT_CODE_a66ea585":"Maximaler Angriffsschaden","TXT_CODE_a674a475":"Die Anzahl der Dateninkonsistenzen, die erforderlich sind, bevor ungewöhnliches Verhalten gemeldet wird","TXT_CODE_a676f2da":"Habe es","TXT_CODE_a6878a01":"Begrenzen Sie die Anzahl aufeinanderfolgender Updates, bevor Sie andere Updates überspringen. \\nNegative Werte heben Einschränkungen auf.","TXT_CODE_a68b3a9c":"Maximaler Spawn -Speicher","TXT_CODE_a6a04fa3":"Ob Dorfbewohner generiert werden sollen","TXT_CODE_a6f5af58":"Dungeon-Samen","TXT_CODE_a6f8f61a":"Erlauben Sie die Anzeige benutzerdefinierter Köpfe.","TXT_CODE_a725a5b1":"Meldung, die anzeigt, wenn die tpsbar für einen Benutzer mit dem Befehl /tpsbar aktiviert wird.","TXT_CODE_a77b1a21":"Die maximal zulässige Zeitdifferenz zwischen Client-Geräten und dem Server beim Generieren und Überprüfen von TOTP-Codes.","TXT_CODE_a7813c72":"Auf „true“ setzen, damit der Enderdrache die Mob-Griefing-Gamerregel umgeht","TXT_CODE_a7885cbc":"Steuert die Präferenz des Containers für die Verwendung virtueller Speicherseiten von 0 bis 100. Höhere Werte machen den Kernel wahrscheinlicher, dass die Speicherseiten auf dem physischen Speicher ausgetauscht werden.","TXT_CODE_a788e3eb":"Speicher-/Prozessorauslastung","TXT_CODE_a7907771":"Erfolgreich gespeichert","TXT_CODE_a7aa53a3":"Legt den Server fest, der für Profile verwendet werden soll.","TXT_CODE_a7c73a51":"7zip erfolgreich geladen: {{info}}","TXT_CODE_a7c85e67":"Hyperlink hinzufügen","TXT_CODE_a7e1976":"Die Menge an Schaden, die nach dem Teleportieren mit einer Enderperle erlitten wird","TXT_CODE_a7e9d4e":"Schließe dieses Fenster","TXT_CODE_a7e9ff0f":"Punkt","TXT_CODE_a7f6b0e0":"Informationen zum Containerressourcenlimit","TXT_CODE_a85091a4":"Standardmäßige automatische Zuweisung","TXT_CODE_a8839b35":"Sobald das Rcon-Protokoll aktiviert ist, werden alle an der Konsole eingegebenen Befehle in RCON gesendet und sind nicht mehr mit dem ursprünglichen Konsolenprogramm kompatibel.","TXT_CODE_a884de59":"Hinweise beachten","TXT_CODE_a89ab67c":"Maximale Anzahl verbundener Spieler.","TXT_CODE_a8a375ae":"Steuert, ob überstapelte Gegenstände in Shulker-Boxen erlaubt sind (Standard behebt das Blockverbotsproblem PaperMC/Paper","TXT_CODE_a8b0dfab":"Führen Sie eine 2x1-Berechnung für diesen Wert durch, um den Schutzradius des Spawnpunkts zu bestimmen. Wenn Sie ihn auf 0 setzen, wird nur der Block unterhalb des Spawnpunkts geschützt. \\nAb Version 1.5 deaktiviert die Einstellung auf 0 oder einen negativen Wert den Build-Schutz.","TXT_CODE_a8b245fa":"Die Initialisierung einiger Module ist fehlgeschlagen. Bitte prüfen Sie, ob die Dateien unter daemon/lib vorhanden sind oder ob die Berechtigungen normal sind!","TXT_CODE_a8b402a9":"Aktivieren Sie die Debug-Protokollierung","TXT_CODE_a8f82885":"Ump-Höhenmodifikator. \\nDer Standardwert 1,0 lässt Riesen etwa bis zur Hüfte springen","TXT_CODE_a8fe5e68":"Attribut „Maximale Bewegungsgeschwindigkeit“.","TXT_CODE_a92a298e":"Wachstumsrate von Kakteen","TXT_CODE_a92a4aa1":"Universelle Konsolenanwendung","TXT_CODE_a92df201":"unbegrenzt","TXT_CODE_a94e89ef":"Ausgabe des Platzhalters <Sekunden> in der Option command.uptime.format","TXT_CODE_a95c0f85":"Geben Sie den Code ein, z. B.: 2WJBUHJUD0VV5SYMC0F3HFFH","TXT_CODE_a9bcbde9":"Das Feld muss numerisch sein","TXT_CODE_a9c9d05e":"Auf „false“ setzen, um zu verhindern, dass das Lagerfeuer angezündet wird, wenn es platziert wird","TXT_CODE_aa373641":"Bitte Knoten auswählen","TXT_CODE_aa43b248":"Betreten Sie die Konsole","TXT_CODE_aa47f5ed":"Legen Sie die Standard-Stufenhöhe von Rüstungsständern fest. \\nNützlich für Plugins, die Panzerständer als Fahrzeuge nutzen, um über Blöcke fahren zu können, ohne zu springen usw","TXT_CODE_aaba7ab8":"Lässt Mobs/Spieler auf Spielern reiten, wenn sich der Spieler im Wasser befindet","TXT_CODE_aac98b2a":"Instanzeinstellungen","TXT_CODE_aadfb5c0":"Ob Konsolen und Betreiber daran erinnert werden sollen, dass es eine neue Geyser-Version gibt, die die Bedrock-Version unterstützt, und dass diese Geyser-Version die Bedrock-Version nicht unterstützt","TXT_CODE_aae2918f":"Der Instanzprozess konnte nicht gestartet werden. Bitte überprüfen Sie den Startbefehl und die Konfiguration der Betriebsumgebung!","TXT_CODE_aae43e39":"Auf „true“ gesetzt, damit Plünderer die Mob Griefing-Gamerule umgehen können","TXT_CODE_aaecb7ff":"Liste der Geschwindigkeitsüberschreibungen pro Blocktyp","TXT_CODE_ab4504ca":"Kontrollieren Sie, ob Illusionisten auf natürliche Weise im Spiel erscheinen","TXT_CODE_ab483b69":"Lassen Sie den Boden durch das Wasser direkt darunter befeuchten","TXT_CODE_ab4cc2dc":"Software-Endbenutzervereinbarung, diese Vereinbarung muss auf „Zustimmen“ eingestellt sein, andernfalls kann die Serversoftware nicht aktiviert werden","TXT_CODE_ab4d93":"Zeigt Ping-Anfragen von Clients an.","TXT_CODE_ab5d758e":"Suche nach Kollisionsobjekten für Panzerständer","TXT_CODE_ab7672dd":"Mindestlänge des Passworts für neue Spielerkonten. \\ndarf nicht kleiner als 4 sein","TXT_CODE_ab839970":"Ist Velocity aktiviert?","TXT_CODE_ab90dc44":"Auf „true“ setzen, um Trampling vollständig zu deaktivieren.","TXT_CODE_ab9f8bfb":"Radiuskristalle suchen nach Phantomen, die angreifen können. \\nDer Wert 0 deaktiviert die Funktion","TXT_CODE_abac12f6":"Der Projektilversatz einer Enderperle","TXT_CODE_abadb770":"Die Schadensmenge, die feindlichen Mobs alle 2 Sekunden zugefügt wird, wenn sie mit Wasser/Regen in Berührung kommen","TXT_CODE_abc080d":"Keine Zeitbegrenzung","TXT_CODE_abd2f7e1":"Kartenlayout zurücksetzen","TXT_CODE_abe0862e":"Wird verwendet, um detaillierte Informationen und den Status entfernter Knoten anzuzeigen","TXT_CODE_abedfd03":"Abwählen","TXT_CODE_abfe9512":"Speichern","TXT_CODE_ac01315a":"Sind Sie sicher, dass Sie mit der Stapelentfernung fortfahren möchten? \\nBei diesem Vorgang werden nicht die eigentlichen Instanzdateien gelöscht, sondern nur die Instanz","TXT_CODE_ac0754f7":"Steuert, ob Bienen bei Regenwetter arbeiten können","TXT_CODE_ac10fe01":"Vorlagen-URL eingeben","TXT_CODE_ac225d07":"Parameter der Build-Paketinstanz:","TXT_CODE_ac405b50":"Fehler","TXT_CODE_ac52ad06":"Verpflichten Sie das ganze Jahr über ausschließlich Halloween-Veranstaltungen","TXT_CODE_ac696f4d":"Ob Plug-Ins standardmäßig in Abfrageantworten angezeigt werden sollen.","TXT_CODE_ac7a5f17":"Stellen Sie den Verstärker auf den Feuerwiderstandseffekt ein","TXT_CODE_acabc771":"Zweite","TXT_CODE_acd4abda":"Schnelle Bereitstellung mit Docker-Images","TXT_CODE_ad14bcf3":"Diese Konfigurationsdatei ist die Hauptkonfigurationsdatei des Bedrock Edition-Servers. In dieser Konfigurationsdatei werden die meisten Einstellungen des Bedrock Edition-Servers festgelegt, z. B. Server-Port, Anzahl der Personen, Sichtlinien- und Einschränkungsparameter usw.","TXT_CODE_ad1c674c":"Vereinbarung","TXT_CODE_ad207008":"Bearbeiten","TXT_CODE_ad24269a":"Bitte wählen Sie einen verfügbaren Knoten.","TXT_CODE_ad30f3c5":"Anzahl Starts: ","TXT_CODE_ad40abfb":"Artikelmetadaten mit visuellen Effekten ausblenden","TXT_CODE_ad5107bc":"Berechtigungsgruppeneinstellungen","TXT_CODE_ad533c70":"Das Passwort muss zwischen 9 und 36 Zeichen lang sein und Groß- und Kleinbuchstaben sowie Zahlen enthalten","TXT_CODE_ad5e2b0f":"Linkadresse","TXT_CODE_ad6c5d03":"Wie viele Zecken braucht man, um fliegende Monster aufzuwecken?","TXT_CODE_adab942e":"Ermöglichen Sie allgemeinen Benutzern die Nutzung von Dateiverwaltungsfunktionen","TXT_CODE_adcce2c7":"Warten Sie mit der Lobotomie, bis ein Dorfbewohner getauscht wurde","TXT_CODE_addfcb6b":"Ja","TXT_CODE_ae09d79d":"hochladen","TXT_CODE_ae0e0126":"Auf „false“ setzen, um zu verhindern, dass ungezähmte Zähmbare reitbar sind","TXT_CODE_ae441ea3":"Der zusätzliche Mountpfad des Instanzcontainers ist falsch konfiguriert! \\nÜberprüfen Sie bitte!","TXT_CODE_ae51f93b":"Erneuerungserfolg!","TXT_CODE_ae533703":"Dateiverwaltung","TXT_CODE_ae566b56":"Optimiert die Erstickungsprüfung durch selektives Überspringen der Prüfung, so dass sie immer noch wie Vanille aussieht. \\nDies sollte auf den meisten Servern aktiviert bleiben, wird aber als Konfigurationsoption bereitgestellt, wenn die Vanilla-Abweichung unerwünscht ist.","TXT_CODE_ae575e12":"Wenn Sie das Reverse-Proxy-Zugriffsfeld verwenden, aktivieren Sie diese Option. \\nDie echte IP erhält das Panel von der „X-Real-IP“ im Request-Header.","TXT_CODE_ae747cc0":"Ablaufzeit: ","TXT_CODE_aea11899":"Nur Spielerkollision","TXT_CODE_aeb10fea":"Verwenden Sie denselben Verbindungsport wie bei der Java Edition","TXT_CODE_af11ca2a":"Maximale Blockgenerierungsrate des Spielers","TXT_CODE_af143e18":"Uhr","TXT_CODE_af19b7b5":"Im Allgemeinen kann der Standardwert persönliche tägliche Nutzungsszenarien erfüllen. Wenn der Maßstab größer wird, sind die Anforderungen an die Hardware höher. Um die Benutzererfahrung nicht übermäßig zu beeinträchtigen, ist ein geeigneter Schwellenwert sehr wichtig.","TXT_CODE_af1f921d":"Wenn Sie es nicht ausfüllen, wird der ursprüngliche Wert nicht geändert. Nachdem das Passwort des Benutzers zurückgesetzt wurde, wird auch 2FA entsprechend zurückgesetzt.","TXT_CODE_af21e6b":"Panel-Version","TXT_CODE_af28bbfd":"Der Enderdrache bringt immer ein Drachenei hervor, wenn er stirbt.","TXT_CODE_af2a6972":"Klicken Sie auf die Schaltfläche „Ich habe den Scanvorgang abgeschlossen“.","TXT_CODE_afabf3ca":"Die Analysezeit ist fehlgeschlagen","TXT_CODE_afb12200":"Containerisierung","TXT_CODE_afb7259b":"Das Inhaltsformat, das in der TAB-Liste der mit dem Server verbundenen Player angezeigt wird","TXT_CODE_afc104e0":"Der Projektilversatz eines Dreizacks","TXT_CODE_afd43f2":"Detaillierte Ausgabe der Timings","TXT_CODE_afde4995":"Der lokale Schwierigkeitsgrad muss größer sein als ein zufälliger Wert zwischen 0,0 und diesem Wert","TXT_CODE_all_platform":"Alle Plattformen","TXT_CODE_app.addr":"Zugriffsadresse: http://<IP-Adresse>:{{port}}/ oder ws://<IP-Adresse>:{{port}}","TXT_CODE_app.configPathTip":"Konfigurationsdatei: data/Config/global.json","TXT_CODE_app.developInfo":"Dieses Projekt kann nicht gestartet werden und wird von MCSManager-Entwicklern verwendet.\\n\\nDie neuesten Installationsmethoden finden Sie unter https://mcsmanager.com/.\\n\\nWenn Sie im Entwicklungsmodus ausführen möchten, erstellen Sie bitte ein öffentliches Verzeichnis src/public, platzieren Sie die statischen Front-End-Dateien und führen Sie es erneut aus.","TXT_CODE_app.doc":"Referenzdokument: https://docs.mcsmanager.com/","TXT_CODE_app.exitTip":"Sie können das Programm mit der Tastenkombination Strg C schließen","TXT_CODE_app.host":"Zugriffsadresse: http://localhost:{{port}}","TXT_CODE_app.httpSetupError":"Beim Starten des HTTP/Socket-Dienstes ist ein Fehler aufgetreten. Der Verbindungsport ist möglicherweise belegt, die Berechtigungen sind unzureichend oder das Netzwerkkartengerät ist nicht verfügbar.","TXT_CODE_app.instanceLoad":"Alle App-Instanzen geladen, insgesamt {{n}}","TXT_CODE_app.instanceLoadError":"Lokale Instanzdatei konnte nicht gelesen werden:","TXT_CODE_app.panelStarted":"Die Panelseite wurde gestartet","TXT_CODE_app.password":"Zugriffsschlüssel: {{key}}","TXT_CODE_app.passwordTip":"Als einzige Authentifizierungsmethode verwenden Sie bitte die Knotenfunktion des MCSManager-Panels, um das Programm zu verbinden.","TXT_CODE_app.portTip":"Für den Zugriff auf das öffentliche Netzwerk der Software ist das Öffnen des Ports {{port}} und des Daemon-Verbindungsports erforderlich","TXT_CODE_app.reference":"Projektreferenz: https://github.com/mcsmanager","TXT_CODE_app.sessionConnect":"Sitzung {{ip}} {{uuid}} ist verbunden","TXT_CODE_app.sessionDisconnect":"Sitzung {{ip}} {{uuid}} wurde unterbrochen","TXT_CODE_app.started":"Der Daemon wurde nun erfolgreich gestartet","TXT_CODE_app.sysinfo":"Ressourcenbericht","TXT_CODE_app.welcome":"Willkommen beim MCSManager-Daemon","TXT_CODE_auth_router.access":"Sitzung {{id}}({{address}}) Identitätsüberprüfung erfolgreich","TXT_CODE_auth_router.disconnect":"Die Sitzung {{id}}({{address}}) wurde aufgrund einer langen Zeitspanne ohne Identitätsüberprüfung getrennt.","TXT_CODE_auth_router.illegalAccess":"Unautorisierter Zugriff","TXT_CODE_auth_router.notAccess":"Sitzung {{id}}({{address}}) hat versucht, unbefugt auf {{event}} zuzugreifen und ist jetzt blockiert.","TXT_CODE_b01f8383":"Lern mehr","TXT_CODE_b026be33":"Zwei-Faktor-Authentifizierung (TOTP) Zeitdrift-Toleranz","TXT_CODE_b029a155":"Die Instanz kann nach Ablauf nicht mehr gestartet werden","TXT_CODE_b02f295d":"Standardkonfigurationspfad für Server","TXT_CODE_b05948d1":"Berechtigungen wurden erfolgreich geändert","TXT_CODE_b05c6947":"Erlauben Sie Spinnen, Weltgrenzen zu überschreiten","TXT_CODE_b078a763":"Verfügbar","TXT_CODE_b0794aeb":"Der Basiswert, der für den Angriffsschaden des Phantoms festgelegt werden soll","TXT_CODE_b08f61c5":"Die Anzahl der Wassertiere, die in jeder Welt gelaicht werden können","TXT_CODE_b09eea4":"Monster","TXT_CODE_b09eff8f":"Erstellen Sie ein OpenJDK 8-Umgebungsimage","TXT_CODE_b0a18c20":"Ich habe den Scanvorgang abgeschlossen","TXT_CODE_b0aa2db9":"Geschlossen!","TXT_CODE_b0ad88c4":"Ob das PROXY-Protokoll beim Herstellen einer Verbindung zum Server aktiviert werden soll.","TXT_CODE_b0ae5b42":"Sollte der Name von AFK-Spielern in der Tab-Liste aktualisiert werden (setzt [AFK] vor ihren Namen)?","TXT_CODE_b0b67785":"Erzwingen Sie die Weltzeit auf Normalzeit, Tag oder Nacht","TXT_CODE_b0c4e4ae":"Geben Sie den CPU-Kern an","TXT_CODE_b0e39fd":"Auf „true“ setzen, damit der Widerrist die Fähigkeit erhält, Fahrzeuge zu fahren","TXT_CODE_b0f5847f":"Entitätsverfolgungsbereich anzeigen","TXT_CODE_b0ff4172":"Hochladen von {n} -Dateien im Hintergrund","TXT_CODE_b10cbef0":"Missbrauchsgrenze für Synthesetabellen","TXT_CODE_b11166e7":"Instanz wird neu gestartet","TXT_CODE_b12787d7":"Ob die Unterwelt (einschließlich der Hölle) zugelassen werden soll","TXT_CODE_b128afa6":"Bitte geben Sie einen neuen Kartentitel ein","TXT_CODE_b135e9bd":"Herunterladen ...","TXT_CODE_b1446a00":"Arbeitsverzeichnis im Container","TXT_CODE_b147fabc":"Erstellen","TXT_CODE_b152cd75":"Bitte wählen Sie zuerst die Datei aus","TXT_CODE_b1600db0":"Instanz wird aktualisiert","TXT_CODE_b16dc70c":"Verwelktes Skelett","TXT_CODE_b16fc7a6":"Gibt an, ob Spieler einen Netzwerk-Proxy verwenden dürfen, um auf den Server zuzugreifen","TXT_CODE_b18c34fd":"Prozentuale Chance (0,0 – 1,0), dass dieser Mob Verstärkung hervorbringt","TXT_CODE_b197be11":"Daten werden geladen...","TXT_CODE_b19ed1dd":"Zurücksetzen","TXT_CODE_b1b30b86":"Macht den Namen beim Platzieren mit einem benutzerdefinierten Namen sichtbar","TXT_CODE_b1d19033":"Ändern Sie, um die Lebensmitteleigenschaften zu ändern.","TXT_CODE_b1d709bc":"Ob die IP-Adressen angezeigt werden sollen, die BungeeCord abhört","TXT_CODE_b1dedda3":"Stoppen","TXT_CODE_b1e2e1b4":"Konsolenausgabe löschen","TXT_CODE_b1ef1d4a":"Archivdaten beschädigt","TXT_CODE_b1f833f3":"Download-Quellenliste bei schneller Installation des Servers Sie können die Standard-Download-Site des Servers anpassen, indem Sie diese Adresse ändern.","TXT_CODE_b1fd3eb1":"Einstellungen für die Portweiterleitung","TXT_CODE_b214a52d":"Ob Spieler sich gegenseitig angreifen dürfen","TXT_CODE_b2391fca":"Sekundäre Kategorie auswählen","TXT_CODE_b23cc3e":"Optional, geben Sie den Standardwert nicht ein: /workspace/","TXT_CODE_b23e2bab":"Platzhalterkarte","TXT_CODE_b251fa6d":"ID des Anzeigenamens des Elements","TXT_CODE_b26a0528":"Zugehöriger Knoten","TXT_CODE_b2767aa2":"Standard-Vorlagenkonfiguration","TXT_CODE_b278707d":"Wenn Sie beim Dekomprimieren/Komprimieren der Datei feststellen, dass der Dateiname verstümmelt ist, können Sie diese Option ändern, um das Problem zu lösen.","TXT_CODE_b290a4b0":"Name der Projektaufgabe","TXT_CODE_b2dbf778":"Wenn Sie über eine Drittanbieteranwendung auf das Panel zugreifen müssen, müssen Sie diesen Schlüssel zur Identitätsüberprüfung verwenden. Jede Anfrage, die diesen Schlüssel verwendet, verfügt über dieselben Berechtigungen wie dieses Konto.","TXT_CODE_b2e9a60":"Auf „true“ setzen, damit Schwämme Lava absorbieren können","TXT_CODE_b2f1310e":"Eine Konfigurationsoption hauptsächlich für Entwickler. \\nMelden Sie sich modifizierte Tags an, die den Namespace \\"Forge\\" beim Ausführen auf integriertem Server verwenden. \\nStandardeinstellungen zu dev_short. \\nZulässige Werte: Schweigen, dev_short, dev_verbose, prod_short, prod_verbose","TXT_CODE_b30daa03":"Erlaube CrimsonCreep, wenn sich die Welt im Hard-Modus befindet","TXT_CODE_b3127cba":"Chatfarbe für Super-Administratorgruppe","TXT_CODE_b3190a77":"Ob nicht aktivierte Dorfbewohner angekreuzt werden sollen","TXT_CODE_b329418":"Die Menge an Eisenbarren, die zur Reparatur eines Ambosses benötigt wird","TXT_CODE_b32f926d":"Korrektur der Baby-Zombie-Bewegung","TXT_CODE_b340c04a":"bitte haben Sie Geduld","TXT_CODE_b34efc1":"Das Container-Manifest stellt alle Anwendungsinstanzen dar, die in einer unabhängigen Image-Umgebung ausgeführt werden. Das Manifest umfasst hier nicht nur vom Panel gestartete Container.","TXT_CODE_b34f9eee":"maximale Gesundheit","TXT_CODE_b355c681":"Kick-Nachricht überschreitet die Paketverarbeitungsrate","TXT_CODE_b3581555":"Die Anzahl der angetriebenen Schienen, die von einer einzelnen Redstone-Quelle aktiviert werden","TXT_CODE_b36320e1":"Auf „true“ setzen, um in Spieler-Todesmeldungen immer den Gegenstand anzuzeigen, der zum Töten des Spielers verwendet wurde.","TXT_CODE_b36630b3":"Blockfallmultiplikator für blaues Bett","TXT_CODE_b3796a8":"Ausgabe des Platzhalters <second> in der Option command.uptime.format","TXT_CODE_b37e6938":"Fügen Sie optional eine benutzerdefinierte Nachricht hinzu, die im Eingabeaufforderungsfenster des Ressourcenpakets angezeigt wird, wenn Sie require-resource-pack verwenden.","TXT_CODE_b3825da":"Wird bearbeitet..","TXT_CODE_b3844cf8":"Erstellen Sie eine Instanz direkt, ohne Dateien hochzuladen. \\nKonfigurieren Sie es später. \\nDies ist für erfahrene Benutzer geeignet.","TXT_CODE_b3cc1379":"Bitte geben Sie den Erneuerungscode ein","TXT_CODE_b3e2f83e":"Diese Karte hat keinen Inhalt und kann verwendet werden, um Platz zu belegen, um Anforderungen an ein zentriertes Layout zu erfüllen.","TXT_CODE_b3ea8245":"Maximale Anzahl von Entitätskollisionen","TXT_CODE_b3f2ea10":"Geben Sie die Musik-URL ein","TXT_CODE_b45e73fb":"Die Anzahl der Sekunden, die der Spieler warten muss, bevor er wieder erscheint, wenn sich ein Boss in der Nähe befindet. \\nGültiger Bereich: 0 (Standard) bis 30 Sekunden. \\nBenutzung auf eigene Gefahr","TXT_CODE_b47dbe7d":"Steuert, wie viele Brocken ein Projektil in seiner Lebensdauer laden kann, bevor es automatisch entfernt wird.","TXT_CODE_b488372f":"Alle","TXT_CODE_b4a9d04a":"Anzahl der Knoten online","TXT_CODE_b4d8588":"Systemversion","TXT_CODE_b5022f5d":"Drosselt die KI-Zielauswahl bei inaktiven Entitäts-Ticks.","TXT_CODE_b50ffba8":"Die Instanz wurde begonnen ...","TXT_CODE_b51bac6f":"Um eine Instanz mithilfe eines Docker-Images einzurichten, müssen Sie sicherstellen, dass Docker korrekt installiert ist!","TXT_CODE_b5253fae":"Lassen Sie zu, dass heruntergefallene Gegenstände Schildkröteneier beschädigen/zerbrechen","TXT_CODE_b52cb76c":"Bitte wählen Sie den Netzwerkmodus aus","TXT_CODE_b5a0661a":"Titel","TXT_CODE_b5a3a6ca":"Echte Bestätigung","TXT_CODE_b5a47731":"Der Administrator hat allgemeinen Benutzern die Nutzung der Instanz-Neuinstallationsfunktion untersagt.","TXT_CODE_b5afc7e":"Die maximale Anzahl von Spielern, die der Player-Client anzeigt. Der Standardwert ist 1. \\nDieser Gegenstand dient nur der Dekoration und hat keine tatsächliche maximale Spielerzahl.","TXT_CODE_b5b33dd4":"Textanzeige der Anmeldeseite","TXT_CODE_b5c7b82d":"Einstellungen","TXT_CODE_b5ca0563":"Wir führen Sie durch die Verwendung und Bereitstellung Ihrer Anwendung.","TXT_CODE_b5ce1069":"Blockieren Sie die Verbindung von Nicht-Softcore-Spielern","TXT_CODE_b5e19c1":"Auf „true“ setzen, damit Kaninchen die Mob-Griefing-Gamerule umgehen","TXT_CODE_b625dbf0":"Hochladen:","TXT_CODE_b642de88":"Maximales Spielerlimit des Servers","TXT_CODE_b649a71a":"Das ganze Jahr über ausschließlich Weihnachtsveranstaltungen vorschreiben","TXT_CODE_b6697d36":"Wenn der Player-Client die Gesamtmenge an Datenpaketen sendet, wird er rausgeschmissen. 0 bedeutet geschlossen.","TXT_CODE_b67197fc":"Alle Nutzer","TXT_CODE_b69550bf":"alter Benutzer","TXT_CODE_b6ac7af4":"Benutzer <<operator_name>> geändert die Konfiguration des Daemon -Prozesses <<daemon_id>>","TXT_CODE_b6ba38a4":"Auf „true“ setzen, damit Notenblöcke weiterhin Töne erzeugen, auch wenn sich darüber ein Block befindet","TXT_CODE_b6c675d6":"Abonnementinformationen anzeigen","TXT_CODE_b6d926ab":"Ermöglicht, dass das Totem der Unsterblichkeit überall in Ihrem Inventar funktioniert, nicht nur in Ihrer Nebenhand","TXT_CODE_b6eb8851":"Greifen Zombies Schildkröteneier an?","TXT_CODE_b729d2e":"Container-Anschlussport","TXT_CODE_b72d638d":"Erforderlich und muss eindeutig sein","TXT_CODE_b75e6388":"Das Format, das der <uptime>-Platzhalter für die uptime-command-output verwendet","TXT_CODE_b76d94e0":"Aktualisieren","TXT_CODE_b7c8eb9f":"Gründe, warum Hardcore-Spielern das Sterben verboten ist","TXT_CODE_b7cab91d":"Befehl senden","TXT_CODE_b7d026f8":"Geplante Aufgaben","TXT_CODE_b7d38e78":"Der Remote-Knoten kann nicht verwendet werden! \\nBitte wenden Sie sich an den Administrator, um den Status des Remote-Knotens in der Knotenliste zu überprüfen!","TXT_CODE_b7f19227":"Ändern Sie den Bereich, in dem der Blitzableiter Blitze umleitet","TXT_CODE_b8108d4d":"Geben Sie hier den Befehl ein und drücken Sie zum Senden die Eingabetaste.","TXT_CODE_b815f6f6":"Reptilienrückstandseffekte deaktivieren","TXT_CODE_b82225c3":"Dateien werden dekomprimiert, bitte warten...","TXT_CODE_b858d78a":"Erfolgreich kopiert","TXT_CODE_b862a158":"CPU -Verwendung","TXT_CODE_b8814f15":"Möglicherweise verfügt das Panel nicht über die Berechtigung, auf diese Datei zuzugreifen. Sie können versuchen, diese Datei mit der „Dateiverwaltung“ zu bearbeiten.","TXT_CODE_b89285d3":"Dadurch wird der Servername geändert, der angezeigt wird, wenn ein Client veraltet ist oder wenn jemand den Debug-Bildschirm öffnet [F3]","TXT_CODE_b89780e2":"Die Version der Konfigurationsdatei ist falsch und das Hintergrundbild kann nicht eingestellt werden. Bitte versuchen Sie, das Panel neu zu starten oder das benutzerdefinierte Layout zurückzusetzen!","TXT_CODE_b8c40ce0":"Kontrollieren Sie den TPS-Aufholprozess","TXT_CODE_b90e9abd":"Der Code wird sofort wirksam und an den passenden Benutzernamen gebunden","TXT_CODE_b916a8dc":"Umgebungsvariablen","TXT_CODE_b91a94f9":"Wagenrücklaufsymbol für die Befehlsausführung","TXT_CODE_b9442311":"Zusätzliche Parameter","TXT_CODE_b946a322":"Zusätzlicher virtueller Speicher, der über den maximalen Speicher zugewiesen wird. \\nDie Verwendung dieses Speichers ist weniger effizient. \\nLassen Sie für die automatische Zuweisung leer.","TXT_CODE_b94f13ce":"Unter der Windows-Plattform ist es normalerweise „Wagenrücklauf und Zeilenvorschub“, und unter der Linux/MacOS-Plattform ist es normalerweise „Zeilenvorschub“.","TXT_CODE_b99cae18":"Produkte","TXT_CODE_b9af1460":"Mindestanzahl an Intervall-Ticks, die geschossen werden","TXT_CODE_b9ca022b":"Instanzdateien werden installiert, bitte warten Sie geduldig ...","TXT_CODE_b9d7fe43":"Erfordern Sie eine Token-Validierung, wenn Sie öffentliche REST-API-Endpunkte verwenden","TXT_CODE_b9fc604c":"Limit pro HTTP -Anforderung, Maximale Datei -Download -Geschwindigkeit","TXT_CODE_ba027d6c":"Dateien werden komprimiert, bitte warten Sie geduldig...","TXT_CODE_ba09da46":"Der Versuch, den untergeordneten Prozess als Linux -Benutzer zu starten {{Name}} ...","TXT_CODE_ba1a222b":"Ermöglicht Spielern, Eis dort zu platzieren, wo sie nicht bauen können","TXT_CODE_ba1eb3b5":"Docker ist eine leichte Virtualisierungssoftware, die ein Umgebungsimage verwendet, um einen Container (wie eine Box) zu erstellen, der Ihre eigentliche Anwendung umschließt, sodass Ihre Anwendung unabhängig davon, was die Anwendung tut, in einer virtuellen Sandbox-Umgebung ausgeführt werden kann alle Dateien auf dem Host-Computer.","TXT_CODE_ba42d467":"Web-URL","TXT_CODE_ba497a8b":"Intervallaufgaben","TXT_CODE_ba4f41ba":"Ob die ausführliche Ausgabe aktiviert werden soll","TXT_CODE_ba717ff3":"Sie können das Layout, die Reihenfolge und die Darstellung der meisten Elemente auf der Webseite frei gestalten.","TXT_CODE_ba82dddb":"Die Image-Erstellung und der Containerbetrieb basieren auf der Docker-Software, und alle Remote-Knoten auf dem physischen Host teilen alle Images.","TXT_CODE_ba86f4a":"MC BungeeCord","TXT_CODE_ba8ebc7":"Darf nicht leer sein, schreiben Sie bitte 0, um alle 0 Stunden darzustellen","TXT_CODE_baa16e45":"Breite erweitern","TXT_CODE_bac2d713":"Ob der Debugging-Modus aktiviert werden soll","TXT_CODE_bae487e4":"Erstellen Sie mit Docker -Bild","TXT_CODE_baseport_title":"Basis-Hafen","TXT_CODE_bb0b9711":"Update- oder Installationsanweisungen","TXT_CODE_bb35dc39":"Auf „true“ setzen, damit Kakteen mit Knochenmehl zerkleinert werden können","TXT_CODE_bb729416":"Die Verzögerung, mit der ein Spieler Erfahrung sammeln kann, nachdem sie fallen gelassen wurde","TXT_CODE_bb888626":"Ausgabe","TXT_CODE_bb9657ff":"Selektoren in Büchern analysieren","TXT_CODE_bb98d45":"Aktivieren Sie die Fertigstellung des Brigadier-Befehls","TXT_CODE_bbbda29":"Der Startbefehl darf keine Zeilenumbrüche enthalten. Dies ist keine Skriptdatei und es können nicht mehrere Befehle ausgeführt werden.","TXT_CODE_bbd7d448":"Detaillierte Informationen wie Docker-Images und Container sollten von technischem Personal gelesen werden. Der vollständige Informationsinhalt im JSON-Format wird hier bereitgestellt.","TXT_CODE_bbe23ee7":"Node-Direktverbindungsadresszuordnungen","TXT_CODE_bbedcf29":"Der aktuelle Status der Instanz erlaubt nicht das Ändern von Dateien. \\nBitte versuchen Sie es später noch einmal!","TXT_CODE_bc2e52a0":"Wenn dies aktiviert ist, können alle Benutzer die Funktion \\"Neuinstallation\\" in der oberen rechten Ecke des Terminals ohne Administratorrechte verwenden.","TXT_CODE_bc3e529c":"Ermöglicht permanenten Block-Breaking-Exploit","TXT_CODE_bc46c15b":"Beginnen Sie mit dem Entwerfen","TXT_CODE_bc560b9":"Erneuerung bestätigen","TXT_CODE_bc883bbb":"Kehren Sie zur manuellen Installation zurück","TXT_CODE_bca67837":"Der Unterschied zwischen den Server- und Clientwerten, bevor abnormales Verhalten erkannt wird","TXT_CODE_bcfaf14d":"Leider kann die neueste Standard-Modpack-Liste nicht abgerufen werden. Möglicherweise liegt ein Problem mit Ihrem Netzwerk vor oder der Server wird gewartet.","TXT_CODE_bd0aa3c7":"Auf „true“ setzen, damit die Anzeigenamen und Überlieferungen der Entität nach dem Zerstören bestehen bleiben (z. B. benannte Rüstungsständer behalten ihren Namen).","TXT_CODE_bd1ff011":"Frühe Fensterbreite","TXT_CODE_bd2534da":"Dieser Wert bestimmt, wie weit eine Entität vom Spieler entfernt sein muss, um von DEAR beeinflusst zu werden.","TXT_CODE_bd2559f3":"Kodierung der Konsoleneingabe","TXT_CODE_bd7152f7":"Ob das Ende geöffnet werden soll","TXT_CODE_bd84e700":"Auf „true“ setzen, damit Mobs über Schienen laufen können","TXT_CODE_bd99b64e":"Zeitüberschreitung der Anforderung! \\nBitte wenden Sie sich an den Administrator, um den Netzwerkstatus des Knotens und die Knoten-IP zu überprüfen:","TXT_CODE_bdb620b9":"Läuft","TXT_CODE_bdd4fe65":"Benötigen Sie ein Ressourcenpaket?","TXT_CODE_bddc37e2":"Dateianalyse fehlgeschlagen, gültige JSON-Datei erforderlich","TXT_CODE_bdfa3457":"Das RCON-Protokoll kann im Betriebszustand nicht aktiviert oder deaktiviert werden.","TXT_CODE_be1351ce":"Wie bekomme ich den Schlüssel?","TXT_CODE_be1354f5":"Bewegen Sie Ihre Maus im Designmodus hierher, um sie zu bearbeiten","TXT_CODE_be1f9806":"Trichterprüfskala","TXT_CODE_be236019":"Wachstumsrate der Kakaobohnen","TXT_CODE_be26bb3c":"Portalsamen","TXT_CODE_be608c82":"Verschiedene Typen weisen geringfügige Unterschiede in bestimmten Funktionen auf","TXT_CODE_be6484f7":"Bitte wählen Sie ein Instanzbild aus","TXT_CODE_be769e64":"Ermöglicht Ihnen, die Anzahl der Ticks zu ändern, die erforderlich sind, damit der Tod eines Mobs als Spielertötung zählt, nachdem er vom Spieler verletzt wurde (Projektil oder direkt).","TXT_CODE_be7a689a":"Muss vom Server erreichbar sein, der dieses Panel bereitstellt. Bei nicht-öffentlichen IPs/Domains oder \'localhost\' mit Reverse Proxy müssen Sie Node-Direktverbindungszuordnungen konfigurieren.","TXT_CODE_bea356aa":"Erlauben Sie Verbindungen von ProxyPass und Waterdog.","TXT_CODE_bea85b64":"Anzahl der Ticks, die der Spieler nach dem Verzehr einer Glühbeere zum Leuchten bringt. \\nZum Deaktivieren auf 0 setzen","TXT_CODE_beacbdc":"Die Geschwindigkeit, mit der sich ein Kessel mit Pulverschnee füllt (abhängig von der Zufallsgeschwindigkeit)","TXT_CODE_bec3d0ea":"Ob die Welt gerettet werden soll, wenn der Server aufgrund einer nicht behandelten Ausnahme abstürzt","TXT_CODE_bec552ee":"Ausgabe des Platzhalters <hours> in der Option command.uptime.format","TXT_CODE_bed32084":"Der Remote-Knoten ist offline. Bitte wenden Sie sich an den Administrator, um den Online-Status des Panels zu überprüfen!","TXT_CODE_bf6bec1a":"Auf „false“ setzen, um zu verhindern, dass sich Rüstungsständer im Wasser über einen Zaun bewegen","TXT_CODE_bf8ae6c8":"Diese Konfigurationsdatei ist die EULA (Endbenutzer-Lizenzvereinbarung) des Minecraft-Servers. Sie müssen dieser Vereinbarung zustimmen, um die Serversoftware normal auszuführen. Wenn Sie feststellen, dass diese Einstellung nicht „Ja“ ist, ändern Sie sie bitte sofort.","TXT_CODE_bfb50126":"Übersicht über den Knotenstatus","TXT_CODE_bfbdf579":"Mit dieser Funktion können normale Benutzer die Befehle \\"Start\\" und \\"Aktualisieren\\" von Docker -Instanzen bearbeiten","TXT_CODE_bff43de3":"Name","TXT_CODE_c03297d4":"Abhörende IP-Adresse und Verbindungsport","TXT_CODE_c0401ba7":"Fehlende Volumendatei: {{file}}","TXT_CODE_c059faee":"Korrektur der Vervollständigung der Zielauswahlbeschriftung","TXT_CODE_c0606ef4":"Sind Sie sicher, dass Sie das Hintergrundbild festlegen möchten?","TXT_CODE_c093bec9":"Diese Operation ist in Abklingzeit. \\nSie können über {{Sekunden}} Sekunden fortfahren!","TXT_CODE_c0a49b60":"Schwelle für falsche Bewegungen","TXT_CODE_c0be39df":"Anderer Entitätsstartbereich","TXT_CODE_c0ce588":"Kürbiswachstumsgeschwindigkeit","TXT_CODE_c0fcee47":"Auf „false“ setzen, um den Handel mit wandernden Händlern zu deaktivieren","TXT_CODE_c10ea805":"Schneller Beginn mit Vorlagen","TXT_CODE_c117a10c":"Deaktivieren Sie den Creeper-Persistenzeffekt","TXT_CODE_c11ac499":"Titelbild-URL eingeben","TXT_CODE_c1320e08":"Sie können alle von Ihnen hochgeladenen Dateien über „Layout zurücksetzen“ löschen.","TXT_CODE_c132a726":"Mobs, die Beute einsammeln können, werden auch dann weiterhin Beute einsammeln, wenn die MobGriefing-Gamerregel deaktiviert ist","TXT_CODE_c135338":"Aufforderung zum Tritt des fliegenden Fahrzeugs","TXT_CODE_c14b2ea3":"Zurückgehen","TXT_CODE_c14caab":"Keine zusätzlichen Dateien erforderlich","TXT_CODE_c1507dd6":"Warnverzögerung","TXT_CODE_c15dcfec":"Auf „true“ setzen, damit der Schleifstein die Attribute von einem Element entfernen kann","TXT_CODE_c174fbb4":"Ermöglicht Spieleransammlungsschaden","TXT_CODE_c17f6488":"ZIP-Datei auswählen","TXT_CODE_c1c548fb":"Die folgenden Ports wurden für die Instanz geöffnet:","TXT_CODE_c20e5d16":"Meldung, die angezeigt wird, wenn der Credits-Bildschirm für einen Benutzer mit dem Befehl /credits aktiviert wird.","TXT_CODE_c237192c":"Bitte geben Sie einen Namen für die neue Instanz ein","TXT_CODE_c24c2569":"Die Anzahl der Sekunden, die gewartet werden muss, bevor ein Benutzer Geyser den Zugriff auf sein Microsoft-Konto autorisiert.","TXT_CODE_c24fdee3":"Datei-Kodierung auswählen","TXT_CODE_c2697552":"Spur ändern","TXT_CODE_c26e5fb7":"Unterstützt das Markdown-Format","TXT_CODE_c2a8378b":"Name der Welt (Karte).","TXT_CODE_c2cef2d":"Startbereich des Angreifers","TXT_CODE_c3022e22":"Diese Konfigurationsdatei ist eine allgemeine Konfigurationsdatei für Server vom Typ Bukkit oder andere abgeleitete Servertypen. Sie enthält die meisten Servereinstellungen, wie z. B. Server-Port, maximale Personenanzahl, Sichtweite des Spielers und Echtheitsüberprüfung.","TXT_CODE_c30a5f37":"Die Höhe, die dieser Mob beim Reiten springen kann (in Blöcken)","TXT_CODE_c32bc4b3":"Sichtweite","TXT_CODE_c32eb04a":"Ändern Sie dies auf keinen Fall! \\nPurpur verwendet dies intern, um Ihre Konfiguration automatisch zu aktualisieren.","TXT_CODE_c38813a8":"Benutzername","TXT_CODE_c3a3b6b1":"Containername","TXT_CODE_c3a933d3":"Mission erfüllt!","TXT_CODE_c3adc044":"Upload -Aufgabe existiert nicht","TXT_CODE_c3c06801":"Stapellöschung erfolgreich","TXT_CODE_c3ec4dc8":"Kampfhunger-Bar erschöpft","TXT_CODE_c42a1b9b":"Verwendet einen anderen Ansatz für Keepalive-Ping-Timeouts. \\nWenn Sie dies aktivieren, wird einmal pro Sekunde ein Keepalive-Paket an einen Spieler gesendet und nur dann für eine Zeitüberschreitung gekickt, wenn innerhalb von 30 Sekunden auf keines dieser Pakete geantwortet wurde. \\nWenn Sie auf eine dieser Fragen in beliebiger Reihenfolge antworten, bleibt der Spieler verbunden. \\nAKA, es wird Ihre Spieler nicht rausschmeißen, weil ein Paket irgendwo entlang der Linie verloren geht","TXT_CODE_c4430fa6":"Verhindern Sie, dass sich Benutzer anmelden, bevor die Verbindung hergestellt wurde","TXT_CODE_c4435af9":"Konfiguration der Portzuordnung der Containerverbindung","TXT_CODE_c48f6f64":"alle","TXT_CODE_c4dfdb26":"Traditionelles Chinesisch (BIG5)","TXT_CODE_c4f90da6":"Geben Sie Zeitaufgaben an","TXT_CODE_c51b86ff":"Stellt dem Shulker eine zufällige Farbe ein, wenn er aus einer Kugel hervorgeht","TXT_CODE_c52c93f7":"Wenn nicht aktiviert (Standard ist „true“), wird die IP-Adresse des Spielers in den Protokollen durch <IP-Adresse zurückgehalten> ersetzt.","TXT_CODE_c534ca49":"Wird gewartet","TXT_CODE_c535fb8":"Auf „true“ setzen, wenn dieser Mob immer Erfahrung verlieren soll","TXT_CODE_c536b7c7":"Ob die Flammen eines Phantoms Gegenstände verbrennen können","TXT_CODE_c53c342e":"Setzen Sie dies auf True, um eine Entität zu entfernen (Hinweis: Enthält keine Blockentitäten), die einen Fehler in seine Tick -Methode auswirft, anstatt den Server zu schließen und ein Crashprotokoll zu melden. \\nSeien Sie gewarnt, dies könnte alles vermasseln, was wir sparsam verwendet haben. Wir sind nicht für Schäden verantwortlich.","TXT_CODE_c565b2e0":"Unterstützt das Hochladen von HTML-Dateien. Diese Karte lädt HTML und führt Javascript-Code aus.","TXT_CODE_c5687e56":"Benutzer <<operator_name>> Aktualisierte die Datei <<file>> der <<instance_name>> Instanz","TXT_CODE_c59f077d":"Auf „false“ setzen, um das Festlegen eines negativen ExplosionRadius-Werts für Explosionen zu ermöglichen","TXT_CODE_c5a46eba":"Modifizierte Datei herunterladen","TXT_CODE_c5ace40b":"Spieltyp","TXT_CODE_c5b38d90":"Die Instanzspezifikationen für die Erneuerung stimmen nicht überein und der Erneuerungsvorgang kann nicht abgeschlossen werden!","TXT_CODE_c5c56801":"Anmeldezeit","TXT_CODE_c5ed896f":"Der Inhalt der Sofortausgabe ist zu lang und die Anzeige wurde verweigert ...","TXT_CODE_c62a8fa1":"Texturpaket","TXT_CODE_c62e2f11":"Konfigurieren Sie hier Ihren Server. \\nJeder Schlüssel stellt den Namen des Servers dar und der Wert stellt die IP-Adresse des Servers dar, zu dem eine Verbindung hergestellt werden soll.","TXT_CODE_c671927e":"Erzwingen Sie, dass der Client das Serverressourcenpaket lädt","TXT_CODE_c684d8b2":"Benutzername existiert, ist das Ihr Konto?","TXT_CODE_c68b0bef":"Bild-Download abgeschlossen!","TXT_CODE_c698246c":"Untote sind gegen bestimmte Effekte immun","TXT_CODE_c6d3bd8":"MC Kugelfisch","TXT_CODE_c6ecc182":"Notieren Sie Todesereignisse benannter Entitäten im Protokoll","TXT_CODE_c709edac":"Auf „true“ setzen, damit Zombies die Mob-Griefing-Gamerule umgehen können","TXT_CODE_c7362d3d":"Ob versucht werden soll, die Komprimierung für Bedrock Edition-Player zu deaktivieren.","TXT_CODE_c73de59d":"Dienstag","TXT_CODE_c745cf56":"Debug-Modus","TXT_CODE_c7952636":"Artikel, um Eisbären anzulocken/zu füttern und sie zur Fortpflanzung zu bewegen","TXT_CODE_c7a43089":"Die Instanz ruft das Bild zur Laufzeit ab und erstellt daraus einen Container. Dieser Bildname muss in der Cloud oder lokal vorhanden sein","TXT_CODE_c7b1b8d0":"Programme, die gestartet werden müssen","TXT_CODE_c7d0002e":"IP Adresse","TXT_CODE_c7d340bc":"Verhindern Sie das Bewegen zu entladenen Brocken","TXT_CODE_c800cb31":"Geben Sie den Containerverzeichnispfad ein. \\nAlle Dateien im Dateimanager werden hier gemountet","TXT_CODE_c8261c85":"Minecraft Bedrock Edition-Spieleserver","TXT_CODE_c82a51b0":"Kann ein Domänenname oder eine IP-Adresse sein, z. B. mcsmanager.com, 43.123.211.12","TXT_CODE_c8333afa":"unbekannter Status","TXT_CODE_c83551f5":"Umbenennen","TXT_CODE_c840ab37":"Whitelist der Blöcke, die vom Verwüster zerstört werden können","TXT_CODE_c846074d":"Bitte vervollständigen Sie Ihre Kontoinformationen!","TXT_CODE_c848a459":"Laichbereich der Kreatur","TXT_CODE_c855fc29":"Benutzer erfolgreich hinzugefügt","TXT_CODE_c8572f16":"Iglu-Samen","TXT_CODE_c871d8c8":"Legt den maximalen Abstand zwischen einer biologischen Entität und dem Player für Serveraktualisierungen in Blöcken (Radius) in jede Richtung des Players fest. \\nBefinden sich Entitäten außerhalb dieses Radius, werden sie nicht vom Server gesendet und sind für den Spieler nicht sichtbar.","TXT_CODE_c8a51b2e":"Bitte geben Sie die Bildadresse ein","TXT_CODE_c8c91afc":"Deaktivieren Sie das Platzieren und Verschieben von Kacheln","TXT_CODE_c8cdeeee":"Die Änderung der Konfigurationsdateiversion kann zu unvorhersehbaren Problemen führen. \\nEs wird empfohlen, dieses Projekt nicht zu ändern.","TXT_CODE_c91c29cd":"Brandschaden, wenn ein Phantom brennt","TXT_CODE_c92156bb":"Es gibt ein Problem mit dem vom Dienstanbieter festgelegten Plan. \\nBitte kontaktieren Sie den Anbieter, um den Plan neu zu konfigurieren!","TXT_CODE_c93f32f8":"Erforderlich, unterstützt Domänennamen und IP-Adresse. Wenn sie nicht ausgefüllt sind, werden Serverinformationen, Anzahl der Personen, Version usw. nicht abgefragt.","TXT_CODE_c9609785":"Zustand","TXT_CODE_c97dd046":"Wenn diese Option aktiviert ist, sollten Endertruhen über sechs Reihen Inventarplatz verfügen","TXT_CODE_c9b31f8e":"Donnerstag","TXT_CODE_c9c27711":"Ob Kristallkugelsplitter bei der Berechnung der Projektilschwelle ignoriert werden sollen","TXT_CODE_c9ce7427":"Sie können Spiele über das Dropdown -Menü filtern, eine Vorlage auswählen und mit der Installation fortfahren. \\nStellen Sie sicher, dass das System über die erforderliche Laufzeitumgebung für das Spiel verfügt.","TXT_CODE_c9d34339":"Auf „false“ setzen, damit Boote den Spielern keinen Fallschaden zufügen","TXT_CODE_c9e4d5c1":"Verhindern Sie, dass Dungeonwächter erscheinen, wenn Sie Spieler zu ihrem Spawnpunkt schicken","TXT_CODE_c9f303dd":"Min. Gesundheitsattribut","TXT_CODE_ca030197":"Die Instanz hat andere Aufgaben in Bearbeitung und dieser Vorgang kann nicht ausgeführt werden!","TXT_CODE_ca06ec2a":"Die Entität wählt das Ziel basierend auf dem folgenden Bereich aus","TXT_CODE_ca07c84c":"Ihr aktueller Browser unterstützt kein automatisches Kopieren","TXT_CODE_ca500df8":"Diese Konfigurationsdatei ist eine allgemeine Konfigurationsdatei für Server der Papierkategorie oder anderer abgeleiteter Kategorien. Sie erweitert die Mängel der Spigot-Konfigurationsdatei.","TXT_CODE_ca8072bd":"Die Initialisierung ist fehlgeschlagen, der Remote-Knoten existiert nicht!","TXT_CODE_caaac421":"Aus Zwischenablage importieren","TXT_CODE_cacd8840":"7zip-Entpackfehler: {{message}}","TXT_CODE_cad62df3":"Speichern Sie den Benutzercache nur, wenn der Server ausgefallen ist","TXT_CODE_cae10a08":"Die Aufgabe zum Löschen von Dateien wird gestartet. Wenn zu viele Dateien vorhanden sind, dauert es einige Zeit.","TXT_CODE_caf10268":"Ob der Server beim Abfragen der integrierten MCSM-Konsole eine Liste von Plug-Ins zurückgibt","TXT_CODE_caf8ebb7":"Kartenschlüsselverkäufe","TXT_CODE_cafe41ab":"Zulässige Leerlaufzeit in Minuten. Automatisches Abschalten des Servers nach Überschreiten des Limits.","TXT_CODE_cb043d10":"Beispiel","TXT_CODE_cb08d342":"Das Feld darf nicht leer sein","TXT_CODE_cb1fef78":"Alle Spieler müssen sich vor dem Spielen registrieren oder anmelden","TXT_CODE_cb36c80e":"Liste der Remote-Host-Container","TXT_CODE_cb61062d":"Kann nicht angezeigt werden","TXT_CODE_cb84b22":"Diese Karte kann benutzerdefinierte HTML-Seiten hochladen und Javascript-Skripte direkt ausführen. Sie kann alle Elemente auf der Webseite direkt verwenden und ist für Web-Frontend-Entwickler geeignet.","TXT_CODE_cbb958f2":"Wenn diese Option aktiviert ist, können Spieler ohne einen öffentlichen Mojang-Signaturschlüssel keine Verbindung zum Server herstellen.","TXT_CODE_cbbc779f":"Nachdem Sie den Dateinamen der Serversoftware eingegeben haben, gehen Sie zur Dateiverwaltung, um die Serversoftware zum Starten der Instanz hochzuladen.","TXT_CODE_cbc235ad":"Die vorhandenen Dateien der Instanz werden gelöscht. Bitte warten Sie geduldig ...","TXT_CODE_cbe0fc07":"Die wiederhergestellte Hungerbar ist erschöpft","TXT_CODE_cc446b0c":"Radius, den Phantome nach Kristallen absuchen, um sie zu umkreisen. \\nDer Wert 0 deaktiviert die Funktion","TXT_CODE_cc561947":"Scannen Sie den QR-Code mit der Google-Authentifizierung oder einem anderen gängigen zweistufigen Verifizierungstool.","TXT_CODE_cc5a3aea":"Die Länge des Passworts darf nicht weniger als 9 Zeichen betragen","TXT_CODE_cc6ecb18":"Die maximale Anzahl erwachter Monster pro Tick","TXT_CODE_cc732bf6":"Stop-Befehl eingeben","TXT_CODE_cc7b54b9":"Grundeinstellungen","TXT_CODE_ccb60658":"Verifizieren","TXT_CODE_ccc0fec7":"Auf „false“ setzen, um die Lama-Caravan-Funktion zu deaktivieren (https://minecraft.wiki/w/Llama","TXT_CODE_cd045236":"Wachstumsrate süßer Beeren","TXT_CODE_cd1f9ef7":"Knotenhöranschluss","TXT_CODE_cd3ae89e":"Meldung zum automatischen Speichern des Backups anzeigen","TXT_CODE_cd40249d":"Anzahl der Kernthreads zur Chatausführung","TXT_CODE_cd5df11b":"Port-Mapping konfigurieren","TXT_CODE_cd62c9d4":"Verhindern Sie, dass verbotene Elemente durch Befehle generiert oder abgerufen werden","TXT_CODE_cd76bc9":"Benutzer <<operator_name>> löscht den Benutzer <<target_user_name>>","TXT_CODE_cd8cd5d2":"Diese Karte kann nur auf Seiten mit höheren Berechtigungen platziert werden","TXT_CODE_cd923ade":"Zum Abschluss: Nutzen Sie diese Software zum ersten Mal?","TXT_CODE_cd978243":"Administrator","TXT_CODE_cdb213a3":"Liste der Gegenstände, die gegen Explosionen immun sind","TXT_CODE_cdbd12d2":"Zeit des Phantomfeuers","TXT_CODE_cdd555be":"Grundeinstellungen","TXT_CODE_cdf1a25":"Welche Farbe sollte angezeigt werden, wenn die RAM-Auslastung „niedrig“ ist?","TXT_CODE_cdf7c16a":"Nur Administratoren können diese Einstellungen anzeigen und ändern","TXT_CODE_ce132192":"Suche nach Anwendungsnamen","TXT_CODE_ce4a3230":"Maximale Gesundheit des Mobs","TXT_CODE_ce8f3dc1":"Ob das PROXY-Protokoll für den Client aktiviert werden soll. \\nSie möchten dies nicht aktivieren, es sei denn, Sie führen einen UDP-Reverse-Proxy vor Ihrer Geyser-Instanz aus.","TXT_CODE_ce917b27":"Du bist fertig! \\nAls nächstes müssen Sie nur noch die „Instanzkonsole“ aufrufen und auf „Instanz starten“ tippen.","TXT_CODE_ce953a4":"Deaktivieren Sie PrimeBombs","TXT_CODE_ce99026b":"Speichern Sie Protokolle in einer SQL-Datenbank statt in Textdateien. \\nStandardmäßig falsch","TXT_CODE_cea5dba1":"Das Programm hat ein Ausstiegssignal erhalten und bereitet sich auf die Schließung vor ...","TXT_CODE_ceb783a9":"Die Dateiverwaltung ist eine Funktion, die mehr Ressourcen verbraucht und schwer zu kontrollieren ist.","TXT_CODE_ceba9262":"Wenn Sie nur ein normaler Benutzer sind, wenden Sie sich bitte an den Panel-Administrator.","TXT_CODE_cec321b4":"Ausgabekodierung: ","TXT_CODE_cee5802c":"Brutzeit","TXT_CODE_cf1cb995":"Gibt die Anzahl der Sekunden an, die Bilder auf der Festplatte zwischengespeichert werden, um das Herunterladen aus dem Netzwerk zu ersparen. \\n0 bedeutet deaktiviert.","TXT_CODE_cf27ab7e":"Bitte geben Sie einen Namen ein","TXT_CODE_cf393058":"Eine Konfigurationsoption hauptsächlich für Entwickler. \\nMelden Sie sich modifizierte Element -Tags an, die beim Ausführen auf integriertem Server keine Übersetzungen haben. \\nDas gewünschte Format ist tag.Item. <Namespace>. <Path> für den Übersetzungsschlüssel. \\nStandardmäßig zum Schweigen gebracht. \\nZulässige Werte: Schweigen, dev_short, dev_verbose, prod_short, prod_verbose","TXT_CODE_cf88c936":"Offener Port","TXT_CODE_cf95364f":"Diese Funktion weist eine gewisse Instabilität auf und kann nicht garantieren, dass die Benutzererfahrung der Benutzeroberfläche optimal bleibt.","TXT_CODE_cf9e259c":"Aktuelle Uhrzeit anzeigen","TXT_CODE_cfc657db":"Ordner","TXT_CODE_cfd64e73":"Standardgruppenname für neu registrierte Spieler","TXT_CODE_cfe187b0":"Dieser Wert definiert, um wie viel Abstand die Tick-Frequenz einer Entität verändert.","TXT_CODE_cff4286":"Prozentuale Chance (0,0–1,0), auf natürliche Weise ein Kaninchen namens Toast hervorzubringen","TXT_CODE_command.errLen":"Falsche Befehlslänge. Bitte stellen Sie sicher, dass das Befehlsformat korrekt ist","TXT_CODE_command.instanceNotOpen":"Die Befehlsausführung ist fehlgeschlagen, da das tatsächliche Instanzprogramm nicht vorhanden ist","TXT_CODE_command.quotes":"Falsche doppelte Anführungszeichen für den Befehl, es konnte kein Paar doppelter Anführungszeichen gefunden werden. Wenn Sie ein einzelnes doppeltes Anführungszeichen verwenden müssen, verwenden Sie bitte das Symbol {Anführungszeichen}","TXT_CODE_common._7unzip":"[7zip-Dekomprimierungsaufgabe]","TXT_CODE_common._7zip":"[7zip-Komprimierungsaufgabe]","TXT_CODE_common.killProcess":"Das Programm {{pid}} wurde mit einem Systembefehl zwangsweise beendet","TXT_CODE_common.title":"Titel","TXT_CODE_common.uuidIrregular":"UUID {{uuid}} ist falsch","TXT_CODE_d00c21bb":"Kartengenerierungstyp (Standard: Standard, Superflach: Flach)","TXT_CODE_d01532d":"Höhe des beim Ertrinken verursachten Schadens","TXT_CODE_d03c3e0e":"Bukkit-Originalkonfigurationsdatei","TXT_CODE_d043fe18":"Schreibdiskette","TXT_CODE_d07742fe":"Konfigurationsdateien","TXT_CODE_d080f2d7":"Neu laden","TXT_CODE_d092c3b":"Nur Hardcore-Spieler dürfen eine Verbindung herstellen","TXT_CODE_d0b40386":"Name der MySQL-Datenbank","TXT_CODE_d0c670df":"Der Fortschritt des MCSManager-Managementgremiums ist untrennbar mit dem selbstlosen Engagement der Mitwirkenden und Sponsoren verbunden.","TXT_CODE_d0c78699":"Meldung „Authentifizierungsserver nicht verfügbar“","TXT_CODE_d0d08d6":"z.B. 123MB","TXT_CODE_d0e37f20":"Whitelist aktivieren","TXT_CODE_d0e78c58":"Grundchance","TXT_CODE_d0fd83bf":"Chat-Einschränkungen","TXT_CODE_d11bf156":"Bitte haben Sie etwas Geduld und nutzen Sie die Aktualisierungsfunktion, um die Liste zu laden. Dieses Bild wird voraussichtlich später gelöscht","TXT_CODE_d11cc3e1":"Ob die Unterstützung für HAProxy aktiviert werden soll","TXT_CODE_d12fa808":"Startbefehl","TXT_CODE_d149e3e6":"Ermöglicht die Platzierung von Ambossen durch Spender","TXT_CODE_d1509da0":"Der Explosionsradius der Explosion. \\n(Zum Vergleich: TNT hat einen Wert von 4,0 und geladene Kriechpflanzen haben einen Wert von 6,0)","TXT_CODE_d15dc89c":"Die Anzahl der Blöcke, die ein Kolben drücken kann","TXT_CODE_d16d82ab":"Wenn der Inhalt in der Konsole verstümmelt ist, können Sie versuchen, die Kodierung zu ändern, um das Problem zu lösen.","TXT_CODE_d182c422":"Auf welcher Maschine wird das neue Programm bereitgestellt?","TXT_CODE_d1c78fbf":"Der zum Erstellen des Containers verwendete Name wird zufällig generiert, wenn er leer ist.","TXT_CODE_d23631cb":"Konsoleneinstellungen","TXT_CODE_d245f00d":"Auf „true“ setzen, um die Verlangsamung der Oxidation zu beseitigen, die durch in der Nähe befindliche, nicht oxidierte Kupferblöcke verursacht wird","TXT_CODE_d248b5c8":"Samstag","TXT_CODE_d258ec31":"Löschen Sie alle Auswahlen","TXT_CODE_d28c05df":"Erfolgreich etabliert","TXT_CODE_d29be029":"Auf „true“ setzen, damit Schwämme Wasser aus Schlammblöcken absorbieren und diese wieder in Schmutz verwandeln können","TXT_CODE_d29c8730":"Sollten Ping-Anfragen der Serverliste an die Backend-Server weitergeleitet werden?","TXT_CODE_d2bbb2f1":"Instanzfunktionsgruppe","TXT_CODE_d2c1a316":"Login","TXT_CODE_d2c79249":"Wenn Sie bereit sind, die Weiterentwicklung von MCSManager zu unterstützen,","TXT_CODE_d2e3b565":"Sprungkraft beim Drücken der Leertaste auf einem steuerbaren Minenwagen","TXT_CODE_d31196db":"Händlerkonsole","TXT_CODE_d31a684c":"Startzeit:","TXT_CODE_d32301c1":"Verfügbare Anschlussports","TXT_CODE_d324bb21":"Zugangsadresse:","TXT_CODE_d33e975f":"Auf „false“ setzen, um zu verhindern, dass der Server einen Spieler rauswirft, weil sein Chat nicht funktioniert","TXT_CODE_d341127b":"Event-Aufgaben","TXT_CODE_d356cf9d":"Schrumpfbreite","TXT_CODE_d372d72":"Versuchen Sie, beim Starten des Servers eine automatische Portweiterleitung über UPnP durchzuführen","TXT_CODE_d37f0418":"Das Panel ist montiert!","TXT_CODE_d3b29478":"Letzte Änderung","TXT_CODE_d3d88894":"Die Regenerationsmenge des Widerristes","TXT_CODE_d3ddefb5":"Die Menge an Erfahrungspunkten, die aus der Leiste des Spielers für die Reparatur von verzauberten Gegenständen im Inventar des Spielers verwendet werden können","TXT_CODE_d3de39b4":"Update abgeschlossen","TXT_CODE_d4146944":"Kehren Sie zur Startseite des Panels zurück","TXT_CODE_d42566ff":"Eine Chat-Nachricht, die die RAM-Nutzung anzeigt, wenn jemand den Befehl /ram verwendet.","TXT_CODE_d4517dcb":"Freitag","TXT_CODE_d47ff7e5":"Prozentuale Chance (0,0 – 1,0), dass ein Rechtsklick auf aktiviertes TNT es entschärft","TXT_CODE_d486a561":"beschreiben:","TXT_CODE_d4ad1dd":"Optional. \\nVerwendet den Bild-Standardbefehl, wenn leer, andernfalls wird der angegebene Befehl ausgeführt","TXT_CODE_d4b058a9":"Es ist verboten, Zenith-Projektile mit anderen Gegenständen als Waffen zu verwenden","TXT_CODE_d4b35741":"Schwellenwert für die Bewegungsrichtung des Spielers","TXT_CODE_d4c8fb3b":"Zugehörige Dokumente: ","TXT_CODE_d4cf1cb8":"Archiv","TXT_CODE_d4dafc41":"Ob die Shulker-Box ihren Inhalt zurücklassen soll, wenn sie zerstört wird","TXT_CODE_d507abff":"bestimmen","TXT_CODE_d51cd7ae":"generieren","TXT_CODE_d51f5d6":"Die doppelt eingegebenen Passwörter sind inkonsistent","TXT_CODE_d572c313":"Auf „true“ gesetzt, damit Dorfbewohner die Mob-Trauer-Gamerregel umgehen können","TXT_CODE_d58ffa0f":"Die Instanz befindet sich nicht im Ausführungsstatus!","TXT_CODE_d628e631":"Wird zum schnellen Erstellen von Instanzen verwendet","TXT_CODE_d629fa48":"Spielserver-IP","TXT_CODE_d6312bd5":"Benutzer <<operator_name>> hat die Systemkonfiguration geändert","TXT_CODE_d6321094":"Missbrauchsinkrement der Synthesetabelle","TXT_CODE_d648ff91":"Allerdings sind keine benutzerdefinierten Kartentitel oder andere benutzerdefinierte Sprachinhalte enthalten.","TXT_CODE_d649b01e":"Speichern Sie das leere Anzeigetafelteam","TXT_CODE_d655beec":"Beispielliste","TXT_CODE_d6a96ea4":"Zeigen Sie einen benutzerdefinierten Satz von Hyperlink-Schaltflächen an","TXT_CODE_d6c5a7f8":"Bitte füllen Sie die Pflichtfelder im Formular aus!","TXT_CODE_d6d9c42c":"Betriebsstatus der Anwendungsinstanz","TXT_CODE_d6e124c1":"Teleportiert dich zum Spawnen, wenn du oben an der Netherdecke Schaden erleidest","TXT_CODE_d6e7f572":"Sollten bei der Nutzung Probleme auftreten, empfiehlt es sich, diese zu schließen.","TXT_CODE_d705a2bd":"Zusätzliche Parameter werden automatisch an das Ende des Softwarepfads gespleißt.","TXT_CODE_d73c037b":"Ermöglicht den kontinuierlichen Handel mit einem Dorfbewohner über einen End Gateway-Exploit.","TXT_CODE_d73c8510":"Möchten Sie das Layout wirklich speichern?","TXT_CODE_d745c7d4":"RAM -Nutzung","TXT_CODE_d7638d7b":"Erforderlich, zum Beispiel: openjdk:23-slim","TXT_CODE_d764908b":"Deaktivieren Sie die maximale Entfernung, die ein Spieler zurücklegen kann (in Kacheln).","TXT_CODE_d76ccb4f":"Was ist ein Umgebungsbild?","TXT_CODE_d78ad17a":"Bitte wählen Sie den zu löschenden Benutzer aus","TXT_CODE_d79ff710":"z.B. RAM 4G","TXT_CODE_d7a7a095":"Der Karten-Seed bleibt standardmäßig leer.","TXT_CODE_d7ad19af":"Ändern Sie die Version der Konfigurationsdatei unter normalen Umständen nicht. Änderungen können den normalen Betrieb des Servers beeinträchtigen.","TXT_CODE_d7c5823e":"Integrierte Java 8-Ausführungsumgebung, geeignet für Minecraft-Server der Versionen 1.7 bis 1.16","TXT_CODE_d7dbc7c2":"Nicht aktiviert","TXT_CODE_d7ee9ba":"Letzte Anmeldung","TXT_CODE_d7fa3be3":"Optionaler Parameter -Xmx, z. B. 1024M","TXT_CODE_d851d86d":"Verdorren","TXT_CODE_d8d19932":"Begrenzung pro HTTP","TXT_CODE_d8d6dca8":"Auf „false“ setzen, um zu verhindern, dass der Kristall explodiert","TXT_CODE_d928da57":"Legen Sie fest, wie lange der Nachtzyklus aktiviert ist","TXT_CODE_d941eb89":"Betriebskarte","TXT_CODE_d97eaef3":"Ab welchem ​​Schwierigkeitsgrad durchbrechen Zombies Türen?","TXT_CODE_d9829f9c":"Kontinuierliche Zecken, die fliegende Monster aufwecken","TXT_CODE_d9a5c0c2":"Kontrollieren Sie, ob Kürbisse wieder auf Schneemänner gelegt werden können","TXT_CODE_d9b7a6a3":"Ermöglicht das Stapeln von Gegenständen in Truhen, um beim Laden der Welt die Stapelgrenzen zu überschreiten","TXT_CODE_d9c63fdd":"Vorlageninformationen","TXT_CODE_d9c73520":"Mounten Sie zusätzliche Verzeichnisse","TXT_CODE_d9cfab1b":"Anzahl der Hinrichtungen","TXT_CODE_da234f4f":"Spielschwierigkeit (friedlich, leicht, normal, schwer)","TXT_CODE_da26028c":"Mindestanzahl von Sekunden, die ein Phantom benötigt, um zu erscheinen","TXT_CODE_da2fb99a":"Die Webseite funktioniert nicht richtig","TXT_CODE_da521b59":"Der Geschwindigkeitsschub, den Minenkarren durch das Auftreffen auf eine angetriebene Schiene erhalten (betrifft nicht Ofen-Minenkarren)","TXT_CODE_da579edc":"2. Wenn der Besucher nicht angemeldet ist oder nicht über ausreichende Berechtigungen verfügt, kann die Karte trotzdem nicht geladen werden.","TXT_CODE_da65ecbd":"Ignorieren Sie die Prüfung, ob der Spieler einen Sprengkopf töten „kann“.","TXT_CODE_da76ea07":"Diese Konfigurationsdatei wird häufig für Purpur-Servertypen verwendet und erweitert die Einschränkungen der Paper-Konfiguration.","TXT_CODE_da782f63":"Maximale Anzahl von Threads für die Chat-Ausführung","TXT_CODE_da7a0328":"unbekannter Typ","TXT_CODE_da8bb476":"Plug-in-Update-Ordner, geben Sie den Ordnernamen der neuen Version des Plug-ins ein. Dieser Ordner aktualisiert das Plug-in automatisch, wenn der Server neu startet","TXT_CODE_da8f97a7":"Zugriff gesperrt","TXT_CODE_daca92c1":"Von der REST-API verwendeter Verbindungsport","TXT_CODE_dad61ed8":"Legen Sie die Standardhalsbandfarbe fest, wenn eine Katze gezähmt wird. \\nVerfügbare Farben","TXT_CODE_daemonInfo.authError":"Fehler bei der Schlüsselüberprüfung des Remote-Knotens {{- v}}","TXT_CODE_daemonInfo.authFailure":"Schlüsselüberprüfung des Remote-Knotens {{- v}} abgelehnt","TXT_CODE_daemonInfo.authSuccess":"Schlüsselüberprüfung des Remote-Knotens {{- v}} erfolgreich","TXT_CODE_daemonInfo.closed":"Trennen Sie aktiv den Remote-Knoten {{- v}}","TXT_CODE_daemonInfo.connect":"Der Remote-Knoten {{- v}} ist verbunden","TXT_CODE_daemonInfo.connectError":"Fehler beim Herstellen der Verbindung zum Remote-Knoten: {{- v}}","TXT_CODE_daemonInfo.disconnect":"Der Remote-Knoten {{- v}} ist ausgefallen","TXT_CODE_daemonInfo.replaceConnect":"Der Benutzer hat eine wiederholte Verbindungsanfrage initiiert und setzt nun die Verbindungskonfiguration zurück.","TXT_CODE_daemonInfo.resetConnect":"Der Benutzer initiiert die erneute Verbindung zum bereits verfügbaren Remote-Knoten und der Verbindungskanal wird zurückgesetzt.","TXT_CODE_daemonInfo.setLanguage":"Knotensprache festlegen","TXT_CODE_daemonInfo.tryConnect":"Es wird versucht, eine Verbindung zum Remote-Knoten herzustellen","TXT_CODE_db04e635":"Wenn es nur einen Standardserver gibt, wird der Server im Motd des Spielers angezeigt. \\nDieses Element hat keine Auswirkung, wenn ping_passthrough aktiviert ist","TXT_CODE_db07cf9e":"Teleportiert dich zum Spawn, wenn du irgendwie die Weltgrenze verlässt","TXT_CODE_db14fb46":"erfolgreich hinzugefügt","TXT_CODE_db37b7f9":"Fehler beim Herunterladen des Bildes. Stellen Sie sicher, dass der Bildname korrekt ist, oder ziehen Sie das benötigte Bild manuell über Docker Pull an der Knotenverwaltungskonsole.","TXT_CODE_db64faf6":"Anzahl der Panel-Logins","TXT_CODE_db815f4a":"Textfilterregelprofil (funktioniert möglicherweise nicht ordnungsgemäß)","TXT_CODE_db9375a5":"Kann zur Anzeige externer Websites verwendet werden","TXT_CODE_dba9bf61":"Die Ausführung der Komprimierungsaufgabe ist fehlgeschlagen!","TXT_CODE_dbc9b3e3":"Die Entfernung (in Blöcken), um feindlichen Mobs Schaden zuzufügen","TXT_CODE_dbefcc6c":"Terraria-Spieleserver","TXT_CODE_dc370276":"Legt den Overlay-Typ der Bossbar fest. \\nVerfügbare Optionen: PROGRESS, NOTCHED_6, NOTCHED_10, NOTCHED_12, NOTCHED_20","TXT_CODE_dc570cf2":"Lassen Sie das Feld leer, um keine Änderungen vorzunehmen","TXT_CODE_dc9fb6ce":"Das Speichern ist fehlgeschlagen, eine einzelne Instanz unterstützt nur bis zu 6 Tags!","TXT_CODE_dca030b8":"Die Konfigurationslänge des zusätzlichen Montagepfads für den Instanzcontainer ist falsch! \\nÜberprüfen Sie bitte!","TXT_CODE_dce87e42":"Wenn Sie 50 eingeben, bedeutet dies, dass die Nutzung aller Kerne auf 50 % begrenzt ist. Wenn Sie 200 eingeben, bedeutet dies, dass die Gesamtnutzung aller Kerne 200 % betragen darf.","TXT_CODE_dd002fae":"Ob die Whitelist aktiviert werden soll","TXT_CODE_dd06dea2":"Derzeit gibt es","TXT_CODE_dd0a8173":"Attribut für Rückstoßresistenz","TXT_CODE_dd20e5c3":"Ständige Zecken, die die Dorfbewohner wecken","TXT_CODE_dd238854":"Maximaler Speicher","TXT_CODE_dd2cef06":"Maximale vom Block verarbeitete Ticks","TXT_CODE_dd559000":"Remote mit angegebener Daemon-ID nicht gefunden!","TXT_CODE_dd65f101":"Der vom Server verwendete Berechtigungshandler. \\nStandardeinstellungen zu Neoforge: default_handler Wenn kein solcher Handler mit diesem Namen registriert ist.","TXT_CODE_dd78943e":"Sicherheitswarnung","TXT_CODE_dd8d27ce":"Steam-Spieleserver","TXT_CODE_ddc2de99":"Standard: localhost","TXT_CODE_ddcca0b9":"Benutzerdefiniertes Textfeld","TXT_CODE_dde54f31":"Fügen Sie ein neues hinzu","TXT_CODE_ddec29cf":"Der Gradient von <text>, wenn die RAM-Auslastung „mittel“ ist.","TXT_CODE_de150623":"Nicht-Spieler-Entitäten auf der Anzeigetafel zulassen","TXT_CODE_de161f0c":"Versteckte Haltbarkeit","TXT_CODE_de1ece3c":"Beruhigt den Eisengolem, wenn er geheilt ist, wenn er wütend ist","TXT_CODE_de3ced4b":"Bitte geben Sie den Bildnamen ein","TXT_CODE_de567e84":"Benutzer <<operator_name>> löscht die Datei <<file>> der <<instance_name>> Instanz","TXT_CODE_de61c48c":"Notizblockaktualisierungen deaktivieren","TXT_CODE_de854aa6":"Maximale Sekunden, die ein Phantom zum Spawnen benötigt","TXT_CODE_de9b7cc0":"Da der Instanztyp der Docker -Containermodus ist, werden wir nur Docker -Versionsvorlagen anzeigen.","TXT_CODE_deaf423c":"Spielmodi (Überleben, Kreativ, Abenteuer, Zuschauer)","TXT_CODE_deb2d85d":"Auf „true“ setzen, damit dieser Mob den Spieler umkreist, während er sich entzündet","TXT_CODE_dec6550e":"Steuert den Abstand des am weitesten sichtbaren Objekts auf dem Client und kann den Abstand entsprechend optimieren und verringern.","TXT_CODE_decf21ee":"Unterdrücken Sie Warnungen für fehlgeschlagene Build-Berechtigungen von Zonen, Spawn-Punkten oder fehlgeschlagene Serverbearbeitungen","TXT_CODE_dedc50a0":"Netzwerkrate","TXT_CODE_def287e0":"entfernter Knoten","TXT_CODE_df1ceee":"Infektionsrate der Zombie-Dorfbewohner","TXT_CODE_df3fdec":"Alle Dateien im Arbeitsverzeichnis der Instanz werden in diesem Verzeichnis innerhalb des Containers bereitgestellt","TXT_CODE_df455795":"Der Standardwert ist 24444.","TXT_CODE_df87c46d":"Alle abwählen","TXT_CODE_df903498":"Kontinuierliche Ticks, um Monster aufzuwecken","TXT_CODE_dfa17b2d":"Durch diesen Vorgang wird das Bild dauerhaft gelöscht. Möchten Sie fortfahren?","TXT_CODE_dfa27a93":"Haben Sie alle Berechtigungen?","TXT_CODE_dfaa82f3":"Mindestanzahl an Phantomen, die pro Versuch erscheinen","TXT_CODE_dfc17a0c":"Neue Konfiguration","TXT_CODE_dfc4b650":"Aus Link importieren","TXT_CODE_dfd06954":"Diese Zahl entspricht den Variablen von {mcsm_port1} bis {mcsm_port5} und wird bei jeder neuen Instanz inkrementell vergeben","TXT_CODE_dfd4fc5a":"Editor-Optionen & Hinweise","TXT_CODE_dff680b7":"Das Programm ist verlassen!","TXT_CODE_e00c858c":"Datei hochladen","TXT_CODE_e01539f1":"Erstellen Sie schnell Anwendungsbeispiele","TXT_CODE_e01e51f3":"Betrifft die Zeitrichtlinie alle Welten?","TXT_CODE_e039b9b5":"normal","TXT_CODE_e050b3be":"anfängliche Erinnerung","TXT_CODE_e057798f":"Server-Port (IPv6)","TXT_CODE_e0643e6f":"Ob Spieler gekickt werden sollen, wenn sie den HealOther-Schwellenwert überschreiten","TXT_CODE_e06841b5":"Beim Hochladen von Dateien wird gleichzeitig eine Instanz erstellt. Dieser Vorgang kann nicht rückgängig gemacht werden.","TXT_CODE_e06c1cea":"Komprimierungsformat","TXT_CODE_e076d90b":"Knoten","TXT_CODE_e08dfec5":"Max. Gesundheitsattribut","TXT_CODE_e08e63b5":"Stellen Sie eine beliebige ausführbare Konsolendatei bereit","TXT_CODE_e093012e":"Durch die Änderung der Nether-Dimensions-ID in die End-ID wird das Problem gelöst, dass Bedrock Edition nicht über der Y-Koordinate 127 aufbauen kann.","TXT_CODE_e0a944a1":"Sie haben dem {0} nicht zugestimmt. \\nSie müssen dieser Vereinbarung zustimmen, um diese Instanz zu starten. \\nSind Sie einverstanden?","TXT_CODE_e0fca76":"Direkt erstellen","TXT_CODE_e1070b52":"Wir arbeiten hart an der Datei!","TXT_CODE_e109c091":"Ungewöhnlicher Zugriff auf den Remote-Knoten","TXT_CODE_e10c992a":"Alle Benutzer aktualisieren die Seite, um Ihre neuen Änderungen zu sehen.","TXT_CODE_e112412a":"Herzliche Erinnerung","TXT_CODE_e1276b33":"Min. Sprungstärkeattribut","TXT_CODE_e13a6529":"Ob die Whitelist aktiviert werden soll (neue Version)","TXT_CODE_e13abbb1":"Instanz ausgeführt","TXT_CODE_e1454ba7":"Benutzer <<operator_name>> aktualisiert die <<instance_name>> Instanz","TXT_CODE_e14b32b":"Anzahl der Ticks zwischen den Versuchen, eine Katze auf natürliche Weise zu laichen","TXT_CODE_e15e5006":"Diese Seite hat keinen Inhalt.","TXT_CODE_e166bc2f":"Die Installationsaufgabe beginnt ...","TXT_CODE_e1a3b150":"Front-End-Farbwiedergabe","TXT_CODE_e1af7c8b":"Maximaler Schaden, den ein Sprengkopf anrichten kann","TXT_CODE_e1b0aab2":"Passwort unverändert","TXT_CODE_e1c60611":"Nur JSON-Format","TXT_CODE_e1ddd156":"Der dem Abfrageserver gemeldete Kartenname.","TXT_CODE_e21473bc":"Instanzen","TXT_CODE_e260a220":"Spielversion: ","TXT_CODE_e26d53d5":"Erstellen Sie nicht zu viele neue Registerkarten, da dies zu einer Unordnung der Elemente auf der Benutzeroberfläche und einer schlechten Panel-Leistung führen kann.","TXT_CODE_e2976753":"Diese ID ist die eindeutige Kennung für McSmanager, die zur Unterscheidung verschiedener Panels verwendet wird. \\nAlle von McSmanager bereitgestellten Online -Dienste verwenden diese ID, um Benutzer zu unterscheiden.","TXT_CODE_e29a9317":"Programmiersprache geändert","TXT_CODE_e29b79df":"Wenn Sie keine Parameter ausfüllen, erhält die neu hinzugefügte Karte automatisch Daten basierend auf der Adresse. Dies gilt jedoch nicht für alle Seiten und kann nur auf bestimmten Seiten normal verwendet werden.","TXT_CODE_e29be84c":"Prozentuale Chance (0,0 - 1,0), beim Laichen auf einem Huhn zu reiten","TXT_CODE_e2a11a62":"Ob anonyme Daten an Geyser gemeldet werden sollen","TXT_CODE_e2be1e70":"Auf „true“ setzen, damit Verwüster die Mob-Griefing-Gamerregel umgehen können","TXT_CODE_e2dc0156":"Beispiel: 25565","TXT_CODE_e304faa":"Maximale Anzahl gleichzeitiger Verbindungen. \\nWenn Sie möchten, dass Spieler aus der Einstellung „Server voll“ ausgeschlossen werden, stellen Sie die maximale Anzahl an Spielern ein, die Sie festgelegt haben, und stellen Sie dann die maximale Spielerzahl von Terraria auf 2 oder mehr ein","TXT_CODE_e3116bba":"Auf „false“ setzen, um das Spawnen von Mobs auf blauem Eis zu verhindern","TXT_CODE_e35de72b":"Kontrollieren Sie, ob riesige Zombies über KI verfügen, anstatt einfach nur da zu stehen","TXT_CODE_e37b4577":"Die Remote -Knotenadresse muss eine öffentliche IP -Adresse sein. \\nDomänen oder Localhosts können nicht verwendet werden, noch können LAN -IP -Adressen verwendet werden.","TXT_CODE_e3a77a77":"Unbegrenzt","TXT_CODE_e3d96a26":"Das Panel kann keine Verbindung zu einem Remote-Knoten herstellen. Bitte gehen Sie zur Knotenschnittstelle, um zuerst einen Remote-Knoten hinzuzufügen.","TXT_CODE_e3db239d":"Std.","TXT_CODE_e3efef30":"Liste der Gegenstände, die gegen Feuer immun sind","TXT_CODE_e40ddc99":"Blockfallmultiplikator für braunes Bett","TXT_CODE_e456aed":"Akzeptieren","TXT_CODE_e4605c4":"Benutzer <<operator_name>> startete <<instance_name>> Instanz","TXT_CODE_e4794d20":"Bitte klicken Sie hier.","TXT_CODE_e4878221":"Fehlende Remote-Knoten-ID","TXT_CODE_e4895a21":"Wenn ein Wert festgelegt ist, vermeiden Mobs auch, über den Steinmetz zu laufen.","TXT_CODE_e4898801":"Installation beginnen","TXT_CODE_e4a926bf":"Unkomprimierende Dateien ...","TXT_CODE_e4c84088":"Bitte vervollständigen Sie die erforderlichen Parameter der Karte","TXT_CODE_e4cf9ca3":"Das Format der Bossbar, wenn der Server den Befehl /tpsbar ausführt","TXT_CODE_e4d6cc20":"Fehler im Anforderungstext","TXT_CODE_e4dbff32":"MC-Sponge","TXT_CODE_e4dce83f":"Online","TXT_CODE_e4e975f0":"Wecken Sie die Dorfbewohner bei jedem Ticken auf","TXT_CODE_e520908a":"Die Version des Remote-Knotens stimmt nicht mit der vom Panel benötigten Version überein. Dies kann zu abnormalen Arbeiten führen. Bitte aktualisieren Sie den Remote-Knoten sofort.","TXT_CODE_e543f6c0":"MC Purpur","TXT_CODE_e56cced3":"Ändern Sie nicht willkürlich. \\nKonflikte mit anderen Panels können zu Fehlfunktionen führen.","TXT_CODE_e576a340":"Auf „false“ setzen, damit der Regen auch dann anhält, wenn ein Spieler schläft","TXT_CODE_e577c77c":"Aktualisieren der Instanz ...","TXT_CODE_e57bd50f":"Open-Source-Vereinbarung","TXT_CODE_e5839f71":"Wachstumsrate von Bambus","TXT_CODE_e5a52cee":"Sollten Spieler Schaden erleiden, wenn sie gegen eine Wand fliegen?","TXT_CODE_e5b0feda":"Aktivieren Sie den Datenabruf","TXT_CODE_e5b7522d":"Wenn Ihre allgemeinen Benutzer keine Dateiverwaltungsanforderungen haben, können Sie Benutzern die Verwendung der Dateiverwaltung verbieten.","TXT_CODE_e5ba712d":"Build-Server als Standardpaket:","TXT_CODE_e5bf0df1":"Händlerinformationen können nicht abgerufen werden, der Server wird möglicherweise gewartet","TXT_CODE_e5d3b1a":"Spawnen Sie nur bei Spielern, über denen der Himmel sichtbar ist","TXT_CODE_e5f949c":"Ordner","TXT_CODE_e6044db2":"An welchen Verbindungsport soll der Agent binden? \\nStandardmäßig binden wir an alle Adressen an Port 25577.","TXT_CODE_e60567a8":"Legen Sie die Portnummer des Überwachungsservers fest (siehe enable-rcon).","TXT_CODE_e612a8a2":"Auf „false“ setzen, um den Handel mit Dorfbewohnern zu deaktivieren","TXT_CODE_e627e546":"Anzahl der Knoten online","TXT_CODE_e641b54c":"ID des Buchautors","TXT_CODE_e65d2d1a":"Aktivieren Sie die Sichtbarkeit des lokalen Netzwerks","TXT_CODE_e66bfef9":"Steuert, wie viele Brocken von Projektilen in einem Tick synchronisiert geladen werden dürfen.","TXT_CODE_e66f4ae":"Erschöpfungsmultiplikator für den Schwimmhunger","TXT_CODE_e679197e":"Lobotomisiert den Dorfbewohner, wenn er sich nicht bewegen kann (Deaktiviert den Handel nicht)","TXT_CODE_e6a5c12b":"Instanz-ID","TXT_CODE_e6adf32d":"Autorenname eingeben","TXT_CODE_e6c30866":"Bildverwaltung","TXT_CODE_e707d042":"Ermöglicht Endkristallen, den Enderdrachen wiederzubeleben.","TXT_CODE_e70a8e24":"Zustand:","TXT_CODE_e718a226":"Die Download -Aufgabe ist in Arbeit. \\nIm Begriff, zur Konsole zu springen ...","TXT_CODE_e7335483":"Diese Funktion wählt automatisch das entsprechende Protokoll basierend auf dem vom Administrator festgelegten Instanztyp aus und ruft spezifische Informationen und Parameter des Serverprozesses ab (z. B. Anzahl der Spieler, Version usw.).","TXT_CODE_e74d658c":"Gerettet","TXT_CODE_e75ed0b5":"Max -Fäden für die frühe Initialisierung parallelität, -1 basiert auf der Prozessorzahl","TXT_CODE_e76e49e9":"Gemountetes Arbeitsverzeichnis:","TXT_CODE_e78047a5":"Globale Einstellungen für das Bedienfeld","TXT_CODE_e7a42e0e":"Tipps zur Geschwindigkeitsbegrenzung bei Verbindungen","TXT_CODE_e7ad77f0":"Schiffbruchsamen","TXT_CODE_e7b75c0e":"Benutzergruppe","TXT_CODE_e7cad65f":"Bitte wählen Sie eine Instanz aus, damit wir Knoteninformationen erhalten","TXT_CODE_e7cb14e2":"Deaktivieren Sie Tripwire-Updates","TXT_CODE_e812e21d":"Ob Dorfbewohner brüten können oder nicht","TXT_CODE_e81c77bc":"Servername","TXT_CODE_e8293f96":"Der Füllgrad der Bossleiste liegt zwischen 0,0 und 1,0","TXT_CODE_e83ffa03":"Neuen Benutzer hinzufügen","TXT_CODE_e86e91a2":"Eingabe-Kodierung auswählen","TXT_CODE_e88884ba":"Auf „false“ setzen, um zu verhindern, dass Entitäten Portale nutzen können","TXT_CODE_e89c5ccb":"Erzeugen Sie in einem vorhandenen Block Gelände mit Minusgraden","TXT_CODE_e8adf231":"Lava blockiert die Sicht","TXT_CODE_e8ce38c2":"Upload-Adresse konnte nicht abgerufen werden","TXT_CODE_e8d9c341":"Buchtitel-ID","TXT_CODE_e948602a":"Wird für Ackerland auf „true“ gesetzt, um die Mob-Griefing-Gamerule zu umgehen","TXT_CODE_e95ee23f":"Auf „false“ setzen, um die Aggressivität der Zombies gegenüber Dorfbewohnern zu stoppen, wenn sie zurückbleiben","TXT_CODE_e95f3a9f":"Macht es so, dass Tintenfische fliegen können, oh mein Gott!","TXT_CODE_e96a055e":"Echte Online-Verifizierung","TXT_CODE_e96a91cd":"7zip-Entpackung abgeschlossen: Alles in Ordnung","TXT_CODE_e9712ce1":"Macht es möglich, Spawner mit einem Werkzeug mit Seidengriff abzubauen","TXT_CODE_e97669d8":"implementieren","TXT_CODE_e9839f54":"Maximale Größe zur zufälligen Auswahl beim natürlichen Laichen","TXT_CODE_e98816c2":"Die Dauer der Immunität der Dorfbewohner tickt","TXT_CODE_e9935066":"Erforderlich, geben Sie nur numerische Portnummern ein","TXT_CODE_e99ab99a":"Sind Sie sicher, dass Sie den Benutzer {userName} löschen möchten?","TXT_CODE_e9ac4f57":"Update-Befehl darf keine Zeilenumbrüche enthalten; ist keine Skriptdatei für mehrere Befehle","TXT_CODE_e9cee11e":"Erlauben Sie den Spielern, Milch zu trinken, um den Statuseffekt eines schlechten Omens zu heilen","TXT_CODE_e9da0615":"Auf „false“ setzen, um das Spawnen von Mobs auf gepacktem Eis zu verhindern","TXT_CODE_e9dcbfe4":"Die wichtige Konfigurationsdatei des Bungeecord-Gruppenservers kann für die verteilte Verwaltung, Knotensteuerung usw. verwendet werden. Diese Konfigurationsdatei ist jedoch komplizierter und dient nur einfachen Einstellungen und Vorgängen.","TXT_CODE_ea04fb32":"Aktivieren Sie Neoforge Global Version Checking","TXT_CODE_ea0840c9":"Instanzverknüpfung","TXT_CODE_ea46baee":"Anderer Entitätsverfolgungsbereich","TXT_CODE_ea579dec":"Verlaufsintervall","TXT_CODE_ea6e5e5e":"Dieser Knoten funktioniert möglicherweise nicht ordnungsgemäß, wenn Sie mit einer öffentlichen IP -Adresse auf das Panel zugreifen","TXT_CODE_ea8aaf1b":"Wie oft soll eine Warnung ausgegeben werden?","TXT_CODE_eadac3c2":"Instanz {{Instanz}} Herunterfahren zeitlich festgelegt, erzwingt das Abschalten ...","TXT_CODE_eadb4f60":"Grundinformation","TXT_CODE_eaed6901":"Instanzen","TXT_CODE_eb579d63":"Benutzerressourcenverwaltung","TXT_CODE_eb5fe3b6":"Auf „true“ setzen, damit Ertrunkene Türen aufbrechen können","TXT_CODE_eb7966f6":"Abfrage der Kollisionsentität von Panzergestellen","TXT_CODE_eb880db2":"Normaler Benutzer","TXT_CODE_eb9584d":"Wie viel Schaden wird den Flügeldecken zugefügt, wenn der Feuerwerksschub aktiviert wird?","TXT_CODE_eb9fcdad":"Nutzername","TXT_CODE_ebbb2def":"Alle Kategorien","TXT_CODE_ebc235d5":"Wie viel Schaden erleidet die Haltbarkeit eines Elytra während des Fluges pro Sekunde?","TXT_CODE_ebd2a6a1":"Benutzerdefiniertes Layout","TXT_CODE_ebf479f2":"Die Abklingzeit nach der Verwendung einer Enderperle im Kreativmodus (in Ticks)","TXT_CODE_ebfb4831":"Primäre Kategorie (Spielname)","TXT_CODE_ec08484":"Sind Sie sicher, dass Sie die Beendigung der laufenden Instanz erzwingen möchten? \\nDies kann zu einer Beschädigung der Instanzdaten führen.","TXT_CODE_ec0b25f5":"Teilen Sie die URL dieser Seite mit Benutzern, keine Anmeldung erforderlich","TXT_CODE_ec0cda88":"MC-Paper","TXT_CODE_ec299306":"meine Bewerbung","TXT_CODE_ec6341cb":"Mindestgröße der zu komprimierenden Rohnetzwerknutzlast","TXT_CODE_ec6d29f4":"jeden","TXT_CODE_ec734b5c":"Geben Sie an, welches Image der Container zur Ausführung verwendet","TXT_CODE_ec7553c6":"Ursprüngliches Passwort","TXT_CODE_ec7fc405":"Entpacken fehlgeschlagen: {{message}}","TXT_CODE_ec99ddaa":"Von Ihnen hochgeladene Dateien","TXT_CODE_ec9dec9d":"Sollten Mobs AFK-Spieler in der Nähe angreifen?","TXT_CODE_eca8f1b3":"CPU-Auslastung (10 Minuten)","TXT_CODE_ecbd7449":"Löschen","TXT_CODE_ecc99fb6":"Frames Fenster -Framebuffer -Skala","TXT_CODE_eccd1c6c":"Vielfaches für zu schnelles Bewegen","TXT_CODE_ece2dd18":"Bei der Einstellung „Ja“ wird die Chat-Vorschau aktiviert. \\nWenn diese Option aktiviert ist, verbietet der Server Benutzern die Verwendung von VPNs oder Proxys. Wenn sie deaktiviert ist, verhindert der Server nicht, dass Benutzer VPNs oder Proxys verwenden.","TXT_CODE_ecf17071":"Anzahl der Instanzen, die vorübergehend nicht verfügbar sind","TXT_CODE_ecf93b03":"Es ist Zeit für die Dorfbewohner, Panik auszulösen","TXT_CODE_ed0e3963":"Übertragen Sie Serverkonsoleninformationen an OP","TXT_CODE_ed38c8ae":"Maximale Anzahl an Eisengolems, die Dorfbewohner im konfigurierten Radius spawnen können","TXT_CODE_ed3fc23":"weitermachen","TXT_CODE_ed510830":"Attribut „Angriffsrückstoß“.","TXT_CODE_ed81f72d":"Diese Instanz wurde nicht in einem Geschäft gekauft und kann nicht verlängert werden. Bitte kontaktieren Sie den Händler zur Bearbeitung!","TXT_CODE_ed9bab79":"Verhindert, dass Spieler nach dem Tod mit der Welt interagieren","TXT_CODE_ed9bfc6c":"Elementzusammenführungsradius","TXT_CODE_edd64e4d":"deaktivieren","TXT_CODE_edd8458c":"Die Geschwindigkeit, mit der sich ein Kessel unter einem nach unten gerichteten spitzen Tropfstein, über dem ein Lavablock platziert ist, mit Lava füllt (hängt von der Zufallsgeschwindigkeit ab)","TXT_CODE_edf84830":"Systemtyp","TXT_CODE_ee01df88":"Ob Sie der Minecraft-EULA-Vereinbarung zustimmen möchten. Wenn Sie den Minecraft-Server starten möchten, muss diese Option aktiviert sein.","TXT_CODE_ee54440":"Benutzer <<operator_name>>, die die <<instance_name>> Instanz text","TXT_CODE_ee67e1a3":"Arbeitsverzeichnis","TXT_CODE_ee8ae330":"Abfrage","TXT_CODE_eec3c1d7":"Mit der Installation des Standard-Integrationspakets wird davon ausgegangen, dass Sie zugestimmt und gelesen haben","TXT_CODE_eed84e8d":"Gibt an, ob Ihr Server Forge unterstützt.","TXT_CODE_eee2a47f":"Bildvorschau","TXT_CODE_eefcc58b":"Nur Babys können auf Hühnern reiten","TXT_CODE_ef0ce2e":"Dinge zu beachten","TXT_CODE_ef1f63d2":"Ob Phantome bei Tageslicht brennen oder nicht","TXT_CODE_ef27fda1":"Support-Kanal:","TXT_CODE_ef5f0c4c":"Serverkonfiguration & Laufzeitinformationen","TXT_CODE_ef61e06a":"Das Halten einer Schere während des Sprints fügt dem Spieler zufällig Schaden zu (Laufen Sie nicht mit einer Schere!)","TXT_CODE_ef650d57":"Analoge Konsole","TXT_CODE_ef676a8f":"Verwenden Sie eine alternative Glücksberechnungsformel","TXT_CODE_ef79a2ff":"Format: „image:tag“, „latest“ für neueste Version","TXT_CODE_ef8f8e29":"Seitenladefehler, bitte später erneut versuchen!","TXT_CODE_ef97db20":"Deaktivieren Sie die OnSecondUpdate-Prüfung für das Schreiben in die Protokolldatei","TXT_CODE_efb6d377":"Die Instanz funktioniert nicht mehr","TXT_CODE_efcef926":"Netzwerkmodus","TXT_CODE_efd37c48":"Instanz Verwalten","TXT_CODE_effefaab":"Kündigungsanordnung erlassen","TXT_CODE_environment_router.crateErr":"Bild erstellen {{name}}:{{tag}} Fehler:{{error}}","TXT_CODE_environment_router.crateImage":"Der Daemon erstellt das Image {{name}}:{{tag}} DockerFile wie folgt:\\n\\n{{dockerFileText}}","TXT_CODE_environment_router.crateSuccess":"Erstellung des Bildes {{name}}:{{tag}} abgeschlossen","TXT_CODE_environment_router.delImage":"Daemon löscht das Bild {{imageId}}","TXT_CODE_environment_router.dockerInfoErr":"Es konnten keine Bildinformationen abgerufen werden. Bitte stellen Sie sicher, dass Sie die Docker-Umgebung korrekt installiert haben","TXT_CODE_f0127843":"Die Anzahl der Zecken, die warten müssen, bevor sie sich wieder vermehren können","TXT_CODE_f021f43a":"Was die BossBar-Leiste anzeigen soll. \\nVerfügbare Optionen: TPS, MSPT, PING","TXT_CODE_f0260e51":"Datei einfügen","TXT_CODE_f02ff9cc":"Auf „true“ setzen, damit der Infinity-Bogen ohne Pfeile funktioniert","TXT_CODE_f041de90":"Dateiverwaltungscode","TXT_CODE_f0512848":"Entpackfehler: {{message}}","TXT_CODE_f0694685":"Primäre Kategorie auswählen","TXT_CODE_f07610ed":"Einstellung erfolgreich","TXT_CODE_f0789d81":"Reverse-Proxy-Modus","TXT_CODE_f085ce38":"Auf „true“ setzen, damit der Schleifstein den Namen und die Überlieferung von einem Gegenstand entfernen kann","TXT_CODE_f09da050":"Erstellen Sie automatisch eine Instanz, indem Sie ein serverkomprimiertes Paket hochladen. \\nNur .zip -Dateien werden unterstützt. \\nEs wird nach dem Upload automatisch dekomprimiert.","TXT_CODE_f0be5e98":"Legt fest, dass der Spieler unverwundbar ist, während er das Ressourcenpaket herunterlädt.","TXT_CODE_f0ca2761":"Ein Wörterbuch mit REST-Tokens, das externe Anwendungen zum Abfragen des Servers verwenden können","TXT_CODE_f0dc2530":"Standardbenutzergruppenberechtigungen","TXT_CODE_f0de6bb8":"Zeichen, die in Benutzernamen verwendet werden können. \\nKonfigurierbar mit Regex.","TXT_CODE_f0e6cbc":"Auf „true“ setzen, um die Welt zu Halloween zu zwingen","TXT_CODE_f115eff":"Automatisches Speicherintervall","TXT_CODE_f125d699":"Es kann immer nur eine Datei gleichzeitig ausgewählt werden","TXT_CODE_f130e34a":"Blockfallmultiplikator für graues Bett","TXT_CODE_f160d877":"Gründe, warum Spieler rausgeschmissen werden, wenn sie nicht auf der Whitelist stehen","TXT_CODE_f174dee0":"Wenn die Einstellung „Deaktiviert“ ist, generiert der Server dynamisch das Sichtfeld des Spielers und weist den Rest dem Client zur Konstruktion zu. \\nNur gültig, wenn „Client-side-chunk-generation-enabled“ aktiviert ist.","TXT_CODE_f17889f4":"Es wird von Zeit zu Zeit ausgeführt. Das spezifische Intervall kann sorgfältig eingestellt werden.","TXT_CODE_f17af923":"periodische Aufgaben","TXT_CODE_f1b166e7":"Einzelheiten","TXT_CODE_f1c96d8a":"Lösung:","TXT_CODE_f1cae9fa":"Leer lassen für integrierten Container-Einstiegspunkt","TXT_CODE_f1ed28e6":"Sorgt dafür, dass die Explosion des Creepers proportional zu seiner Gesundheit ist (geringere Gesundheit, schwächere Explosion).","TXT_CODE_f1f9ff1c":"Die Leerhöhe, bei der ein Dreizack mit Loyalität zu seinem Werfer zurückkehrt. \\nEin Wert von 0,0 oder höher deaktiviert diese Funktion.","TXT_CODE_f2168ca9":"Die Kraft der Explosion des Endkristalls","TXT_CODE_f220ed78":"Die Installation ist abgeschlossen!","TXT_CODE_f255aee0":"Die Abklingzeit nach Verwendung einer Enderperle (in Ticks)","TXT_CODE_f2577f17":"Ermöglicht Spielern, sich bei jedem Konto anzumelden, auch wenn ihr Benutzername nicht mit dem Namen ihres Charakters übereinstimmt","TXT_CODE_f25df30a":"Terrarien","TXT_CODE_f287f6dd":"Legen Sie die Höhe fest, die ein Spieler/eine Entität fallen muss, bevor es Ackerland zertrampelt","TXT_CODE_f28ded80":"Schleimblocksamen","TXT_CODE_f29d5d2":"Deaktivieren Sie das Senden von Protokollen als Nachrichten an Spieler mit Protokollberechtigungen","TXT_CODE_f2a58270":"Laden Sie das serverseitige Dateikomprimierungspaket hoch","TXT_CODE_f2d5dd5":"Ob Velocity den Online-Modus aktiviert","TXT_CODE_f2deb1d0":"Minecraft-Spieleserver","TXT_CODE_f309e464":"Auf „true“ gesetzt, wenn nur Spieler Ackerland zertrampeln dürfen.","TXT_CODE_f3209427":"Panel-Adresse","TXT_CODE_f3fc17f3":"Die Konfigurationsdatei der PaperSpigot-Serversoftware kann erweiterte Parameter und spezifischere Spieleinstellungen weiter konfigurieren, was einen großen entscheidenden Einfluss auf die Gesamtleistung hat. Sie erweitert die Mängel der Spigot-Konfigurationsdatei.","TXT_CODE_f3fe5c8e":"Bitte wählen Sie ein Datum und eine Uhrzeit aus","TXT_CODE_f4110b65":"Keine verfügbaren Remote -Knoten gefunden. \\nBitte gehen Sie zur Knotenseite, um Ihren Knoten zu verbinden. \\nWenn Sie nicht wissen, dass Sie das Panel neu installieren.","TXT_CODE_f41ad30a":"Bitte wählen Sie aus, was Sie löschen möchten","TXT_CODE_f4244bbf":"Panel-Host-CPU, RAM-Nutzung","TXT_CODE_f435b042":"Ob Spieler-IP-Daten an Mojang gesendet werden sollen, um zu verhindern, dass Spieler, die Proxys verwenden, auf den Server zugreifen","TXT_CODE_f460677f":"Entpacken fehlgeschlagen","TXT_CODE_f4617d31":"Bitte geben Sie die URL-Adresse der Datei ein","TXT_CODE_f466d7a":"Wählen Sie Alle","TXT_CODE_f486dbb4":"Instanz erfolgreich gelöscht","TXT_CODE_f49149d0":"Anschlussport","TXT_CODE_f49b2787":"Dateien, die zur Verwaltung bestimmter Anwendungsinstanzen verwendet werden","TXT_CODE_f4b52ed4":"Maximale Auto-Neustarts","TXT_CODE_f4c15e78":"Legen Sie dies auf True ein, um jede Blockentität zu entfernen, die einen Fehler in seine Aktualisierungsmethode auslöst, anstatt den Server zu schließen und ein Crashprotokoll zu melden. \\nSeien Sie gewarnt, dies könnte alles vermasseln, was wir sparsam verwendet haben. Wir sind nicht für Schäden verantwortlich.","TXT_CODE_f4c9715b":"Mehr sehen","TXT_CODE_f4fba0cd":"Vorlagenname","TXT_CODE_f50cfe2":"Geben Sie den Startbefehl ein","TXT_CODE_f51ce97e":"Deaktivieren Sie das Spawnen von Clownbomben","TXT_CODE_f52079a0":"Verbindungsadresse","TXT_CODE_f54e6d1f":"Panelzeit","TXT_CODE_f5689a76":"Aktionsleistenmeldung, die angezeigt wird, wenn jemand versucht, mit einer Schere zu rennen","TXT_CODE_f591e2fa":"Thema wählen","TXT_CODE_f59bbcef":"Schwellenwert für eingehende Pakete","TXT_CODE_f5b9d58f":"Administrationsmenü","TXT_CODE_f5cbef5c":"Ob die Proxy-Vereinbarung aktiviert werden soll","TXT_CODE_f5e3c97e":"Blockfallmultiplikator für rotes Bett","TXT_CODE_f5f9664":"Mit dieser Funktion können allgemeine Benutzer die Standardpakete in „Quick Deployment“ verwenden, um Instanzen neu zu installieren.","TXT_CODE_f5feed4e":"Anti-Verschleierungs-Stack-Trace-Informationen","TXT_CODE_f6047384":"Optional, Beispiel lobby-1","TXT_CODE_f60ca79d":"Wachstumsrate von Karotten","TXT_CODE_f61bf5f3":"Explosions-Fallback-Effekt deaktivieren","TXT_CODE_f63bfe78":"Dadurch werden alle Webseiten auf ihren Standardzustand zurückgesetzt. Gehen Sie daher bitte vorsichtig vor. \\nDie Seite kann nach dem Zurücksetzen automatisch die Sprache wechseln.","TXT_CODE_f63c4be2":"Warten auf das Hochladen in der Warteschlange, {n} verbleibend","TXT_CODE_f6468fe8":"Auf „true“ setzen, damit der Wither die Mob-Griefing-Gamerule umgeht","TXT_CODE_f6a33629":"Betriebsprotokoll","TXT_CODE_f6bd907d":"Sind Sie sicher, dass Sie die Instanz neu starten möchten?","TXT_CODE_f6d73056":"Vorlagenautor eingeben","TXT_CODE_f6dacecc":"Auf „true“ setzen, wenn dieser Mob Erfahrung verlieren soll","TXT_CODE_f7084f84":"Benutzerbetrieb","TXT_CODE_f70badb9":"Instanzname","TXT_CODE_f71475e2":"Die Bombe kann die Reichweite der Kacheln vom Explosionspunkt (in Gittern) beeinflussen.","TXT_CODE_f728ba8":"Das Füttern einer weiß/orangefarbenen Tulpe ändert den Typ Schnee/Normal","TXT_CODE_f738c45c":"Optimierungen für Entity-Gehirne, wenn sie weit von einem Spieler entfernt sind","TXT_CODE_f73a2ad2":"Legen Sie fest, wie lange die Feuerbeständigkeit anhält. \\nZum Deaktivieren auf 0 setzen","TXT_CODE_f77093c8":"Erneuern","TXT_CODE_f773aaeb":"Die Überlieferung des Spawners","TXT_CODE_f7909939":"Hardwareanforderungen eingeben","TXT_CODE_f79563ef":"Optional, Parameter vor -jar","TXT_CODE_f7969e5a":"Benutzer <<operator_name>> Erstellt den Daemon -Prozess <<daemon_id>>","TXT_CODE_f7f57aec":"Rette die Welt, wenn der letzte Spieler die Verbindung trennt","TXT_CODE_f801a9d2":"Wie lange sollten Sie warten, bis ein weiterer Raid gestartet werden kann?","TXT_CODE_f80e0786":"Verbindungsstatus","TXT_CODE_f8145844":"Diese Anwendungsvorlage kann nicht zur Neuinstallation verwendet werden. \\nMit Docker -Containern erstellte Instanzen können nicht als normale Vorlagen neu installiert werden. \\nBitte wählen Sie ein voreingestelltes Paket mit dem Docker -Label zur Neuinstallation aus. \\nWenn Sie andere Vorlagen installieren müssen, wenden Sie sich bitte an den Administrator, um die Containerisierungseinstellungen der Instanz manuell auszuschalten.","TXT_CODE_f84ae54f":"Nachdem Instanzen Tags haben, klassifiziert MCSManager die Instanzen automatisch nach Tag-Namen, damit Benutzer sie bei der Anzeige dieser Instanzen filtern können. Tag-Namen unterstützen jede Sprache.","TXT_CODE_f8501690":"Auf „false“ setzen, um zu verhindern, dass Enderman gegenüber allen Arten von gespawnten Endermiten aggressiv wird","TXT_CODE_f859eac":"Das Bearbeiten dieser Datei wird derzeit nicht unterstützt","TXT_CODE_f86b456a":"Kolbenkopie zulassen","TXT_CODE_f878fd4c":"Installieren","TXT_CODE_f880b5ad":"Erstellen Sie ein Administratorkonto, um auf das Panel zuzugreifen","TXT_CODE_f88db280":"Aktuelle Vorlage ist leer, trotzdem speichern?","TXT_CODE_f8a15a94":"Komprimiertes Archiv","TXT_CODE_f8b28901":"Wieder verbinden","TXT_CODE_f8bb9f10":"Auf „true“ setzen, damit dieser Mob unterhalb des Meeresspiegels spawnt","TXT_CODE_f8ef0c45":"Diese Konfigurationsdatei ist eine allgemeine Konfigurationsdatei für Server der Papierkategorie oder anderer abgeleiteter Kategorien. Sie erweitert die Mängel der Spigot-Konfigurationsdatei.","TXT_CODE_f8f3218a":"URL des Zeitberichts","TXT_CODE_f912fadc":"in Betrieb","TXT_CODE_f94e428a":"Benutzer hat abgesagt","TXT_CODE_f9a92e38":"Für die Konsole der Anwendungsinstanz auf dem Remote-Knoten sowie für das Hochladen und Herunterladen von Dateien muss die Webseite eine direkte Verbindung zum Remote-Knoten herstellen können.","TXT_CODE_f9b6e61b":"Laden Sie ein serverseitig komprimiertes Paket hoch","TXT_CODE_f9c65693":"Verhindert, dass Entitäten beim Tod Beute fallen lassen, wenn sie durch das Pauken von Spielregeln getötet werden","TXT_CODE_f9d92e18":"Sollte Schaden im Wasser ignoriert werden, wenn damage-if-sprinting aktiviert ist","TXT_CODE_fa301a5":"Wenn der Spieler im Kreativmodus ist und ein Wesen mit leerer Hand schlägt, stirbt das Wesen sofort","TXT_CODE_fa487a47":"Geben Sie die folgenden variablen Zeichenfolgen an:","TXT_CODE_fa6d3490":"Ermöglichen Sie Spinnen, über die Grenzen der Welt hinauszuklettern","TXT_CODE_fa6f95a1":"MC MCDR","TXT_CODE_fa7002ef":"Benutzer <<operator_name>> startete die <<instance_name>> Instanz neu","TXT_CODE_fa920c0":"Ablaufzeit","TXT_CODE_faa1962b":"Benutzer <<operator_name>> Erstellt den Benutzer <<target_user_name>>","TXT_CODE_faa6656a":"Der Server sendet eine gehashte Block-Netzwerk-ID anstelle einer aufsteigenden ID beginnend bei 0","TXT_CODE_fabc6a75":"Immunitätszeit der Dorfbewohner nach der Arbeit","TXT_CODE_fabfaadc":"Meldung, die anzeigt, wenn die Rambar für einen Benutzer mit dem Befehl /rambar aktiviert wird.","TXT_CODE_facd4d3c":"Macht diesen Mob im Wasser montierbar (Sie werden nicht herausgeschleudert)","TXT_CODE_fb00a910":"Wüstensamen","TXT_CODE_fb1ff943":"Unbekannter Umgebungstyp","TXT_CODE_fb23339d":"Bei dieser Konfigurationsdatei handelt es sich um eine allgemeine Konfigurationsdatei für Bukkit-Typ- oder andere abgeleitete Typserver. Unter normalen Umständen muss diese Konfigurationsdatei nicht allzu stark geändert werden. Wenn Sie jedoch den von Bukkit abgeleiteten Typ verwenden, können Sie entsprechende Anpassungen vornehmen Serversoftware ist diese Konfigurationsdatei möglicherweise ungültig.","TXT_CODE_fb267b0b":"Sind Sie sicher, dass Sie den Knoten dauerhaft löschen möchten?","TXT_CODE_fb4cb9cb":"Das Hinzufügen ist nicht möglich. Diese Karte kann nur auf Seiten mit höheren Berechtigungen platziert werden","TXT_CODE_fb547313":"Bitte stellen Sie sicher, dass die Instanz gestoppt ist, bevor Sie sie löschen!","TXT_CODE_fb75aba9":"[Konfigurations-Upgrade-Mechanismus] Fehler beim Parsen der Konfigurationsdatei, automatisch ignoriert:","TXT_CODE_fb87ccd":"Instanzcode","TXT_CODE_fb93942a":"Ladebereich des Spawnpunkts","TXT_CODE_fbde647e":"Erfrischt","TXT_CODE_fbe67333":"Lassen Sie keine Katze spawnen, wenn in diesem Bereich eine andere Katze gefunden wird. \\nZum Deaktivieren auf 0 setzen","TXT_CODE_fc4e2173":"Nach dem Hochladen der Datei wird die Instanz automatisch erstellt.","TXT_CODE_fc5c0e2e":"Macht diesen Mob im Wasser montierbar (Sie werden nicht herausgeschleudert)","TXT_CODE_fc7ac5ea":"Die maximale Anzahl der vom Server verwendeten Ausführungsthreads (0 bedeutet keine Begrenzung)","TXT_CODE_fcb08d61":"Auf „true“ setzen, um zu verhindern, dass ein Enderman aggressiv wird, wenn ein Spieler dem Enderman in die Augen schaut","TXT_CODE_fcbdcb34":"Montag","TXT_CODE_fcd641db":"Aufgabenaktion/-typ","TXT_CODE_fcdc758":"Das Ändern des Instanzordnerbesitzers (Chown) ist fehlgeschlagen. \\nDieser Schritt wurde automatisch übersprungen.","TXT_CODE_fcde7b2e":"Diese Konfigurationseinstellungen erfordern etwas Fachwissen, und Sie können anhand Ihrer Hardware grob abschätzen, welche Werte für Sie funktionieren.","TXT_CODE_fcee1fa0":"antike Stadtsamen","TXT_CODE_fd0cdf5d":"Aus Datei importieren","TXT_CODE_fd13f431":"Bild bearbeiten","TXT_CODE_fd5ca298":"Höhe verkleinern (Peers müssen der Änderung der Mindesthöhe zustimmen)","TXT_CODE_fd63a181":"Unter der aktuellen Adresse gibt es keine Webseite","TXT_CODE_fd665d32":"maximale Bewegungsgeschwindigkeit","TXT_CODE_fd838916":"Alle Brocken sind Schleimbrocken","TXT_CODE_fd9d9eeb":"Steuert, ob die Werte von Attributen begrenzt werden sollen.","TXT_CODE_fdb6c369":"Benutzername des Prozesses","TXT_CODE_fdd1a61":"Zeichnen Sie REST-API-Verbindungsinformationen auf","TXT_CODE_fdd8effa":"Der fliegende Spieler schießt prompt","TXT_CODE_fde31068":"Upload -Rate für Benutzerdatei","TXT_CODE_fdec1b6f":"Arbeitsverzeichnis mounten","TXT_CODE_fe2435a0":"Entpacke mit 7zip im aktuellen Verzeichnis: {{command}}","TXT_CODE_fe25087f":"Bitte Schlüssel eingeben","TXT_CODE_fe3f34e6":"Nicht ausgewählt","TXT_CODE_fe402f41":"Auf „true“ setzen, damit Zuckerrohr zu Knochenmehl verarbeitet werden kann","TXT_CODE_fe463ea3":"Purpur verfolgt, wenn es zu Verzögerungen kommt, um das Verhalten entsprechend ändern zu können. \\nDieser Wert ist der Schwellenwert, ab dem Sie davon ausgehen möchten, dass der Server verzögert ist.","TXT_CODE_fe46ac12":"Chance für Azaleen, auf natürliche Weise zu Bäumen zu wachsen","TXT_CODE_fe592df1":"Wie oft soll die Bossbar aktualisiert werden?","TXT_CODE_fe731dfc":"Aktionen","TXT_CODE_fe80882d":"UDP-Abfrageport","TXT_CODE_fe82609a":"Verhindern Sie, dass Spieler Spielsteine ​​mit ungültigen Stilen platzieren","TXT_CODE_fe95b79a":"Ob serverseitiges autoritatives Mining aktiviert werden soll","TXT_CODE_feaa97d4":"Legen Sie die Standardhalsbandfarbe fest, wenn ein Wolf gezähmt wird.","TXT_CODE_feab659d":"Alle Arten","TXT_CODE_fec66aca":"Ob Xbox-Erfolge aktiviert werden sollen.","TXT_CODE_feeea328":"Erhalten Sie vollständige Konsoleninteraktivität, indem Sie eine Konsolenweiterleitung simulieren. \\nEinschließlich der Verwendung der Tabulator-, Strg-Funktionstasten usw.","TXT_CODE_fefbb457":"Falsches Konto oder Passwort","TXT_CODE_ff2c2f20":"Größe des Datei-Cache blockieren","TXT_CODE_ff81b31e":"Gravur","TXT_CODE_ff8431c1":"Netto-Threadzahl","TXT_CODE_ffa884f9":"Warnung: Das Arbeitsverzeichnis ist nicht im Container gemountet und der Container kann nicht auf Dateien im Arbeitsverzeichnis der Instanz zugreifen","TXT_CODE_ffca72ed":"Bewirkt, dass der Server in der Serverliste online angezeigt wird. \\nBei der Einstellung „Nein“ werden Antworten vom Client unterdrückt. \\nDies bedeutet, dass es offline angezeigt wird, aber weiterhin Verbindungen akzeptiert.","TXT_CODE_ffda3755":"Code eingeben","TXT_CODE_ffe9366a":"Ob Elemente und Blöcke hinzugefügt werden sollen, die in der Bedrock Edition nicht vorhanden sind.","TXT_CODE_ffeacc21":"Stop-Befehl darf keine Zeilenumbrüche enthalten; ist keine Skriptdatei für mehrere Befehle","TXT_CODE_ffebf0bf":"RCON-Nachricht an OP senden","TXT_CODE_fff00e2b":"Attribut „Mindestbewegungsgeschwindigkeit“.","TXT_CODE_fffaeb16":"Eine Stornierung ist während des Upload-Vorgangs nicht möglich!","TXT_CODE_fffaeb17":"Startbefehl als Benutzer ausführen.","TXT_CODE_fffaeb18":"Legen Sie den Systembenutzer fest, der verwendet wird, um den Prozess zu starten. \\nMöglicherweise müssen Sie Probleme selbst lösen, die durch Erlaubnisprobleme selbst verursacht werden.","TXT_CODE_file_router.instanceNotExist":"Instanz {{instanceUuid}} existiert nicht","TXT_CODE_file_router.unzipLimit":"Die maximale Anzahl gleichzeitiger Dekomprimierungsaufgaben wurde überschritten. Derzeit werden {{fileLock}} Aufgaben ausgeführt.","TXT_CODE_file_router_service.instanceNotExit":"Instanz {{uuid}} existiert nicht","TXT_CODE_frp.done":"Das FRP-Intranet-Zuordnungsprogramm ist installiert. Sie können den Zuordnungsstatus in der oberen linken Ecke überprüfen. Wenn er nicht angezeigt wird, ist er möglicherweise durch Antivirensoftware blockiert, unzureichende Dateiberechtigungen oder der FRP-Schlüssel ist falsch.","TXT_CODE_frp.downloadErr":"Das Herunterladen der FRP-Anwendung ist fehlgeschlagen und das FRP-Intranet-Zuordnungsprogramm kann nicht normal gestartet werden.","TXT_CODE_frp.installing":"Das FRP-Intranet-Mapping-Programm wird gleichzeitig heruntergeladen und installiert. Wir werden die Mapping-Funktion später automatisch starten...","TXT_CODE_general_start.cmdEmpty":"Die Instanz kann nicht gestartet werden, der Startbefehl ist leer","TXT_CODE_general_start.cwd":"Arbeitsverzeichnis: {{cwd}}","TXT_CODE_general_start.cwdPathNotExist":"Arbeitsverzeichnis existiert nicht","TXT_CODE_general_start.instanceConfigErr":"Startbefehl, Eingabe- und Ausgabekodierung oder Arbeitsverzeichnis ist leer","TXT_CODE_general_start.instanceUuid":"Instanz-ID: [{{uuid}}]","TXT_CODE_general_start.pidErr":"Es wurde festgestellt, dass das Instanzprogramm/der Container nicht gestartet werden konnte (PID ist leer). Die möglichen Gründe sind:\\n\\n1. Der Instanz-Startbefehl ist falsch geschrieben. Bitte gehen Sie zur Instanz-Einstellungsoberfläche, um den Startbefehl und die Parameter zu überprüfen.\\n\\n2. Die Systemhostumgebung ist falsch oder es fehlt die Umgebung, z. B. eine Java-Umgebung usw.\\n\\n\\nAnweisungen zum nativen Start:\\n\\n{{startCommand}}\\n\\n\\nStarten Sie die Befehlsanalyse des Textkörpers:\\n\\nProgramm: {{commandExeFile}}\\n\\nParameter: {{commandParameters}}\\n\\n\\nBitte melden Sie diese Informationen dem Administrator oder dem technischen Personal oder beheben Sie den Fehler selbst.","TXT_CODE_general_start.runAs":"Versuchen Sie, den Unterprozess mit dem Systembenutzer Benutzername zu starten: {{Benutzer}}","TXT_CODE_general_start.startCmd":"Startbefehl: {{cmdList}}","TXT_CODE_general_start.startErr":"Der Instanzstart ist fehlgeschlagen. Bitte überprüfen Sie die Startanweisungen, die Hostumgebung und die Konfigurationsdateien usw.","TXT_CODE_general_start.startInstance":"Sitzung {{source}}: Anfrage zum Öffnen einer Instanz.","TXT_CODE_general_start.startOrdinaryTerminal":"Die Anwendungsinstanz wird ausgeführt. Sie können Befehle im Befehlseingabefeld unten senden. Wenn Sie erweiterte Konsolenfunktionen wie Strg, Tab und andere Tastenkombinationen unterstützen müssen, gehen Sie bitte zu den Konsoleneinstellungen, um die simulierte Konsolenfunktion zu aktivieren.","TXT_CODE_general_start.startSuccess":"Instanz {{instanceUuid}} erfolgreich gestartet PID: {{pid}}","TXT_CODE_general_stop.execCmd":"Voreingestellter Befehl zum Herunterfahren ausgeführt: {{stopCommand}}\\n\\nWenn Sie die Instanz nicht schließen können, gehen Sie bitte zu den Instanzeinstellungen, um den richtigen Befehl zum Schließen der Instanz zu ändern, z. B. ^C, Stopp, Ende usw.","TXT_CODE_general_stop.notRunning":"Die Instanz befindet sich nicht im Ausführungsstatus und kann nicht gestoppt werden.","TXT_CODE_general_stop.stopErr":"Wenn der Befehl zum Herunterfahren ausgegeben wurde, die Instanz jedoch längere Zeit nicht heruntergefahren werden kann, kann dies an einem Fehler im Befehl zum Herunterfahren der Instanz oder an der angehaltenen Animation des Instanzprozesses liegen Der Befehl zum Erzwingen der Beendigung kann verwendet werden, um den Prozess zu beenden.","TXT_CODE_general_update.cmdFormatErr":"Das Format des Aktualisierungsbefehls ist falsch. Bitte wenden Sie sich an den Administrator.","TXT_CODE_general_update.err":"Fehler","TXT_CODE_general_update.error":"Aktualisierungsfehler: {{err}}","TXT_CODE_general_update.killProcess":"Das Task-Programm wird zwangsweise beendet...","TXT_CODE_general_update.readyUpdate":"Instanz {{instanceUuid}} bereitet sich auf einen Aktualisierungsjob vor ...","TXT_CODE_general_update.statusErr_notStop":"Der Instanzstatus ist falsch, die Aktualisierungsaufgabe kann nicht ausgeführt werden und die Instanz muss gestoppt werden.","TXT_CODE_general_update.statusErr_otherProgress":"Der Instanzstatus ist falsch, andere Aufgaben werden ausgeführt","TXT_CODE_general_update.terminateUpdate":"Der Benutzer hat angefordert, die asynchrone Aktualisierungsaufgabe der Instanz {{instanceUuid}} zu beenden.","TXT_CODE_general_update.update":"erneuern","TXT_CODE_general_update.updateCmd":"Instanz {{instanceUuid}} führt den Aktualisierungsbefehl wie folgt aus:","TXT_CODE_general_update.updateErr":"Der Aktualisierungsvorgang ist abgeschlossen, aber das Ergebnis ist falsch. Die Dateiaktualisierung ist möglicherweise beschädigt oder das Netzwerk funktioniert nicht reibungslos.","TXT_CODE_general_update.updateFailed":"Das Update ist fehlgeschlagen. Der Update-Befehl konnte nicht gestartet werden.","TXT_CODE_general_update.updateSuccess":"Update abgeschlossen!","TXT_CODE_http_router.downloadErr":"Download-Fehler: {{error}}","TXT_CODE_http_router.fileNameNotSpec":"Der Downloadname der Benutzerdatei ist falsch","TXT_CODE_http_router.instanceNotExist":"Instanz existiert nicht","TXT_CODE_http_router.updateErr":"Unbekannter Grund: Upload fehlgeschlagen","TXT_CODE_install.changeModeErr":"Die Berechtigungen für die Datei {{path}} konnten nicht geändert werden. Bitte setzen Sie sie manuell auf chmod 755 oder höher","TXT_CODE_install.guide":"Abhängige Programmreferenz: https://github.com/mcsmanager/pty","TXT_CODE_install.installErr":"Die Installation optionaler abhängiger Bibliotheken ist fehlgeschlagen und einige optionale Funktionen sind nicht verfügbar. Die Installation wird beim nächsten Start nicht erneut versucht.","TXT_CODE_install.installed":"Die ausgewählten abhängigen Programme wurden automatisch installiert und die simulierte Konsole sowie einige erweiterte Funktionen wurden automatisch aktiviert.","TXT_CODE_install.ptyNotSupportSystem":"Die simulierte Konsole unterstützt nur die Windows/Linux x86_64-Architektur und wurde automatisch auf eine normale Konsole herabgestuft.","TXT_CODE_install.ptySupport":"Es wurde erkannt, dass die abhängige Bibliotheksinstallation ausgewählt ist und die simulierte Konsolenfunktion verfügbar ist.","TXT_CODE_install.skipInstall":"Es wird erkannt, dass es sich bei dem System nicht um ein Linux-System handelt und die Installation abhängiger Bibliotheken wird automatisch übersprungen.","TXT_CODE_instance.dirEmpty":"Startbefehl, Eingabe- und Ausgabekodierung oder Arbeitsverzeichnis ist leer","TXT_CODE_instance.dirNoE":"Arbeitsverzeichnis existiert nicht","TXT_CODE_instance.invalidContainerName":"Ungültiger Containername {{v}}","TXT_CODE_instance.invalidCpu":"Falsche CPU-Kernspezifikation {{v}}","TXT_CODE_instance.successful":"Instanz {{v}} wurde erfolgreich gestartet","TXT_CODE_instanceConf.autoRestart":"Es wurde festgestellt, dass die Instanz heruntergefahren wurde. Gemäß dem aktiven Ereignismechanismus wurde der Befehl zum automatischen Neustart ausgegeben ...","TXT_CODE_instanceConf.autoRestartErr":"Fehler beim automatischen Neustart: {{err}}","TXT_CODE_instanceConf.cantModifyInstanceType":"Dieser Instanztyp kann während der Ausführung nicht geändert werden","TXT_CODE_instanceConf.cantModifyProcessType":"Dieser Instanzprogrammtyp kann während der Ausführung nicht geändert werden","TXT_CODE_instanceConf.cantModifyPtyModel":"Der PTY-Modus kann während der Ausführung nicht geändert werden","TXT_CODE_instanceConf.error":"Fehler","TXT_CODE_instanceConf.info":"Nachricht","TXT_CODE_instanceConf.initInstanceErr":"Die Initialisierung der Instanz ist fehlgeschlagen, der eindeutige Identifikationscode oder die Einstellungsparameter sind leer","TXT_CODE_instanceConf.instanceBusy":"Die Instanz befindet sich derzeit in einem ausgelasteten Zustand und kann keine Aktionen ausführen.","TXT_CODE_instanceConf.instanceLock":"Dieser {{info}}-Vorgang kann nicht ausgeführt werden, da die Instanz gesperrt ist. Bitte versuchen Sie es später erneut.","TXT_CODE_instanceConf.instantExit":"Es wurde festgestellt, dass die Instanz innerhalb einer sehr kurzen Zeitspanne nach dem Start beendet wird. Der Grund kann sein, dass Ihr Startbefehl falsch ist oder die Konfigurationsdatei falsch ist.","TXT_CODE_instanceConf.ptyNotExist":"Die simulierte Konsole kann nicht aktiviert werden, da der {{path}}-Daemon nicht vorhanden ist. Sie können sich an den Administrator wenden, um den Daemon neu zu starten und ihn neu zu installieren (nur Linux).","TXT_CODE_mc_update.updateInstance":"Instanz aktualisieren.....","TXT_CODE_passport_router.registerErr":"Der Aufgabenname kann nicht definiert werden oder der Schlüssel ist leer","TXT_CODE_permission.apiError":"Falscher Schlüssel","TXT_CODE_permission.forbidden":"Nicht ausreichende Berechtigungen","TXT_CODE_permission.forbiddenInstance":"[Verboten] [Middleware] Falsche Parameter oder falsche Zugriffsinstanz","TXT_CODE_permission.forbiddenTokenError":"Token-Überprüfung fehlgeschlagen, Zugriff verweigert","TXT_CODE_permission.tooFast":"Die Anfragegeschwindigkeit ist zu hoch. Bitte versuchen Sie es später erneut","TXT_CODE_permission.xmlhttprequestError":"Anforderungsheader x-requested-with: xmlhttprequest konnte nicht gefunden werden","TXT_CODE_preset.actionErr":"Der Standardbefehl {{action}} ist nicht verfügbar","TXT_CODE_process_config.writEmpty":"Der geschriebene Inhalt ist leer. Möglicherweise wird der Profiltyp nicht unterstützt.","TXT_CODE_protocol.socketErr":"Ausnahme der Sitzung {{id}}({{address}})/{{event}} bei der Antwort auf Daten:","TXT_CODE_pty_start.cmdEmpty":"Die Instanz kann nicht gestartet werden, der Startbefehl ist leer","TXT_CODE_pty_start.cmdErr":"Startbefehl, Eingabe- und Ausgabekodierung oder Arbeitsverzeichnis ist leer","TXT_CODE_pty_start.cwdNotExist":"Arbeitsverzeichnis existiert nicht","TXT_CODE_pty_start.instanceStartErr":"Der Instanzstart ist fehlgeschlagen. Bitte überprüfen Sie den Startbefehl, die Hostumgebung und die Konfigurationsdateien usw.","TXT_CODE_pty_start.instanceUuid":"Instanz-ID: [{{instanceUuid}}]","TXT_CODE_pty_start.mustAbsolutePath":"Das Startarbeitsverzeichnis der Simulationskonsole muss einen absoluten Pfad verwenden. Bitte gehen Sie zur Instanzeinstellungsoberfläche, um den Arbeitspfad auf einen absoluten Pfad zurückzusetzen.","TXT_CODE_pty_start.notSupportPty":"Der simulierte Konsolenmodus ist fehlgeschlagen. Die nicht unterstützte Architektur oder das nicht unterstützte System wurde automatisch auf den normalen Konsolenmodus heruntergestuft.","TXT_CODE_pty_start.pidErr":"Es wurde ein Fehler beim Prozessstart festgestellt. Die möglichen Gründe sind:\\n\\n1. Der Instanz-Startbefehl ist falsch geschrieben. Bitte gehen Sie zur Instanz-Einstellungsoberfläche, um den Startbefehl und die Parameter zu überprüfen.\\n\\n2. Die Systemhostumgebung ist falsch oder es fehlt die Umgebung, z. B. das Fehlen einer Java-Umgebung usw.\\n\\n\\nStartbefehl:\\n\\n{{startCommand}}\\n\\n\\nBitte melden Sie diese Informationen dem Administrator oder dem technischen Personal oder beheben Sie den Fehler selbst.","TXT_CODE_pty_start.ptyCwd":"Arbeitsverzeichnis: {{cwd}}","TXT_CODE_pty_start.ptyParams":"PTY-Parameter: {{param}}","TXT_CODE_pty_start.ptyPath":"PTY-Pfad: {{path}}","TXT_CODE_pty_start.sourceRequest":"Sitzung {{source}}: Anfrage zum Öffnen einer Instanz.","TXT_CODE_pty_start.startCmd":"Startbefehl: {{cmd}}","TXT_CODE_pty_start.startEmulatedTerminal":"Der simulierte Konsolenmodus ist wirksam. Sie können Inhalte direkt in die Konsole eingeben und Funktionstasten wie Strg und Tab verwenden.","TXT_CODE_pty_start.startErr":"Der simulierte Konsolenmodus ist fehlgeschlagen. Möglicherweise existiert das abhängige Programm nicht und wurde automatisch auf den normalen Konsolenmodus heruntergestuft ...","TXT_CODE_pty_start.startPty":"Sitzung {{source}}: erfordert das Öffnen der Instanz, der Modus ist simulierte Konsole","TXT_CODE_pty_start.startSuccess":"Instanz {{instanceUuid}} erfolgreich gestartet PID: {{pid}}","TXT_CODE_pty_stop.execCmd":"Voreingestellter Befehl zum Herunterfahren ausgeführt: {{stopCommand}}\\n\\nWenn die Instanz nicht heruntergefahren werden kann, gehen Sie bitte zu den Instanzeinstellungen, um den richtigen Befehl zum Herunterfahren der Instanz zu ändern, z. B. Beenden, Stoppen, Beenden usw.","TXT_CODE_pty_stop.notRunning":"Die Instanz wird nicht ausgeführt und kann nicht gestoppt werden.","TXT_CODE_pty_stop.stopErr":"Wenn der Befehl zum Herunterfahren ausgegeben wurde, die Instanz jedoch längere Zeit nicht heruntergefahren werden kann, kann dies an einem Fehler im Befehl zum Herunterfahren der Instanz oder an der angehaltenen Animation des Instanzprozesses liegen Der Befehl zum Erzwingen der Beendigung kann verwendet werden, um den Prozess zu beenden.","TXT_CODE_quick_install.hiperError":"Das Netzwerk-Mapping-Programm existiert bereits und kann nicht erneut gestartet werden!","TXT_CODE_quick_install.unzipError":"Das Dekomprimieren des Archivs ist fehlgeschlagen","TXT_CODE_restart.error1":"Der Neustart-Instanzstatus ist falsch. Die Instanz wurde bereits gestartet. Der Neustartplan des letzten Status wurde abgebrochen.","TXT_CODE_restart.error2":"Der Status der Neustartinstanz ist falsch. Der Status der Instanz sollte gestoppt werden, aber jetzt wird sie ausgeführt. Der Neustartplan ist abgebrochen.","TXT_CODE_restart.restarting":"Es wurde festgestellt, dass der Server gestoppt wurde. Die Instanz wird neu gestartet.","TXT_CODE_restart.start":"Starten Sie den Instanzplan neu, um mit der Ausführung zu beginnen","TXT_CODE_router.file.off":"Administratoren haben Benutzern die Nutzung von Dateiverwaltungsfunktionen untersagt","TXT_CODE_router.initComplete":"Alle Funktionsmodule und die Berechtigungsfirewall wurden initialisiert.","TXT_CODE_router.instance.createError":"Instanz konnte nicht erstellt werden","TXT_CODE_router.login.ban":"Zu viele Verifizierungsversuche, Ihre IP-Adresse wurde für 10 Minuten gesperrt","TXT_CODE_router.login.init":"[Installation Panel] Panel-Administratorkonto wird initialisiert: {{userName}}","TXT_CODE_router.login.installed":"Das Panel wurde installiert und kann nicht erneut installiert werden. Bitte sichern und löschen Sie den Datenordner für eine Neuinstallation.","TXT_CODE_router.login.nameOrPassError":"Falsches Konto oder Passwort","TXT_CODE_router.schedule.invalidName":"Falscher Name der Projektaufgabe","TXT_CODE_router.user.deleteFailure":"Das Löschen der Benutzerdaten konnte nicht abgeschlossen werden","TXT_CODE_router.user.existsUserName":"Benutzername ist bereits vergeben","TXT_CODE_router.user.installed":"Das Administratorkonto wurde erstellt und kann nicht erneut erstellt werden.","TXT_CODE_router.user.invalidPassword":"Falsches Passwortformat","TXT_CODE_router.user.invalidUserName":"Falsches Benutzernamenformat","TXT_CODE_router.user.passwordCheck":"Das Passwort ist falsch. Es muss Groß- und Kleinbuchstaben sowie Zahlen enthalten und zwischen 9 und 36 lang sein.","TXT_CODE_start.instanceMaturity":"Die Ablaufzeit der Instanznutzung ist abgelaufen und die Instanz kann nicht mehr gestartet werden.","TXT_CODE_start.instanceNotDown":"Die Instanz wird nicht heruntergefahren und kann nicht mehr gestartet werden","TXT_CODE_start.startInstance":"Beginnend...","TXT_CODE_stream_router.IGNOREAccess":"Unautorisierter Zugriff","TXT_CODE_stream_router.authSuccess":"Sitzung {{id}} {{address}} Überprüfung des Datenflusskanals erfolgreich","TXT_CODE_stream_router.disconnect":"Sitzung {{id}} {{address}} hat den Datenkanal von {{uuid}} getrennt","TXT_CODE_stream_router.establishConnection":"Sitzung {{id}} {{address}} hat einen Datenkanal mit {{uuid}} eingerichtet","TXT_CODE_stream_router.instanceNotExist":"Instanz existiert nicht","TXT_CODE_stream_router.taskNotExist":"Aufgabe existiert nicht","TXT_CODE_stream_router.unauthorizedAccess":"Unautorisierter Zugriff","TXT_CODE_systemRemoteService.autoCheckDaemon":"Lokaler Daemon erkannt, erhält automatisch Schlüssel und Verbindungsport ...","TXT_CODE_systemRemoteService.error":"Die lokale Daemon-Konfigurationsdatei kann nicht automatisch abgerufen werden. Gehen Sie zu https://docs.mcsmanager.com/, um mehr zu erfahren.","TXT_CODE_systemRemoteService.loadDaemonTitle":"Versucht, den lokalen Daemon {{localKeyFilePath}} zu lesen","TXT_CODE_systemRemoteService.nodeCount":"Anzahl entfernter Knoten: {{n}}","TXT_CODE_systemUser.userCount":"Anzahl der Benutzer auf diesem Computer: {{n}}","TXT_CODE_system_file.execLimit":"Maximale Dateibearbeitungsgrenze überschritten","TXT_CODE_system_file.illegalAccess":"Falscher Zugriffspfad","TXT_CODE_system_file.unzipLimit":"Die Dateidekomprimierung unterstützt nur die Dekomprimierung von Dateien bis zu {{max}} GB. Wenn Sie die Obergrenze ändern müssen, gehen Sie bitte zur Datei data/Config/global.json.","TXT_CODE_system_instance.autoStart":"Der automatische Startbefehl für die Instanz {{name}} {{uuid}} wurde ausgegeben","TXT_CODE_system_instance.autoStartErr":"Instanz {{name}} {{uuid}} Fehler beim Autostart: {{reason}}","TXT_CODE_system_instance.checkConf":"Bitte überprüfen oder löschen Sie die Datei: data/InstanceConfig/{{uuid}}.json","TXT_CODE_system_instance.readInstanceFailed":"{{uuid}} Anwendungsinstanz konnte nicht gelesen werden: {{error}}","TXT_CODE_system_instance.uuidEmpty":"Es kann keine Instanz hinzugefügt werden, da die Instanz-UUID leer ist","TXT_CODE_system_instance_control.crateSuccess":"Projektaufgabe {{name}} erstellen abgeschlossen","TXT_CODE_system_instance_control.crateTask":"Geplante Aufgabe {{name}} erstellen:\\n\\n{{Aufgabe}}","TXT_CODE_system_instance_control.crateTaskErr":"Fehler bei der Erstellung der geplanten Aufgabe, falscher Zeitausdruck:\\n\\n{{name}}: {{timeArray}}\\n\\nBitte versuchen Sie, die Datei data/TaskConfig/{{name}}.json zu löschen, um dieses Problem zu lösen","TXT_CODE_system_instance_control.execCmdErr":"Beispiel für einen Ausführungsfehler der geplanten Aufgabe {{uuid}} {{name}}:\\n \\n{{Fehler}}","TXT_CODE_system_instance_control.execLimit":"Die Erstellung geplanter Aufgaben kann nicht fortgesetzt werden, um die Obergrenze zu erreichen","TXT_CODE_system_instance_control.existRepeatTask":"Es sind bereits doppelte Aufgaben vorhanden","TXT_CODE_system_instance_control.illegalName":"Falscher Projektname, unterstützt nur Unterstriche, Zahlen, Buchstaben und einige lokale Sprachen","TXT_CODE_ui.help":"[Konsole] Der Daemon verfügt über grundlegende interaktive Funktionen. Bitte geben Sie „Hilfe“ ein, um weitere Informationen anzuzeigen","TXT_CODE_version.versionDetectErr":"Die Versionsprüfung ist fehlgeschlagen"}');

/***/ }),

/***/ "../languages/en_US.json":
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"TXT_CODE_00000001":"Welcome to MCSManager Panel","TXT_CODE_10088738":"Confirm deletion","TXT_CODE_10150756":"Event-Triggered Task","TXT_CODE_10194e6a":"Network Aliases","TXT_CODE_10430e01":"Outpost Seed","TXT_CODE_1049cbd1":"Whether the server should output debug-level messages related to system operations.","TXT_CODE_10693964":"Any Program","TXT_CODE_107695d":"All Games","TXT_CODE_108ce2e4":"Width:","TXT_CODE_10a6d36f":"Used to display and interact with the console of a specific instance.","TXT_CODE_10cc2794":"Network architecture description","TXT_CODE_10eeb359":"Maximum ambient creatures (e.g., bats) that can spawn per world.","TXT_CODE_10efed7c":"Set to false to keep coral alive when placed on land","TXT_CODE_1135828":"Wheat Growth Speed","TXT_CODE_1155db3a":"Allow GameSpy4 Protocol","TXT_CODE_115e891f":"Disable snowball spawns.","TXT_CODE_115e8a25":"Variable Value","TXT_CODE_11673d8c":"Successfully Logged Out","TXT_CODE_116db655":"Plays a burp sound after a player fills the hunger bar completely by eating","TXT_CODE_1181762b":"Fixed Chunk Resident Time","TXT_CODE_11cba563":"If a chicken is hit, it will attack back","TXT_CODE_11cfe3a1":"Instance Shutdown Command","TXT_CODE_11d2ab6b":"RGB values for broadcast message colors.","TXT_CODE_11d5caea":"Create Account","TXT_CODE_11dd341b":"Set to false to disable the players\' ability to skip the night by sleeping","TXT_CODE_11ecd5a9":"Unknown error","TXT_CODE_11f8cc36":"Tab-Completion Abuse Limit","TXT_CODE_12040bf0":"The port number must be within the range of 0-65535","TXT_CODE_123bcd09":"Create Custom Environment Image Using DockerFile","TXT_CODE_12413b31":"Maximum monsters that can spawn per world","TXT_CODE_125812c9":"The gradient of <text> when fill-mode is \'medium\'","TXT_CODE_129475a7":"Reason for kicking hardcore players.","TXT_CODE_1295831e":"If the color rendering feature conflicts with the software\'s built-in color functionality, you can disable this feature.","TXT_CODE_12e3afa9":"A crucial configuration for Minecraft server, where most common settings (such as port, player count, render distance, etc.) can be configured.","TXT_CODE_1301e748":"Fix Invulnerable End Crystals Vulnerability","TXT_CODE_13411df7":"SSO login failed, please return to the original page and try to log in again!","TXT_CODE_1348332a":"Control whether the dragon egg will teleport when hit","TXT_CODE_13663120":"For example: without filling in parameters, the \'Terminal Card\' can only be used on the \'Instance\' page.","TXT_CODE_1396f33c":"Whether a cactus will break from a solid block next to it","TXT_CODE_139ef152":"Configuration Version. Do not change this.","TXT_CODE_13aa13dd":"Track Plugin Scoreboards","TXT_CODE_13ae6a93":"Copy","TXT_CODE_13dfc5cb":"History Length","TXT_CODE_13eac7e1":"Package Download URL (Optional)","TXT_CODE_143db7d9":"7zip decompression completed: {{result}}","TXT_CODE_143e55cb":"Item Description Line Count ID","TXT_CODE_143f213e":"Vine Growth Speed","TXT_CODE_144caddf":"Fix spawners not spawning water animals correctly; MC-238526","TXT_CODE_14688b70":"Gives you the ability to control how long a player is invulnerable when they first spawn in.","TXT_CODE_1471ac98":"Set to true for foxes to bypass the mob griefing gamerule","TXT_CODE_147a2f87":"Actual required time depends on your internet and processor speed. Please be patient.","TXT_CODE_148d6467":"Stop Instance","TXT_CODE_15022f3e":"Use Display Name in Quit Message","TXT_CODE_1514d08f":"Commands have been successfully sent to the remote hosts. The operation may take a while, please wait a moment before checking the results","TXT_CODE_153f705d":"Remove Card","TXT_CODE_1544562":"Payload","TXT_CODE_1548649e":"Edit scheduled tasks","TXT_CODE_154cd636":"The cooldown of the dolphin spit","TXT_CODE_1556989":"The label content is too long. Please reduce the number of characters.","TXT_CODE_1561198c":"Once the file is uploaded, it will be decompressed and an instance will be created. This may take some time","TXT_CODE_1562f6cf":"All installation operations have been completed. Please try to start the instance...","TXT_CODE_157e06a9":"Maximum Players Displayed on the TAB List","TXT_CODE_1594de63":"If we don\'t have the language requested by the client, use this default language.","TXT_CODE_159f0203":"Monster Tracking Range","TXT_CODE_15a381d5":"New Daemon","TXT_CODE_15c07350":"Compression/decompression task timed out, terminated!","TXT_CODE_15c6d4eb":"Reset Successful","TXT_CODE_15c747a6":"Delay in ticks between physics/flowing (lower is faster)","TXT_CODE_15e80e9d":"The step height in which a minecarts can go up to the next block without jumping","TXT_CODE_15f2e564":"Stopped","TXT_CODE_15f5fb07":"Assigned starting port","TXT_CODE_163e2d0a":"Display instance specifications when merchant mode is enabled","TXT_CODE_1644b775":"New Task","TXT_CODE_1648c9ea":"Display merchant information when merchant mode is enabled","TXT_CODE_16853efe":"Change Permissions","TXT_CODE_16b4f026":"Silent command block console","TXT_CODE_16d71239":"Dashboard","TXT_CODE_16da1c76":"Hopper Transfer Rate","TXT_CODE_16e2615":"The death message that appears when the player is killed because they were standing on a stonecutter","TXT_CODE_16e58cc1":"Remove End Dragons","TXT_CODE_16f55a9b":"File decompression started. It may take some time.","TXT_CODE_1704ea49":"Install","TXT_CODE_172c745e":"Allows the ability to increase enchantments passed their maximum level. For example, efficiency V + efficiency V = efficiency VI.","TXT_CODE_1732276b":"The distance at which the snow golem will attack","TXT_CODE_17544b7b":"Unable find the server core, please provide the startup command manually.","TXT_CODE_175b570d":"Starting","TXT_CODE_176b2151":"Set this to true to enable advertising the dedicated server to local LAN clients so that it shows up in the Multiplayer screen automatically.","TXT_CODE_1770c716":" The amount of obsidian required to damage an anvil","TXT_CODE_179d7be4":"Enable Rcon Protocol","TXT_CODE_179e8e0":"Player Tracking Range","TXT_CODE_179eb7ce":"Max Simultaneously Generated Chunks per Player","TXT_CODE_17b3748b":"Check Purchase History","TXT_CODE_17be5f70":"Image name cannot be empty!","TXT_CODE_17cbacf6":"Ban players if they place more than this number of tiles in 1 second.","TXT_CODE_17f1f440":"MySQL database address.","TXT_CODE_180884da":"Enable Merchant Mode","TXT_CODE_181c72ba":"No suitable template found? Customize a template configuration.","TXT_CODE_181f2f08":"Unable to retrieve remote daemon information","TXT_CODE_187bb567":"All instances have been shut down, exiting program...","TXT_CODE_188c7493":"Disable Progress Saving.","TXT_CODE_18b3d541":"Whether beds explode when a villager sleeps in one.","TXT_CODE_18b94497":"System Requirements","TXT_CODE_18cdc17f":"Edit Title","TXT_CODE_18d2f8ae":"Are you sure you want to delete this instance and its files? This operation will delete all files in the instance directory, please proceed with caution","TXT_CODE_18de069c":"Allows the looting enchantment on shears","TXT_CODE_18df7f10":"Please select your server program type","TXT_CODE_18e7e5df":"Environment Variables (Optional)","TXT_CODE_190ecd56":"Unix Load Average","TXT_CODE_19140a89":"Set to true to make upward bubble columns generate instead of downward bubble columns when magma blocks are placed/generated under water-source blocks.","TXT_CODE_192078c6":"Whether to kick players who exceed the TilePaint threshold.","TXT_CODE_192b48f0":"Server Restarting","TXT_CODE_193297ed":"Potato Growth Speed","TXT_CODE_1934114b":"Entrance card for configuring instances, terminal settings, and other functions.","TXT_CODE_193605ab":"Set to true to make enderman ignore players that wear the dragon head","TXT_CODE_193f5347":"Wither spawn sound effect radius","TXT_CODE_195215f7":"The projectile offset of a throwable-potion","TXT_CODE_196253a2":"Should we authenticate players with Mojang? By default, this option is enabled.","TXT_CODE_196d6257":"The equation to use for calculating a shulker spawning from a bullet (nearby is the amount of shulker entities nearby) Make this blank to always spawn if there\'s a shulker nearby","TXT_CODE_1981470a":"If you choose to delete the instance-related files at the same time, the entire directory where the instance is located will be directly deleted.","TXT_CODE_1987587b":"Required, 3 to 12 characters, supports any language","TXT_CODE_19cada2a":"Interval in seconds to ping remote servers.","TXT_CODE_19f697f3":"I\'m aware that I might be hacked! \\nIgnore the risks!","TXT_CODE_1a0ab98b":"RCON Access Password (see enable-rcon)","TXT_CODE_1a124d6":"Setting this to false prevents keeping arrows alive indefinitely (such as when the block the arrow is stuck in gets removed, like a piston head going up/down).","TXT_CODE_1a37f514":"Map container processes to use the host\'s actual ports.","TXT_CODE_1a499109":"File does not exist","TXT_CODE_1a6bacc6":"Log Player Client Ping Requests to BungeeCord Console","TXT_CODE_1a6d30de":"Prevent softcore players from connecting.","TXT_CODE_1a730d48":"The configuration file is empty, please check if the file is correct, or click the \'Edit Source File\' button above to continue editing.","TXT_CODE_1a77954":"The maximum amount of ticks to randomly choose from when curing","TXT_CODE_1a8cf808":"Ocean Monument Seed","TXT_CODE_1ac19459":"Creative Mode Arrow Disappearance Rate","TXT_CODE_1adaa4f4":"Animals Awakened Every x Ticks","TXT_CODE_1af148fe":"Duplicate File Exists","TXT_CODE_1b1b2934":"Failed to send RCON command due to incorrect password, please check the access password set in the Steam Rcon protocol!","TXT_CODE_1b450b79":"Please Provide Directory Name","TXT_CODE_1b518dd0":"Block fall multiplier for lime bed","TXT_CODE_1b688710":"7zip decompression failed: {{message}} (details: {{details}})","TXT_CODE_1b763e24":"Display the player\'s IP upon joining to players with log permissions.","TXT_CODE_1b78c12e":"Output of <minutes> placeholder in command.uptime.format option","TXT_CODE_1b7a8832":"Operation Canceled!","TXT_CODE_1b7f826e":"The projectile offset of a crossbow","TXT_CODE_1b82883f":"What color should show when the ram usage is \'medium\'","TXT_CODE_1b858414":"Set to true for the ender dragon to gain the ability to ride vehicles","TXT_CODE_1baf656e":"Select an Existing Server Directory","TXT_CODE_1bc41425":"Option to choose whether or not to ignore creative players when spawning mobs.","TXT_CODE_1c18acc0":"Appearance","TXT_CODE_1c2efd38":"The network connection cannot be established with the remote node. Please check whether the remote node is running normally? \\nIs the network configured correctly?","TXT_CODE_1c36c8f2":"Terminate Instance","TXT_CODE_1c38439b":"Set to true for silverfish to bypass the mob griefing gamerule","TXT_CODE_1c45f7fe":"Edit Server Configuration File","TXT_CODE_1c6e2cd":"Number of mushrooms to feed a cow to make it transform into a mooshroom. Value of 0 disables feature","TXT_CODE_1c7a8f47":"The server is full!","TXT_CODE_1c84154f":"Percent chance (0.0 - 1.0) that a wolf will spawn as rabid","TXT_CODE_1cafa176":"Allows applying enchantments together that are normally incompatible. For example, protection and fire protection or fortune and silk touch.","TXT_CODE_1cd8f9d2":"Tshock Configuration File","TXT_CODE_1ce1d1d1":"Runtime Platform","TXT_CODE_1ceefd70":"Player shuffle","TXT_CODE_1cf6fc4b":"Incorrect port open configuration for this container!","TXT_CODE_1d1ec400":"Decompression timed out","TXT_CODE_1d39feca":"Geyser Standalone Server Configuration File with basic settings (such as port, max players, etc.) and advanced parameters (block cache, thread count, etc.).","TXT_CODE_1d67c9c6":"Limit Login Attempts from the Same IP","TXT_CODE_1d7a8617":"Spawn Protection Radius (radius is calculated by 2x+1, set to 0 to protect only the block under spawn point)","TXT_CODE_1d8746ed":"Set to true for mending enchantment to always repair the most damaged equipment first","TXT_CODE_1d8f3c33":"Network Error","TXT_CODE_1d9d0746":"UUID","TXT_CODE_1dc0000f":"The actionbar message that appears when a player tries to sleep, but the playersSleepingPercentage gamerule is set to a value greater than 100. Set to \'default\' to let the clients use their own translatable components. Set to an empty string to disable it.","TXT_CODE_1dc16497":"Max Chunk Sending Rate per Player","TXT_CODE_1deaa2dd":"Users","TXT_CODE_1df9fbd5":"Import","TXT_CODE_1e03347e":"External access port: {{- host}} -> Internal container port: {{- container}} / Protocol: {{- protocol}}","TXT_CODE_1e08ca6b":"Stronghold Fortress Seed","TXT_CODE_1e0b63b6":"Blank File","TXT_CODE_1e1dfbbe":"Different types have different functionalities. If unsure, you can choose a more abstract type, such as Minecraft Java Edition.","TXT_CODE_1e58bb5e":"Minecraft End User License Agreement (EULA)","TXT_CODE_1e9c479e":"No","TXT_CODE_1ed0031c":"Underwater Entity Activation Range","TXT_CODE_1eea2726":"Makes the arms visible when placed","TXT_CODE_1efc7c5f":"Common Configuration File of a NeoForge Server","TXT_CODE_1f2062c7":"Required, 9 to 36 characters, must include uppercase and lowercase letters, and numbers","TXT_CODE_1f224bef":"Disable Saving Metrics Data","TXT_CODE_1f246be3":"Min Height:","TXT_CODE_1f2d95eb":"Set to false to use <mob>.ridable-in-water options instead of the DISMOUNTS_UNDERWATER tag","TXT_CODE_1f3aac40":"Disables Optimized DFU client-side - already disabled on servers","TXT_CODE_1f600912":"Should damage be ignored while in lava if damage-if-sprinting is enabled","TXT_CODE_1f61e5a3":"Edit Source File","TXT_CODE_1f62022c":"Lets you change the color of the shulker by right-clicking it with a dye","TXT_CODE_1f991d":"The amount of damage to give if damage-if-sprinting is enabled","TXT_CODE_1fbf74d9":"Force Player Teleport to Default Server on Each Login","TXT_CODE_1fc10e3b":"Enable Whitelist","TXT_CODE_1fe2257b":"Perform Username Validation","TXT_CODE_1fec78cc":"Set this to true to check the entire entity\'s collision bounding box for ladders instead of just the block they are in. Causes noticeable differences in mechanics so default is vanilla behavior. Default: false.","TXT_CODE_20053f37":"Block fall multiplier for light gray bed","TXT_CODE_201bc643":"No Protection","TXT_CODE_2029027e":"Incorrect port open configuration for this container, no values exist on either side of the separator!","TXT_CODE_2033383b":"Delay between waves. Lower values mean more creatures in between waves.","TXT_CODE_2038ec2c":"Please select at least one file!","TXT_CODE_20509fa0":"Daemons","TXT_CODE_2054155a":"Maximum Height for Placing Blocks by Players","TXT_CODE_206f0c11":"Allow players to register accounts that don\'t necessarily match their character name.","TXT_CODE_2076e91e":"Display","TXT_CODE_2082f659":"Note: If this is empty, the files in the file management will not be bound to the container!","TXT_CODE_2093cc1a":"Purchase History","TXT_CODE_20bf7fdd":"The Max health equation used to calculate the max health","TXT_CODE_20ce2aae":"Build Failed","TXT_CODE_20cec54":"Carriage Return and Line Feed","TXT_CODE_20d107f1":"o true to make the max-joins-per-tick setting in paper.yml be used per second instead of per tick","TXT_CODE_20e4ab72":"Set to false to stop piglins from griefing","TXT_CODE_21077dc4":"Set how much damage a snowball does (-1 will make damage be 3 for blazes & 0 for all other entities which is default)","TXT_CODE_21b8b71a":"User permissions are for general users, while the highest permissions are for administrators","TXT_CODE_2203d4ff":"All Packet Handling Modes","TXT_CODE_221bf389":"Send fake cooldown indicators.","TXT_CODE_2222777e":"Not found in the URL address or initial settings.","TXT_CODE_22510c5c":"Login Account","TXT_CODE_2266908":"Leaves a trail where a snowman walks when being ridden","TXT_CODE_226b6c9e":"Enable endless invasion events.","TXT_CODE_22b2a206":"Disconnect Threshold","TXT_CODE_22b5f37d":"The amount of sources required to have infinite lava","TXT_CODE_22c68314":"Set to true if this mob should always drop ecperience","TXT_CODE_22cf9c9d":"Specify read timeouts for connections here. Default is thirty seconds.","TXT_CODE_2313aab2":"Enable response to GameSpy 4 query responses.","TXT_CODE_23178d7d":"Per-Chunk Entity Save Limit","TXT_CODE_233624ad":"Web access port, please enter a numerical value. The default port is 23333.","TXT_CODE_233dd4f8":"How long to delay the health regen","TXT_CODE_235cd293":"Specify which string to start the command with. If length is greater than 1, it may not work properly.","TXT_CODE_236f70aa":"Configuration","TXT_CODE_2374966e":"Change in-game chat format: {0} = group name, {1} = group prefix, {2} = player name, {3} = group suffix, {4} = chat message.","TXT_CODE_2375f010":"Reinstall","TXT_CODE_238c4c01":"Set to true for snow golems to bypass the mob griefing gamerule","TXT_CODE_2393baa2":"Cobblestone","TXT_CODE_23a3bd72":"abnormal","TXT_CODE_23b02a65":"Instance Status Query Protocol Configuration","TXT_CODE_240252a":"Forward the player count and max player count from the remote server to Bedrock players.","TXT_CODE_2415440f":"When applying enchantments together that are incompatible, instead of using the enchantment in the base item, the enchantment will be replaced by the enchantment on the secondary item.","TXT_CODE_2418225f":"For statistical purposes, please do not change or remove","TXT_CODE_2428b9c0":"The gradient of <text> when fill-mode is \'low\'","TXT_CODE_2432f4cc":"Please ensure the activation code is valid and matches the instance plan specifications.","TXT_CODE_243a463":"Server Port","TXT_CODE_2452016e":"Please manually copy the following content","TXT_CODE_2471b9c":"Search by username","TXT_CODE_247f6613":"Set to false for clerics to not throw nether wart at other villagers","TXT_CODE_24843187":"Chat prefix for the SuperAdmin group.","TXT_CODE_24873a8a":"Login Page","TXT_CODE_2493e6fc":"Use Permission for Control","TXT_CODE_2498e4ed":"Enhanced Monitoring of Server Status","TXT_CODE_249df6f2":"The maximum amount of bees allowed inside of a beehive/bee_nest","TXT_CODE_24c2172c":"Makes this mob immune to EAR (Entity Activation Range - See spigot.yml)","TXT_CODE_24c4768a":"You can download the app marketplace data source, modify it, and upload it to any server to add your own modpack to the marketplace.","TXT_CODE_24e5bff2":"Condition","TXT_CODE_25023ad0":"Allows the player to remove curse of binding armor when they have a weakness effect applied to them","TXT_CODE_2541ce4d":"How long the delay of a big dripleaf should be until it fully collapses","TXT_CODE_255606fb":"Retention time for backups (in minutes).","TXT_CODE_25699fea":"MCDReforged Server Control Tool Configuration File","TXT_CODE_256e5825":"Docker needs to be installed in advance. Then, use any image you found on DockerHub to create, install, and start the instance.","TXT_CODE_25924d5a":"Max Ticks for Entity Processing","TXT_CODE_25af3af3":"RCON Access Password","TXT_CODE_25cb04bb":"Saved to clipboard.","TXT_CODE_260d96a0":"If set to true, items given to players will go directly into their inventory. Otherwise, given items will generate as dropped items. Experimental feature, may not work correctly and may lead to item loss.","TXT_CODE_26407d1f":"Report BUG","TXT_CODE_2645196f":"Max Packet Handling Rate","TXT_CODE_26495d02":"You can enter a startup command, such as java -jar demo.jar. If no startup command is entered, the command defined inside the image will be used.","TXT_CODE_266b7246":"Quick Deployment for Minecraft","TXT_CODE_2695488c":"Please enter a username","TXT_CODE_26d7316f":"Decompression failed!","TXT_CODE_2728d0d4":"Command Helper","TXT_CODE_273d24e0":"Auto Start","TXT_CODE_2759226f":"Sugar Cane Growth Speed","TXT_CODE_27594db8":"Market","TXT_CODE_2764f197":"Please fill out the form completely","TXT_CODE_276756b2":"Are you sure?","TXT_CODE_2793b84":"Disable Teleportation Suffocation Check","TXT_CODE_2799a1dd":"Quick Start","TXT_CODE_27b7102a":"No Permission to Execute Command Message","TXT_CODE_27ecd5c9":"Spawn Delay - Ticks","TXT_CODE_27ee6bf8":"The gradient of <text> when the ram usage is \'good\'","TXT_CODE_27efac3b":"Edit Successful","TXT_CODE_27efff22":"Cave Vines Growth Speed","TXT_CODE_27f641c1":"Jungle Temple Seed","TXT_CODE_27fd08b9":"Hunger Depletion Multiplier for Other Activities","TXT_CODE_28013340":"Set to false to stop fluids from ticking.","TXT_CODE_28116f29":"Minecraft Server - Bedrock","TXT_CODE_28124988":"Program Root","TXT_CODE_2818a7bc":"Unfill","TXT_CODE_28190dbc":"Deleted","TXT_CODE_281c9d37":"Log errors","TXT_CODE_282b0721":"Steam Rcon Protocol Settings","TXT_CODE_28357e8b":"Floodgate uses encryption to ensure it is used from an authorized source. This should point to the public key generated by Floodgate (BungeeCord, Spigot, or Velocity).","TXT_CODE_2841f4a":"Please select the format of the compressed file","TXT_CODE_2864bfbc":"Instance File Management","TXT_CODE_2880eed4":"RCON Password","TXT_CODE_288830f4":"Number of seconds a player must wait before respawning. Range: 0 (default) to 15 seconds. Use at your own risk.","TXT_CODE_28bf8a1b":"Enable Timings","TXT_CODE_28bfb02":"If the ISP/AS of the client this proxy sends differs from what Mojang\'s authentication servers send, players will be kicked.","TXT_CODE_28ce635a":"No music available","TXT_CODE_28e53fed":"Manage Remote Daemon","TXT_CODE_2908dac":"Name of the custom permission file","TXT_CODE_2930907c":"Max Automatically Saved Chunks per Tick","TXT_CODE_2931127f":"PaperSpigot global configuration file that can further configure advanced parameters and more specific game settings, with a significant impact on overall performance.","TXT_CODE_2958a0f8":"Congratulations, the instance has been created successfully!","TXT_CODE_29b7eca5":"Ignore Spectator Entities","TXT_CODE_2a07bba3":"Start - Per Player","TXT_CODE_2a1fc6cc":"RCON Access Port","TXT_CODE_2a22c2ff":"No clipboard permission, please check your browser settings","TXT_CODE_2a2dfc09":"Creative Mode Players Not Affected by Phantom Attacks","TXT_CODE_2a34c50a":"Language","TXT_CODE_2a370f1c":"Set to true to allow breaking individual slabs in a double slab block while sneaking","TXT_CODE_2a379a13":"Optional, fill in according to your program, such as: -server -XXX -ZZZ, etc.","TXT_CODE_2a3b0c17":"Final Confirmation","TXT_CODE_2a4f13d4":"Radius in blocks around players to display custom heads.","TXT_CODE_2a82b720":"Percent chance (0.0 - 1.0) an entity will spawn left-handed","TXT_CODE_2a84466d":"Max Automatically Saved Players per Tick","TXT_CODE_2a8dc13f":"Used to view the status of all remote daemons connected to the panel.","TXT_CODE_2ab036a4":"Please enter the game server port","TXT_CODE_2ab3e9fd":"Deploy Console Application","TXT_CODE_2abeb185":"Changing the language here will synchronize it for all nodes and all users.","TXT_CODE_2ad9f3a0":"How big should Minecraft packets be in bytes before we compress them? Set to zero to compress all packets, set to -1 to completely disable compression.","TXT_CODE_2af87548":"All Versions","TXT_CODE_2b221e02":"Instance will run in a \\"sandbox\\".","TXT_CODE_2b524bbf":"Set to true for each gamemode to require its own permission","TXT_CODE_2b5fd76e":"Sent start command","TXT_CODE_2b9e9b5":"Limit the container to run on specified CPU cores.","TXT_CODE_2ba4bf6f":"Number of failed insertions before falling back to text logs for SQL logs.","TXT_CODE_2bcc4e34":"Will automatically save after uploading","TXT_CODE_2be83d36":"The decompression and compression program is abnormal. Make sure the file you want to process exists and is legal. Please try again later!","TXT_CODE_2bfc02ef":"Forward the server protocol name (e.g., BungeeCord [X.X], Paper 1.X) from the remote server.","TXT_CODE_2c1337d":"Tag list of this instance","TXT_CODE_2c194599":"Announce on save.","TXT_CODE_2c19f3b2":"The amount at which this effect affects entities","TXT_CODE_2c41a36d":"Maximum MTU supported by the Internet is 1492, but this may cause packet fragmentation issues.","TXT_CODE_2c4d586f":"Generate Structures (e.g., villages) on World Generation (dungeons and strongholds still generate if disabled)","TXT_CODE_2c69ab15":"Logout","TXT_CODE_2c7bcdfa":"1. Everyone can access this page, and you can place cards with any level of permissions.","TXT_CODE_2c9083a1":"Select Instance","TXT_CODE_2ca42b39":"Displays specified text, supports Markdown syntax","TXT_CODE_2ce63943":"Early Window starts maximized","TXT_CODE_2ce953da":"Unknown Configuration File","TXT_CODE_2cf59872":"Open Page","TXT_CODE_2cfbaa90":"Radius villagers search for existing iron golems before spawning more. Value of 0 disables features","TXT_CODE_2d542e4c":"Task Name","TXT_CODE_2d8a400":"Secondary Category (Version Type)","TXT_CODE_2db37427":"PlaceRecipePacket Handling Interval","TXT_CODE_2dbd3cd3":"Enter the merchant console","TXT_CODE_2dc23f7a":"Select Decompression Encoding","TXT_CODE_2de4c590":"Output of <day> placeholder in command.uptime.format option","TXT_CODE_2de92a5d":"Please select a node before installing!","TXT_CODE_2debc7ae":"Hardcore Mode (automatic ban upon death)","TXT_CODE_2e0e1dfa":"Sentry DSN for improved error logging, leave blank to disable","TXT_CODE_2e4469f6":"Available Ports:","TXT_CODE_2e5d3d0f":"Owner","TXT_CODE_2e660675":"A list of entities to ignore for activation","TXT_CODE_2ea7af21":"What is Docker? Why do you need it?","TXT_CODE_2ee6fd18":"When accessing panel from","TXT_CODE_2efcbf1e":"Output Encoding","TXT_CODE_2f07d608":"Interval between client connection attempts","TXT_CODE_2f09a53c":"Addresses MC-163962 where villager demand decreases indefinitely. Paper adds a patch to fix this by preventing demand from going below zero. This option allows the minimum demand to be configurable.","TXT_CODE_2f291d8b":"Instance Type","TXT_CODE_2f59807a":"Server address","TXT_CODE_2f87036a":"Scale of the Mob","TXT_CODE_2f900008":"Nether Fortress Seed","TXT_CODE_2fa46b8c":"Downloading image file. Image name:","TXT_CODE_2fb14927":"This error usually means that the web page cannot connect directly to the backend process. If you have port forwarding, mapping, reverse proxy, please check the configuration!","TXT_CODE_2fb7e284":"BungeeCord Enable Online Mode","TXT_CODE_2fe0cc84":"Please select a day of the week","TXT_CODE_2fe6e00e":"If the player is stuck inside a portal with no way of getting out, walking to another block will reset the portal cooldown, allowing them to teleport back through the portal","TXT_CODE_30051f9b":"Instance ID: ","TXT_CODE_300c2ff4":"Daemon Key","TXT_CODE_30258325":"Container Directory","TXT_CODE_3036d123":"Correct the client\'s player position to the server\'s player position when the movement value exceeds the threshold","TXT_CODE_30aa5133":"IP address of the Java server.","TXT_CODE_30fcc19a":"User <<operator_name>> modified the configuration of the <<instance_name>> instance","TXT_CODE_30fe1717":"Optional, e.g., 0,1,2,3","TXT_CODE_31145b04":"retrying {retries}/{maxRetries}","TXT_CODE_311b2d6b":"Weaken creatures spawned by spawners","TXT_CODE_312cd9f0":"PlaceRecipePacket Handling Mode","TXT_CODE_313db7d2":"Fossil Seed","TXT_CODE_314aa817":"Forward hostname resolution for Bedrock Edition clients connecting to Java servers","TXT_CODE_317e0cc1":"Other Tracking Range","TXT_CODE_3183c301":"Lightning Strike Probability","TXT_CODE_31a1d824":"Advanced Settings","TXT_CODE_31a48870":"User <<operator_name>> attempted login, result: <<login_result>>","TXT_CODE_31c10b14":"Set to true for the fire resistance potion effect to show particles","TXT_CODE_31c5a4d0":"Web Shell","TXT_CODE_31edf78":"Set to false to stop zombified piglins from dropping XP if they were angered (but not killed) by a player","TXT_CODE_320f4304":"Server File Directory","TXT_CODE_3243b4f8":"Piglin Guard Chests","TXT_CODE_3247f016":"The amount of sources required to have infinite water","TXT_CODE_328191e":"Maybe useful in a multi-IP environment.  If there\'s only one IP available on the host, please leave it empty.","TXT_CODE_329fb904":"To a new dir","TXT_CODE_32bf92a1":"How many NPCs can be generated within 600 pixels of a player before generating stops. Default is 6.","TXT_CODE_32cd41d5":"Downloading file...","TXT_CODE_32d87bf1":"Most Steam game servers require RCON protocol to support command execution, including Minecraft game servers. If you find that the built-in console cannot execute commands when running a Steam game server, try configuring RCON protocol to support command execution.","TXT_CODE_32eb350b":"If this setting is true, the server will run faster after a lag spike in","TXT_CODE_3354b56e":"Log Player-Entered Commands to Console (BungeeCord Commands Only)","TXT_CODE_335ba209":"Choose File","TXT_CODE_3362d4b7":"Create New Image","TXT_CODE_3371000d":"The panel is already installed and cannot be reinstalled.","TXT_CODE_3378e8a5":"What should the max player count display? (Velocity does not support an online player cap.)","TXT_CODE_337da349":"Start Time - Day","TXT_CODE_33a09033":"Players: ","TXT_CODE_33c223c":"Ignore checks to see if players \'can\' update projectiles.","TXT_CODE_33ce1c5c":"Pass environment variables to the container","TXT_CODE_33d91ef6":"Whether or not books should be writeable.","TXT_CODE_34071701":"Experience orb merge radius","TXT_CODE_3407250a":"Mount host instance directory to container for data persistence","TXT_CODE_34100777":"Set to false to stop the villager from displaying the trade item","TXT_CODE_34148d2b":"Set to true for the particle effects to be less intrusive on the screen","TXT_CODE_341bc7f3":"Scale attribute","TXT_CODE_341dfd11":"Early window height","TXT_CODE_342a04a9":"Under Maintenance","TXT_CODE_342d5959":"The damage of the dolphin spit","TXT_CODE_34611898":"Startup","TXT_CODE_347ff81c":"Allow players to use leads on wandering traders","TXT_CODE_3489786b":"Use permission nodes to determine the number of rows. By default, with this setting enabled, all players have six rows unless otherwise specified using permissions.","TXT_CODE_348c9098":"Failed to obtain the details of the specified instance, please try again!","TXT_CODE_34999278":"The interval in ticks to check if the villager is lobotomized","TXT_CODE_349edc57":"Please select a time","TXT_CODE_3502273d":"Add Scheduled Task","TXT_CODE_351aaf7":"Get Started","TXT_CODE_354409b6":"Server overload warning","TXT_CODE_3549ea82":"Max amount of interval ticks that get shot","TXT_CODE_3554dac0":"Trigger Time","TXT_CODE_3579ab7d":"Allows applying enchantments on tools or armour that are normally not applicable. For example, sharpness on a pickaxe.","TXT_CODE_35d2ee7a":"Using 7zip to decompress to specified directory: {{command}}","TXT_CODE_35d52619":"Chance for flowering azalea to grow into trees naturally","TXT_CODE_361a79c6":"Image download terminated!","TXT_CODE_36417656":"To Terminal Page","TXT_CODE_365aabd4":"Line Feed","TXT_CODE_36622cee":"Set to true to give night vision to riders while on a ridable","TXT_CODE_366bad15":"Please enter the name for the archive.","TXT_CODE_369a4a22":"Reserved slots. The number of reserved slots players with more than the maximum server slots can join.","TXT_CODE_36b878dc":"Packet Handling Interval","TXT_CODE_36cae384":"You are using a private IP address","TXT_CODE_3725b37b":"Ctrl+C has been sent!","TXT_CODE_372e7b9c":"Click \\"Image\\" to browse templates in the current category, click \\"Install\\" to edit template info, and click \\"Batch Edit\\" to delete items.","TXT_CODE_372e97f4":"Allow CorruptionSpread when the world is in hard mode.","TXT_CODE_3752d436":"Output of <hour> placeholder in command.uptime.format option","TXT_CODE_37658aab":"The modifier value of snow-ball projectiles","TXT_CODE_377a62dc":"Set to true to place fire when the end-crystal explodes","TXT_CODE_377e142":"File compression started. It may take some time.","TXT_CODE_377e5535":"Please enter the directory name","TXT_CODE_3790ec90":"Whether to Send Namespace Command","TXT_CODE_37924654":"Please re-enter the new password","TXT_CODE_37931fa9":"Armor toughness attribute","TXT_CODE_379fa48a":"Selected","TXT_CODE_37a4c14a":"No available configuration file found","TXT_CODE_37d67b69":"Max TNT per tick","TXT_CODE_37d839a4":"The decompression/compression program failed to start! Please make sure the files in the daemon/lib directory exist and have correct permissions! If it still doesn\'t work, please reinstall the panel","TXT_CODE_37f5901":"Beetroot Growth Speed","TXT_CODE_38091a03":"Zombie is hostile towards villagers","TXT_CODE_3816e0d9":"Set to false to stop the enderman from griefing.","TXT_CODE_381f8f22":"Product List","TXT_CODE_382ec256":"The minimum amount of ticks to randomly choose from when curing","TXT_CODE_384d278f":"User <<operator_name>> deleted the daemon process <<daemon_id>>","TXT_CODE_3855e22f":"Unban the IP if the ban command is passed without any parameters.","TXT_CODE_38591f72":"Specific Time","TXT_CODE_386f2d66":"Command delivered but no response received, please check in-game.","TXT_CODE_3897eb89":"Max Simultaneously Loaded Chunks per Player","TXT_CODE_38a430d8":"Select the network mode for container access, such as bridge mode.","TXT_CODE_38fb23a8":"Download started...","TXT_CODE_393c816c":"Page Not Found","TXT_CODE_3969cb6b":"Auto-Config Send Distance","TXT_CODE_397667ff":"Log villager death events","TXT_CODE_39994770":"Players","TXT_CODE_39a3ba38":"Village Seed","TXT_CODE_39abde23":"Kelp Growth Speed","TXT_CODE_39ac8ed3":"Easy","TXT_CODE_39bb14c1":"Message that shows when a player is kicked for having an unverified username (user is in offline-mode). Setting as \'default\' displays the default message \'Failed to verify username!\'","TXT_CODE_39c5229e":"Edit Daemon Information","TXT_CODE_39e7fa63":"Allow Grinder to Exceed Stack Limit","TXT_CODE_3a056dc8":"Usernames support any language, please ensure the security of your password.","TXT_CODE_3a24c7a3":"The effective radius of the conduit for every seven blocks in the frame","TXT_CODE_3a302f23":"Manual","TXT_CODE_3a3f9a57":"A crucial configuration for the Minecraft Bedrock server, where most common settings (such as port, player count, render distance, etc.) can be configured.","TXT_CODE_3a406403":"Status Query","TXT_CODE_3a51d817":"The amount of darkness in the sky (5 is dark enough for thunderstorms, but not regular rain)","TXT_CODE_3a5b3d2d":"MySQL database password.","TXT_CODE_3a5c9779":"Setting this to true makes it so lapis lazuli can stay in the enchanting table slot, so you can leave your lapis lazuli in the table","TXT_CODE_3a818e91":"Back to Image List","TXT_CODE_3a8fdbf1":"Stops the farmland from getting trampled if a fence or a cobble wall is placed directly underneath it","TXT_CODE_3aa9f36":"Illegal characters detected in the file name for compression or decompression, please rename and change the file!","TXT_CODE_3ae0276b":"Please enter the access password for the game server\'s RCON protocol, usually found in the configuration file.","TXT_CODE_3aec94fb":"ZIP file decompression failed. Possible reasons:\\n1. File is corrupted or password-protected\\n2. If this is a multi-volume archive (zip+z01+z02, etc.), 7zip support needs to be enabled\\n3. Incorrect file format\\nPlease check the file or contact the administrator to enable 7zip functionality for better archive support.","TXT_CODE_3b1bb444":"Min","TXT_CODE_3b1cc020":"Cancel","TXT_CODE_3b24a247":"Click the Save button in the upper right corner to save the layout design.","TXT_CODE_3b346a65":"Whether region protection should apply to chests.","TXT_CODE_3b4260f8":"How many NPCs total can be generated by statues before generating stops. Default is 10.","TXT_CODE_3b4b656d":"About","TXT_CODE_3ba5ad":"Login","TXT_CODE_3bb646e4":"Please Select","TXT_CODE_3bdd7af8":"Please select output encoding","TXT_CODE_3be23278":"Whether the explosion can cause fire or not","TXT_CODE_3beb6e5c":"Set how long the daylight cycle is ticked","TXT_CODE_3bfb9e04":"The target instance does not exist!","TXT_CODE_3c37583b":"Directories under file management will be mounted to this directory inside the container","TXT_CODE_3c8fd4c2":"Display Name","TXT_CODE_3c93920b":"Normal users are allowed to use the reinstallation function","TXT_CODE_3ccb26e":"Community Edition","TXT_CODE_3d046b93":"Control whether coordinates are displayed to players.","TXT_CODE_3d07fa74":"Stops the enderman from being immune to projectiles","TXT_CODE_3d0885c0":"Platform","TXT_CODE_3d09f0ac":"Create Image","TXT_CODE_3d14442a":"Create environment image using DockerFile. It is recommended ONLY for experienced user.","TXT_CODE_3d45d8d":"Add Template","TXT_CODE_3d4e1594":"Max PlaceRecipePacket Handling Rate","TXT_CODE_3d56da34":"Template Author / Provider","TXT_CODE_3d602459":"Instances Status","TXT_CODE_3d68e43b":"Two-factor authentication code is incorrect","TXT_CODE_3d7fbe30":"Steam Game Server","TXT_CODE_3d94ea16":"The node Socket is abnormal, please try to reconnect in the node management!","TXT_CODE_3da5e4e":"Whether to allow beacon effects to activate when it\'s covered by tinted glass","TXT_CODE_3dbf8890":"Maximum height this mob can fly to while being ridden","TXT_CODE_3dd66d98":"New tag","TXT_CODE_3dee9250":"Set to true for turtle eggs to bypass the mob griefing gamerule","TXT_CODE_3df4beaf":"Enable Linux Packet Receive/Send Optimization [Linux Only]","TXT_CODE_3e252bc9":"Size of invasion events.","TXT_CODE_3e4e61b3":"Set to true for phantoms to shoot flames on swoop","TXT_CODE_3e68ca00":"Additional Mount points","TXT_CODE_3e724e40":"Baby Zombie Movement Adjustment","TXT_CODE_3e83082b":"Allow Signs to be Used in Respawn Protected Areas","TXT_CODE_3e93e31e":"Used when reusing ports. In most cases, no configuration is required here","TXT_CODE_3e959ce7":" compression/decompression tasks running...","TXT_CODE_3e98e22f":"Number of login failures a player can have before being kicked.","TXT_CODE_3eb58633":"Can be used for automatic recovery after crashes.","TXT_CODE_3ecee271":"These selectable tags are calculated from the instance list of the current page and do not include all existing tags. A maximum of 30 are displayed here","TXT_CODE_3ed96265":"Embedded Web Card","TXT_CODE_3ee20639":"Redemption successful, please remember the following","TXT_CODE_3ef08433":"Set to true to register unused/hidden minecraft commands. The following commands become available (along with their minecraft.command.<command_name> permission counterpart): debugconfig, serverpack, spawn_armor_trims, warden_spawn_tracker, debugmobspawning, debugpath, and raid. This list may or may not be incomplete depending on if they get removed or new ones get added in newer minecraft versions.","TXT_CODE_3efe364e":"Block","TXT_CODE_3f227bcf":"Enable merchant mode to connect to MCSManager Console for package customization and code sales","TXT_CODE_3f3e734b":"Allow banned items to be generated by group that allowed to generate such item, even if PreventBannedItemSpawn is true.","TXT_CODE_3f470950":"Maximum life a player can have before equipping buffs.","TXT_CODE_3f477ec":"Length must be 3 to 20 characters","TXT_CODE_3f59b48":"The percentage of damage a critical attack adds to the base damage","TXT_CODE_3f5a2028":"Custom Spawner Cages Use Dimension Type","TXT_CODE_3f65b1f2":"Set to false to have milk clear only negative status effects","TXT_CODE_3f678132":"Monster Activation Range","TXT_CODE_3f739f9c":"Disable hard mode.","TXT_CODE_3f810f66":"Disabled by default (0), Amount of ticks an entity will live before disappearing. Interacting with a player resets the timer","TXT_CODE_3f828072":"reaching maximum number of retries","TXT_CODE_3f99f17f":"Daemon Version","TXT_CODE_3fce7ccb":"Displays the instance status when permission allows.","TXT_CODE_3fd222b0":"Please quickly press Ctrl+C again to take effect...","TXT_CODE_3fe97dcc":"System Settings","TXT_CODE_400a4210":"Input Encoding: ","TXT_CODE_402018ce":"Category","TXT_CODE_40241d8e":"Minecraft Players Query","TXT_CODE_405cd346":"Cross-Origin Request API Interface","TXT_CODE_405d1f28":"Operator Permission Level (1-4)","TXT_CODE_40a87804":"Upload HTML File","TXT_CODE_40c2c2ee":"Interval between backups (in minutes). Backups are stored in the tshock/backups folder.","TXT_CODE_40c4894a":"Enable TCP quick open support on the proxy. Requires the proxy to run on Linux.","TXT_CODE_40ca4f2":"Update","TXT_CODE_40ee4eaf":"Generation Parallelism","TXT_CODE_4126fc53":"If the bossbar from the /compass command should show when holding a compass","TXT_CODE_413b9c01":"Node.js Version","TXT_CODE_41406a5f":"Data","TXT_CODE_4140aa4b":"Suppress errors where setBlock was detected in a far chunk","TXT_CODE_41813325":"Whether or not asynchronous mob spawning should be enabled.","TXT_CODE_41ae3d88":"Set to true to make it so you can create portals out of crying obsidian","TXT_CODE_41d79430":"Ideal for Minecraft Bedrock Edition server or other Linux programs","TXT_CODE_41dd4d19":"Official Website","TXT_CODE_41f86ac":"User <<operator_name>> deleted the task <<task_name>> of the <<instance_name>> instance","TXT_CODE_42036f92":"------ User Login Event ------","TXT_CODE_42a7759b":"The suffix that shows up on the playerlist after someone\'s name when they\'re AFK","TXT_CODE_42bcfe0c":"Terminal initialization failed, please refresh the web page and try again!","TXT_CODE_42e25bc2":"Setting this to false allows RNG manipulation. Paper patches RNG manipulation by using a shared (and locked) random source. This comes with a performance gain, but technical players may prefer to turn this off for the ability to manipulate RNG.","TXT_CODE_4306a0d0":"Online (Official) Authentication","TXT_CODE_43248597":"Paste","TXT_CODE_432cbc38":"Selected:","TXT_CODE_432cfb62":"No Configuration Files Available","TXT_CODE_43422ed3":"Java Path","TXT_CODE_434786c9":"After uploading a background image, the panel will switch to dark theme with a blurred translucent effect, you can switch back anytime.","TXT_CODE_435f4975":"Using an image from Docker Hub","TXT_CODE_438aa1":"Image Name","TXT_CODE_43984628":"Nether Wart Growth Speed","TXT_CODE_43df9305":"Unknown operation","TXT_CODE_43eedf83":"What light level the phantoms will burn at","TXT_CODE_43fcaf94":"Success","TXT_CODE_442c0649":"The max growth age that the plant can grow","TXT_CODE_443ac54f":"Enable or disable anti-cheat range checks based on player position relative to their tile placements.","TXT_CODE_44454300":"Experience Merge Cap","TXT_CODE_444db70f":"Upload a Server Core","TXT_CODE_447a9fc4":"Log path.","TXT_CODE_448d08eb":"Set to true to impose teleport restrictions on end portals. This broadcasts the EntityTeleportHinderedEvent event which gives the ability to retry teleports if they fail due to having passengers/being vehicles","TXT_CODE_448df2bd":"Password required to join the server.","TXT_CODE_449d1581":"Input and Output Encoding","TXT_CODE_449efd26":"Disable players if they send this many HealOtherPlayer packets in 1 second.","TXT_CODE_44a472a5":"Disabled Commands","TXT_CODE_44ae0e7":"Come up with a nice name!","TXT_CODE_44c67809":"Skip specific GL versions, may help with buggy graphics card drivers","TXT_CODE_44f46508":"Block fall multiplier for green bed","TXT_CODE_450481c5":"This card cannot be previewed when editing, please fill in all relevant parameters for it to function properly.","TXT_CODE_451f9968":"Restrict Zombie Piglins to use Nether Portals","TXT_CODE_45364559":"Please provide URL","TXT_CODE_458c34db":"Sample Link","TXT_CODE_458df26d":"Disable Player Data Saving","TXT_CODE_45d7b982":"Failed to request plan details. Please try again later!","TXT_CODE_45e8f121":"Extra Tags (Optional)","TXT_CODE_4600deb7":"Any Console Program","TXT_CODE_46039f9b":"Please select a runtime platform","TXT_CODE_461d1a01":"Search by daemon name","TXT_CODE_462ba96":"UUID for this server. Do not modify.","TXT_CODE_463375d2":"About This Page","TXT_CODE_46410888":"Whether phantoms avoid players with a torch in their hand","TXT_CODE_46ba576a":"Set to false to disallow armorstands from moving","TXT_CODE_46bb965":"Deploy Steam Game Server","TXT_CODE_46c4169b":"Cut","TXT_CODE_46c48969":"It looks like you are trying to use HTTPS, but we cannot connect to the daemon using the WSS protocol. Please try to connect to the daemon using the WSS:// protocol.","TXT_CODE_46c4e9ac":"Write","TXT_CODE_46cb40d5":"Donate","TXT_CODE_46f575ae":"Last Start: ","TXT_CODE_47071ef6":"Time before arrow disappears","TXT_CODE_47129a5b":"Leave blank to automatically use localhost as the host address.","TXT_CODE_47203b64":"All Systems","TXT_CODE_4745436a":"Villagers will be tempted by emerald blocks and follow players holding them","TXT_CODE_47491a7e":"What color should show when fill-mode is \'medium\'","TXT_CODE_475c5890":"For example: My First Server","TXT_CODE_47667d86":"Allow third-party deadmau5 ears to be visible.","TXT_CODE_4770de17":"Merchant Info","TXT_CODE_477ece61":"Installation Complete","TXT_CODE_478717e2":"This is the message that gets broadcasted when a user goes AFK (must have player-idle-timeout set greater than 0 & kick-if-idle set as false)","TXT_CODE_479389a":"Allow players to use color codes on signs","TXT_CODE_47b5a2f7":"Logo image","TXT_CODE_47c35915":"Layout Saved","TXT_CODE_47c62dac":"Use Image","TXT_CODE_47d09eea":"Tab completion","TXT_CODE_47d56d0d":"Instance update failed! Reason:","TXT_CODE_47dcfa5":"Restart","TXT_CODE_47dd244a":"Sea Pickle Growth Speed","TXT_CODE_47e182a5":"Build Complete","TXT_CODE_47e21c80":"Please complete the parameters","TXT_CODE_48044fc2":"If the compressed file is from Mainland China, GBK is generally better;","TXT_CODE_4822a21":"Sent stop command","TXT_CODE_48261ab7":"Merchant Info Card","TXT_CODE_483d379":"The length of time for server and client positions may be out of sync (ineffective when the server-authoritative-movement option is set to false)","TXT_CODE_485e2d41":"Remaining Count","TXT_CODE_4880ef77":"World configuration for PaperSpigot. It allows for further configuration on a per-world basis.","TXT_CODE_48c286cc":"User <<operator_name>> stopped the <<instance_name>> instance","TXT_CODE_48c291c1":"Remote mappings are not available. This may be caused by an outdated panel backend.","TXT_CODE_4908e15b":"Force the client to load all resource packs.","TXT_CODE_495027e1":"Create Ubuntu 22.04 Environment Image","TXT_CODE_497568db":"Configure how the node is directly connected when user reaches panel from different endpoints, useful when node is behind a reverse proxy.","TXT_CODE_498cd5c5":"Click the stop button to cancel the upload","TXT_CODE_49981cb9":"How would you like to deploy this instance?","TXT_CODE_49ab8e74":"Armor attribute","TXT_CODE_49c040e1":"Swap main and off-hand items when any gesture is performed.","TXT_CODE_49c48e0a":"The actionbar message that appears when a player is asleep. Set to \'default\' to let the clients use their own translatable components. Set to an empty string to disable it. Available placeholders: <count> - the current amount of players sleeping, <total> - the total amount of players needed to sleep","TXT_CODE_4a37ec9c":"The number of web pages connected to this terminal, which may affect your terminal width and height","TXT_CODE_4a56836d":"Set Image List","TXT_CODE_4a570d32":"Ensure this image exists and includes necessary information like tags.","TXT_CODE_4a6bf8c6":"Daemon Port","TXT_CODE_4a70853b":"If the cumulative cost should apply when an item is used in an anvil","TXT_CODE_4a95255b":"Animal Tracking Range","TXT_CODE_4a9822f":"Whether snowballs, when thrown, should extinguish campfires","TXT_CODE_4aaec75c":"Wrong request type, please try again!","TXT_CODE_4ab6a0b5":"Browser Time","TXT_CODE_4aba9745":"Whether to kick players who exceed the TileKill threshold.","TXT_CODE_4ad9f75d":"Spawn Chance","TXT_CODE_4b1d5199":"Support any language.","TXT_CODE_4b20289c":"Enable Block Writes Synchronization","TXT_CODE_4b39143b":"The name of the spawner","TXT_CODE_4b610194":"Enable Client Region Generation","TXT_CODE_4b6e951":"Input","TXT_CODE_4b7eba50":"Online / Total","TXT_CODE_4b971ef4":"Makes the enderman despawn even if it\'s holding a block","TXT_CODE_4bbd3fde":"Build Progress","TXT_CODE_4bedec2a":"All Daemons","TXT_CODE_4bf8a52f":"Reference Price","TXT_CODE_4bf93cf1":"Should the proxy enforce new public key security standards? By default, this option is enabled.","TXT_CODE_4c0fda9":"Please try starting the instance once to generate a configuration file. If it still appears empty, this game server type may not be supported.","TXT_CODE_4c38bb42":"Hunger Depletion from Jumping and Running","TXT_CODE_4c55b6c7":"Time between spawning animals. A value of 400 indicating that the server will attempt to spawn animals every 400 ticks. Values less than 0 reset to Minecraft\'s default.","TXT_CODE_4c566219":"Allows players to use MiniMessage tags in an anvil.","TXT_CODE_4c714a4f":"Outdated Server! Current Version: {0}","TXT_CODE_4c72565d":"Username not found, create new account?","TXT_CODE_4c82f760":"Suppress warnings about attempts to load an unrecognized recipe","TXT_CODE_4c841d3":"Mushroom Growth Speed","TXT_CODE_4c9dd2b4":"Block fall multiplier for hay block","TXT_CODE_4ca9e35f":"Skeleton","TXT_CODE_4ccdd3a0":"Console","TXT_CODE_4cef8979":"Server Port (if your server has more advanced settings, this may be ignored)","TXT_CODE_4d00c085":"Enable BungeeCord plugin message channel support on Velocity.","TXT_CODE_4d124f78":"Enable UDP Query","TXT_CODE_4d36128b":"Check for Updates","TXT_CODE_4d3b4548":"Percent chance (0.0 - 1.0) an endermite will spawn after teleporting using an ender pearl","TXT_CODE_4d50f316":"3. This page can be accessed after login.","TXT_CODE_4d5432bd":"Percent chance (0.0 - 1.0) a zombie horse will spawn instead of a skeleton horse (natural spawns during thunderstorms)","TXT_CODE_4d571cda":"Hide Item Metadata","TXT_CODE_4d6b06f0":"Simplified Chinese (GBK)","TXT_CODE_4d81a657":"Preview","TXT_CODE_4d8e959e":"Allows you to set a list of console commands that will run when the server starts up. Useful for server owners that don\'t have access to their console.","TXT_CODE_4d934e3a":"Resource Assignment","TXT_CODE_4d993ca4":"Image Card","TXT_CODE_4dab643d":"Hard","TXT_CODE_4df7e9bd":"Hostname","TXT_CODE_4e2c7f64":"Hr","TXT_CODE_4e4b52a0":"This build process may take several minutes. Please maintain a stable network connection. Do you want to continue?","TXT_CODE_4e4d9680":"Complete Image Name","TXT_CODE_4e627613":"This card is running incorrectly, please refresh the page and retry","TXT_CODE_4e810102":"Please enter the startup command","TXT_CODE_4ea93630":"Please enter content","TXT_CODE_4ec4f7bb":"Please select an available node!","TXT_CODE_4eccdde8":"Configuration built successfully!","TXT_CODE_4ed501a1":"Forward the remote server\'s MOTD to Bedrock players.","TXT_CODE_4ef3f800":"For merchants: Contact https://redeem.mcsmanager.com or check website notice for help","TXT_CODE_4ef6b040":"Stopped","TXT_CODE_4efba567":"Additional Parameters","TXT_CODE_4f0b822b":"In miliseconds, how long does BungeeCord attempts to ping servers for player count, and disconnects if it takes too long","TXT_CODE_4f21b52":"Message that shows when someone tries to mount a mob they\'re not allowed to.","TXT_CODE_4f225afd":"Only for online mode authentication type. Save a list of Bedrock players that should be allowed to save their Java accounts after logging in.","TXT_CODE_4f2f381b":"Makes the name visible when using a Name Tag on an Armor Stand","TXT_CODE_4f34fc28":"Instance Settings","TXT_CODE_4f387c5a":"After configuring the update command, you can find the update operation at the switch instance button. After clicking, the command written here will be executed on the host (or in Docker)","TXT_CODE_4f57868":"MC Geyser","TXT_CODE_4f64db47":"Makes this mob WASD controllable","TXT_CODE_4f6a2959":"Please wait for the current file to be uploaded","TXT_CODE_4f6c39d3":"Please enter new password","TXT_CODE_4f917a65":"Resource Limits:","TXT_CODE_4fb30d0a":"The projectile offset of an egg","TXT_CODE_4fb3fad1":"Error occurred during decompression","TXT_CODE_4fb66c81":"Ban players and revert their actions if they destroy more than this number of tiles in 1 second.","TXT_CODE_4fd13f18":"This configuration is intended for BungeeCord proxy. Due to the complexity of this configuration file, only simple settings are available fomr this interface. It is recommended to use online file management tools to edit the source file directly.","TXT_CODE_4fdbb351":"Built-in Java 16 runtime environment, ideal for Minecraft server 1.17","TXT_CODE_4fe284cd":"Squir?","TXT_CODE_4fe5dce5":"Go to the node page","TXT_CODE_4ff6a125":"Message when trying to join a server that is full.","TXT_CODE_4ffdc91d":"Received {{signal}} signal from the system, attempting to shut down all instances...","TXT_CODE_50075e02":"This may take a while, as file deletion takes time","TXT_CODE_5020d183":"Allows changing the modifier for the piglin spawn chance from a portal block based on the world difficulty.","TXT_CODE_5024d817":"You must create the /workspace directory, which will be automatically mounted as the root directory of the instance.","TXT_CODE_504b84d9":"Enable player connection logging.","TXT_CODE_50511e8f":"Default player permission levels (visitor | member | operator)","TXT_CODE_50697989":"Assign instances to this user using fuzzy search and daemon name.","TXT_CODE_509d7d9a":"The Spigot configuration, which allows further control of server behavior and specific parameters. Some advanced restrictions are configured in this file.","TXT_CODE_50a2b2d9":"At the same time, this option will also affect the user in the instance\'s Docker container. If you don\'t know what this means, please do not modify it.","TXT_CODE_50aa56a1":"Allow the use of the /timings command. Used to measure the time spent by plugins on events","TXT_CODE_50d471b2":"Change","TXT_CODE_50daec4":"Network","TXT_CODE_510bd294":"Only support ZIP format. The file will be automatically decompressed into the \'File Directory\'","TXT_CODE_5112fcb2":"MC Forge","TXT_CODE_511aea70":"Permission","TXT_CODE_51289627":"Is Installation Complete","TXT_CODE_5143c584":"Prevent creating custom messages with death information protection mechanism.","TXT_CODE_514e064a":"Panel Binding IP","TXT_CODE_518528d0":"Skip","TXT_CODE_51a1fffb":"Filter","TXT_CODE_51bb7e9f":"Unknown command. Type \\"/help\\" for help","TXT_CODE_51df891f":"Bastion Remnant Seed","TXT_CODE_51ff8e5b":"Set to true to disable the /give command from dropping items on the floor when a player\'s inventory is full","TXT_CODE_5206cf41":"Basic Settings","TXT_CODE_5207688f":"MCDReforged Server Control Tool Permission Configuration File","TXT_CODE_5245bd11":"Please complete the form","TXT_CODE_524e3036":"Terminal","TXT_CODE_525e6e18":"EULA has been accepted successfully. Starting instance...","TXT_CODE_5275cb62":"Player Insomnia Start Tick","TXT_CODE_528753e7":"Minecraft or other programs require specific runtime environments, such as Java/Python/.NET, installing and managing different versions on the same machine is very complicated. Using different images can easily manage different versions of service environments.","TXT_CODE_52b31aef":"Record where players logged off based on their IP. Cleared upon server restart.","TXT_CODE_52ba5942":"Fill card","TXT_CODE_52bc24ec":"Confirm Upload","TXT_CODE_52c8a730":"Enable","TXT_CODE_52eff9c3":"Operator Permission Level (1-4)","TXT_CODE_52f96ff0":"The gradient of <text> when fill-mode is \'good\'","TXT_CODE_53046822":"Limit CPU Usage (Percentage)","TXT_CODE_530f5951":"Check","TXT_CODE_5338b335":"Melon Growth Speed","TXT_CODE_53408064":"Create","TXT_CODE_53499d7":"Create blank template","TXT_CODE_534db0b2":"Host Port","TXT_CODE_5366af54":"Exit Batch Operation","TXT_CODE_53745cc0":"Total number of instances assigned to you","TXT_CODE_53761955":"Message that shows when the demo screen is enabled for a user using the /demo command.","TXT_CODE_537cd5ad":"Back to Configuration File List","TXT_CODE_53aec8c6":"Ticks between garbage collections of each region.","TXT_CODE_53d04392":"Whether snowballs, when thrown, should extinguish fires","TXT_CODE_53dd82fc":"Stop Command","TXT_CODE_53e8e5af":"The death message that appears when the player is killed because they were running with scissors","TXT_CODE_5415f009":"No content, please try changing the node or search criteria","TXT_CODE_54275b9c":"Template Editor","TXT_CODE_54312194":"Address and port","TXT_CODE_543356c1":"List of blocks that can be turned into a grass path when right-clicked with a shovel","TXT_CODE_5445f34b":"and {num} more","TXT_CODE_54469e02":"No operation logs available yet","TXT_CODE_5476e012":"State","TXT_CODE_5484094a":"Change container working directory","TXT_CODE_55015f30":"Extra Mount Directories (Optional)","TXT_CODE_551b0348":"Password","TXT_CODE_553c6ed2":"Set to true to make it so netherwart can be bonemealed","TXT_CODE_5544ec22":"View Build Progress","TXT_CODE_555b3625":"Woodland Mansion Seed","TXT_CODE_555e2c1b":"Enter command and press enter to send, use arrow keys to navigate historical commands","TXT_CODE_5564bc4c":"User <<operator_name>> modified the user configuration","TXT_CODE_559f4b1d":"Suppress warnings about plugins initializing the legacy material api","TXT_CODE_55a62de":"Allows the placement of water in the end.","TXT_CODE_55ade942":"Used for administrators to view server data","TXT_CODE_55b1f20e":"User failed to activate instance:","TXT_CODE_55c91a9b":"Set to true to enable damage when sneaking","TXT_CODE_55e91545":"Early window provider","TXT_CODE_55edf44d":"Image creation started","TXT_CODE_56197d09":"Stops squids from floating on top of water","TXT_CODE_5635dd6b":"Set to true to enable damage when walking with boots enchanted with frost-walker","TXT_CODE_56516e92":"Hidden Configuration Options","TXT_CODE_56b9e6af":"By default, MCSManager allocates 5 ports sequentially for each instance, supporting the use of {mcsm_port1} to {mcsm_port5} as sequentially added port numbers.","TXT_CODE_56c42793":"The prefix that shows up on the playerlist before someone\'s name when they\'re AFK","TXT_CODE_56c686f8":"Failed","TXT_CODE_56ff18c1":"Server MOTD (leave empty if using plugins like ColorMotd)","TXT_CODE_57245e94":"Start","TXT_CODE_57358a8b":"Set to true for boats to eject players when on land","TXT_CODE_57417f60":"Whether to kick players who exceed the MaxDamage threshold.","TXT_CODE_574ed474":"Online Features","TXT_CODE_57674047":"Command executed when the \\"Update\\" button is clicked","TXT_CODE_5778848e":"Archive cannot be opened","TXT_CODE_57a3aae":"Message that shows when the /uptime command is ran.","TXT_CODE_57c09778":"Set to true for creepers to bypass the mob griefing gamerule","TXT_CODE_57c1b0a3":"Optional, -Xms parameter, like: 1024M","TXT_CODE_57cd2d04":"This may be due to network conectivity issue or server maintenance. Please wait for a while and try again, or try a different package.","TXT_CODE_57d1929e":"MCSManager will use the \\"Minecraft Ping protocol\\" to try to obtain the number of online servers, versions, delays and other information.","TXT_CODE_57d76ece":"Replace Block List","TXT_CODE_57e86edb":"The instances you have assigned include some instances that do not have \\"Container Protection\\" enabled. MCSManager will not be able to control the behavior of this user. The assigned user can upload malware through these instances to invade your host. Please make sure that the sub-user is one you trust. \\npeople.\\n\\n\\nThe names of instances with security risks are as follows:","TXT_CODE_584af0ab":"Disable invisibility potion effects.","TXT_CODE_584d786d":"Delete instance and related files","TXT_CODE_58508fb7":"Server Software Filename","TXT_CODE_58939ea7":"Spawn Animals","TXT_CODE_589e091c":"Add Picture","TXT_CODE_58a55f17":"The file {name} already exists in this folder","TXT_CODE_58aa8491":"Require shulkers to have their lid open to spawn from bullet","TXT_CODE_58e4a9bd":"User <<operator_name>> uploaded the file <<file>> to the <<instance_name>> instance","TXT_CODE_592eff33":"Save to panel","TXT_CODE_5936d79":"Set to true for projectiles to bypass the mob griefing gamerule","TXT_CODE_593ee330":"Memory","TXT_CODE_595efd06":"Create New","TXT_CODE_5962e188":"Latest Version","TXT_CODE_5974bf24":"Manage","TXT_CODE_597c11cc":"What Difficulty Zombies Break Doors","TXT_CODE_598f2d02":"The gradient of <text> when the ram usage is \'low\'","TXT_CODE_59917c84":"Allow third-party capes to be visible.","TXT_CODE_59976e2c":"Set to true to impose teleport restrictions on gateways. This broadcasts the EntityTeleportHinderedEvent event which gives the ability to retry teleports if they fail due to having passengers/being vehicles","TXT_CODE_59a76359":"Cache store map colors","TXT_CODE_59ab3364":"Download Rate","TXT_CODE_59ac0239":"New Image","TXT_CODE_59b1cb55":"Allow Headless Pistons","TXT_CODE_59c0c994":"uploading to other instances","TXT_CODE_59c39e03":"MCSManager Redemption Center will assist your business plan","TXT_CODE_59cb16ff":"Please Provide File Name","TXT_CODE_59cdbec3":"Description","TXT_CODE_59f7c3a2":"Percent chance (0.0 - 1.0) a zombie or skeleton will spawn with a jack o\' lantern/carved pumpkin on it\'s head","TXT_CODE_5a196078":"Dynamic Photo Card","TXT_CODE_5a280280":"Load permissions.yml Before Plugins","TXT_CODE_5a408a5e":"Shop","TXT_CODE_5a56ccca":"Allow password-based authentication methods through Geyser. Only useful in online mode.","TXT_CODE_5a6463fb":"Armor Stand Tick","TXT_CODE_5a74975b":"Create Instance","TXT_CODE_5a936b7f":"Expand","TXT_CODE_5aa330f0":"Set to false for the fire resistance effect to not display it\'s icon","TXT_CODE_5ab1eb7d":"Change style","TXT_CODE_5ab2062d":"Last Start","TXT_CODE_5af5838a":"Broadcasts the advancment messages in chat only to the affected player","TXT_CODE_5b0e93b5":"The installation cannot be started because there are other asynchronous tasks in progress. Please terminate other tasks on the terminal page first!","TXT_CODE_5b190bc4":"Frequency at which the REST request bucket decreases by 1 (in minutes). Minimum value is 1 minute.","TXT_CODE_5b2daea0":"If you enter a command and pressing Enter doesn\'t yield a response, you can try adjusting this option.","TXT_CODE_5b323a2":"Maximum Players Allowed for the Entire BungeeCord Instance, use -1 for no limit","TXT_CODE_5b5d6f04":"Discard Changes","TXT_CODE_5b60ad00":"Login to MCSManager Control Panel","TXT_CODE_5b6f3691":"Server Configuration File of a NeoForge Server","TXT_CODE_5b719d7b":"Set to true to allow sleep even if there are mobs nearby","TXT_CODE_5b990e2e":"Rename successful.","TXT_CODE_5bb8f14":"Spawn Hostile Mobs (monsters)","TXT_CODE_5bba3e38":"Radius within which villagers search to acquire POI.","TXT_CODE_5bc16b9a":"Chat suffix for the SuperAdmin group.","TXT_CODE_5bdaf23d":"Daemon Terminal","TXT_CODE_5be6c38e":"Default Type","TXT_CODE_5bf41818":"Overwrite","TXT_CODE_5c3ba572":"Disable Pillagers","TXT_CODE_5c43374f":"Virtual Memory Usage Preference","TXT_CODE_5c54f599":"Anyone","TXT_CODE_5cb656b9":"Batch Operation","TXT_CODE_5cd3b4bd":"Instance(s)","TXT_CODE_5ce5085c":"Input Encoding","TXT_CODE_5d033431":"Anti-Xray Hidden Block List","TXT_CODE_5d41afbf":"Set to true to have 100% chance of taming a mob","TXT_CODE_5d488270":" It ensures that Allays respect the NBT from the items they pick up. If you add stored enchantments to the list to respect, then if you give an Allay a sword with an enchantment, it will only pick up swords with the same enchantments.","TXT_CODE_5d563196":"Hunger Depletion from Jumping and Walking","TXT_CODE_5d589988":"Allows for chests to open even with a solid block on top","TXT_CODE_5db4e96b":"Expand Height (final height is the highest among the rows)","TXT_CODE_5ddb00f2":"User <<operator_name>> created the task <<task_name>> for the <<instance_name>> instance","TXT_CODE_5ddf3123":"Set to true to disable observer clocks","TXT_CODE_5deeefb5":"Instance will be created, proceed?","TXT_CODE_5def0cbe":"Safety","TXT_CODE_5e10537a":"Change Instance Template","TXT_CODE_5e4a370d":"Dark Theme","TXT_CODE_5e4c9793":"Amount of ticks to delay sound; burp-when-full option must be enabled","TXT_CODE_5e56a7a5":"The speed in which a cauldron below a down-facing pointed dripstone that has water placed a block above it fills with water (depends on random tick)","TXT_CODE_5e6e46bb":"Maximum damage that players/NPCs can deal.","TXT_CODE_5e9022f8":"Next","TXT_CODE_5ead1240":"Start Editing","TXT_CODE_5eb49cd":"Set to true to make TE\'s lores persist after breaking (ex. custom player heads with lore will retain their lore)","TXT_CODE_5ebec0db":"Extend Page Card","TXT_CODE_5ec10cc8":"This card cannot be previewed in design mode.","TXT_CODE_5ef2cf20":"Authenticate your identity with key generated by remote daemon.","TXT_CODE_5f0eafe5":"Ender dragon death sound effect radius","TXT_CODE_5f1ae9ca":"Set to true to allow clients to request the bee count of beehives using custom payload packets.","TXT_CODE_5f23008":"Reason given when kicking players trying to join when the server is full and no reserved slots are available.","TXT_CODE_5f282a51":"What Difficulty Phantoms Break Doors","TXT_CODE_5f2d2e30":"Node ID: ","TXT_CODE_5f42b528":"Server authentication type. Can be offline, online, or floodgate.","TXT_CODE_5fed0011":"Enable LEGACY ping passthrough. Only enable this if your MOTD or player count isn\'t showing correctly.","TXT_CODE_6032f5a3":"9 to 36 characters, must include uppercase, lowercase letters, and numbers","TXT_CODE_603cbc35":"Whether region protection should apply to diamond gem locks.","TXT_CODE_604d3041":"How much compression should be done (0-9). Default value is -1, which uses the default level 6.","TXT_CODE_604d8d63":"Container Limits","TXT_CODE_606da66a":"Animal Activation Range","TXT_CODE_6071bd0b":"Message displayed to the game client when the server is shut down","TXT_CODE_60752a40":"Please select a language","TXT_CODE_60a11735":"Fix Climbing Rule Bypassing Crowding Limits","TXT_CODE_60dd05d5":"Override default image working directory with data storage directory","TXT_CODE_60e3c342":"Server name. Replaces the world name during the session if UseServerName is true.","TXT_CODE_615be555":"Time before trident disappears","TXT_CODE_61700077":"Set to true for this mob to start taking damage from water","TXT_CODE_617701dc":"Whether to kick players who exceed the TilePlace threshold.","TXT_CODE_617ce69c":"Warn","TXT_CODE_61811ac":"Task Payload","TXT_CODE_61834192":"Update Command (Optional)","TXT_CODE_619d74d3":"e.g. java -jar server.jar，cmd.exe","TXT_CODE_619faab6":"Initiates the instance start operation immediately if the instance stoped unexpectedly.","TXT_CODE_61a8296e":"Enable Docker Container","TXT_CODE_61b6facb":"User <<operator_name>> deleted the <<instance_name>> instance","TXT_CODE_61ca492b":"For Example: ","TXT_CODE_61dd421d":"Max Milliseconds per Tick","TXT_CODE_61eae8a6":"Two-Factor Authentication","TXT_CODE_62051fcc":"Upload Failed","TXT_CODE_6215388a":"New Dir","TXT_CODE_6239c6b6":"No Webpage","TXT_CODE_6253ecce":"Block fall multiplier for light blue bed","TXT_CODE_6259357c":"The program must run for more than 6 seconds before it can be forced to stop!","TXT_CODE_6265ae47":"App Marketplace Data Source","TXT_CODE_628f6851":"Timeout Time","TXT_CODE_62c62825":"Log commands","TXT_CODE_62c88f3a":"Weeping Vines Growth Speed","TXT_CODE_62dbf117":"Time between spawning animals, similar to the previous setting","TXT_CODE_633415e2":"Please fill out the form correctly","TXT_CODE_6345aa71":"HTML file:","TXT_CODE_6353e235":"SHA-1 Value of Resource Pack (optional, in lowercase hexadecimal)","TXT_CODE_635d051":"No Picture","TXT_CODE_638bca20":"The delete command has been sent.","TXT_CODE_63a4602e":"Player Auto-Save Rate","TXT_CODE_63ccbf90":"Permission","TXT_CODE_6420023d":"Number of auto restart count: ","TXT_CODE_64282335":"Disable Disc Plant Updates","TXT_CODE_645bc545":"Create a New Instance","TXT_CODE_645da993":"Docker Configuration","TXT_CODE_647ea2ec":"Clear all selected?","TXT_CODE_64bf4386":"Can be used for instance to start as the remote daemon boots.","TXT_CODE_6514e191":"A common configuration for Spigot or it\'s derivative server software","TXT_CODE_6526494a":"Set to true to stop trampling if entities fall a distance equal to their feather falling level, plus the extra block necessary to trample in the first place. Feather Falling 1 requires you to fall over 3+ blocks to trample. FF 2 requires 4+, etc.","TXT_CODE_6546b287":"Uses a plain-text version of the player\'s display name in the AFK broadcast, instead of their username.","TXT_CODE_6557efaf":"Second Line MOTD","TXT_CODE_656a85d8":"Steam Rcon Protocol","TXT_CODE_65a057ec":"Port of the Java server.","TXT_CODE_65a780a2":"The amount of damage starvation will do","TXT_CODE_65b21404":"Download","TXT_CODE_65e33205":"Set to true if this mob should avoid rabbits, similar to how creepers avoid cats","TXT_CODE_65fcbd09":"Remove","TXT_CODE_66056676":"System Resource","TXT_CODE_660e2341":"Music player","TXT_CODE_661c66fa":"Downstream Server Settings - Only servers listed here can be connected","TXT_CODE_6623dde0":"Suppress logs related to the library loader","TXT_CODE_662ad338":"I/O Encoding","TXT_CODE_662ae77":"Set to true for enderman to bypass the mob griefing gamerule","TXT_CODE_6655c905":"HTTP responses will include \'access-control-allow-origin: *,\' which may reduce security but allow further development.","TXT_CODE_66820e23":"How many NPCs can be generated within 200 pixels of a player before generating stops. Default is 3.","TXT_CODE_6683b887":"Enable or disable REST API.","TXT_CODE_66968dc0":"How many blocks giants can walk up without having to jump","TXT_CODE_669eb0ff":"Output when /ping <user> is run.","TXT_CODE_66ac4611":"Set to false to disallow snow formation on blue ice","TXT_CODE_66b01c4e":"Book Total Volume Multiplier","TXT_CODE_66b7b26e":"Movement speed attribute","TXT_CODE_66ce073e":"Offline","TXT_CODE_66e32091":"Node language has been changed:","TXT_CODE_66f38b2e":"Normal users can only modify part of the settings","TXT_CODE_673eac8e":"Light Theme","TXT_CODE_67509ff2":"Controls whether bees can work during the night","TXT_CODE_6750d9d3":"Using files shared by others may compromise the panel.","TXT_CODE_678164d7":"You can find the node ID in the \'Node List\' section of the merchant console","TXT_CODE_67b4d0ba":"Kick players if they become idle (see server.properties for player-idle-timeout time)","TXT_CODE_67b57086":"Only spawn on players above sea level","TXT_CODE_67b5f678":"MC Bedrock","TXT_CODE_67c765be":"Specify processes to run on certain cores; distributing them reasonably can better utilize your system\'s hardware resources, e.g., 0,1 means running on the 1st and 2nd cores, separated by commas.","TXT_CODE_67d1ea21":"Some optional tags","TXT_CODE_67d68dd1":"Type","TXT_CODE_68128434":"Deploy Minecraft Server","TXT_CODE_6819de18":"Are you sure you want to disable the API Key?","TXT_CODE_681aaeb9":"Host Directory","TXT_CODE_683e3033":"Hardware Requirements","TXT_CODE_684eb7e3":"Max Pages in a Book","TXT_CODE_686c9ca9":"Connecting to terminal...","TXT_CODE_68821d80":"Basic configuration file for TShock servers.","TXT_CODE_68831be6":"Type: ","TXT_CODE_68928779":"Suppress warnings about unknown attributes in console and logs","TXT_CODE_68a15ebb":"Enable JMX Monitoring","TXT_CODE_68a504b3":"Please enter the instance name","TXT_CODE_68a6aec5":"Display Achievements in Server Chat","TXT_CODE_6904cb3":"Docker Image","TXT_CODE_6915f2a":"Dependency files are missing and cannot be started. Please reinstall the program:","TXT_CODE_692957":"Server Binding IP (leave blank if not binding)","TXT_CODE_6929b0b2":"Unable to Connect to Remote Daemon","TXT_CODE_693f31d6":"Path Prefix","TXT_CODE_694952a":"Create OpenJDK 16 Environment Image","TXT_CODE_699b4b66":"Do not fill in; the panel will automatically generate it when needed.","TXT_CODE_69ad6852":"Allow Cheats","TXT_CODE_69c42450":"Missing 7zip dependency support, unable to decompress {{fileExt}} format files.","TXT_CODE_69dbb08":"Allows players to use color codes in anvils","TXT_CODE_69ecec1":"Libraries Download Source","TXT_CODE_6a06a9ef":"Force Switch to Working Directory","TXT_CODE_6a10302d":"This action cannot be undone!","TXT_CODE_6a365d01":"Operation Failed","TXT_CODE_6a515e35":"The web page automatically adds color to the output, but the colors may not be entirely accurate.","TXT_CODE_6a826e8b":"How long you can breathe underwater before you start drowning","TXT_CODE_6aa286df":"Page Not Found","TXT_CODE_6ac327b4":"Set to true to allow bulk processing of food/plant items by sneak right-clicking with the item in hand","TXT_CODE_6ac61ca1":"Radius within which villagers search to detect the nearest bed.","TXT_CODE_6adffa20":"Failed to upload file slice, ","TXT_CODE_6b175558":"After completing the configuration, the server status will be refreshed every minute when the instance is running.","TXT_CODE_6b1984c0":"Percent chance (0.0 - 1.0) creepers are charged (powered) when spawning","TXT_CODE_6b2a9cab":"Upgraded configuration to new version:","TXT_CODE_6b313c":"Set to true to spawn in the world that this option is a part of","TXT_CODE_6b4a27dd":"The web front end cannot establish a WebSocket connection with the node, please check the network proxy configuration or firewall configuration!","TXT_CODE_6b5509c7":"Please enter a template name","TXT_CODE_6b583898":"Anti-Xray Engine Mode","TXT_CODE_6b69f1d":"Specify custom timeouts for connections here. Default is five seconds.","TXT_CODE_6b6f1d3":"You are free to design anything you desire. Having too many elements on a single page may lead to performance issues, so please design accordingly.","TXT_CODE_6be8dbe7":"Restart Script Path","TXT_CODE_6bf4665b":"Broadcast the player\'s geographical location above their head upon joining based on their IP.","TXT_CODE_6c0478ab":"Command executed when the \\"Stop\\" button is clicked","TXT_CODE_6c08319b":"MC Spigot","TXT_CODE_6c232c9c":"Used to mount additional folders on the host into the container, supports two variable strings: &lbrace;mcsm_workspace&rbrace; (working directory) and &lbrace;mcsm_instance_id&rbrace; (instance ID).","TXT_CODE_6c274bdc":"This user does not enable the APIKEY.","TXT_CODE_6c5985ca":"Go","TXT_CODE_6c7970df":"Buried Treasure Seed","TXT_CODE_6c87dd18":"Linux Docker","TXT_CODE_6c945cf8":"Play the wither\'s spawn sound globally when it is spawned","TXT_CODE_6c94f562":"Makes this mob mountable","TXT_CODE_6ca6667f":"Memory Usage (10min)","TXT_CODE_6cb9bb04":"Month","TXT_CODE_6cbb84a9":"Unavailable","TXT_CODE_6cd13a66":"Should player pings be forwarded to the server? Enabling this option will allow Bedrock players to have more accurate pings but may also make them more prone to timeouts.","TXT_CODE_6cfeb776":"Set to false for this mob to stop taking damage from water","TXT_CODE_6d244c20":"Animals","TXT_CODE_6d32ea04":"Should AFK players count as sleeping? (allows active players to skip night by sleeping, even if AFK players are not in bed)","TXT_CODE_6d6c7e9a":"Ban players if they create more than this number of projectiles in 1 second.","TXT_CODE_6d6ceab5":"Spider Immune to Poison Effects","TXT_CODE_6d772765":"Failed to get download address.","TXT_CODE_6d8bc58d":"Failed to save. A single tag only supports up to 9 characters!","TXT_CODE_6d912e27":"Ban players if this many tiles are drawn in 1 second.","TXT_CODE_6d9b9f22":"Once the layout is saved, the language used for the entire interface will be locked. Switching languages may not work well unless the layout is reset. If you do not need to switch languages, you can safely ignore this advice. ","TXT_CODE_6da85509":"Are you sure you want to send a shutdown command to the instance?","TXT_CODE_6dcaa94d":"The name length should be between 1 and 30 characters","TXT_CODE_6e23c48":"General","TXT_CODE_6e3da823":"Optional, parameters after the Java program, like -nogui, etc., separate multiple parameters with spaces","TXT_CODE_6e69b5a5":"For file management functions.","TXT_CODE_6e718abe":"Unable to retrieve identity data, may be banned or network issue, please try refreshing the page","TXT_CODE_6e96b2a9":"Terminal Output Encoding","TXT_CODE_6ed13fd":"How much damage to deal to the elytra when trident riptide boost activates","TXT_CODE_6eead111":"mohist.yml Server Configuration File","TXT_CODE_6ef5195f":"Can be used to display images","TXT_CODE_6f038f25":"We are processing the files with all our might!","TXT_CODE_6f0a5984":"Follow range attribute","TXT_CODE_6f1129fb":"Automatic Allocation","TXT_CODE_6f12aba3":"Are you sure you want to remove this link?","TXT_CODE_6f161560":"File Encoding","TXT_CODE_6f23ce93":"{{count}} instance remaining to be shut down, waiting...","TXT_CODE_6f27624c":"Access daemon from","TXT_CODE_6f2c1806":"Remove","TXT_CODE_6f43f95f":"User <<operator_name>> downloaded the file <<file>> of the <<instance_name>> instance","TXT_CODE_6f659da2":"Used for analyzing recent trend of the panel.","TXT_CODE_6f7c50c2":"Disable Cat Detection on Chests","TXT_CODE_6f862823":"The MCSManager is exiting, please wait...","TXT_CODE_6f91f3ba":"Space Used","TXT_CODE_6f98ccd7":"First Time User","TXT_CODE_6f9d4bb7":"Blocks that can be used to build a conduit","TXT_CODE_6fac9e82":"Sapling Growth Speed","TXT_CODE_6fe24924":"Maximum Memory (in MB)","TXT_CODE_6ff0668f":"Are you sure you want to delete this scheduled task?","TXT_CODE_7010d780":"In what order should we try servers when a player logs in or is kicked?","TXT_CODE_703cdd68":"Should we control the window. Disabling this disables new GL features and can be bad for mods that rely on them.","TXT_CODE_704a8b5d":"Villager Activation Range","TXT_CODE_70750fa":"Allow Vehicle Collisions","TXT_CODE_7078fd28":"Installation Error","TXT_CODE_709c2db4":"Want to contribute a template?","TXT_CODE_70a2613b":"No compatible configuration files were detected through file scanning for specific instance types (e.g., minecraft/java). Please initialize the process configuration or change the instance type.","TXT_CODE_70c3b6e":"Declare proxy commands for 1.13+ clients.","TXT_CODE_70ce6fbb":"The instance has been stopped.","TXT_CODE_70e0cf4d":"Back to Home","TXT_CODE_70fe20dd":"Should elytras ignore the unbreaking enchantment","TXT_CODE_70ff09a8":"Threshold for updating scoreboards, how many Scoreboard packets per second.","TXT_CODE_710a2e6c":"Whitelist of tools that can mine spawners with silk touch","TXT_CODE_71155575":"Are you sure you want to delete?","TXT_CODE_711d4763":"View Distance","TXT_CODE_7141866a":"Kick clients that do not send a UUID to the server within 1 second.","TXT_CODE_7153951e":"The Quick installation service relies on third-party online platforms.","TXT_CODE_7166a969":"Enable Ping Passthrough","TXT_CODE_718c9310":"Disable","TXT_CODE_71a51d19":"Instance Console","TXT_CODE_71c948a9":"Please enter working directory","TXT_CODE_71f715e2":"Makes this mob WASD controllable. Trader llama\'s must be tamed to be WASD controllable. Being saddled (carpet) is not a requirement since it technically always has a carpet.","TXT_CODE_721157a3":"Data Overview","TXT_CODE_7214ead7":"Config version","TXT_CODE_724ce74d":"Which type of instance would you like to deploy?","TXT_CODE_7284c68e":"Default Game Mode for New Players When Joining","TXT_CODE_728fdabf":"Failed to create the instance, please try again later","TXT_CODE_72952e19":"Please select items to delete","TXT_CODE_72c8d0bf":"Allows the furnace to be infinitely powered by lava placed underneath it","TXT_CODE_72cce10b":"Instance File Management","TXT_CODE_72cfab69":"Daemon ID","TXT_CODE_72d36de":"Enable BungeeCord Support","TXT_CODE_72f69b34":"Use Vanilla World Scoreboard Name Colors","TXT_CODE_73102f2b":"System operation logs will be displayed here","TXT_CODE_7333c7f7":"Clear","TXT_CODE_7356e569":"No Templates Available","TXT_CODE_738bc836":"Max World Size","TXT_CODE_73c7b4b":"Attack damage attribute","TXT_CODE_7411336e":"Total Instances","TXT_CODE_741fdde4":"Restart on Crashes","TXT_CODE_743c6bf3":"Set to true for clerics to farm nether wart","TXT_CODE_743ed87f":"Compression Level","TXT_CODE_74443c8f":"Instance is not running","TXT_CODE_745d8a03":"Hyperlink Block","TXT_CODE_745fc959":"This feature will protect your panel from brute force password attacks by allowing only 10 password attempts per IP.","TXT_CODE_74788d9e":"Allows you to place an end crystal on any block, not just obsidian and bedrock","TXT_CODE_74c3d3e5":"Documentation","TXT_CODE_74c46351":"Force Statistics Data","TXT_CODE_74fa2f73":"Are you sure you want to reset the layout?","TXT_CODE_74fd665e":"Apply to subdirectories","TXT_CODE_750ab5c6":"Limit the total CPU usage of all cores; slight deviation may occur.","TXT_CODE_751f9bc1":"Configuration file for Velocity proxy, allowing for distributed management, node control, etc. This configuration file is complex, and here it is provided for basic configuration and operations only.","TXT_CODE_7542201a":"Delete instance-related files simultaneously","TXT_CODE_7546cc5":"Should entities tick normally when nearby players are AFK. False will require at least 1 non-AFK player in order to tick","TXT_CODE_75696661":"If you\'re using modern or BungeeGuard IP forwarding, configure the unique key here.","TXT_CODE_759fb403":"Status","TXT_CODE_75bf9192":"Use Code","TXT_CODE_75c04302":"Flying Monster Activation Range","TXT_CODE_75da3f2d":"Clear current template","TXT_CODE_75e5af9b":"This file does not support direct configuration, please edit it through file management.","TXT_CODE_75ef0619":"Restart node to take effect, requires simultaneous modification of connection configuration","TXT_CODE_7638590c":"Instances currently running","TXT_CODE_765d34e6":"User","TXT_CODE_7669fd3f":"Unzip Files","TXT_CODE_76750199":"Every Week","TXT_CODE_7680e37f":"Enable command logging.","TXT_CODE_768c6fa9":"Tall Grass Growth Speed","TXT_CODE_76a82338":"If from Taiwan or Hong Kong, try BIG5; for other regions, use UTF-8.","TXT_CODE_76b2a495":"Other","TXT_CODE_76c66252":"Tab-Completion Abuse Increment","TXT_CODE_76d20724":"Assigned Instances","TXT_CODE_76d59e8":"Set to true to make downward bubble columns generate instead of upward bubble columns when soul sand is placed/generated under water-source blocks.","TXT_CODE_77000411":"Image","TXT_CODE_7702d818":"Sneak and right-click a strider with a saddle on it\'s back to remove it with this option enabled","TXT_CODE_77083c51":"Mount extra host directories into the container. Variables {mcsm_workspace} (working directory) and {mcsm_instance_id} (instance ID) are supported.","TXT_CODE_772bb48a":"eg: Java 18+","TXT_CODE_772c4961":"Amount of damage per second crystals deal to phantoms. Value of 1.0 is half a heart","TXT_CODE_773f36a0":"Upload Successful.","TXT_CODE_77816ef3":"When true all valid ender dragon deaths will drop the full amount of experience orbs as if it were the first dragon death","TXT_CODE_779553fb":"Web Service token","TXT_CODE_77cc12da":"Restart Instance","TXT_CODE_77d038f7":"Panel Memory Usage","TXT_CODE_77d93d7d":"Official documentation: https://docs.docker.com/engine/reference/builder/","TXT_CODE_78019c60":"Config Editor","TXT_CODE_7818efd1":"Set to false for rabid wolves to not be cured by milk","TXT_CODE_78223e62":"Kick players flagged as using a proxy if GeoIP is enabled.","TXT_CODE_785a0fcf":"User file download rate","TXT_CODE_7863f28d":"Refreshed","TXT_CODE_786c22bd":"Failed to take over running container","TXT_CODE_786e2280":"Whether beds explode. Setting this to false just makes the bed blip out of existence","TXT_CODE_78930f0f":"Edit URL","TXT_CODE_7898c2b4":"Allows endermen to fit into 2 block tall spaces if enabled. Since client hitbox remains the same, you can still hit them in the head","TXT_CODE_78aa511":"Disconnect Timeout","TXT_CODE_78e88c3f":"Tag grouping","TXT_CODE_7907c99":"To the current dir","TXT_CODE_791a4c9b":"Default Permission Level for Functions","TXT_CODE_791c73e9":"New File","TXT_CODE_798f592e":"Read","TXT_CODE_7991f7b3":"The projectile offset of a snowball","TXT_CODE_79b77e31":"Set to true to give fall damage to the player while in a minecart","TXT_CODE_79ccdee0":"The radius of blocks that a sponge absorbs water","TXT_CODE_79d2800b":"Spawn Delay - Per Player","TXT_CODE_79f9a172":"Edit User","TXT_CODE_7a2b969f":"The enchantments that aren\'t removed from grindstones","TXT_CODE_7a318185":"Modify to change the blast resistance of blocks.","TXT_CODE_7a464bb4":"The speed of the dolphin spit","TXT_CODE_7a830c68":"Auto-save, with a value of 6000 indicating that the server will attempt to auto-save the world every 5 minutes. Note: a small value may cause server lag.","TXT_CODE_7ac6f85c":"Terminal is not supported in design mode.","TXT_CODE_7ac8b1d3":"Please enter the two-factor authentication code","TXT_CODE_7af6d85a":"MC Fabric","TXT_CODE_7b0b38e6":"Should dispensers apply armor to armor slots if enchanted with curse of binding","TXT_CODE_7b1adf35":"Layout Design Mode","TXT_CODE_7b2c5414":"Select","TXT_CODE_7b477c3":"Minimum size to randomly choose from when spawning naturally","TXT_CODE_7b67813a":"Terminate","TXT_CODE_7b759c13":"Prevent default tiles from generating within the generation protection radius.","TXT_CODE_7b763c56":"Server MOTD. Irrelevant if \'passthrough-motd\' is set to true.","TXT_CODE_7b8f01b5":"Worker Threads","TXT_CODE_7b92d98d":"Java Version Requirements","TXT_CODE_7bcf35c1":"The amount of damage it will do to players","TXT_CODE_7bdd0634":"Set to true to make enderman aggro towards endermites only if they\'ve been spawned by a player thrown ender pearl. This option does nothing if \'aggressive-towards-endermites\' is false","TXT_CODE_7c0b7608":"Node status","TXT_CODE_7c25c81a":"Disables File Watcher. Used to automatically update config if its file has been modified.","TXT_CODE_7c650d80":"Node connection failed, please contact the administrator to check the status of the remote node!","TXT_CODE_7c76dbf":"Banned","TXT_CODE_7cad42a5":"Search by File Name","TXT_CODE_7cc196b9":"Network Compression Threshold","TXT_CODE_7ce3c6e":"Book Page ID","TXT_CODE_7ceebc05":"Enter text content, support Markdown syntax, and can wrap lines.\\n\\nDon’t use other people’s copywriting easily, otherwise malicious code may be injected to attack you.","TXT_CODE_7cf078e8":"Image Name and Version After Creation","TXT_CODE_7cf70670":"Monsters Awakened Every x Ticks","TXT_CODE_7d197c39":"I/O Threads","TXT_CODE_7d1a9487":"Built-in Java 17 runtime environment, ideal for Minecraft server 1.18 and later","TXT_CODE_7d25f076":"Wandering traders will be tempted by emerald blocks and follow players holding them","TXT_CODE_7d28d924":"Controls how many end crystals can occupy the same hitbox space. When set to a certain number, any additional crystals will cause an explosion.","TXT_CODE_7d3d97ec":"What color should show when fill-mode is \'good\'","TXT_CODE_7d81030f":"Control if giant zombies have hostile AI also","TXT_CODE_7d839745":"eg: apple, banana, cherry","TXT_CODE_7d874fad":"Default maximum number of creatures spawned per wave. Higher values mean more creatures in that wave.","TXT_CODE_7da6e84":"Complete all required fields to create. For more options, please go to instance settings after creation.","TXT_CODE_7db580c1":"Block fall multiplier for white bed","TXT_CODE_7dd469fa":"This is the message that gets broadcasted when a user is no longer AFK (must have player-idle-timeout set greater than 0 & kick-if-idle set as false)","TXT_CODE_7e0b9953":"What to do with the blocks that are effected by the explosion.","TXT_CODE_7e267ba":"Select Node","TXT_CODE_7e426b47":"If query is enabled, what port should the query protocol listen on?","TXT_CODE_7e6a82d8":"Configuration File of a Forge Server","TXT_CODE_7e9727bd":"Players","TXT_CODE_7eb0f9fd":"Set to true to hide players from the entity selector if they\'re hidden","TXT_CODE_7ec7ccb8":"When you click the \'Stop\' button, this command will be executed , where ^C represents the Ctrl+C signal.","TXT_CODE_7ec87e8a":"Cancel Upload","TXT_CODE_7ec9c59c":"Instance: ","TXT_CODE_7f0017d2":"Panel Port","TXT_CODE_7f0c746d":"Operation Successful","TXT_CODE_7f0daff7":"Fix Entity Position Syncronization Issue","TXT_CODE_7f1aef9f":"MC Bedrock Edition","TXT_CODE_7f31b67d":"Hopper Count","TXT_CODE_7f52e10d":"Attack damage (in half hearts)","TXT_CODE_7f5ee413":"The explosion radius of a wither\'s projectile attack","TXT_CODE_7f8f267f":"Velocity Proxy Secret Key","TXT_CODE_7f9b6758":"Optional, please use the absolute path of Java, if not provided, it defaults to the environmental variable","TXT_CODE_7fa8720d":"Start Command (No Line Breaks)","TXT_CODE_7fc92d9":"When opening the command prompt for the first time, Bedrock clients can sometimes freeze. Disabling this feature will prevent command suggestions from being sent and resolve freezing of Bedrock clients.","TXT_CODE_7fca723a":"Loading. If there is no response for a long time, please check the network.","TXT_CODE_8028e95b":"Enter your panel username, new account will be created if not exists","TXT_CODE_8036ea5e":"No mapping is set.","TXT_CODE_806441b5":"Sneak and right-click a pig with a saddle on it\'s back to remove it with this option enabled","TXT_CODE_80747f11":"Output of <minute> placeholder in command.uptime.format option","TXT_CODE_8074a178":"New Expiry Date:","TXT_CODE_80766ddc":"Simplified Commands","TXT_CODE_80790069":"Optional, e.g., 1024","TXT_CODE_808e5ad9":"Only ZIP compressed files can be uploaded","TXT_CODE_80a560a1":"Username","TXT_CODE_80c5409f":"Cover Image","TXT_CODE_80c85070":"Environment Requirements","TXT_CODE_80f0904e":"Professional Edition","TXT_CODE_81297804":"For example, commands, filenames, or other parameters, etc.","TXT_CODE_812a629e":"Browser unable to connect to address:","TXT_CODE_8145d25a":"Select Instance","TXT_CODE_8145d82":"Save Layout","TXT_CODE_814a3c64":"Max Flying Monsters Awakened per tick","TXT_CODE_81634069":"Version","TXT_CODE_816ae222":"Output of <days> placeholder in command.uptime.format option","TXT_CODE_8175818c":"Block fall multiplier for yellow bed","TXT_CODE_818928ba":"Supports any language; use a unique name when possible.","TXT_CODE_81979d0f":"Data storage directory","TXT_CODE_81ad9e80":"A more flexible way to create instances, without installing through the app marketplace.","TXT_CODE_81b9b599":"Copy Failed: ","TXT_CODE_81c2f4ae":"Set to false to disallow armorstands from moving in water","TXT_CODE_81cabec":"Sets whether the server should dump all configuration values to the server log on startup","TXT_CODE_81d7e7c5":"Open-source, distributed, and out-of-the-box management panel. Support Minecraft servers and all console programs.","TXT_CODE_8201d2c6":"Running / Total","TXT_CODE_820ebc92":"Mount Directory into Container","TXT_CODE_823bfe63":"Online","TXT_CODE_8259b3db":"The nearby range to check for shulkers","TXT_CODE_828ea87f":"Mount additional paths into the container.","TXT_CODE_8298bfde":"Maximum number of REST requests in the bucket before denying requests. Minimum value is 5.","TXT_CODE_82b18ea4":"What color should show when the ram usage is \'good\'","TXT_CODE_82c331f":"Hide Player Count","TXT_CODE_82d650be":"Installation Page","TXT_CODE_82e624d1":"MC-Mohist","TXT_CODE_82fbc5ad":"Action","TXT_CODE_8343c177":"Max Villagers Awakened per tick","TXT_CODE_8366db5a":"End City Seed","TXT_CODE_836addb9":"(Offline)","TXT_CODE_837501b0":"Base speed of minecart when controlled","TXT_CODE_83856178":"Maximum animals that can spawn per world","TXT_CODE_83914d85":"Allow Remote Access to Server Console (RCON)","TXT_CODE_83c9cb05":"Chunk Unload Delay","TXT_CODE_83d5cbbe":"Set to false to stop zombie villagers from being curable","TXT_CODE_83d8e4a1":"Please enter the update command","TXT_CODE_83e553fc":"Failed to Retrieve Configuration File List","TXT_CODE_84099e5":"Ensure that the remote daemon address is a public IP and the port is properly forwarded.","TXT_CODE_842929d0":"ZIP decompression failed: {{message}}","TXT_CODE_845b8bd8":"Block fall multiplier for purple bed","TXT_CODE_846683e4":"Stops the dolphin from treasure hunting","TXT_CODE_849c3911":"The chance a turtle egg will crack","TXT_CODE_84bf49c9":"Disk I/O:","TXT_CODE_84cf0951":"Cannot get merchant info","TXT_CODE_84d56d69":"Send Full Position Information for Hard Colliding Entities","TXT_CODE_84f760fa":"Usually a .jar file, like paper.jar, etc.","TXT_CODE_84fbe277":"Overview","TXT_CODE_8504218":"Adds a cooldown to breeding animals per animal type","TXT_CODE_855c4a1c":"Players: ","TXT_CODE_85617390":"Wednesday","TXT_CODE_856bd2f3":"Temporary Banned IPs","TXT_CODE_8575f7c":"Permission: ","TXT_CODE_85770d4a":"Suffix Parameters","TXT_CODE_858d8728":"Increase Hatch Time","TXT_CODE_859b2d24":"Suggest Player Names in Tab-Completion When Blank","TXT_CODE_85a33a84":"Rebind","TXT_CODE_85b01e01":"Set PvP mode. Valid types are \'normal,\' \'always,\' and \'disabled.\'","TXT_CODE_85d134f2":"Whether Creatures Spawned by Limited Spawner can Jump.","TXT_CODE_85d8d0a3":"Send debug messages to console.","TXT_CODE_86076132":"How blind a mob is when affected with the blindness potion effect","TXT_CODE_860e2ce":"Set whether iron golems can swim or not","TXT_CODE_8631c629":"Controls if armor should limit how much damage they can reduce.","TXT_CODE_8638bb65":"Max speed of a minecart when controlled","TXT_CODE_8677ef57":"Set to false to make thunder continue even after a player sleeps","TXT_CODE_868df02c":"About DockerFile","TXT_CODE_86ab6e1e":"Disable Mushroom Block Updates","TXT_CODE_86caaf6c":"Advanced Options","TXT_CODE_86e0cccc":"Address must be filled in","TXT_CODE_86ff658a":"Configure SSL, reverse proxy, etc., require additional support for the Websocket protocol.","TXT_CODE_870b392e":"Maximum number of phantoms to spawn per attempt (Use -1 to base this off of world difficulty)","TXT_CODE_8717ed9d":"Please enter environment requirements","TXT_CODE_871cb8bc":"Go to the App Market to install applications","TXT_CODE_871fb0d6":"Failed : Successful","TXT_CODE_871feca":"Enable Brigadier Syntax Highlighting","TXT_CODE_875e804b":"What Difficulty Zombie Villagers Break Doors","TXT_CODE_877eea45":"[Optional]Managed by panel by default. If provided, require absolute path, e.g. C:/Servers/MyServer","TXT_CODE_877ef60c":"Percent chance (0.0 - 1.0) a vindicator named \'Johnny\' will spawn instead of a vindicator","TXT_CODE_87c20d47":"Max jump strength attribute","TXT_CODE_87c5dcb4":"The actionbar message that appears when the night has been skipped. Set to \'default\' to let the client\'s use their own translatable components. Set to an empty string to disable it.","TXT_CODE_87e18bb5":"Broadcast boss spawns or invasion start.","TXT_CODE_87e448ae":"Server Binding IP, leave blank if not binding","TXT_CODE_87f0a517":"Disable Chest Cat Detection","TXT_CODE_880fedf7":"Reset filter conditions","TXT_CODE_881213df":"What should the MOTD be? When players add your server to their server list, this information will be displayed. Only accepts MiniMessage format.","TXT_CODE_88122886":"Compress","TXT_CODE_88249aee":"Server Template Market","TXT_CODE_88405298":"Whether snowballs, when thrown, should extinguish candles","TXT_CODE_88419e99":"Max Block Height","TXT_CODE_88427611":"For custom superflat world generation. Leave empty to disable.","TXT_CODE_88c990a4":"Modpack Size","TXT_CODE_88e9361a":"Instance","TXT_CODE_88f7082":"Set to true for evokers to bypass the mob griefing gamerule","TXT_CODE_890aa44c":"RCON Port","TXT_CODE_893567ac":"Second confirmation","TXT_CODE_894b8e52":"Reached the maximum auto-restart limit","TXT_CODE_8956123b":"Should we forward IP addresses and other data to backend servers?","TXT_CODE_8965b2cf":"Server name sent to JAVA clients. Visible in both the pause menu and settings menu.","TXT_CODE_8981d724":"Unnamed Title","TXT_CODE_8a30e150":"All Languages","TXT_CODE_8a5274c1":"In miliseconds, how long does BungeeCord uses cached results of server pings before actually pinging them for player count, set to -1 to disable","TXT_CODE_8a71a4d7":"Set to true for fireballs to bypass the mob griefing gamerule","TXT_CODE_8a7c57b9":"Allows you to set the doors that require redstone to be operated (oak, spruce, etc)","TXT_CODE_8a924345":"Whether to use ServerName instead of the world name.","TXT_CODE_8a9c6364":"7zip decompression warning: {{warning}}","TXT_CODE_8a9fd2b4":"Phantoms Only Attack Insomniacs","TXT_CODE_8aa7f7a0":"Can skeleton horses swim in water. False makes them sink to the bottom (vanilla default)","TXT_CODE_8ab0cc1a":"Prevent hardcore players from dying.","TXT_CODE_8ae0dc90":"UI background image","TXT_CODE_8b0f8aab":"New Card","TXT_CODE_8b14426e":"File already exists in this folder, Upload skipped","TXT_CODE_8b62abb2":"Remote Daemon Image List","TXT_CODE_8b8c52f":"You are not whitelisted!","TXT_CODE_8b8e08a6":"Creation Time: ","TXT_CODE_8b937b23":"Remove Daemon","TXT_CODE_8bb8e2a1":"Merchant Mode","TXT_CODE_8bd1f5d2":"is already exists in this folder, should overwrite it?","TXT_CODE_8be0e39b":"Amount of ticks between the drowning damage","TXT_CODE_8bf86cbc":"Set to false to disable TE\'s display names being persistant after breaking (ex. named custom player heads stop retaining their name)","TXT_CODE_8c0db3f4":"Please provide the startup command.","TXT_CODE_8c17acf8":"Port Mapping","TXT_CODE_8c18a6ac":"The projectile offset of a bow","TXT_CODE_8c2ad2cb":"Allow players to place tiles (grass, planters, etc.) in invalid places.","TXT_CODE_8c3164c9":"Profile","TXT_CODE_8c7318b3":"Start Instance","TXT_CODE_8cb5a1e6":"The amount of rows a barrel should have. Min: 1, Max: 6","TXT_CODE_8cba8d40":"Set whether iron golems can spawn in the air, like in 1.12 and below","TXT_CODE_8cc8e9e2":"The base value to set for the attack damage of the slime","TXT_CODE_8ccb5428":"File List Refreshed","TXT_CODE_8cfa8c1e":"Hopper Can Load Chunks","TXT_CODE_8d4882b0":"Optional, not recommended to fill unless there are specific requirements.","TXT_CODE_8d4c8f7e":"Failed to take over running container","TXT_CODE_8d4e6058":"Check Libraries","TXT_CODE_8d5d8e26":"Swamp Hut Seed","TXT_CODE_8d6c8ae7":"Please enter a template description","TXT_CODE_8d6e5b1f":"Strictly Check Dimension Progression","TXT_CODE_8d83752":"Only official game download URLs and ZIP files are supported","TXT_CODE_8d8b1d6a":"Create Minecraft Instance","TXT_CODE_8d8fbbf4":"Add a mapping","TXT_CODE_8d9f5a4e":"Initiates the instance start operation as long as the remote daemon is running.","TXT_CODE_8da44b20":"Block fall multiplier for black bed","TXT_CODE_8dbcf565":"Package Size (Optional)","TXT_CODE_8dd7bc1a":"Max Chunk Loading Rate per Player","TXT_CODE_8deb2054":"Giving the iron golem a poppy calms it down when it\'s angry","TXT_CODE_8dfc41ef":"Host","TXT_CODE_8dfd8b17":"Indefinite","TXT_CODE_8e16ee21":"Click to upload template file","TXT_CODE_8e223f23":"No data available for download","TXT_CODE_8e2be926":"Please enter the IP address of the game server, leave blank for the local host (localhost) by default.","TXT_CODE_8e5f865e":"Database type used for storing data (sqlite or mysql).","TXT_CODE_8e632796":"Server Address","TXT_CODE_8eb1ae3e":"Set to true to impose teleport restrictions on nether portals. This broadcasts the EntityTeleportHinderedEvent event which gives the ability to retry teleports if they fail due to having passengers/being vehicles","TXT_CODE_8f20c21c":"Are you sure you want to discard the layout changes?","TXT_CODE_8f3582d7":"Configuration Version","TXT_CODE_8f3e5807":"MC-Nukkit","TXT_CODE_8f47d95":"Saved via shortcut keys!","TXT_CODE_8f809a5":"Duration of Animal Awakening (in ticks)","TXT_CODE_8f8103b7":"Container","TXT_CODE_8f9533b5":"Enable Anti-Xray Functionality","TXT_CODE_8fac22fc":"What color should show when fill-mode is \'low\'","TXT_CODE_8fac56fb":"Time before item disappears","TXT_CODE_8facd134":"Click here","TXT_CODE_8fd7a9a1":"Make sure Docker is installed on this machine!","TXT_CODE_8fd8bfd3":"Selected Items","TXT_CODE_8fe9c7f7":"Enable Whitelist (old version)","TXT_CODE_903a9ec9":"Music player card","TXT_CODE_903b6c50":"User does not exist, please try again","TXT_CODE_903dfe61":"Simulated Distance","TXT_CODE_90508729":"This operation will directly delete the entire directory where the instance is located, and the files cannot be recovered. Do you want to continue?","TXT_CODE_9066472a":"etting this to false allows levels to go up to \'32767\' by storing them as shorts instead of bytes.","TXT_CODE_906c5d6a":"Deletion Completed!","TXT_CODE_90865a4":"Disables the method profiler.","TXT_CODE_90896d08":"Default group name for unregistered player accounts.","TXT_CODE_908a4ace":"Missing volume file","TXT_CODE_90912e04":"Disable gravestone drops when players die.","TXT_CODE_9095d186":"Maximum amount of exp value to drop on death","TXT_CODE_90a9d317":"Container Environment Variables","TXT_CODE_90b2ae00":"MCSManager prioritizes light mode for better user experience, dark mode may have poorer experience for some interfaces.","TXT_CODE_90b596a8":"The format of the bossbar when the server runs the /rambar command","TXT_CODE_90e959d2":"Enable compatibility with the HAProxy PROXY protocol on the proxy. Do not enable this unless you know what it\'s for.","TXT_CODE_90edf4ad":"Max Connections per Tick","TXT_CODE_90f00679":"Path for the sqlite database.","TXT_CODE_90f684dc":"[General] eula.txt","TXT_CODE_912ec943":"Outdated Client! Please use {0}","TXT_CODE_91381d5c":"If enabled (default is false) and the proxy is in online mode, Velocity will kick any existing online players if they attempt to rejoin.","TXT_CODE_91507ef3":"Enable Forge Support","TXT_CODE_9156fbc":"Execution count, Empty means unlimited times","TXT_CODE_91734638":"Enable server authoritative movement","TXT_CODE_91a8d35c":"Percent chance (0.0-1.0) the killer rabbit naturally spawns","TXT_CODE_91b3fa98":"The panel cannot determine if this configuration file is compatible, please navigate to the corresponding file interface based on its type.","TXT_CODE_91bb6101":"Panel/Linux (UTF8)","TXT_CODE_91d066aa":"7zip not loaded, decompression of multi-volume archives is not supported. Multi-volume archives (including zip, 7z, rar, etc.) require 7zip support to be enabled for proper decompression. Please contact the administrator to try installing the 7zip dependency library.","TXT_CODE_91d70059":"Instance Directory:","TXT_CODE_91d857f5":"Optional, from 0 to infinity.","TXT_CODE_91ebfa75":"Flying speed attribute","TXT_CODE_921206fc":"Edit Template","TXT_CODE_9213f8e3":"Configuration file for Pufferfish. It allows for further configuration of a paper server.","TXT_CODE_925af648":"Glow Berries Growth Speed","TXT_CODE_9268932c":"Save on Region Flush","TXT_CODE_9277af78":"Retry","TXT_CODE_9278b7b0":"If engaged in commercial activities, consider using container to protect the host.","TXT_CODE_928653c6":"Entities Within Follow Range Targeted by Selector","TXT_CODE_929a9ee4":"MySQL database username.","TXT_CODE_92bedafa":"Compress network traffic to Bedrock Edition clients. Higher values result in higher CPU usage but lower bandwidth usage. -1 or values less than 9 have no effect. Set to -1 to disable.","TXT_CODE_92c21a08":"Connect to Java server without creating a TCP connection.","TXT_CODE_92ebdc7f":"The ZIP files compressed by the panel will all be packaged in UTF-8 encoding. If you need to decompress, please select UTF-8 encoding to decompress!","TXT_CODE_930d2524":"Frontend Connection","TXT_CODE_93191a82":"Broadcasts the death messages in chat only to the affected player","TXT_CODE_931e4c8":"The speed in which a cauldron fills with rain (depends on random tick)","TXT_CODE_9337bed1":"It doesn\'t look like there are any remote nodes here. Maybe there was a problem during the installation process. Restarting your panel and daemon will solve it!","TXT_CODE_9341498a":"Update Radius","TXT_CODE_93610b08":"Makes this mob mount able in water (it wont eject you)","TXT_CODE_9364ec40":"Max Animals Awakened per tick","TXT_CODE_937b42e6":"Hunger Depletion Multiplier for Sprinting","TXT_CODE_9393b484":"Assign","TXT_CODE_9394aadf":"Whether to kick players who exceed the TileLiquid threshold.","TXT_CODE_93a70cda":"Parameters Required for the Card","TXT_CODE_93afb039":"Addresses MC-3304 by preventing looting from being applied to deaths caused by a projectile, unless if a plugin changed the looting modifier.","TXT_CODE_93c3cb78":"For this address to work, you may need to configure node direct connection mappings.","TXT_CODE_93d4b66a":"File operation started. It may take some time.","TXT_CODE_93f9b02a":"Daemon IP","TXT_CODE_94002354":"Prevent players from logging in with their client UUID.","TXT_CODE_941d83b8":"Path prefix","TXT_CODE_9466852b":"This card can be used for sectioning or formatting, like titles in an article.","TXT_CODE_946d4401":"Whether to kick players who exceed the Projectile threshold.","TXT_CODE_94b6cd6e":"Configure your forced hosts here.","TXT_CODE_94bb113a":"Size","TXT_CODE_94bcd51b":"Hanging block update frequency","TXT_CODE_94c193de":"Name","TXT_CODE_94d4c80c":"Prevent Bedrock players from scaffold bridging.","TXT_CODE_94d885d1":"Set this to true to enable showing debug information about attributes on an item when advanced tooltips is on.","TXT_CODE_94f1ba3":"After selecting this template, all data of this instance will be deleted. Please compress and download the file backup in file management first. Do you want to continue?","TXT_CODE_94f55150":"Visual preset template editor","TXT_CODE_950c0d7a":"Twisting Vines Growth Speed","TXT_CODE_952c2697":"Increase or decrease the percentage to make the detection range of the mob smaller or larger when a player is wearing the mobs corresponding head","TXT_CODE_95340802":"Kick hardcore players.","TXT_CODE_9535104c":"Set to false to stop the creeper from griefing.","TXT_CODE_95495db":"Actions","TXT_CODE_95583336":"Minecraft Server - Java","TXT_CODE_958fd70c":"About this Configuration File","TXT_CODE_95b08ec3":"Makes the creeper explode when killed","TXT_CODE_95b9833f":"Return to Console","TXT_CODE_95bdc950":"Resource Pack URI pointing to a resource pack. Players can choose whether to use it.","TXT_CODE_95c5e900":"Complete image name, e.g. openjdk:17","TXT_CODE_95c65dc1":"Set to true for sheep to bypass the mob griefing gamerule","TXT_CODE_95d43994":"The minimal level of the Silktouch enchantment required to pick up mined spawners","TXT_CODE_95df80df":"Provided as a more professional interface.","TXT_CODE_95dfd5bd":"Maximum MP a player can have before equipping buffs.","TXT_CODE_96281410":"Path not found.","TXT_CODE_962d9320":"The working directory where the instance runs. You can provide either an absolute or relative path.","TXT_CODE_962f4288":"User cache size","TXT_CODE_9651d0b3":"Damage is multiplied by speed if flight is faster than set speed. Value of 0 disables this multiplier","TXT_CODE_96520bce":"Maximum number of custom heads displayed per player.","TXT_CODE_965360cd":"Generation protection radius.","TXT_CODE_9654b91c":"Are you sure you want to log out this user?","TXT_CODE_96c02044":"Percent chance (0.0 - 1.0) this mob will spawn aggressive towards players","TXT_CODE_96e6bf5d":"End portal sound effect radius","TXT_CODE_9740f199":"The changes made will be lost. Do you want to proceed?","TXT_CODE_97433ac4":"More","TXT_CODE_97535446":"Change the player name used when chatting above the head. Start with player names enclosed in square brackets, following the Terraria format. Same format as ChatFormat but excluding the message.","TXT_CODE_97655c5d":"For containers to access each other in a custom network, separated by spaces.","TXT_CODE_9775ccb":"Switching to dark mode?","TXT_CODE_977cb449":"Waiting for download...","TXT_CODE_978491ec":"Connection Timeout","TXT_CODE_978da1c1":"Building","TXT_CODE_979b9aaf":"Disable player-customized skins outside of the Minecraft store or in-game resources","TXT_CODE_97b80a79":"Whether minecarts can be placed anywhere, not just on rails","TXT_CODE_97be50a8":"Great Success!","TXT_CODE_97ceb743":"Please Select Decompression Encoding","TXT_CODE_97d17cce":"Users","TXT_CODE_97e5eccb":"Used to display detail of a specific instance.","TXT_CODE_97f5701e":"Allow players to fly (in all game modes)","TXT_CODE_97f5d91f":"How many quick connects should clients be allowed after their last connect? Default is three seconds. Set to 0 to disable this feature.","TXT_CODE_97f779b3":"MC Java Edition","TXT_CODE_97ff044f":"Enable Command Blocks","TXT_CODE_981c59e6":"Parrots Not Affected by Player Movement","TXT_CODE_9867da6b":"Whether the server displays a warning when deprecated events are registered by plugins","TXT_CODE_98742e5f":"The color of the bossbar","TXT_CODE_9878c2bc":"By default, Velocity will attempt to gracefully handle connection loss for users connecting to the server rather than disconnecting them.","TXT_CODE_9885543f":"Terminal failed to initialize, possibly due to the remote daemon or instance no longer exists. Please refresh the page and retry.","TXT_CODE_98b4ac74":"MC-NeoForge","TXT_CODE_98dbd049":"Suggest not to exceed 3 lines","TXT_CODE_98e50717":"Configuration file for Purpur. It allows for further configuration of advanced parameters and more specific game settings. It greatly affects overall performance and expands upon the limitations of the Paper configuration file.","TXT_CODE_98e7c829":"Leave empty to use default Docker image command","TXT_CODE_9900f79e":"Image","TXT_CODE_9901af98":"Tags (Optional)","TXT_CODE_9911ac11":"Failed to save, please check the configuration","TXT_CODE_99167cda":"Whether minecarts can be controlled when not on rails","TXT_CODE_992bf9bc":"MC Bukkit","TXT_CODE_998d1dec":"Block fall multiplier for orange bed","TXT_CODE_99a42341":"eg: https://example.com/image.png","TXT_CODE_99ca8563":"Overwriting File","TXT_CODE_99e98174":"Calculate All Entities for Spawning","TXT_CODE_99f8edf0":"Set to true to set can_summon to true on placement","TXT_CODE_99fab05d":"Whether respawn anchors explode. Setting this to false just makes the respawn anchors blip out of existence","TXT_CODE_9a6e35e4":"Disable Player Interactions","TXT_CODE_9aa1872c":"List of items that are immune to lightning","TXT_CODE_9aa83c05":"By default, it inherits and uses the system user of Launchpad","TXT_CODE_9ab6fd":"User <<operator_name>> created the <<instance_name>> instance","TXT_CODE_9ac035d0":"Server Name Privacy Setting","TXT_CODE_9ac051fb":"Mark unavailable item slots in the Bedrock Edition player inventory.","TXT_CODE_9ade0fb8":"Failed to set 7zip file permissions: {{message}}","TXT_CODE_9afe56de":"Upload Rate","TXT_CODE_9b36d5a2":"[General] server.properties","TXT_CODE_9b3ce825":"Reverse proxy description","TXT_CODE_9b45858c":"Quickly install applications using preset templates","TXT_CODE_9b4985d3":"Instance updated successfully!","TXT_CODE_9b5dcfdd":"Sample Count","TXT_CODE_9b8f02fd":"Compression Algorithm","TXT_CODE_9b99b72e":"Quickly Deploy Application Instances","TXT_CODE_9b9b745c":"Create OpenJDK 17 Environment Image","TXT_CODE_9bb2f08b":"User Profile","TXT_CODE_9bc7f49e":"Instances currently stopped","TXT_CODE_9c188ec8":"Visit https://docs.mcsmanager.com for more information.","TXT_CODE_9c2250b7":"Set to true to fix items modified by NetworkItemSerializeEvent that persist even though they\'re client-sided due to the creative client using creative inventory actions","TXT_CODE_9c247f6":"Container Working Directory Mount","TXT_CODE_9c39c7ae":"Display chat messages above player heads.","TXT_CODE_9c3ca8f":"Security","TXT_CODE_9c7f8eb8":"How effective mending is at repairing items, higher values mean less xp is used to repair items. (1.0 = 100%)","TXT_CODE_9c95b60f":"Error Information:","TXT_CODE_9c9c19f0":"Keep Respawn Points Loaded","TXT_CODE_9cae6f92":"Image download timeout! Max: 15 minutes. Please check your network!","TXT_CODE_9cefd73":"Auto-save.","TXT_CODE_9d1d244f":"Program startup failed, input and output streams are unreadable: {{pipeName}}","TXT_CODE_9d2fca76":"Do not automatically restart if the auto-restart count is reached. (Set to -1 for no limit)","TXT_CODE_9d498b20":"Settings saved","TXT_CODE_9d820cb4":"Details","TXT_CODE_9d8e6107":"Allow players to use leads on villagers (trader not included)","TXT_CODE_9d902725":"What Difficulty Zombified Piglins Break Doors","TXT_CODE_9d982f06":"Enable IP Forwarding","TXT_CODE_9dc4ee75":"Set to true for powdered snow to bypass the mob griefing gamerule","TXT_CODE_9df0f923":"Ocean Ruin Seed","TXT_CODE_9df68e04":"Prevents loading plugins with incompatible APIs","TXT_CODE_9df98e2":"Building configuration...","TXT_CODE_9e090ff6":"How much exp to drop on death. Available NMS variables are expLevel, expTotal, and exp","TXT_CODE_9e1657b":"Block fall multiplier for pink bed","TXT_CODE_9e33445e":"Right-clicking a skeleton while holding a wither rose will convert the skeleton into a wither skeleton. With the value being how many wither roses you would need to convert the skeleton, and 0 meaning the feature is disabled.","TXT_CODE_9e3f25e0":"Minecraft Server (Java)","TXT_CODE_9e5eb2a":"Scan for existing chickens to spawn on","TXT_CODE_9e8c176e":"Used to view user operation logs","TXT_CODE_9e9c0179":"How long the delay of a big dripleaf should until it goes into the next animation","TXT_CODE_9e9d3767":"If you engage in commercial activities, please run instances with Docker containers on Linux to avoid security risks.","TXT_CODE_9eacb622":"Process Startup Method","TXT_CODE_9eb5dd12":"Block fall multiplier for magenta bed","TXT_CODE_9ef27367":"Permanently Delete","TXT_CODE_9f174887":"Read Disk","TXT_CODE_9f28d67b":"World Generation Type (default, flat, amplified, largeBiomes)","TXT_CODE_9f4eaa41":"Please select a game type","TXT_CODE_9fb9e6a8":"Set to false to stop babies from being ridable","TXT_CODE_9fd05002":"Set whether a bee should die after stinging","TXT_CODE_9fe98f3":"Listening Port","TXT_CODE_9fed23ab":"Please enter the image name","TXT_CODE_A0000001":"Applicable to the startup command of any console program, script files are not supported.<br />For example: \\"C://Program Files/Java/bin/java.exe\\" -Dfile.encoding=utf-8 -Djline. terminal=jline.UnsupportedTerminal -jar my server.jar -nogui","TXT_CODE_ETA":"ETA","TXT_CODE_Instance_router.accessFileErr":"File does not exist or the path is incorrect, file access is denied","TXT_CODE_Instance_router.cancelIO":"Session {{id}} requests the cancellation of forwarding instance {{targetInstanceUuid}} IO stream.","TXT_CODE_Instance_router.openInstanceErr":"Error occurred while starting instance {{instanceUuid}}:  ","TXT_CODE_Instance_router.performTasks":"Session {{id}} requests instance {{uuid}} to perform asynchronous task: {{taskName}}","TXT_CODE_Instance_router.performTasksErr":"Exception occurred while executing {{taskName}} asynchronous task for instance {{uuid}}: {{err}}","TXT_CODE_Instance_router.requestIO":"Session {{id}} requests the forwarding of instance {{targetInstanceUuid}} IO stream.","TXT_CODE_Instance_router.taskEmpty":"No asynchronous tasks are currently running.","TXT_CODE_Instance_router.terminalLogNotExist":"Terminal log file does not exist.","TXT_CODE_Speed":"Speed","TXT_CODE_a00e84d7":"Deleted","TXT_CODE_a02a0849":"This value defines how often in ticks, the furthest entity will get their pathfinders and behaviors ticked.","TXT_CODE_a0451c97":"Cancel","TXT_CODE_a08f261e":"Enable portal generation for piglins","TXT_CODE_a092b6f0":"List of items that are immune to cactus","TXT_CODE_a0a00fc0":"Allow minecarts to damage/break turtle eggs","TXT_CODE_a0a77be5":"Cannot execute, please select at least one instance","TXT_CODE_a0a99beb":"Gives parrots the ability to breed using any type of seeds (baby parrots don\'t exist D:, so \'adult\' parrots pop out)","TXT_CODE_a0d214ac":"e.g., 1024, 2048, etc.; do not include units.","TXT_CODE_a0e19f38":"Delete instance","TXT_CODE_a0e70887":"Matched Daemon Version","TXT_CODE_a0eb8b37":"Disable Ice and Snow Effects","TXT_CODE_a0ede210":"7zip program not found","TXT_CODE_a106108c":"Upload music file","TXT_CODE_a112cff4":"Priority Settings","TXT_CODE_a132c796":"Allow exp orbs to damage/break turtle eggs","TXT_CODE_a1587e9d":"Should the server log player IP addresses.","TXT_CODE_a1833a27":"The base value to set for the attack damage of the magma cube","TXT_CODE_a1a59b08":"Panel Language","TXT_CODE_a1cc8b68":"Can zombie horses swim in water. False makes them sink to the bottom (vanilla default)","TXT_CODE_a1d885c1":"Add","TXT_CODE_a1e4c720":"Allows the ability to increase enchantments passed their max level through the command","TXT_CODE_a22e749a":"Disable Player Crits","TXT_CODE_a2544278":"Instance tag","TXT_CODE_a2a0e054":"For example: server.exe, app.exe, or use an absolute path, etc.","TXT_CODE_a2c8c88a":"Distance before stop loading chunks (allowed values: 4, 12).","TXT_CODE_a379038f":"Server port","TXT_CODE_a3991784":"Change the accuracy with which Skeletons shoot. The outcome of the formula is the divergence (spread). The higher the value, the less accurate the shot is.","TXT_CODE_a3abb092":"MC Velocity","TXT_CODE_a3de630":"Enter redemption code used for purchase","TXT_CODE_a3efb1cc":"Import Compressed Package","TXT_CODE_a3f13157":"Container Protection","TXT_CODE_a3f8313f":"Area of blocks that a sponge absorbs water","TXT_CODE_a4037a98":"Interface Requests","TXT_CODE_a409b8a9":"Stopping","TXT_CODE_a41a4820":"Villager Nearby POI Validation Time","TXT_CODE_a42984e":"Variable Name","TXT_CODE_a463be37":"The format of the bossbar when the server runs the /compass command","TXT_CODE_a4748cb0":"Please enter the RCON protocol port of the game server, usually found in the configuration file.","TXT_CODE_a4757fec":"Admin User Group Permissions","TXT_CODE_a48bdb09":"Amount of blocks the effect range reaches for this level","TXT_CODE_a492ae63":"Start Binding","TXT_CODE_a4efbd21":"Allow spawners to be deactivated by redstone","TXT_CODE_a519b5ff":"Enable Player Collisions","TXT_CODE_a53573af":"Refresh","TXT_CODE_a5830778":"Please enter a new name.","TXT_CODE_a583cae4":"Allow normal users to edit instance advanced configuration","TXT_CODE_a584cb71":"Specify the instance image.","TXT_CODE_a59981f4":"Leave blank for unlimited","TXT_CODE_a5bdf2d8":"Block fall multiplier for cyan bed","TXT_CODE_a5f01916":"Allow Instance Reset","TXT_CODE_a5f7d835":"Zombie","TXT_CODE_a621f370":"Sunday","TXT_CODE_a62886b9":"File read failed","TXT_CODE_a6424dcc":"The working directory or startup command cannot be empty","TXT_CODE_a6453188":"Please select the decompression mode","TXT_CODE_a64da7c4":"Auto Restart","TXT_CODE_a64f3007":"Unzip","TXT_CODE_a65c65c2":"Therefore, Public IP or Domain (except for localhost) must be used for daemon connection.","TXT_CODE_a66ea585":"Maximum Attack Damage","TXT_CODE_a674a475":"Number of inconsistencies needed before reporting abnormal behavior","TXT_CODE_a676f2da":"Got it","TXT_CODE_a6878a01":"Limit how many consecutive chunk updates can be done before skipping the rest. Negative values remove the limit.","TXT_CODE_a68b3a9c":"Maximum Spawn Memory","TXT_CODE_a6a04fa3":"Spawn villagers","TXT_CODE_a6f5af58":"Dungeon Seed","TXT_CODE_a6f8f61a":"Allow custom heads to be displayed.","TXT_CODE_a725a5b1":"Message that shows when the tpsbar is enabled for a user using the /tpsbar command.","TXT_CODE_a77b1a21":"The maximum allowed time difference between client devices and the server when generating and verifying TOTP codes.","TXT_CODE_a7813c72":"Set to true for the ender dragon to bypass the mob griefing gamerule","TXT_CODE_a7885cbc":"Controls the container\'s preference for using virtual memory pages, ranging from 0 to 100.","TXT_CODE_a788e3eb":"Memory & CPU","TXT_CODE_a7907771":"Saved Successfully","TXT_CODE_a7aa53a3":"Sets the server to use for profiles.","TXT_CODE_a7c73a51":"7zip successfully loaded: {{info}}","TXT_CODE_a7c85e67":"Add Hyperlink","TXT_CODE_a7e1976":"The amount of damage to take after teleporting using an ender pearl","TXT_CODE_a7e9d4e":"Close","TXT_CODE_a7e9ff0f":"Min","TXT_CODE_a7f6b0e0":"Container Resource Limitation","TXT_CODE_a85091a4":"Automatically assigned by default","TXT_CODE_a8839b35":"Once Rcon Protocol is enabled, all commands entered at the console will be sent in RCON mode and will no longer be compatible with the original console program.","TXT_CODE_a884de59":"Display Name","TXT_CODE_a89ab67c":"Maximum connected player count.","TXT_CODE_a8a375ae":"Controls whether overstacked items are allowed in shulker boxes (default fixes chunk ban issue PaperMC/Paper#4748)","TXT_CODE_a8b0dfab":"Spawn Protection Radius (radius is calculated by 2x+1, set to 0 to protect only the block under spawn point). Since version 1.5, setting to 0 or a negative value disables spawn protection.","TXT_CODE_a8b245fa":"Initialization of some modules failed. Please check whether the files under daemon/lib exist or whether the permissions are normal!","TXT_CODE_a8b402a9":"Enable debug logging.","TXT_CODE_a8f82885":"ump height modifier. Default value of 1.0 makes giants jump about as high as their waist","TXT_CODE_a8fe5e68":"Max movement speed attribute","TXT_CODE_a92a298e":"Cactus Growth Speed","TXT_CODE_a92a4aa1":"General Console Application","TXT_CODE_a92df201":"Unlimited","TXT_CODE_a94e89ef":"Output of <seconds> placeholder in command.uptime.format option","TXT_CODE_a95c0f85":"Enter code, e.g.: 2WJBUHJUD0VV5SYMC0F3HFFH","TXT_CODE_a9bcbde9":"Field must be a number","TXT_CODE_a9c9d05e":"Set to false to stop the campfire from being lit when placed","TXT_CODE_aa373641":"Please select a daemon","TXT_CODE_aa43b248":"Enter Console","TXT_CODE_aa47f5ed":"Set the default step height of armorstands. Useful for plugins that utilize armorstands as vehicles to be able to drive over blocks without jumping, etc","TXT_CODE_aaba7ab8":"Lets mobs/players ride on players if the player is in the water","TXT_CODE_aac98b2a":"Instance Settings","TXT_CODE_aadfb5c0":"Notify console and operators when there\'s new Geyser version support for Bedrock versions that this Geyser version doesn\'t support","TXT_CODE_aae2918f":"The instance process failed to start, please check the startup command and operating environment configuration!","TXT_CODE_aae43e39":"Set to true for pillagers to bypass the mob griefing gamerule","TXT_CODE_aaecb7ff":"List of speed overrides per block type","TXT_CODE_ab4504ca":"Control if illusioners naturally spawn in the game","TXT_CODE_ab483b69":"Allow soil to moisten from water directly below it","TXT_CODE_ab4cc2dc":"The End User License Agreement for Minecraft. You must accept EULA to use the server software.","TXT_CODE_ab4d93":"Show ping requests from clients.","TXT_CODE_ab5d758e":"Armor Stand Collide Entity Search","TXT_CODE_ab7672dd":"Minimum password length for new player accounts. Cannot be less than 4.","TXT_CODE_ab839970":"Velocity Enable","TXT_CODE_ab90dc44":"Set to true to disable trampling completely.","TXT_CODE_ab9f8bfb":"Radius crystals scan for phantoms to attack. Value of 0 disables feature","TXT_CODE_abac12f6":"The projectile offset of an ender-pearl","TXT_CODE_abadb770":"The amount of damage to apply to hostile mobs every 2 seconds if they are in contact with water/rain","TXT_CODE_abc080d":"Indefinite","TXT_CODE_abd2f7e1":"Reset Card Layout","TXT_CODE_abe0862e":"Used to display detailed information and status of remote daemonss.","TXT_CODE_abedfd03":"Deselect","TXT_CODE_abfe9512":"Save","TXT_CODE_ac01315a":"Are you sure you want to proceed with bulk removal? This operation will not delete the actual instance files.","TXT_CODE_ac0754f7":"Controls whether bees can work during rainy weather","TXT_CODE_ac10fe01":"Please enter the template URL","TXT_CODE_ac225d07":"Build instance parameters:","TXT_CODE_ac405b50":"Error","TXT_CODE_ac52ad06":"Force Halloween events to be held all year round.","TXT_CODE_ac696f4d":"By default, should plugins be displayed in query responses?","TXT_CODE_ac7a5f17":"Set the amplifier for the fire resistance effect","TXT_CODE_acabc771":"Sec","TXT_CODE_acd4abda":"Quick deployment using Docker image","TXT_CODE_ad14bcf3":"This is the main configuration file for Bedrock Edition dedicated servers. Most server settings, including server port, player count, view distance, and limit parameters, are configured in this file.","TXT_CODE_ad1c674c":"Protocol","TXT_CODE_ad207008":"Edit","TXT_CODE_ad24269a":"Please select an available node.","TXT_CODE_ad30f3c5":"Number of Starts: ","TXT_CODE_ad40abfb":"Hide Items with Visual Effects Metadata","TXT_CODE_ad5107bc":"Permission Group Settings","TXT_CODE_ad533c70":"Passwords must be between 9 and 36 characters and include uppercase letters, lowercase letters, and numbers.","TXT_CODE_ad5e2b0f":"Hyperlink","TXT_CODE_ad6c5d03":"Flying Monsters Awakened Every x Ticks","TXT_CODE_adab942e":"File Management for Users","TXT_CODE_adcce2c7":"Wait until a villager has been traded with before lobotomizing","TXT_CODE_addfcb6b":"Yes","TXT_CODE_ae09d79d":"Upload","TXT_CODE_ae0e0126":"Set to false to stop untamed tamables from being ridable","TXT_CODE_ae441ea3":"The additional mounting path of the instance container is configured incorrectly!","TXT_CODE_ae51f93b":"Renewal Success!","TXT_CODE_ae533703":"File Management","TXT_CODE_ae566b56":"Optimizes the suffocation check by selectively skipping the check in a way that still appears vanilla. This should be left enabled on most servers, but is provided as a configuration option if the vanilla deviation is undesirable.","TXT_CODE_ae575e12":"If you are using a reverse proxy to access the panel, turn this option on. \\nThe panel will obtain the real IP from the \\"X-Real-IP\\" in the request header.","TXT_CODE_ae747cc0":"Expiration Time: ","TXT_CODE_aea11899":"Player-Only Collisions","TXT_CODE_aeb10fea":"Use the same port as Java Edition","TXT_CODE_af11ca2a":"Max Chunk Generation Rate per Player","TXT_CODE_af143e18":"Clock","TXT_CODE_af19b7b5":"In general, default values can meet personal daily usage. However, as the scale grows, setting an appropriate threshold is crucial to avoid service interruption.","TXT_CODE_af1f921d":"Leave blank to keep the value unchanged, Two-step verification will also be reset.","TXT_CODE_af21e6b":"Panel Version","TXT_CODE_af28bbfd":"End Dragon Always Drops Dragon Egg","TXT_CODE_af2a6972":"Click the \'I have scanned\' button.","TXT_CODE_afabf3ca":"Parsing time failed","TXT_CODE_afb12200":"Containerization","TXT_CODE_afb7259b":"Format of Player TAB List Displayed to Players Connecting to the Server","TXT_CODE_afc104e0":"The projectile offset of a trident","TXT_CODE_afd43f2":"Timings Detailed Output","TXT_CODE_afde4995":"Local difficulty must be greater than a random value chosen between 0.0 and this value","TXT_CODE_all_platform":"All Platforms","TXT_CODE_app.addr":"Access URL: http://<IP address>:{{port}}/ or ws://<IP address>:{{port}}","TXT_CODE_app.configPathTip":"Configuration File: data/Config/global.json","TXT_CODE_app.developInfo":"Unable to start, this project is intended for MCSManager developers and cannot be run by regular users.\\nPlease visit https://mcsmanager.com/ for the latest installation instructions.\\nIf you intend to run in developer mode, create directory \'public\' and \'src/public\' along with frontend static files before running again.","TXT_CODE_app.doc":"Reference Documentation: https://docs.mcsmanager.com/","TXT_CODE_app.exitTip":"You can use the Ctrl+C shortcut to close the program","TXT_CODE_app.host":"Access URL: http://localhost:{{port}}","TXT_CODE_app.httpSetupError":"HTTP/Socket service startup error, possibly due to port occupation, insufficient permissions, or unavailable network device.","TXT_CODE_app.instanceLoad":"All {{n}} instances have been loaded.","TXT_CODE_app.instanceLoadError":"Failed to read local instance files:","TXT_CODE_app.panelStarted":"Control panel has started","TXT_CODE_app.password":"Access Key: {{key}}","TXT_CODE_app.passwordTip":"The key is the sole authentication method. Please connect using daemons section of MCSManager panel.","TXT_CODE_app.portTip":"Public access requires opening ports {{port}} and the daemon\'s port.","TXT_CODE_app.reference":"Project Reference: https://github.com/mcsmanager","TXT_CODE_app.sessionConnect":"Session {{ip}} {{uuid}} has connected","TXT_CODE_app.sessionDisconnect":"Session {{ip}} {{uuid}} has disconnected","TXT_CODE_app.started":"Daemon process has been successfully started","TXT_CODE_app.sysinfo":"Resource Report","TXT_CODE_app.welcome":"Welcome to MCSManager Daemon","TXT_CODE_auth_router.access":"Session {{id}} ({{address}}) has successfully authenticated","TXT_CODE_auth_router.disconnect":"Session {{id}} ({{address}}) disconnected due to prolonged unauthentication","TXT_CODE_auth_router.illegalAccess":"Illegal access","TXT_CODE_auth_router.notAccess":"Session {{id}} ({{address}}) attempted unauthorized access to {{event}} and has been blocked.","TXT_CODE_b01f8383":"Learn More","TXT_CODE_b026be33":"Two-Factor Authentication (TOTP) Time Drift Tolerance","TXT_CODE_b029a155":"The instance will not be able to start after expiration.","TXT_CODE_b02f295d":"Default config path for servers","TXT_CODE_b05948d1":"Permission changed.","TXT_CODE_b05c6947":"Allow Spiders to Cross World Borders","TXT_CODE_b078a763":"Available","TXT_CODE_b0794aeb":"The base value to set for the attack damage of the phantom","TXT_CODE_b08f61c5":"Maximum aquatic creatures that can spawn per world","TXT_CODE_b09eea4":"Monsters","TXT_CODE_b09eff8f":"Create OpenJDK 8 Environment Image","TXT_CODE_b0a18c20":"I have scanned","TXT_CODE_b0aa2db9":"Stopped!","TXT_CODE_b0ad88c4":"Should PROXY protocol be enabled when connecting to the server?","TXT_CODE_b0ae5b42":"Should AFK players have their name updated in the tab list (puts [AFK] in front of their name)","TXT_CODE_b0b67785":"Force world time to normal, day, or night.","TXT_CODE_b0c4e4ae":"CPU Core Assignment","TXT_CODE_b0e39fd":"Set to true for the wither to gain the ability to ride vehicles","TXT_CODE_b0f5847f":"Show Entity Tracking Range","TXT_CODE_b0ff4172":"Uploading {n} files in the background","TXT_CODE_b10cbef0":"Crafting Table Abuse Limit","TXT_CODE_b11166e7":"Instance Restarting","TXT_CODE_b12787d7":"Allow Nether (including End)","TXT_CODE_b128afa6":"New Card Title","TXT_CODE_b135e9bd":"Downloading...","TXT_CODE_b1446a00":"Working Directory Inside Container","TXT_CODE_b147fabc":"New","TXT_CODE_b152cd75":"Please select a file first.","TXT_CODE_b1600db0":"Instance Updating","TXT_CODE_b16dc70c":"Wither Skeleton","TXT_CODE_b16fc7a6":"Allow Players to Use Network Proxies to Connect to Server","TXT_CODE_b18c34fd":"Percent chance (0.0 - 1.0) this mob will spawn reinforcements","TXT_CODE_b197be11":"Loading Data...","TXT_CODE_b19ed1dd":"Reset","TXT_CODE_b1b30b86":"Makes the name visible when placing with a custom name","TXT_CODE_b1d19033":"Modify to change food properties.","TXT_CODE_b1d709bc":"Display the IP Address BungeeCord is Listening On","TXT_CODE_b1dedda3":"Stop","TXT_CODE_b1e2e1b4":"Clear Terminal Output","TXT_CODE_b1ef1d4a":"Archive data corrupted","TXT_CODE_b1f833f3":"Source for the quick install function. This can be modified to support custom predefined server packages. ","TXT_CODE_b1fd3eb1":"Port Forwarding Settings","TXT_CODE_b214a52d":"Allow Players to Attack Each Other","TXT_CODE_b2391fca":"Please select a secondary category","TXT_CODE_b23cc3e":"Optional, default: /workspace/","TXT_CODE_b23e2bab":"Placeholder Card","TXT_CODE_b251fa6d":"Item Display Name ID","TXT_CODE_b26a0528":"Host Daemon","TXT_CODE_b2767aa2":"Template Packages Config","TXT_CODE_b278707d":"If garbled file names are found during decompression/compression, modify this option.","TXT_CODE_b290a4b0":"Task Name","TXT_CODE_b2dbf778":"If you need to access the panel through third-party applications, you will require this key for authentication. Any requests made using this key will have the same level of access as this account.","TXT_CODE_b2e9a60":"Set to true to allow sponges to absorb lava","TXT_CODE_b2f1310e":"A config option mainly for developers. Logs out modded tags that are using the \'forge\' namespace when running on integrated server. Defaults to DEV_SHORT. Allowed Values: SILENCED, DEV_SHORT, DEV_VERBOSE, PROD_SHORT, PROD_VERBOSE","TXT_CODE_b30daa03":"Allow CrimsonCreep when the world is in hard mode.","TXT_CODE_b3127cba":"Chat color for the SuperAdmin group.","TXT_CODE_b3190a77":"Tick Non-Activated Villagers","TXT_CODE_b329418":"The amount of iron ingots required to repair an anvil","TXT_CODE_b32f926d":"Baby Zombie Movement Correction","TXT_CODE_b340c04a":"Please be patient.","TXT_CODE_b34efc1":"The container list represents all instances running in independent image environments. This list includes all and not limited to containers started by the panel.","TXT_CODE_b34f9eee":"Maximum Health","TXT_CODE_b355c681":"Kick Message for Exceeding Packet Handling Rate","TXT_CODE_b3581555":"The amount of powered rails that get activated by a single redstone source","TXT_CODE_b36320e1":"Set to true to always show the item used to kill the player in player death messages.","TXT_CODE_b36630b3":"Block fall multiplier for blue bed","TXT_CODE_b3796a8":"Output of <second> placeholder in command.uptime.format option","TXT_CODE_b37e6938":"Optional, adds a custom message that shows in the Resource Pack prompt when using \'require-resource-pack.\'","TXT_CODE_b3825da":"Processing...","TXT_CODE_b3844cf8":"Create an instance directly without uploading any files. Configure it later. This is suitable for experienced users.","TXT_CODE_b3cc1379":"Please enter the renewal code","TXT_CODE_b3e2f83e":"This card has no content and can be used as a placeholder for layout purposes such as centering.","TXT_CODE_b3ea8245":"Max Entity Collisions","TXT_CODE_b3f2ea10":"Fill in music URL","TXT_CODE_b45e73fb":"Number of seconds a player must wait before respawning if a boss is nearby. Range: 0 (default) to 30 seconds. Use at your own risk.","TXT_CODE_b47dbe7d":"Controls how many chunks a projectile can load in its lifetime before it gets automatically removed.","TXT_CODE_b488372f":"Everyone","TXT_CODE_b4a9d04a":"Daemons","TXT_CODE_b4d8588":"OS Version","TXT_CODE_b5022f5d":"Throttles the AI goal selector in entity inactive ticks.","TXT_CODE_b50ffba8":"The instance has been started...","TXT_CODE_b51bac6f":"To create an instance using a Docker image, you must ensure that Docker is installed correctly!","TXT_CODE_b5253fae":"Allow dropped items to damage/break turtle eggs","TXT_CODE_b52cb76c":"Please select network mode","TXT_CODE_b5a0661a":"Title","TXT_CODE_b5a3a6ca":"Official Authentication","TXT_CODE_b5a47731":"The administrator has restricted general users from using the instance reinstallation function.","TXT_CODE_b5afc7e":"Maximum Players Displayed to Player Clients, default value is 1. This is decorative and does not affect the actual maximum player setting.","TXT_CODE_b5b33dd4":"Custom Text on the Login Page","TXT_CODE_b5c7b82d":"Settings","TXT_CODE_b5ca0563":"We will guide you through the process of deploying your application.","TXT_CODE_b5ce1069":"Prevent non-softcore players from connecting.","TXT_CODE_b5e19c1":"Set to true for rabbits to bypass the mob griefing gamerule","TXT_CODE_b625dbf0":"Uploading：","TXT_CODE_b642de88":"Maximum Players","TXT_CODE_b649a71a":"Force Christmas events to be held all year round.","TXT_CODE_b6697d36":"Kick players when packets per second exceed this limit. Set to 0 to disable.","TXT_CODE_b67197fc":"All Users","TXT_CODE_b69550bf":"Experienced User","TXT_CODE_b6ac7af4":"User <<operator_name>> modified the configuration of the daemon process <<daemon_id>>","TXT_CODE_b6ba38a4":"Set to true for note blocks to continue making sound even if there is a block above it","TXT_CODE_b6c675d6":"View subscription information","TXT_CODE_b6d926ab":"Allows the totem of undying to work anywhere in your inventory, not just your offhand","TXT_CODE_b6eb8851":"Zombies Attack Turtle Eggs","TXT_CODE_b729d2e":"Container Port","TXT_CODE_b72d638d":"Required and must be unique","TXT_CODE_b75e6388":"The format the <uptime> placeholder uses for uptime-command-output","TXT_CODE_b76d94e0":"Refresh","TXT_CODE_b7c8eb9f":"Reason for preventing hardcore players from dying.","TXT_CODE_b7cab91d":"Send Command","TXT_CODE_b7d026f8":"Scheduled Tasks","TXT_CODE_b7d38e78":"The remote node is unavailable! \\nPlease contact the administrator to go to the node list to check the status of the remote node!","TXT_CODE_b7f19227":"Change the range in which the lightning rod redirects lightning","TXT_CODE_b8108d4d":"Enter your command here and press Enter to send","TXT_CODE_b815f6f6":"Disable Creeper Residual Effects","TXT_CODE_b82225c3":"Decompressing, please wait patiently...","TXT_CODE_b858d78a":"Copied","TXT_CODE_b862a158":"CPU Usage","TXT_CODE_b8814f15":"This might be due to lack of access to this file. Try editing it via \'File Management\'.","TXT_CODE_b89285d3":"This modifies the server name that shows up when a client is outdated or when someone opens the debug screen [F3]","TXT_CODE_b89780e2":"Incorrect profile version, unable to set background image, please try restarting the panel or resetting custom layout!","TXT_CODE_b8c40ce0":"Control tps catch-up","TXT_CODE_b90e9abd":"Code takes effect immediately and binds to matching username","TXT_CODE_b916a8dc":"Environment Variables","TXT_CODE_b91a94f9":"Command Execution Carriage Return","TXT_CODE_b9442311":"Additional parameters","TXT_CODE_b946a322":"Additional virtual memory allocated on top of the maximum memory. Using this memory is less efficient. Leave blank for automatic allocation.","TXT_CODE_b94f13ce":"On Windows platforms, it\'s generally \'Carriage Return and Line Feed\' (\\\\r\\\\n), while on Linux/MacOS platforms, it\'s typically \'Line Feed\' (\\\\n).","TXT_CODE_b99cae18":"Products","TXT_CODE_b9af1460":"Min amount of interval ticks that get shot","TXT_CODE_b9ca022b":"Installing instance files, please wait patiently...","TXT_CODE_b9d7fe43":"Require token authentication when using public REST API endpoints.","TXT_CODE_b9fc604c":"Limit per HTTP request, maximum file download speed","TXT_CODE_ba027d6c":"Compressing files, please wait patiently...","TXT_CODE_ba09da46":"Trying to start child process as Linux user {{name}}...","TXT_CODE_ba1a222b":"Allow players to place ice in invalid places.","TXT_CODE_ba1eb3b5":"Docker is lightweight virtualization software that can create containers (like boxes) to run your actual applications with different environments. It ensures that your application runs in a virtual sandbox and does not affect any files on the host machine, regardless of potential malicious operations performed by the application.","TXT_CODE_ba42d467":"Network URL","TXT_CODE_ba497a8b":"Interval-based Task","TXT_CODE_ba4f41ba":"Enable Detailed Output","TXT_CODE_ba717ff3":"You can freely design the layout, order and display of most elements on the web page.","TXT_CODE_ba82dddb":"Image building and container running depend on Docker software, and all daemons on the physical host share all images.","TXT_CODE_ba86f4a":"MC BungeeCord","TXT_CODE_ba8ebc7":"Cannot be empty, please enter 0 for every 0 hours","TXT_CODE_baa16e45":"Expand Width","TXT_CODE_bac2d713":"Enable debug mode","TXT_CODE_bae487e4":"Create with Docker Image","TXT_CODE_baseport_title":"Base Port","TXT_CODE_bb0b9711":"Update or Install Command","TXT_CODE_bb35dc39":"Set to true to make it so cacti can be bonemealed","TXT_CODE_bb729416":"The delay a player can pick up experience after it is dropped","TXT_CODE_bb888626":"Output","TXT_CODE_bb9657ff":"Parse Selectors in Books","TXT_CODE_bb98d45":"Enable Brigadier Command Suggestions","TXT_CODE_bbbda29":"The startup command cannot contain line breaks, as this is not a script file and cannot execute multiple commands","TXT_CODE_bbd7d448":"Detailed information about Docker images and containers. Recommended for technical personnel. The complete information is provided in JSON format.","TXT_CODE_bbe23ee7":"Node direct connection address mappings","TXT_CODE_bbedcf29":"The current state of the instance does not allow modifying any files. Please try again later!","TXT_CODE_bc2e52a0":"When enabled, all users can use the \'Reinstall\' function in the upper right corner of the terminal without administrator privileges.","TXT_CODE_bc3e529c":"Allow Permanent Block Breaking Exploit","TXT_CODE_bc46c15b":"Start Designing","TXT_CODE_bc560b9":"Confirm renewal","TXT_CODE_bc883bbb":"Return to Manual Installation","TXT_CODE_bca67837":"The difference between server and client values before detecting abnormal behavior","TXT_CODE_bcfaf14d":"Sorry, unable to fetch the latest modpack list. This might be due to the network or the server is under maintenance.","TXT_CODE_bd0aa3c7":"Set to true to make entity\'s display names and lores persist after breaking (ex. named armor stands retain their name)","TXT_CODE_bd1ff011":"Early window width","TXT_CODE_bd2534da":"This value determines how far away an entity has to be from the player to start being effected by DEAR.","TXT_CODE_bd2559f3":"Terminal Input Encoding","TXT_CODE_bd7152f7":"Enable the End dimension","TXT_CODE_bd84e700":"Set to true to allow mobs to walk over rails","TXT_CODE_bd99b64e":"Request timeout! \\nPlease contact the administrator to check the node network status, IP:","TXT_CODE_bdb620b9":"Running","TXT_CODE_bdd4fe65":"Require Resource Packs","TXT_CODE_bddc37e2":"File parsing failed, please ensure it is a valid JSON file","TXT_CODE_bdfa3457":"RCON protocol cannot be enabled or disabled while running.","TXT_CODE_be1351ce":"How to obtain the key?","TXT_CODE_be1354f5":"Use design mode to hover here for editing","TXT_CODE_be1f9806":"Hopper Check Rate","TXT_CODE_be236019":"Cocoa Bean Growth Speed","TXT_CODE_be26bb3c":"Stronghold Seed","TXT_CODE_be608c82":"Different types may have slightly differences in some functions","TXT_CODE_be6484f7":"Please select an instance image","TXT_CODE_be769e64":"Allows you to change the amount of ticks required for a mob\'s death to count as a player kill after being hurt by the player (projectile or directly)","TXT_CODE_be7a689a":"It must be accessible from the server that provide this panel. When it is neither a public IP/domain nor \'localhost\' and you are using reverse proxy for public access, you need to configure node direct connection mappings to let related functionalities work properly.","TXT_CODE_bea356aa":"Allow connections from ProxyPass and Waterdog.","TXT_CODE_bea85b64":"Amount of ticks the player will glow after eating a glow berry. Set to 0 to disable","TXT_CODE_beacbdc":"The speed in which a cauldron fills with powdered snow (depends on random tick)","TXT_CODE_bec3d0ea":"Save the world if the server crashes due to an unhandled exception.","TXT_CODE_bec552ee":"Output of <hours> placeholder in command.uptime.format option","TXT_CODE_bed32084":"The remote node is offline, please contact the administrator to check the online status of the panel!","TXT_CODE_bf6bec1a":"Set to false to disallow armorstands from moving in water over a fence","TXT_CODE_bf8ae6c8":"This configuration file is the Minecraft server\'s End User License Agreement (EULA). You must agree to this agreement in order to run the server software. If you find that this setting is not set to \'true,\' please change it immediately.","TXT_CODE_bfb50126":"Daemon Status","TXT_CODE_bfbdf579":"This feature allows ordinary users to edit the configuration of Docker instances such as the \\"start\\" and \\"update\\" commands","TXT_CODE_bff43de3":"Name","TXT_CODE_c03297d4":"Listening IP Address and Port","TXT_CODE_c0401ba7":"Missing volume file: {{file}}","TXT_CODE_c059faee":"Fix Target Selector Tag Suggestions","TXT_CODE_c0606ef4":"Set background image?","TXT_CODE_c093bec9":"This operation is on cooldown. You can continue in about {{seconds}} seconds!","TXT_CODE_c0a49b60":"Threshold for incorrect movement","TXT_CODE_c0be39df":"Other Entity Activation Range","TXT_CODE_c0ce588":"Pumpkin Growth Speed","TXT_CODE_c0fcee47":"Set to false to disable trading with wandering traders","TXT_CODE_c10ea805":"Quick start with templates","TXT_CODE_c117a10c":"Disable Creeper Persistent Effects","TXT_CODE_c11ac499":"Please enter a cover image URL","TXT_CODE_c1320e08":"You can clear all uploaded files by \'Reset Layout\'","TXT_CODE_c132a726":"Mobs that can pick up loot will continue to pick up loot even if the mobGriefing gamerule is disabled","TXT_CODE_c135338":"Kicked for Flying Vehicle Message","TXT_CODE_c14b2ea3":"Go Back","TXT_CODE_c14caab":"No Additional Files Required","TXT_CODE_c1507dd6":"Warning Delay","TXT_CODE_c15dcfec":"Set to true to allow the grindstone to remove the attributes from an item","TXT_CODE_c174fbb4":"Allow Player Crowding Damage","TXT_CODE_c17f6488":"Select zip file","TXT_CODE_c1c548fb":"The following ports have been opened for the instance:","TXT_CODE_c20e5d16":"Message that shows when the credits screen is enabled for a user using the /credits command.","TXT_CODE_c237192c":"Please enter the name of the new instance","TXT_CODE_c24c2569":"Number of seconds to wait for the user to authorize Geyser access to their Microsoft account.","TXT_CODE_c24fdee3":"Please select file encoding","TXT_CODE_c2697552":"Edit track","TXT_CODE_c26e5fb7":"Support Markdown format","TXT_CODE_c2a8378b":"World (Map) Name","TXT_CODE_c2cef2d":"Attacker Activation Range","TXT_CODE_c3022e22":"This configuration file is commonly used in Bukkit-like or other derivative server software. It includes most server settings, such as server port, maximum player count, player view distance, and official authentication.","TXT_CODE_c30a5f37":"The height this mob can jump when riding it (in blocks)","TXT_CODE_c32bc4b3":"View Distance","TXT_CODE_c32eb04a":"Do not change this for any reason! Purpur uses this internally to help automatically update your config.","TXT_CODE_c38813a8":"Username","TXT_CODE_c3a3b6b1":"Container Name","TXT_CODE_c3a933d3":"Task completed!","TXT_CODE_c3adc044":"Upload task does not exist","TXT_CODE_c3c06801":"Bulk Deletion Successful","TXT_CODE_c3ec4dc8":"Hunger Depletion from Combat","TXT_CODE_c42a1b9b":"Uses a different approach to keepalive ping timeouts. Enabling this sends a keepalive packet once per second to a player, and only kicks for timeout if none of them were responded to in 30 seconds. Responding to any of them in any order will keep the player connected. AKA, it won\'t kick your players because one packet gets dropped somewhere along the lines","TXT_CODE_c4430fa6":"Prevent users from logging in before they have finished connecting.","TXT_CODE_c4435af9":"Container Port Mapping Configuration","TXT_CODE_c48f6f64":"All","TXT_CODE_c4dfdb26":"Traditional Chinese (BIG5)","TXT_CODE_c4f90da6":"Specific Time Task","TXT_CODE_c51b86ff":"Set the shulker to a random color when spawned from a bullet","TXT_CODE_c52c93f7":"If not enabled (default is true), player IP addresses will be replaced with <ip address withheld> in logs.","TXT_CODE_c534ca49":"Under Maintenance","TXT_CODE_c535fb8":"Set to true if this mob should always drop experience","TXT_CODE_c536b7c7":"Whether a phantom\'s flames can burn items","TXT_CODE_c53c342e":"Set this to true to remove any Entity (Note: Does not include BlockEntities) that throws an error in its tick method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.","TXT_CODE_c565b2e0":"Allows uploading HTML files. This card will load the HTML and run Javascript code.","TXT_CODE_c5687e56":"User <<operator_name>> updated the file <<file>> of the <<instance_name>> instance","TXT_CODE_c59f077d":"Set to false to allow setting a negative ExplosionRadius value on explosions","TXT_CODE_c5a46eba":"Download Modified File","TXT_CODE_c5ace40b":"Game Type","TXT_CODE_c5b38d90":"The instance specifications for renewal do not match, and the renewal operation cannot be completed!","TXT_CODE_c5c56801":"Registration Time","TXT_CODE_c5ed896f":"The instantaneous output content is too long and has been rejected....","TXT_CODE_c62a8fa1":"Resource Pack","TXT_CODE_c62e2f11":"Configure your servers here. Each key represents the server\'s name, and the value represents the IP address to connect to.","TXT_CODE_c671927e":"Enforce server resource packs","TXT_CODE_c684d8b2":"Username exists, is this your account?","TXT_CODE_c68b0bef":"Image downloaded!","TXT_CODE_c698246c":"Undead Creatures Immune to Specific Effects","TXT_CODE_c6d3bd8":"MC Pufferfish","TXT_CODE_c6ecc182":"Log named entity death events","TXT_CODE_c709edac":"Set to true for zombies to bypass the mob griefing gamerule","TXT_CODE_c7362d3d":"Attempt to disable compression for Bedrock players through Geyser.","TXT_CODE_c73de59d":"Tuesday","TXT_CODE_c745cf56":"Debug Mode","TXT_CODE_c7952636":"Item to tempt/feed polar bears and make them breed","TXT_CODE_c7a43089":"The instance will pull the image upon start and create a container using it. This image name must exist in the cloud or locally","TXT_CODE_c7b1b8d0":"Program","TXT_CODE_c7d0002e":"IP","TXT_CODE_c7d340bc":"Prevent Movement into Unloaded Chunks","TXT_CODE_c800cb31":"Enter container directory path. All files in File Manager will be mounted here","TXT_CODE_c8261c85":"Minecraft Server (Bedrock)","TXT_CODE_c82a51b0":"For example, \'mcsmanager.com\' or \'43.123.211.12\'.","TXT_CODE_c8333afa":"Unknown Status","TXT_CODE_c83551f5":"Rename","TXT_CODE_c840ab37":"Whitelist of blocks that can be broken by the ravager","TXT_CODE_c846074d":"Please complete your account profile!","TXT_CODE_c848a459":"Creature Spawning Range","TXT_CODE_c855fc29":"New User Added","TXT_CODE_c8572f16":"Igloo Seed","TXT_CODE_c871d8c8":"Sets the maximum distance (in chunks, per player direction) that entity updates will be sent by the server. Entities beyond this radius will not be sent to players.","TXT_CODE_c8a51b2e":"Please provide picture address","TXT_CODE_c8c91afc":"Disable tile placement and tile movement.","TXT_CODE_c8cdeeee":"Configuration file version. Modifying this may result in unpredictable issues. It\'s recommended not to modify this.","TXT_CODE_c91c29cd":"Damage of fire when a phantom is burning","TXT_CODE_c92156bb":"There is an issue with the plan set by the service provider. Please contact the provider to reconfigure the plan!","TXT_CODE_c93f32f8":"Required, supports domain names and IP addresses. If not provided, server information such as number of players and version will not be queried.","TXT_CODE_c9609785":"Status","TXT_CODE_c97dd046":"When enabled, ender chests should have six rows of inventory space","TXT_CODE_c9b31f8e":"Thursday","TXT_CODE_c9c27711":"Whether to ignore Crystal Bullet shards for calculating projectile thresholds.","TXT_CODE_c9ce7427":"You can filter games via the dropdown menu, select a template, and proceed with installation. Ensure the system has the required runtime environment for the game.","TXT_CODE_c9d34339":"Set to false for boats to not do fall damage to players","TXT_CODE_c9e4d5c1":"Prevent dungeon guardians from spawning when sending players to their spawn points.","TXT_CODE_c9f303dd":"Min health attribute","TXT_CODE_ca030197":"The instance has other tasks in progress, and this operation cannot be performed!","TXT_CODE_ca06ec2a":"Entities Choose Targets Based on Follow Range","TXT_CODE_ca07c84c":"Your Browser does not support Clipboard API","TXT_CODE_ca500df8":"This configuration file is common for Paper-like or other derived server software, expanding on the shortcomings of the Spigot configuration file.","TXT_CODE_ca8072bd":"Initialization failed, the remote node does not exist!","TXT_CODE_caaac421":"Import from clipboard","TXT_CODE_cacd8840":"7zip decompression error: {{message}}","TXT_CODE_cad62df3":"Only save user cache when the server stops","TXT_CODE_cae10a08":"File deletion started. It may take some time.","TXT_CODE_caf10268":"Whether the server returns a list of plugins when queried in the MCSM built-in console","TXT_CODE_caf8ebb7":"Card key sales","TXT_CODE_cafe41ab":"Allowed idle Time (in minutes). Players will be kicked if they exceed this limit.","TXT_CODE_cb043d10":"Instance","TXT_CODE_cb08d342":"Field cannot be empty","TXT_CODE_cb1fef78":"All players must register or log in before playing.","TXT_CODE_cb36c80e":"Remote Host Container List","TXT_CODE_cb61062d":"Cannot View","TXT_CODE_cb84b22":"This card allows custom HTML pages and direct execution of Javascript scripts. It can use all elements on the webpage, and is for Web developers.","TXT_CODE_cbb958f2":"If enabled, players without Mojang-signed public keys will be unable to connect.","TXT_CODE_cbbc779f":"Make sure the name of the provided core matches the uploaded file before starting the instance.","TXT_CODE_cbc235ad":"Clearing the existing files of the instance, please wait patiently...","TXT_CODE_cbe0fc07":"Hunger Depletion from Regeneration","TXT_CODE_cc446b0c":"Radius which phantoms scan for crystals to orbit. Value of 0 disables feature","TXT_CODE_cc561947":"Scan the QR code using Google Authentication or other universal 2FA tools.","TXT_CODE_cc5a3aea":"Password length cannot be less than 9 characters","TXT_CODE_cc6ecb18":"Max Monsters Awakened per tick","TXT_CODE_cc732bf6":"Please enter the stop command","TXT_CODE_cc7b54b9":"Basic Settings","TXT_CODE_ccb60658":"Authentication","TXT_CODE_ccc0fec7":"Set to false to disable the llama caravan feature (https://minecraft.wiki/w/Llama#Caravans)","TXT_CODE_cd045236":"Sweet Berry Bush Growth Speed","TXT_CODE_cd1f9ef7":"Node listening port","TXT_CODE_cd3ae89e":"Show backup auto-save messages.","TXT_CODE_cd40249d":"Chat Execution Core Threads","TXT_CODE_cd5df11b":"Please configure port mapping","TXT_CODE_cd62c9d4":"Prevent the spawning of banned items or invoking commands for protection.","TXT_CODE_cd76bc9":"User <<operator_name>> deleted the user <<target_user_name>>","TXT_CODE_cd8cd5d2":"This card can only be placed on pages with higher permissions","TXT_CODE_cd923ade":"Is this your first time using MCSM?","TXT_CODE_cd978243":"Admin","TXT_CODE_cdb213a3":"List of items that are immune to explosions","TXT_CODE_cdbd12d2":"Phantom fire time","TXT_CODE_cdd555be":"Basic","TXT_CODE_cdf1a25":"What color should show when the ram usage is \'low\'","TXT_CODE_cdf7c16a":"Only Admin can view and change these settings","TXT_CODE_ce132192":"Search by instance name","TXT_CODE_ce4a3230":"Max Health of the Mob","TXT_CODE_ce8f3dc1":"Enable PROXY protocol for clients. Do not enable this unless you are running a UDP reverse proxy in front of your Geyser instances.","TXT_CODE_ce917b27":"Great success! All you need now is to enter the \'Instance Console\' and click \'Start\'.","TXT_CODE_ce953a4":"Disable PrimeBombs.","TXT_CODE_ce99026b":"Save logs to SQL database instead of text files. Default is false.","TXT_CODE_cea5dba1":"Program has received the shutdown signal, preparing to stop...","TXT_CODE_ceb783a9":"File management is a resource-intensive and less controllable function.","TXT_CODE_ceba9262":"If you are a regular user, please contact the panel administrator.","TXT_CODE_cec321b4":"Output Encoding: ","TXT_CODE_cee5802c":"Hatch Time","TXT_CODE_cf1cb995":"Specify the number of seconds to cache images to disk to save time downloading them from the internet. 0 means disable.","TXT_CODE_cf27ab7e":"Please enter a name","TXT_CODE_cf393058":"A config option mainly for developers. Logs out modded item tags that do not have translations when running on integrated server. Format desired is tag.item.<namespace>.<path> for the translation key. Defaults to SILENCED. Allowed Values: SILENCED, DEV_SHORT, DEV_VERBOSE, PROD_SHORT, PROD_VERBOSE","TXT_CODE_cf88c936":"Open Ports","TXT_CODE_cf95364f":"This feature may be unstable, cannot guarantee best user experience.","TXT_CODE_cf9e259c":"Displays the current time","TXT_CODE_cfc657db":"Directory","TXT_CODE_cfd64e73":"Default group name for newly registered player accounts.","TXT_CODE_cfe187b0":"This value defines how much distance modifies an entity\'s tick frequency.","TXT_CODE_cff4286":"Percent chance (0.0-1.0) to naturally spawn a rabbit named Toast","TXT_CODE_command.errLen":"Incorrect command length, please ensure the command format is correct","TXT_CODE_command.instanceNotOpen":"Command execution failed because the instance\'s actual process does not exist","TXT_CODE_command.quotes":"Incorrect command double quotes, paired double quotes cannot be found. If you need to use single quote symbol, please use the {quotes} symbol","TXT_CODE_common._7unzip":"[7zip Decompression Task]","TXT_CODE_common._7zip":"[7zip Compression Task]","TXT_CODE_common.killProcess":"Process {{pid}} has been terminated using system commands","TXT_CODE_common.title":"Title","TXT_CODE_common.uuidIrregular":"UUID {{uuid}} does not conform to the standards","TXT_CODE_d00c21bb":"Map generation type (default, flat)","TXT_CODE_d01532d":"Amount of damage done while drowning","TXT_CODE_d03c3e0e":"The original Bukkit configuration","TXT_CODE_d043fe18":"Write Disk","TXT_CODE_d07742fe":"Configuration Files","TXT_CODE_d080f2d7":"Reload","TXT_CODE_d092c3b":"Only allow hardcore players to connect.","TXT_CODE_d0b40386":"MySQL database name.","TXT_CODE_d0c670df":"The development of the MCSManager management panel is made possible by the selfless contributions of contributors and sponsors.","TXT_CODE_d0c78699":"Authentication Server Unavailable Message","TXT_CODE_d0d08d6":"eg: 123MB","TXT_CODE_d0e37f20":"Enable whitelist.","TXT_CODE_d0e78c58":"Base chance","TXT_CODE_d0fd83bf":"Chat Limits","TXT_CODE_d11bf156":"Please wait patiently and use the refresh function to reload the list. The image is expected to be deleted later.","TXT_CODE_d11cc3e1":"Enable HAProxy Support","TXT_CODE_d12fa808":"Startup Command","TXT_CODE_d149e3e6":"Allows anvils to be placed by dispensers","TXT_CODE_d1509da0":"The blast radius of the explosion. (For comparison, TNT is 4.0 and charged creepers are 6.0)","TXT_CODE_d15dc89c":"The amount of blocks a piston can push","TXT_CODE_d16d82ab":"If you encounter garbled content in the console, you can try modifying this encoding to resolve the issue.","TXT_CODE_d182c422":"On which machine is the new instance deployed?","TXT_CODE_d1c78fbf":"Name used for container creation; leave empty for a random name.","TXT_CODE_d23631cb":"Terminal Settings","TXT_CODE_d245f00d":"Set to true to remove the slowdown of oxidation caused by nearby unoxidized copper blocks","TXT_CODE_d248b5c8":"Saturday","TXT_CODE_d258ec31":"Clear all selected","TXT_CODE_d28c05df":"Success!","TXT_CODE_d29be029":"Set to true to allow sponges to absorb water from mud blocks turning them back into dirt","TXT_CODE_d29c8730":"Should server list ping requests be forwarded to backend servers?","TXT_CODE_d2bbb2f1":"Instance Features","TXT_CODE_d2c1a316":"Login","TXT_CODE_d2c79249":"If you are willing to support the future development of MCSManager,","TXT_CODE_d2e3b565":"Jump power when pressing spacebar on a controllable minecart","TXT_CODE_d31196db":"Merchant Console","TXT_CODE_d31a684c":"Last Start：","TXT_CODE_d32301c1":"Available Ports","TXT_CODE_d324bb21":"Address:","TXT_CODE_d33e975f":"Set to false to stop the server from kicking a player for their chat being out of order","TXT_CODE_d341127b":"Event Tasks","TXT_CODE_d356cf9d":"Shrink Width","TXT_CODE_d372d72":"Attempt to automatically port forward using UPnP when the server starts up","TXT_CODE_d37f0418":"Panel is already installed!","TXT_CODE_d3b29478":"Last Modify","TXT_CODE_d3d88894":"The regen amount of the wither","TXT_CODE_d3ddefb5":"The amount of experience points to use from the player\'s bar for repairing items enchanted with mending in the player\'s inventory","TXT_CODE_d3de39b4":"Update Successful","TXT_CODE_d4146944":"Return to Dashboard","TXT_CODE_d42566ff":"A chat message that shows the ram usage when someone uses the /ram command.","TXT_CODE_d4517dcb":"Friday","TXT_CODE_d47ff7e5":"Percent chance (0.0 - 1.0) that right-clicking primed TNT will defuse it","TXT_CODE_d486a561":"Description: ","TXT_CODE_d4ad1dd":"Optional. Uses image default command if empty, otherwise runs specified command","TXT_CODE_d4b058a9":"Prevent using Zenith projectiles alongside different objects than weapons.","TXT_CODE_d4b35741":"Player Movement Threshold.","TXT_CODE_d4c8fb3b":"Related documents:","TXT_CODE_d4cf1cb8":"File","TXT_CODE_d4dafc41":"Whether the shulker box should drop it\'s contents when it\'s been destroyed","TXT_CODE_d507abff":"Confirm","TXT_CODE_d51cd7ae":"Generate New Key","TXT_CODE_d51f5d6":"Password length does not match","TXT_CODE_d572c313":"Set to true for villagers to bypass the mob griefing gamerule","TXT_CODE_d58ffa0f":"The instance is not running!","TXT_CODE_d628e631":"Used for quickly deploying a new instance.","TXT_CODE_d629fa48":"Game Server IP","TXT_CODE_d6312bd5":"User <<operator_name>> modified the system configuration","TXT_CODE_d6321094":"Crafting Table Abuse Increment","TXT_CODE_d648ff91":"However, this does not include custom card titles or other custom language content.","TXT_CODE_d649b01e":"Save Empty Scoreboard Teams","TXT_CODE_d655beec":"Instance List","TXT_CODE_d6a96ea4":"Displays a set of custom hyperlink buttons","TXT_CODE_d6c5a7f8":"Please complete all required fields in the form!","TXT_CODE_d6d9c42c":"Running Instances","TXT_CODE_d6e124c1":"Teleports you to spawn if you take damage while on top of the nether ceiling","TXT_CODE_d6e7f572":"If you encounter issues, it is recommended to disable this feature.","TXT_CODE_d705a2bd":"Additional parameters will be appended to the end of the software path.","TXT_CODE_d73c037b":"Allows the ability to continuously trade with a villager through an End Gateway exploit.","TXT_CODE_d73c8510":"Are you sure you want to save the layout?","TXT_CODE_d745c7d4":"RAM Usage","TXT_CODE_d7638d7b":"Required, e.g. openjdk:23-slim","TXT_CODE_d764908b":"Prevent players from moving beyond a certain distance in tiles.","TXT_CODE_d76ccb4f":"What is an Environment Image?","TXT_CODE_d78ad17a":"Please select the user(s) to be deleted","TXT_CODE_d79ff710":"eg: RAM 4G","TXT_CODE_d7a7a095":"Map Seed (leave blank for default)","TXT_CODE_d7ad19af":"Configuration File Version - Generally, avoid modifying as it may impact server functionality if changed.","TXT_CODE_d7c5823e":"Built-in Java 8 runtime environment, ideal for Minecraft server 1.7 ~ 1.16","TXT_CODE_d7dbc7c2":"Disabled","TXT_CODE_d7ee9ba":"Last Login","TXT_CODE_d7fa3be3":"Optional, -Xmx parameter, like: 1024M","TXT_CODE_d851d86d":"Wither","TXT_CODE_d8d19932":"Limit per HTTP request, maximum file upload speed","TXT_CODE_d8d6dca8":"Set to false to stop the crystal from exploding","TXT_CODE_d928da57":"Set how long the nighttime cycle is ticked","TXT_CODE_d941eb89":"Operation","TXT_CODE_d97eaef3":"What Difficulty Husks Break Doors","TXT_CODE_d9829f9c":"Duration of Flying Monster Awakening (in ticks)","TXT_CODE_d9a5c0c2":"Control if pumpkins can be placed back onto snowmen","TXT_CODE_d9b7a6a3":"Allow stacking of items in chests beyond the stack limit during world load.","TXT_CODE_d9c63fdd":"Template Information","TXT_CODE_d9c73520":"Mount additional directories","TXT_CODE_d9cfab1b":"Execution Count","TXT_CODE_da234f4f":"Game Difficulty (peaceful, easy, normal, hard)","TXT_CODE_da26028c":"Minimum Seconds for Phantom Spawn","TXT_CODE_da2fb99a":"Page not functioning correctly","TXT_CODE_da521b59":"The speed boost that minecarts gain from hitting a powered rail (Doesn\'t affect furnace minecarts)","TXT_CODE_da579edc":"2. Visitors who are not logged in or do not have sufficient permissions will not be able to load the cards.","TXT_CODE_da65ecbd":"Ignore checks to see if players \'can\' kill projectiles.","TXT_CODE_da76ea07":"This configuration file is commonly used for Purpur server types, expanding on the limitations of the Paper configuration.","TXT_CODE_da782f63":"Chat Execution Max Threads","TXT_CODE_da7a0328":"Unknown Type","TXT_CODE_da8bb476":"Plugin update folder, the name of the folder for new version plugins. Plugins in this folder will be automatically updated server restarts.","TXT_CODE_da8f97a7":"Blocked Accesses","TXT_CODE_daca92c1":"Port used by REST API.","TXT_CODE_dad61ed8":"Set the default collar color when a cat is tamed. Available Colors","TXT_CODE_daemonInfo.authError":"Remote daemon {{- v}} key validation error","TXT_CODE_daemonInfo.authFailure":"Remote daemon {{- v}} key validation denied","TXT_CODE_daemonInfo.authSuccess":"Remote daemon {{- v}} key validation successful","TXT_CODE_daemonInfo.closed":"Disconnected remote daemon {{- v}}","TXT_CODE_daemonInfo.connect":"Connected to remote daemon {{- v}}","TXT_CODE_daemonInfo.connectError":"Error connecting to remote daemon: {{- v}}","TXT_CODE_daemonInfo.disconnect":"Disconnected from remote daemon {{- v}}","TXT_CODE_daemonInfo.replaceConnect":"User initiated a duplicate connection request, resetting connection configuration","TXT_CODE_daemonInfo.resetConnect":"User initiated reconnection to an already available remote daemon, resetting connection channel","TXT_CODE_daemonInfo.setLanguage":"Set daemon language","TXT_CODE_daemonInfo.tryConnect":"Attempting to connect to remote daemon","TXT_CODE_db04e635":"MOTD Displayed to Players When Only One Default Server Exists. This is overridden when \'ping_passthrough\' is enabled.","TXT_CODE_db07cf9e":"Teleports you to spawn if you somehow get outside the world border","TXT_CODE_db14fb46":"Added","TXT_CODE_db37b7f9":"Image download error, please make sure the image name is correct, or manually pull the required image using docker pull via the node management terminal, error:","TXT_CODE_db64faf6":"Login Count","TXT_CODE_db815f4a":"Text filtering rules configuration file (may not work as intended)","TXT_CODE_db9375a5":"Can be used to display external websites","TXT_CODE_dba9bf61":"Compression failed!","TXT_CODE_dbc9b3e3":"The distance (in blocks) to damage hostile mobs","TXT_CODE_dbefcc6c":"Terraria Server","TXT_CODE_dc370276":"Sets the overlay type of the Bossbar. Available options: PROGRESS, NOTCHED_6, NOTCHED_10, NOTCHED_12, NOTCHED_20","TXT_CODE_dc570cf2":"Leave it blank to make no changes.","TXT_CODE_dc9fb6ce":"Failed to save. A single instance only supports up to 6 tags!","TXT_CODE_dca030b8":"The configuration length of the additional mounting path for the instance container is incorrect!","TXT_CODE_dce87e42":"Specify 50 to limit all core usage to 50%; use 200 to allow a total core usage sum of 200%.","TXT_CODE_dd002fae":"Enable Whitelist","TXT_CODE_dd06dea2":"Currently, there are ","TXT_CODE_dd0a8173":"Knockback resistance attribute","TXT_CODE_dd20e5c3":"Duration of Villager Awakening (in ticks)","TXT_CODE_dd238854":"Maximum Memory","TXT_CODE_dd2cef06":"Max Ticks for Block Processing","TXT_CODE_dd559000":"Could not find remote with given daemon ID!","TXT_CODE_dd65f101":"The permission handler used by the server. Defaults to neoforge:default_handler if no such handler with that name is registered.","TXT_CODE_dd78943e":"Safety warning","TXT_CODE_dd8d27ce":"Steam Game Server","TXT_CODE_ddc2de99":"Default: localhost","TXT_CODE_ddcca0b9":"Custom Text Box","TXT_CODE_dde54f31":"Add One","TXT_CODE_ddec29cf":"The gradient of <text> when the ram usage is \'medium\'","TXT_CODE_de150623":"Allow Non-Player Entities on Scoreboard","TXT_CODE_de161f0c":"Hide Durability","TXT_CODE_de1ece3c":"Calms the iron golem when it\'s healed if it\'s angry","TXT_CODE_de3ced4b":"Please enter the image name","TXT_CODE_de567e84":"User <<operator_name>> deleted the file <<file>> of the <<instance_name>> instance","TXT_CODE_de61c48c":"Disable Note Block Updates","TXT_CODE_de854aa6":"Maximum Seconds for Phantom Spawn","TXT_CODE_de9b7cc0":"Since the instance type is Docker container mode, we will only display Docker version templates.","TXT_CODE_deaf423c":"Game Mode (survival, creative, adventure, spectator)","TXT_CODE_deb2d85d":"Set to true for this mob to circle around the player as it ignites","TXT_CODE_dec6550e":"Controls the maximum distance for entities to be visible to clients. Reducing this value may improve the performance.","TXT_CODE_decf21ee":"Disable warnings for spawn permission failures due to region, spawn point, or server edit failures.","TXT_CODE_dedc50a0":"Network Rate","TXT_CODE_def287e0":"Remote Daemon","TXT_CODE_df1ceee":"Zombie Villager Infection Probability","TXT_CODE_df3fdec":"All files in the instance\'s working directory will be mounted to this directory inside the container","TXT_CODE_df455795":"By default 24444。","TXT_CODE_df87c46d":"Deselect All","TXT_CODE_df903498":"Duration of Monster Awakening (in ticks)","TXT_CODE_dfa17b2d":"This operation will permanently delete this image. Do you want to continue?","TXT_CODE_dfa27a93":"Have All Permissions","TXT_CODE_dfaa82f3":"Minimum number of phantoms to spawn per attempt","TXT_CODE_dfc17a0c":"Add Configuration","TXT_CODE_dfc4b650":"Import from link","TXT_CODE_dfd06954":"This number corresponds to the variables from {mcsm_port1} to {mcsm_port5}, and it will be incrementally assigned each time a new instance is added","TXT_CODE_dfd4fc5a":"Editor Options & Notes","TXT_CODE_dff680b7":"Program has exited!","TXT_CODE_e00c858c":"Upload","TXT_CODE_e01539f1":"Quick Start","TXT_CODE_e01e51f3":"Time Commands Affect All Worlds","TXT_CODE_e039b9b5":"normal","TXT_CODE_e050b3be":"Initial Memory","TXT_CODE_e057798f":"Server Port (IPv6)","TXT_CODE_e0643e6f":"Whether to kick players who exceed the HealOther threshold.","TXT_CODE_e06841b5":"The instance will be created as you upload the files. This is an irreversible process. Do you want to proceed?","TXT_CODE_e06c1cea":"Compression Format","TXT_CODE_e076d90b":"Daemons","TXT_CODE_e08dfec5":"Max health attribute","TXT_CODE_e08e63b5":"Console Program","TXT_CODE_e093012e":"Resolve the issue where Bedrock Edition can\'t build above Y coordinate 127 by changing the Nether dimension ID to the End ID.","TXT_CODE_e0a944a1":"You have not agreed to the {0}. You need to agree to this agreement to start this instance. Do you agree?","TXT_CODE_e0fca76":"Create Directly","TXT_CODE_e1070b52":"We are processing the files with all our might!","TXT_CODE_e109c091":"Abnormal access to remote node","TXT_CODE_e10c992a":"All users will see your new changes upon refreshing the webpage.","TXT_CODE_e112412a":"Friendly Reminder","TXT_CODE_e1276b33":"Min jump strength attribute","TXT_CODE_e13a6529":"Enable Whitelist (new version)","TXT_CODE_e13abbb1":"Instance Running","TXT_CODE_e1454ba7":"User <<operator_name>> updated the <<instance_name>> instance","TXT_CODE_e14b32b":"Number of ticks between attempting to naturally spawn a cat","TXT_CODE_e15e5006":"No content on this page.","TXT_CODE_e166bc2f":"The installation task is starting...","TXT_CODE_e1a3b150":"Color Rendering","TXT_CODE_e1af7c8b":"Maximum damage that projectiles can deal.","TXT_CODE_e1b0aab2":"Password unchanged","TXT_CODE_e1c60611":"JSON format only","TXT_CODE_e1ddd156":"Reported map name to query services.","TXT_CODE_e21473bc":"Instances","TXT_CODE_e260a220":"Version: ","TXT_CODE_e26d53d5":"Do not create too many new tags, which may cause confusion of elements on the interface and degrade panel performance.","TXT_CODE_e2976753":"This ID is the unique identifier for MCSManager, used to distinguish different panels. All online services provided by MCSManager will use this ID to differentiate users.","TXT_CODE_e29a9317":"Programming language changed","TXT_CODE_e29b79df":"If not filling any parameters, the newly added card will automatically retrieve data based on the address, but this does not apply to all pages. ","TXT_CODE_e29be84c":"Percent chance (0.0 - 1.0) of riding a chicken when spawned","TXT_CODE_e2a11a62":"Report anonymous data to Geyser.","TXT_CODE_e2be1e70":"Set to true for ravagers to bypass the mob griefing gamerule","TXT_CODE_e2dc0156":"Example: 25565","TXT_CODE_e304faa":"Maximum concurrent connections. If you want players to be kicked with the \'server is full\' setting, set it to the maximum number of players you\'ve set and set the max players for Terraria to 2 or more.","TXT_CODE_e3116bba":"Set to false to disallow mob spawning on blue ice","TXT_CODE_e35de72b":"Control if giant zombies have AI instead of just standing there","TXT_CODE_e37b4577":"The remote node address must be a public IP address. Domains or localhost cannot be used, nor can LAN IP addresses.","TXT_CODE_e3a77a77":"Unlimited","TXT_CODE_e3d96a26":"The panel could not connect to any remote daemon, please go to the Daemons first to add a remote daemon","TXT_CODE_e3db239d":"Hr","TXT_CODE_e3efef30":"List of items that are immune to fire","TXT_CODE_e40ddc99":"Block fall multiplier for brown bed","TXT_CODE_e456aed":"Accept","TXT_CODE_e4605c4":"User <<operator_name>> started the <<instance_name>> instance","TXT_CODE_e4794d20":"please click here.","TXT_CODE_e4878221":"Missing remote node ID","TXT_CODE_e4895a21":"If a value is set, Mobs will also avoid walking over the stonecutter.","TXT_CODE_e4898801":"Start Installation","TXT_CODE_e4a926bf":"Uncompressing files...","TXT_CODE_e4c84088":"Please complete the required parameters for the card.","TXT_CODE_e4cf9ca3":"The format of the bossbar when the server runs the /tpsbar command","TXT_CODE_e4d6cc20":"Request Body Error","TXT_CODE_e4dbff32":"MC Sponge","TXT_CODE_e4dce83f":"Online","TXT_CODE_e4e975f0":"Villagers Awakened Every x Ticks","TXT_CODE_e520908a":"The version of the remote daemon is inconsistent with the version required by the panel. This may cause critical issues. Please update the remote daemon immediately!","TXT_CODE_e543f6c0":"MC Purpur","TXT_CODE_e56cced3":"Do not modify arbitrarily. Conflicts with other panels may cause services to malfunction.","TXT_CODE_e576a340":"Set to false to make rain continue even after a player sleeps","TXT_CODE_e577c77c":"Updating the instance...","TXT_CODE_e57bd50f":"License","TXT_CODE_e5839f71":"Bamboo Growth Speed","TXT_CODE_e5a52cee":"Should players take damage when flying into a wall","TXT_CODE_e5b0feda":"Enable Metrics","TXT_CODE_e5b7522d":"If your regular users do not need file management, you can disable their access to this function.","TXT_CODE_e5ba712d":"Building the server as a preset package:","TXT_CODE_e5bf0df1":"Cannot get merchant info, server may be under maintenance","TXT_CODE_e5d3b1a":"Only spawn on players that have visible sky above them","TXT_CODE_e5f949c":"Directory","TXT_CODE_e6044db2":"Which port should the proxy bind to? By default, we bind to all addresses on port 25577.","TXT_CODE_e60567a8":"Listening Port for Server Remote Access (see enable-rcon)","TXT_CODE_e612a8a2":"Set to false to disable trading with villagers","TXT_CODE_e627e546":"Daemon","TXT_CODE_e641b54c":"Book Author ID","TXT_CODE_e65d2d1a":"Enable LAN visibility","TXT_CODE_e66bfef9":"Controls how many chunks are allowed to be sync loaded by projectiles in a tick.","TXT_CODE_e66f4ae":"Hunger Depletion Multiplier for Swimming","TXT_CODE_e679197e":"Lobotomizes the villager if it cannot move (Does not disable trading)","TXT_CODE_e6a5c12b":"Instance ID","TXT_CODE_e6adf32d":"Please enter the author name","TXT_CODE_e6c30866":"Manage Images","TXT_CODE_e707d042":"Allows end crystals to respawn the ender dragon.","TXT_CODE_e70a8e24":"Status: ","TXT_CODE_e718a226":"The download task is in progress. About to jump to the console...","TXT_CODE_e7335483":"This feature will automatically select the appropriate protocol based on the instance type set by the administrator, to obtain specific information and parameters of the server process (e.g., number of players, version, etc.)","TXT_CODE_e74d658c":"Saved","TXT_CODE_e75ed0b5":"Max threads for early initialization parallelism,  -1 is based on processor count","TXT_CODE_e76e49e9":"Mounted working directory:","TXT_CODE_e78047a5":"Used for global settings of the control panel","TXT_CODE_e7a42e0e":"Connection Throttling Message","TXT_CODE_e7ad77f0":"Shipwreck Seed","TXT_CODE_e7b75c0e":"User Group","TXT_CODE_e7cad65f":"Please select an instance to retrieve daemon information.","TXT_CODE_e7cb14e2":"Disable Tripwire Updates","TXT_CODE_e812e21d":"Whether villagers can breed or not","TXT_CODE_e81c77bc":"Server Name","TXT_CODE_e8293f96":"How filled the bossbar is ranging from 0.0 to 1.0","TXT_CODE_e83ffa03":"New User","TXT_CODE_e86e91a2":"Please select input encoding","TXT_CODE_e88884ba":"Set to false to stop entities from being able to use portals","TXT_CODE_e89c5ccb":"Generate terrain below zero in existing chunks","TXT_CODE_e8adf231":"Lava will Occlusion Sightline","TXT_CODE_e8ce38c2":"Failed to get upload address.","TXT_CODE_e8d9c341":"Book Title ID","TXT_CODE_e948602a":"Set to true for farmland to bypass the mob griefing gamerule","TXT_CODE_e95ee23f":"Set to false to stop zombie aggressiveness towards villagers when lagging","TXT_CODE_e95f3a9f":"Makes it so squids can fly, Oh my!","TXT_CODE_e96a055e":"Online Official Verification","TXT_CODE_e96a91cd":"7zip decompression completed: Everything is Ok","TXT_CODE_e9712ce1":"Makes it so you can mine spawners using a tool with silk touch","TXT_CODE_e97669d8":"Execute","TXT_CODE_e9839f54":"Maximum size to randomly choose from when spawning naturally","TXT_CODE_e98816c2":"Duration of Villager Immunity (in ticks)","TXT_CODE_e9935066":"Required, only numeric port numbers","TXT_CODE_e99ab99a":"Are you sure you want to delete the user {userName}?","TXT_CODE_e9ac4f57":"The update command must not contain line breaks; it is not a script file and cannot execute multiple commands","TXT_CODE_e9cee11e":"Allow players to drink milk to cure bad omen status effect","TXT_CODE_e9da0615":"Set to false to disallow mob spawning on packed ice","TXT_CODE_e9dcbfe4":"Basic configuration for Bungeecord, the group proxy server. It enables distributed management, node control, and more. Here, you\'ll find simple configurations and operations.","TXT_CODE_ea04fb32":"Enable NeoForge global version checking","TXT_CODE_ea0840c9":"Instance Shortcut","TXT_CODE_ea46baee":"Other Entity Tracking Range","TXT_CODE_ea579dec":"History Interval","TXT_CODE_ea6e5e5e":"This node may not work properly when accessing the panel using a public IP address","TXT_CODE_ea8aaf1b":"Interval Between Warnings","TXT_CODE_eadac3c2":"Instance {{instance}} shutdown timed out, forcing shutdown...","TXT_CODE_eadb4f60":"Basic Infomation","TXT_CODE_eaed6901":"Instances","TXT_CODE_eb579d63":"User Resource Management","TXT_CODE_eb5fe3b6":"Set to true to allow drowned to break doors","TXT_CODE_eb7966f6":"Armor Stand Entity Collide","TXT_CODE_eb880db2":"User","TXT_CODE_eb9584d":"How much damage to deal to the elytra when firework boost activates","TXT_CODE_eb9fcdad":"Username","TXT_CODE_ebbb2def":"All Categories","TXT_CODE_ebc235d5":"How much damage an elytra\'s durability takes during flight each second","TXT_CODE_ebd2a6a1":"Custom Layout","TXT_CODE_ebf479f2":"The cooldown after using an ender pearl while in creative (in ticks)","TXT_CODE_ebfb4831":"Primary Category (Game Name)","TXT_CODE_ec08484":"Are you sure you want to forcefully terminate the running instance? This may cause instance data corruption.","TXT_CODE_ec0b25f5":"Share this page URL with users, no login required","TXT_CODE_ec0cda88":"MC Paper","TXT_CODE_ec299306":"My Application","TXT_CODE_ec6341cb":"Minimum size for raw network payload to be compressed.","TXT_CODE_ec6d29f4":"Every","TXT_CODE_ec734b5c":"Specify which image the container runs on","TXT_CODE_ec7553c6":"Initial Password","TXT_CODE_ec7fc405":"Decompression failed: {{message}}","TXT_CODE_ec99ddaa":"File","TXT_CODE_ec9dec9d":"Should mobs target nearby AFK players","TXT_CODE_eca8f1b3":"CPU Usage (10min)","TXT_CODE_ecbd7449":"Delete","TXT_CODE_ecc99fb6":"Early window framebuffer scale","TXT_CODE_eccd1c6c":"Multiplier for too-fast movement","TXT_CODE_ece2dd18":"If set to \'true,\' chat preview will be enabled. If enabled, the server will block users from using VPN or proxies; if disabled, the server won\'t block users from using VPN or proxies.","TXT_CODE_ecf17071":"Temporarily unavailable instances","TXT_CODE_ecf93b03":"Villager Activation Time to Trigger Panic","TXT_CODE_ed0e3963":"Broadcast Server Console to Operators","TXT_CODE_ed38c8ae":"Maximum amount of iron golems villagers can spawn in configured radius","TXT_CODE_ed3fc23":"Continue","TXT_CODE_ed510830":"Attack knockback attribute","TXT_CODE_ed81f72d":"This instance was not purchased from the store and cannot be renewed. Please contact the merchant for processing!","TXT_CODE_ed9bab79":"Prevent players from interacting with the world upon death.","TXT_CODE_ed9bfc6c":"Item merge radius","TXT_CODE_edd64e4d":"Disable","TXT_CODE_edd8458c":"The speed in which a cauldron below a down-facing pointed dripstone that has lava placed a block above it fills with lava (depends on random tick)","TXT_CODE_edf84830":"OS Type","TXT_CODE_ee01df88":"Whether you agree to the Minecraft EULA agreement. This option must be enabled if you want to start a Minecraft server.","TXT_CODE_ee54440":"User <<operator_name>> force-terminated the <<instance_name>> instance","TXT_CODE_ee67e1a3":"Working Directory","TXT_CODE_ee8ae330":"Query","TXT_CODE_eec3c1d7":"Installing listed modpacks will be considered as your agreement to and acknowledgment of the","TXT_CODE_eed84e8d":"Should your server announce support for Forge?","TXT_CODE_eee2a47f":"Image preview","TXT_CODE_eefcc58b":"Only babies can ride chickens","TXT_CODE_ef0ce2e":"Important Notes","TXT_CODE_ef1f63d2":"Whether phantoms burn in daylight or not","TXT_CODE_ef27fda1":"Support Channel:","TXT_CODE_ef5f0c4c":"Server Configuration & Runtime Information","TXT_CODE_ef61e06a":"Holding shears while sprinting will randomly damage the player (Don\'t run with scissors!)","TXT_CODE_ef650d57":"Emulated Terminal","TXT_CODE_ef676a8f":"Use Alternative Luck Calculation Formula","TXT_CODE_ef79a2ff":"Format: \\"image:tag\\", \\"latest\\" for the newest version","TXT_CODE_ef8f8e29":"Page failed to load, please try again later!","TXT_CODE_ef97db20":"Prevent writing content to the log file before OnSecondUpdate check.","TXT_CODE_efb6d377":"Instance Stopped","TXT_CODE_efcef926":"Network Mode","TXT_CODE_efd37c48":"Manage Instance","TXT_CODE_effefaab":"Sent terminate command","TXT_CODE_environment_router.crateErr":"Error creating image {{name}}:{{tag}}: {{error}}","TXT_CODE_environment_router.crateImage":"Daemon is creating image {{name}}:{{tag}} with the following DockerFile:\\n{{dockerFileText}}\\n","TXT_CODE_environment_router.crateSuccess":"Image {{name}}:{{tag}} creation completed.","TXT_CODE_environment_router.delImage":"Daemon is deleting image {{imageId}}","TXT_CODE_environment_router.dockerInfoErr":"Failed to fetch image information. Please ensure that you have Docker environment installed correctly.","TXT_CODE_f0127843":"The amount of ticks to wait before being able to breed again","TXT_CODE_f021f43a":"What the BossBar bar should show. Available options: TPS, MSPT, PING","TXT_CODE_f0260e51":"Paste Files","TXT_CODE_f02ff9cc":"Set to true for the infinity bow to work without arrows","TXT_CODE_f041de90":"File Encoding","TXT_CODE_f0512848":"Unzip Error: {{message}}","TXT_CODE_f0694685":"Please select a primary category","TXT_CODE_f07610ed":"Configuration Successful","TXT_CODE_f0789d81":"Reverse Proxy Mode","TXT_CODE_f085ce38":"Set to true to allow the grindstone to remove the name and lore from an item","TXT_CODE_f09da050":"Automatically create an instance by uploading a server compressed package. Only .zip files are supported. It will be automatically decompressed after upload.","TXT_CODE_f0be5e98":"Sets the player as invulnerable while they download the resource pack.","TXT_CODE_f0ca2761":"Dictionary of REST token for external applications to query the server.","TXT_CODE_f0dc2530":"Default User Group Permissions","TXT_CODE_f0de6bb8":"Characters that can be used in usernames. Configurable with regex.","TXT_CODE_f0e6cbc":"Set to true to force the world into halloween","TXT_CODE_f115eff":"Auto-Save Interval","TXT_CODE_f125d699":"Can only select one file at a time","TXT_CODE_f130e34a":"Block fall multiplier for gray bed","TXT_CODE_f160d877":"Reason for kicking players not on the whitelist.","TXT_CODE_f174dee0":"If set to  \\"Disabled\\", the server will dynamically calculate player\'s field of view and assign the rest to the client for construction. Only effective when client-side-chunk-generation-enabled is enabled.","TXT_CODE_f17889f4":"Will execute at regular or specific intervals.","TXT_CODE_f17af923":"Periodic Task","TXT_CODE_f1b166e7":"Details","TXT_CODE_f1c96d8a":"Solution:","TXT_CODE_f1cae9fa":"Leave blank to use the container\'s built-in entry point","TXT_CODE_f1ed28e6":"Makes the creeper\'s explosion be proportionate to the amount of health it has (lower health, weaker explosion)","TXT_CODE_f1f9ff1c":"The void height at which a trident with loyalty will return to it\'s thrower. A value of 0.0 or higher disables this feature.","TXT_CODE_f2168ca9":"The power of the end crystal\'s explosion","TXT_CODE_f220ed78":"Installation is complete!","TXT_CODE_f255aee0":"The cooldown after using an ender pearl (in ticks)","TXT_CODE_f2577f17":"Allow players to log into any account, even if the username doesn\'t match their character name.","TXT_CODE_f25df30a":"Terraria","TXT_CODE_f287f6dd":"Set the height a player/entity needs to fall before it tramples farmland","TXT_CODE_f28ded80":"Slime Chunk Seed","TXT_CODE_f29d5d2":"Prevent sending logs as messages to players with log permissions.","TXT_CODE_f2a58270":"Upload a Compressed Server Package","TXT_CODE_f2d5dd5":"Velocity Enable Online Mode","TXT_CODE_f2deb1d0":"Minecraft Game Server","TXT_CODE_f309e464":"Set to true if only players may trample farmland.","TXT_CODE_f3209427":"Panel Address","TXT_CODE_f3fc17f3":"Configuration file for PaperSpigot. It allows for further configuration of advanced parameters and more specific game settings. It greatly affects overall performance and expands upon the limitations of the Spigot configuration file.","TXT_CODE_f3fe5c8e":"Please select a date and time","TXT_CODE_f4110b65":"No available remote nodes found. Please go to the node page to connect your node. If you don\'t know how, try reinstalling the panel.","TXT_CODE_f41ad30a":"Please select items to delete.","TXT_CODE_f4244bbf":"CPU, Memory Usage","TXT_CODE_f435b042":"Send Player IP Data to Mojang to Prevent Proxy Users","TXT_CODE_f460677f":"Decompression failed","TXT_CODE_f4617d31":"Enter file URL address","TXT_CODE_f466d7a":"Select All","TXT_CODE_f486dbb4":"Instance deleted successfully","TXT_CODE_f49149d0":"Port","TXT_CODE_f49b2787":"Used for managing files of a specific instance.","TXT_CODE_f4b52ed4":"Maximum auto restart count","TXT_CODE_f4c15e78":"Set this to true to remove any BlockEntity that throws an error in its update method instead of closing the server and reporting a crash log. BE WARNED THIS COULD SCREW UP EVERYTHING USE SPARINGLY WE ARE NOT RESPONSIBLE FOR DAMAGES.","TXT_CODE_f4c9715b":"View More","TXT_CODE_f4fba0cd":"Template Name","TXT_CODE_f50cfe2":"Enter startup command","TXT_CODE_f51ce97e":"Disable clown bomb spawns.","TXT_CODE_f52079a0":"Connection Address","TXT_CODE_f54e6d1f":"Panel Time","TXT_CODE_f5689a76":"Actionbar message that shows when someone attempts to run with scissors","TXT_CODE_f591e2fa":"Select Theme","TXT_CODE_f59bbcef":"Inbound Packet Threshold","TXT_CODE_f5b9d58f":"Control Panel","TXT_CODE_f5cbef5c":"Enable Proxy Protocol","TXT_CODE_f5e3c97e":"Block fall multiplier for red bed","TXT_CODE_f5f9664":"This feature allows general users to use the default packages in \\"Quick Deployment\\" to reinstall instances.","TXT_CODE_f5feed4e":"Decompile Stack Trace Information","TXT_CODE_f6047384":"Optional, e.g., lobby-1","TXT_CODE_f60ca79d":"Carrot Growth Speed","TXT_CODE_f61bf5f3":"Disable Explosion Knockback Effect","TXT_CODE_f63bfe78":"This will reset all web pages to default, please proceed with caution. Displayed language can be switched after reset.","TXT_CODE_f63c4be2":"Waiting to upload in queue, {n} remaining","TXT_CODE_f6468fe8":"Set to true for the wither to bypass the mob griefing gamerule","TXT_CODE_f6a33629":"Operation Log","TXT_CODE_f6bd907d":"Are you sure you want to restart the instance?","TXT_CODE_f6d73056":"Please enter the template author","TXT_CODE_f6dacecc":"Set to true if this mob should drop experience","TXT_CODE_f7084f84":"User Operation","TXT_CODE_f70badb9":"Instance Name","TXT_CODE_f71475e2":"Bomb range affecting tile damage from the blast point (in tiles).","TXT_CODE_f728ba8":"Feeding a white/orange tulip changes type snow/regular","TXT_CODE_f738c45c":"Optimizations for entity brains when being far from a player","TXT_CODE_f73a2ad2":"Set how long the fire resistance lasts. Set to 0 to disable","TXT_CODE_f77093c8":"Renew","TXT_CODE_f773aaeb":"The lore of the spawner","TXT_CODE_f7909939":"Please enter hardware requirements","TXT_CODE_f79563ef":"Optional, parameters before -jar","TXT_CODE_f7969e5a":"User <<operator_name>> created the daemon process <<daemon_id>>","TXT_CODE_f7f57aec":"Save the world when the last player disconnects.","TXT_CODE_f801a9d2":"How long you should wait before another raid can be initiated","TXT_CODE_f80e0786":"Status","TXT_CODE_f8145844":"This application template cannot be used for reinstallation. Instances created using Docker containers cannot be reinstalled as normal templates. Please select a preset package with the Docker label for reinstallation. If you do need to install other templates, please contact the administrator to manually turn off the containerization settings of the instance.","TXT_CODE_f84ae54f":"After an instance has a tag, MCSManager will automatically classify the instance by tag name for users to filter when displaying these instances. Tag names support any language.","TXT_CODE_f8501690":"Set to false to stop enderman from being aggro towards all types of spawned endermites","TXT_CODE_f859eac":"Unable to edit this file.","TXT_CODE_f86b456a":"Allow Piston Duplication","TXT_CODE_f878fd4c":"Installing","TXT_CODE_f880b5ad":"Create an administrator account.","TXT_CODE_f88db280":"The current template is empty, do you want to continue saving?","TXT_CODE_f8a15a94":"Compress Files","TXT_CODE_f8b28901":"Reconnect","TXT_CODE_f8bb9f10":"Set to true for this mob to spawn below the sea level","TXT_CODE_f8ef0c45":"This configuration file is commonly used for Paper or other derived server types, expanding on the limitations of the Spigot configuration.","TXT_CODE_f8f3218a":"Timings Report URL","TXT_CODE_f912fadc":"Running","TXT_CODE_f94e428a":"User cancelled","TXT_CODE_f9a92e38":"Console, file uploading, and file downloading on remote daemon requires direct connection to the daemon from browser.","TXT_CODE_f9b6e61b":"Upload Compressed Server Package","TXT_CODE_f9c65693":"Stops entities from dropping loot on death, if killed by cramming gamerule","TXT_CODE_f9d92e18":"Should damage be ignored while in water if damage-if-sprinting is enabled","TXT_CODE_fa301a5":"If the player is in creative and hits an entity with an empty hand, the entity instantly dies","TXT_CODE_fa487a47":"Provide the following variable strings: &lbrace;mcsm_instance_id&rbrace; = instance ID, &lbrace;mcsm_workspace&rbrace; = instance installation directory","TXT_CODE_fa6d3490":"Allow Spiders to Cross World Borders","TXT_CODE_fa6f95a1":"MC MCDR","TXT_CODE_fa7002ef":"User <<operator_name>> restarted the <<instance_name>> instance","TXT_CODE_fa920c0":"Expire","TXT_CODE_faa1962b":"User <<operator_name>> created the user <<target_user_name>>","TXT_CODE_faa6656a":"The server will send hashed block network IDs instead of incrementing IDs starting from 0","TXT_CODE_fabc6a75":"Villager Immunity After Work","TXT_CODE_fabfaadc":"Message that shows when the rambar is enabled for a user using the /rambar command.","TXT_CODE_facd4d3c":"Makes this mob mountable in water (it won\'t eject you)","TXT_CODE_fb00a910":"Desert Temple Seed","TXT_CODE_fb1ff943":"Unknown Environment","TXT_CODE_fb23339d":"This is a common configuration file for Bukkit-like or it\'s derivative server software. In general, this configuration file does not require extensive modifications. You can adjust it based on the explanation, but if you are using Bukkit-derived server software, this configuration file may be ineffective.","TXT_CODE_fb267b0b":"Permanently delete this daemon?","TXT_CODE_fb4cb9cb":"Cannot add, this card can only be placed on pages with higher permissions","TXT_CODE_fb547313":"Please make sure the instance is stopped before deleting it!","TXT_CODE_fb75aba9":"[Configuration Upgrade] Configuration file parsing error, ignored:","TXT_CODE_fb87ccd":"Instance Code","TXT_CODE_fb93942a":"Respawn Point Load Radius","TXT_CODE_fbde647e":"Refreshed","TXT_CODE_fbe67333":"Do not spawn a cat if another cat is found within this range. Set to 0 to disable","TXT_CODE_fc4e2173":"Instance will be created after file upload.","TXT_CODE_fc5c0e2e":"Makes this mob mountable in water (it wont eject you)","TXT_CODE_fc7ac5ea":"Maximum number of threads used by the server (0 for no limit)","TXT_CODE_fcb08d61":"Set to true to stop an enderman from going aggro by a player looking into the enderman\'s eyes","TXT_CODE_fcbdcb34":"Monday","TXT_CODE_fcd641db":"Task Action / Type","TXT_CODE_fcdc758":"Changing the instance folder owner (chown) failed. This step has been automatically skipped.","TXT_CODE_fcde7b2e":"These settings require some level of expertise. You can adjust them based on the host performance.","TXT_CODE_fcee1fa0":"Ruined Portal Seed","TXT_CODE_fd0cdf5d":"Import from file","TXT_CODE_fd13f431":"Edit Picture","TXT_CODE_fd5ca298":"Shrink Height (height of rows must be consistent to change the minimum height)","TXT_CODE_fd63a181":"Page Not Found","TXT_CODE_fd665d32":"Maximum Movement Speed","TXT_CODE_fd838916":"All Chunks are Slime Chunks","TXT_CODE_fd9d9eeb":"Controls if attributes should have their values clamped.","TXT_CODE_fdb6c369":"Process User","TXT_CODE_fdd1a61":"Log REST API connection information.","TXT_CODE_fdd8effa":"Kicked for Flying Player Message","TXT_CODE_fde31068":"User file upload rate","TXT_CODE_fdec1b6f":"Mount Working Directory","TXT_CODE_fe2435a0":"Using 7zip to decompress to current directory: {{command}}","TXT_CODE_fe25087f":"Please enter the key.","TXT_CODE_fe3f34e6":"Not Selected","TXT_CODE_fe402f41":"Set to true to make it so sugarcane can be bonemealed","TXT_CODE_fe463ea3":"Purpur keeps track of when it is lagging in order to have the ability to change behaviors accordingly. This value is that threshold when you want to consider the server to be lagging.","TXT_CODE_fe46ac12":"Chance for azalea to grow into trees naturally","TXT_CODE_fe592df1":"How often the bossbar should update","TXT_CODE_fe731dfc":"Actions","TXT_CODE_fe80882d":"UDP Query Port","TXT_CODE_fe82609a":"Prevent players from placing invalid tile styles.","TXT_CODE_fe95b79a":"Whether to enable server authoritative mining","TXT_CODE_feaa97d4":"Set the default collar color when a wolf is tamed.","TXT_CODE_feab659d":"All Types","TXT_CODE_fec66aca":"Enable Xbox achievements.","TXT_CODE_feeea328":"Gain full terminal interaction capability through an emulated terminal. This includes using Tab, Ctrl keys, and more.","TXT_CODE_fefbb457":"Incorrect account or password","TXT_CODE_ff2c2f20":"Chunk File Cache Size","TXT_CODE_ff81b31e":"Tick","TXT_CODE_ff8431c1":"Netty Threads","TXT_CODE_ffa884f9":"Warning: The working directory is not mounted to the container, and the container will not be able to access files in the instance\'s working directory","TXT_CODE_ffca72ed":"Make the server appear as \'Online\' on the server list. If set to \'false,\' it will suppress responses from the client. This means it will appear as \'Offline\' but still accept connections.","TXT_CODE_ffda3755":"Enter code","TXT_CODE_ffe9366a":"Add any items and blocks that aren\'t originally in the Bedrock edition.","TXT_CODE_ffeacc21":"The stop command must not contain line breaks; it is not a script file and cannot execute multiple commands","TXT_CODE_ffebf0bf":"Broadcast RCON to Operators","TXT_CODE_fff00e2b":"Min movement speed attribute","TXT_CODE_fffaeb16":"Cannot cancel during upload!","TXT_CODE_fffaeb17":"Run start command as user.","TXT_CODE_fffaeb18":"Set the system user used to start the process. You may need to solve problems caused by permission issues yourself.","TXT_CODE_file_router.instanceNotExist":"Instance {{instanceUuid}} does not exist","TXT_CODE_file_router.unzipLimit":"Exceeded the maximum number of concurrent decompression tasks. The maximum allowed is {{maxFileTask}}, and currently, {{fileLock}} tasks are in progress. Please be patient.","TXT_CODE_file_router_service.instanceNotExit":"Instance {{uuid}} does not exist","TXT_CODE_frp.done":"FRP reverse proxy installed. You can check the mapping status from the top left corner. If it is not displayed, it may be due to antivirus software, insufficient file permissions, or incorrect FRP key.","TXT_CODE_frp.downloadErr":"Failed to download the FRP application, and the FRP proxy cannot be started properly.","TXT_CODE_frp.installing":"Downloading and installing the FRP reverse proxy. We will automatically start the program shortly...","TXT_CODE_general_start.cmdEmpty":"Unable to start the instance as the startup command is empty","TXT_CODE_general_start.cwd":"Working Directory: {{cwd}}","TXT_CODE_general_start.cwdPathNotExist":"The working directory does not exist","TXT_CODE_general_start.instanceConfigErr":"Startup command, input/output encoding, or working directory is empty","TXT_CODE_general_start.instanceUuid":"Instance UUID: [{{uuid}}]","TXT_CODE_general_start.pidErr":"Detected instance process/container startup failure (PID is empty). Possible reasons are:\\n1. Incorrectly instance startup command. Please check the startup command and parameters in the instance settings.\\n2. Incorrect or missing system host environment, such as Java environment, etc.\\n\\nNative startup command:\\n{{startCommand}}\\n\\nStartup Command Parsing:\\nProgram: {{commandExeFile}}\\nParameters: {{commandParameters}}\\n\\nPlease report this information to the administrator, technical support, or troubleshoot yourself.","TXT_CODE_general_start.runAs":"Try to start the subprocess using the system user, username: {{user}}","TXT_CODE_general_start.startCmd":"Startup Command: {{cmdList}}","TXT_CODE_general_start.startErr":"Instance startup failed. Please check the startup command, host environment, and configuration file.","TXT_CODE_general_start.startInstance":"Session {{source}}: Request to start the instance.","TXT_CODE_general_start.startOrdinaryTerminal":"Instance running. You can send commands use the input box at the bottom. If you need advanced console features like Ctrl, Tab, and other shortcuts, please go to terminal settings to enable the emulated terminal.","TXT_CODE_general_start.startSuccess":"Instance {{instanceUuid}} started with PID: {{pid}}","TXT_CODE_general_stop.execCmd":"The predefined shutdown command has been executed: {{stopCommand}}\\nIf the instance does not stop, please change the correct shutdown command, such as ^C, stop, end, etc.","TXT_CODE_general_stop.notRunning":"Instance not running and cannot be stopped.","TXT_CODE_general_stop.stopErr":"The shutdown command has been sent but the instance has not stopped for an extended period. This could be due to an incorrect shutdown command or a process freeze. The instance will now return to running state, and you can use \'Terminate\' function to end the process.","TXT_CODE_general_update.cmdFormatErr":"Incorrect update command. Please contact your administrator.","TXT_CODE_general_update.err":"Error","TXT_CODE_general_update.error":"Update Error: {{err}}","TXT_CODE_general_update.killProcess":"Terminating the task process...","TXT_CODE_general_update.readyUpdate":"Instance {{instanceUuid}} is preparing for the update operation...","TXT_CODE_general_update.statusErr_notStop":"Incorrect instance status, cannot perform the update task. The instance must be stopped first.","TXT_CODE_general_update.statusErr_otherProgress":"Incorrect instance status, another task is currently in progress.","TXT_CODE_general_update.terminateUpdate":"User requested to terminate the update asynchronous task for instance {{instanceUuid}}","TXT_CODE_general_update.update":"Update","TXT_CODE_general_update.updateCmd":"Instance {{instanceUuid}} executed the update command as follows:","TXT_CODE_general_update.updateErr":"The update process has ended with error. It may be due to damaged update files or network issues.","TXT_CODE_general_update.updateFailed":"Update failed. The update command failed to start. Please contact the administrator.","TXT_CODE_general_update.updateSuccess":"Update successful!","TXT_CODE_http_router.downloadErr":"Download error: {{error}}","TXT_CODE_http_router.fileNameNotSpec":"User file download name does not conform to standards.","TXT_CODE_http_router.instanceNotExist":"Instance does not exist.","TXT_CODE_http_router.updateErr":"Unknown reason: Upload failed.","TXT_CODE_install.changeModeErr":"Failed to change permissions for file {{path}}. Please manually set it to chmod 755 or above.","TXT_CODE_install.guide":"Dependency program reference: https://github.com/mcsmanager/pty","TXT_CODE_install.installErr":"Installation of optional dependency libraries failed. Full emulated terminal and some optional features will not be available. This does not affect normal functionality and will be attempted again at the next startup.","TXT_CODE_install.installed":"Optional dependency programs have been automatically installed, emulated terminal and some advanced features have been automatically enabled.","TXT_CODE_install.ptyNotSupportSystem":"Emulated terminal is only supported on Windows/Linux x86_64 architecture. Downgraded to a regular terminal.","TXT_CODE_install.ptySupport":"Recognized the installed dependency libraries, emulated terminal functionality is now available.","TXT_CODE_install.skipInstall":"System is not a Linux system, automatically skipped dependency library installation.","TXT_CODE_instance.dirEmpty":"Startup command, input/output encoding, or working directory is empty.","TXT_CODE_instance.dirNoE":"Working directory does not exist.","TXT_CODE_instance.invalidContainerName":"Invalid container name {{v}}.","TXT_CODE_instance.invalidCpu":"Invalid CPU core specification {{v}}.","TXT_CODE_instance.successful":"Instance {{v}} started successfully.","TXT_CODE_instanceConf.autoRestart":"Unexpected instance stop detected. Restart command has been sent...","TXT_CODE_instanceConf.autoRestartErr":"Auto-restart error: {{err}}","TXT_CODE_instanceConf.cantModifyInstanceType":"The instance type cannot be modified while running.","TXT_CODE_instanceConf.cantModifyProcessType":"The process type cannot be modified while running.","TXT_CODE_instanceConf.cantModifyPtyModel":"PTY mode cannot be modified while running.","TXT_CODE_instanceConf.error":"Error","TXT_CODE_instanceConf.info":"Information","TXT_CODE_instanceConf.initInstanceErr":"Failed to initialize the instance. The unique identifier or configuration parameters are empty.","TXT_CODE_instanceConf.instanceBusy":"The current instance is busy and cannot perform any operations.","TXT_CODE_instanceConf.instanceLock":"This {{info}} operation cannot be executed because the instance is locked. Please try again later.","TXT_CODE_instanceConf.instantExit":"The instance appears to have exited shortly after startup, which may be due to an incorrect launch command or configuration error.","TXT_CODE_instanceConf.ptyNotExist":"Emulated terminal cannot be enabled because the attached program {{path}} does not exist. You can contact the administrator to restart the Daemon program for reinstallation (Linux only).","TXT_CODE_mc_update.updateInstance":"Updating instance...","TXT_CODE_passport_router.registerErr":"Task name or key cannot be empty","TXT_CODE_permission.apiError":"Incorrect key","TXT_CODE_permission.forbidden":"Insufficient Permissions","TXT_CODE_permission.forbiddenInstance":"[Forbidden] [Middleware] Incorrect parameters or unauthorized access to the instance.","TXT_CODE_permission.forbiddenTokenError":"Token validation failed, access denied","TXT_CODE_permission.tooFast":"Too many requests, please try again later","TXT_CODE_permission.xmlhttprequestError":"Unable to find the request header: x-requested-with: xmlhttprequest","TXT_CODE_preset.actionErr":"Predefined command {{action}} is not available.","TXT_CODE_process_config.writEmpty":"Content to write is empty, possibly due to an unsupported type of configuration file","TXT_CODE_protocol.socketErr":"Session {{id}}({{address}})/{{event}}  encountered an exception when responding:\\n","TXT_CODE_pty_start.cmdEmpty":"Unable to start the instance: the startup command is empty","TXT_CODE_pty_start.cmdErr":"Startup command, input/output encoding, or working directory is empty","TXT_CODE_pty_start.cwdNotExist":"The working directory does not exist","TXT_CODE_pty_start.instanceStartErr":"Instance failed to start. Please check the startup command, host environment, and configuration files, etc","TXT_CODE_pty_start.instanceUuid":"Instance UUID: [{{instanceUuid}}]","TXT_CODE_pty_start.mustAbsolutePath":"The working directory for emulated terminal must be an absolute path. Please go to the instance settings and set the working directory to an absolute path.","TXT_CODE_pty_start.notSupportPty":"Emulated terminal mode failed. Unsupported architecture or system. Downgraded to regular terminal mode...","TXT_CODE_pty_start.pidErr":"It was detected that the process startup failed. The possible reasons are: \\n1. The instance startup command was written incorrectly. Please go to the instance setting interface to check the startup command and parameters. \\n2. The system host environment is incorrect or lacks an environment, such as a lack of Java environment, etc. \\n\\nStart command:\\n{{startCommand}}\\n\\nPlease report this information to the administrator, technician or troubleshoot yourself.","TXT_CODE_pty_start.ptyCwd":"Working Directory: {{cwd}}","TXT_CODE_pty_start.ptyParams":"PTY Parameters: {{param}}","TXT_CODE_pty_start.ptyPath":"PTY Path: {{path}}","TXT_CODE_pty_start.sourceRequest":"Session {{source}}: Requested instance start.","TXT_CODE_pty_start.startCmd":"Startup Command: {{cmd}}","TXT_CODE_pty_start.startEmulatedTerminal":"Emulated terminal mode is active. You can directly input content in the terminal and use Ctrl, Tab, and other function keys.","TXT_CODE_pty_start.startErr":"Emulated terminal mode failed. Dependency program might be missing. Downgraded to regular terminal mode...","TXT_CODE_pty_start.startPty":"Session {{source}}: Requested instance start with emulated terminal.","TXT_CODE_pty_start.startSuccess":"Instance {{instanceUuid}} started successfully. PID: {{pid}}","TXT_CODE_pty_stop.execCmd":"Stop command has been executed: {{stopCommand}}\\nIf you are unable to stop the instance, please go to the instance settings and change the correct command for stopping the instance, such as \'exit,\' \'stop,\' \'end,\' etc.","TXT_CODE_pty_stop.notRunning":"The instance is not running and cannot be stopped.","TXT_CODE_pty_stop.stopErr":"The shutdown command has been sent but the instance has not stopped for an extended period. This could be due to an incorrect shutdown command or a process freeze. The instance will now return to running state, and you can use \'Terminate\' function to end the process.","TXT_CODE_quick_install.hiperError":"The network mapping process already exists and cannot be started again!","TXT_CODE_quick_install.unzipError":"Unzip Failed","TXT_CODE_restart.error1":"Instance restart error. The instance has been previously started, and the planned restart has been canceled.","TXT_CODE_restart.error2":"Instance restart error.The instance should have been in a stopping state but is now running. The restart plan is canceled.","TXT_CODE_restart.restarting":"Server stopped, restarting the instance...","TXT_CODE_restart.start":"Starting to execute the restart event.","TXT_CODE_router.file.off":"Administrator has restricted file management functionality for default users","TXT_CODE_router.initComplete":"All feature modules and permission firewalls have been initialized successfully","TXT_CODE_router.instance.createError":"Failed to create instance","TXT_CODE_router.login.ban":"Too many attempts, your IP address has been banned for 10 minutes","TXT_CODE_router.login.init":"[Panel Installation] Initializing panel admin account: {{userName}}","TXT_CODE_router.login.installed":"MCSM has already been installed and cannot be reinstalled. Please backup and delete the data folder for a new installation","TXT_CODE_router.login.nameOrPassError":"Incorrect Username or Password","TXT_CODE_router.schedule.invalidName":"Invalid Task Name","TXT_CODE_router.user.deleteFailure":"Unable to delete user data","TXT_CODE_router.user.existsUserName":"Username is already in use","TXT_CODE_router.user.installed":"Admin account has already been created and cannot be recreated","TXT_CODE_router.user.invalidPassword":"Invalid Password Format","TXT_CODE_router.user.invalidUserName":"Invalid Username Format","TXT_CODE_router.user.passwordCheck":"Invalid password. It must contain uppercase and lowercase letters, numbers, and have a length between 9 and 36 characters","TXT_CODE_start.instanceMaturity":"Instance expired. Unable to start the instance","TXT_CODE_start.instanceNotDown":"The instance is running and cannot be started again","TXT_CODE_start.startInstance":"Preparing to start...","TXT_CODE_stream_router.IGNOREAccess":"Unauthorized access","TXT_CODE_stream_router.authSuccess":"Session {{id}} {{address}} data channel authenticated.","TXT_CODE_stream_router.disconnect":"Session {{id}} {{address}} has disconnected from the data channel with {{uuid}}","TXT_CODE_stream_router.establishConnection":"Session {{id}} {{address}} has established a data channel with {{uuid}}","TXT_CODE_stream_router.instanceNotExist":"Instance does not exist","TXT_CODE_stream_router.taskNotExist":"Task does not exist","TXT_CODE_stream_router.unauthorizedAccess":"Unauthorized access","TXT_CODE_systemRemoteService.autoCheckDaemon":"Detected local daemon, automatically obtaining key and port...","TXT_CODE_systemRemoteService.error":"Unable to automatically retrieve local daemon configuration. Please manually connect the daemon through the panel. Visit https://docs.mcsmanager.com/ for more information.","TXT_CODE_systemRemoteService.loadDaemonTitle":"Attempting to read local daemon {{localKeyFilePath}}","TXT_CODE_systemRemoteService.nodeCount":"Number of remote daemons: {{n}}","TXT_CODE_systemUser.userCount":"Number of local users: {{n}}","TXT_CODE_system_file.execLimit":"Exceeded maximum file editing limit","TXT_CODE_system_file.illegalAccess":"Illegal access path","TXT_CODE_system_file.unzipLimit":"File decompression only supports file up to {{max}}GB. To change this limit, please go to the data/Config/global.json file.","TXT_CODE_system_instance.autoStart":"Automatic start command for instance {{name}} ({{uuid}}) has been issued.","TXT_CODE_system_instance.autoStartErr":"Error occurred while automatically starting instance {{name}} ({{uuid}}): {{reason}}","TXT_CODE_system_instance.checkConf":"Please check or delete the file: data/InstanceConfig/{{uuid}}.json","TXT_CODE_system_instance.readInstanceFailed":"Failed to read instance {{uuid}}: {{error}}","TXT_CODE_system_instance.uuidEmpty":"Cannot create a certain instance because the instance UUID is empty.","TXT_CODE_system_instance_control.crateSuccess":"Created scheduled task {{name}} successfully.","TXT_CODE_system_instance_control.crateTask":"Creating scheduled task {{name}}:\\n{{task}}","TXT_CODE_system_instance_control.crateTaskErr":"Error creating scheduled task. Invalid time expression: \\n{{name}}: {{timeArray}}\\nPlease try deleting the data/TaskConfig/{{name}}.json file to resolve this issue.","TXT_CODE_system_instance_control.execCmdErr":"Error executing scheduled task {{name}} for instance {{uuid}}:\\n{{error}}","TXT_CODE_system_instance_control.execLimit":"Cannot continue creating scheduled tasks as the limit has been reached.","TXT_CODE_system_instance_control.existRepeatTask":"A duplicate task already exists.","TXT_CODE_system_instance_control.illegalName":"Illegal task name. Only underscores, numbers, letters, and some local language characters are supported.","TXT_CODE_ui.help":"[Terminal] The daemon has basic interactive functionality. Please enter \'help\' for more information.","TXT_CODE_version.versionDetectErr":"Version Check Failed"}');

/***/ }),

/***/ "../languages/es_ES.json":
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"TXT_CODE_00000001":"Bienvenido al panel de gestión de MCSManager","TXT_CODE_10088738":"Confirmar eliminación","TXT_CODE_10150756":"Tareas desencadenadas por eventos","TXT_CODE_10194e6a":"Alias de la red","TXT_CODE_10430e01":"Semilla de puesto avanzado","TXT_CODE_1049cbd1":"Si el servidor debe generar mensajes de nivel de depuración relacionados con las operaciones del sistema","TXT_CODE_10693964":"cualquier tipo de programa","TXT_CODE_107695d":"Tutti i giochi","TXT_CODE_108ce2e4":"Ancho de banda:","TXT_CODE_10a6d36f":"Una consola utilizada para mostrar e interactuar con una instancia.","TXT_CODE_10cc2794":"Descripción de la arquitectura de red","TXT_CODE_10eeb359":"La cantidad de mobs circundantes (también conocidos como murciélagos) que pueden aparecer en el mundo.","TXT_CODE_10efed7c":"Establecido en falso para mantener vivo al coral cuando se coloca en tierra","TXT_CODE_1135828":"tasa de crecimiento del trigo","TXT_CODE_1155db3a":"Si se debe permitir que los oyentes del servidor utilicen el protocolo GameSpy4","TXT_CODE_115e891f":"Deshabilitar la generación de bola de nieve","TXT_CODE_115e8a25":"Valor de la variable","TXT_CODE_11673d8c":"Cerraste tu sesión exitosamente","TXT_CODE_116db655":"Toca un sonido de eructo después de que un jugador llena por completo la barra del hambre comiendo","TXT_CODE_1181762b":"Tiempo de residencia de bloque fijo","TXT_CODE_11cba563":"Si se golpea un pollo, atacará hacia atrás","TXT_CODE_11cfe3a1":"Comando de cerrar instancia","TXT_CODE_11d2ab6b":"Valor RGB utilizado para el color del mensaje de difusión","TXT_CODE_11d5caea":"Crear una cuenta","TXT_CODE_11dd341b":"Establecer en falso para deshabilitar la capacidad de los jugadores de saltar la noche durmiendo","TXT_CODE_11ecd5a9":"Error desconocido","TXT_CODE_11f8cc36":"Límite de abuso de la tecla Tab","TXT_CODE_12040bf0":"El número de puerto debe estar entre 0 y 65535","TXT_CODE_123bcd09":"Compilación personalizada usando DockerFile","TXT_CODE_12413b31":"Esto es la cantidad de monstruos que se pueden generar en cada mundo.","TXT_CODE_125812c9":"El gradiente de <Ext> cuando el modo relleno es \'medio\'","TXT_CODE_129475a7":"Razones para expulsar a los jugadores incondicionales","TXT_CODE_1295831e":"Si la función de reproducción cromática entra en conflicto con la función de color del software, puede desactivar esta función.","TXT_CODE_12e3afa9":"Un archivo de configuración muy importante para el servidor de Minecraft. Casi la mayoría de las configuraciones comunes (puertos, número de personas, distancia de visión, etc.) se editan en este archivo.","TXT_CODE_1301e748":"Se corrigió el error del cristal final invencible.","TXT_CODE_13411df7":"Error al iniciar sesión en SSO. Vuelva a la página original e intente iniciar sesión nuevamente.","TXT_CODE_1348332a":"Controlar si el huevo de dragón se teletransportará cuando golpee","TXT_CODE_13663120":"Por ejemplo: sin completar los parámetros, la \\"Tarjeta de consola\\" solo se puede usar en la página \\"Detalles de la instancia\\".","TXT_CODE_1396f33c":"Si un cactus se romperá de un bloque sólido al lado","TXT_CODE_139ef152":"Establecer versión. \\nNO cambies esto","TXT_CODE_13aa13dd":"Marcador de complementos de seguimiento","TXT_CODE_13ae6a93":"Copiar","TXT_CODE_13dfc5cb":"Longitud de la historia","TXT_CODE_13eac7e1":"URL de Descarga del Paquete (Opcional)","TXT_CODE_143db7d9":"Descompresión 7zip completada: {{result}}","TXT_CODE_143e55cb":"ID del número de línea de descripción del artículo","TXT_CODE_143f213e":"tasa de crecimiento de la vid","TXT_CODE_144caddf":"Arreglar los desovadores que no generan animales de agua correctamente; \\nMC-238526","TXT_CODE_14688b70":"Te brinda la capacidad de controlar cuánto tiempo es invulnerable cuando se genera por primera vez.","TXT_CODE_1471ac98":"Establecer en True para los zorros para evitar el Gamérulo de duelo de la mafia","TXT_CODE_147a2f87":"El tiempo real requerido está relacionado con la velocidad de la red y la velocidad del procesador, así que tenga paciencia.","TXT_CODE_148d6467":"Detener una instancia","TXT_CODE_15022f3e":"Usar nombre para mostrar en el mensaje de salida","TXT_CODE_1514d08f":"El comando se ha emitido correctamente a cada host remoto. La operación específica puede retrasarse ligeramente. Espere un momento para comprobar los resultados.","TXT_CODE_153f705d":"Eliminar tarjeta","TXT_CODE_1544562":"Carga útil","TXT_CODE_1548649e":"Editar tareas programadas","TXT_CODE_154cd636":"El enfriamiento del asador de delfines","TXT_CODE_1556989":"El contenido de la etiqueta es demasiado largo. \\nReduzca el número de caracteres.","TXT_CODE_1561198c":"Después de cargar el archivo, la instancia creará y descomprimirá automáticamente el archivo. Es posible que tarde algún tiempo en completar la tarea de descompresión.","TXT_CODE_1562f6cf":"Se han completado todas las operaciones de instalación. \\nPor favor intente iniciar la instancia ...","TXT_CODE_157e06a9":"Número máximo de jugadores mostrados en la lista TAB","TXT_CODE_1594de63":"El idioma por defecto a usar si no tenemos el idioma solicitado por el cliente.","TXT_CODE_159f0203":"Rango de seguimiento de monstruos","TXT_CODE_15a381d5":"Agregar un nuevo nodo","TXT_CODE_15c07350":"¡La tarea de descompresión/compresión expiró y finalizó automáticamente!","TXT_CODE_15c6d4eb":"Restablecer exitosamente","TXT_CODE_15c747a6":"Retraso en las garrapatas entre física/flujo (más bajo es más rápido)","TXT_CODE_15e80e9d":"La altura del paso en la que un minecarts puede subir al siguiente bloque sin saltar","TXT_CODE_15f2e564":"Sin ejecutar","TXT_CODE_15f5fb07":"Puerto inicial asignado","TXT_CODE_163e2d0a":"Mostrar especificaciones de instancia cuando el modo comercial está habilitado","TXT_CODE_1644b775":"Añadir","TXT_CODE_1648c9ea":"Mostrar información del comerciante cuando el modo comerciante está habilitado","TXT_CODE_16853efe":"Cambiar permisos","TXT_CODE_16b4f026":"Silenciar la consola del bloque de comandos","TXT_CODE_16d71239":"Panel","TXT_CODE_16da1c76":"Escala de transferencia de embudo","TXT_CODE_16e2615":"El mensaje de muerte que aparece cuando el jugador es asesinado porque estaban parados en un StoneCutter","TXT_CODE_16e58cc1":"Ya sea para eliminar el dragón ender","TXT_CODE_16f55a9b":"Se inicia la tarea de descompresión de archivos. Si hay demasiados archivos, llevará algún tiempo.","TXT_CODE_1704ea49":"Instalar","TXT_CODE_172c745e":"Permite la capacidad de aumentar los encantamientos aprobados por su nivel máximo. \\nPor ejemplo, Eficiencia V Eficiencia V = Eficiencia VI.","TXT_CODE_1732276b":"La distancia a la que atacará el golem de nieve","TXT_CODE_17544b7b":"Debido a que no se puede detectar el nombre del archivo del servidor en el paquete comprimido, complete el comando de inicio usted mismo.","TXT_CODE_175b570d":"A partir de","TXT_CODE_176b2151":"Establezca esto en verdadero para habilitar la publicidad del servidor dedicado a los clientes LAN locales para que aparezca automáticamente en la pantalla multijugador.","TXT_CODE_1770c716":"La cantidad de obsidiana requerida para dañar un yunque","TXT_CODE_179d7be4":"Habilitar protocolo Rcon","TXT_CODE_179e8e0":"Rango de seguimiento del jugador","TXT_CODE_179eb7ce":"El número máximo de bloques generados por un jugador al mismo tiempo.","TXT_CODE_17b3748b":"Consultar historial de compras","TXT_CODE_17be5f70":"¡El nombre de la imagen no puede estar vacío!","TXT_CODE_17cbacf6":"Bloquear al jugador si esta cantidad de fichas se colocan en 1 segundo","TXT_CODE_17f1f440":"Dirección de la base de datos MySQL","TXT_CODE_180884da":"Habilitar el modo comerciante","TXT_CODE_181c72ba":"¿No se encuentra una plantilla adecuada? \\nPersonalizar una configuración de plantilla.","TXT_CODE_181f2f08":"No se puede obtener información del nodo remoto","TXT_CODE_187bb567":"Todas las instancias se han cerrado, saliendo del programa ...","TXT_CODE_188c7493":"Si se debe deshabilitar el guardado de progreso","TXT_CODE_18b3d541":"Si las camas explotan cuando un aldeano duerme en uno.","TXT_CODE_18b94497":"Necesidades ambientales","TXT_CODE_18cdc17f":"Modificar título","TXT_CODE_18d2f8ae":"¿Está seguro de que desea eliminar esta instancia y archivar? \\nEsta operación eliminará todos los archivos en el directorio de la instancia; opere con precaución","TXT_CODE_18de069c":"Permite el encantamiento de saqueo en las tijeras","TXT_CODE_18df7f10":"Por favor seleccione la categoría de su programa de servidor","TXT_CODE_18e7e5df":"Variables de Entorno (Opcional)","TXT_CODE_190ecd56":"Carga de linux","TXT_CODE_19140a89":"Establecer en verdadero para hacer que las columnas de burbujas ascendentes generen en lugar de columnas de burbujas hacia abajo cuando los bloques de magma se colocan/generan bajo bloques de fuente de agua.","TXT_CODE_192078c6":"Cuando un jugador excede el umbral de TilePaint, si expulsarlo","TXT_CODE_192b48f0":"El servidor se está reiniciando","TXT_CODE_193297ed":"Tasa de crecimiento de la papa","TXT_CODE_1934114b":"Editor de configuración para instancias de aplicaciones, tarjetas de funciones de entrada para configuraciones de consola y otras funciones","TXT_CODE_193605ab":"Establecido en verdad para hacer que Enderman ignore a los jugadores que usan la cabeza del dragón","TXT_CODE_193f5347":"Wither genera un radio de efecto de sonido.","TXT_CODE_195215f7":"La compensación de proyectil de una conya lanzable","TXT_CODE_196253a2":"¿Deberíamos usar Mojang para autenticar jugadores? \\nDe forma predeterminada, esta opción está activada.","TXT_CODE_196d6257":"La ecuación de usar para calcular un shulker que desove de una bala (cerca es la cantidad de entidades de shulker cercanas) hace que esto sea en blanco siempre desovado si hay un shulker cerca","TXT_CODE_1981470a":"Si elige eliminar archivos relacionados con la instancia al mismo tiempo, todo el directorio donde se encuentra la instancia se eliminará directamente.","TXT_CODE_1987587b":"Requerido, de 3 a 12 caracteres, cualquier idioma admitido","TXT_CODE_19cada2a":"El intervalo en segundos para hacer ping al servidor remoto.","TXT_CODE_19f697f3":"¡Sé que podrían hackearme! \\n¡Ignora los riesgos!","TXT_CODE_1a0ab98b":"Establezca la contraseña para el acceso remoto de RCON (consulte enable-rcon)","TXT_CODE_1a124d6":"Establecer esto en falso evita mantener vivas las flechas indefinidamente (como cuando el bloque de la flecha está atascada se quita, como una cabeza de pistón subiendo/hacia abajo).","TXT_CODE_1a37f514":"Deje que el programa contenedor utilice el puerto de conexión real del host mediante el mapeo","TXT_CODE_1a499109":"El archivo no existe","TXT_CODE_1a6bacc6":"Si se debe registrar en la consola el registro de solicitudes de ping iniciadas por el cliente del reproductor a BungeeCord","TXT_CODE_1a6d30de":"Bloquear la conexión de jugadores softcore","TXT_CODE_1a730d48":"El contenido del archivo de configuración está vacío. Verifique si el archivo es correcto o haga clic en el botón \\"Editar archivo fuente\\" arriba para continuar con la edición.","TXT_CODE_1a77954":"La cantidad máxima de garrapatas para elegir al azar cuando se cura","TXT_CODE_1a8cf808":"Semilla del templo submarino","TXT_CODE_1ac19459":"Tasa de desaparición de flechas en modo creativo","TXT_CODE_1adaa4f4":"Despierta al animal cada tictac.","TXT_CODE_1af148fe":"Existe un archivo con el mismo nombre.","TXT_CODE_1b1b2934":"El comando RCON no se pudo enviar debido a una contraseña incorrecta. ¡Verifique la contraseña de acceso establecida en el protocolo Steam Rcon!","TXT_CODE_1b450b79":"Por favor ingrese el nombre del directorio","TXT_CODE_1b518dd0":"Bloquear multiplicador de otoño para la cama de lima","TXT_CODE_1b688710":"Descompresión 7zip falló: {{message}} (detalles: {{details}})","TXT_CODE_1b763e24":"Muestra la IP del jugador que tiene permiso de registro cuando el jugador se une","TXT_CODE_1b78c12e":"Salida del marcador de posición <ronte> en el comando.uptime.format opción","TXT_CODE_1b7a8832":"¡Trabajo cancelado!","TXT_CODE_1b7f826e":"La compensación de proyectil de una ballesta","TXT_CODE_1b82883f":"¿Qué color debería mostrar cuando el uso de RAM es \'medio\'?","TXT_CODE_1b858414":"Establecer en True para el Dragón Ender para obtener la capacidad de montar vehículos","TXT_CODE_1baf656e":"Seleccione un directorio existente en el servidor","TXT_CODE_1bc41425":"Opción para elegir si ignorar o no a los jugadores creativos al generar turbas.","TXT_CODE_1c18acc0":"Configuración de la apariencia","TXT_CODE_1c2efd38":"No se puede establecer una conexión de red con el nodo remoto. Verifique si el nodo remoto está funcionando normalmente. \\n¿Está la red configurada correctamente?","TXT_CODE_1c36c8f2":"Terminar instancia","TXT_CODE_1c38439b":"Establecido en True para Silverfish para evitar el Gamérulo de duelo de la mafia","TXT_CODE_1c45f7fe":"Editar archivo de configuración del servidor","TXT_CODE_1c6e2cd":"Número de hongos para alimentar a una vaca para que se transforme en un Mooshroom. \\nValor de 0 Desactiva la función","TXT_CODE_1c7a8f47":"¡El servidor está lleno!","TXT_CODE_1c84154f":"Porcentaje de posibilidades (0.0 - 1.0) que un lobo aparecerá como rabioso","TXT_CODE_1cafa176":"Permite aplicar encantamientos juntos que normalmente son incompatibles. \\nPor ejemplo, protección y protección contra incendios o fortuna y toque de seda.","TXT_CODE_1cd8f9d2":"Archivo de configuración del servidor Tshock","TXT_CODE_1ce1d1d1":"Plataforma de Ejecución","TXT_CODE_1ceefd70":"Los jugadores se barajan","TXT_CODE_1cf6fc4b":"¡La configuración del puerto abierto de este contenedor es incorrecta!","TXT_CODE_1d1ec400":"Tiempo de descompresión agotado","TXT_CODE_1d39feca":"La versión independiente de Geyser del archivo de configuración del software del servidor tiene configuraciones básicas de parámetros del servidor (como puerto, número máximo de jugadores, etc.) y también puede establecer parámetros detallados del servidor (caché de bloques, número de subprocesos, etc.)","TXT_CODE_1d67c9c6":"Límite en el número de inicios de sesión con la misma IP","TXT_CODE_1d7a8617":"El radio de protección del punto de generación se determina aplicando 2x 1 a este valor. Establecerlo en 0 solo protegerá el bloque debajo del punto de generación.","TXT_CODE_1d8746ed":"Establecido en verdadero para reparar el encantamiento para reparar siempre el equipo más dañado primero","TXT_CODE_1d8f3c33":"Error de red","TXT_CODE_1d9d0746":"ID de usuario","TXT_CODE_1dc0000f":"El mensaje de ActionBar que aparece cuando un jugador intenta dormir, pero el jugador de SleepingCentagege Gamerule se establece en un valor superior a 100. Establece en \'predeterminado\' para permitir que los clientes usen sus propios componentes traducibles. \\nEstablezca en una cadena vacía para deshabilitarla.","TXT_CODE_1dc16497":"Tasa máxima de envío de bloques del jugador","TXT_CODE_1deaa2dd":"Usuarios","TXT_CODE_1df9fbd5":"Importar","TXT_CODE_1e03347e":"Puerto de acceso externo: {{- host}}-> puerto de contenedor interno: {{- contenedor}} / protocol: {{- protocol}}","TXT_CODE_1e08ca6b":"Semillas de fortaleza","TXT_CODE_1e0b63b6":"archivo en blanco","TXT_CODE_1e1dfbbe":"Diferentes tipos conducirán a diferentes funciones. Si no hay un tipo requerido, puede elegir un tipo general más abstracto, como Java Universal Edition Server.","TXT_CODE_1e58bb5e":"Acuerdo de usuario final de Minecraft (EULA)","TXT_CODE_1e9c479e":"No","TXT_CODE_1ed0031c":"Rango de activación de la entidad de agua","TXT_CODE_1eea2726":"Hace que los brazos sean visibles cuando se colocan","TXT_CODE_1efc7c5f":"Archivo de configuración común de un servidor Neoforge","TXT_CODE_1f2062c7":"Requerido, de 9 a 36 caracteres, debe contener letras mayúsculas y minúsculas y números.","TXT_CODE_1f224bef":"Si se debe deshabilitar el guardado de estadísticas","TXT_CODE_1f246be3":"Altura mínima:","TXT_CODE_1f2d95eb":"Establezca en falso para usar las opciones <mob> .ridable-in-water en lugar de la etiqueta desmontos_underwater","TXT_CODE_1f3aac40":"Desactiva el lado del cliente de DFU optimizado: ya está deshabilitado en servidores","TXT_CODE_1f600912":"Debería ignorarse el daño mientras está en lava si se habilita el daño-if a la huella","TXT_CODE_1f61e5a3":"Editar archivo original","TXT_CODE_1f62022c":"Te permite cambiar el color del shulker haciendo clic derecho con un tinte","TXT_CODE_1f991d":"La cantidad de daño a dar si se habilita el daño-if a la huella","TXT_CODE_1fbf74d9":"Si obligar al jugador a ser teletransportado al servidor predeterminado cada vez que ingresa al servidor","TXT_CODE_1fc10e3b":"Aplicar listas blancas en el servidor","TXT_CODE_1fe2257b":"Realizar verificación de nombre de usuario","TXT_CODE_1fec78cc":"Establezca esto en verdadero para verificar el cuadro delimitador de colisión de toda la entidad para escaleras en lugar de solo el bloque en el que se encuentran. Causa diferencias notables en la mecánica, por lo que el valor predeterminado es el comportamiento de vainilla. \\nPredeterminado: falso.","TXT_CODE_20053f37":"Multiplicador de otoño de bloque para cama gris claro","TXT_CODE_201bc643":"sin protección","TXT_CODE_2029027e":"¡La configuración del puerto abierto de este contenedor es incorrecta y no hay valores en los lados izquierdo y derecho del separador!","TXT_CODE_2033383b":"Retraso entre olas. \\nCuanto menor sea el valor, más criaturas habrá.","TXT_CODE_2038ec2c":"¡Seleccione al menos un perfil!","TXT_CODE_20509fa0":"Lista de nodos remotos","TXT_CODE_2054155a":"La altura máxima a la que los jugadores colocan bloques en el servidor.","TXT_CODE_206f0c11":"Permitir que los jugadores se registren no necesariamente coincide con el nombre de su personaje.","TXT_CODE_2076e91e":"Espectaculo","TXT_CODE_2082f659":"Nota: Si está vacío, los archivos en la administración de archivos no estarán vinculados al contenedor.","TXT_CODE_2093cc1a":"Historial de compras","TXT_CODE_20bf7fdd":"La ecuación de salud máxima utilizada para calcular la salud máxima","TXT_CODE_20ce2aae":"Construcción fallida","TXT_CODE_20cec54":"símbolo de avance de línea de retorno de carro","TXT_CODE_20d107f1":"o fiel a hacer la configuración máxima de los bócalos por huella en papel.yml se usará por segundo en lugar de por tick","TXT_CODE_20e4ab72":"Establecer en falso para evitar que el duelo","TXT_CODE_21077dc4":"Establezca cuánto daño hace una bola de nieve (-1 hará daño 3 por incendios","TXT_CODE_21b8b71a":"Los permisos normales son adecuados para usuarios empresariales y los permisos más altos son adecuados para administradores.","TXT_CODE_2203d4ff":"Todos los métodos de procesamiento de paquetes.","TXT_CODE_221bf389":"Si se deben enviar instrucciones de enfriamiento falsas.","TXT_CODE_2222777e":"No existe en la dirección URL ni en la configuración de inicialización.","TXT_CODE_22510c5c":"Iniciar sesión cuenta","TXT_CODE_2266908":"Deja un sendero donde camina un muñeco de nieve cuando se monta","TXT_CODE_226b6c9e":"Habilite eventos de intrusión interminables","TXT_CODE_22b2a206":"Tiempos de desconexión","TXT_CODE_22b5f37d":"La cantidad de fuentes necesarias para tener lava infinita","TXT_CODE_22c68314":"Establecer en True si esta mafia siempre debe dejar caer la época","TXT_CODE_22cf9c9d":"Especifique aquí el tiempo de espera de lectura para la conexión. \\nEl valor predeterminado es 30 segundos.","TXT_CODE_2313aab2":"Si se habilitan las respuestas a las consultas de GameSpy 4.","TXT_CODE_23178d7d":"Límite en la cantidad de entidades guardadas por bloque","TXT_CODE_233624ad":"Puerto de acceso a la página web, complete números puros, el puerto predeterminado es el puerto 23333.","TXT_CODE_233dd4f8":"Cuánto tiempo retrasar la regeneración de salud","TXT_CODE_235cd293":"Especifica qué cadena debe usarse como parte inicial del comando. \\nSi la longitud es mayor que 1, es posible que no funcione correctamente.","TXT_CODE_236f70aa":"Ajustes de usuario","TXT_CODE_2374966e":"Cambiar el formato del chat en el juego: {0} = nombre del grupo, {1} = prefijo del grupo, {2} = nombre del jugador, {3} = sufijo del grupo, {4} = mensaje de chat.","TXT_CODE_2375f010":"Reinstalar","TXT_CODE_238c4c01":"Establecido en True For Snow Golems para evitar el Gamérulo de duelo de la mafia","TXT_CODE_2393baa2":"piedra redonda","TXT_CODE_23a3bd72":"anormal","TXT_CODE_23b02a65":"Configuración del protocolo de consulta de estado de instancia","TXT_CODE_240252a":"Reenvía el recuento de jugadores del servidor remoto y el recuento máximo de jugadores a los jugadores de Bedrock Edition.","TXT_CODE_2415440f":"Al aplicar encantamientos que sean incompatibles, en lugar de usar el encantamiento en el elemento base, el encantamiento será reemplazado por el encantamiento en el elemento secundario.","TXT_CODE_2418225f":"Para fines estadísticos, no cambie ni elimine","TXT_CODE_2428b9c0":"El gradiente de <Ext> cuando el modo relleno es \'bajo\'","TXT_CODE_2432f4cc":"Asegúrese de que el código de activación sea válido y coincida con las especificaciones del plan de instancia.","TXT_CODE_243a463":"Puerto de acceso al servidor","TXT_CODE_2452016e":"Copie manualmente el siguiente contenido.","TXT_CODE_2471b9c":"Buscar por nombre de usuario","TXT_CODE_247f6613":"Establecido en falso para que los clérigos no arrojen a la verruga inferior a otros aldeanos","TXT_CODE_24843187":"Prefijo de chat grupal de superadministrador","TXT_CODE_24873a8a":"Página de inicio de sesión","TXT_CODE_2493e6fc":"Usar control de permisos","TXT_CODE_2498e4ed":"Mejor monitoreo del estado del servidor","TXT_CODE_249df6f2":"La cantidad máxima de abejas permitidas dentro de una colmena/bee_nest","TXT_CODE_24c2172c":"Hace que esta mafia sea inmune al oído (rango de activación de la entidad - ver Spigot.yml)","TXT_CODE_24c4768a":"Puede descargar la fuente de datos del mercado de aplicaciones, modificarla y cargarlo a cualquier servidor para agregar su propio Modpack al mercado.","TXT_CODE_24e5bff2":"condición","TXT_CODE_25023ad0":"Permite que el jugador elimine la maldición de la armadura de unión cuando tenga un efecto de debilidad aplicado a ellos","TXT_CODE_2541ce4d":"¿Cuánto tiempo debería ser el retraso de una gran gotea hasta que se derrumbe por completo?","TXT_CODE_255606fb":"Cuánto tiempo conservar las copias de seguridad en minutos","TXT_CODE_25699fea":"Archivo de configuración de la herramienta de control del servidor MCDReforged","TXT_CODE_256e5825":"Docker debe instalarse por adelantado. \\nLuego, use cualquier imagen que haya encontrado en DockerHub para crear, instalar e iniciar la instancia.","TXT_CODE_25924d5a":"ticks máximos manejados por la entidad","TXT_CODE_25af3af3":"Contraseña de acceso RCON","TXT_CODE_25cb04bb":"Guardado en el portapapeles","TXT_CODE_260d96a0":"Si se establece en verdadero, los elementos entregados al jugador se insertarán directamente en su inventario. \\nDe lo contrario, los objetos entregados al jugador se generarán como objetos caídos. \\nCaracterística experimental, es posible que no funcione correctamente o provoque la pérdida de elementos","TXT_CODE_26407d1f":"Reportar un error","TXT_CODE_2645196f":"Velocidad máxima de procesamiento de paquetes","TXT_CODE_26495d02":"Puede completar el comando de inicio, como java -jar demo.jar. Si no completa el comando de inicio, prevalecerá el comando definido dentro de la imagen.","TXT_CODE_266b7246":"Despliegue rápido de Minecraft","TXT_CODE_2695488c":"Por favor ingrese el nombre de usuario","TXT_CODE_26d7316f":"¡La tarea de descompresión falló!","TXT_CODE_2728d0d4":"asistente de comando","TXT_CODE_273d24e0":"inicio automático","TXT_CODE_2759226f":"tasa de crecimiento de la caña de azúcar","TXT_CODE_27594db8":"Mercado","TXT_CODE_2764f197":"Por favor complete el formulario completamente","TXT_CODE_276756b2":"¿Estás seguro de que deseas realizar esta acción?","TXT_CODE_2793b84":"Deshabilitar la verificación de asfixia por teletransporte","TXT_CODE_2799a1dd":"Cree rápidamente instancias de aplicaciones","TXT_CODE_27b7102a":"Sin permiso para ejecutar el símbolo del sistema","TXT_CODE_27ecd5c9":"Generar retraso - ticks","TXT_CODE_27ee6bf8":"El gradiente de <Ext> cuando el uso de RAM es \'bueno\'","TXT_CODE_27efac3b":"Editado con éxito","TXT_CODE_27efff22":"Tasa de crecimiento de la vid de cueva","TXT_CODE_27f641c1":"semillas de la selva","TXT_CODE_27fd08b9":"Multiplicador de agotamiento del valor del hambre para otras actividades","TXT_CODE_28013340":"Establecer en falso para evitar que los fluidos funcionen.","TXT_CODE_28116f29":"Servidor Minecraft Edición Bedrock","TXT_CODE_28124988":"Directorio raíz del programa","TXT_CODE_2818a7bc":"cancelar completo","TXT_CODE_28190dbc":"Eliminar con éxito","TXT_CODE_281c9d37":"Si se debe registrar el contenido del error en el archivo de registro","TXT_CODE_282b0721":"Configuración del protocolo Steam Rcon","TXT_CODE_28357e8b":"Floodgate utiliza cifrado para garantizar el uso de fuentes autorizadas. \\nEsto debería apuntar a la clave pública generada por Floodgate (BungeeCord, Spigot o Velocity)","TXT_CODE_2841f4a":"Por favor seleccione el formato del archivo comprimido","TXT_CODE_2864bfbc":"Ir a gestión de archivos de instancia","TXT_CODE_2880eed4":"contraseña RCON","TXT_CODE_288830f4":"La cantidad de segundos que el jugador debe esperar antes de reaparecer. \\nRango válido: 0 (predeterminado) a 15 segundos. \\nÚselo bajo su propio riesgo","TXT_CODE_28bf8a1b":"Ya sea para habilitar los horarios","TXT_CODE_28bfb02":"Si este agente envía un cliente con un ISP/AS diferente al servidor de autenticación de Mojang, el jugador será expulsado.","TXT_CODE_28ce635a":"Aún no hay música","TXT_CODE_28e53fed":"Administrar nodos remotos","TXT_CODE_2908dac":"Nombre del archivo de permisos personalizados","TXT_CODE_2930907c":"Número máximo de bloques almacenados automáticamente por tick","TXT_CODE_2931127f":"El archivo de configuración global del software del servidor PaperSpigot puede configurar aún más parámetros avanzados y configuraciones de juego más específicas, lo que tiene un gran efecto decisivo en el rendimiento general.","TXT_CODE_2958a0f8":"Felicitaciones, la instancia se creó exitosamente.","TXT_CODE_29b7eca5":"Ignorar entidades de audiencia","TXT_CODE_2a07bba3":"Inicio - cada jugador","TXT_CODE_2a1fc6cc":"Establezca el número de puerto para el acceso remoto RCON","TXT_CODE_2a22c2ff":"Sin permiso de portapapeles, revise la configuración del navegador","TXT_CODE_2a2dfc09":"Los jugadores del modo creativo son inmunes a los ataques fantasmas","TXT_CODE_2a34c50a":"Idioma","TXT_CODE_2a370f1c":"Establecer en True para permitir la rotura de losas individuales en un bloque de losa doble mientras se escabulle","TXT_CODE_2a379a13":"Opcional, complete según sea necesario según su programa de inicio, como: -server -XXX -ZZZ, etc.","TXT_CODE_2a3b0c17":"confirmación final","TXT_CODE_2a4f13d4":"Muestra el radio de la cabeza personalizada en bloques alrededor del jugador.","TXT_CODE_2a82b720":"Porcentaje de posibilidades (0.0 - 1.0) Una entidad generará zurdos","TXT_CODE_2a84466d":"Número máximo de guardados automáticos de jugadores por tick","TXT_CODE_2a8dc13f":"Se utiliza para ver el estado de todos los nodos remotos conectados al panel.","TXT_CODE_2ab036a4":"Por favor ingresa el puerto del servidor del juego","TXT_CODE_2ab3e9fd":"Implementar cualquier aplicación de consola","TXT_CODE_2abeb185":"La modificación del idioma aquí modificará simultáneamente los idiomas de todos los nodos y de todos los usuarios.","TXT_CODE_2ad9f3a0":"Qué tamaño debe tener un paquete de datos de Minecraft antes de comprimirlo. \\nConfigurarlo en cero comprimirá todos los paquetes, configurarlo en -1 deshabilitará la compresión por completo.","TXT_CODE_2af87548":"Tutte le versioni","TXT_CODE_2b221e02":"Una vez habilitada, la instancia se ejecutará en un entorno \\"sandbox\\" y la mayoría de las operaciones no afectarán la seguridad del host.","TXT_CODE_2b524bbf":"Establecer en True para cada gamemode para requerir su propio permiso","TXT_CODE_2b5fd76e":"Se ha emitido el comando de apertura","TXT_CODE_2b9e9b5":"Restringir contenedores para que se ejecuten en núcleos de CPU específicos","TXT_CODE_2ba4bf6f":"El registro SQL volverá al registro de texto después de que la inserción de registros falle varias veces.","TXT_CODE_2bcc4e34":"Se guardará automáticamente después de cargar","TXT_CODE_2be83d36":"Excepción del programa de descompresión y compresión. Asegúrese de que el archivo que desea procesar exista y sea legal. ¡Inténtelo nuevamente más tarde!","TXT_CODE_2bfc02ef":"Nombre del protocolo del servidor de reenvío (por ejemplo, BungeeCord [X.X], Paper 1.X).","TXT_CODE_2c1337d":"Lista de etiquetas para esta instancia","TXT_CODE_2c194599":"Si se debe emitir un anuncio al guardar","TXT_CODE_2c19f3b2":"La cantidad en la que este efecto afecta a las entidades","TXT_CODE_2c41a36d":"La MTU máxima admitida por Internet es 1492, pero esto puede causar problemas de fragmentación de paquetes.","TXT_CODE_2c4d586f":"Las mazmorras y fortalezas subterráneas aún se generan después de desactivar las estructuras generadas (como las aldeas) al generar el mundo.","TXT_CODE_2c69ab15":"desconectar","TXT_CODE_2c7bcdfa":"1. Esta página es accesible para todos y puedes colocar tarjetas con cualquier permiso.","TXT_CODE_2c9083a1":"Seleccionar instancia","TXT_CODE_2ca42b39":"Mostrar texto especificado, compatible con la sintaxis de Markdown","TXT_CODE_2ce63943":"La ventana temprana comienza a maximizar","TXT_CODE_2ce953da":"Perfil desconocido","TXT_CODE_2cf59872":"Abrir página","TXT_CODE_2cfbaa90":"Los aldeanos de radio buscan golems de hierro existentes antes de generar más. \\nValor de 0 Desactiva las características","TXT_CODE_2d542e4c":"Nombre de la tarea","TXT_CODE_2d8a400":"Categoría Secundaria (Tipo de Versión)","TXT_CODE_2db37427":"Intervalo de procesamiento de paquetes PlaceRecipePacket","TXT_CODE_2dbd3cd3":"Ingrese a la consola del comerciante","TXT_CODE_2dc23f7a":"Seleccionar codificación de descompresión","TXT_CODE_2de4c590":"Salida del marcador de posición <day> en comando.uptime.format opción","TXT_CODE_2de92a5d":"¡Seleccione un nodo antes de instalar!","TXT_CODE_2debc7ae":"Modo extremo (bloqueado automáticamente después de la muerte)","TXT_CODE_2e0e1dfa":"Sentry DSN para un registro de errores mejorado, deje en blanco para deshabilitar","TXT_CODE_2e4469f6":"Puertos de conexión disponibles:","TXT_CODE_2e5d3d0f":"Owner","TXT_CODE_2e660675":"Una lista de entidades para ignorar la activación","TXT_CODE_2ea7af21":"¿Qué es Docker? \\n¿Por qué es necesario?","TXT_CODE_2ee6fd18":"Al acceder al panel desde","TXT_CODE_2efcbf1e":"Codificación de Salida","TXT_CODE_2f07d608":"El intervalo después del intento de conexión más reciente del cliente antes de permitir otra conexión","TXT_CODE_2f09a53c":"Se dirige a MC-163962 donde la demanda de los aldeanos disminuye indefinidamente. \\nPaper agrega un parche para solucionar esto al evitar que la demanda suba por debajo de cero. \\nEsta opción permite que la demanda mínima sea configurable.","TXT_CODE_2f291d8b":"tipo de instancia","TXT_CODE_2f59807a":"Dirección del servidor","TXT_CODE_2f87036a":"Escala de la mafia","TXT_CODE_2f900008":"Semilla inferior","TXT_CODE_2fa46b8c":"El archivo de imagen se está descargando, espere pacientemente. \\nNombre de la imágen:","TXT_CODE_2fb14927":"Este error generalmente significa que la página web no puede conectarse directamente al proceso backend. \\nSi tiene reenvío de puertos, mapeo o proxy inverso, verifique la configuración.","TXT_CODE_2fb7e284":"Si BungeeCord habilita el modo en línea","TXT_CODE_2fe0cc84":"Por favor seleccione un día de la semana","TXT_CODE_2fe6e00e":"Si el jugador está atrapado dentro de un portal sin forma de salir, caminar hacia otro bloque restablecerá el retrownsown del portal, lo que les permitirá teletransportarme a través del portal","TXT_CODE_30051f9b":"ID de instancia:","TXT_CODE_300c2ff4":"Clave de nodo remoto","TXT_CODE_30258325":"directorio de contenedores","TXT_CODE_3036d123":"Si se debe corregir la posición del jugador del cliente a la posición del jugador del servidor cuando el valor de movimiento excede el umbral","TXT_CODE_30aa5133":"Dirección IP del servidor Java","TXT_CODE_30fcc19a":"Usuario <<operator_name>> modificado la configuración de la instancia <<instance_name>>","TXT_CODE_30fe1717":"Opcional, por ejemplo 0,1,2,3","TXT_CODE_31145b04":"Vuelto a intentar {reintentos}/{maxrcrecries}","TXT_CODE_311b2d6b":"Debilitar a los mobs generados por los generadores.","TXT_CODE_312cd9f0":"Método de procesamiento de paquetes PlaceRecipePacket","TXT_CODE_313db7d2":"semillas fósiles","TXT_CODE_314aa817":"Reenviar el nombre de host utilizado por el cliente Bedrock Edition para conectarse al servidor Java","TXT_CODE_317e0cc1":"Otros alcances de seguimiento","TXT_CODE_3183c301":"Probabilidad de impacto de rayo","TXT_CODE_31a1d824":"Ajustes avanzados","TXT_CODE_31a48870":"L\'utente <<operator_name>> ha tentato l\'accesso, risultato: <<login_result>>","TXT_CODE_31c10b14":"Establecido en verdadero para el efecto de la poción de resistencia al fuego para mostrar partículas","TXT_CODE_31c5a4d0":"Carcasa web","TXT_CODE_31edf78":"Establecer en falso para evitar que los cerditos zombificados dejen caer XP si un jugador los enojó (pero no lo mataron)","TXT_CODE_320f4304":"Directorio de archivos del servidor","TXT_CODE_3243b4f8":"Cofre del guardián Piglin","TXT_CODE_3247f016":"La cantidad de fuentes necesarias para tener agua infinita","TXT_CODE_328191e":"Es adecuado para situaciones en las que el host tiene varias tarjetas de red y varias direcciones IP. Si solo tiene una IP pública, no configure este elemento.","TXT_CODE_329fb904":"Descomprimir en una nueva carpeta","TXT_CODE_32bf92a1":"¿Cuántos NPC puede generar la estatua dentro de los 600 píxeles antes de dejar de aparecer? \\nValor predeterminado 6","TXT_CODE_32cd41d5":"Descargando archivo...","TXT_CODE_32d87bf1":"La mayoría de los servidores de juegos Steam requieren el protocolo RCON para admitir la ejecución de comandos y también admiten el servidor de juegos Minecraft. Si descubre que la consola integrada no puede ejecutar comandos cuando ejecuta el servidor de juegos Steam, puede intentar configurar el protocolo RCON para que sea compatible. Se ejecuta el comando.","TXT_CODE_32eb350b":"Si esta configuración es verdadera, el servidor se ejecutará más rápido después de un retraso","TXT_CODE_3354b56e":"Si se deben grabar los comandos ingresados ​​por el jugador en la consola (solo se graban los comandos de BungeeCord)","TXT_CODE_335ba209":"Seleccione Archivo","TXT_CODE_3362d4b7":"Crear imagen","TXT_CODE_3371000d":"El panel ha sido instalado y no se puede reinstalar.","TXT_CODE_3378e8a5":"¿Cuál debería mostrar el número máximo de jugadores? \\n(Velocity no admite la cantidad máxima de jugadores en línea).","TXT_CODE_337da349":"Hora de inicio - días","TXT_CODE_33a09033":"Número de personas en línea:","TXT_CODE_33c223c":"Ignorar la verificación para ver si el jugador \\"puede\\" actualizar el proyectil","TXT_CODE_33ce1c5c":"Pasar variables de entorno al contenedor.","TXT_CODE_33d91ef6":"Si los libros deben ser escritos o no.","TXT_CODE_34071701":"Experimente el radio de fusión de la esfera","TXT_CODE_3407250a":"Monte el directorio de la instancia del host en el contenedor para la persistencia de los datos","TXT_CODE_34100777":"Establecer en falso para evitar que el aldeano muestre el elemento comercial","TXT_CODE_34148d2b":"Establecer en True para que los efectos de las partículas sean menos intrusivos en la pantalla","TXT_CODE_341bc7f3":"Atributo de escala","TXT_CODE_341dfd11":"Altura temprana de la ventana","TXT_CODE_342a04a9":"En mantenimiento","TXT_CODE_342d5959":"El daño de la saliva del delfín","TXT_CODE_34611898":"Puesta en marcha","TXT_CODE_347ff81c":"Permitir que los jugadores usen clientes potenciales en comerciantes errantes","TXT_CODE_3489786b":"Use nodos de permiso para determinar el número de filas. \\nPor defecto, con esta configuración habilitada, todos los jugadores tienen seis filas a menos que se especifique lo contrario con permisos.","TXT_CODE_348c9098":"No se pudieron obtener los detalles de la instancia especificada. ¡Inténtelo de nuevo!","TXT_CODE_34999278":"El intervalo en las garrapatas para verificar si el aldeano está lobotomizado","TXT_CODE_349edc57":"Por favor seleccione una hora","TXT_CODE_3502273d":"Agregar nueva tarea programada","TXT_CODE_351aaf7":"Empezar","TXT_CODE_354409b6":"Advertencia de sobrecarga del servidor","TXT_CODE_3549ea82":"Cantidad máxima de garrapatas de intervalo que se disparan","TXT_CODE_3554dac0":"tiempo de activación","TXT_CODE_3579ab7d":"Permite aplicar encantamientos en herramientas o armaduras que normalmente no son aplicables. \\nPor ejemplo, nitidez en un pico.","TXT_CODE_35d2ee7a":"Usando 7zip para descomprimir al directorio especificado: {{command}}","TXT_CODE_35d52619":"La posibilidad de florecer azalea se convierte en árboles naturalmente","TXT_CODE_361a79c6":"¡La descarga de imágenes se ha detenido!","TXT_CODE_36417656":"Ir a la consola de la instancia","TXT_CODE_365aabd4":"símbolo de nueva línea","TXT_CODE_36622cee":"Establecido en verdad para dar visión nocturna a los jinetes mientras está en un ridículo","TXT_CODE_366bad15":"Por favor ingrese el nombre del archivo comprimido","TXT_CODE_369a4a22":"Reserva de plazas. \\nNúmero de espacios reservados a los que los jugadores reservados pueden unirse si superan el número máximo de espacios de servidor","TXT_CODE_36b878dc":"Intervalo de procesamiento de paquetes","TXT_CODE_36cae384":"Estás utilizando una dirección IP privada","TXT_CODE_3725b37b":"Ctrl C ha sido enviado!","TXT_CODE_372e7b9c":"Haga clic en \\"Imagen\\" para explorar plantillas en la categoría actual, clic en \\"Instalar\\" para editar información de plantilla, y clic en \\"Edición Masiva\\" para eliminar elementos.","TXT_CODE_372e97f4":"Cuando el mundo está en modo difícil, se permite que la corrupción se propague","TXT_CODE_3752d436":"Salida del marcador de posición <Hora> en Command.uptime.Format Opción","TXT_CODE_37658aab":"El valor modificador de los proyectiles de bola de nieve","TXT_CODE_377a62dc":"Establecido en verdadero para colocar el fuego cuando explota el cristal final","TXT_CODE_377e142":"Se inicia la tarea de compresión de archivos. Si hay demasiados archivos, llevará algún tiempo.","TXT_CODE_377e5535":"Por favor ingrese un nombre de carpeta","TXT_CODE_3790ec90":"Ya sea para enviar directivas de espacio de nombres","TXT_CODE_37924654":"Por favor vuelva a ingresar la nueva contraseña","TXT_CODE_37931fa9":"Atributo de dureza de armadura","TXT_CODE_379fa48a":"Seleccionado","TXT_CODE_37a4c14a":"No se encuentra ningún archivo de configuración disponible","TXT_CODE_37d67b69":"Cantidad máxima de TNT por tick","TXT_CODE_37d839a4":"¡El programa de descompresión/compresión no pudo iniciarse! \\n¡Asegúrese de que los archivos en el directorio daemon/lib existan y tengan los permisos correctos! \\nSi aún no funciona, reinstale el panel.","TXT_CODE_37f5901":"Tasa de crecimiento de la remolacha","TXT_CODE_38091a03":"Los zombis son hostiles a los aldeanos.","TXT_CODE_3816e0d9":"Establecer en falso para evitar que el enderman duelo.","TXT_CODE_381f8f22":"Lista de productos","TXT_CODE_382ec256":"La cantidad mínima de garrapatas para elegir al azar cuando se cura","TXT_CODE_384d278f":"Usuario <<operator_name>> eliminó el proceso de demonio <<daemon_id>>","TXT_CODE_3855e22f":"Si no se pasan parámetros al comando ban, el bloqueo de IP se cancela","TXT_CODE_38591f72":"punto de tiempo específico","TXT_CODE_386f2d66":"El comando ha sido enviado, pero no hay respuesta. Verifica en el juego.","TXT_CODE_3897eb89":"Número máximo de bloques cargados simultáneamente por un jugador","TXT_CODE_38a430d8":"Seleccione el modo de red para el acceso al contenedor, como puente puente","TXT_CODE_38fb23a8":"Descarga iniciada...","TXT_CODE_393c816c":"La página no existe","TXT_CODE_3969cb6b":"Establecer automáticamente la distancia de envío","TXT_CODE_397667ff":"Registre los eventos de muerte de los aldeanos en el registro.","TXT_CODE_39994770":"jugador","TXT_CODE_39a3ba38":"semillas de pueblo","TXT_CODE_39abde23":"Tasa de crecimiento de algas","TXT_CODE_39ac8ed3":"simple","TXT_CODE_39bb14c1":"Mensaje que muestra cuándo se patean un jugador por tener un nombre de usuario no verificado (el usuario está en modo fuera de línea). \\nConfiguración como \'predeterminado\' Muestra el mensaje predeterminado \'¡no puede verificar el nombre de usuario!\'","TXT_CODE_39c5229e":"Editar información del nodo","TXT_CODE_39e7fa63":"Permitir que las lijadoras excedan el límite de pila","TXT_CODE_3a056dc8":"Los nombres de usuario están disponibles en cualquier idioma. Mantenga su contraseña segura.","TXT_CODE_3a24c7a3":"El radio efectivo del conducto por cada siete bloques en el marco","TXT_CODE_3a302f23":"Manual de usuario","TXT_CODE_3a3f9a57":"Un archivo de configuración muy importante para el servidor Minecraft Bedrock. Casi la mayoría de las configuraciones comunes (puertos, número de personas, distancia de visión, etc.) se editan en este archivo.","TXT_CODE_3a406403":"Consulta de estado","TXT_CODE_3a51d817":"La cantidad de oscuridad en el cielo (5 es lo suficientemente oscura para tormentas eléctricas, pero no lluvia regular)","TXT_CODE_3a5b3d2d":"Contraseña de la base de datos MySQL","TXT_CODE_3a5c9779":"Establecer esto en verdadero lo hace para que lapislazuli pueda permanecer en la ranura de mesa encantadora, para que pueda dejar su lapis lazuli en la mesa","TXT_CODE_3a818e91":"Volver a la lista de imágenes","TXT_CODE_3a8fdbf1":"Evita que las tierras de cultivo se pisoteen si se coloca una cerca o una pared de adoquines directamente debajo de ella","TXT_CODE_3aa9f36":"El nombre del archivo comprimido o descomprimido contiene caracteres incorrectos. ¡Cambie el nombre del archivo!","TXT_CODE_3ae0276b":"Ingrese la contraseña de acceso al protocolo RCON del servidor de juegos, que generalmente se encuentra en el archivo de configuración.","TXT_CODE_3aec94fb":"Descompresión de archivo ZIP falló. Posibles razones:\\n1. Archivo corrupto o protegido con contraseña\\n2. Si es un archivo multi-volumen (zip+z01+z02, etc.), necesita habilitar soporte 7zip\\n3. Formato de archivo incorrecto\\nVerifique el archivo o contacte al administrador para habilitar funcionalidad 7zip.","TXT_CODE_3b1bb444":"minuto","TXT_CODE_3b1cc020":"Cancelar","TXT_CODE_3b24a247":"Haga clic en el botón Guardar en la esquina superior derecha para guardar el diseño.","TXT_CODE_3b346a65":"¿Debería aplicarse la protección de zona a las cajas?","TXT_CODE_3b4260f8":"¿Cuántos NPC puede generar una estatua antes de que deje de aparecer? \\nValor predeterminado 10.","TXT_CODE_3b4b656d":"Acerca de","TXT_CODE_3ba5ad":"Autenticacion de usuario","TXT_CODE_3bb646e4":"Por favor seleccione","TXT_CODE_3bdd7af8":"Seleccione la codificación de salida","TXT_CODE_3be23278":"Si la explosión puede causar fuego o no","TXT_CODE_3beb6e5c":"Establezca cuánto tiempo se marca el ciclo de luz del día","TXT_CODE_3bfb9e04":"¡La instancia de destino no existe!","TXT_CODE_3c37583b":"El directorio bajo la función de administración de archivos se montará en este directorio en el contenedor.","TXT_CODE_3c8fd4c2":"Apodo","TXT_CODE_3c93920b":"Los usuarios normales pueden usar la función de reinstalación","TXT_CODE_3ccb26e":"Edición comunitaria","TXT_CODE_3d046b93":"Controla si las coordenadas se muestran al jugador.","TXT_CODE_3d07fa74":"Evita que el enderman sea inmune a los proyectiles","TXT_CODE_3d0885c0":"plataforma","TXT_CODE_3d09f0ac":"Crear imagen","TXT_CODE_3d14442a":"Utilice DockerFile para personalizar cualquier imagen del entorno; se recomienda que el personal técnico lo haga","TXT_CODE_3d45d8d":"Agregar Plantilla","TXT_CODE_3d4e1594":"PlaceRecipePacket tasa máxima de procesamiento de paquetes","TXT_CODE_3d56da34":"Autor/Proveedor de Plantilla","TXT_CODE_3d602459":"Estado de la instancia","TXT_CODE_3d68e43b":"Error del código de verificación de dos pasos","TXT_CODE_3d7fbe30":"Servidor de juegos Steam","TXT_CODE_3d94ea16":"El socket del nodo es anormal, intente volver a conectarse en la administración del nodo.","TXT_CODE_3da5e4e":"Si permitir que los efectos de la baliza se activen cuando está cubierto por vidrio teñido","TXT_CODE_3dbf8890":"Altura máxima a la que esta mafia puede volar mientras se monta","TXT_CODE_3dd66d98":"nueva pestaña","TXT_CODE_3dee9250":"Establecido en True para los huevos de tortuga para evitar el Gamérulo de duelo de la mafia","TXT_CODE_3df4beaf":"Si se debe utilizar la optimización de envío y recepción de paquetes para la plataforma Linux [solo Linux]","TXT_CODE_3e252bc9":"El tamaño de la intrusión","TXT_CODE_3e4e61b3":"Establecer en True For Phantoms para disparar llamas en Swoop","TXT_CODE_3e68ca00":"Ruta de montaje adicional","TXT_CODE_3e724e40":"Ajustes del movimiento del bebé zombie.","TXT_CODE_3e83082b":"Permitir el uso de señalización dentro de las áreas de protección del renacimiento.","TXT_CODE_3e93e31e":"Se utiliza cuando se comparte un puerto de conexión; normalmente no se requiere configuración aquí","TXT_CODE_3e959ce7":"Las tareas de compresión/descompresión se están ejecutando...","TXT_CODE_3e98e22f":"El número de intentos fallidos de inicio de sesión de un jugador. Si excede el número, el jugador será expulsado directamente.","TXT_CODE_3eb58633":"Se puede utilizar para la funcionalidad de reinicio automático después de un fallo.","TXT_CODE_3ecee271":"Estas etiquetas seleccionables se calculan a partir de la lista de instancias de la página actual y no incluyen todas las etiquetas existentes. Aquí se muestran un máximo de 30.","TXT_CODE_3ed96265":"marco flotante","TXT_CODE_3ee20639":"Canje exitoso, recuerde lo siguiente","TXT_CODE_3ef08433":"Establecer en True para registrar los comandos Minecraft no utilizados/ocultos. \\nLos siguientes comandos están disponibles (junto con su Minecraft.command. <Command_Name> contraparte de permiso): DebugConfig, ServerPack, Spawn_armor_trims, Warden_spawn_Tracker, DebugMobspawning, Debugpath y Raid. \\nEsta lista puede o no estar incompleta dependiendo de si se eliminan o las nuevas se agregan en versiones más nuevas de Minecraft.","TXT_CODE_3efe364e":"red","TXT_CODE_3f227bcf":"Habilite el modo comercial para conectarse a la consola MCSManager para personalizar paquetes y vender códigos","TXT_CODE_3f3e734b":"Permitir elementos prohibidos Permite que los grupos de la lista generen elementos prohibidos incluso si PreventBannedItemSpawn está configurado en verdadero","TXT_CODE_3f470950":"La salud máxima que puede tener un jugador antes de mejorar el equipo.","TXT_CODE_3f477ec":"La longitud sólo puede ser de 3 a 20 caracteres.","TXT_CODE_3f59b48":"El porcentaje de daño un ataque crítico se suma al daño base","TXT_CODE_3f5a2028":"Si los generadores de monstruos personalizados utilizan tipos de dimensiones","TXT_CODE_3f65b1f2":"Establecer en falso para tener leche clara solo efectos de estado negativos","TXT_CODE_3f678132":"Rango inicial de monstruos","TXT_CODE_3f739f9c":"Desactivar el modo difícil","TXT_CODE_3f810f66":"Desactivado por defecto (0), la cantidad de garrapatas una entidad vivirá antes de desaparecer. \\nInteractuar con un jugador restablece el temporizador","TXT_CODE_3f828072":"alcanzar el número máximo de reintentos","TXT_CODE_3f99f17f":"Versión de nodo remoto","TXT_CODE_3fce7ccb":"Mostrar el estado de la instancia, siempre que el usuario tenga permiso para ingresar a la instancia.","TXT_CODE_3fd222b0":"Por favor, presione rápidamente Ctrl C nuevamente para entrar en vigencia ...","TXT_CODE_3fe97dcc":"Ajustes del sistema","TXT_CODE_400a4210":"Introduzca el código:","TXT_CODE_402018ce":"Categoría","TXT_CODE_40241d8e":"Adquisición de estado de Minecraft","TXT_CODE_405cd346":"Interfaz API de solicitud entre dominios","TXT_CODE_405d1f28":"Nivel de permiso OP (1-4)","TXT_CODE_40a87804":"Subir archivo HTML","TXT_CODE_40c2c2ee":"El intervalo entre copias de seguridad en minutos. \\nLas copias de seguridad se almacenan en la carpeta tshock/backups","TXT_CODE_40c4894a":"Habilite el soporte de inicio rápido de TCP en el agente. \\nRequiere que el agente se ejecute en Linux.","TXT_CODE_40ca4f2":"renovar","TXT_CODE_40ee4eaf":"producir paralelismo","TXT_CODE_4126fc53":"Si el comando BossBar desde el comando /Compass debe mostrarse al sostener una brújula","TXT_CODE_413b9c01":"Versión del entorno de nodo","TXT_CODE_41406a5f":"tarjeta de datos","TXT_CODE_4140aa4b":"Suprimir los errores donde SetBlock se detectó en un trozo lejano","TXT_CODE_41813325":"Si el desove de la mafia asíncrono o no debe estar habilitado o no.","TXT_CODE_41ae3d88":"Establecer en True para hacerlo para que pueda crear portales con obsidiana llorando","TXT_CODE_41d79430":"Adecuado para el entorno operativo del servidor MC Bedrock Edition u otros programas Linux","TXT_CODE_41dd4d19":"Página web oficial","TXT_CODE_41f86ac":"Usuario <<operator_name>> eliminó la tarea <<task_name>> de la instancia <<instance_name>>","TXT_CODE_42036f92":"------Evento de inicio de sesión de usuario ------","TXT_CODE_42a7759b":"El sufijo que aparece en la lista de jugadores después del nombre de alguien cuando son AFK","TXT_CODE_42bcfe0c":"Error al inicializar la consola. Actualice la página web e inténtelo de nuevo.","TXT_CODE_42e25bc2":"Establecer esto en falso permite la manipulación RNG. \\nManipulación de RNG de parches de papel mediante el uso de una fuente aleatoria compartida (y bloqueada). \\nEsto viene con una ganancia de rendimiento, pero los jugadores técnicos pueden preferir esto para apagar la capacidad de manipular RNG.","TXT_CODE_4306a0d0":"Verificación en línea (genuina)","TXT_CODE_43248597":"pegar","TXT_CODE_432cbc38":"Seleccionado:","TXT_CODE_432cfb62":"Aún no hay perfil","TXT_CODE_43422ed3":"ruta de java","TXT_CODE_434786c9":"Después de cargar una imagen de fondo, el panel se configurará con un tema oscuro, borroso y translúcido, y podrás volver a cambiarlo en cualquier momento.","TXT_CODE_435f4975":"Utilice imágenes de Docker Hub","TXT_CODE_438aa1":"Nombre de Imagen","TXT_CODE_43984628":"Tasa de crecimiento de las verrugas inferiores","TXT_CODE_43df9305":"Operación desconocida","TXT_CODE_43eedf83":"En que nivel de luz quemarán los fantasmas","TXT_CODE_43fcaf94":"Successo","TXT_CODE_442c0649":"La edad máxima de crecimiento que la planta puede crecer","TXT_CODE_443ac54f":"Habilite o deshabilite las comprobaciones de alcance anti-trampas según la distancia entre el jugador y la ubicación de su ficha.","TXT_CODE_44454300":"Máxima experiencia combinada","TXT_CODE_444db70f":"Cargar software de servidor único","TXT_CODE_447a9fc4":"Ruta de registro","TXT_CODE_448d08eb":"Establecido en True para imponer restricciones de teletransporte en los portales finales. \\nEsto transmite el evento EntityTelePorthinderedEvent que da la capacidad de volver a intentar los teletransportes si fallan debido a que los pasajeros/ser vehículos","TXT_CODE_448df2bd":"Se requiere contraseña para unirse al servidor","TXT_CODE_449d1581":"Codificación de entrada y salida.","TXT_CODE_449efd26":"Desactive el reproductor si esta cantidad de paquetes HealOtherPlayer se envían en 1 segundo","TXT_CODE_44a472a5":"Directivas desactivadas","TXT_CODE_44ae0e7":"¡Se te ocurre un buen nombre!","TXT_CODE_44c67809":"Omita versiones GL específicas, puede ayudar con los controladores de la tarjeta gráfica de buggy","TXT_CODE_44f46508":"Bloquear multiplicador de otoño para cama verde","TXT_CODE_450481c5":"No se puede obtener una vista previa de esta tarjeta al agregarla. Complete la tarjeta de parámetro correspondiente después de agregarla para que funcione normalmente.","TXT_CODE_451f9968":"Confinando a los piglins zombies a través de portales inferiores","TXT_CODE_45364559":"Por favor ingrese el enlace URL","TXT_CODE_458c34db":"Enlace de ejemplo","TXT_CODE_458df26d":"Si se debe deshabilitar el guardado del perfil del jugador","TXT_CODE_45d7b982":"No se pudo solicitar detalles del plan. \\n¡Vuelva a intentarlo más tarde!","TXT_CODE_45e8f121":"Etiquetas Adicionales (Opcional)","TXT_CODE_4600deb7":"cualquier programa de consola","TXT_CODE_46039f9b":"Seleccione una plataforma de ejecución","TXT_CODE_461d1a01":"Buscar por nombre de nodo","TXT_CODE_462ba96":"UUID de este servidor, no lo modifiques","TXT_CODE_463375d2":"Acerca de esta página","TXT_CODE_46410888":"Si los fantasmas evitan a los jugadores con una antorcha en la mano","TXT_CODE_46ba576a":"Establecer en falso para no permitir que los estandos armados se muevan","TXT_CODE_46bb965":"Crear un servidor de juegos Steam","TXT_CODE_46c4169b":"separar","TXT_CODE_46c48969":"Parece que está intentando utilizar HTTPS, pero no podemos conectarnos al demonio mediante el protocolo WSS. \\nIntente conectarse al demonio utilizando el protocolo WSS://.","TXT_CODE_46c4e9ac":"escribir","TXT_CODE_46cb40d5":"Conviértete en patrocinador","TXT_CODE_46f575ae":"Finalmente comienza:","TXT_CODE_47071ef6":"Velocidad de desaparición de flecha","TXT_CODE_47129a5b":"Si no se completa, la dirección local localhost se utilizará automáticamente.","TXT_CODE_47203b64":"Todos los sistemas","TXT_CODE_4745436a":"Los aldeanos serán tentados por los bloques esmeraldas y seguirán a los jugadores que los sostienen","TXT_CODE_47491a7e":"¿Qué color debe mostrar cuando el modo de relleno es \'medio\'?","TXT_CODE_475c5890":"Por ejemplo: mi primer servidor","TXT_CODE_47667d86":"Permita que las orejas de deadmau5 de terceros sean visibles.","TXT_CODE_4770de17":"Información del comerciante","TXT_CODE_477ece61":"instalación completa","TXT_CODE_478717e2":"Este es el mensaje que se transmite cuando un usuario se va AFK (debe tener un juego de tiempo de jugador de juego mayor que 0","TXT_CODE_479389a":"Permitir que los jugadores usen códigos de color en las señales","TXT_CODE_47b5a2f7":"Imagen de logo","TXT_CODE_47c35915":"Diseño guardado","TXT_CODE_47c62dac":"Usa imágenes","TXT_CODE_47d09eea":"Pestaña completa","TXT_CODE_47d56d0d":"¡Falló la actualización de la instancia! \\nRazón:","TXT_CODE_47dcfa5":"Reanudar","TXT_CODE_47dd244a":"Velocidad de crecimiento de la flor de la antorcha","TXT_CODE_47e182a5":"Construcción completada","TXT_CODE_47e21c80":"Complete los parámetros básicos antes de cargar el archivo.","TXT_CODE_48044fc2":"Si la fuente del paquete de compresión es China continental, generalmente se selecciona GBK;","TXT_CODE_4822a21":"Se ha emitido una orden de cierre","TXT_CODE_48261ab7":"Tarjeta de información del comerciante","TXT_CODE_483d379":"La duración de las ubicaciones del servidor y del cliente puede no estar sincronizada (deshabilitada cuando la opción de movimiento autoritativo del servidor es falsa)","TXT_CODE_485e2d41":"Tiempos restantes","TXT_CODE_4880ef77":"Archivo de configuración mundial del software del servidor PaperSpigot, que se puede configurar aún más por mundo","TXT_CODE_48c286cc":"Usuario <<operator_name>> detuvo la instancia <<instance_name>>","TXT_CODE_48c291c1":"Las asignaciones remotas no están disponibles. Esto puede deberse a un backend del panel desactualizado.","TXT_CODE_4908e15b":"Si se debe forzar al cliente a cargar todos los paquetes de recursos.","TXT_CODE_495027e1":"Construyendo una imagen de entorno Ubuntu 22.04","TXT_CODE_497568db":"Configura cómo se conecta directamente el nodo cuando el usuario accede al panel desde diferentes endpoints, útil cuando el nodo está detrás de un proxy inverso.","TXT_CODE_498cd5c5":"Haga clic en el botón Cerrar para cancelar la carga.","TXT_CODE_49981cb9":"Elija cómo implementar la instancia de su aplicación.","TXT_CODE_49ab8e74":"Atributo de armadura","TXT_CODE_49c040e1":"Ya sea para intercambiar elementos de la mano secundaria y de la mano principal al realizar cualquier gesto.","TXT_CODE_49c48e0a":"El mensaje de ActionBar que aparece cuando un jugador está dormido. \\nEstablezca en \'predeterminado\' para permitir que los clientes usen sus propios componentes traducibles. \\nEstablezca en una cadena vacía para deshabilitarla. \\nMarcadores de posición disponibles: <conta> - La cantidad actual de jugadores durmiendo, <total> - la cantidad total de jugadores necesarios para dormir","TXT_CODE_4a37ec9c":"La cantidad de páginas web conectadas a esta consola, lo que puede afectar el ancho y alto de su consola.","TXT_CODE_4a56836d":"Configurar lista de imágenes","TXT_CODE_4a570d32":"Asegúrese de que esta imagen exista y de que tenga una etiqueta y otra información. Esta imagen se extraerá automáticamente antes de ejecutar la instancia.","TXT_CODE_4a6bf8c6":"Puerto de conexión del nodo remoto","TXT_CODE_4a70853b":"Si el costo acumulativo debe aplicarse cuando se usa un artículo en un yunque","TXT_CODE_4a95255b":"rango de seguimiento de animales","TXT_CODE_4a9822f":"Si las bolas de nieve, cuando se arrojan, deben extinguir fogatas","TXT_CODE_4aaec75c":"Tipo de solicitud incorrecto, ¡inténtelo de nuevo!","TXT_CODE_4ab6a0b5":"tiempo del navegador","TXT_CODE_4aba9745":"Si se debe expulsar al jugador cuando el jugador excede el umbral de TileKill","TXT_CODE_4ad9f75d":"Probabilidad de ocurrencia","TXT_CODE_4b1d5199":"Admite cualquier idioma para completar información de comentarios relevantes","TXT_CODE_4b20289c":"Si se debe habilitar la escritura en bloque síncrona","TXT_CODE_4b39143b":"El nombre del Soperwner","TXT_CODE_4b610194":"Habilitar la generación de bloques del lado del cliente","TXT_CODE_4b6e951":"aporte","TXT_CODE_4b7eba50":"Nodos en línea/nodos totales","TXT_CODE_4b971ef4":"Hace que el enderman despoje incluso si está sosteniendo un bloque","TXT_CODE_4bbd3fde":"Avance de la construcción","TXT_CODE_4bedec2a":"Todos los nodos","TXT_CODE_4bf8a52f":"Precio de Referencia","TXT_CODE_4bf93cf1":"¿Se debería obligar a los agentes a implementar nuevos estándares de seguridad de clave pública? \\nDe forma predeterminada, esta opción está activada.","TXT_CODE_4c0fda9":"Intente comenzar la instancia una vez para generar un archivo de configuración. \\nSi todavía parece vacío, es posible que este tipo de servidor de juego no sea compatible.","TXT_CODE_4c38bb42":"La barra de hambre para saltar y correr está agotada.","TXT_CODE_4c55b6c7":"Intenta generar un animal cada Tick. Un valor de 400 significa que el servidor intentará generar un animal cada 400 Ticks. Un valor inferior a 0 se restablecerá al valor predeterminado de Minecraft.","TXT_CODE_4c566219":"Permite a los jugadores usar etiquetas de minimas en un yunque.","TXT_CODE_4c714a4f":"¡El servidor está desactualizado! \\nLa versión actual es {0}","TXT_CODE_4c72565d":"Nombre de usuario no encontrado, ¿crear una nueva cuenta?","TXT_CODE_4c82f760":"Suprimir las advertencias sobre los intentos de cargar una receta no reconocida","TXT_CODE_4c841d3":"Tasa de crecimiento de hongos","TXT_CODE_4c9dd2b4":"Multiplicador de otoño de bloque para bloque de heno","TXT_CODE_4ca9e35f":"esqueleto","TXT_CODE_4ccdd3a0":"consola","TXT_CODE_4cef8979":"Puerto del servidor (es posible que esta opción no funcione si el servidor tiene configuraciones más avanzadas)","TXT_CODE_4d00c085":"Habilite la compatibilidad con el canal de mensajes del complemento BungeeCord en Velocity.","TXT_CODE_4d124f78":"Si se debe habilitar la consulta UDP","TXT_CODE_4d36128b":"Buscar actualizaciones","TXT_CODE_4d3b4548":"Porcentaje de posibilidades (0.0 - 1.0) Una endermita aparecerá después de teletransportarse usando una perla ender","TXT_CODE_4d50f316":"3. Una vez completado el diseño, puede acceder a él directamente utilizando el estado de inicio de sesión.","TXT_CODE_4d5432bd":"Porcentaje de posibilidades (0.0 - 1.0) Un caballo zombie generará en lugar de un caballo esqueleto (desove natural durante las tormentas eléctricas)","TXT_CODE_4d571cda":"Metadatos de elementos ocultos","TXT_CODE_4d6b06f0":"Chino simplificado (GBK)","TXT_CODE_4d81a657":"Avance","TXT_CODE_4d8e959e":"Le permite establecer una lista de comandos de consola que se ejecutarán cuando el servidor se inicie. \\nÚtil para los propietarios de servidores que no tienen acceso a su consola.","TXT_CODE_4d934e3a":"Asignar recursos","TXT_CODE_4d993ca4":"marco","TXT_CODE_4dab643d":"dificultad","TXT_CODE_4df7e9bd":"nombre de host","TXT_CODE_4e2c7f64":"Hora","TXT_CODE_4e4b52a0":"Este proceso de instalación puede tardar unos minutos. Asegúrese de que la red esté abierta. ¿Quiere continuar?","TXT_CODE_4e4d9680":"Nombre completo de la imagen","TXT_CODE_4e627613":"Error de ejecución de esta tarjeta. Actualice la página web e inténtelo nuevamente.","TXT_CODE_4e810102":"Por favor ingrese el comando de inicio","TXT_CODE_4ea93630":"Por favor ingresa el contenido","TXT_CODE_4ec4f7bb":"¡Seleccione un nodo disponible!","TXT_CODE_4eccdde8":"¡Configuración construida con éxito!","TXT_CODE_4ed501a1":"Reenvía el MOTD del servidor remoto a los reproductores Bedrock Edition.","TXT_CODE_4ef3f800":"Para comerciantes: comuníquese con https://redeem.mcsmanager.com o consulte el aviso del sitio web para obtener ayuda.","TXT_CODE_4ef6b040":"interrumpido","TXT_CODE_4efba567":"parámetros adicionales","TXT_CODE_4f0b822b":"¿Cuánto tiempo en milisegundos intentará BungeeCord hacer ping al servidor para obtener la cantidad de jugadores antes de cancelar la conexión?","TXT_CODE_4f21b52":"Mensaje que muestra cuando alguien intenta montar una mafia que no están permitidos.","TXT_CODE_4f225afd":"Solo para el tipo de verificación en modo en línea. \\nGuarda una lista de reproductores Bedrock Edition cuyas cuentas Java deben guardarse después de iniciar sesión.","TXT_CODE_4f2f381b":"Hace que el nombre sea visible cuando se usa una etiqueta de nombre en un soporte de armadura","TXT_CODE_4f34fc28":"Aplicar configuración de instancia","TXT_CODE_4f387c5a":"Después de configurar el comando de actualización, puede encontrar la operación de actualización en el botón de instancia de cambio. Después de hacer clic, el comando escrito aquí se ejecutará en el host (o en Docker).","TXT_CODE_4f57868":"MC Géiser","TXT_CODE_4f64db47":"Hace controlable esta mafia","TXT_CODE_4f6a2959":"Espere hasta que se complete la carga del archivo actual.","TXT_CODE_4f6c39d3":"Por favor ingrese una nueva contraseña","TXT_CODE_4f917a65":"Límites de recursos:","TXT_CODE_4fb30d0a":"La compensación de proyectil de un huevo","TXT_CODE_4fb3fad1":"Error durante la descompresión","TXT_CODE_4fb66c81":"Si se destruyen más de esta cantidad de fichas en 1 segundo, bloquea al jugador y reanuda sus acciones.","TXT_CODE_4fd13f18":"Esta configuración es aplicable al software del servidor del grupo BungeeCord. Sin embargo, dado que este archivo de configuración es ligeramente complejo, la mayoría de las configuraciones solo se pueden modificar de manera sencilla. Se recomienda utilizar la función de administración de archivos en línea para editar este archivo.","TXT_CODE_4fdbb351":"Entorno de tiempo de ejecución Java 16 integrado, adecuado para el servidor Minecraft versión 1.17","TXT_CODE_4fe284cd":"Squir?","TXT_CODE_4fe5dce5":"Ir a la página del nodo","TXT_CODE_4ff6a125":"Se agregó un recordatorio cuando el servidor está lleno.","TXT_CODE_4ffdc91d":"Se recibió la señal {{señal}} del sistema, intentando cerrar todas las instancias ...","TXT_CODE_50075e02":"Puede haber un retraso y la eliminación del archivo llevará algún tiempo","TXT_CODE_5020d183":"Permite cambiar el modificador de la oportunidad de engendra de Piglin desde un bloque de portal en función de la dificultad mundial.","TXT_CODE_5024d817":"Se debe crear el directorio /workspace y se montará automáticamente en el directorio raíz del archivo de la instancia.","TXT_CODE_504b84d9":"Habilite el registro de conexiones de jugadores.","TXT_CODE_50511e8f":"Nivel de permiso de jugador predeterminado (invitado: visitante | miembro: miembro | administrador: operador","TXT_CODE_50697989":"Utilice la dirección de host remoto y la consulta difusa para agregar ejemplos de aplicaciones para este usuario","TXT_CODE_509d7d9a":"El archivo de configuración de Spigot puede controlar aún más el comportamiento del servidor y parámetros específicos. Algunas restricciones más avanzadas se encuentran en este archivo de configuración.","TXT_CODE_50a2b2d9":"Al mismo tiempo, esta opción también afectará al usuario en el contenedor Docker de la instancia. \\nSi no sabe lo que esto significa, no lo modifique.","TXT_CODE_50aa56a1":"Permite el uso de directivas/timings. \\nSe utiliza para medir el tiempo que el complemento dedica a los eventos.","TXT_CODE_50d471b2":"reiniciar","TXT_CODE_50daec4":"Red","TXT_CODE_510bd294":"Solo admite formato ZIP. Después de cargarlo, el paquete comprimido se descomprimirá automáticamente en el \\"Directorio de archivos\\".","TXT_CODE_5112fcb2":"Forja MC","TXT_CODE_511aea70":"Permisos","TXT_CODE_51289627":"¿Se ha completado la instalación?","TXT_CODE_5143c584":"Mecanismo de protección para evitar la creación de mensajes personalizados con mensajes de muerte.","TXT_CODE_514e064a":"IP de unión del panel","TXT_CODE_518528d0":"Salta","TXT_CODE_51a1fffb":"Filtrar","TXT_CODE_51bb7e9f":"Comando desconocido. \\nEscribe \\"/ayuda\\" para obtener ayuda.","TXT_CODE_51df891f":"rastro ruinas semillas","TXT_CODE_51ff8e5b":"Establecer en verdadero para deshabilitar el comando /dar de soltar elementos en el piso cuando el inventario de un jugador está lleno","TXT_CODE_5206cf41":"Configuracion basica","TXT_CODE_5207688f":"Perfil de permisos de la herramienta de control del servidor MCDReforged","TXT_CODE_5245bd11":"Por favor complete el contenido del formulario","TXT_CODE_524e3036":"consola","TXT_CODE_525e6e18":"Eula ha sido aceptado con éxito. \\nInstancia de inicio ...","TXT_CODE_5275cb62":"El número de tics comienza cuando el jugador sufre de insomnio.","TXT_CODE_528753e7":"Dado que Minecraft u otros programas requieren entornos operativos específicos, como Java/Python/.NET, etc., es muy complicado instalar y administrar diferentes versiones en la misma máquina. El uso de diferentes imágenes de entorno puede administrar fácilmente diferentes versiones y diferentes tipos. entornos de servicio.","TXT_CODE_52b31aef":"Inicia sesión donde los jugadores cierran sesión según su IP. \\nSe borrará después de que se reinicie el servidor.","TXT_CODE_52ba5942":"tarjeta completa","TXT_CODE_52bc24ec":"Confirmar carga","TXT_CODE_52c8a730":"permitir","TXT_CODE_52eff9c3":"Nivel de permiso OP (1-4)","TXT_CODE_52f96ff0":"El gradiente de <Ext> cuando el modo relleno es \'bueno\'","TXT_CODE_53046822":"Limitar el uso de CPU (porcentaje)","TXT_CODE_530f5951":"Vista","TXT_CODE_5338b335":"tasa de crecimiento de la sandía","TXT_CODE_53408064":"Crear aplicación","TXT_CODE_53499d7":"Crear plantilla en blanco","TXT_CODE_534db0b2":"puerto de conexión del host","TXT_CODE_5366af54":"Salir del trabajo por lotes","TXT_CODE_53745cc0":"El número total de instancias que le asignaron los administradores.","TXT_CODE_53761955":"Mensaje que muestra cuándo la pantalla de demostración está habilitada para un usuario utilizando el comando /demo.","TXT_CODE_537cd5ad":"Volver a la lista de perfiles","TXT_CODE_53aec8c6":"Marque la recolección de basura entre cada bloque grande","TXT_CODE_53d04392":"Si las bolas de nieve, cuando se arrojan, deben extinguir los incendios","TXT_CODE_53dd82fc":"Comando de Detención","TXT_CODE_53e8e5af":"El mensaje de muerte que aparece cuando el jugador es asesinado porque estaba corriendo con tijeras","TXT_CODE_5415f009":"Sin contenido, seleccione el nodo en el cuadro desplegable en la esquina superior derecha o haga clic en Crear aplicación","TXT_CODE_54275b9c":"Editor de Plantillas","TXT_CODE_54312194":"Dirección y puerto","TXT_CODE_543356c1":"Lista de bloques que se pueden convertir en una ruta de césped cuando se hagan clic derecho con una pala","TXT_CODE_5445f34b":"e altri {num}","TXT_CODE_54469e02":"No hay registros de operación disponibles todavía","TXT_CODE_5476e012":"estado de funcionamiento","TXT_CODE_5484094a":"Cambiar el directorio de trabajo del contenedor","TXT_CODE_55015f30":"Directorios de Montaje Adicionales (Opcional)","TXT_CODE_551b0348":"contraseña","TXT_CODE_553c6ed2":"Establecido en verdad para que lo haga para que se pueda hacer una punzada.","TXT_CODE_5544ec22":"Consultar el avance de la construcción.","TXT_CODE_555b3625":"Semilla de mansión forestal","TXT_CODE_555e2c1b":"Ingrese el comando y presione Enter para enviarlo. Use las teclas arriba y abajo para seleccionar comandos históricos.","TXT_CODE_5564bc4c":"Usuario <<operator_name>> modificado la configuración del usuario","TXT_CODE_559f4b1d":"Suprimir las advertencias sobre los complementos que inicializan la API del material heredado","TXT_CODE_55a62de":"Permite la colocación de agua al final.","TXT_CODE_55ade942":"Utilizado por los administradores para ver los datos del servidor.","TXT_CODE_55b1f20e":"El usuario no pudo activar la instancia:","TXT_CODE_55c91a9b":"Establecido en verdadero para habilitar el daño al escabullirse","TXT_CODE_55e91545":"Proveedor de ventanas temprano","TXT_CODE_55edf44d":"La tarea de imágenes ha comenzado.","TXT_CODE_56197d09":"Deja que los calamares floten sobre el agua","TXT_CODE_5635dd6b":"Establecido en verdadero para habilitar el daño al caminar con botas encantadas con Frost-Walker","TXT_CODE_56516e92":"Configuraciones ocultas","TXT_CODE_56b9e6af":"Por defecto, McSmanager asigna 5 puertos secuencialmente para cada instancia, lo que respalda el uso de {MCSM_PORT1} a {MCSM_PORT5} como números de puerto agregados secuencialmente.","TXT_CODE_56c42793":"El prefijo que aparece en la lista de jugadores antes del nombre de alguien cuando son AFK","TXT_CODE_56c686f8":"Fallito","TXT_CODE_56ff18c1":"Visualización de información del servidor. Si utiliza programas complementarios como ColorMotd, puede dejar esta opción en blanco.","TXT_CODE_57245e94":"encender","TXT_CODE_57358a8b":"Establecer en True for Boats para expulsar a los jugadores cuando están en tierra","TXT_CODE_57417f60":"Si se debe expulsar a los jugadores cuando superen el umbral de MaxDamage","TXT_CODE_574ed474":"Características en línea","TXT_CODE_57674047":"Comando ejecutado al hacer clic en \\"Actualizar\\"","TXT_CODE_5778848e":"No se puede abrir el archivo","TXT_CODE_57a3aae":"Mensaje que muestra cuándo se ejecuta el comando /tiempo de inicio.","TXT_CODE_57c09778":"Establecer en True For Creepers para evitar el Gamérulo de duelo de la mafia","TXT_CODE_57c1b0a3":"Opcional, parámetro -Xms, como: 1024M","TXT_CODE_57cd2d04":"Puede deberse a que la red no está disponible o el servidor está en mantenimiento. Espere un momento antes de volver a intentarlo o intente utilizar otros kits de instalación.","TXT_CODE_57d1929e":"MCSManager utilizará el protocolo Minecraft Ping para intentar obtener la cantidad de personas en línea en el servidor, la versión, la latencia y otra información.","TXT_CODE_57d76ece":"Lista de bloqueo de reemplazo","TXT_CODE_57e86edb":"Las instancias que asigne incluyen algunas instancias que no tienen habilitada la \\"Protección de contenedor\\". MCSManager no podrá controlar el comportamiento de este usuario. El usuario asignado puede cargar malware para invadir su host a través de estas instancias. El usuario es alguien en quien usted confía.\\n\\n\\nLos nombres de las instancias con riesgos de seguridad son los siguientes:","TXT_CODE_584af0ab":"Desactiva los efectos de la poción de invisibilidad.","TXT_CODE_584d786d":"Eliminar la instancia y los archivos relacionados.","TXT_CODE_58508fb7":"Nombre del archivo del software del servidor","TXT_CODE_58939ea7":"Si generar animales","TXT_CODE_589e091c":"Añadir uno nuevo","TXT_CODE_58a55f17":"Il file {name} esiste già in questa cartella","TXT_CODE_58aa8491":"Requieren que los shulkers tengan su tapa abierta para desovar desde Bullet","TXT_CODE_58e4a9bd":"Usuario <<operator_name>> cargó el archivo {{archivo}} a la instancia <<instance_name>>","TXT_CODE_592eff33":"Guardar en panel","TXT_CODE_5936d79":"Establecer en True para proyectiles para evitar el Gamérulo de duelo de la mafia","TXT_CODE_593ee330":"memoria","TXT_CODE_595efd06":"Crear Nuevo","TXT_CODE_5962e188":"Última Versión","TXT_CODE_5974bf24":"administrar","TXT_CODE_597c11cc":"¿En qué nivel de dificultad se romperá la cáscara?","TXT_CODE_598f2d02":"El gradiente de <Ext> cuando el uso de RAM es \'bajo\'","TXT_CODE_59917c84":"Permite que las capas de terceros sean visibles.","TXT_CODE_59976e2c":"Establecido en True para imponer restricciones de teletransporte en las puertas de enlace. \\nEsto transmite el evento EntityTelePorthinderedEvent que da la capacidad de volver a intentar los teletransportes si fallan debido a que los pasajeros/ser vehículos","TXT_CODE_59a76359":"Utilice el caché para almacenar los colores del mapa","TXT_CODE_59ab3364":"Tasa de descarga","TXT_CODE_59ac0239":"Agregar nueva imagen","TXT_CODE_59b1cb55":"Permite pistones sin cabeza","TXT_CODE_59c0c994":"Subiendo a otros casos","TXT_CODE_59c39e03":"MCSManager Redemption Center le ayudará en su plan de negocios","TXT_CODE_59cb16ff":"Por favor ingrese el nombre del archivo","TXT_CODE_59cdbec3":"Descripción","TXT_CODE_59f7c3a2":"Porcentaje de posibilidades (0.0 - 1.0) Un zombie o un esqueleto aparecerá con una calabaza Jack O \'Lantern/tallada en su cabeza","TXT_CODE_5a196078":"marco de fotos de desplazamiento","TXT_CODE_5a280280":"Cargue permisos.yml antes del complemento","TXT_CODE_5a408a5e":"Comercio","TXT_CODE_5a56ccca":"Permite métodos de autenticación basados ​​en contraseña a través de Geyser. \\nSólo útil en modo online.","TXT_CODE_5a6463fb":"Soporte de armadura grabado","TXT_CODE_5a74975b":"Crear una instancia","TXT_CODE_5a936b7f":"Expandir","TXT_CODE_5aa330f0":"Establecido en falso para el efecto de resistencia al fuego para no mostrar su icono","TXT_CODE_5ab1eb7d":"Cambia estilo","TXT_CODE_5ab2062d":"último comienzo","TXT_CODE_5af5838a":"Transmite los mensajes de avance en el chat solo con el jugador afectado","TXT_CODE_5b0e93b5":"La instalación no se puede iniciar porque hay otras tareas asincrónicas en progreso. \\n¡Primero finalice otras tareas en la página del terminal!","TXT_CODE_5b190bc4":"Con qué frecuencia (en minutos) REST solicita que el depósito se reduzca en 1. \\nEl valor mínimo es 1 minuto.","TXT_CODE_5b2daea0":"Si no sucede nada cuando ingresa un comando y presiona Enter, puede intentar ajustar esta opción.","TXT_CODE_5b323a2":"La cantidad máxima de jugadores que toda la instancia de BungeeCord puede aceptar. El valor predeterminado es -1, lo que significa que no hay límite para la cantidad de jugadores.","TXT_CODE_5b5d6f04":"Cancelar guardar diseño","TXT_CODE_5b60ad00":"Utilice la cuenta MCSManager del servidor para ingresar al panel","TXT_CODE_5b6f3691":"Archivo de configuración del servidor de un servidor Neoforge","TXT_CODE_5b719d7b":"Establecido en verdadero para permitir el sueño incluso si hay turbas cerca","TXT_CODE_5b990e2e":"Renombrado exitosamente","TXT_CODE_5bb8f14":"Generar criaturas atacantes (monstruos)","TXT_CODE_5bba3e38":"Radio dentro del cual los aldeanos buscan adquirir POI.","TXT_CODE_5bc16b9a":"Sufijo de chat grupal de superadministrador","TXT_CODE_5bdaf23d":"Consola de nodo","TXT_CODE_5be6c38e":"Tipo predeterminado","TXT_CODE_5bf41818":"Sovrascrivi","TXT_CODE_5c3ba572":"Si desactivar a los depredadores","TXT_CODE_5c43374f":"Preferencia de uso de memoria virtual","TXT_CODE_5c54f599":"alguien","TXT_CODE_5cb656b9":"trabajo por lotes","TXT_CODE_5cd3b4bd":"artículo","TXT_CODE_5ce5085c":"Codificación de Entrada","TXT_CODE_5d033431":"Lista de bloqueo oculto anti-perspectiva","TXT_CODE_5d41afbf":"Establecido en verdad para tener un 100% de posibilidades de domesticar una mafia","TXT_CODE_5d488270":"Asegura que los alivios respeten al NBT de los elementos que recogen. \\nSi agrega encantamientos almacenados a la lista para respetar, entonces si le da a una espada de alivio con un encantamiento, solo recogerá espadas con los mismos encantamientos.","TXT_CODE_5d563196":"La barra de hambre para saltar y caminar está agotada.","TXT_CODE_5d589988":"Permite que los cofres se abran incluso con un bloque sólido en la parte superior","TXT_CODE_5db4e96b":"Altura ampliada (la altura más alta en la misma página es la altura final)","TXT_CODE_5ddb00f2":"Usuario <<operator_name>> creó la tarea <<task_name>> para la instancia <<instance_name>>","TXT_CODE_5ddf3123":"Establecer en True para deshabilitar los relojes Observador","TXT_CODE_5deeefb5":"Se creará la instancia, ¿quieres continuar?","TXT_CODE_5def0cbe":"seguridad","TXT_CODE_5e10537a":"Cambiar plantilla de instancia","TXT_CODE_5e4a370d":"modo oscuro","TXT_CODE_5e4c9793":"Cantidad de garrapatas para retrasar el sonido; \\nLa opción Burp-When-Full debe estar habilitada","TXT_CODE_5e56a7a5":"La velocidad en la que un caldero debajo de una piedra de goteo puntiaguda que tiene agua colocada por encima de él se llena de agua (depende de la garrapata aleatoria)","TXT_CODE_5e6e46bb":"Daño máximo que un jugador/NPC puede causar","TXT_CODE_5e9022f8":"Siguiente","TXT_CODE_5ead1240":"Comenzar Edición","TXT_CODE_5eb49cd":"Establecer en True para hacer que las lores de Te persistan después de romperse (ex. Los cabezas de los jugadores personalizados con la tradición retendrán su tradición)","TXT_CODE_5ebec0db":"Tarjeta de página de expansión","TXT_CODE_5ec10cc8":"Esta tarjeta no se puede obtener una vista previa en el modo de diseño.","TXT_CODE_5ef2cf20":"La identidad se autentica a través de la clave generada por el nodo remoto para garantizar la seguridad del trabajo de integración de múltiples máquinas.","TXT_CODE_5f0eafe5":"Radio del efecto de sonido de la muerte del dragón ender","TXT_CODE_5f1ae9ca":"Establecer en True para permitir que los clientes soliciten el recuento de abejas de las colmenas utilizando paquetes de carga útil personalizados.","TXT_CODE_5f23008":"Razón dada al expulsar a un jugador que intenta unirse cuando el servidor está lleno y no hay espacios reservados disponibles","TXT_CODE_5f282a51":"¿En qué nivel de dificultad el espíritu maligno romperá la puerta?","TXT_CODE_5f2d2e30":"ID de nodo:","TXT_CODE_5f42b528":"Tipo de autenticación del servidor. \\nPuede estar fuera de línea, en línea o en compuerta.","TXT_CODE_5fed0011":"Habilite el paso de ping LEGACY. \\nNo es necesario habilitar esta opción a menos que su MOTD o el recuento de jugadores no se muestren correctamente.","TXT_CODE_6032f5a3":"De 9 a 36 caracteres, debe contener letras mayúsculas, minúsculas y números.","TXT_CODE_603cbc35":"¿Se aplica la protección de zona a las cerraduras con gemas de diamantes?","TXT_CODE_604d3041":"Cuánta compresión se debe realizar (de 0 a 9). \\nEl valor predeterminado es -1, utilizando el nivel predeterminado 6.","TXT_CODE_604d8d63":"Límites de contenedor","TXT_CODE_606da66a":"Rango de activación animal","TXT_CODE_6071bd0b":"Información solicitada por el cliente del juego después de cerrar el servidor","TXT_CODE_60752a40":"Seleccione un idioma","TXT_CODE_60a11735":"Arreglar las reglas de escalada para evitar las restricciones de aglomeración","TXT_CODE_60dd05d5":"Anular el directorio de trabajo de imagen predeterminado con el directorio de almacenamiento de datos","TXT_CODE_60e3c342":"Nombre del servidor. \\nSi UseServerName es verdadero, el nombre mundial se reemplaza durante la sesión.","TXT_CODE_615be555":"Velocidad de desaparición del tridente","TXT_CODE_61700077":"Establecer en True para que esta mafia comience a recibir daño del agua","TXT_CODE_617701dc":"Si expulsar a los jugadores cuando superan el umbral de TilePlace","TXT_CODE_617ce69c":"advertir","TXT_CODE_61811ac":"Carga útil de la tarea","TXT_CODE_61834192":"Comando de Actualización (Opcional)","TXT_CODE_619d74d3":"Como java -jar server.jar, cmd.exe, etc.","TXT_CODE_619faab6":"Si el estado de la instancia cambia al estado de no ejecución sin operación del panel, la operación de inicio de la instancia se iniciará inmediatamente.","TXT_CODE_61a8296e":"Habilitar contenedores Docker","TXT_CODE_61b6facb":"Usuario <<operator_name>> eliminó la instancia <<instance_name>>","TXT_CODE_61ca492b":"Por ejemplo:","TXT_CODE_61dd421d":"Establecer el número máximo de milisegundos gastados por Tick","TXT_CODE_61eae8a6":"Autenticación de dos factores (2FA)","TXT_CODE_62051fcc":"Carga falló","TXT_CODE_6215388a":"nuevo directorio","TXT_CODE_6239c6b6":"Aún no hay página web","TXT_CODE_6253ecce":"Bloquear multiplicador de otoño para cama azul claro","TXT_CODE_6259357c":"¡El programa debe ejecutarse durante más de 6 segundos antes de que se pueda forzar su detención!","TXT_CODE_6265ae47":"Fuente de datos del mercado de aplicaciones","TXT_CODE_628f6851":"se acabó el tiempo","TXT_CODE_62c62825":"Si se deben registrar instrucciones en el registro","TXT_CODE_62c88f3a":"Tasa de crecimiento de la vid llorona","TXT_CODE_62dbf117":"Intenta generar un monstruo con cada Tick, igual que arriba","TXT_CODE_633415e2":"Por favor rellene el formulario correctamente","TXT_CODE_6345aa71":"Archivo HTML:","TXT_CODE_6353e235":"El valor SHA-1 del paquete de recursos debe estar en hexadecimal en minúsculas, no es una opción obligatoria.","TXT_CODE_635d051":"Aún no hay fotos","TXT_CODE_638bca20":"Se ha emitido orden de eliminación","TXT_CODE_63a4602e":"Tasa de guardado automático del jugador","TXT_CODE_63ccbf90":"Nivel de permiso","TXT_CODE_6420023d":"Número de reinicios automáticos: ","TXT_CODE_64282335":"Deshabilitar registros de actualizaciones de planta","TXT_CODE_645bc545":"Crea una nueva instancia","TXT_CODE_645da993":"Configuración de Docker","TXT_CODE_647ea2ec":"¿Está seguro de que desea borrar todas las instancias seleccionadas?","TXT_CODE_64bf4386":"Si el nodo remoto se inicia automáticamente al inicio, se puede utilizar para iniciar automáticamente la instancia al inicio.","TXT_CODE_6514e191":"Este perfil es común a servidores de la categoría Spigot u otras categorías derivadas.","TXT_CODE_6526494a":"Establecido en verdadero para dejar de pisotear si las entidades caen a una distancia igual a su nivel de caída de plumas, además del bloqueo adicional necesario para pisotear en primer lugar. \\nLa caída de la pluma 1 requiere que caigas más de 3 cuadras para pisotear. \\nFF 2 requiere 4, etc.","TXT_CODE_6546b287":"Utiliza una versión de texto simple del nombre de la pantalla del reproductor en la transmisión de AFK, en lugar de su nombre de usuario.","TXT_CODE_6557efaf":"MODT de segunda línea","TXT_CODE_656a85d8":"Acuerdo Steam Rcon","TXT_CODE_65a057ec":"Puerto de conexión del servidor Java","TXT_CODE_65a780a2":"La cantidad de hambre de daño funcionará","TXT_CODE_65b21404":"Descargar","TXT_CODE_65e33205":"Establecer en True si esta mafia debe evitar conejos, similar a cómo las enredaderas evitan los gatos","TXT_CODE_65fcbd09":"Eliminar","TXT_CODE_66056676":"Información de recursos del sistema","TXT_CODE_660e2341":"reproductor de música","TXT_CODE_661c66fa":"Configuración del servidor descendente, solo se pueden conectar los servidores descendentes configurados aquí.","TXT_CODE_6623dde0":"Suprimir los registros relacionados con el cargador de la biblioteca","TXT_CODE_662ad338":"Codificación de flujo de bytes","TXT_CODE_662ae77":"Establecer en True for Enderman para evitar el Gamérulo de duelo de la mafia","TXT_CODE_6655c905":"La respuesta HTTP agregará access-control-allow-origin: *, lo que puede reducir la seguridad pero mejorar la escalabilidad del desarrollo.","TXT_CODE_66820e23":"¿Cuántos NPC puede generar la estatua en 200 píxeles antes de dejar de aparecer? \\nValor predeterminado 3","TXT_CODE_6683b887":"Activar o desactivar API REST","TXT_CODE_66968dc0":"Cuántos bloques gigantes pueden caminar sin tener que saltar","TXT_CODE_669eb0ff":"Salida cuando /ping <ser User> se ejecuta.","TXT_CODE_66ac4611":"Establecer en falso para no permitir la formación de nieve en hielo azul","TXT_CODE_66b01c4e":"Multiplicador del volumen total de libros","TXT_CODE_66b7b26e":"Atributo de velocidad de movimiento","TXT_CODE_66ce073e":"Desconectado","TXT_CODE_66e32091":"El lenguaje de nodo ha sido cambiado:","TXT_CODE_66f38b2e":"Los usuarios normales solo pueden modificar parte de la configuración","TXT_CODE_673eac8e":"modo de luz","TXT_CODE_67509ff2":"Controla si las abejas pueden funcionar durante la noche","TXT_CODE_6750d9d3":"El uso de perfiles compartidos por otros puede hacer que el panel se vea comprometido.","TXT_CODE_678164d7":"Puede encontrar la ID de nodo en la sección \'Lista de nodos\' de la consola comercial","TXT_CODE_67b4d0ba":"Patear jugadores si se quedan inactivos (ver servidor.","TXT_CODE_67b57086":"Solo aparece en jugadores sobre el nivel del mar","TXT_CODE_67b5f678":"MC lecho de roca","TXT_CODE_67c765be":"Especifique el proceso para ejecutarse en ciertos núcleos. Una asignación razonable puede utilizar mejor los recursos de hardware de su sistema. Por ejemplo, 0,1 significa ejecutarse en el primer y segundo núcleo, separados por comas.","TXT_CODE_67d1ea21":"Algunas etiquetas opcionales","TXT_CODE_67d68dd1":"Tipo","TXT_CODE_68128434":"Crear un servidor de juegos de Minecraft","TXT_CODE_6819de18":"¿Está seguro de que desea desactivar APIKey?","TXT_CODE_681aaeb9":"directorio de host","TXT_CODE_683e3033":"Requisitos de hardware","TXT_CODE_684eb7e3":"Número máximo de páginas en un libro.","TXT_CODE_686c9ca9":"Conectando a la consola...","TXT_CODE_68821d80":"Este archivo de configuración es un archivo de configuración común para los servidores Tshock.","TXT_CODE_68831be6":"Tipo:","TXT_CODE_68928779":"Suprimir advertencias sobre atributos desconocidos en consola y registros","TXT_CODE_68a15ebb":"Ya sea para habilitar el monitoreo JMX","TXT_CODE_68a504b3":"Por favor ingresa un nombre de instancia","TXT_CODE_68a6aec5":"Cuando un jugador obtiene un logro, si se muestra en la barra de chat del servidor (si se le permite instalar X)","TXT_CODE_6904cb3":"imagen acoplable","TXT_CODE_6915f2a":"Faltan archivos de dependencia y no se pueden iniciar. Reinstale el programa:","TXT_CODE_692957":"IP del servidor, déjelo en blanco si no está vinculado","TXT_CODE_6929b0b2":"No se puede conectar al nodo remoto","TXT_CODE_693f31d6":"prefijo de ruta","TXT_CODE_694952a":"Crear una imagen de entorno OpenJDK 16","TXT_CODE_699b4b66":"No complete; \\nEl panel lo generará automáticamente cuando sea necesario.","TXT_CODE_69ad6852":"Si se permite hacer trampa usando instrucciones similares","TXT_CODE_69c42450":"Falta soporte de dependencia 7zip, no se pueden descomprimir archivos formato {{fileExt}}.","TXT_CODE_69dbb08":"Permite a los jugadores usar códigos de color en yunques","TXT_CODE_69ecec1":"fuente de descarga de bibliotecas","TXT_CODE_6a06a9ef":"Forzar Cambio al Directorio de Trabajo","TXT_CODE_6a10302d":"¡Una vez eliminado no se puede restaurar!","TXT_CODE_6a365d01":"Operación fallida","TXT_CODE_6a515e35":"La página web agregará automáticamente reproducción de color al contenido de salida y es posible que los colores representados no sean completamente correctos.","TXT_CODE_6a826e8b":"¿Cuánto tiempo puede respirar bajo el agua antes de comenzar a ahogarse?","TXT_CODE_6aa286df":"Página no encontrada","TXT_CODE_6ac327b4":"Establezca en verdadero para permitir el procesamiento a granel de los artículos de alimentos/plantas haciendo clic con el clic derecho con el artículo en la mano","TXT_CODE_6ac61ca1":"Radio dentro del cual los aldeanos buscan detectar la cama más cercana.","TXT_CODE_6adffa20":"No se pudo cargar el archivo de archivo,","TXT_CODE_6b175558":"Después de completar la configuración, cuando la instancia se está ejecutando, el estado del servidor se actualiza cada minuto.","TXT_CODE_6b1984c0":"Porcentaje de probabilidad (0.0 - 1.0) Las enredaderas se cargan (alimentadas) al desovar","TXT_CODE_6b2a9cab":"La configuración de la versión anterior se ha actualizado a la configuración de la nueva versión:","TXT_CODE_6b313c":"Establecido en True to Spewn en el mundo que esta opción es parte de","TXT_CODE_6b4a27dd":"La interfaz web no puede establecer una conexión WebSocket con el nodo. Verifique la configuración del proxy de red o la configuración del firewall.","TXT_CODE_6b5509c7":"Ingrese un nombre de plantilla","TXT_CODE_6b583898":"Modo de motor anti-pivote","TXT_CODE_6b69f1d":"Especifique aquí un tiempo de espera personalizado para el tiempo de espera de la conexión. \\nEl valor predeterminado es cinco segundos.","TXT_CODE_6b6f1d3":"Eres libre de diseñar lo que quieras. \\nDemasiados elementos en la misma página pueden causar una degradación del rendimiento, así que asígnelos de manera razonable.","TXT_CODE_6be8dbe7":"Reiniciar la ruta del script","TXT_CODE_6bf4665b":"Transmitir la geolocalización del jugador según la IP del jugador al unirse","TXT_CODE_6c0478ab":"Comando ejecutado al hacer clic en \\"Detener\\"","TXT_CODE_6c08319b":"MC espiga","TXT_CODE_6c232c9c":"Se utiliza para montar carpetas adicionales en el host en el contenedor, admite dos cadenas de variables:","TXT_CODE_6c274bdc":"Este usuario no tiene APIKEY habilitada.","TXT_CODE_6c5985ca":"Ir a","TXT_CODE_6c7970df":"semillas del tesoro enterrado","TXT_CODE_6c87dd18":"Contenedor Docker (Docker)","TXT_CODE_6c945cf8":"Toca el sonido del desovado de The Wither a nivel mundial cuando está generado","TXT_CODE_6c94f562":"Hace que esta mafia se pueda montar","TXT_CODE_6ca6667f":"Uso de memoria (10min)","TXT_CODE_6cb9bb04":"luna","TXT_CODE_6cbb84a9":"Indisponible","TXT_CODE_6cd13a66":"Si se deben reenviar los pings del jugador al servidor. \\nHabilitar esta opción permitirá a los jugadores de Bedrock Edition tener un ping más preciso, pero también puede hacer que los jugadores agoten el tiempo de espera más fácilmente.","TXT_CODE_6cfeb776":"Establecido en falso para que esta mafia deje de recibir daños del agua","TXT_CODE_6d244c20":"animal","TXT_CODE_6d32ea04":"¿Deberían los jugadores de AFK contar como dormir? \\n(Permite a los jugadores activos omitir la noche durmiendo, incluso si los jugadores de AFK no están en la cama)","TXT_CODE_6d6c7e9a":"Bloquea al jugador si esta cantidad de proyectiles se crea en 1 segundo","TXT_CODE_6d6ceab5":"Las arañas son inmunes a los efectos del veneno.","TXT_CODE_6d772765":"No se pudo obtener la dirección de descarga","TXT_CODE_6d8bc58d":"Error al guardar, ¡una sola etiqueta solo admite hasta 9 caracteres!","TXT_CODE_6d912e27":"Bloquear al jugador si se extrae esta cantidad de fichas en 1 segundo","TXT_CODE_6d9b9f22":"Dado que la interfaz es altamente personalizable, una vez que se guarda el diseño, el idioma de toda la interfaz se bloqueará y el cambio de idioma no funcionará bien a menos que se restablezca el diseño. \\nSi no necesita cambiar de idioma, puede ignorar esta sugerencia.","TXT_CODE_6da85509":"¿Está seguro de que desea emitir un comando de apagado para la instancia?","TXT_CODE_6dcaa94d":"La longitud del nombre debe estar entre 1 y 30 caracteres","TXT_CODE_6e23c48":"tarjeta universal","TXT_CODE_6e3da823":"Parámetros adicionales opcionales después del programa Java, como -nogui, etc. Varios parámetros están separados por espacios.","TXT_CODE_6e69b5a5":"Descompresión, edición y otras codificaciones de funciones de gestión de archivos.","TXT_CODE_6e718abe":"No se pueden obtener datos de identidad. Puede ser que haya sido bloqueado o haya un problema de red. Intente actualizar la página.","TXT_CODE_6e96b2a9":"Codificación de salida de consola","TXT_CODE_6ed13fd":"¿Cuánto daño lidiar con el Elytra cuando Trident Riptide Boost se activa","TXT_CODE_6eead111":"Archivo de configuración del servidor mohist.yml","TXT_CODE_6ef5195f":"Se puede utilizar para mostrar imágenes.","TXT_CODE_6f038f25":"¡Estamos trabajando duro en los archivos!","TXT_CODE_6f0a5984":"Seguir el atributo de rango","TXT_CODE_6f1129fb":"Asignación automática","TXT_CODE_6f12aba3":"¿Está seguro de que desea eliminar este hipervínculo?","TXT_CODE_6f161560":"Codificación de Archivo","TXT_CODE_6f23ce93":"{{count}} instancia restante para ser cerrada, esperando ...","TXT_CODE_6f27624c":"Acceder al daemon desde","TXT_CODE_6f2c1806":"Eliminar","TXT_CODE_6f43f95f":"Usuario <<operator_name>> descargó el archivo {{archivo}} de la instancia <<instance_name>>","TXT_CODE_6f659da2":"Diagrama de estado utilizado para analizar el período reciente del panel.","TXT_CODE_6f7c50c2":"Desactivar la detección de gatos en cajas","TXT_CODE_6f862823":"El McSmanager está saliendo, por favor espera ...","TXT_CODE_6f91f3ba":"ocupando espacio","TXT_CODE_6f98ccd7":"primera vez usando","TXT_CODE_6f9d4bb7":"Bloques que se pueden usar para construir un conducto","TXT_CODE_6fac9e82":"tasa de crecimiento del retoño","TXT_CODE_6fe24924":"Memoria máxima (MB)","TXT_CODE_6ff0668f":"¿Está seguro de que desea eliminar esta tarea del proyecto?","TXT_CODE_7010d780":"El orden en el que se deben probar los servidores cuando un jugador inicia sesión o es expulsado de un servidor.","TXT_CODE_703cdd68":"¿Deberíamos controlar la ventana? \\nDeshabilitar esto deshabilita nuevas características de GL y puede ser malo para las modificaciones que dependen de ellas.","TXT_CODE_704a8b5d":"Rango de inicio del aldeano","TXT_CODE_70750fa":"Permitir colisiones de vehículos","TXT_CODE_7078fd28":"Error de instalación","TXT_CODE_709c2db4":"¿Quieres contribuir una plantilla?","TXT_CODE_70a2613b":"No se detectaron archivos de configuración calificados mediante tipos de instancia específicos (minecraft/java) y escaneo de archivos. Inicialice la configuración del proceso o cambie el tipo de instancia para realizar ajustes.","TXT_CODE_70c3b6e":"Declaración 1.13 Comandos de proxy del cliente.","TXT_CODE_70ce6fbb":"La instancia ha sido detenida.","TXT_CODE_70e0cf4d":"Volver al Inicio","TXT_CODE_70fe20dd":"Debería Elytras ignorar el encantamiento inquebrantable","TXT_CODE_70ff09a8":"El umbral para actualizar el marcador, cuántos paquetes de marcador por segundo.","TXT_CODE_710a2e6c":"Whitelist of Tools que pueden extraer desovadores con toque de seda","TXT_CODE_71155575":"¿Estás seguro de que quieres eliminarlo?","TXT_CODE_711d4763":"La cantidad de datos enviados desde el servidor al cliente determina el campo de visión que el jugador puede configurar.","TXT_CODE_7141866a":"Expulsar a los clientes que no envían UUID al servidor","TXT_CODE_7153951e":"El servicio de instalación rápida depende de plataformas en línea de terceros.","TXT_CODE_7166a969":"Ya sea para habilitar la penetración de ping","TXT_CODE_718c9310":"desactivar","TXT_CODE_71a51d19":"Consola de instancia","TXT_CODE_71c948a9":"Por favor ingrese al directorio de trabajo","TXT_CODE_71f715e2":"Hace controlable esta mafia. \\nTrader Llama debe ser domesticado para ser controlable. \\nEstar cargado (alfombra) no es un requisito, ya que técnicamente siempre tiene una alfombra.","TXT_CODE_721157a3":"Resumen de datos","TXT_CODE_7214ead7":"Versión de configuración","TXT_CODE_724ce74d":"¿Qué instancia de aplicación desea implementar?","TXT_CODE_7284c68e":"Modo de juego predeterminado al obligar a los jugadores a unirse","TXT_CODE_728fdabf":"No se pudo crear la instancia. Vuelva a intentarlo más tarde.","TXT_CODE_72952e19":"Seleccione elementos para eliminar","TXT_CODE_72c8d0bf":"Permite que el horno esté infinitamente alimentado por lava colocada debajo","TXT_CODE_72cce10b":"Gestión de archivos de instancia","TXT_CODE_72cfab69":"ID de nodo","TXT_CODE_72d36de":"Si se debe habilitar la compatibilidad con BungeeCord","TXT_CODE_72f69b34":"Utilice los colores del nombre del marcador mundial vainilla","TXT_CODE_73102f2b":"Los registros de operación del sistema se mostrarán aquí","TXT_CODE_7333c7f7":"Claro","TXT_CODE_7356e569":"Nessun modello disponibile","TXT_CODE_738bc836":"Tamaño máximo del mundo","TXT_CODE_73c7b4b":"Atributo de daño de ataque","TXT_CODE_7411336e":"Instancias totales","TXT_CODE_741fdde4":"Si se debe reiniciar automáticamente el servidor cuando falla","TXT_CODE_743c6bf3":"Establecer en True For Clérics para cultivar la verruga inferior","TXT_CODE_743ed87f":"Nivel de compresión","TXT_CODE_74443c8f":"La instancia no se está ejecutando.","TXT_CODE_745d8a03":"bloque de hipervínculo","TXT_CODE_745fc959":"Esta característica protegerá su panel contra el descifrado de contraseñas por fuerza bruta por parte de un solo host con solo 10 errores de contraseña por IP.","TXT_CODE_74788d9e":"Le permite colocar un cristal final en cualquier bloque, no solo la obsidiana y el lecho de roca","TXT_CODE_74c3d3e5":"Documentación","TXT_CODE_74c46351":"Estadísticas de fuerza","TXT_CODE_74fa2f73":"¿Está seguro de que desea restablecer el diseño?","TXT_CODE_74fd665e":"Aplicar al subdirectorio","TXT_CODE_750ab5c6":"Limite el uso total de todas las CPU, habrá una ligera desviación","TXT_CODE_751f9bc1":"El importante archivo de configuración del servidor del grupo Velocity se puede utilizar para administración distribuida, control de nodos, etc. Sin embargo, este archivo de configuración es más complicado y es solo para configuraciones y operaciones simples.","TXT_CODE_7542201a":"Eliminar también archivos relacionados con la instancia","TXT_CODE_7546cc5":"En caso de que las entidades funcionen normalmente cuando los jugadores cercanos son AFK. \\nFalse requerirá al menos 1 jugador que no sea AFK para marcar","TXT_CODE_75696661":"Si utiliza el reenvío de IP moderno o BungeeGuard, configure aquí el perfil que contiene la clave única.","TXT_CODE_759fb403":"condición","TXT_CODE_75bf9192":"Usar código","TXT_CODE_75c04302":"Rango inicial del monstruo volador","TXT_CODE_75da3f2d":"Limpiar plantilla actual","TXT_CODE_75e5af9b":"Este archivo de configuración actualmente no admite la configuración directa. Vaya a la administración de archivos para editarlo.","TXT_CODE_75ef0619":"Reiniciar el nodo para entrar en vigencia, requiere una modificación simultánea de la configuración de la conexión","TXT_CODE_7638590c":"El número de instancias en ejecución.","TXT_CODE_765d34e6":"tarjeta de usuario","TXT_CODE_7669fd3f":"Descomprimir el archivo","TXT_CODE_76750199":"cada semana","TXT_CODE_7680e37f":"Habilite el registro de directivas.","TXT_CODE_768c6fa9":"Tasa de crecimiento de la planta carnívora","TXT_CODE_76a82338":"Si viene de Taiwán y Hong Kong, puedes elegir BIG5, y si viene de otras regiones, puedes elegir UTF-8.","TXT_CODE_76b2a495":"otro","TXT_CODE_76c66252":"Incremento de abuso de tecla de tabulación","TXT_CODE_76d20724":"Todas las instancias de usuario","TXT_CODE_76d59e8":"Establecer en True para hacer que las columnas de burbujas descendentes generen en lugar de columnas de burbujas ascendentes cuando la arena del alma se coloca/se genera bajo bloques de fuente de agua.","TXT_CODE_77000411":"Nombre de la imágen","TXT_CODE_7702d818":"Escurchar y haga clic con el botón derecho en un strider con una silla de montar en su parte posterior para eliminarlo con esta opción habilitada","TXT_CODE_77083c51":"Montar directorios adicionales del host en el contenedor. Se admiten las variables {mcsm_workspace} (directorio de trabajo) y {mcsm_instance_id} (ID de instancia).","TXT_CODE_772bb48a":"ej: Java 18+","TXT_CODE_772c4961":"Cantidad de daño por segundo cristales se ocupan de los fantasmas. \\nEl valor de 1.0 es medio corazón","TXT_CODE_773f36a0":"Subida exitosa","TXT_CODE_77816ef3":"Cuando verdaderas, todas las muertes de dragón válidas eliminarán la cantidad total de experiencia en orbes como si fuera la primera muerte del dragón","TXT_CODE_779553fb":"Token de servicio web","TXT_CODE_77cc12da":"Reiniciar la instancia","TXT_CODE_77d038f7":"La cantidad de memoria utilizada por el lado del panel.","TXT_CODE_77d93d7d":"Documento de referencia oficial: https://docs.docker.com/engine/reference/builder/","TXT_CODE_78019c60":"Editar perfil","TXT_CODE_7818efd1":"Establecido en falso para los lobos rabiosos para no ser curados por leche","TXT_CODE_78223e62":"Si GeoIP está habilitado, los jugadores identificados como usuarios de proxies serán expulsados.","TXT_CODE_785a0fcf":"Tasa de descarga de archivos de usuario","TXT_CODE_7863f28d":"Actualizar exitosamente","TXT_CODE_786c22bd":"No se pudo hacer cargo del contenedor en ejecución","TXT_CODE_786e2280":"Si las camas explotan. \\nEstablecer esto en falso solo hace que la cama fuera de la existencia","TXT_CODE_78930f0f":"Editar URL","TXT_CODE_7898c2b4":"Permite a los endermen encajar en espacios de 2 bloque de alto si están habilitados. \\nDado que el cliente hitbox sigue siendo el mismo, aún puedes golpearlos en la cabeza","TXT_CODE_78aa511":"tiempo de desconexión","TXT_CODE_78e88c3f":"Agrupación de etiquetas","TXT_CODE_7907c99":"Descomprimir en el directorio actual","TXT_CODE_791a4c9b":"Establecer el nivel de permiso predeterminado de una función","TXT_CODE_791c73e9":"archivo nuevo","TXT_CODE_798f592e":"leer","TXT_CODE_7991f7b3":"La compensación de proyectil de una bola de nieve","TXT_CODE_79b77e31":"Establecido en verdad para darle daño a la caída al jugador mientras está en un MineCart","TXT_CODE_79ccdee0":"El radio de bloques que una esponja absorbe agua","TXT_CODE_79d2800b":"Generar latencia - por jugador","TXT_CODE_79f9a172":"Editar usuario","TXT_CODE_7a2b969f":"Los encantamientos que no se eliminan de las piedras de molienda","TXT_CODE_7a318185":"Modificar para cambiar la resistencia de explosión de los bloques.","TXT_CODE_7a464bb4":"La velocidad del aspirador de delfines","TXT_CODE_7a830c68":"Autoguardado, un valor de 6000 significa que el servidor intentará guardar el mundo automáticamente cada 5 minutos. \\nNota: Demasiado pequeño puede provocar un retraso en el servidor","TXT_CODE_7ac6f85c":"La consola de visualización no es compatible con el modo de diseño.","TXT_CODE_7ac8b1d3":"Por favor ingresa el código de verificación de dos pasos","TXT_CODE_7af6d85a":"Tela MC","TXT_CODE_7b0b38e6":"¿Deberían los dispensadores aplicar la armadura a las ranuras de armadura si se encantan con la maldición de la unión?","TXT_CODE_7b1adf35":"Patrones de diseño de interfaz","TXT_CODE_7b2c5414":"seleccionar","TXT_CODE_7b477c3":"Tamaño mínimo para elegir aleatoriamente cuando se desove naturalmente","TXT_CODE_7b67813a":"Terminar","TXT_CODE_7b759c13":"Evite que se generen mosaicos preestablecidos dentro del radio de protección","TXT_CODE_7b763c56":"El MOTD del servidor. \\nNo importa si \\"passthrough-motd\\" está configurado como verdadero","TXT_CODE_7b8f01b5":"Número de hilos de ejecución de trabajo","TXT_CODE_7b92d98d":"Requisitos de la versión de Java","TXT_CODE_7bcf35c1":"La cantidad de daño que le hará a los jugadores","TXT_CODE_7bdd0634":"Establecido en verdad para hacer que el enderman aggro hacia los endermites solo si los han generado un jugador lanzado Pearl Pearl. \\nEsta opción no hace nada si \'agresivo-towards-endermites\' es falso","TXT_CODE_7c0b7608":"Estado del nodo","TXT_CODE_7c25c81a":"Desactiva el observador de archivos. \\nSe utiliza para actualizar automáticamente la configuración si su archivo ha sido modificado.","TXT_CODE_7c650d80":"La conexión del nodo falló. Comuníquese con el administrador para verificar el estado del nodo remoto.","TXT_CODE_7c76dbf":"obstruido","TXT_CODE_7cad42a5":"Buscar por nombre de archivo","TXT_CODE_7cc196b9":"Umbral de compresión de red","TXT_CODE_7ce3c6e":"ID de página del libro","TXT_CODE_7ceebc05":"Ingrese contenido de texto, admita la sintaxis de Markdown y pueda ajustar líneas.\\n\\nNo utilices la redacción de otras personas fácilmente, de lo contrario se puede inyectar código malicioso para atacarte.","TXT_CODE_7cf078e8":"Nombre de la imagen e identificación de la versión después de la creación.","TXT_CODE_7cf70670":"Despierta al monstruo cada tictac","TXT_CODE_7d197c39":"Número de subprocesos de ejecución de IO","TXT_CODE_7d1a9487":"Entorno de etapa de ejecución Java 17 incorporado, adecuado para servidores que ejecutan Minecraft 1.18 o superior","TXT_CODE_7d25f076":"Los comerciantes errantes serán tentados por los bloques de esmeraldas y seguirán a los jugadores que los sostienen","TXT_CODE_7d28d924":"Controla cuántos cristales finales pueden ocupar el mismo espacio de hitbox. \\nCuando se establece en un determinado número, cualquier cristal adicional causará una explosión.","TXT_CODE_7d3d97ec":"¿Qué color debería mostrar cuando el modo de relleno es \'bueno\'?","TXT_CODE_7d81030f":"Control si los zombis gigantes también tienen una IA hostil también","TXT_CODE_7d839745":"ej: manzana, plátano, cereza","TXT_CODE_7d874fad":"El número máximo preestablecido de criaturas generadas por ola. \\nMás alto significa que hay más criaturas en esa ola.","TXT_CODE_7da6e84":"Después de completar todos los campos obligatorios, puede crearlo. Para obtener más configuraciones, créelas y edítelas en la configuración de la instancia de la aplicación.","TXT_CODE_7db580c1":"Multiplicador de otoño de bloque para cama blanca","TXT_CODE_7dd469fa":"Este es el mensaje que se transmite cuando un usuario ya no es AFK (debe tener un juego de tiempo de jugador de juego mayor que 0","TXT_CODE_7e0b9953":"Qué hacer con los bloques afectados por la explosión.","TXT_CODE_7e267ba":"Seleccionar nodo","TXT_CODE_7e426b47":"Si la consulta está habilitada, ¿en qué puerto de conexión debería escuchar el protocolo de consulta?","TXT_CODE_7e6a82d8":"Archivo de configuración de un servidor Forge","TXT_CODE_7e9727bd":"Número de jugadores","TXT_CODE_7eb0f9fd":"Establecer en True para ocultar a los jugadores del selector de entidades si están ocultos","TXT_CODE_7ec7ccb8":"Cuando se hace clic en el botón \\"Cerrar instancia\\", este comando se ejecutará inmediatamente. ^C representa la señal Ctrl C.","TXT_CODE_7ec87e8a":"Cancelar carga","TXT_CODE_7ec9c59c":"Nombre:","TXT_CODE_7f0017d2":"Puerto de conexión del panel","TXT_CODE_7f0c746d":"Operación exitosa","TXT_CODE_7f0daff7":"Solucionar el problema de que la posición de la entidad no esté sincronizada.","TXT_CODE_7f1aef9f":"Servidor edición MC Bedrock","TXT_CODE_7f31b67d":"Número de embudos","TXT_CODE_7f52e10d":"Daño de ataque (en medio corazones)","TXT_CODE_7f5ee413":"El radio de explosión del ataque de proyectil de un marchitamiento","TXT_CODE_7f8f267f":"Clave del agente de velocidad","TXT_CODE_7f9b6758":"Opcional, ingrese la ruta absoluta de Java. Si se deja en blanco, las variables de entorno se seleccionarán de forma predeterminada.","TXT_CODE_7fa8720d":"Comando de Inicio (Sin Saltos de Línea)","TXT_CODE_7fc92d9":"El cliente Bedrock Edition puede congelarse al abrir el símbolo del sistema por primera vez. \\nDeshabilitar esta función evitará que se envíen sugerencias de comandos y resolverá los bloqueos del cliente Bedrock Edition.","TXT_CODE_7fca723a":"Cargando. \\nSi no hay respuesta durante mucho tiempo, consulte la red.","TXT_CODE_8028e95b":"Ingrese su nombre de usuario del panel, se creará una nueva cuenta si no existe","TXT_CODE_8036ea5e":"No hay asignación configurada.","TXT_CODE_806441b5":"Golpear y hacer clic con el botón derecho en un cerdo con una silla de montar en su regreso para eliminarlo con esta opción habilitada","TXT_CODE_80747f11":"Salida del marcador de posición <Minute> en Command.uptime.Format Opción","TXT_CODE_8074a178":"Nueva fecha de vencimiento:","TXT_CODE_80766ddc":"Guión simplificado","TXT_CODE_80790069":"Opcional, por ejemplo 1024","TXT_CODE_808e5ad9":"Sólo se pueden cargar archivos zip","TXT_CODE_80a560a1":"Número de cuenta","TXT_CODE_80c5409f":"Imagen de Portada","TXT_CODE_80c85070":"Requisitos de Entorno","TXT_CODE_80f0904e":"Edición profesional","TXT_CODE_81297804":"Como instrucciones, nombres de archivos u otros parámetros, etc.","TXT_CODE_812a629e":"El navegador no puede conectarse a la dirección:","TXT_CODE_8145d25a":"Por favor seleccione una instancia","TXT_CODE_8145d82":"Guardar diseño de tarjeta","TXT_CODE_814a3c64":"El número máximo de monstruos voladores despertados por tic","TXT_CODE_81634069":"Versión","TXT_CODE_816ae222":"Salida del marcador de posición <Days> en el comando.uptime.Format Opción","TXT_CODE_8175818c":"Bloquear multiplicador de otoño para cama amarilla","TXT_CODE_818928ba":"Admite cualquier idioma y garantiza la singularidad tanto como sea posible.","TXT_CODE_81979d0f":"Directorio de almacenamiento de datos","TXT_CODE_81ad9e80":"Una forma más flexible de crear instancias, sin instalar a través del mercado de aplicaciones.","TXT_CODE_81b9b599":"Copia fallida:","TXT_CODE_81c2f4ae":"Establecer en falso para no permitir que los armarios se muevan en agua","TXT_CODE_81cabec":"Establece si el servidor debe volcar todos los valores de configuración al inicio de sesión de registro del servidor","TXT_CODE_81d7e7c5":"Panel de administración de código abierto, descentralizado y listo para usar que admite servidores de juegos de Minecraft y todos los programas de consola.","TXT_CODE_8201d2c6":"Número de ejecuciones/Número total de todas las instancias","TXT_CODE_820ebc92":"Montar directorio en contenedor","TXT_CODE_823bfe63":"en línea","TXT_CODE_8259b3db":"El rango cercano para verificar si hay shulkers","TXT_CODE_828ea87f":"Monte rutas adicionales en el contenedor.","TXT_CODE_8298bfde":"El número máximo de solicitudes REST en el depósito antes de rechazar la solicitud. \\nEl valor mínimo es 5.","TXT_CODE_82b18ea4":"¿Qué color debería mostrar cuando el uso de RAM es \'bueno\'?","TXT_CODE_82c331f":"Si se debe ocultar el número de personas en línea","TXT_CODE_82d650be":"Interfaz de instalación","TXT_CODE_82e624d1":"Mc-mohist","TXT_CODE_82fbc5ad":"acción","TXT_CODE_8343c177":"El número máximo de aldeanos despertados por tic.","TXT_CODE_8366db5a":"semillas de la ciudad final","TXT_CODE_836addb9":"(desconectado)","TXT_CODE_837501b0":"Velocidad base de MineCart cuando se controla","TXT_CODE_83856178":"La cantidad de animales que se pueden generar en cada mundo.","TXT_CODE_83914d85":"Si se debe permitir el acceso remoto a la consola del servidor (RCON)","TXT_CODE_83c9cb05":"Retrasar el tiempo de descarga del bloque","TXT_CODE_83d5cbbe":"Establecer en falso para evitar que los aldeanos zombie sean curables","TXT_CODE_83d8e4a1":"Ingrese el comando de actualización","TXT_CODE_83e553fc":"No se pudo obtener la lista de perfiles","TXT_CODE_84099e5":"Asegúrese de que la dirección del nodo remoto sea una IP pública y que el puerto de conexión del nodo esté abierto normalmente.","TXT_CODE_842929d0":"Descompresión ZIP falló: {{message}}","TXT_CODE_845b8bd8":"Bloquear multiplicador de otoño para la cama púrpura","TXT_CODE_846683e4":"Evita que el delfín caza el tesoro","TXT_CODE_849c3911":"La posibilidad de que un huevo de tortuga se rompa","TXT_CODE_84bf49c9":"Disco de E/S:","TXT_CODE_84cf0951":"No puedo obtener información del comerciante","TXT_CODE_84d56d69":"Enviar información de posición completa para entidades de colisión fuerte","TXT_CODE_84f760fa":"Generalmente es un archivo .jar, como paper.jar, etc.","TXT_CODE_84fbe277":"Descripción general","TXT_CODE_8504218":"Agrega un tiempo de reutilización a los animales reproductores por tipo animal","TXT_CODE_855c4a1c":"Número de jugadores: ","TXT_CODE_85617390":"miércoles","TXT_CODE_856bd2f3":"Número de IP bloqueadas temporalmente","TXT_CODE_8575f7c":"Permisos:","TXT_CODE_85770d4a":"parámetro de sufijo","TXT_CODE_858d8728":"Aumentar el tiempo de incubación.","TXT_CODE_859b2d24":"Sugerir nombres de jugadores cuando la pestaña de finalización esté vacía","TXT_CODE_85a33a84":"reencuadernar","TXT_CODE_85b01e01":"Establece el modo PvP. \\nLos tipos válidos son: \\"normal\\", \\"siempre\\" y \\"deshabilitado\\"","TXT_CODE_85d134f2":"Si los mobs en generadores restringidos saltan","TXT_CODE_85d8d0a3":"Ya sea para enviar mensajes de depuración a través de la consola.","TXT_CODE_86076132":"Cuán ciega es una mafia cuando se ve afectada con el efecto de la poción de ceguera","TXT_CODE_860e2ce":"Establezca si los golems de hierro pueden nadar o no","TXT_CODE_8631c629":"Controles si la armadura debe limitar cuánto daño pueden reducir.","TXT_CODE_8638bb65":"Velocidad máxima de un minecart cuando se controla","TXT_CODE_8677ef57":"Establecer en falso para que el trueno continúe incluso después de que un jugador duerme","TXT_CODE_868df02c":"Acerca de los archivos DockerFile","TXT_CODE_86ab6e1e":"Deshabilitar las actualizaciones del bloque de hongos","TXT_CODE_86caaf6c":"Opciones avanzadas","TXT_CODE_86e0cccc":"La dirección debe completarse","TXT_CODE_86ff658a":"La configuración de SSL, proxy inverso, etc. requiere soporte adicional para el protocolo Websocket.","TXT_CODE_870b392e":"Número máximo de fantasmas para generar por intento (use -1 para basar esto fuera de la dificultad mundial)","TXT_CODE_8717ed9d":"Ingrese los requisitos de entorno","TXT_CODE_871cb8bc":"Vaya al mercado de aplicaciones para instalar aplicaciones","TXT_CODE_871fb0d6":"Número de inicios de sesión fallidos: Número de inicios de sesión exitosos","TXT_CODE_871feca":"Habilitar resaltado de sintaxis de Brigadier","TXT_CODE_875e804b":"¿En qué nivel de dificultad los aldeanos zombies rompen puertas?","TXT_CODE_877eea45":"Opcional, el valor predeterminado se crea y administra automáticamente. Si es necesario, escriba la ruta absoluta completa.","TXT_CODE_877ef60c":"Porcentaje de posibilidades (0.0 - 1.0) Un vindicador llamado \'Johnny\' generará en lugar de un vindicador","TXT_CODE_87c20d47":"Atributo de fuerza de salto máximo","TXT_CODE_87c5dcb4":"El mensaje de ActionBar que aparece cuando se ha omitido la noche. \\nEstablezca en \'predeterminado\' para permitir que el cliente use sus propios componentes traducibles. \\nEstablezca en una cadena vacía para deshabilitarla.","TXT_CODE_87e18bb5":"Ya sea para transmitir la aparición de jefes o el inicio de una invasión","TXT_CODE_87e448ae":"IP del servidor, déjelo en blanco si no está vinculado","TXT_CODE_87f0a517":"Desactivar la detección de gatos en caja","TXT_CODE_880fedf7":"Restablecer filtros","TXT_CODE_881213df":"¿Qué debería ser MODT? \\nEsta información se mostrará cuando un jugador agregue su servidor a la lista de servidores. \\nSólo se acepta el formato MiniMessage.","TXT_CODE_88122886":"Compresión","TXT_CODE_88249aee":"Mercato dei modelli di server","TXT_CODE_88405298":"Si las bolas de nieve, cuando se arrojan, deben extinguir velas","TXT_CODE_88419e99":"altura máxima del bloque","TXT_CODE_88427611":"Se utiliza para personalizar la generación de un mundo superplano. Si no desea generar un mundo superplano, déjelo en blanco.","TXT_CODE_88c990a4":"Tamaño del paquete integrado","TXT_CODE_88e9361a":"Estado operativo de la instancia","TXT_CODE_88f7082":"Establecer en True para los evocadores para evitar el Gamérulo de duelo de la mafia","TXT_CODE_890aa44c":"Puerto de conexión RCON","TXT_CODE_893567ac":"Segunda confirmación","TXT_CODE_894b8e52":"Límite máximo de reinicios automáticos alcanzado","TXT_CODE_8956123b":"¿Deberíamos reenviar direcciones IP y otros datos a servidores backend?","TXT_CODE_8965b2cf":"El nombre del servidor que se enviará al cliente JAVA. \\nEsto es visible tanto en el menú de pausa como en el menú de configuración.","TXT_CODE_8981d724":"Columna de título sin nombre","TXT_CODE_8a30e150":"todos los idiomas","TXT_CODE_8a5274c1":"¿Durante cuánto tiempo, en milisegundos, BungeeCord debe usar los resultados almacenados en caché de los pings del servidor en lugar de hacerles ping manualmente para el recuento de jugadores? Ingrese -1 para desactivarlos.","TXT_CODE_8a71a4d7":"Establecido en True para bolas de fuego para evitar el Gamérulo de duelo de la mafia","TXT_CODE_8a7c57b9":"Le permite configurar las puertas que requieren que se opere Redstone (roble, abeto, etc.)","TXT_CODE_8a924345":"Si se debe utilizar ServerName en lugar de nombre mundial","TXT_CODE_8a9c6364":"Advertencia descompresión 7zip: {{warning}}","TXT_CODE_8a9fd2b4":"Las alas fantasma sólo atacan a los insomnes","TXT_CODE_8aa7f7a0":"Los caballos de esqueleto pueden nadar en agua. \\nFalse los hace hundirse hasta el fondo (Vanilla predeterminado)","TXT_CODE_8ab0cc1a":"Evita que los jugadores incondicionales mueran","TXT_CODE_8ae0dc90":"Imagen de fondo de la interfaz","TXT_CODE_8b0f8aab":"Agregar nueva tarjeta","TXT_CODE_8b14426e":"El archivo ya existe, omita la carga.","TXT_CODE_8b62abb2":"Lista de imágenes de host remoto","TXT_CODE_8b8c52f":"¡No estás en la lista blanca!","TXT_CODE_8b8e08a6":"Tiempo de creación:","TXT_CODE_8b937b23":"Eliminar nodo","TXT_CODE_8bb8e2a1":"Modo comerciante","TXT_CODE_8bd1f5d2":"Ya existe en el directorio. ¿Quieres sobrescribir el archivo original?","TXT_CODE_8be0e39b":"Cantidad de garrapatas entre el daño ahogado","TXT_CODE_8bf86cbc":"Establecer en falso para deshabilitar los nombres de la pantalla de TE persistentes después de romperse (por ejemplo, los jefes de jugadores personalizados deja de conservar su nombre)","TXT_CODE_8c0db3f4":"Complete las instrucciones de inicio usted mismo","TXT_CODE_8c17acf8":"Mapeo de Puertos","TXT_CODE_8c18a6ac":"La compensación de proyectil de un arco","TXT_CODE_8c2ad2cb":"Permite a los jugadores romper fichas temporales que no se pueden construir (césped, macetas, etc.)","TXT_CODE_8c3164c9":"informacion personal","TXT_CODE_8c7318b3":"Iniciar una instancia","TXT_CODE_8cb5a1e6":"La cantidad de filas que debe tener un barril. \\nMin: 1, Max: 6","TXT_CODE_8cba8d40":"Establezca si los golems de hierro pueden generar en el aire, como en 1.12 y abajo","TXT_CODE_8cc8e9e2":"El valor base para establecer el daño de ataque del limo","TXT_CODE_8ccb5428":"Lista de archivos actualizada correctamente","TXT_CODE_8cfa8c1e":"Si la tolva puede cargar trozos","TXT_CODE_8d4882b0":"Opcional, no se recomienda completar este ítem sin necesidades especiales.","TXT_CODE_8d4c8f7e":"No se pudo hacer cargo del contenedor en ejecución","TXT_CODE_8d4e6058":"Consultar bibliotecas","TXT_CODE_8d5d8e26":"semillas de pantano","TXT_CODE_8d6c8ae7":"Ingrese una descripción de plantilla","TXT_CODE_8d6e5b1f":"Verifique estrictamente el progreso de las dimensiones.","TXT_CODE_8d83752":"Solo se admiten URLs oficiales de descarga de juegos y archivos ZIP","TXT_CODE_8d8b1d6a":"Crear una instancia de Minecraft","TXT_CODE_8d8fbbf4":"Añadir asignación","TXT_CODE_8d9f5a4e":"Mientras el nodo remoto (nodo remoto) se esté ejecutando, se iniciará automáticamente una operación de inicio de instancia.","TXT_CODE_8da44b20":"Bloquear multiplicador de otoño para cama negra","TXT_CODE_8dbcf565":"Tamaño del Paquete (Opcional)","TXT_CODE_8dd7bc1a":"Tasa de carga máxima del jugador","TXT_CODE_8deb2054":"Darle al Golem de Hierro una amapola lo calma cuando está enojado","TXT_CODE_8dfc41ef":"Anfitrión","TXT_CODE_8dfd8b17":"indefinidamente","TXT_CODE_8e16ee21":"Haga clic para subir archivo de plantilla","TXT_CODE_8e223f23":"No hay datos disponibles para descargar","TXT_CODE_8e2be926":"Ingrese la dirección IP del servidor del juego. Si se deja en blanco, el valor predeterminado será el host local del demonio (localhost).","TXT_CODE_8e5f865e":"El tipo de base de datos utilizada para almacenar datos (sqlite o mysql)","TXT_CODE_8e632796":"Dirección de acceso al servidor","TXT_CODE_8eb1ae3e":"Establecido en True para imponer restricciones de teletransporte en los portales inferiores. \\nEsto transmite el evento EntityTelePorthinderedEvent que da la capacidad de volver a intentar los teletransportes si fallan debido a que los pasajeros/ser vehículos","TXT_CODE_8f20c21c":"¿Está seguro de que desea cancelar el guardado del diseño?","TXT_CODE_8f3582d7":"Establecer versión","TXT_CODE_8f3e5807":"Mc-nukkit","TXT_CODE_8f47d95":"¡Guardado mediante tecla de acceso directo!","TXT_CODE_8f809a5":"Despierta las persistentes garrapatas de los animales","TXT_CODE_8f8103b7":"envase","TXT_CODE_8f9533b5":"Habilitar la función anti-pivote","TXT_CODE_8fac22fc":"¿Qué color debería mostrar cuando el modo de relleno es \'bajo\'?","TXT_CODE_8fac56fb":"Velocidad de desaparición del artículo","TXT_CODE_8facd134":"Haz clic aquí","TXT_CODE_8fd7a9a1":"¡Asegúrese de tener Docker instalado correctamente en esta máquina!","TXT_CODE_8fd8bfd3":"Seleccione un artículo","TXT_CODE_8fe9c7f7":"Si se debe habilitar la lista blanca (versión anterior)","TXT_CODE_903a9ec9":"tarjeta de reproductor de música","TXT_CODE_903b6c50":"El usuario no existe, por favor inténtalo de nuevo.","TXT_CODE_903dfe61":"distancia simulada","TXT_CODE_90508729":"Esta operación eliminará directamente todo el directorio donde se encuentra la instancia y los archivos no se podrán restaurar. ¿Quiere continuar?","TXT_CODE_9066472a":"Elaborar esto a falsos permite que los niveles suban a \'32767\' almacenándolos como pantalones cortos en lugar de bytes.","TXT_CODE_906c5d6a":"Eliminación completada!","TXT_CODE_90865a4":"Deshabilita el perfilador de método.","TXT_CODE_90896d08":"Nombre de grupo predeterminado para jugadores no registrados","TXT_CODE_908a4ace":"Falta archivo de volumen","TXT_CODE_90912e04":"Desactivar las lápidas que caen cuando el jugador muere","TXT_CODE_9095d186":"Cantidad máxima de valor de EXP para caer en la muerte","TXT_CODE_90a9d317":"Variables de entorno del contenedor","TXT_CODE_90b2ae00":"MCSManager prioriza garantizar la experiencia del usuario en el modo claro. El modo oscuro puede proporcionar una experiencia de usuario peor para algunas interfaces.","TXT_CODE_90b596a8":"El formato de BossBar cuando el servidor ejecuta el comando /rambar","TXT_CODE_90e959d2":"Habilita la compatibilidad con el protocolo PROXY de HAProxy. \\nSi no sabes para qué sirve esto, no lo habilites.","TXT_CODE_90edf4ad":"Número máximo de conexiones por tick","TXT_CODE_90f00679":"ruta de base de datos sqlite","TXT_CODE_90f684dc":"[General] eula.txt","TXT_CODE_912ec943":"¡El cliente está desactualizado! \\nPor favor use {0}","TXT_CODE_91381d5c":"Si está habilitado (el valor predeterminado es falso) y el agente está en modo en línea, Velocity expulsará a cualquier jugador en línea existente si se realizan repetidos intentos de conectarse.","TXT_CODE_91507ef3":"Si se debe habilitar el soporte para Forge","TXT_CODE_9156fbc":"Número de ejecuciones, dejar en blanco significa tiempos ilimitados","TXT_CODE_91734638":"Si se debe habilitar el movimiento autorizado del lado del servidor","TXT_CODE_91a8d35c":"Porcentaje de posibilidades (0.0-1.0) El conejo asesino genera naturalmente","TXT_CODE_91b3fa98":"El panel no puede saber si este perfil es compatible. Ingrese a la interfaz de perfil correspondiente según el tipo.","TXT_CODE_91bb6101":"Panel/Linux (UTF8)","TXT_CODE_91d066aa":"7zip no cargado, no se soportan archivos multi-volumen. Archivos multi-volumen (incluyendo zip, 7z, rar, etc.) requieren soporte 7zip. Contacte al administrador para instalar la librería 7zip.","TXT_CODE_91d70059":"Directorio de instancias:","TXT_CODE_91d857f5":"Opcional, 0 a infinito","TXT_CODE_91ebfa75":"Atributo de velocidad de vuelo","TXT_CODE_921206fc":"Editar Plantilla","TXT_CODE_9213f8e3":"Archivo de configuración para pez glóbulo. \\nPermite una mayor configuración de un servidor de papel.","TXT_CODE_925af648":"Tasa de crecimiento de bayas brillantes","TXT_CODE_9268932c":"Actualizar área al guardar","TXT_CODE_9277af78":"Reintentar","TXT_CODE_9278b7b0":"Por lo general, el valor predeterminado es suficiente. Si se dedica a actividades comerciales, debe utilizar el método de inicio del contenedor virtualizado; de lo contrario, el host puede ser invadido.","TXT_CODE_928653c6":"Si el selector de destino selecciona entidades dentro del siguiente rango","TXT_CODE_929a9ee4":"Nombre de usuario de la base de datos MySQL","TXT_CODE_92bedafa":"Compresión del tráfico de red al cliente Bedrock Edition. \\nCuanto mayor sea el número, mayor será el uso de la CPU pero menor será el ancho de banda utilizado. \\nPor debajo de -1 o 9 no tiene ningún efecto. \\nEstablezca en -1 para desactivar.","TXT_CODE_92c21a08":"Ya sea para conectarse a un servidor Java sin establecer una conexión TCP.","TXT_CODE_92ebdc7f":"Todos los archivos ZIP comprimidos por el panel se empaquetarán en codificación UTF-8. Si necesita descomprimirlos, seleccione la codificación UTF-8 para descomprimirlos.","TXT_CODE_930d2524":"Conexión directa a la página web.","TXT_CODE_93191a82":"Transmite los mensajes de muerte en el chat solo con el jugador afectado","TXT_CODE_931e4c8":"La velocidad en la que un caldero se llena de lluvia (depende de la garrapata aleatoria)","TXT_CODE_9337bed1":"Parece que no hay nodos remotos aquí. ¡Quizás haya un problema durante el proceso de instalación reiniciando su panel y los nodos remotos pueden resolverlo!","TXT_CODE_9341498a":"radio de actualización","TXT_CODE_93610b08":"Hace que este montaje de la mafia sea capaz de agua (no te expulsa)","TXT_CODE_9364ec40":"El número máximo de animales despertados por garrapata.","TXT_CODE_937b42e6":"Multiplicador de agotamiento de la barra de hambre de Sprint","TXT_CODE_9393b484":"asignar instancia","TXT_CODE_9394aadf":"Si expulsar a los jugadores cuando superen el umbral de TileLiquid","TXT_CODE_93a70cda":"Parámetros requeridos de la tarjeta","TXT_CODE_93afb039":"Se dirige a MC-3304 evitando que el saqueo se aplique a las muertes causadas por un proyectil, a menos que si un complemento cambió el modificador de saqueo.","TXT_CODE_93c3cb78":"Para que esta dirección funcione, puede que necesites configurar las asignaciones de conexión directa del nodo.","TXT_CODE_93d4b66a":"Se inicia la tarea de operación de archivos. Si hay demasiados archivos, llevará algún tiempo.","TXT_CODE_93f9b02a":"Dirección IP del nodo remoto","TXT_CODE_94002354":"Evite que los jugadores inicien sesión usando su UUID de cliente","TXT_CODE_941d83b8":"Prefijo de ruta","TXT_CODE_9466852b":"Esta tarjeta se puede utilizar para la segmentación de columnas, de forma similar a los títulos de los artículos escritos, y se puede utilizar para el diseño.","TXT_CODE_946d4401":"Si patear al jugador cuando el jugador excede el umbral del proyectil","TXT_CODE_94b6cd6e":"Configure su host obligatorio aquí.","TXT_CODE_94bb113a":"tamaño","TXT_CODE_94bcd51b":"Frecuencia de actualización del bloque colgante","TXT_CODE_94c193de":"Nombre del archivo","TXT_CODE_94d4c80c":"Ya sea para evitar que los jugadores de Bedrock Edition hagan andamios.","TXT_CODE_94d885d1":"Establezca esto en verdadero para habilitar la muestra de información de depuración sobre los atributos en un elemento cuando las información sobre herramientas avanzadas están activadas.","TXT_CODE_94f1ba3":"Después de seleccionar esta plantilla, se eliminarán todos los datos de esta instancia. Primero comprima y descargue la copia de seguridad del archivo en la administración de archivos.","TXT_CODE_94f55150":"Editor visual de plantillas predefinidas","TXT_CODE_950c0d7a":"Velocidad de crecimiento de la vid retorcida","TXT_CODE_952c2697":"Aumentar o disminuir el porcentaje para que el rango de detección de la mafia sea más pequeño o más grande cuando un jugador usa la cabeza de las turbas correspondientes","TXT_CODE_95340802":"Si expulsar a los jugadores incondicionales","TXT_CODE_9535104c":"Establezca en falso para evitar que la enredadera de duelo.","TXT_CODE_95495db":"trabajo de archivo","TXT_CODE_95583336":"Servidor Minecraft Edición Java","TXT_CODE_958fd70c":"Descripción del perfil","TXT_CODE_95b08ec3":"Hace que la enredadera explote cuando se mata","TXT_CODE_95b9833f":"Regresar a la consola","TXT_CODE_95bdc950":"Un identificador uniforme de recursos (URI) apunta a un paquete de recursos. \\nLos jugadores pueden elegir si usar","TXT_CODE_95c5e900":"El nombre completo de la imagen, por ejemplo: openjdk:17","TXT_CODE_95c65dc1":"Establecido en True para las ovejas para evitar el Gamérulo de duelo de la mafia","TXT_CODE_95d43994":"El nivel mínimo del encantamiento de SilkTouch requerido para recoger desovadores minados","TXT_CODE_95df80df":"Hay una interfaz más profesional disponible para su uso.","TXT_CODE_95dfd5bd":"MP máximo que un jugador puede tener antes de mejorar el equipo","TXT_CODE_96281410":"camino no encontrado","TXT_CODE_962d9320":"El directorio de trabajo donde se ejecuta la instancia, puede completar la ruta absoluta y la ruta relativa","TXT_CODE_962f4288":"Tamaño de caché del usuario","TXT_CODE_9651d0b3":"El daño se multiplica por velocidad si el vuelo es más rápido que la velocidad establecida. \\nEl valor de 0 deshabilita este multiplicador","TXT_CODE_96520bce":"El número máximo de cabezas personalizadas mostradas por jugador.","TXT_CODE_965360cd":"Generar radio de protección","TXT_CODE_9654b91c":"¿Está seguro de que desea cerrar la sesión del usuario actual?","TXT_CODE_96c02044":"Porcentaje de posibilidades (0.0 - 1.0) Esta mafia generará agresiva hacia los jugadores","TXT_CODE_96e6bf5d":"Radio del efecto de sonido del portal final","TXT_CODE_9740f199":"Se perderá el diseño actual. ¿Quieres continuar?","TXT_CODE_97433ac4":"Más información","TXT_CODE_97535446":"Cambia el nombre del jugador utilizado en el chat aéreo. \\nComienza con el nombre del jugador entre corchetes, en el mismo formato que Terraria. \\nEl mismo formato que ChatFormat, pero sin el mensaje.","TXT_CODE_97655c5d":"Se utiliza para permitir que los contenedores accedan entre sí en una red personalizada, separados por espacios.","TXT_CODE_9775ccb":"¿Estás seguro de que quieres cambiar al modo oscuro?","TXT_CODE_977cb449":"Esperando que se complete la descarga del evento...","TXT_CODE_978491ec":"El tiempo de conexión expiro","TXT_CODE_978da1c1":"Bajo construcción","TXT_CODE_979b9aaf":"Deshabilite las máscaras personalizadas por jugadores fuera de la tienda de Minecraft o de los recursos del juego.","TXT_CODE_97b80a79":"Si MineCarts se puede colocar en cualquier lugar, no solo en Rails","TXT_CODE_97be50a8":"¡Ya terminaste!","TXT_CODE_97ceb743":"Seleccione la codificación de descompresión","TXT_CODE_97d17cce":"Lista de usuarios","TXT_CODE_97e5eccb":"Se utiliza para mostrar detalles de una instancia específica.","TXT_CODE_97f5701e":"Si el jugador puede volar (en cualquier modo de juego)","TXT_CODE_97f5d91f":"¿Qué tan rápido se le permite al cliente conectarse después de la última conexión? \\nPor defecto, son tres segundos. \\nDeshabilite esta función configurándola en 0.","TXT_CODE_97f779b3":"Servidor de edición MC Java","TXT_CODE_97ff044f":"Habilitar bloques de comando","TXT_CODE_981c59e6":"Los loros no se ven afectados por el movimiento del jugador.","TXT_CODE_9867da6b":"Si el servidor muestra una advertencia cuando un complemento registra un evento obsoleto","TXT_CODE_98742e5f":"El color del Bossbar","TXT_CODE_9878c2bc":"De forma predeterminada, Velocity intentará manejar con elegancia la pérdida inesperada de la conexión de un usuario al servidor en lugar de desconectarla.","TXT_CODE_9885543f":"No se pudo inicializar la consola. Es posible que el nodo o la instancia remota ya no exista. Actualice la página web y vuelva a intentarlo.","TXT_CODE_98b4ac74":"Mc-neoforge","TXT_CODE_98dbd049":"Se sugiere no superar 3 líneas","TXT_CODE_98e50717":"Archivo de configuración para el propósito. \\nPermite una mayor configuración de parámetros avanzados y configuraciones de juego más específicas. \\nAfecta en gran medida el rendimiento general y se expande sobre las limitaciones del archivo de configuración en papel.","TXT_CODE_98e7c829":"Déjelo vacío para usar el comando de imagen predeterminado de Docker","TXT_CODE_9900f79e":"fotos","TXT_CODE_9901af98":"Etiquetas (Opcional)","TXT_CODE_9911ac11":"Error al guardar, verifique la configuración","TXT_CODE_99167cda":"Si MineCarts se puede controlar cuando no está en Rails","TXT_CODE_992bf9bc":"MC Bukit","TXT_CODE_998d1dec":"Bloquear multiplicador de otoño para cama naranja","TXT_CODE_99a42341":"ej: https://example.com/image.png","TXT_CODE_99ca8563":"sobrescribir archivo","TXT_CODE_99e98174":"Cuente todas las criaturas para desovar.","TXT_CODE_99f8edf0":"Establecer en verdadero para establecer can_summon en verdadero en la colocación","TXT_CODE_99fab05d":"Si explotan los anclajes de reaparición. \\nEstablecer esto en falso solo hace que los anclajes de reaparición se salgan de la existencia","TXT_CODE_9a6e35e4":"Deshabilitar la interacción del jugador","TXT_CODE_9aa1872c":"Lista de elementos que son inmunes a los rayos","TXT_CODE_9aa83c05":"Por defecto, hereda y utiliza el usuario del sistema de LaunchPad","TXT_CODE_9ab6fd":"Usuario <<operator_name>> creado la instancia <<instance_name>>","TXT_CODE_9ac035d0":"Configuración de privacidad del nombre del servidor","TXT_CODE_9ac051fb":"Marca elementos en espacios no disponibles en los inventarios de los jugadores de Bedrock Edition.","TXT_CODE_9ade0fb8":"Error al establecer permisos de archivo 7zip: {{message}}","TXT_CODE_9afe56de":"Tasa de carga","TXT_CODE_9b36d5a2":"[General] propiedades del servidor","TXT_CODE_9b3ce825":"Descripción del proxy inverso","TXT_CODE_9b45858c":"Instale rápidamente aplicaciones utilizando plantillas preestablecidas","TXT_CODE_9b4985d3":"¡Instancia actualizada con éxito!","TXT_CODE_9b5dcfdd":"Número de muestras","TXT_CODE_9b8f02fd":"algoritmo de compresión","TXT_CODE_9b99b72e":"Implemente rápidamente instancias de aplicaciones","TXT_CODE_9b9b745c":"Crear una imagen de entorno OpenJDK 17","TXT_CODE_9bb2f08b":"Informacion del usuario","TXT_CODE_9bc7f49e":"El número de instancias que no están operativas.","TXT_CODE_9c188ec8":"Visite https://docs.mcsmanager.com para obtener más información.","TXT_CODE_9c2250b7":"Establecer en True para arreglar los elementos modificados por NetworkItemSerializeEvent que persisten a pesar de que están al cliente debido a que el cliente creativo utilizan acciones de inventario creativo","TXT_CODE_9c247f6":"Montaje del directorio de trabajo del contenedor","TXT_CODE_9c39c7ae":"Si mostrar mensajes de chat sobre la cabeza del jugador","TXT_CODE_9c3ca8f":"Configuraciones de seguridad","TXT_CODE_9c7f8eb8":"Qué tan efectiva es la reparación para reparar artículos, los valores más altos significan menos XP para reparar elementos. \\n(1.0 = 100%)","TXT_CODE_9c95b60f":"Mensaje de error:","TXT_CODE_9c9c19f0":"Mantener el punto de generación cargado","TXT_CODE_9cae6f92":"¡Se agotó el tiempo de descarga de la imagen! \\nSolo podemos esperar hasta 15 minutos, ¡verifique su red!","TXT_CODE_9cefd73":"Guardar automáticamente","TXT_CODE_9d1d244f":"Error al iniciar el programa, los flujos de entrada y salida son ilegibles: {{pipeName}}","TXT_CODE_9d2fca76":"No reiniciar automáticamente si se alcanza el conteo de reinicios. (Establecer en -1 para sin límite)","TXT_CODE_9d498b20":"Configuración exitosa, guárdela para aplicar los cambios","TXT_CODE_9d820cb4":"Detalles de la información","TXT_CODE_9d8e6107":"Permitir que los jugadores usen clientes potenciales en los aldeanos (comerciante no incluido)","TXT_CODE_9d902725":"¿En qué nivel de dificultad el piglin zombificado romperá la puerta?","TXT_CODE_9d982f06":"Si se debe habilitar el seguimiento de IP","TXT_CODE_9dc4ee75":"Establecido en True For Powdered Snow para evitar el Gamérulo de duelo de la mafia","TXT_CODE_9df0f923":"semillas oceánicas","TXT_CODE_9df68e04":"Evitar la carga de complementos con API incompatibles","TXT_CODE_9df98e2":"Configuración de edificios ...","TXT_CODE_9e090ff6":"¿Cuánto expulsar la muerte? \\nLas variables NMS disponibles son Explevel, ExpTotal y Exp.","TXT_CODE_9e1657b":"Multiplicador de otoño de bloque para la cama rosa","TXT_CODE_9e33445e":"Haga clic con el botón derecho en un esqueleto mientras sostiene una Rose de marchitamiento convertirá el esqueleto en un esqueleto de marchitamiento. \\nCon el valor de cuántas rosas Wither necesitaría convertir el esqueleto, y 0 significa que la función está deshabilitada.","TXT_CODE_9e3f25e0":"Servidor de juegos Minecraft Edición Java","TXT_CODE_9e5eb2a":"Escanear para que los pollos existentes generen","TXT_CODE_9e8c176e":"Se utiliza para ver registros de operación de usuario","TXT_CODE_9e9c0179":"¿Cuánto tiempo debe el retraso de una gran gotea hasta que llegue a la próxima animación?","TXT_CODE_9e9d3767":"Si se dedica a actividades comerciales de alquiler, asegúrese de que la instancia de la aplicación se ejecute en un contenedor virtual Docker de Linux; de lo contrario, habrá riesgos de seguridad.","TXT_CODE_9eacb622":"Método de inicio del viaje","TXT_CODE_9eb5dd12":"Multiplicador de otoño de bloque para la cama magenta","TXT_CODE_9ef27367":"eliminar completamente","TXT_CODE_9f174887":"Leer disco","TXT_CODE_9f28d67b":"El tipo de generación del mapa (predeterminado: plano, súper plano: amplificado, biomas grandes: biomas grandes)","TXT_CODE_9f4eaa41":"Seleccione un tipo de juego","TXT_CODE_9fb9e6a8":"Establecer en falso para evitar que los bebés sean ridículas","TXT_CODE_9fd05002":"Establecer si una abeja debería morir después de aguantar","TXT_CODE_9fe98f3":"puerto de escucha","TXT_CODE_9fed23ab":"Por favor ingresa el nombre de la imagen","TXT_CODE_A0000001":"Adecuado para comandos de inicio de cualquier programa de consola, no se admiten archivos de script;<br />Por ejemplo: \\"C://Archivos de programa/Java/bin/java.exe\\" -Dfile.encoding= utf-8 -Djline.terminal =jline.UnsupportedTerminal -jar my server.jar -nogui <br/>Si usa un contenedor Docker, no necesita completar el comando de inicio y comenzará a usar el comando definido por la imagen.","TXT_CODE_ETA":"ETA","TXT_CODE_Instance_router.accessFileErr":"El archivo no existe o la ruta es incorrecta. Se deniega el acceso al archivo.","TXT_CODE_Instance_router.cancelIO":"La sesión {{id}} solicitó la cancelación de la instancia de reenvío {{targetInstanceUuid}} flujo de IO","TXT_CODE_Instance_router.openInstanceErr":"Error al iniciar la instancia {{instanceUuid}}:","TXT_CODE_Instance_router.performTasks":"La sesión {{id}} requiere la instancia {{uuid}} para realizar la tarea asincrónica {{taskName}}","TXT_CODE_Instance_router.performTasksErr":"Instancia {{uuid}} {{taskName}} Excepción de ejecución de tarea asincrónica: {{err}}","TXT_CODE_Instance_router.requestIO":"Sesión {{id}} Instancia de reenvío de solicitudes {{targetInstanceUuid}} flujo de E/S","TXT_CODE_Instance_router.taskEmpty":"No se están ejecutando tareas asincrónicas","TXT_CODE_Instance_router.terminalLogNotExist":"El archivo de registro de la consola no existe","TXT_CODE_Speed":"Velocidad","TXT_CODE_a00e84d7":"Eliminado","TXT_CODE_a02a0849":"Este valor define con qué frecuencia en las garrapatas, la entidad más alejada obtendrá sus caminos y comportamientos.","TXT_CODE_a0451c97":"Cancelar","TXT_CODE_a08f261e":"Si se debe habilitar el desove del portal de piglins zombies","TXT_CODE_a092b6f0":"Lista de elementos que son inmunes al cactus","TXT_CODE_a0a00fc0":"Permita que MineCarts dañe/rompa los huevos de tortuga","TXT_CODE_a0a77be5":"No se puede ejecutar, seleccione al menos una instancia","TXT_CODE_a0a99beb":"Da loros la capacidad de reproducirse usando cualquier tipo de semillas (los loros de los bebés no existen d :, por lo que salen los loros \'adultos\')","TXT_CODE_a0d214ac":"Por ejemplo, 1024, 2048, etc., no agregue unidades.","TXT_CODE_a0e19f38":"Eliminar instancia","TXT_CODE_a0e70887":"Versión de nodo correspondiente","TXT_CODE_a0eb8b37":"Desactivar efectos de hielo y nieve.","TXT_CODE_a0ede210":"Programa 7zip no encontrado","TXT_CODE_a106108c":"Subir archivos de música","TXT_CODE_a112cff4":"Establecimiento de prioridades","TXT_CODE_a132c796":"Permita que Exp Orbs dañe/rompa los huevos de tortuga","TXT_CODE_a1587e9d":"Si el servidor registra la dirección IP del jugador.","TXT_CODE_a1833a27":"El valor base para establecer el daño de ataque del Magma Cube","TXT_CODE_a1a59b08":"Idioma del panel","TXT_CODE_a1cc8b68":"¿Pueden los caballos zombies nadar en agua? \\nFalse los hace hundirse hasta el fondo (Vanilla predeterminado)","TXT_CODE_a1d885c1":"Nuevo","TXT_CODE_a1e4c720":"Permite la capacidad de aumentar los encantamientos pasados ​​por su nivel máximo a través del comando","TXT_CODE_a22e749a":"Deshabilitar los golpes críticos del jugador","TXT_CODE_a2544278":"etiqueta de instancia","TXT_CODE_a2a0e054":"Por ejemplo: server.exe, app.exe o utilizar ruta absoluta, etc.","TXT_CODE_a2c8c88a":"Distancia para dejar de cargar trozos (valores permitidos: 4, 12)","TXT_CODE_a379038f":"Puerto de servicio","TXT_CODE_a3991784":"Cambie la precisión con la que los esqueletos disparan. \\nEl resultado de la fórmula es la divergencia (propagación). \\nCuanto mayor sea el valor, menos preciso es el disparo.","TXT_CODE_a3abb092":"Velocidad MC","TXT_CODE_a3de630":"Ingrese el código de canje utilizado para la compra","TXT_CODE_a3efb1cc":"Importar paquete comprimido","TXT_CODE_a3f13157":"Protección de contenedores","TXT_CODE_a3f8313f":"Área de bloques que una esponja absorbe agua","TXT_CODE_a4037a98":"Estado del volumen de solicitud de interfaz","TXT_CODE_a409b8a9":"Parada","TXT_CODE_a41a4820":"Tiempo de verificación de puntos de interés cerca de los aldeanos","TXT_CODE_a42984e":"nombre de la variable","TXT_CODE_a463be37":"El formato de BossBar cuando el servidor ejecuta el comando /Compass","TXT_CODE_a4748cb0":"Ingrese el puerto del protocolo RCON del servidor de juegos, que generalmente se encuentra en el archivo de configuración.","TXT_CODE_a4757fec":"Permisos de grupo de usuarios administradores","TXT_CODE_a48bdb09":"Cantidad de bloques El rango de efecto alcanza este nivel","TXT_CODE_a492ae63":"Empezar a encuadernar","TXT_CODE_a4efbd21":"Permitir que los reproductores sean desactivados por Redstone","TXT_CODE_a519b5ff":"Habilitar colisión de jugadores","TXT_CODE_a53573af":"Actualizar lista","TXT_CODE_a5830778":"Por favor ingresa un nuevo nombre","TXT_CODE_a583cae4":"Permitir a los usuarios normales editar la configuración avanzada de instancia","TXT_CODE_a584cb71":"Especificar imagen de instancia","TXT_CODE_a59981f4":"Dejar en blanco hasta el infinito","TXT_CODE_a5bdf2d8":"Bloquear multiplicador de otoño para la cama cian","TXT_CODE_a5f01916":"Permitir que los usuarios generales utilicen la función de plantilla de instancia","TXT_CODE_a5f7d835":"zombi","TXT_CODE_a621f370":"Domingo","TXT_CODE_a62886b9":"Error al leer archivo","TXT_CODE_a6424dcc":"El directorio de trabajo o el comando de inicio no pueden estar vacíos","TXT_CODE_a6453188":"Por favor seleccione el modo de descompresión","TXT_CODE_a64da7c4":"reinicio automático","TXT_CODE_a64f3007":"Abrir la cremallera","TXT_CODE_a65c65c2":"Por lo tanto, debe evitar el uso de cualquier IP en el segmento de la red local que no sea localhost y debe usar una IP o dominio externo para la conexión.","TXT_CODE_a66ea585":"Daño de ataque máximo","TXT_CODE_a674a475":"La cantidad de inconsistencias de datos requeridas antes de informar un comportamiento inusual","TXT_CODE_a676f2da":"Entiendo","TXT_CODE_a6878a01":"Limite la cantidad de actualizaciones consecutivas antes de omitir otras actualizaciones. \\nLos valores negativos eliminan las restricciones.","TXT_CODE_a68b3a9c":"Máxima memoria de desove","TXT_CODE_a6a04fa3":"Ya sea para generar aldeanos","TXT_CODE_a6f5af58":"semillas de mazmorra","TXT_CODE_a6f8f61a":"Permitir la visualización de cabezas personalizadas.","TXT_CODE_a725a5b1":"Mensaje que muestra cuándo el TPSBAR está habilitado para un usuario utilizando el comando /tpsbar.","TXT_CODE_a77b1a21":"La diferencia de tiempo máxima permitida entre los dispositivos cliente y el servidor al generar y verificar códigos TOTP.","TXT_CODE_a7813c72":"Establecer en True for the Ender Dragon para evitar el Gamérulo de duelo de la mafia","TXT_CODE_a7885cbc":"Controla la preferencia del contenedor por usar páginas de memoria virtual, que van desde 0 a 100. Los valores más altos hacen que el núcleo sea más probable que cambie las páginas de memoria para liberar la memoria física.","TXT_CODE_a788e3eb":"Memoria/Procesador","TXT_CODE_a7907771":"Guardado exitosamente","TXT_CODE_a7aa53a3":"Establece el servidor para usar para perfiles.","TXT_CODE_a7c73a51":"7zip cargado exitosamente: {{info}}","TXT_CODE_a7c85e67":"Agregar hipervínculo","TXT_CODE_a7e1976":"La cantidad de daño a tomar después de teletransportarse usando una perla ender","TXT_CODE_a7e9d4e":"Cierra esta ventana","TXT_CODE_a7e9ff0f":"punto","TXT_CODE_a7f6b0e0":"Información sobre el límite de recursos del contenedor","TXT_CODE_a85091a4":"Asignación automática predeterminada","TXT_CODE_a8839b35":"Una vez que se habilita el protocolo Rcon, todos los comandos ingresados ​​en la consola se enviarán en RCON y ya no serán compatibles con el programa de la consola original.","TXT_CODE_a884de59":"Información de la nota","TXT_CODE_a89ab67c":"Número máximo de jugadores conectados.","TXT_CODE_a8a375ae":"Controla si los elementos sobrecargados están permitidos en las cajas de Shulker (arreglos predeterminados de la prohibición del fragmento Papermc/Paper","TXT_CODE_a8b0dfab":"Realice un cálculo de 2x 1 en este valor para determinar el radio de protección del punto de generación. Establecerlo en 0 solo protegerá el bloque debajo del punto de generación. \\nA partir de la versión 1.5, establecer en 0 o un valor negativo deshabilita la protección de compilación.","TXT_CODE_a8b245fa":"La inicialización de algunos módulos falló. Compruebe si los archivos en daemon/lib existen o si los permisos son normales.","TXT_CODE_a8b402a9":"Habilitar el registro de depuración","TXT_CODE_a8f82885":"Modificador de altura de Ump. \\nEl valor predeterminado de 1.0 hace que los gigantes salten tan alto como su cintura","TXT_CODE_a8fe5e68":"Atributo de velocidad de movimiento máximo","TXT_CODE_a92a298e":"tasa de crecimiento de cactus","TXT_CODE_a92a4aa1":"Aplicación de consola universal","TXT_CODE_a92df201":"ilimitado","TXT_CODE_a94e89ef":"Salida del marcador de posición <Seconds> en Command.uptime.Format Opción","TXT_CODE_a95c0f85":"Ingrese el código, por ejemplo: 2WJBUHJUD0VV5SYMC0F3HFFH","TXT_CODE_a9bcbde9":"El campo debe ser numérico.","TXT_CODE_a9c9d05e":"Establecido en falso para evitar que la fogata se encienda cuando se coloca","TXT_CODE_aa373641":"Por favor seleccione nodo","TXT_CODE_aa43b248":"Ingresar a la consola","TXT_CODE_aa47f5ed":"Establezca la altura de paso predeterminada de los estandos armadores. \\nÚtil para complementos que utilizan paradas de armadura como vehículos para poder conducir sobre bloques sin saltar, etc.","TXT_CODE_aaba7ab8":"Deja que las turbas/jugadores pasen a los jugadores si el jugador está en el agua","TXT_CODE_aac98b2a":"Aplicar configuración de instancia","TXT_CODE_aadfb5c0":"Ya sea para recordar a las consolas y a los operadores que hay una nueva versión de Geyser que es compatible con la versión Bedrock y que esta versión de Geyser no es compatible con la versión Bedrock.","TXT_CODE_aae2918f":"El proceso de instancia no pudo iniciarse. Verifique el comando de inicio y la configuración del entorno operativo.","TXT_CODE_aae43e39":"Establecer en True para que los prestamistas eluden el Gamérulo de duelo de la mafia","TXT_CODE_aaecb7ff":"Lista de anulaciones de velocidad por tipo de bloque","TXT_CODE_ab4504ca":"Control si los ilussusers se desarrollan naturalmente en el juego","TXT_CODE_ab483b69":"Permita que el suelo humedezca del agua directamente debajo de él","TXT_CODE_ab4cc2dc":"Acuerdo de usuario final del software, este acuerdo debe configurarse para aceptar; de lo contrario, el software del servidor no se puede activar","TXT_CODE_ab4d93":"Muestra solicitudes de ping de los clientes.","TXT_CODE_ab5d758e":"Búsqueda de entidades de colisión de soporte blindado","TXT_CODE_ab7672dd":"Longitud mínima de contraseña para nuevas cuentas de jugadores. \\nno puede ser menor que 4","TXT_CODE_ab839970":"¿Está habilitada la velocidad?","TXT_CODE_ab90dc44":"Establecer en True para deshabilitar el pisoteo por completo.","TXT_CODE_ab9f8bfb":"Los cristales de radio escanean los fantasmas para atacar. \\nValor de 0 Desactiva la función","TXT_CODE_abac12f6":"La compensación de proyectil de un ender-perl","TXT_CODE_abadb770":"La cantidad de daño para aplicarse a las turbas hostiles cada 2 segundos si están en contacto con agua/lluvia","TXT_CODE_abc080d":"Sin límite de tiempo","TXT_CODE_abd2f7e1":"Restablecer diseño de tarjeta","TXT_CODE_abe0862e":"Se utiliza para mostrar información detallada y el estado de los nodos remotos.","TXT_CODE_abedfd03":"Deseleccionar","TXT_CODE_abfe9512":"ahorrar","TXT_CODE_ac01315a":"¿Está seguro de que desea continuar con la eliminación del lote? \\nEsta operación no elimina los archivos de instancia reales, solo la instancia","TXT_CODE_ac0754f7":"Controla si las abejas pueden funcionar durante el clima lluvioso","TXT_CODE_ac10fe01":"Ingrese la URL de la plantilla","TXT_CODE_ac225d07":"Parámetros de instancia de paquete de compilación:","TXT_CODE_ac405b50":"Error","TXT_CODE_ac52ad06":"Exigir eventos exclusivos de Halloween durante todo el año","TXT_CODE_ac696f4d":"Si los complementos deben mostrarse en las respuestas a las consultas de forma predeterminada.","TXT_CODE_ac7a5f17":"Establezca el amplificador para el efecto de resistencia al fuego","TXT_CODE_acabc771":"Segundo","TXT_CODE_acd4abda":"Implemente rápidamente usando imágenes de Docker","TXT_CODE_ad14bcf3":"Este archivo de configuración es el archivo de configuración principal del servidor dedicado Bedrock Edition. La mayoría de las configuraciones del servidor Bedrock Edition se establecen en este archivo de configuración, como el puerto del servidor, la cantidad de personas, la línea de visión y los parámetros de restricción, etc.","TXT_CODE_ad1c674c":"acuerdo","TXT_CODE_ad207008":"Editar","TXT_CODE_ad24269a":"Seleccione un nodo disponible.","TXT_CODE_ad30f3c5":"Número de salidas:","TXT_CODE_ad40abfb":"Ocultar metadatos de elementos con efectos visuales","TXT_CODE_ad5107bc":"Configuración del grupo de permisos","TXT_CODE_ad533c70":"La contraseña debe tener entre 9 y 36 caracteres y contener letras y números mayúsculas y minúsculas.","TXT_CODE_ad5e2b0f":"Dirección del enlace","TXT_CODE_ad6c5d03":"¿Cuántos tics para despertar a los monstruos voladores?","TXT_CODE_adab942e":"Permitir que los usuarios generales utilicen funciones de administración de archivos","TXT_CODE_adcce2c7":"Espere hasta que se haya cambiado a un aldeano antes de lobotomizar","TXT_CODE_addfcb6b":"Sí","TXT_CODE_ae09d79d":"subir","TXT_CODE_ae0e0126":"Establecer en falso para evitar que los tamables indométicos sean ridiculizantes","TXT_CODE_ae441ea3":"¡La ruta de montaje adicional del contenedor de instancias está configurada incorrectamente! \\n¡Por favor, compruebe!","TXT_CODE_ae51f93b":"¡Éxito de renovación!","TXT_CODE_ae533703":"Gestión de archivos","TXT_CODE_ae566b56":"Optimiza la verificación de asfixia omitiendo selectivamente el cheque de una manera que aún aparece vainilla. \\nEsto debe dejarse habilitado en la mayoría de los servidores, pero se proporciona como una opción de configuración si la desviación de vainilla es indeseable.","TXT_CODE_ae575e12":"Si está utilizando el panel de acceso de proxy inverso, active esta opción. \\nEl panel obtendrá la IP real del \\"X-Real-IP\\" en el encabezado de la solicitud.","TXT_CODE_ae747cc0":"Tiempo de expiración:","TXT_CODE_aea11899":"Solo colisión de jugadores","TXT_CODE_aeb10fea":"Utilice el mismo puerto de conexión que Java Edition","TXT_CODE_af11ca2a":"Tasa máxima de generación de bloques del jugador","TXT_CODE_af143e18":"reloj","TXT_CODE_af19b7b5":"En términos generales, el valor predeterminado puede cumplir con escenarios de uso diario personal. Si la escala aumenta, los requisitos de hardware serán mayores. Para no perder excesivamente la experiencia del usuario, un umbral adecuado es muy importante.","TXT_CODE_af1f921d":"Si no lo completa, el valor original no se cambiará. Después de restablecer la contraseña del usuario, 2FA también se restablecerá en consecuencia.","TXT_CODE_af21e6b":"Versión panel","TXT_CODE_af28bbfd":"El dragón ender siempre genera un huevo de dragón cuando muere.","TXT_CODE_af2a6972":"Haga clic en el botón \\"He terminado de escanear\\".","TXT_CODE_afabf3ca":"Error en el tiempo de análisis","TXT_CODE_afb12200":"Contenedorización","TXT_CODE_afb7259b":"El formato de contenido que se muestra en la lista TAB de reproductores conectados al servidor.","TXT_CODE_afc104e0":"El desplazamiento de proyectil de un tridente","TXT_CODE_afd43f2":"Salida detallada de los tiempos","TXT_CODE_afde4995":"La dificultad local debe ser mayor que un valor aleatorio elegido entre 0.0 y este valor","TXT_CODE_all_platform":"Todas las plataformas","TXT_CODE_app.addr":"Dirección de acceso: http://<dirección IP>:{{puerto}}/ o ws://<dirección IP>:{{puerto}}","TXT_CODE_app.configPathTip":"Archivo de configuración: datos/Config/global.json","TXT_CODE_app.developInfo":"No se puede iniciar. Este proyecto lo utilizan los desarrolladores de MCSManager y los usuarios generales no pueden operarlo directamente.\\n\\nVaya a https://mcsmanager.com/ para conocer los métodos de instalación más recientes.\\n\\nSi desea ejecutar en modo de desarrollo, cree un directorio público, src/public, coloque los archivos estáticos del front-end y ejecútelo nuevamente.","TXT_CODE_app.doc":"Documento de referencia: https://docs.mcsmanager.com/","TXT_CODE_app.exitTip":"Puede utilizar la tecla de acceso directo Ctrl C para cerrar el programa.","TXT_CODE_app.host":"Dirección de acceso: http://localhost:{{port}}","TXT_CODE_app.httpSetupError":"Hay un error al iniciar el servicio HTTP/Socket. Es posible que el puerto de conexión esté ocupado, los permisos sean insuficientes o el dispositivo de la tarjeta de red no esté disponible.","TXT_CODE_app.instanceLoad":"Todas las instancias de aplicaciones cargadas, total {{n}}","TXT_CODE_app.instanceLoadError":"No se pudo leer el archivo de instancia local:","TXT_CODE_app.panelStarted":"El lado del panel ha sido iniciado.","TXT_CODE_app.password":"Clave de acceso: {{key}}","TXT_CODE_app.passwordTip":"Como único método de autenticación, utilice la función de nodo del panel MCSManager para conectar el programa.","TXT_CODE_app.portTip":"El acceso a la red pública de software requiere abrir el puerto {{port}} y el puerto de conexión del demonio","TXT_CODE_app.reference":"Referencia del proyecto: https://github.com/mcsmanager","TXT_CODE_app.sessionConnect":"La sesión {{ip}} {{uuid}} está conectada","TXT_CODE_app.sessionDisconnect":"La sesión {{ip}} {{uuid}} ha sido interrumpida","TXT_CODE_app.started":"El demonio ahora se ha iniciado con éxito.","TXT_CODE_app.sysinfo":"informe de recursos","TXT_CODE_app.welcome":"Bienvenido al demonio MCSManager","TXT_CODE_auth_router.access":"Sesión {{id}}({{address}}) Verificación de identidad exitosa","TXT_CODE_auth_router.disconnect":"La sesión {{id}}({{address}}) se desconectó debido a un largo período de identidad no verificada.","TXT_CODE_auth_router.illegalAccess":"Acceso no autorizado","TXT_CODE_auth_router.notAccess":"La sesión {{id}}({{address}}) intentó acceder no autorizado a {{event}} y ahora está bloqueada.","TXT_CODE_b01f8383":"aprende más","TXT_CODE_b026be33":"Autenticación de Doble Factor (TOTP) Tolerancia a la Desviación del Tiempo","TXT_CODE_b029a155":"La instancia no podrá iniciarse después de su vencimiento.","TXT_CODE_b02f295d":"Ruta de configuración predeterminada para servidores","TXT_CODE_b05948d1":"Los permisos cambiaron exitosamente","TXT_CODE_b05c6947":"Permitir que las arañas crucen las fronteras del mundo","TXT_CODE_b078a763":"Disponible","TXT_CODE_b0794aeb":"El valor base para establecer el daño de ataque del fantasma","TXT_CODE_b08f61c5":"La cantidad de animales acuáticos que se pueden engendrar en cada mundo.","TXT_CODE_b09eea4":"monstruo","TXT_CODE_b09eff8f":"Crear una imagen de entorno OpenJDK 8","TXT_CODE_b0a18c20":"he terminado de escanear","TXT_CODE_b0aa2db9":"¡Cerrado!","TXT_CODE_b0ad88c4":"Si se debe habilitar el protocolo PROXY al conectarse al servidor.","TXT_CODE_b0ae5b42":"Si los jugadores de AFK tienen su nombre actualizado en la lista de pestañas (pone [AFK] delante de su nombre)","TXT_CODE_b0b67785":"Forzar la hora mundial a la hora normal, de día o de noche.","TXT_CODE_b0c4e4ae":"Especificar el núcleo de la CPU","TXT_CODE_b0e39fd":"Establecer en True para el marchitamiento para obtener la capacidad de montar vehículos","TXT_CODE_b0f5847f":"Mostrar rango de seguimiento de entidad","TXT_CODE_b0ff4172":"Carga de archivos {n} en segundo plano","TXT_CODE_b10cbef0":"Límite de abuso de la tabla de síntesis","TXT_CODE_b11166e7":"La instancia se está reiniciando","TXT_CODE_b12787d7":"Si permitir el inframundo (incluido el infierno)","TXT_CODE_b128afa6":"Por favor ingresa un nuevo título de tarjeta","TXT_CODE_b135e9bd":"Descarga ...","TXT_CODE_b1446a00":"Directorio de Trabajo dentro del Contenedor","TXT_CODE_b147fabc":"crear","TXT_CODE_b152cd75":"Por favor seleccione el archivo primero","TXT_CODE_b1600db0":"La instancia se está actualizando.","TXT_CODE_b16dc70c":"Esqueleto marchito","TXT_CODE_b16fc7a6":"Si se debe permitir que los jugadores utilicen un proxy de red para acceder al servidor","TXT_CODE_b18c34fd":"Porcentaje de posibilidades (0.0 - 1.0) Esta mafia generará refuerzos","TXT_CODE_b197be11":"Los datos se están cargando...","TXT_CODE_b19ed1dd":"reiniciar","TXT_CODE_b1b30b86":"Hace que el nombre sea visible al colocar con un nombre personalizado","TXT_CODE_b1d19033":"Modificar para cambiar las propiedades de los alimentos.","TXT_CODE_b1d709bc":"Si se muestran las direcciones IP en las que BungeeCord está escuchando","TXT_CODE_b1dedda3":"Cerca","TXT_CODE_b1e2e1b4":"Borrar salida de consola","TXT_CODE_b1ef1d4a":"Datos de archivo corruptos","TXT_CODE_b1f833f3":"Descargue la lista de fuentes al instalar rápidamente el servidor. Puede personalizar el sitio de descarga predeterminado del servidor cambiando esta dirección.","TXT_CODE_b1fd3eb1":"Configuración de reenvío de puertos","TXT_CODE_b214a52d":"Si se debe permitir que los jugadores se ataquen entre sí","TXT_CODE_b2391fca":"Seleccione una categoría secundaria","TXT_CODE_b23cc3e":"Opcional, no complete el valor predeterminado: /workspace/","TXT_CODE_b23e2bab":"tarjeta de marcador de posición","TXT_CODE_b251fa6d":"ID del nombre para mostrar del artículo","TXT_CODE_b26a0528":"Nodo de pertenencia","TXT_CODE_b2767aa2":"Configuración de plantilla predeterminada","TXT_CODE_b278707d":"Cuando descubra que el nombre del archivo está confuso al descomprimir/comprimir el archivo, puede modificar esta opción para resolver el problema.","TXT_CODE_b290a4b0":"Nombre de la tarea del proyecto","TXT_CODE_b2dbf778":"Si necesita acceder al panel a través de una aplicación de terceros, deberá utilizar esta clave para la verificación de identidad. Cualquier solicitud que utilice esta clave tendrá los mismos permisos que esta cuenta.","TXT_CODE_b2e9a60":"Establecido en verdadero para permitir que las esponjas absorban lava","TXT_CODE_b2f1310e":"Una opción de configuración principalmente para desarrolladores. \\nInicie etiquetas modificadas que están utilizando el espacio de nombres \'Forge\' cuando se ejecutan en el servidor integrado. \\nEl valor predeterminado a dev_short. \\nValores permitidos: silenciado, dev_short, dev_verbose, prod_short, prod_verbose","TXT_CODE_b30daa03":"Permitir CrimsonCreep cuando el mundo esté en modo difícil","TXT_CODE_b3127cba":"Color de chat para el grupo de superadministrador","TXT_CODE_b3190a77":"Ya sea para marcar a los aldeanos no activados","TXT_CODE_b329418":"La cantidad de lingotes de hierro requeridos para reparar un yunque","TXT_CODE_b32f926d":"Corrección del movimiento del bebé zombie.","TXT_CODE_b340c04a":"por favor sea paciente","TXT_CODE_b34efc1":"El manifiesto del contenedor representa todas las instancias de la aplicación que se ejecutan en un entorno de imagen independiente. El manifiesto aquí no solo incluye los contenedores iniciados por el panel.","TXT_CODE_b34f9eee":"máxima salud","TXT_CODE_b355c681":"Mensaje de expulsión que excede la velocidad de procesamiento de paquetes","TXT_CODE_b3581555":"La cantidad de rieles alimentados que se activan por una sola fuente de Redstone","TXT_CODE_b36320e1":"Establecer en True para mostrar siempre el elemento utilizado para matar al jugador en los mensajes de muerte del jugador.","TXT_CODE_b36630b3":"Bloquear multiplicador de otoño para la cama azul","TXT_CODE_b3796a8":"Salida del marcador de posición <Second> en Command.uptime.Format Opción","TXT_CODE_b37e6938":"Opcionalmente, agregue un mensaje personalizado que se mostrará en la ventana de solicitud del paquete de recursos cuando use require-resource-pack.","TXT_CODE_b3825da":"Procesando..","TXT_CODE_b3844cf8":"Cree una instancia directamente sin cargar ningún archivo. \\nConfigurarlo más tarde. \\nEsto es adecuado para usuarios experimentados.","TXT_CODE_b3cc1379":"Ingrese el código de renovación","TXT_CODE_b3e2f83e":"Esta tarjeta no tiene ningún contenido y puede usarse para ocupar espacio para lograr requisitos de diseño centrado.","TXT_CODE_b3ea8245":"Número máximo de colisiones de entidades","TXT_CODE_b3f2ea10":"Introduce la URL de la música.","TXT_CODE_b45e73fb":"La cantidad de segundos que el jugador debe esperar antes de reaparecer si hay un jefe cerca. \\nRango válido: 0 (predeterminado) a 30 segundos. \\nÚselo bajo su propio riesgo","TXT_CODE_b47dbe7d":"Controla cuántos fragmentos puede cargar un proyectil en su vida antes de que se elimine automáticamente.","TXT_CODE_b488372f":"todos","TXT_CODE_b4a9d04a":"Número de nodos en línea","TXT_CODE_b4d8588":"Versión del sistema","TXT_CODE_b5022f5d":"Reduce el selector de objetivos de IA en las garrapatas inactivas de la entidad.","TXT_CODE_b50ffba8":"La instancia ha sido iniciada ...","TXT_CODE_b51bac6f":"Para configurar una instancia usando una imagen de Docker, debe asegurarse de que Docker esté instalado correctamente.","TXT_CODE_b5253fae":"Permita que los artículos caídos dañen/rompan los huevos de tortuga","TXT_CODE_b52cb76c":"Por favor seleccione el modo de red","TXT_CODE_b5a0661a":"Título","TXT_CODE_b5a3a6ca":"Verificación genuina","TXT_CODE_b5a47731":"El administrador ha restringido el uso de la función de reinstalación de instancias por parte de usuarios generales.","TXT_CODE_b5afc7e":"El número máximo de jugadores que mostrará el cliente del jugador; el valor predeterminado es 1. \\nEste artículo es sólo para decoración y no tiene un número máximo real de jugadores.","TXT_CODE_b5b33dd4":"Visualización del texto de la página de inicio de sesión","TXT_CODE_b5c7b82d":"Ajustes","TXT_CODE_b5ca0563":"Le guiaremos en el uso y la implementación de su aplicación.","TXT_CODE_b5ce1069":"Bloquear la conexión de jugadores no softcore","TXT_CODE_b5e19c1":"Establecer en True For Rabbits para evitar la Gamérula de duelo de la mafia","TXT_CODE_b625dbf0":"Subiendo:","TXT_CODE_b642de88":"Límite máximo de jugadores del servidor","TXT_CODE_b649a71a":"Ordene eventos exclusivos de Navidad durante todo el año","TXT_CODE_b6697d36":"Cuando el cliente del jugador envíe la cantidad total de paquetes de datos, será expulsado. 0 significa cerrado.","TXT_CODE_b67197fc":"todos los usuarios","TXT_CODE_b69550bf":"antiguo usuario","TXT_CODE_b6ac7af4":"Usuario <<operator_name>> modificado la configuración del proceso de demonio <<daemon_id>>","TXT_CODE_b6ba38a4":"Establecer en true para los bloques de notas para continuar haciendo sonido incluso si hay un bloque encima de él","TXT_CODE_b6c675d6":"Ver información de suscripción","TXT_CODE_b6d926ab":"Permite que el tótem de la eterna trabaje en cualquier lugar de su inventario, no solo su poco","TXT_CODE_b6eb8851":"¿Los zombies atacan los huevos de tortuga?","TXT_CODE_b729d2e":"Puerto de conexión de contenedores","TXT_CODE_b72d638d":"Requerido y debe ser único.","TXT_CODE_b75e6388":"El formato que usa el marcador de posición <Time> para la salida de tiempo de impulso","TXT_CODE_b76d94e0":"actualizar","TXT_CODE_b7c8eb9f":"Razones por las que los jugadores incondicionales tienen prohibido morir","TXT_CODE_b7cab91d":"enviar comando","TXT_CODE_b7d026f8":"Tareas programadas","TXT_CODE_b7d38e78":"¡El nodo remoto no se puede utilizar! \\n¡Comuníquese con el administrador para verificar el estado del nodo remoto en la lista de nodos!","TXT_CODE_b7f19227":"Cambiar el rango en el que el pararrayos redirige Lightning","TXT_CODE_b8108d4d":"Ingrese el comando aquí y presione Enter para enviar.","TXT_CODE_b815f6f6":"Desactivar los efectos de residuos de reptiles.","TXT_CODE_b82225c3":"Descomprimiendo archivos, por favor espere...","TXT_CODE_b858d78a":"Copiado exitosamente","TXT_CODE_b862a158":"Uso de la CPU","TXT_CODE_b8814f15":"Puede ser que el panel no tenga permiso para acceder a este archivo. Puede intentar utilizar \\"Administración de archivos\\" para editar este archivo.","TXT_CODE_b89285d3":"Esto modifica el nombre del servidor que aparece cuando un cliente está desactualizado o cuando alguien abre la pantalla de depuración [F3]","TXT_CODE_b89780e2":"La versión del archivo de configuración es incorrecta y no se puede configurar la imagen de fondo. Intente reiniciar el panel o restablecer el diseño personalizado.","TXT_CODE_b8c40ce0":"Controlar TPS TPS","TXT_CODE_b90e9abd":"El código entra en vigor inmediatamente y se vincula al nombre de usuario correspondiente.","TXT_CODE_b916a8dc":"variables ambientales","TXT_CODE_b91a94f9":"Símbolo de retorno de carro de ejecución de instrucción","TXT_CODE_b9442311":"Parámetros adicionales","TXT_CODE_b946a322":"Memoria virtual adicional asignada en la parte superior de la memoria máxima. \\nUsar esta memoria es menos eficiente. \\nDeje en blanco para la asignación automática.","TXT_CODE_b94f13ce":"En la plataforma Windows, suele ser \\"retorno de carro y avance de línea\\", y en la plataforma Linux/MacOS, suele ser \\"avance de línea\\".","TXT_CODE_b99cae18":"Productos","TXT_CODE_b9af1460":"Minto cantidad de garrapatas de intervalo que reciben disparos","TXT_CODE_b9ca022b":"Instalando archivos de instancia, espere pacientemente...","TXT_CODE_b9d7fe43":"Requerir validación de token cuando se utilizan puntos finales de API REST públicos","TXT_CODE_b9fc604c":"Límite por solicitud HTTP, velocidad máxima de descarga de archivo","TXT_CODE_ba027d6c":"Comprimiendo archivos, espere pacientemente...","TXT_CODE_ba09da46":"Intentando iniciar el proceso infantil como usuario de Linux {{nombre}} ...","TXT_CODE_ba1a222b":"Permite a los jugadores colocar hielo donde no pueden construir.","TXT_CODE_ba1eb3b5":"Docker es un software de virtualización liviano que utiliza una imagen de entorno para crear un contenedor (como una caja) para envolver su aplicación real, lo que permite que su aplicación se ejecute en un entorno de pruebas virtual, independientemente de lo que haga la aplicación. cualquier archivo en la máquina host.","TXT_CODE_ba42d467":"URL web","TXT_CODE_ba497a8b":"tareas de intervalo","TXT_CODE_ba4f41ba":"Si se debe habilitar la salida detallada","TXT_CODE_ba717ff3":"Puede diseñar libremente el diseño, el orden y la visualización de la mayoría de los elementos de la página web.","TXT_CODE_ba82dddb":"La construcción de imágenes y la operación de contenedores dependen del software Docker, y todos los nodos remotos en el host físico compartirán todas las imágenes.","TXT_CODE_ba86f4a":"Cuerda elástica MC","TXT_CODE_ba8ebc7":"No puede estar vacío, escriba 0 para representar cada 0 horas","TXT_CODE_baa16e45":"Ampliar ancho","TXT_CODE_bac2d713":"Ya sea para habilitar el modo de depuración","TXT_CODE_bae487e4":"Crear con la imagen Docker","TXT_CODE_baseport_title":"Puerto Base","TXT_CODE_bb0b9711":"Instrucciones de actualización o instalación","TXT_CODE_bb35dc39":"Establecido en verdadero para hacerlo para que los cactus puedan ser bonemeados","TXT_CODE_bb729416":"El retraso que un jugador puede recoger experiencia después de que se caiga","TXT_CODE_bb888626":"producción","TXT_CODE_bb9657ff":"Analizando selectores en libros.","TXT_CODE_bb98d45":"Habilitar la finalización del comando de brigadier","TXT_CODE_bbbda29":"El comando de inicio no puede contener nuevas líneas. Este no es un archivo de secuencia de comandos y no se pueden ejecutar varios comandos.","TXT_CODE_bbd7d448":"Se recomienda que el personal técnico lea información detallada, como imágenes y contenedores de Docker. Aquí se proporciona el contenido completo de la información en formato JSON.","TXT_CODE_bbe23ee7":"Asignaciones de dirección de conexión directa del nodo","TXT_CODE_bbedcf29":"El estado actual de la instancia no permite modificar ningún archivo. \\n¡Vuelva a intentarlo más tarde!","TXT_CODE_bc2e52a0":"Cuando está habilitado, todos los usuarios pueden usar la función \'reinstalar\' en la esquina superior derecha del terminal sin privilegios de administrador.","TXT_CODE_bc3e529c":"Permite un exploit de ruptura permanente de bloques","TXT_CODE_bc46c15b":"Empezar a diseñar","TXT_CODE_bc560b9":"Confirmar la renovación","TXT_CODE_bc883bbb":"Volver a la instalación manual","TXT_CODE_bca67837":"La diferencia entre los valores del servidor y del cliente antes de que se detecte un comportamiento anormal","TXT_CODE_bcfaf14d":"Lo sentimos, no se puede obtener la lista de modpack predeterminado más reciente. Puede haber un problema con su red o el servidor está en mantenimiento.","TXT_CODE_bd0aa3c7":"Establecer en True para hacer que los nombres de visualización de la entidad y lores persistan después de romperse (por ejemplo, los stands de armadura llamado conservan su nombre)","TXT_CODE_bd1ff011":"Ancho temprano de la ventana","TXT_CODE_bd2534da":"Este valor determina qué tan lejos debe estar una entidad del jugador para comenzar a ser afectado por Dear.","TXT_CODE_bd2559f3":"Codificación de entrada de consola","TXT_CODE_bd7152f7":"Ya sea para abrir el final","TXT_CODE_bd84e700":"Establecido en verdadero para permitir que las turbas caminen sobre los rieles","TXT_CODE_bd99b64e":"¡Tiempo de espera agotado! \\nComuníquese con el administrador para verificar el estado de la red del nodo, IP del nodo:","TXT_CODE_bdb620b9":"Correr","TXT_CODE_bdd4fe65":"¿Necesita un paquete de recursos?","TXT_CODE_bddc37e2":"Error al analizar archivo, asegúrese de que es un archivo JSON válido","TXT_CODE_bdfa3457":"El protocolo RCON no se puede habilitar ni deshabilitar en el estado operativo.","TXT_CODE_be1351ce":"¿Cómo conseguir la llave?","TXT_CODE_be1354f5":"Use el modo de diseño para mover el mouse aquí para editar","TXT_CODE_be1f9806":"Escala de control del embudo","TXT_CODE_be236019":"Tasa de crecimiento del grano de cacao","TXT_CODE_be26bb3c":"semilla portal","TXT_CODE_be608c82":"Los diferentes tipos tendrán diferencias sutiles en ciertas funciones.","TXT_CODE_be6484f7":"Por favor seleccione una imagen de instancia","TXT_CODE_be769e64":"Le permite cambiar la cantidad de garrapatas requeridas para que la muerte de una mafia cuente como un jugador matar después de ser lastimado por el jugador (proyectil o directamente)","TXT_CODE_be7a689a":"Debe ser accesible desde el servidor que proporciona este panel. Cuando no es ni una IP/dominio público ni \'localhost\' y estás usando proxy inverso para acceso público, necesitas configurar las asignaciones de conexión directa del nodo para que las funcionalidades relacionadas funcionen correctamente.","TXT_CODE_bea356aa":"Permitir conexiones desde ProxyPass y Waterdog.","TXT_CODE_bea85b64":"Cantidad de garrapatas El jugador brillará después de comer una baya de brillo. \\nEstablecer en 0 para deshabilitar","TXT_CODE_beacbdc":"La velocidad en la que un caldero se llena con nieve en polvo (depende de la garrapata aleatoria)","TXT_CODE_bec3d0ea":"Si se debe salvar el mundo si el servidor falla debido a una excepción no controlada","TXT_CODE_bec552ee":"Salida del marcador de posición <Hours> en el comando.uptime.Format Opción","TXT_CODE_bed32084":"El nodo remoto está fuera de línea, comuníquese con el administrador para verificar el estado en línea del panel.","TXT_CODE_bf6bec1a":"Establecer en falso para no permitir los quioscos de la armadura en agua sobre una cerca","TXT_CODE_bf8ae6c8":"Este archivo de configuración es el EULA (Acuerdo de licencia de usuario final) del servidor de Minecraft. Debe aceptar este acuerdo para ejecutar el software del servidor normalmente. Si encuentra que esta configuración no es \\"Sí\\", modifíquela inmediatamente.","TXT_CODE_bfb50126":"Descripción general del estado del nodo","TXT_CODE_bfbdf579":"Esta característica permite a los usuarios comunes editar la configuración de instancias de Docker, como los comandos \\"Inicio\\" y \\"Actualizar\\"","TXT_CODE_bff43de3":"Nombre","TXT_CODE_c03297d4":"Dirección IP de escucha y puerto de conexión","TXT_CODE_c0401ba7":"Falta archivo de volumen: {{file}}","TXT_CODE_c059faee":"Corregir la finalización de la etiqueta del selector de destino","TXT_CODE_c0606ef4":"¿Está seguro de que desea configurar la imagen de fondo?","TXT_CODE_c093bec9":"Esta operación está en el tiempo de reutilización. \\n¡Puede continuar en aproximadamente {{segundos}} segundos!","TXT_CODE_c0a49b60":"Umbral para movimientos incorrectos","TXT_CODE_c0be39df":"Otro alcance de inicio de entidad","TXT_CODE_c0ce588":"Velocidad de crecimiento de la calabaza","TXT_CODE_c0fcee47":"Establecer en falso para deshabilitar el comercio con comerciantes errantes","TXT_CODE_c10ea805":"Inicio rápido con plantillas","TXT_CODE_c117a10c":"Deshabilitar el efecto de persistencia de creeper","TXT_CODE_c11ac499":"Ingrese una URL de imagen de portada","TXT_CODE_c1320e08":"Puede borrar todos los archivos que cargó a través de \\"Restablecer diseño\\"","TXT_CODE_c132a726":"Las turbas que pueden recoger el botín continuarán recogiendo el botín incluso si el Gamérulo Mobgriefing está discapacitado","TXT_CODE_c135338":"Aviso de patada de vehículo volador","TXT_CODE_c14b2ea3":"devolver","TXT_CODE_c14caab":"No se requieren archivos adicionales","TXT_CODE_c1507dd6":"retraso de advertencia","TXT_CODE_c15dcfec":"Establecer en verdadero para permitir que la piedra de molienda elimine los atributos de un artículo","TXT_CODE_c174fbb4":"Permite daño por aglomeración de jugadores.","TXT_CODE_c17f6488":"Seleccionar archivo zip","TXT_CODE_c1c548fb":"Los siguientes puertos se han abierto para la instancia:","TXT_CODE_c20e5d16":"Mensaje que muestra cuándo la pantalla de créditos está habilitado para un usuario utilizando el comando /credits.","TXT_CODE_c237192c":"Por favor ingrese un nombre para la nueva instancia","TXT_CODE_c24c2569":"La cantidad de segundos que se deben esperar antes de que un usuario autorice a Geyser a acceder a su cuenta de Microsoft.","TXT_CODE_c24fdee3":"Seleccione la codificación de archivo","TXT_CODE_c2697552":"Modificar pista","TXT_CODE_c26e5fb7":"Admite formato de rebajas","TXT_CODE_c2a8378b":"Nombre del mundo (mapa)","TXT_CODE_c2cef2d":"Alcance del lanzamiento del atacante","TXT_CODE_c3022e22":"Este archivo de configuración es un archivo de configuración común para el tipo Bukkit u otros tipos de servidores derivados. Contiene la mayoría de las configuraciones del servidor, como el puerto del servidor, el número máximo de personas, la distancia de visión del jugador y la verificación genuina, etc.","TXT_CODE_c30a5f37":"La altura de esta mafia puede saltar cuando la monta (en bloques)","TXT_CODE_c32bc4b3":"distancia de visión","TXT_CODE_c32eb04a":"¡No cambie esto por ningún motivo! \\nPurpur usa esto internamente para ayudar a actualizar automáticamente su configuración.","TXT_CODE_c38813a8":"Nombre de usuario","TXT_CODE_c3a3b6b1":"Nombre del contenedor","TXT_CODE_c3a933d3":"¡Misión cumplida!","TXT_CODE_c3adc044":"La tarea de carga no existe","TXT_CODE_c3c06801":"Eliminación por lotes exitosa","TXT_CODE_c3ec4dc8":"La barra del hambre de batalla está agotada.","TXT_CODE_c42a1b9b":"Utiliza un enfoque diferente para obtener tiempos de espera de ping Keepalive. \\nHabilitando esto envía un paquete Keepalive una vez por segundo a un jugador, y solo patea para el tiempo de espera si ninguno de ellos fue respondido en 30 segundos. \\nResponder a cualquiera de ellos en cualquier orden mantendrá al jugador conectado. \\nAKA, no pateará a tus jugadores porque un paquete se deja caer en algún lugar de la línea","TXT_CODE_c4430fa6":"Evitar que los usuarios inicien sesión antes de completar su conexión","TXT_CODE_c4435af9":"Configuración de mapeo de puertos de conexión de contenedor","TXT_CODE_c48f6f64":"todo","TXT_CODE_c4dfdb26":"Chino tradicional (BIG5)","TXT_CODE_c4f90da6":"Especificar tareas de tiempo","TXT_CODE_c51b86ff":"Establezca el shulker en un color aleatorio cuando se engendra de una bala","TXT_CODE_c52c93f7":"Si no está habilitado (el valor predeterminado es verdadero), la dirección IP del jugador será reemplazada por <dirección IP retenida> en los registros.","TXT_CODE_c534ca49":"En mantenimiento","TXT_CODE_c535fb8":"Establecer en verdadero si esta mafia siempre debe dejar la experiencia","TXT_CODE_c536b7c7":"Si las llamas de un fantasma pueden quemar artículos","TXT_CODE_c53c342e":"Establezca esto en verdadero para eliminar cualquier entidad (nota: no incluye blockEtities) que arroja un error en su método de tick en lugar de cerrar el servidor e informar un registro de bloqueo. \\nTenga en cuenta que esto podría arruinar todo lo que usa con moderación, no somos responsables de los daños.","TXT_CODE_c565b2e0":"Admite la carga de archivos HTML, esta tarjeta cargará HTML y ejecutará código Javascript.","TXT_CODE_c5687e56":"Usuario <<operator_name>> actualizado el archivo {{archivo}} de la instancia <<instance_name>>","TXT_CODE_c59f077d":"Establecer en falso para permitir establecer un valor negativo de explosiónradio en explosiones","TXT_CODE_c5a46eba":"Descargar Archivo Modificado","TXT_CODE_c5ace40b":"Tipo de Juego","TXT_CODE_c5b38d90":"¡Las especificaciones de la instancia para la renovación no coinciden y la operación de renovación no se puede completar!","TXT_CODE_c5c56801":"Hora de registro","TXT_CODE_c5ed896f":"El contenido de la salida instantánea es demasiado largo y se ha negado a mostrarse...","TXT_CODE_c62a8fa1":"paquete de texturas","TXT_CODE_c62e2f11":"Configure su servidor aquí. \\nCada clave representa el nombre del servidor y el valor representa la dirección IP del servidor al que conectarse.","TXT_CODE_c671927e":"Obligar al cliente a cargar el paquete de recursos del servidor.","TXT_CODE_c684d8b2":"El nombre de usuario existe, ¿es esta tu cuenta?","TXT_CODE_c68b0bef":"¡Descarga de imagen completa!","TXT_CODE_c698246c":"Los muertos vivientes son inmunes a ciertos efectos.","TXT_CODE_c6d3bd8":"MC PIEZO","TXT_CODE_c6ecc182":"Registre los eventos de muerte de la entidad nombrada en el registro","TXT_CODE_c709edac":"Establecer en True For Zombies para evitar el Gamérulo de duelo de la mafia","TXT_CODE_c7362d3d":"Si se debe intentar desactivar la compresión para los reproductores Bedrock Edition.","TXT_CODE_c73de59d":"Martes","TXT_CODE_c745cf56":"Modo de depuración","TXT_CODE_c7952636":"Ítem ​​para tentar/alimentar osos polares y hacerlos reproducirse","TXT_CODE_c7a43089":"La instancia extraerá la imagen en tiempo de ejecución y la usará para crear un contenedor. Este nombre de imagen debe existir en la nube o local.","TXT_CODE_c7b1b8d0":"Programas que deben iniciarse","TXT_CODE_c7d0002e":"dirección IP","TXT_CODE_c7d340bc":"Evite pasar a trozos descargados","TXT_CODE_c800cb31":"Introduzca la ruta del directorio del contenedor. \\nTodos los archivos en el Administrador de archivos se montarán aquí","TXT_CODE_c8261c85":"Servidor de juegos Minecraft Bedrock Edition","TXT_CODE_c82a51b0":"Puede ser un nombre de dominio o una dirección IP, como mcsmanager.com, 43.123.211.12","TXT_CODE_c8333afa":"estado desconocido","TXT_CODE_c83551f5":"Rebautizar","TXT_CODE_c840ab37":"Whitelist of Blocks que el Ravager puede romperse","TXT_CODE_c846074d":"¡Por favor complete la información de su cuenta!","TXT_CODE_c848a459":"Rango de aparición de criaturas","TXT_CODE_c855fc29":"Usuario agregado exitosamente","TXT_CODE_c8572f16":"semillas de iglú","TXT_CODE_c871d8c8":"Establece la distancia máxima entre una entidad biológica y el jugador para las actualizaciones del servidor, en bloques (radio) en cada dirección del jugador. \\nSi las entidades están fuera de este radio, el servidor no las enviará y el jugador no las verá.","TXT_CODE_c8a51b2e":"Por favor introduce la dirección de la imagen.","TXT_CODE_c8c91afc":"Deshabilitar la colocación y el movimiento de mosaicos","TXT_CODE_c8cdeeee":"Versión del archivo de configuración, la modificación puede causar problemas impredecibles. \\nSe recomienda no modificar este proyecto.","TXT_CODE_c91c29cd":"Daño del fuego cuando un fantasma está ardiendo","TXT_CODE_c92156bb":"Hay un problema con el plan establecido por el proveedor de servicios. \\n¡Póngase en contacto con el proveedor para reconfigurar el plan!","TXT_CODE_c93f32f8":"Requerido, admite nombre de dominio y dirección IP. Si no se completa, no se consultará la información del servidor, número de personas, versión, etc.","TXT_CODE_c9609785":"condición","TXT_CODE_c97dd046":"Cuando está habilitado, los cofres de Ender deben tener seis filas de espacio de inventario","TXT_CODE_c9b31f8e":"Jueves","TXT_CODE_c9c27711":"Si se debe ignorar la metralla de bala de cristal para calcular el umbral del proyectil","TXT_CODE_c9ce7427":"Puede filtrar juegos a través del menú desplegable, seleccionar una plantilla y continuar con la instalación. \\nAsegúrese de que el sistema tenga el entorno de tiempo de ejecución requerido para el juego.","TXT_CODE_c9d34339":"Establecido en falso para los botes para no hacer daño a los jugadores","TXT_CODE_c9e4d5c1":"Evita que aparezcan guardias de mazmorra al enviar jugadores a su punto de generación","TXT_CODE_c9f303dd":"Atributo de salud mínimo","TXT_CODE_ca030197":"La instancia tiene otras tareas en progreso y esta operación no se puede realizar.","TXT_CODE_ca06ec2a":"La entidad selecciona el objetivo según el siguiente rango","TXT_CODE_ca07c84c":"Su navegador actual no admite la copia automática","TXT_CODE_ca500df8":"Este archivo de configuración es un archivo de configuración común para servidores de la categoría papel u otras categorías derivadas. Amplía las deficiencias del archivo de configuración spigot.","TXT_CODE_ca8072bd":"La inicialización falló, ¡el nodo remoto no existe!","TXT_CODE_caaac421":"Importar desde portapapeles","TXT_CODE_cacd8840":"Error descompresión 7zip: {{message}}","TXT_CODE_cad62df3":"Solo almacene el caché del usuario cuando el servidor esté inactivo","TXT_CODE_cae10a08":"Se inicia la tarea de eliminación de archivos. Si hay demasiados archivos, llevará algún tiempo.","TXT_CODE_caf10268":"Si el servidor devuelve una lista de complementos al consultar la consola integrada MCSM","TXT_CODE_caf8ebb7":"Venta de llave de tarjeta","TXT_CODE_cafe41ab":"Tiempo de inactividad permitido, en minutos. Expulsar automáticamente del servidor después de exceder el límite.","TXT_CODE_cb043d10":"Ejemplo","TXT_CODE_cb08d342":"El campo no puede estar vacío","TXT_CODE_cb1fef78":"Todos los jugadores deben registrarse o iniciar sesión antes de jugar.","TXT_CODE_cb36c80e":"Lista de contenedores de host remoto","TXT_CODE_cb61062d":"No se puede ver","TXT_CODE_cb84b22":"Esta tarjeta puede cargar páginas HTML personalizadas y ejecutar scripts Javascript directamente. Puede utilizar directamente todos los elementos de la página web y es adecuada para desarrolladores de aplicaciones web.","TXT_CODE_cbb958f2":"Si está activado, los jugadores sin una clave pública de firma de Mojang no podrán conectarse al servidor.","TXT_CODE_cbbc779f":"Después de completar el nombre del archivo del software del servidor, vaya a Administración de archivos para cargar el software del servidor e iniciar la instancia.","TXT_CODE_cbc235ad":"Borrando los archivos existentes de la instancia, espere pacientemente...","TXT_CODE_cbe0fc07":"La barra del hambre restaurada está agotada.","TXT_CODE_cc446b0c":"Radio que los fantasmas escanean cristales a órbita. \\nValor de 0 Desactiva la función","TXT_CODE_cc561947":"Escanee el código QR utilizando la autenticación de Google u otra herramienta común de verificación en dos pasos.","TXT_CODE_cc5a3aea":"La longitud de la contraseña no puede ser inferior a 9 caracteres.","TXT_CODE_cc6ecb18":"El número máximo de monstruos despertados por tick.","TXT_CODE_cc732bf6":"Ingrese el comando de detención","TXT_CODE_cc7b54b9":"Ajustes básicos","TXT_CODE_ccb60658":"Verificar","TXT_CODE_ccc0fec7":"Establecer en falso para deshabilitar la función de caravana de Llama (https://minecraft.wiki/w/llama","TXT_CODE_cd045236":"Tasa de crecimiento de las bayas dulces","TXT_CODE_cd1f9ef7":"Puerto de escucha de nodo","TXT_CODE_cd3ae89e":"Mostrar mensaje de guardado automático de copia de seguridad","TXT_CODE_cd40249d":"Número de subprocesos principales de ejecución de chat","TXT_CODE_cd5df11b":"Configure el mapeo de puertos","TXT_CODE_cd62c9d4":"Evite que se generen o recuperen elementos prohibidos mediante comandos","TXT_CODE_cd76bc9":"Usuario <<operator_name>> eliminó el usuario <<target_user_name>>","TXT_CODE_cd8cd5d2":"Esta tarjeta solo se puede colocar en páginas con permisos superiores.","TXT_CODE_cd923ade":"Finalmente, ¿es la primera vez que utilizas este software?","TXT_CODE_cd978243":"Administrador","TXT_CODE_cdb213a3":"Lista de elementos que son inmunes a las explosiones","TXT_CODE_cdbd12d2":"Tiempo de fuego fantasma","TXT_CODE_cdd555be":"Ajustes básicos","TXT_CODE_cdf1a25":"¿Qué color debería mostrar cuando el uso de RAM es \'bajo\'?","TXT_CODE_cdf7c16a":"Solo los administradores pueden ver y cambiar esta configuración","TXT_CODE_ce132192":"Buscar por nombre de la aplicación","TXT_CODE_ce4a3230":"Salud máxima de la mafia","TXT_CODE_ce8f3dc1":"Si se debe habilitar el protocolo PROXY para el cliente. \\nNo desea habilitar esto a menos que esté realizando un proxy inverso UDP frente a su instancia de Geyser.","TXT_CODE_ce917b27":"¡Ya terminaste! \\nA continuación, solo necesita ingresar a la \\"Consola de instancia\\" y tocar \\"Iniciar instancia\\".","TXT_CODE_ce953a4":"Desactivar PrimeBombs","TXT_CODE_ce99026b":"Almacene registros en una base de datos SQL en lugar de archivos de texto. \\nFalso predeterminado","TXT_CODE_cea5dba1":"El programa ha recibido una señal de salida y se prepara para cerrar...","TXT_CODE_ceb783a9":"La gestión de archivos es una función que consume más recursos y es difícil de controlar.","TXT_CODE_ceba9262":"Si es un usuario habitual, póngase en contacto con el administrador del panel.","TXT_CODE_cec321b4":"Codificación de salida:","TXT_CODE_cee5802c":"tiempo de eclosión","TXT_CODE_cf1cb995":"Especifica la cantidad de segundos para almacenar en caché las imágenes en el disco para evitar descargarlas de la red. \\n0 significa deshabilitado.","TXT_CODE_cf27ab7e":"Por favor ingrese un nombre","TXT_CODE_cf393058":"Una opción de configuración principalmente para desarrolladores. \\nIniciar sesión etiquetas de elementos modificados que no tienen traducciones cuando se ejecutan en el servidor integrado. \\nEl formato deseado es TAG.Item. <pace>. <lation> para la clave de traducción. \\nPredeterminado se silenció. \\nValores permitidos: silenciado, dev_short, dev_verbose, prod_short, prod_verbose","TXT_CODE_cf88c936":"puerto abierto","TXT_CODE_cf95364f":"Esta característica tiene cierta inestabilidad y no puede garantizar que la experiencia del usuario de la interfaz siga siendo óptima.","TXT_CODE_cf9e259c":"Mostrar hora actual","TXT_CODE_cfc657db":"contenido","TXT_CODE_cfd64e73":"Nombre de grupo predeterminado para jugadores recién registrados","TXT_CODE_cfe187b0":"Este valor define cuánta distancia modifica la frecuencia de tic de una entidad.","TXT_CODE_cff4286":"Porcentaje de probabilidad (0.0-1.0) para generar naturalmente un conejo llamado Toast","TXT_CODE_command.errLen":"Longitud de comando incorrecta; asegúrese de que el formato del comando sea correcto","TXT_CODE_command.instanceNotOpen":"La ejecución de la instrucción falló porque el programa real de la instancia no existe","TXT_CODE_command.quotes":"Comillas dobles de comando incorrectas, no se pueden encontrar un par de comillas dobles. Si necesita usar una comilla doble simple, use el símbolo {comillas}","TXT_CODE_common._7unzip":"[Tarea de descompresión 7zip]","TXT_CODE_common._7zip":"[Tarea de compresión 7zip]","TXT_CODE_common.killProcess":"El programa {{pid}} ha sido finalizado por la fuerza mediante un comando del sistema","TXT_CODE_common.title":"Título","TXT_CODE_common.uuidIrregular":"UUID {{uuid}} es incorrecto","TXT_CODE_d00c21bb":"Tipo de generación de mapa (predeterminado: predeterminado, súper plano: plano)","TXT_CODE_d01532d":"Cantidad de daño hecho mientras se ahoga","TXT_CODE_d03c3e0e":"Archivo de configuración original de Bukkit","TXT_CODE_d043fe18":"Escribir disco","TXT_CODE_d07742fe":"Archivo de configuración del servidor","TXT_CODE_d080f2d7":"Recargar","TXT_CODE_d092c3b":"Sólo los jugadores incondicionales pueden conectarse","TXT_CODE_d0b40386":"Nombre de la base de datos MySQL","TXT_CODE_d0c670df":"El progreso del panel de gestión de MCSManager es inseparable de la dedicación desinteresada de los contribuyentes y patrocinadores.","TXT_CODE_d0c78699":"Mensaje de servidor de autenticación no disponible","TXT_CODE_d0d08d6":"ej: 123MB","TXT_CODE_d0e37f20":"Habilitar lista blanca","TXT_CODE_d0e78c58":"Casualidad","TXT_CODE_d0fd83bf":"Restricciones de chat","TXT_CODE_d11bf156":"Tenga paciencia y utilice la función de actualización para cargar la lista; se espera que esta imagen se elimine más adelante","TXT_CODE_d11cc3e1":"Si se debe habilitar el soporte para HAProxy","TXT_CODE_d12fa808":"Comando de inicio","TXT_CODE_d149e3e6":"Permite que los dispensadores colocen los yunques","TXT_CODE_d1509da0":"El radio de explosión de la explosión. \\n(Para comparación, TNT es 4.0 y las enredaderas cargadas son 6.0)","TXT_CODE_d15dc89c":"La cantidad de bloques que un pistón puede empujar","TXT_CODE_d16d82ab":"Si el contenido de la consola es confuso, puedes intentar modificar la codificación para resolver el problema.","TXT_CODE_d182c422":"¿En qué máquina se implementará el nuevo programa?","TXT_CODE_d1c78fbf":"El nombre utilizado para crear el contenedor se genera aleatoriamente si está vacío.","TXT_CODE_d23631cb":"Configuración de la consola","TXT_CODE_d245f00d":"Establecido en verdadero para eliminar la desaceleración de la oxidación causada por bloques de cobre no oxidados cercanos","TXT_CODE_d248b5c8":"Sábado","TXT_CODE_d258ec31":"Borrar todas las selecciones","TXT_CODE_d28c05df":"Establecido con éxito","TXT_CODE_d29be029":"Establecido en verdadero para permitir que las esponjas absorban el agua de los bloques de lodo que las conviertan en tierra","TXT_CODE_d29c8730":"¿Deberían pasarse las solicitudes de ping de la lista de servidores a los servidores backend?","TXT_CODE_d2bbb2f1":"Grupo funcional de instancia","TXT_CODE_d2c1a316":"Acceso","TXT_CODE_d2c79249":"Si está dispuesto a apoyar el desarrollo posterior de MCSManager,","TXT_CODE_d2e3b565":"Saltar potencia al presionar la barra espaciadora en un MineCart controlable","TXT_CODE_d31196db":"Consola de comerciante","TXT_CODE_d31a684c":"Hora de inicio:","TXT_CODE_d32301c1":"Puertos de conexión disponibles","TXT_CODE_d324bb21":"Dirección de acceso:","TXT_CODE_d33e975f":"Establezca en falso para evitar que el servidor patee a un jugador para que su chat esté fuera de servicio","TXT_CODE_d341127b":"tareas de eventos","TXT_CODE_d356cf9d":"ancho de contracción","TXT_CODE_d372d72":"Intente pasar automáticamente hacia adelante usando UPNP cuando el servidor se inicia","TXT_CODE_d37f0418":"¡El panel ha sido instalado!","TXT_CODE_d3b29478":"tiempo de modificación","TXT_CODE_d3d88894":"La cantidad de regen de la marchitez","TXT_CODE_d3ddefb5":"La cantidad de experiencia apunta a usar desde la barra del jugador para reparar artículos encantados con reparación en el inventario del jugador","TXT_CODE_d3de39b4":"actualización completada","TXT_CODE_d4146944":"Volver a la página de inicio del panel","TXT_CODE_d42566ff":"Un mensaje de chat que muestra el uso de RAM cuando alguien usa el comando /RAM.","TXT_CODE_d4517dcb":"Viernes","TXT_CODE_d47ff7e5":"Porcentaje de posibilidades (0.0 - 1.0) que TNT cebado con clic derecho lo calmará","TXT_CODE_d486a561":"describir:","TXT_CODE_d4ad1dd":"Opcional. \\nUtiliza el comando predeterminado de imagen si está vacío; de lo contrario, ejecuta el comando especificado","TXT_CODE_d4b058a9":"Está prohibido utilizar proyectiles Zenith con objetos distintos a las armas.","TXT_CODE_d4b35741":"Umbral de dirección de movimiento del jugador","TXT_CODE_d